# moonstream db

### Setting up moonstreamdb

Copy `sample.env` to a new file and set the environment variables to appropriate values. This new file
should be sourced every time you want to access the database with the `moonstreamdb` application or any
dependents.

To be able to run migrations, copy [`alembic.sample.ini`](./alembic.sample.ini) to a separate file
(e.g. `./secrets/alembic.dev.ini`) and modify the `sqlalchemy.url` setting in the new file to point
at your database.

Make sure your database is at the latest alembic migration:

```bash
alembic -c ./secrets/alembic.dev.ini upgrade head
```

### Adding a new table to database

Add SQLAlchemy model in [`moonstreamdb/models.py`](./moonstreamdb/models.py)

Import new model and add tablename to whitelist in [`alembic/env.py`](.alembic/env.py)

Create a migration:

```bash
alembic -c <alembic config file> revision -m "<revision message>" --autogenerate
```

Always check the autogenerated file to make sure that it isn't performing any actions that you don't want it to.
A good policy is to delete any operations that don't touch the tables that you created.

Then run the migration:

```bash
alembic -c <alembic config file> upgrade head
```
