/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import net.sf.varscan.CallMpileup;
import net.sf.varscan.CallPileup;
import net.sf.varscan.Comparison;
import net.sf.varscan.CopyCaller;
import net.sf.varscan.Copynumber;
import net.sf.varscan.Coverage;
import net.sf.varscan.FilterSomatic;
import net.sf.varscan.FilterVariants;
import net.sf.varscan.FishersExact;
import net.sf.varscan.FpFilter;
import net.sf.varscan.LimitVariants;
import net.sf.varscan.ProcessSomatic;
import net.sf.varscan.ReadCounts;
import net.sf.varscan.Somatic;
import net.sf.varscan.Trio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarScan {
    static final double MIN_FREQ_FOR_HOM = 0.7;

    public static void main(String[] args) {
        String usage = "VarScan v2.3\n\nUSAGE: java -jar VarScan.jar [COMMAND] [OPTIONS] \n\n";
        usage = String.valueOf(usage) + "COMMANDS:\n" + "\tpileup2snp\t\tIdentify SNPs from a pileup file\n" + "\tpileup2indel\t\tIdentify indels a pileup file\n" + "\tpileup2cns\t\tCall consensus and variants from a pileup file\n" + "\tmpileup2snp\t\tIdentify SNPs from an mpileup file\n" + "\tmpileup2indel\t\tIdentify indels an mpileup file\n" + "\tmpileup2cns\t\tCall consensus and variants from an mpileup file\n\n" + "\tsomatic\t\t\tCall germline/somatic variants from tumor-normal pileups\n" + "\tcopynumber\t\t\tDetermine relative tumor copy number from tumor-normal pileups\n" + "\treadcounts\t\tObtain read counts for a list of variants from a pileup file\n\n" + "\tfilter\t\t\tFilter SNPs by coverage, frequency, p-value, etc.\n" + "\tsomaticFilter\t\tFilter somatic variants for clusters/indels\n" + "\tfpfilter\t\tApply the false-positive filter\n\n" + "\tprocessSomatic\t\tIsolate Germline/LOH/Somatic calls from output\n" + "\tcopyCaller\t\tGC-adjust and process copy number changes from VarScan copynumber output\n" + "\tcompare\t\t\tCompare two lists of positions/variants\n" + "\tlimit\t\t\tRestrict pileup/snps/indels to ROI positions\n" + "\n";
        if (args.length > 0) {
            HashMap params = VarScan.getParams(args);
            if (args[0].equals("pileup2snp")) {
                VarScan.pileup2call(args, params, "SNP");
            } else if (args[0].equals("pileup2indel")) {
                VarScan.pileup2call(args, params, "INDEL");
            } else if (args[0].equals("pileup2cns")) {
                VarScan.pileup2call(args, params, "CNS");
            } else if (args[0].equals("mpileup2snp") || args[0].equals("mpileup2indel") || args[0].equals("mpileup2cns") || args[0].equals("mpileup2vcf")) {
                VarScan.mpileup2call(args, params, "CNS");
            } else if (args[0].equals("filter")) {
                VarScan.filter(args, params);
            } else if (args[0].equals("somaticFilter")) {
                VarScan.somaticFilter(args, params);
            } else if (args[0].equals("fpfilter")) {
                VarScan.fpfilter(args, params);
            } else if (args[0].equals("processSomatic")) {
                VarScan.processSomatic(args, params);
            } else if (args[0].equals("copyCaller")) {
                VarScan.copyCaller(args, params);
            } else if (args[0].equals("compare")) {
                VarScan.compare(args, params);
            } else if (args[0].equals("readcounts")) {
                VarScan.readcounts(args, params);
            } else if (args[0].equals("somatic")) {
                VarScan.somatic(args, params);
            } else if (args[0].equals("trio")) {
                VarScan.trio(args, params, "CNS");
            } else if (args[0].equals("copynumber")) {
                VarScan.copynumber(args, params);
            } else if (args[0].equals("limit")) {
                VarScan.limit(args, params);
            } else if (args[0].equals("coverage")) {
                VarScan.coverage(args, params);
            } else if (args[0].equals("test")) {
                System.err.println("Testing...");
                try {
                    RandomAccessFile ref = new RandomAccessFile("test.fasta", "r");
                    ref.seek(52L);
                    byte[] buffer = new byte[5];
                    ref.read(buffer);
                    String thisBase = new String(buffer);
                    System.err.println("Got " + thisBase);
                }
                catch (Exception e) {
                    System.err.println("Error: Reference file: " + e.getLocalizedMessage());
                }
            } else {
                System.err.println("Command not recognized\n" + usage);
            }
        } else {
            System.err.println(usage);
        }
    }

    public static void pileup2call(String[] args, HashMap<String, String> params, String callType) {
        CallPileup pileupCall = new CallPileup(args, callType);
    }

    public static void mpileup2call(String[] args, HashMap<String, String> params, String callType) {
        CallMpileup mpileupCall = new CallMpileup(args, callType);
    }

    public static void readcounts(String[] args, HashMap<String, String> params) {
        ReadCounts myReadCounts = new ReadCounts(args, params);
    }

    public static void somatic(String[] args, HashMap<String, String> params) {
        if (params.containsKey("mpileup")) {
            Somatic mySomatic = new Somatic(args, true);
        } else {
            Somatic somatic = new Somatic(args);
        }
    }

    public static void trio(String[] args, HashMap<String, String> params, String callType) {
        Trio myTrio = new Trio(args, callType);
    }

    public static void copynumber(String[] args, HashMap<String, String> params) {
        if (params.containsKey("mpileup")) {
            Copynumber myCopynumber = new Copynumber(args, true);
        } else {
            Copynumber copynumber = new Copynumber(args);
        }
    }

    public static void filter(String[] args, HashMap<String, String> params) {
        FilterVariants myFilter = new FilterVariants(args);
    }

    public static void fpfilter(String[] args, HashMap<String, String> params) {
        FpFilter myFilter = new FpFilter(args);
    }

    public static void somaticFilter(String[] args, HashMap<String, String> params) {
        FilterSomatic myFilter = new FilterSomatic(args);
    }

    public static void processSomatic(String[] args, HashMap<String, String> params) {
        ProcessSomatic myProcess = new ProcessSomatic(args);
    }

    public static void copyCaller(String[] args, HashMap<String, String> params) {
        CopyCaller myCopy = new CopyCaller(args, params);
    }

    public static void compare(String[] args, HashMap<String, String> params) {
        Comparison myComparison = new Comparison(args);
    }

    public static void limit(String[] args, HashMap<String, String> params) {
        LimitVariants myLimit = new LimitVariants(args);
    }

    public static void coverage(String[] args, HashMap<String, String> params) {
        Coverage myCoverage = new Coverage(args);
    }

    static HashMap getParams(String[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        String arg = "";
        String value = "";
        int i = 0;
        int j = 0;
        while (i < args.length) {
            j = i + 1;
            arg = args[i];
            if (arg.startsWith("-")) {
                while (arg.startsWith("-")) {
                    arg = arg.replaceFirst("-", "");
                }
                if (i < args.length && j < args.length && !args[j].startsWith("-")) {
                    value = args[j];
                    params.put(arg, value);
                } else {
                    params.put(arg, "true");
                }
            }
            ++i;
        }
        return params;
    }

    static BufferedReader getInfile(String[] args) {
        BufferedReader in = null;
        try {
            File infile;
            if (args.length > 1 && !args[1].startsWith("-") && (infile = new File(args[1])).exists()) {
                System.err.println("Reading input from " + args[1]);
                in = new BufferedReader(new FileReader(args[1]));
            }
            if (in == null) {
                InputStreamReader instream = new InputStreamReader(System.in);
                Thread.sleep(1000L);
                int num_naps = 0;
                while (!instream.ready()) {
                    System.err.println("Input stream not ready, waiting for 5 seconds...");
                    Thread.sleep(5000L);
                    if (++num_naps < 100) continue;
                    System.err.println("ERROR: Gave up waiting after 500 seconds...\n");
                    System.exit(10);
                }
                if (instream.ready()) {
                    System.err.println("Reading input from STDIN");
                    in = new BufferedReader(instream);
                }
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: Unable to open input stream\n");
            System.exit(10);
        }
        return in;
    }

    /*
     * Unable to fully structure code
     */
    static HashMap<String, String> getReadCounts(String refBase, String readBases, String readQuals, int minAvgQual, String mapQuals) {
        readCounts = new HashMap<String, Integer>();
        readCountsPlus = new HashMap<String, Integer>();
        readCountsMinus = new HashMap<String, Integer>();
        qualitySum = new HashMap<String, Integer>();
        mapQualitySum = new HashMap<String, Integer>();
        strandsSeen = new HashMap<String, String>();
        reads1 = 0;
        reads1indel = 0;
        readBase = "";
        prevBase = "";
        nextBase = "";
        baseQuality = 0;
        prevBaseQuality = 0;
        mapQuality = 1;
        strand = "";
        arrBases = readBases.split("");
        arrQualities = readQuals.toCharArray();
        mapQualities = mapQuals.toCharArray();
        readStart = false;
        j = 0;
        i = 0;
        while (i < arrBases.length) {
            readBase = arrBases[i];
            if (i == 0 && readBase.length() == 0) {
                readBase = arrBases[++i];
            }
            prevBase = "";
            if (i > 1 && i < arrBases.length - 1) {
                prevBase = arrBases[i - 1];
            }
            if (j > 1 && j < arrQualities.length - 1) {
                prevBaseQuality = arrQualities[j - 1] - 33;
            }
            nextBase = "";
            if (i < arrBases.length - 1) {
                nextBase = arrBases[i + 1];
            }
            if (j < arrQualities.length) {
                baseQuality = arrQualities[j] - 33;
            }
            if (j < mapQualities.length) {
                mapQuality = mapQualities[j] - 33;
            }
            if ((readBase.equals(".") || readBase.equals(",")) && !nextBase.equals("-") && !nextBase.equals("+")) {
                strand = "+";
                if (readBase.equals(",")) {
                    strand = "-";
                }
                if (baseQuality >= minAvgQual) {
                    ++reads1;
                    if (strandsSeen.containsKey("ref")) {
                        alreadySeen = (String)strandsSeen.get("ref");
                        if (alreadySeen.length() < 2 && !alreadySeen.equals(strand)) {
                            strandsSeen.put("ref", String.valueOf((String)strandsSeen.get("ref")) + strand);
                        }
                    } else {
                        strandsSeen.put("ref", strand);
                    }
                    if (strand.equals("+")) {
                        if (readCountsPlus.containsKey("ref")) {
                            readCountsPlus.put("ref", (Integer)readCountsPlus.get("ref") + 1);
                        } else {
                            readCountsPlus.put("ref", 1);
                        }
                    } else if (readCountsMinus.containsKey("ref")) {
                        readCountsMinus.put("ref", (Integer)readCountsMinus.get("ref") + 1);
                    } else {
                        readCountsMinus.put("ref", 1);
                    }
                    if (qualitySum.containsKey("ref")) {
                        qualitySum.put("ref", (Integer)qualitySum.get("ref") + baseQuality);
                        mapQualitySum.put("ref", (Integer)mapQualitySum.get("ref") + mapQuality);
                    } else {
                        qualitySum.put("ref", baseQuality);
                        mapQualitySum.put("ref", mapQuality);
                    }
                }
                ++j;
                readStart = false;
            } else if (readBase.toUpperCase().equals("A") || readBase.toUpperCase().equals("C") || readBase.toUpperCase().equals("G") || readBase.toUpperCase().equals("T")) {
                strand = "+";
                if (readBase.equals("a") || readBase.equals("c") || readBase.equals("g") || readBase.equals("t")) {
                    strand = "-";
                }
                readBase = readBase.toUpperCase();
                if (baseQuality >= minAvgQual) {
                    if (readCounts.containsKey(readBase)) {
                        readCounts.put(readBase, (Integer)readCounts.get(readBase) + 1);
                    } else {
                        readCounts.put(readBase, 1);
                    }
                    if (strand.equals("+")) {
                        if (readCountsPlus.containsKey(readBase)) {
                            readCountsPlus.put(readBase, (Integer)readCountsPlus.get(readBase) + 1);
                        } else {
                            readCountsPlus.put(readBase, 1);
                        }
                    } else if (readCountsMinus.containsKey(readBase)) {
                        readCountsMinus.put(readBase, (Integer)readCountsMinus.get(readBase) + 1);
                    } else {
                        readCountsMinus.put(readBase, 1);
                    }
                    if (strandsSeen.containsKey(readBase)) {
                        alreadySeen = (String)strandsSeen.get(readBase);
                        if (alreadySeen.length() < 2 && !alreadySeen.equals(strand)) {
                            strandsSeen.put(readBase, String.valueOf((String)strandsSeen.get(readBase)) + strand);
                        }
                    } else {
                        strandsSeen.put(readBase, strand);
                    }
                    if (qualitySum.containsKey(readBase)) {
                        qualitySum.put(readBase, (Integer)qualitySum.get(readBase) + baseQuality);
                        mapQualitySum.put(readBase, (Integer)mapQualitySum.get(readBase) + mapQuality);
                    } else {
                        qualitySum.put(readBase, baseQuality);
                        mapQualitySum.put(readBase, mapQuality);
                    }
                }
                ++j;
                readStart = false;
            } else if (readBase.equals("+") || readBase.equals("-")) {
                block83: {
                    indelType = "";
                    indelType = readBase.equals("+") != false ? "INS" : "DEL";
                    if ((prevBase.equals(".") || prevBase.equals(",")) && prevBaseQuality >= minAvgQual) {
                        ++reads1indel;
                    }
                    indel_size = 0;
                    max_parse = 1;
                    indelBases = "";
                    try {
                        stringWithSize = String.valueOf(arrBases[i + 1]) + arrBases[i + 2] + arrBases[i + 3];
                        stringWithSize = stringWithSize.replaceAll("[^0-9]", "");
                        indel_size = Integer.parseInt(stringWithSize);
                        max_parse = indel_size + Integer.toString(indel_size).length();
                        bases_parsed = 0;
                        while (bases_parsed < max_parse) {
                            block82: {
                                thisBase = arrBases[i + 1 + bases_parsed];
                                try {
                                    Integer.parseInt(thisBase);
                                }
                                catch (Exception e) {
                                    if (thisBase.equals(".") || thisBase.equals(",")) {
                                        bases_parsed = max_parse;
                                    }
                                    if (!thisBase.toUpperCase().equals("A") && !thisBase.toUpperCase().equals("C") && !thisBase.toUpperCase().equals("G") && !thisBase.toUpperCase().equals("T") && !thisBase.toUpperCase().equals("N")) break block82;
                                    indelBases = String.valueOf(indelBases) + thisBase;
                                }
                            }
                            ++bases_parsed;
                        }
                        i += max_parse;
                        break block83;
                    }
                    catch (Exception e) {
                        indel_size = Integer.parseInt(arrBases[i + 1]);
                        bases_parsed = 0;
                        ** while (bases_parsed < indel_size)
                    }
lbl-1000:
                    // 1 sources

                    {
                        indelBases = String.valueOf(indelBases) + arrBases[i + 2 + bases_parsed];
                        ++bases_parsed;
                        continue;
                    }
lbl164:
                    // 1 sources

                    i = i + 1 + indel_size;
                }
                strand = indelBases.equals(indelBases.toUpperCase()) != false ? "+" : "-";
                indelBases = indelBases.toUpperCase();
                indelKey = String.valueOf(indelType) + "-" + indel_size + "-" + indelBases;
                if (readCounts.containsKey(indelKey)) {
                    readCounts.put(indelKey, (Integer)readCounts.get(indelKey) + 1);
                } else {
                    readCounts.put(indelKey, 1);
                }
                if (strand.equals("+")) {
                    if (readCountsPlus.containsKey(indelKey)) {
                        readCountsPlus.put(indelKey, (Integer)readCountsPlus.get(indelKey) + 1);
                    } else {
                        readCountsPlus.put(indelKey, 1);
                    }
                } else if (readCountsMinus.containsKey(indelKey)) {
                    readCountsMinus.put(indelKey, (Integer)readCountsMinus.get(indelKey) + 1);
                } else {
                    readCountsMinus.put(indelKey, 1);
                }
                if (strandsSeen.containsKey(indelKey)) {
                    alreadySeen = (String)strandsSeen.get(indelKey);
                    if (alreadySeen.length() < 2 && !alreadySeen.equals(strand)) {
                        strandsSeen.put(indelKey, String.valueOf((String)strandsSeen.get(indelKey)) + strand);
                    }
                } else {
                    strandsSeen.put(indelKey, strand);
                }
                if (j < arrQualities.length) {
                    baseQuality = arrQualities[j] - 33;
                    ++j;
                }
                if (j < mapQualities.length) {
                    mapQuality = mapQualities[j] - 33;
                }
                if (qualitySum.containsKey(indelKey)) {
                    qualitySum.put(indelKey, (Integer)qualitySum.get(indelKey) + baseQuality);
                    mapQualitySum.put(indelKey, (Integer)mapQualitySum.get(indelKey) + mapQuality);
                } else {
                    qualitySum.put(indelKey, baseQuality);
                    mapQualitySum.put(indelKey, mapQuality);
                }
                readStart = false;
            } else if (readBase.toUpperCase().equals("N")) {
                ++j;
            } else if (readBase.equals("^")) {
                ++i;
                readStart = true;
            } else if (readBase.equals("$")) {
                readStart = false;
            } else if (!readBase.equals(".") && !readBase.equals(",")) {
                ++j;
            }
            ++i;
        }
        results = new HashMap<String, String>();
        strands1 = 0;
        if (strandsSeen.containsKey("ref")) {
            strands1 = ((String)strandsSeen.get("ref")).length();
        }
        avgQual1 = 0;
        if (reads1 > 0) {
            avgQual1 = (Integer)qualitySum.get("ref") / reads1;
        }
        avgMapQual1 = 0;
        if (reads1 > 0) {
            avgMapQual1 = (Integer)mapQualitySum.get("ref") / reads1;
        }
        reads1plus = 0;
        reads1minus = 0;
        if (readCountsPlus.containsKey("ref")) {
            reads1plus = (Integer)readCountsPlus.get("ref");
        }
        if (readCountsMinus.containsKey("ref")) {
            reads1minus = (Integer)readCountsMinus.get("ref");
        }
        if (reads1 < 0) {
            reads1 = 0;
        }
        results.put(refBase, String.valueOf(reads1) + "\t" + strands1 + "\t" + avgQual1 + "\t" + avgMapQual1 + "\t" + reads1plus + "\t" + reads1minus + "\t" + reads1indel);
        variantKeys = readCounts.keySet().toArray(new String[0]);
        Arrays.sort(variantKeys);
        var35_42 = variantKeys;
        var34_43 = variantKeys.length;
        var33_41 = 0;
        while (var33_41 < var34_43) {
            key = var35_42[var33_41];
            reads2 = (Integer)readCounts.get(key);
            reads2plus = 0;
            reads2minus = 0;
            if (readCountsPlus.containsKey(key)) {
                reads2plus = (Integer)readCountsPlus.get(key);
            }
            if (readCountsMinus.containsKey(key)) {
                reads2minus = (Integer)readCountsMinus.get(key);
            }
            strands2 = 0;
            if (strandsSeen.containsKey(key)) {
                strands2 = ((String)strandsSeen.get(key)).length();
            }
            avg_qual2 = (Integer)qualitySum.get(key) / reads2;
            avg_map_qual2 = (Integer)mapQualitySum.get(key) / reads2;
            if (reads2 > 0) {
                results.put((String)key, String.valueOf(reads2) + "\t" + strands2 + "\t" + avg_qual2 + "\t" + avg_map_qual2 + "\t" + reads2plus + "\t" + reads2minus);
            }
            ++var33_41;
        }
        return results;
    }

    static int qualityDepth(String readQuals, int minAvgQual) {
        int baseQuality = 0;
        int qualityDepth = 0;
        char[] arrQualities = readQuals.toCharArray();
        int j = 0;
        j = 0;
        while (j < arrQualities.length) {
            baseQuality = arrQualities[j] - 33;
            if (baseQuality >= minAvgQual) {
                ++qualityDepth;
            }
            ++j;
        }
        return qualityDepth;
    }

    static String callPosition(String refBase, HashMap<String, String> readCounts, String callType, int minReads2, double minVarFreq, int minAvgQual, double pValueThreshold, double minFreqForHom) {
        String callResult = "";
        DecimalFormat df = new DecimalFormat("###.##");
        int reads1 = 0;
        int reads2 = 0;
        int readsWithIndels = 0;
        int strands1 = 0;
        int strands2 = 0;
        int avgQual1 = 0;
        int avgQual2 = 0;
        int avgMap1 = 0;
        int avgMap2 = 0;
        int reads1indel = 0;
        int reads1plus = 0;
        int reads1minus = 0;
        int reads2plus = 0;
        int reads2minus = 0;
        double pValue = 1.0;
        double varFreq = 0.0;
        Object varAllele = "";
        try {
            String[] alleleContents;
            Object allele;
            if (readCounts.containsKey(refBase)) {
                try {
                    String[] refBaseContents = readCounts.get(refBase).split("\t");
                    reads1 = Integer.parseInt(refBaseContents[0]);
                    strands1 = Integer.parseInt(refBaseContents[1]);
                    avgQual1 = Integer.parseInt(refBaseContents[2]);
                    avgMap1 = Integer.parseInt(refBaseContents[3]);
                    reads1plus = Integer.parseInt(refBaseContents[4]);
                    reads1minus = Integer.parseInt(refBaseContents[5]);
                    if (refBaseContents.length > 6) {
                        reads1indel = Integer.parseInt(refBaseContents[6]);
                    }
                }
                catch (Exception e) {
                    System.err.println("Error parsing refBase readcounts from " + readCounts.get(refBase));
                }
            }
            Object[] alleleKeys = readCounts.keySet().toArray(new String[0]);
            Arrays.sort(alleleKeys);
            int totalReadCounts = 0;
            Object[] objectArray = alleleKeys;
            int n = alleleKeys.length;
            int n2 = 0;
            while (n2 < n) {
                allele = objectArray[n2];
                alleleContents = readCounts.get(allele).split("\t");
                try {
                    int thisReads = Integer.parseInt(alleleContents[0]);
                    totalReadCounts += thisReads;
                }
                catch (Exception thisReads) {
                    // empty catch block
                }
                ++n2;
            }
            objectArray = alleleKeys;
            n = alleleKeys.length;
            n2 = 0;
            while (n2 < n) {
                allele = objectArray[n2];
                alleleContents = readCounts.get(allele).split("\t");
                if (!((String)allele).equals(refBase)) {
                    int thisReads1 = reads1;
                    int thisReads2 = 0;
                    int thisStrands2 = 0;
                    int thisAvgQual2 = 0;
                    int thisAvgMap2 = 0;
                    int thisReads2plus = 0;
                    int thisReads2minus = 0;
                    try {
                        thisReads2 = Integer.parseInt(alleleContents[0]);
                        thisStrands2 = Integer.parseInt(alleleContents[1]);
                        thisAvgQual2 = Integer.parseInt(alleleContents[2]);
                        thisAvgMap2 = Integer.parseInt(alleleContents[3]);
                        thisReads2plus = Integer.parseInt(alleleContents[4]);
                        thisReads2minus = Integer.parseInt(alleleContents[5]);
                        if (((String)allele).contains("INS") || ((String)allele).contains("DEL")) {
                            readsWithIndels += thisReads2;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!callType.equals("CNS") || thisReads2 > reads2) {
                        double thisVarFreq = (double)thisReads2 / (double)totalReadCounts;
                        double thisPvalue = 1.0;
                        if (((String)allele).contains("INS") || ((String)allele).contains("DEL")) {
                            int thisTotalReadCounts = totalReadCounts - reads1indel;
                            if (thisTotalReadCounts < thisReads2) {
                                thisTotalReadCounts = thisReads2;
                            }
                            thisVarFreq = (double)thisReads2 / (double)totalReadCounts;
                        }
                        thisPvalue = pValueThreshold == 0.99 ? 0.98 : VarScan.getSignificance(reads1, thisReads2);
                        if (thisReads2 > reads2 && thisAvgQual2 >= minAvgQual) {
                            varAllele = ((String)allele).contains("INS") || ((String)allele).contains("DEL") ? VarScan.getShortIndel((String)allele) : allele;
                            reads2 = thisReads2;
                            strands2 = thisStrands2;
                            avgQual2 = thisAvgQual2;
                            avgMap2 = thisAvgMap2;
                            reads2plus = thisReads2plus;
                            reads2minus = thisReads2minus;
                            varFreq = thisVarFreq * 100.0;
                            pValue = thisPvalue;
                        }
                        if (thisReads2 >= minReads2 && thisAvgQual2 >= minAvgQual && thisVarFreq >= minVarFreq) {
                            thisReads1 = reads1;
                            thisVarFreq *= 100.0;
                            String thisVarType = "SNP";
                            if (((String)allele).contains("INS") || ((String)allele).contains("DEL")) {
                                thisVarType = "INDEL";
                                thisReads1 = reads1;
                                if (thisReads1 < 0) {
                                    thisReads1 = 0;
                                }
                                allele = VarScan.getShortIndel((String)allele);
                            }
                            if (thisPvalue <= pValueThreshold) {
                                String genotype;
                                if (callType.equals("SNP") || callType.equals("INDEL")) {
                                    reads2 = thisReads2;
                                    strands2 = thisStrands2;
                                    avgQual2 = thisAvgQual2;
                                    avgMap2 = thisAvgMap2;
                                    reads2plus = thisReads2plus;
                                    reads2minus = thisReads2minus;
                                    pValue = thisPvalue;
                                    genotype = "";
                                    if (thisVarFreq >= minFreqForHom * 100.0) {
                                        genotype = String.valueOf(allele) + (String)allele;
                                        if (thisVarType.equals("INDEL")) {
                                            genotype = String.valueOf(allele) + "/" + (String)allele;
                                        }
                                    } else {
                                        genotype = String.valueOf(refBase) + (String)allele;
                                        if (thisVarType.equals("INDEL")) {
                                            genotype = "*/" + (String)allele;
                                        }
                                    }
                                    if (thisVarType.equals(callType)) {
                                        if (callResult.length() > 0) {
                                            callResult = String.valueOf(callResult) + "\n";
                                        }
                                        if (thisReads1 < 0) {
                                            thisReads1 = 0;
                                        }
                                        if (reads2 < 0) {
                                            reads2 = 0;
                                        }
                                        callResult = String.valueOf(callResult) + VarScan.genotypeToCode(genotype) + "\t" + thisReads1 + "\t" + reads2 + "\t" + df.format(thisVarFreq) + "%\t" + strands1 + "\t" + strands2 + "\t" + avgQual1 + "\t" + avgQual2 + "\t" + pValue;
                                        callResult = String.valueOf(callResult) + "\t" + avgMap1 + "\t" + avgMap2;
                                        callResult = String.valueOf(callResult) + "\t" + reads1plus + "\t" + reads1minus + "\t" + reads2plus + "\t" + reads2minus + "\t" + (String)varAllele;
                                    }
                                } else if (callType.equals("CNS") && thisReads2 >= reads2) {
                                    reads2 = thisReads2;
                                    strands2 = thisStrands2;
                                    avgQual2 = thisAvgQual2;
                                    avgMap2 = thisAvgMap2;
                                    reads2plus = thisReads2plus;
                                    reads2minus = thisReads2minus;
                                    pValue = thisPvalue;
                                    genotype = "";
                                    if (thisVarFreq >= minFreqForHom * 100.0) {
                                        genotype = String.valueOf(allele) + (String)allele;
                                        if (thisVarType.equals("INDEL")) {
                                            genotype = String.valueOf(allele) + "/" + (String)allele;
                                        }
                                    } else {
                                        genotype = String.valueOf(refBase) + (String)allele;
                                        if (thisVarType.equals("INDEL")) {
                                            genotype = "*/" + (String)allele;
                                        }
                                    }
                                    callResult = String.valueOf(VarScan.genotypeToCode(genotype)) + "\t" + thisReads1 + "\t" + reads2 + "\t" + df.format(thisVarFreq) + "%\t" + strands1 + "\t" + strands2 + "\t" + avgQual1 + "\t" + avgQual2 + "\t" + pValue;
                                    callResult = String.valueOf(callResult) + "\t" + avgMap1 + "\t" + avgMap2;
                                    callResult = String.valueOf(callResult) + "\t" + reads1plus + "\t" + reads1minus + "\t" + reads2plus + "\t" + reads2minus + "\t" + (String)varAllele;
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            System.err.println("Read Counts Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
        }
        if (callResult.length() == 0 && callType.equals("CNS")) {
            if (reads1 > 0 && reads1 > minReads2) {
                callResult = String.valueOf(refBase) + "\t" + reads1 + "\t" + reads2 + "\t" + df.format(varFreq) + "%\t" + strands1 + "\t" + strands2 + "\t" + avgQual1 + "\t" + avgQual2 + "\t" + pValue;
                callResult = String.valueOf(callResult) + "\t" + avgMap1 + "\t" + avgMap2;
                callResult = String.valueOf(callResult) + "\t" + reads1plus + "\t" + reads1minus + "\t" + reads2plus + "\t" + reads2minus + "\t" + (String)varAllele;
            } else {
                callResult = "N\t" + reads1 + "\t" + reads2 + "\t" + df.format(varFreq) + "%\t" + strands1 + "\t" + strands2 + "\t" + avgQual1 + "\t" + avgQual2 + "\t" + pValue;
                callResult = String.valueOf(callResult) + "\t" + avgMap1 + "\t" + avgMap2;
                callResult = String.valueOf(callResult) + "\t" + reads1plus + "\t" + reads1minus + "\t" + reads2plus + "\t" + reads2minus + "\t" + (String)varAllele;
            }
        }
        return callResult;
    }

    static String strandFilter(int reads1plus, int reads1minus, int reads2plus, int reads2minus, double strandPvalueThreshold) {
        DecimalFormat pvalueFormat = new DecimalFormat("0.####E0");
        String strandFilterStatus = "Pass:" + reads1plus + ":" + reads1minus + ":" + reads2plus + ":" + reads2minus + ":" + 1;
        double refStrandPlus = 0.5;
        double varStrandPlus = 0.5;
        double strandPvalue = 1.0;
        if (reads2plus + reads2minus > 0) {
            varStrandPlus = (double)reads2plus / (double)(reads2plus + reads2minus);
        }
        if (varStrandPlus < 0.1 || varStrandPlus > 0.9) {
            if (reads1plus + reads1minus > 1) {
                refStrandPlus = (double)reads1plus / (double)(reads1plus + reads1minus);
                strandPvalue = VarScan.getSignificance(reads1plus, reads1minus, reads2plus, reads2minus);
            } else {
                int testReads1plus = (reads2plus + reads2minus) / 2;
                int testReads1minus = reads2plus + reads2minus - testReads1plus;
                strandPvalue = VarScan.getSignificance(testReads1plus, testReads1minus, reads2plus, reads2minus);
            }
            strandFilterStatus = "Pass:" + varStrandPlus + ":" + reads1plus + ":" + reads1minus + ":" + reads2plus + ":" + reads2minus + ":" + pvalueFormat.format(strandPvalue);
            if (refStrandPlus >= 0.1 && refStrandPlus <= 0.9 && (!(varStrandPlus >= 0.1) || !(varStrandPlus <= 0.9)) && strandPvalue < strandPvalueThreshold) {
                strandFilterStatus = "Fail:" + reads1plus + ":" + reads1minus + ":" + reads2plus + ":" + reads2minus + ":" + pvalueFormat.format(strandPvalue);
            }
        }
        return strandFilterStatus;
    }

    public static double getSignificance(int obsReads1, int obsReads2) {
        double pValue = 1.0;
        double baseline_error = 0.001;
        int coverage = obsReads1 + obsReads2;
        int expReads2 = (int)((double)coverage * baseline_error);
        int expReads1 = coverage - expReads2;
        pValue = VarScan.getSignificance(expReads1, expReads2, obsReads1, obsReads2);
        return pValue;
    }

    public static double getSignificance(int expReads1, int expReads2, int obsReads1, int obsReads2) {
        double pValue = 1.0;
        if (expReads1 < 0) {
            expReads1 = 0;
        }
        if (expReads2 < 0) {
            expReads2 = 0;
        }
        if (obsReads1 < 0) {
            obsReads1 = 0;
        }
        if (obsReads2 < 0) {
            obsReads2 = 0;
        }
        FishersExact fisher = new FishersExact(expReads1 + expReads2 + obsReads1 + obsReads2 + 100);
        pValue = fisher.getRightTailedP(expReads1, expReads2, obsReads1, obsReads2);
        int fisher_max = 1000;
        int num_tries = 0;
        while (Double.isNaN(pValue) && num_tries < 10) {
            fisher = new FishersExact(expReads1 + expReads2 + obsReads1 + obsReads2 + fisher_max);
            pValue = fisher.getRightTailedP(expReads1, expReads2, obsReads1, obsReads2);
            fisher_max += 1000;
            ++num_tries;
        }
        if (num_tries >= 10) {
            System.err.println("Warning: unable to calculate p-value failure: " + expReads1 + "," + expReads2 + "," + obsReads1 + "," + obsReads2);
        }
        if (pValue >= 0.999) {
            pValue = fisher.getLeftTailedP(expReads1, expReads2, obsReads1, obsReads2);
            while (Double.isNaN(pValue)) {
                fisher = new FishersExact(expReads1 + expReads2 + obsReads1 + obsReads2 + fisher_max);
                pValue = fisher.getLeftTailedP(expReads1, expReads2, obsReads1, obsReads2);
                fisher_max += 1000;
            }
        }
        return pValue;
    }

    static String genotypeToCode(String gt) {
        if (gt.equals("AA")) {
            return "A";
        }
        if (gt.equals("CC")) {
            return "C";
        }
        if (gt.equals("GG")) {
            return "G";
        }
        if (gt.equals("TT")) {
            return "T";
        }
        if (gt.equals("AC") || gt.equals("CA")) {
            return "M";
        }
        if (gt.equals("AG") || gt.equals("GA")) {
            return "R";
        }
        if (gt.equals("AT") || gt.equals("TA")) {
            return "W";
        }
        if (gt.equals("CG") || gt.equals("GC")) {
            return "S";
        }
        if (gt.equals("CT") || gt.equals("TC")) {
            return "Y";
        }
        if (gt.equals("GT") || gt.equals("TG")) {
            return "K";
        }
        if (gt.substring(0, 1).equals("N")) {
            return "N";
        }
        return gt;
    }

    static String getVarAllele(String refBase, String consCode) {
        String varAllele = consCode;
        if (consCode.contains("/")) {
            String[] tempArray = consCode.split("/");
            if (tempArray.length > 1) {
                varAllele = tempArray[1];
            }
        } else if (consCode.equals("M") || consCode.equals("R") || consCode.equals("W") || consCode.equals("S") || consCode.equals("Y") || consCode.equals("K")) {
            if (consCode.equals("M")) {
                varAllele = refBase.equals("A") ? "C" : "A";
            } else if (consCode.equals("R")) {
                varAllele = refBase.equals("A") ? "G" : "A";
            } else if (consCode.equals("W")) {
                varAllele = refBase.equals("A") ? "T" : "A";
            } else if (consCode.equals("S")) {
                varAllele = refBase.equals("G") ? "C" : "G";
            } else if (consCode.equals("Y")) {
                varAllele = refBase.equals("C") ? "T" : "C";
            } else if (consCode.equals("K")) {
                varAllele = refBase.equals("G") ? "T" : "G";
            }
        }
        return varAllele;
    }

    static String getShortIndel(String gt) {
        if (gt.contains("INS") || gt.contains("DEL")) {
            try {
                String[] gtContents = gt.split("-");
                String indel_type = gtContents[0];
                String indel_size = gtContents[1];
                String indel_bases = gtContents[2];
                if (indel_type.contains("INS")) {
                    return "+" + indel_bases;
                }
                return "-" + indel_bases;
            }
            catch (Exception e) {
                System.err.println("Warning: error generating consensus from " + gt);
            }
        }
        return "N";
    }

    static boolean isHeterozygous(String genotype) {
        String[] alleles;
        return genotype.contains("/") ? !(alleles = genotype.split("/"))[0].equals(alleles[1]) : genotype.equals("M") || genotype.equals("R") || genotype.equals("W") || genotype.equals("S") || genotype.equals("Y") || genotype.equals("K");
    }

    static boolean isHomozygous(String genotype) {
        String[] alleles;
        return genotype.contains("/") ? (alleles = genotype.split("/"))[0].equals(alleles[1]) : genotype.equals("A") || genotype.equals("C") || genotype.equals("G") || genotype.equals("T");
    }

    static String codeToGenotype(String code) {
        if (code.equals("A") || code.equals("C") || code.equals("G") || code.equals("T")) {
            return String.valueOf(code) + "/" + code;
        }
        if (code.contains("/")) {
            return code;
        }
        if (code.equals("M")) {
            return "A/C";
        }
        if (code.equals("R")) {
            return "A/G";
        }
        if (code.equals("W")) {
            return "A/T";
        }
        if (code.equals("S")) {
            return "C/G";
        }
        if (code.equals("Y")) {
            return "C/T";
        }
        if (code.equals("K")) {
            return "G/T";
        }
        return "N/N";
    }
}

