/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import net.sf.varscan.VarScan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trio {
    public Trio(String[] args, String callType) {
        block142: {
            String usage = "USAGE: java -jar VarScan.jar trio [mpileup file] [output-basename] OPTIONS\n\tmpileup file - The SAMtools mpileup file for father, mother, child in that order\n\n\tOPTIONS:\n\t--output-name\tAn output base name for VCF files of results. Required for piped input\n\t--min-coverage\tMinimum read depth at a position to make a call [20]\n\t--min-reads2\tMinimum supporting reads at a position to call variants [2]\n\t--min-avg-qual\tMinimum base quality at a position to count a read [15]\n\t--min-var-freq\tMinimum variant allele frequency threshold [0.20]\n\t--min-freq-for-hom\tMinimum frequency to call homozygote [0.75]\n\t--p-value\tDefault p-value threshold for calling variants [0.05]\n\t--adj-var-freq\tAdjusted minimum VAF when recalling at variant site [0.05]\n\t--adj-p-value\tAdjusted p-value when recalling at variant site [0.10]\n\t--vcf-sample-list\tFor VCF output, a list of sample names in order, one per line\n\t--variants\tReport only variant (SNP/indel) positions [0]";
            HashMap params = VarScan.getParams(args);
            String outputName = "output";
            String outputSnp = "";
            String outputIndel = "";
            if (args.length >= 3 && !args[2].startsWith("-")) {
                outputName = args[2];
                outputSnp = String.valueOf(outputName) + ".snp.vcf";
                outputIndel = String.valueOf(outputName) + ".indel.vcf";
            }
            DecimalFormat pvalueFormat = new DecimalFormat("0.####E0");
            params.put("output-vcf", "1");
            int minCoverage = 20;
            int minReads2 = 4;
            int minAvgQual = 15;
            double minVarFreq = 0.2;
            double minFreqForHom = 0.75;
            double pValueThreshold = 0.01;
            double strandPvalueThreshold = 0.01;
            double adjustedMinVarFreq = 0.05;
            double adjustedpValueThreshold = 0.1;
            int adjustedMinReads2 = 2;
            boolean strandFilter = true;
            String sampleList = "";
            if (callType.equals("CNS")) {
                minVarFreq = 0.2;
                pValueThreshold = 0.01;
            }
            try {
                if (params.containsKey("min-coverage")) {
                    minCoverage = Integer.parseInt((String)params.get("min-coverage"));
                }
                if (params.containsKey("min-reads2")) {
                    minReads2 = Integer.parseInt((String)params.get("min-reads2"));
                }
                if (params.containsKey("adj-min-reads2")) {
                    adjustedMinReads2 = Integer.parseInt((String)params.get("adj-min-reads2"));
                }
                if (params.containsKey("min-var-freq")) {
                    minVarFreq = Double.parseDouble((String)params.get("min-var-freq"));
                }
                if (params.containsKey("adj-var-freq")) {
                    adjustedMinVarFreq = Double.parseDouble((String)params.get("adj-var-freq"));
                }
                if (params.containsKey("p-value")) {
                    pValueThreshold = Double.parseDouble((String)params.get("p-value"));
                }
                if (params.containsKey("adj-p-value")) {
                    adjustedpValueThreshold = Double.parseDouble((String)params.get("adj-p-value"));
                }
                if (params.containsKey("min-freq-for-hom")) {
                    minFreqForHom = Double.parseDouble((String)params.get("min-freq-for-hom"));
                }
                if (params.containsKey("min-avg-qual")) {
                    minAvgQual = Integer.parseInt((String)params.get("min-avg-qual"));
                }
                if (params.containsKey("output-name")) {
                    outputName = (String)params.get("output-name");
                    outputSnp = String.valueOf(outputName) + ".snp.vcf";
                    outputIndel = String.valueOf(outputName) + ".indel.vcf";
                }
                if (params.containsKey("strand-filter")) {
                    int filter = Integer.parseInt((String)params.get("strand-filter"));
                    strandFilter = filter > 0;
                }
                if (params.containsKey("vcf-sample-list")) {
                    File samplefile = new File((String)params.get("vcf-sample-list"));
                    if (samplefile.exists()) {
                        BufferedReader in = new BufferedReader(new FileReader(samplefile));
                        String line = "";
                        if (in.ready()) {
                            while ((line = in.readLine()) != null) {
                                String sampleName = line;
                                if (sampleList.length() > 0) {
                                    sampleList = String.valueOf(sampleList) + "\t";
                                }
                                sampleList = String.valueOf(sampleList) + sampleName;
                            }
                        } else {
                            System.err.println("Unable to open sample list");
                        }
                        in.close();
                    }
                    System.err.println("Got the following sample list: ");
                    System.err.println(sampleList);
                }
                if (params.containsKey("p-value")) {
                    pValueThreshold = Double.parseDouble((String)params.get("p-value"));
                } else {
                    System.err.println("Warning: No p-value threshold provided, so p-values will not be calculated");
                }
                if (outputSnp.length() == 0 || outputIndel.length() == 0) {
                    System.err.println("Please provide an output basename or SNP/indel output files!");
                    System.err.println(usage);
                    System.exit(1);
                }
                System.err.println("SNPs will be output to " + outputSnp);
                System.err.println("Indels will be output to " + outputIndel);
                System.err.println("Min coverage:\t" + minCoverage);
                System.err.println("Min reads2:\t" + minReads2);
                System.err.println("Min var freq:\t" + minVarFreq);
                System.err.println("Min avg qual:\t" + minAvgQual);
                System.err.println("P-value thresh:\t" + pValueThreshold);
                System.err.println("Adj. min reads2:\t" + adjustedMinReads2);
                System.err.println("Adj. var freq:\t" + adjustedMinVarFreq);
                System.err.println("Adj. p-value:\t" + adjustedpValueThreshold);
            }
            catch (Exception e) {
                System.err.println("Input Parameter Threw Exception: " + e.getLocalizedMessage());
                e.printStackTrace(System.err);
                return;
            }
            if (params.containsKey("help") || params.containsKey("h")) {
                System.err.println(usage);
                return;
            }
            long numBases = 0L;
            long numBasesCovered = 0L;
            long numVariantPositions = 0L;
            long numSNPpositions = 0L;
            long numIndelPositions = 0L;
            long numFailStrandFilter = 0L;
            long numFailMendelFilter = 0L;
            long numVariantsReported = 0L;
            long numVariantsReportedDeNovo = 0L;
            long numSNPsReported = 0L;
            long numSNPsReportedDeNovo = 0L;
            long numIndelsReported = 0L;
            long numIndelsReportedDeNovo = 0L;
            int numParsingExceptions = 0;
            HashMap<String, Integer> stats = new HashMap<String, Integer>();
            try {
                BufferedReader in = VarScan.getInfile(args);
                if (in == null) {
                    System.out.println(usage);
                    return;
                }
                int numNaps = 0;
                while (!in.ready()) {
                    try {
                        Thread.sleep(5000L);
                        if (++numNaps <= 100) continue;
                        System.err.println("Input file was not ready after 100 5-second cycles!");
                        System.exit(10);
                    }
                    catch (Exception e) {
                        System.err.println("Exception while trying to get input" + e.getMessage());
                        System.exit(1);
                    }
                }
                String vcfHeader = "##fileformat=VCFv4.1";
                if (in != null && in.ready()) {
                    String line;
                    PrintStream outSnp = null;
                    PrintStream outIndel = null;
                    outSnp = new PrintStream(new FileOutputStream(outputSnp));
                    outIndel = new PrintStream(new FileOutputStream(outputIndel));
                    if (!params.containsKey("no-headers")) {
                        if (params.containsKey("output-vcf")) {
                            vcfHeader = String.valueOf(vcfHeader) + "\n##source=VarScan2";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=ADP,Number=1,Type=Integer,Description=\"Average per-sample depth of bases with Phred score >= " + minAvgQual + "\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=STATUS,Number=1,Type=String,Description=\"Variant status in trio (1=untransmitted, 2=transmitted, 3=denovo, 4=MIE)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=DENOVO,Number=0,Type=Flag,Description=\"Indicates apparent de novo mutations unique to the child\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FILTER=<ID=str10,Description=\"Less than 10% or more than 90% of variant supporting reads on one strand\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FILTER=<ID=indelError,Description=\"Likely artifact due to indel reads at this position\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FILTER=<ID=mendelError,Description=\"Apparent Mendelian inheritance error (MIE) in trio\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=GT,Number=1,Type=String,Description=\"Genotype\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=GQ,Number=1,Type=Integer,Description=\"Genotype Quality\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=SDP,Number=1,Type=Integer,Description=\"Raw Read Depth as reported by SAMtools\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=DP,Number=1,Type=Integer,Description=\"Quality Read Depth of bases with Phred score >= " + minAvgQual + "\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=RD,Number=1,Type=Integer,Description=\"Depth of reference-supporting bases (reads1)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=AD,Number=1,Type=Integer,Description=\"Depth of variant-supporting bases (reads2)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=FREQ,Number=1,Type=String,Description=\"Variant allele frequency\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=PVAL,Number=1,Type=String,Description=\"P-value from Fisher's Exact Test\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=RBQ,Number=1,Type=Integer,Description=\"Average quality of reference-supporting bases (qual1)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=ABQ,Number=1,Type=Integer,Description=\"Average quality of variant-supporting bases (qual2)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=RDF,Number=1,Type=Integer,Description=\"Depth of reference-supporting bases on forward strand (reads1plus)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=RDR,Number=1,Type=Integer,Description=\"Depth of reference-supporting bases on reverse strand (reads1minus)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=ADF,Number=1,Type=Integer,Description=\"Depth of variant-supporting bases on forward strand (reads2plus)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=ADR,Number=1,Type=Integer,Description=\"Depth of variant-supporting bases on reverse strand (reads2minus)\">";
                        } else {
                            System.out.println("Chrom\tPosition\tRef\tVar\tStrandFilter:R1+:R1-:R2+:R2-:pval\tFather:Cov:Reads1:Reads2:Freq:P-value\tMother:Cov:Reads1:Reads2:Freq:P-value\tChild:Cov:Reads1:Reads2:Freq:P-value");
                        }
                    }
                    while ((line = in.readLine()) != null) {
                        if (params.containsKey("verbose") && ++numBases % 100000L == 0L) {
                            System.err.println(String.valueOf(numBases) + " positions parsed...");
                        }
                        try {
                            String[] lineContents = line.split("\t");
                            if (lineContents.length > 5 && lineContents[0].length() > 0 && lineContents[1].length() > 0 && lineContents[2].length() > 0 && lineContents[3].length() > 0) {
                                String allQualities;
                                if (numBases == 1L && params.containsKey("output-vcf")) {
                                    vcfHeader = String.valueOf(vcfHeader) + "\n#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT";
                                    vcfHeader = sampleList.length() > 0 ? String.valueOf(vcfHeader) + "\t" + sampleList : String.valueOf(vcfHeader) + "\tFather\tMother\tChild";
                                    outSnp.println(vcfHeader);
                                    outIndel.println(vcfHeader);
                                }
                                String refName = lineContents[0];
                                String position = lineContents[1];
                                String refBase = lineContents[2].toUpperCase();
                                HashMap<String, Integer> varAlleles = new HashMap<String, Integer>();
                                boolean variantFlag = false;
                                double strandPvalue = 1.0;
                                String strandFilterStatus = "";
                                if (lineContents.length > 12 && numBases == 1L) {
                                    System.err.println("Warning: More than 3 samples in pileup; but only first 3 will be used and they should be father, mother child");
                                }
                                int offset = 3;
                                int fatherDepth = Integer.parseInt(lineContents[offset]);
                                String fatherBases = lineContents[offset + 1];
                                String fatherQualities = lineContents[offset + 2];
                                int fatherQualityDepth = VarScan.qualityDepth(fatherQualities, minAvgQual);
                                offset = 6;
                                int motherDepth = Integer.parseInt(lineContents[offset]);
                                String motherBases = lineContents[offset + 1];
                                String motherQualities = lineContents[offset + 2];
                                int motherQualityDepth = VarScan.qualityDepth(motherQualities, minAvgQual);
                                offset = 9;
                                int childDepth = Integer.parseInt(lineContents[offset]);
                                String childBases = lineContents[offset + 1];
                                String childQualities = lineContents[offset + 2];
                                int childQualityDepth = VarScan.qualityDepth(childQualities, minAvgQual);
                                if (fatherQualityDepth < minCoverage || motherQualityDepth < minCoverage || childQualityDepth < minCoverage) continue;
                                ++numBasesCovered;
                                String allBases = String.valueOf(fatherBases) + motherBases + childBases;
                                HashMap<String, String> allCounts = VarScan.getReadCounts(refBase, allBases, allQualities = String.valueOf(fatherQualities) + motherQualities + childQualities, minAvgQual, "");
                                String positionCall = VarScan.callPosition(refBase, allCounts, "CNS", minReads2, 0.01, minAvgQual, 0.95, minFreqForHom);
                                String[] callContents = positionCall.split("\t");
                                if (callContents.length >= 15) {
                                    int reads1plus = Integer.parseInt(callContents[11]);
                                    int reads1minus = Integer.parseInt(callContents[12]);
                                    int reads2plus = Integer.parseInt(callContents[13]);
                                    int reads2minus = Integer.parseInt(callContents[14]);
                                    strandFilterStatus = VarScan.strandFilter(reads1plus, reads1minus, reads2plus, reads2minus, strandPvalueThreshold);
                                }
                                HashMap<String, String> fatherCounts = VarScan.getReadCounts(refBase, fatherBases, fatherQualities, minAvgQual, "");
                                HashMap<String, String> motherCounts = VarScan.getReadCounts(refBase, motherBases, motherQualities, minAvgQual, "");
                                HashMap<String, String> childCounts = VarScan.getReadCounts(refBase, childBases, childQualities, minAvgQual, "");
                                String fatherCall = "";
                                String motherCall = "";
                                String childCall = "";
                                String trioStatus = "";
                                String trioCall = this.callTrio(refBase, fatherCounts, motherCounts, childCounts, minReads2, minVarFreq, minAvgQual, pValueThreshold, minFreqForHom);
                                String[] trioCallContents = trioCall.split("\t");
                                if (trioCallContents.length >= 4) {
                                    fatherCall = trioCallContents[0];
                                    motherCall = trioCallContents[1];
                                    childCall = trioCallContents[2];
                                    trioStatus = trioCallContents[3];
                                    boolean recallTrio = false;
                                    if (trioStatus.equals("DeNovo") || trioStatus.contains("MIE") || trioStatus.equals("Untransmitted")) {
                                        String[] fatherContents = fatherCall.split(":");
                                        String[] motherContents = motherCall.split(":");
                                        String[] childContents = childCall.split(":");
                                        String fatherAllele = refBase;
                                        String motherAllele = refBase;
                                        String childAllele = refBase;
                                        if (fatherContents.length >= 16) {
                                            fatherAllele = fatherContents[15];
                                        }
                                        if (motherContents.length >= 16) {
                                            motherAllele = motherContents[15];
                                        }
                                        if (childContents.length >= 16) {
                                            childAllele = childContents[15];
                                        }
                                        if (trioStatus.equals("Untransmitted")) {
                                            if (!childAllele.equals(refBase) && (childAllele.equals(motherAllele) || childAllele.equals(fatherAllele))) {
                                                recallTrio = true;
                                            }
                                        } else if (trioStatus.equals("DeNovo")) {
                                            recallTrio = true;
                                        } else if (trioStatus.contains("MIE")) {
                                            recallTrio = true;
                                        }
                                        if (recallTrio) {
                                            trioCall = this.callTrio(refBase, fatherCounts, motherCounts, childCounts, adjustedMinReads2, adjustedMinVarFreq, minAvgQual, adjustedpValueThreshold, minFreqForHom);
                                            trioCallContents = trioCall.split("\t");
                                            if (!trioStatus.equals(trioCallContents[3])) {
                                                String change = "initially " + trioStatus + " were re-called " + trioCallContents[3];
                                                if (!stats.containsKey(change)) {
                                                    stats.put(change, 1);
                                                } else {
                                                    stats.put(change, (Integer)stats.get(change) + 1);
                                                }
                                            }
                                            trioStatus = trioCallContents[3];
                                        }
                                    }
                                    String variantType = "SNP";
                                    fatherCall = trioCallContents[0];
                                    motherCall = trioCallContents[1];
                                    childCall = trioCallContents[2];
                                    String[] fatherContents = fatherCall.split(":");
                                    String[] motherContents = motherCall.split(":");
                                    String[] childContents = childCall.split(":");
                                    String fatherAllele = refBase;
                                    String motherAllele = refBase;
                                    String childAllele = refBase;
                                    String fatherVCF = "./.:.:" + fatherQualityDepth;
                                    if (fatherContents.length >= 15) {
                                        if (fatherContents.length >= 16) {
                                            fatherAllele = fatherContents[15];
                                        }
                                        String consBase = fatherContents[0];
                                        int reads1 = Integer.parseInt(fatherContents[1]);
                                        int reads2 = Integer.parseInt(fatherContents[2]);
                                        String varFreq = fatherContents[3];
                                        int qual1 = Integer.parseInt(fatherContents[6]);
                                        int qual2 = Integer.parseInt(fatherContents[7]);
                                        double pValue = Double.parseDouble(fatherContents[8]);
                                        int reads1plus = Integer.parseInt(fatherContents[11]);
                                        int reads1minus = Integer.parseInt(fatherContents[12]);
                                        int reads2plus = Integer.parseInt(fatherContents[13]);
                                        int reads2minus = Integer.parseInt(fatherContents[14]);
                                        double logP = 0.0;
                                        try {
                                            logP = 0.0 - 10.0 * Math.log10(pValue);
                                            if (logP > 255.0) {
                                                logP = 255.0;
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        if (consBase.equals(refBase)) {
                                            int expReads1 = (reads1 + reads2) / 2;
                                            int expReads2 = reads1 + reads2 - expReads1;
                                            double newPvalue = VarScan.getSignificance(reads1, reads2, expReads1, expReads2);
                                            double newLogP = 0.0;
                                            try {
                                                newLogP = 0.0 - 10.0 * Math.log10(newPvalue);
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            fatherVCF = "0/0";
                                            fatherVCF = String.valueOf(fatherVCF) + ":" + (int)newLogP + ":" + fatherDepth + ":" + fatherQualityDepth;
                                            fatherVCF = String.valueOf(fatherVCF) + ":" + reads1 + ":" + reads2 + ":" + varFreq + ":" + pvalueFormat.format(pValue);
                                            fatherVCF = String.valueOf(fatherVCF) + ":" + qual1 + ":" + qual2;
                                            fatherVCF = String.valueOf(fatherVCF) + ":" + reads1plus + ":" + reads1minus + ":" + reads2plus + ":" + reads2minus;
                                        } else if (fatherAllele.length() > 0 && !fatherAllele.equals("N") && !fatherAllele.equals(".")) {
                                            int varAlleleNumber = 0;
                                            if (varAlleles.containsKey(fatherAllele)) {
                                                varAlleleNumber = (Integer)varAlleles.get(fatherAllele);
                                            } else {
                                                varAlleleNumber = varAlleles.size() + 1;
                                                varAlleles.put(fatherAllele, varAlleleNumber);
                                            }
                                            if (fatherContents.length >= 1) {
                                                fatherVCF = VarScan.isHomozygous(consBase) ? String.valueOf(varAlleleNumber) + "/" + varAlleleNumber : "0/" + varAlleleNumber;
                                                fatherVCF = String.valueOf(fatherVCF) + ":" + (int)logP + ":" + fatherDepth + ":" + fatherQualityDepth;
                                                fatherVCF = String.valueOf(fatherVCF) + ":" + reads1 + ":" + reads2 + ":" + varFreq + ":" + pvalueFormat.format(pValue);
                                                fatherVCF = String.valueOf(fatherVCF) + ":" + qual1 + ":" + qual2;
                                                fatherVCF = String.valueOf(fatherVCF) + ":" + reads1plus + ":" + reads1minus + ":" + reads2plus + ":" + reads2minus;
                                            }
                                            if (fatherAllele.length() > 1) {
                                                variantType = "Indel";
                                            }
                                        }
                                    }
                                    String motherVCF = "./.:.:" + motherQualityDepth;
                                    if (motherContents.length >= 15) {
                                        if (motherContents.length >= 16) {
                                            motherAllele = motherContents[15];
                                        }
                                        String consBase = motherContents[0];
                                        int reads1 = Integer.parseInt(motherContents[1]);
                                        int reads2 = Integer.parseInt(motherContents[2]);
                                        String varFreq = motherContents[3];
                                        int qual1 = Integer.parseInt(motherContents[6]);
                                        int qual2 = Integer.parseInt(motherContents[7]);
                                        double pValue = Double.parseDouble(motherContents[8]);
                                        int reads1plus = Integer.parseInt(motherContents[11]);
                                        int reads1minus = Integer.parseInt(motherContents[12]);
                                        int reads2plus = Integer.parseInt(motherContents[13]);
                                        int reads2minus = Integer.parseInt(motherContents[14]);
                                        double logP = 0.0;
                                        try {
                                            logP = 0.0 - 10.0 * Math.log10(pValue);
                                            if (logP > 255.0) {
                                                logP = 255.0;
                                            }
                                        }
                                        catch (Exception expReads2) {
                                            // empty catch block
                                        }
                                        if (consBase.equals(refBase)) {
                                            int expReads1 = (reads1 + reads2) / 2;
                                            int expReads2 = reads1 + reads2 - expReads1;
                                            double newPvalue = VarScan.getSignificance(reads1, reads2, expReads1, expReads2);
                                            double newLogP = 0.0;
                                            try {
                                                newLogP = 0.0 - 10.0 * Math.log10(newPvalue);
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            motherVCF = "0/0";
                                            motherVCF = String.valueOf(motherVCF) + ":" + (int)newLogP + ":" + motherDepth + ":" + motherQualityDepth;
                                            motherVCF = String.valueOf(motherVCF) + ":" + reads1 + ":" + reads2 + ":" + varFreq + ":" + pvalueFormat.format(pValue);
                                            motherVCF = String.valueOf(motherVCF) + ":" + qual1 + ":" + qual2;
                                            motherVCF = String.valueOf(motherVCF) + ":" + reads1plus + ":" + reads1minus + ":" + reads2plus + ":" + reads2minus;
                                        } else if (motherAllele.length() > 0 && !motherAllele.equals("N") && !motherAllele.equals(".")) {
                                            int varAlleleNumber = 0;
                                            if (varAlleles.containsKey(motherAllele)) {
                                                varAlleleNumber = (Integer)varAlleles.get(motherAllele);
                                            } else {
                                                varAlleleNumber = varAlleles.size() + 1;
                                                varAlleles.put(motherAllele, varAlleleNumber);
                                            }
                                            if (motherContents.length >= 1) {
                                                motherVCF = VarScan.isHomozygous(consBase) ? String.valueOf(varAlleleNumber) + "/" + varAlleleNumber : "0/" + varAlleleNumber;
                                                motherVCF = String.valueOf(motherVCF) + ":" + (int)logP + ":" + motherDepth + ":" + motherQualityDepth;
                                                motherVCF = String.valueOf(motherVCF) + ":" + reads1 + ":" + reads2 + ":" + varFreq + ":" + pvalueFormat.format(pValue);
                                                motherVCF = String.valueOf(motherVCF) + ":" + qual1 + ":" + qual2;
                                                motherVCF = String.valueOf(motherVCF) + ":" + reads1plus + ":" + reads1minus + ":" + reads2plus + ":" + reads2minus;
                                            }
                                            if (motherAllele.length() > 1) {
                                                variantType = "Indel";
                                            }
                                        }
                                    }
                                    String childVCF = "./.:.:" + childQualityDepth;
                                    if (childContents.length >= 15) {
                                        if (childContents.length >= 16) {
                                            childAllele = childContents[15];
                                        }
                                        String consBase = childContents[0];
                                        int reads1 = Integer.parseInt(childContents[1]);
                                        int reads2 = Integer.parseInt(childContents[2]);
                                        String varFreq = childContents[3];
                                        int qual1 = Integer.parseInt(childContents[6]);
                                        int qual2 = Integer.parseInt(childContents[7]);
                                        double pValue = Double.parseDouble(childContents[8]);
                                        int reads1plus = Integer.parseInt(childContents[11]);
                                        int reads1minus = Integer.parseInt(childContents[12]);
                                        int reads2plus = Integer.parseInt(childContents[13]);
                                        int reads2minus = Integer.parseInt(childContents[14]);
                                        double logP = 0.0;
                                        try {
                                            logP = 0.0 - 10.0 * Math.log10(pValue);
                                            if (logP > 255.0) {
                                                logP = 255.0;
                                            }
                                        }
                                        catch (Exception expReads2) {
                                            // empty catch block
                                        }
                                        if (consBase.equals(refBase)) {
                                            int expReads1 = (reads1 + reads2) / 2;
                                            int expReads2 = reads1 + reads2 - expReads1;
                                            double newPvalue = VarScan.getSignificance(reads1, reads2, expReads1, expReads2);
                                            double newLogP = 0.0;
                                            try {
                                                newLogP = 0.0 - 10.0 * Math.log10(newPvalue);
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            childVCF = "0/0";
                                            childVCF = String.valueOf(childVCF) + ":" + (int)newLogP + ":" + childDepth + ":" + childQualityDepth;
                                            childVCF = String.valueOf(childVCF) + ":" + reads1 + ":" + reads2 + ":" + varFreq + ":" + pvalueFormat.format(pValue);
                                            childVCF = String.valueOf(childVCF) + ":" + qual1 + ":" + qual2;
                                            childVCF = String.valueOf(childVCF) + ":" + reads1plus + ":" + reads1minus + ":" + reads2plus + ":" + reads2minus;
                                        } else if (childAllele.length() > 0 && !childAllele.equals("N") && !childAllele.equals(".")) {
                                            int varAlleleNumber = 0;
                                            if (varAlleles.containsKey(childAllele)) {
                                                varAlleleNumber = (Integer)varAlleles.get(childAllele);
                                            } else {
                                                varAlleleNumber = varAlleles.size() + 1;
                                                varAlleles.put(childAllele, varAlleleNumber);
                                            }
                                            if (childContents.length >= 1) {
                                                childVCF = VarScan.isHomozygous(consBase) ? String.valueOf(varAlleleNumber) + "/" + varAlleleNumber : "0/" + varAlleleNumber;
                                                childVCF = String.valueOf(childVCF) + ":" + (int)logP + ":" + childDepth + ":" + childQualityDepth;
                                                childVCF = String.valueOf(childVCF) + ":" + reads1 + ":" + reads2 + ":" + varFreq + ":" + pvalueFormat.format(pValue);
                                                childVCF = String.valueOf(childVCF) + ":" + qual1 + ":" + qual2;
                                                childVCF = String.valueOf(childVCF) + ":" + reads1plus + ":" + reads1minus + ":" + reads2plus + ":" + reads2minus;
                                            }
                                            if (childAllele.length() > 1) {
                                                variantType = "Indel";
                                            }
                                        }
                                    }
                                    String outLine = String.valueOf(refName) + "\t" + position + "\t";
                                    String varBases = "";
                                    String[] sortedKeys = varAlleles.keySet().toArray(new String[0]);
                                    String[] alleleKeys = new String[sortedKeys.length];
                                    String[] reads1plus = sortedKeys;
                                    int pValue = sortedKeys.length;
                                    int qual2 = 0;
                                    while (qual2 < pValue) {
                                        String allele = reads1plus[qual2];
                                        int arrayIndex = (Integer)varAlleles.get(allele) - 1;
                                        alleleKeys[arrayIndex] = allele;
                                        ++qual2;
                                    }
                                    reads1plus = alleleKeys;
                                    pValue = alleleKeys.length;
                                    qual2 = 0;
                                    while (qual2 < pValue) {
                                        String allele = reads1plus[qual2];
                                        if (varBases.length() > 0) {
                                            varBases = String.valueOf(varBases) + ",";
                                        }
                                        varBases = String.valueOf(varBases) + allele;
                                        ++qual2;
                                    }
                                    if (varBases.length() == 0) {
                                        varBases = ".";
                                    }
                                    int avgQualityDepth = (fatherQualityDepth + motherQualityDepth + childQualityDepth) / 3;
                                    String refColumn = "";
                                    String varColumn = "";
                                    if (varBases.contains(",") && (varBases.contains("-") || varBases.contains("+"))) {
                                        String[] varBaseContents;
                                        variantType = "INDEL";
                                        int maxDelSize = 0;
                                        String maxDelBases = "";
                                        String[] stringArray = varBaseContents = varBases.split(",");
                                        int n = varBaseContents.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String varAllele = stringArray[n2];
                                            if (varAllele.startsWith("-") && (varAllele = varAllele.replace("-", "")).length() > maxDelSize) {
                                                maxDelBases = varAllele;
                                                maxDelSize = varAllele.length();
                                            }
                                            ++n2;
                                        }
                                        refColumn = String.valueOf(refBase) + maxDelBases;
                                        varColumn = "";
                                        stringArray = varBaseContents;
                                        n = varBaseContents.length;
                                        n2 = 0;
                                        while (n2 < n) {
                                            String varAllele = stringArray[n2];
                                            if (varColumn.length() > 0) {
                                                varColumn = String.valueOf(varColumn) + ",";
                                            }
                                            if (varAllele.startsWith("-")) {
                                                if ((varAllele = varAllele.replace("-", "")).length() < maxDelSize) {
                                                    String varEntry = maxDelBases.replace(varAllele, "");
                                                    varColumn = String.valueOf(varColumn) + refBase + varEntry;
                                                } else {
                                                    varColumn = String.valueOf(varColumn) + refBase;
                                                }
                                            } else if (varAllele.startsWith("+")) {
                                                varAllele = varAllele.replace("+", "");
                                                String varEntry = String.valueOf(refBase) + varAllele + maxDelBases;
                                                varColumn = String.valueOf(varColumn) + varEntry;
                                            } else {
                                                String varEntry = String.valueOf(varAllele) + maxDelBases;
                                                varColumn = String.valueOf(varColumn) + varEntry;
                                            }
                                            ++n2;
                                        }
                                    } else if (varBases.startsWith("+")) {
                                        variantType = "INDEL";
                                        refColumn = refBase;
                                        varColumn = String.valueOf(refBase) + varBases.replace("+", "");
                                    } else if (varBases.startsWith("-")) {
                                        variantType = "INDEL";
                                        refColumn = String.valueOf(refBase) + varBases.replace("-", "");
                                        varColumn = refBase;
                                    } else {
                                        refColumn = refBase;
                                        varColumn = varBases;
                                    }
                                    varColumn = varColumn.replace("+", "");
                                    varColumn = varColumn.replace("-", "");
                                    outLine = String.valueOf(outLine) + ".\t" + refColumn + "\t" + varColumn + "\t.\t";
                                    String filterColumn = "";
                                    filterColumn = trioStatus.contains("MIE") ? "mendelError" : (strandFilterStatus.contains("Fail") ? "str10" : "PASS");
                                    outLine = String.valueOf(outLine) + filterColumn + "\t";
                                    outLine = String.valueOf(outLine) + "ADP=" + avgQualityDepth + ";STATUS=";
                                    if (trioStatus.contains("Untransmitted")) {
                                        outLine = String.valueOf(outLine) + "1";
                                    } else if (trioStatus.contains("Germline")) {
                                        outLine = String.valueOf(outLine) + "2";
                                    } else if (trioStatus.contains("DeNovo")) {
                                        outLine = String.valueOf(outLine) + "3;DENOVO";
                                    } else if (trioStatus.contains("MIE")) {
                                        outLine = String.valueOf(outLine) + "4";
                                    }
                                    outLine = String.valueOf(outLine) + "\tGT:GQ:SDP:DP:RD:AD:FREQ:PVAL:RBQ:ABQ:RDF:RDR:ADF:ADR\t";
                                    outLine = String.valueOf(outLine) + fatherVCF + "\t" + motherVCF + "\t" + childVCF;
                                    String statKey = "";
                                    if (!trioStatus.equals("Reference")) {
                                        ++numVariantPositions;
                                        variantFlag = true;
                                        if (variantType.equals("INDEL")) {
                                            ++numIndelPositions;
                                        } else {
                                            ++numSNPpositions;
                                        }
                                        if (strandFilterStatus.contains("Fail")) {
                                            ++numFailStrandFilter;
                                        } else if (trioStatus.equals("MIE")) {
                                            ++numFailMendelFilter;
                                        } else {
                                            ++numVariantsReported;
                                            if (trioStatus.equals("DeNovo")) {
                                                ++numVariantsReportedDeNovo;
                                            }
                                            if (variantType.equals("INDEL")) {
                                                ++numIndelsReported;
                                                if (trioStatus.equals("DeNovo")) {
                                                    ++numIndelsReportedDeNovo;
                                                }
                                            } else {
                                                ++numSNPsReported;
                                                if (trioStatus.equals("DeNovo")) {
                                                    ++numSNPsReportedDeNovo;
                                                }
                                            }
                                        }
                                    }
                                    if (!variantFlag) continue;
                                    if (variantType.equals("SNP")) {
                                        outSnp.println(outLine);
                                        continue;
                                    }
                                    if (!variantType.equals("INDEL")) continue;
                                    outIndel.println(outLine);
                                    continue;
                                }
                                System.err.println("No status for " + numBases);
                                continue;
                            }
                            if (lineContents.length >= 4 && lineContents[3].equals("0")) continue;
                            System.err.println("Error: Invalid format for pileup at line " + numBases + "\n" + line + "\n");
                            return;
                        }
                        catch (Exception e) {
                            System.err.println("Parsing Exception on line:\n" + line + "\n" + e.getMessage() + "\n" + e.getLocalizedMessage());
                            e.printStackTrace();
                            if (++numParsingExceptions >= 5) {
                                System.err.println("Too many parsing exceptions encountered; exiting");
                                return;
                            }
                            return;
                        }
                    }
                    in.close();
                    System.err.println(String.valueOf(numBases) + " bases in pileup file");
                    System.err.println(String.valueOf(numBasesCovered) + " met the coverage requirement of " + minCoverage);
                    System.err.println(String.valueOf(numVariantPositions) + " variant positions (" + numSNPpositions + " SNP, " + numIndelPositions + " indel)");
                    System.err.println(String.valueOf(numFailStrandFilter) + " were failed by the strand-filter");
                    System.err.println(String.valueOf(numVariantsReported) + " variant positions reported (" + numSNPsReported + " SNP, " + numIndelsReported + " indel)");
                    System.err.println(String.valueOf(numVariantsReportedDeNovo) + " de novo mutations reported (" + numSNPsReportedDeNovo + " SNP, " + numIndelsReportedDeNovo + " indel)");
                    Object[] statsKeys = stats.keySet().toArray(new String[0]);
                    Arrays.sort(statsKeys);
                    boolean totalstats = false;
                    Object[] objectArray = statsKeys;
                    int n = statsKeys.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object statsKey = objectArray[n3];
                        System.err.println(stats.get(statsKey) + " " + (String)statsKey);
                        ++n3;
                    }
                    break block142;
                }
                System.err.println("Please provide an input file!\n" + usage);
                System.exit(10);
            }
            catch (Exception e) {
                System.err.println("Exception: " + e.getLocalizedMessage());
                e.printStackTrace(System.err);
                System.exit(11);
            }
        }
    }

    public String callTrio(String refBase, HashMap<String, String> fatherCounts, HashMap<String, String> motherCounts, HashMap<String, String> childCounts, int minReads2, double minVarFreq, int minAvgQual, double pValueThreshold, double minFreqForHom) {
        String fatherCall = VarScan.callPosition(refBase, fatherCounts, "CNS", minReads2, minVarFreq, minAvgQual, pValueThreshold, minFreqForHom);
        String motherCall = VarScan.callPosition(refBase, motherCounts, "CNS", minReads2, minVarFreq, minAvgQual, pValueThreshold, minFreqForHom);
        String childCall = VarScan.callPosition(refBase, childCounts, "CNS", minReads2, minVarFreq, minAvgQual, pValueThreshold, minFreqForHom);
        String trioStatus = "unknown";
        try {
            String[] fatherContents = fatherCall.split("\t");
            String[] motherContents = motherCall.split("\t");
            String[] childContents = childCall.split("\t");
            String father = fatherContents[0];
            String mother = motherContents[0];
            String child = childContents[0];
            String fatherAllele = refBase;
            String motherAllele = refBase;
            String childAllele = refBase;
            if (fatherContents.length >= 16) {
                fatherAllele = fatherContents[15];
            }
            if (motherContents.length >= 16) {
                motherAllele = motherContents[15];
            }
            if (childContents.length >= 16) {
                childAllele = childContents[15];
            }
            if (child.equals("N") || father.equals("N") || mother.equals("N")) {
                trioStatus = "MissingData";
            } else if (father.equals(refBase) && mother.equals(refBase) && child.equals(refBase)) {
                trioStatus = "Reference";
            } else if (father.equals(refBase) && mother.equals(refBase) && !child.equals(refBase)) {
                trioStatus = "DeNovo";
            } else {
                String fatherGt = VarScan.codeToGenotype(father);
                String motherGt = VarScan.codeToGenotype(mother);
                String childGt = VarScan.codeToGenotype(child);
                String father1 = "N";
                String father2 = "N";
                String[] fatherSplit = fatherGt.split("/");
                if (fatherSplit.length == 2) {
                    father1 = fatherSplit[0];
                    father2 = fatherSplit[1];
                }
                String mother1 = "N";
                String mother2 = "N";
                String[] motherSplit = motherGt.split("/");
                if (motherSplit.length == 2) {
                    mother1 = motherSplit[0];
                    mother2 = motherSplit[1];
                }
                String child1 = "N";
                String child2 = "N";
                String[] childSplit = childGt.split("/");
                if (childSplit.length == 2) {
                    child1 = childSplit[0];
                    child2 = childSplit[1];
                }
                if (father1.equals("*")) {
                    father1 = refBase;
                }
                if (mother1.equals("*")) {
                    mother1 = refBase;
                }
                if (child1.equals("*")) {
                    child1 = refBase;
                }
                if (!child.equals(refBase)) {
                    trioStatus = (child1.equals(father1) || child1.equals(father2) || child2.equals(father1) || child2.equals(father2)) && (child1.equals(mother1) || child1.equals(mother2) || child2.equals(mother1) || child2.equals(mother2)) ? "Germline" : (!child.equals(fatherAllele) && !child.equals(motherAllele) ? "MultAlleles" : "MIE");
                } else if (child.equals(refBase)) {
                    trioStatus = !(!father1.equals(refBase) && !father2.equals(refBase) || !mother1.equals(refBase) && !mother2.equals(refBase)) ? "Untransmitted" : "MIE";
                }
            }
            return String.valueOf(fatherCall.replace("\t", ":")) + "\t" + motherCall.replace("\t", ":") + "\t" + childCall.replace("\t", ":") + "\t" + trioStatus;
        }
        catch (Exception e) {
            System.err.println("Error parsing genotypes: " + e.getMessage() + " local: " + e.getLocalizedMessage());
            e.printStackTrace();
            return "";
        }
    }
}

