/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import net.sf.varscan.VarScan;

public class Somatic {
    public Somatic(String[] args, boolean isMpileup) {
        block85: {
            String usage = "USAGE: java -jar VarScan.jar somatic [normal-tumor.mpileup] [Opt: output] OPTIONS\n\tnormal-tumor.pileup - The SAMtools mpileup file for Normal and Tumor BAMs\n\toutput - Output base name for SNP and indel output\n\nOPTIONS:\n\t--output-snp - Output file for SNP calls [output.snp]\n\t--output-indel - Output file for indel calls [output.indel]\n\t--min-coverage - Minimum coverage in normal and tumor to call variant [8]\n\t--min-coverage-normal - Minimum coverage in normal to call somatic [8]\n\t--min-coverage-tumor - Minimum coverage in tumor to call somatic [6]\n\t--min-avg-qual - Minimum Phred quality to count a base [15]\n\t--min-var-freq - Minimum variant frequency to call a heterozygote [0.10]\n\t--min-freq-for-hom\tMinimum frequency to call homozygote [0.75]\n\t--normal-purity - Estimated purity (non-tumor content) of normal sample [1.00]\n\t--tumor-purity - Estimated purity (tumor content) of tumor sample [1.00]\n\t--p-value - P-value threshold to call a heterozygote [0.99]\n\t--somatic-p-value - P-value threshold to call a somatic site [0.05]\n\t--strand-filter - If set to 1, removes variants with >90% strand bias\n\t--validation - If set to 1, outputs all compared positions even if non-variant\n\t--output-vcf - If set to 1, output VCF instead of VarScan native format\n";
            String vcfHeader = "##fileformat=VCFv4.1";
            vcfHeader = String.valueOf(vcfHeader) + "\n##source=VarScan2";
            vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=DP,Number=1,Type=Integer,Description=\"Total depth of quality bases\">";
            vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=SOMATIC,Number=0,Type=Flag,Description=\"Indicates if record is a somatic mutation\">";
            vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=SS,Number=1,Type=String,Description=\"Somatic status of variant (0=Reference,1=Germline,2=Somatic,3=LOH, or 5=Unknown)\">";
            vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=SSC,Number=1,Type=String,Description=\"Somatic score in Phred scale (0-255) derived from somatic p-value\">";
            vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=GPV,Number=1,Type=Float,Description=\"Fisher's Exact Test P-value of tumor+normal versus no variant for Germline calls\">";
            vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=SPV,Number=1,Type=Float,Description=\"Fisher's Exact Test P-value of tumor versus normal for Somatic/LOH calls\">";
            vcfHeader = String.valueOf(vcfHeader) + "\n##FILTER=<ID=str10,Description=\"Less than 10% or more than 90% of variant supporting reads on one strand\">";
            vcfHeader = String.valueOf(vcfHeader) + "\n##FILTER=<ID=indelError,Description=\"Likely artifact due to indel reads at this position\">";
            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=GT,Number=1,Type=String,Description=\"Genotype\">";
            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=GQ,Number=1,Type=Integer,Description=\"Genotype Quality\">";
            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=DP,Number=1,Type=Integer,Description=\"Read Depth\">";
            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=RD,Number=1,Type=Integer,Description=\"Depth of reference-supporting bases (reads1)\">";
            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=AD,Number=1,Type=Integer,Description=\"Depth of variant-supporting bases (reads2)\">";
            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=FREQ,Number=1,Type=String,Description=\"Variant allele frequency\">";
            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=DP4,Number=1,Type=String,Description=\"Strand read counts: ref/fwd, ref/rev, var/fwd, var/rev\">";
            vcfHeader = String.valueOf(vcfHeader) + "\n#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT\tNORMAL\tTUMOR";
            HashMap params = VarScan.getParams(args);
            DecimalFormat pvalueFormat = new DecimalFormat("0.####E0");
            DecimalFormat oneDigit = new DecimalFormat("#0.0");
            DecimalFormat threeDigits = new DecimalFormat("#0.000");
            String outputName = "output";
            String outputSnp = "";
            String outputIndel = "";
            String outputCopy = "";
            if (args.length >= 3 && !args[2].startsWith("-")) {
                outputName = args[2];
                outputSnp = String.valueOf(outputName) + ".snp";
                outputIndel = String.valueOf(outputName) + ".indel";
            }
            int minCoverage = 8;
            int minCoverageNormal = 8;
            int minCoverageTumor = 6;
            int minReads2 = 2;
            int minStrands2 = 1;
            int minAvgQual = 15;
            double normalPurity = 1.0;
            double tumorPurity = 1.0;
            double dataRatio = 1.0;
            double minVarFreq = 0.2;
            double pValueThreshold = 0.99;
            double somaticPvalue = 0.05;
            double minFreqForHom = 0.75;
            boolean doStrandFilter = true;
            try {
                if (params.containsKey("output-snp")) {
                    outputSnp = (String)params.get("output-snp");
                }
                if (params.containsKey("output-indel")) {
                    outputIndel = (String)params.get("output-indel");
                }
                if (params.containsKey("min-coverage")) {
                    minCoverageNormal = minCoverage = Integer.parseInt((String)params.get("min-coverage"));
                    minCoverageTumor = minCoverage;
                }
                if (params.containsKey("min-coverage-normal")) {
                    minCoverageNormal = Integer.parseInt((String)params.get("min-coverage-normal"));
                }
                if (params.containsKey("min-coverage-tumor")) {
                    minCoverageTumor = Integer.parseInt((String)params.get("min-coverage-tumor"));
                }
                if (params.containsKey("min-reads2")) {
                    minReads2 = Integer.parseInt((String)params.get("min-reads2"));
                }
                if (params.containsKey("min-strands2")) {
                    minStrands2 = Integer.parseInt((String)params.get("min-strands2"));
                }
                if (params.containsKey("min-var-freq")) {
                    minVarFreq = Double.parseDouble((String)params.get("min-var-freq"));
                }
                if (params.containsKey("min-freq-for-hom")) {
                    minFreqForHom = Double.parseDouble((String)params.get("min-freq-for-hom"));
                }
                if (params.containsKey("min-avg-qual")) {
                    minAvgQual = Integer.parseInt((String)params.get("min-avg-qual"));
                }
                if (params.containsKey("p-value")) {
                    pValueThreshold = Double.parseDouble((String)params.get("p-value"));
                }
                if (params.containsKey("somatic-p-value")) {
                    somaticPvalue = Double.parseDouble((String)params.get("somatic-p-value"));
                }
                if (params.containsKey("data-ratio")) {
                    dataRatio = Double.parseDouble((String)params.get("data-ratio"));
                }
                if (params.containsKey("normal-purity") && (normalPurity = Double.parseDouble((String)params.get("normal-purity"))) > 1.0) {
                    normalPurity /= 100.0;
                }
                if (params.containsKey("tumor-purity") && (tumorPurity = Double.parseDouble((String)params.get("tumor-purity"))) > 1.0) {
                    tumorPurity = normalPurity / 100.0;
                }
                if (params.containsKey("strand-filter")) {
                    int filter = Integer.parseInt((String)params.get("strand-filter"));
                    doStrandFilter = filter > 0;
                }
                System.err.println("Min coverage:\t" + minCoverageNormal + "x for Normal, " + minCoverageTumor + "x for Tumor");
                System.err.println("Min reads2:\t" + minReads2);
                System.err.println("Min strands2:\t" + minStrands2);
                System.err.println("Min var freq:\t" + minVarFreq);
                System.err.println("Min freq for hom:\t" + minFreqForHom);
                System.err.println("Normal purity:\t" + normalPurity);
                System.err.println("Tumor purity:\t" + tumorPurity);
                System.err.println("Min avg qual:\t" + minAvgQual);
                System.err.println("P-value thresh:\t" + pValueThreshold);
                System.err.println("Somatic p-value:\t" + somaticPvalue);
                if (params.containsKey("validation")) {
                    System.err.println("Validation mode: on");
                }
            }
            catch (Exception e) {
                System.err.println("Input Parameter Threw Exception: " + e.getLocalizedMessage());
                e.printStackTrace(System.err);
                System.exit(1);
            }
            if (params.containsKey("help") || params.containsKey("h")) {
                System.err.println(usage);
                return;
            }
            if (outputSnp.length() == 0 || outputIndel.length() == 0) {
                System.err.println("Please provide an output basename or SNP/indel output files!");
                System.err.println(usage);
                System.exit(1);
            }
            long tumorPositions = 0L;
            long sharedPositions = 0L;
            long comparedPositions = 0L;
            long calledReference = 0L;
            long indelFilter = 0L;
            long strandFilter = 0L;
            long calledGermline = 0L;
            long calledLOH = 0L;
            long calledSomatic = 0L;
            long calledUnknown = 0L;
            long calledVariant = 0L;
            try {
                BufferedReader in = VarScan.getInfile(args);
                if (in == null) {
                    System.out.println(usage);
                    return;
                }
                int numNaps = 0;
                while (!in.ready()) {
                    try {
                        Thread.sleep(5000L);
                        if (++numNaps <= 100) continue;
                        System.err.println("Input file was not ready after 100 5-second cycles!");
                        System.exit(10);
                    }
                    catch (Exception e) {
                        System.err.println("Exception while trying to get input" + e.getMessage());
                        System.exit(1);
                    }
                }
                if (in != null && in.ready()) {
                    String line;
                    String chromNormal = "";
                    String chromTumor = "";
                    String refBase = "";
                    int posNormal = 0;
                    int posTumor = 0;
                    PrintStream outSnp = null;
                    PrintStream outIndel = null;
                    PrintStream outValidation = null;
                    Object outCopyNumber = null;
                    if (params.containsKey("output-vcf")) {
                        if (!outputSnp.contains(".vcf")) {
                            outputSnp = String.valueOf(outputSnp) + ".vcf";
                        }
                        if (!outputIndel.contains(".vcf")) {
                            outputIndel = String.valueOf(outputIndel) + ".vcf";
                        }
                    }
                    outSnp = new PrintStream(new FileOutputStream(outputSnp));
                    outIndel = new PrintStream(new FileOutputStream(outputIndel));
                    if (!params.containsKey("no-headers") && !params.containsKey("output-vcf")) {
                        outSnp.println("chrom\tposition\tref\tvar\tnormal_reads1\tnormal_reads2\tnormal_var_freq\tnormal_gt\ttumor_reads1\ttumor_reads2\ttumor_var_freq\ttumor_gt\tsomatic_status\tvariant_p_value\tsomatic_p_value\ttumor_reads1_plus\ttumor_reads1_minus\ttumor_reads2_plus\ttumor_reads2_minus\tnormal_reads1_plus\tnormal_reads1_minus\tnormal_reads2_plus\tnormal_reads2_minus");
                        outIndel.println("chrom\tposition\tref\tvar\tnormal_reads1\tnormal_reads2\tnormal_var_freq\tnormal_gt\ttumor_reads1\ttumor_reads2\ttumor_var_freq\ttumor_gt\tsomatic_status\tvariant_p_value\tsomatic_p_value\ttumor_reads1_plus\ttumor_reads1_minus\ttumor_reads2_plus\ttumor_reads2_minus\tnormal_reads1_plus\tnormal_reads1_minus\tnormal_reads2_plus\tnormal_reads2_minus");
                    }
                    if (params.containsKey("output-vcf")) {
                        outSnp.println(vcfHeader);
                        outIndel.println(vcfHeader);
                    }
                    if (params.containsKey("validation")) {
                        outValidation = new PrintStream(new FileOutputStream(String.valueOf(outputName) + ".validation"));
                        if (!params.containsKey("no-headers") && !params.containsKey("output-vcf")) {
                            outValidation.println("chrom\tposition\tref\tvar\tnormal_reads1\tnormal_reads2\tnormal_var_freq\tnormal_gt\ttumor_reads1\ttumor_reads2\ttumor_var_freq\ttumor_gt\tsomatic_status\tvariant_p_value\tsomatic_p_value\ttumor_reads1_plus\ttumor_reads1_minus\ttumor_reads2_plus\ttumor_reads2_minus");
                        }
                        if (params.containsKey("output-vcf")) {
                            outValidation.println(vcfHeader);
                        }
                    }
                    System.err.println("Reading mpileup input...");
                    int numParsingExceptions = 0;
                    while ((line = in.readLine()) != null) {
                        try {
                            String[] lineContents = line.split("\t", -1);
                            if (lineContents.length > 5 && lineContents[0].length() > 0 && lineContents[1].length() > 0 && lineContents[2].length() > 0 && lineContents[3].length() > 0) {
                                String lineTumor;
                                ++sharedPositions;
                                String refName = lineContents[0];
                                int position = Integer.parseInt(lineContents[1]);
                                refBase = lineContents[2].toUpperCase();
                                chromNormal = refName;
                                chromTumor = refName;
                                posNormal = position;
                                posTumor = position;
                                int normalOffset = 3;
                                int pileupDepthNormal = Integer.parseInt(lineContents[normalOffset]);
                                String normalBases = lineContents[normalOffset + 1];
                                String normalQualities = lineContents[normalOffset + 2];
                                int tumorOffset = 6;
                                int pileupDepthTumor = Integer.parseInt(lineContents[tumorOffset]);
                                String tumorBases = lineContents[tumorOffset + 1];
                                String tumorQualities = lineContents[tumorOffset + 2];
                                String lineNormal = String.valueOf(refName) + "\t" + position + "\t" + refBase + "\t" + pileupDepthNormal + "\t" + normalBases + "\t" + normalQualities;
                                String compareResult = Somatic.comparePositions(lineNormal, lineTumor = String.valueOf(refName) + "\t" + position + "\t" + refBase + "\t" + pileupDepthTumor + "\t" + tumorBases + "\t" + tumorQualities, minCoverage, minReads2, minVarFreq, minAvgQual, pValueThreshold, somaticPvalue, minFreqForHom, normalPurity, tumorPurity);
                                if (compareResult.length() > 0) {
                                    String[] compareContents = compareResult.split("\t");
                                    String allele1 = compareContents[0];
                                    String allele2 = compareContents[1];
                                    double strandedness1 = 0.5;
                                    double strandedness2 = 0.5;
                                    double strandednessDiff = 0.0;
                                    if (compareContents.length >= 17) {
                                        try {
                                            int tumorReads1plus = Integer.parseInt(compareContents[13]);
                                            int tumorReads1minus = Integer.parseInt(compareContents[14]);
                                            int tumorReads2plus = Integer.parseInt(compareContents[15]);
                                            int tumorReads2minus = Integer.parseInt(compareContents[16]);
                                            if (tumorReads1plus > 0 || tumorReads1minus > 0) {
                                                strandedness1 = (double)tumorReads1plus / (double)(tumorReads1plus + tumorReads1minus);
                                            }
                                            if (tumorReads2plus > 0 || tumorReads2minus > 0) {
                                                strandedness2 = (double)tumorReads2plus / (double)(tumorReads2plus + tumorReads2minus);
                                                if (tumorReads1plus > 0 || tumorReads1minus > 0) {
                                                    strandednessDiff = Math.abs(strandedness1 - strandedness2);
                                                }
                                            }
                                        }
                                        catch (Exception tumorReads1plus) {
                                            // empty catch block
                                        }
                                    }
                                    ++comparedPositions;
                                    if (params.containsKey("verbose") && !compareResult.contains("Reference")) {
                                        System.err.println(String.valueOf(chromNormal) + "\t" + posNormal + "\t" + compareResult);
                                    }
                                    if (params.containsKey("output-vcf")) {
                                        int normalReads1 = Integer.parseInt(compareContents[2]);
                                        int normalReads2 = Integer.parseInt(compareContents[3]);
                                        String normalFreq = compareContents[4];
                                        String normalCall = compareContents[5];
                                        int tumorReads1 = Integer.parseInt(compareContents[6]);
                                        int tumorReads2 = Integer.parseInt(compareContents[7]);
                                        String tumorFreq = compareContents[8];
                                        String tumorCall = compareContents[9];
                                        String somStatus = compareContents[10];
                                        Double germlineP = Double.parseDouble(compareContents[11]);
                                        Double somaticP = Double.parseDouble(compareContents[12]);
                                        int totalDepth = pileupDepthNormal + pileupDepthTumor;
                                        if (allele2.startsWith("+")) {
                                            String varColumn = String.valueOf(allele1) + allele2.replace("+", "");
                                            compareResult = ".\t" + allele1 + "\t" + varColumn + "\t" + ".";
                                        } else if (allele2.startsWith("-")) {
                                            String refColumn = String.valueOf(allele1) + allele2.replace("-", "");
                                            compareResult = ".\t" + refColumn + "\t" + allele1 + "\t" + ".";
                                        } else {
                                            compareResult = ".\t" + allele1 + "\t" + allele2 + "\t" + ".";
                                        }
                                        compareResult = doStrandFilter && strandednessDiff > 0.1 && (strandedness2 < 0.1 || strandedness2 > 0.9) ? String.valueOf(compareResult) + "\tstr10" : (somStatus.equals("IndelFilter") ? String.valueOf(compareResult) + "\tindelError" : String.valueOf(compareResult) + "\tPASS");
                                        int ssCode = 0;
                                        double somScore = 0.0;
                                        if (somStatus.equals("Reference")) {
                                            ssCode = 0;
                                            ++calledReference;
                                        } else if (somStatus.equals("Germline")) {
                                            ssCode = 1;
                                            ++calledGermline;
                                            somScore = somaticP == 0.0 ? 0.0 : 0.0 - 10.0 * Math.log10(somaticP);
                                        } else if (somStatus.equals("Somatic")) {
                                            ssCode = 2;
                                            ++calledSomatic;
                                            somScore = somaticP == 0.0 ? 255.0 : 0.0 - 10.0 * Math.log10(somaticP);
                                        } else if (somStatus.equals("LOH")) {
                                            ssCode = 3;
                                            ++calledLOH;
                                            somScore = somaticP == 0.0 ? 255.0 : 0.0 - 10.0 * Math.log10(somaticP);
                                        } else {
                                            ++calledUnknown;
                                            ssCode = 5;
                                        }
                                        if (somScore > 255.0) {
                                            somScore = 255.0;
                                        }
                                        compareResult = String.valueOf(compareResult) + "\tDP=" + totalDepth;
                                        if (somStatus.equals("Somatic")) {
                                            compareResult = String.valueOf(compareResult) + ";SOMATIC";
                                        }
                                        compareResult = String.valueOf(compareResult) + ";SS=" + ssCode;
                                        compareResult = String.valueOf(compareResult) + ";SSC=" + (int)somScore;
                                        compareResult = String.valueOf(compareResult) + ";GPV=" + pvalueFormat.format(germlineP);
                                        compareResult = String.valueOf(compareResult) + ";SPV=" + pvalueFormat.format(somaticP);
                                        String tumorDP4 = "";
                                        String normalDP4 = "";
                                        if (compareContents.length >= 17) {
                                            try {
                                                tumorDP4 = String.valueOf(compareContents[13]) + "," + compareContents[14] + "," + compareContents[15] + "," + compareContents[16];
                                                normalDP4 = String.valueOf(compareContents[17]) + "," + compareContents[18] + "," + compareContents[19] + "," + compareContents[20];
                                            }
                                            catch (Exception e) {
                                                tumorDP4 = "";
                                                normalDP4 = "";
                                            }
                                        }
                                        compareResult = tumorDP4.length() > 0 ? String.valueOf(compareResult) + "\tGT:GQ:DP:RD:AD:FREQ:DP4" : String.valueOf(compareResult) + "\tGT:GQ:DP:RD:AD:FREQ";
                                        String normalGt = ".";
                                        String tumorGt = ".";
                                        normalGt = normalCall.equals(refBase) ? "0/0" : (VarScan.isHeterozygous(normalCall) ? "0/1" : "1/1");
                                        tumorGt = tumorCall.equals(refBase) ? "0/0" : (VarScan.isHeterozygous(tumorCall) ? "0/1" : "1/1");
                                        if (tumorDP4.length() > 0) {
                                            compareResult = String.valueOf(compareResult) + "\t" + normalGt + ":.:" + pileupDepthNormal + ":" + normalReads1 + ":" + normalReads2 + ":" + normalFreq + ":" + normalDP4;
                                            compareResult = String.valueOf(compareResult) + "\t" + tumorGt + ":.:" + pileupDepthTumor + ":" + tumorReads1 + ":" + tumorReads2 + ":" + tumorFreq + ":" + tumorDP4;
                                        } else {
                                            compareResult = String.valueOf(compareResult) + "\t" + normalGt + ":.:" + pileupDepthNormal + ":" + normalReads1 + ":" + normalReads2 + ":" + normalFreq;
                                            compareResult = String.valueOf(compareResult) + "\t" + tumorGt + ":.:" + pileupDepthTumor + ":" + tumorReads1 + ":" + tumorReads2 + ":" + tumorFreq;
                                        }
                                    }
                                    if (params.containsKey("validation")) {
                                        outValidation.println(String.valueOf(chromNormal) + "\t" + posNormal + "\t" + compareResult);
                                    }
                                    if (params.containsKey("validation") || !compareResult.contains("Reference") && !compareResult.contains("SS=0") && !compareResult.contains("Filter")) {
                                        if (doStrandFilter && strandednessDiff > 0.1 && (strandedness2 < 0.1 || strandedness2 > 0.9)) {
                                            if (!params.containsKey("output-vcf")) {
                                                compareResult = "StrandFilter";
                                            }
                                        } else if (allele1.contains("-") || allele1.contains("+") || allele2.contains("-") || allele2.contains("+")) {
                                            outIndel.println(String.valueOf(chromNormal) + "\t" + posNormal + "\t" + compareResult);
                                        } else {
                                            outSnp.println(String.valueOf(chromNormal) + "\t" + posNormal + "\t" + compareResult);
                                        }
                                    }
                                }
                                if (compareResult.contains("Reference")) {
                                    ++calledReference;
                                    continue;
                                }
                                if (compareResult.contains("IndelFilter")) {
                                    ++indelFilter;
                                    continue;
                                }
                                if (compareResult.contains("StrandFilter")) {
                                    ++strandFilter;
                                    continue;
                                }
                                if (compareResult.contains("Germline")) {
                                    ++calledGermline;
                                    continue;
                                }
                                if (compareResult.contains("Somatic")) {
                                    ++calledSomatic;
                                    continue;
                                }
                                if (compareResult.contains("LOH")) {
                                    ++calledLOH;
                                    continue;
                                }
                                if (compareResult.contains("Unknown")) {
                                    ++calledUnknown;
                                    continue;
                                }
                                if (!compareResult.contains("Variant")) continue;
                                ++calledVariant;
                                continue;
                            }
                            System.err.println("Error: Invalid format or not enough samples in mpileup: " + line + "\n");
                            return;
                        }
                        catch (Exception e) {
                            System.err.println("Parsing Exception on line:\n" + line + "\n" + e.getLocalizedMessage());
                            if (++numParsingExceptions >= 5) {
                                System.err.println("Too many parsing exceptions encountered; exiting");
                                return;
                            }
                            return;
                        }
                    }
                    in.close();
                    outSnp.close();
                    outIndel.close();
                    System.err.println(String.valueOf(sharedPositions) + " positions in mpileup file");
                    System.err.println(String.valueOf(comparedPositions) + " had sufficient coverage for comparison");
                    System.err.println(String.valueOf(calledReference) + " were called Reference");
                    System.err.println(String.valueOf(indelFilter) + " were mixed SNP-indel calls and filtered");
                    if (doStrandFilter) {
                        System.err.println(String.valueOf(strandFilter) + " were removed by the strand filter");
                    }
                    System.err.println(String.valueOf(calledGermline) + " were called Germline");
                    System.err.println(String.valueOf(calledLOH) + " were called LOH");
                    System.err.println(String.valueOf(calledSomatic) + " were called Somatic");
                    System.err.println(String.valueOf(calledUnknown) + " were called Unknown");
                    System.err.println(String.valueOf(calledVariant) + " were called Variant");
                    break block85;
                }
                System.err.println("Input file never ready for parsing (maybe due to file I/O)...");
                System.exit(10);
            }
            catch (IOException e) {
                System.err.println("File Parsing Exception: " + e.getLocalizedMessage());
                e.printStackTrace(System.err);
                System.exit(11);
            }
        }
    }

    public Somatic(String[] args) {
        String usage = "USAGE: VarScan somatic [normal_pileup] [tumor_pileup] [Opt: output] OPTIONS\n\tnormal_pileup - The SAMtools pileup file for Normal\n\ttumor_pileup - The SAMtools pileup file for Tumor\n\toutput - Output base name for SNP and indel output\n\nOPTIONS:\n\t--output-snp - Output file for SNP calls [output.snp]\n\t--output-indel - Output file for indel calls [output.indel]\n\t--min-coverage - Minimum coverage in normal and tumor to call variant [8]\n\t--min-coverage-normal - Minimum coverage in normal to call somatic [8]\n\t--min-coverage-tumor - Minimum coverage in tumor to call somatic [6]\n\t--min-var-freq - Minimum variant frequency to call a heterozygote [0.10]\n\t--min-freq-for-hom\tMinimum frequency to call homozygote [0.75]\n\t--normal-purity - Estimated purity (non-tumor content) of normal sample [1.00]\n\t--tumor-purity - Estimated purity (tumor content) of tumor sample [1.00]\n\t--p-value - P-value threshold to call a heterozygote [0.99]\n\t--somatic-p-value - P-value threshold to call a somatic site [0.05]\n\t--strand-filter - If set to 1, removes variants with >90% strand bias [0]\n\t--validation - If set to 1, outputs all compared positions even if non-variant\n\t--output-vcf - If set to 1, output VCF instead of VarScan native format\n";
        String vcfHeader = "##fileformat=VCFv4.1";
        vcfHeader = String.valueOf(vcfHeader) + "\n##source=VarScan2";
        vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=DP,Number=1,Type=Integer,Description=\"Total depth of quality bases\">";
        vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=SOMATIC,Number=0,Type=Flag,Description=\"Indicates if record is a somatic mutation\">";
        vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=SS,Number=1,Type=String,Description=\"Somatic status of variant (0=Reference,1=Germline,2=Somatic,3=LOH, or 5=Unknown)\">";
        vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=SSC,Number=1,Type=String,Description=\"Somatic score in Phred scale (0-255) derived from somatic p-value\">";
        vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=GPV,Number=1,Type=Float,Description=\"Fisher's Exact Test P-value of tumor+normal versus no variant for Germline calls\">";
        vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=SPV,Number=1,Type=Float,Description=\"Fisher's Exact Test P-value of tumor versus normal for Somatic/LOH calls\">";
        vcfHeader = String.valueOf(vcfHeader) + "\n##FILTER=<ID=str10,Description=\"Less than 10% or more than 90% of variant supporting reads on one strand\">";
        vcfHeader = String.valueOf(vcfHeader) + "\n##FILTER=<ID=indelError,Description=\"Likely artifact due to indel reads at this position\">";
        vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=GT,Number=1,Type=String,Description=\"Genotype\">";
        vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=GQ,Number=1,Type=Integer,Description=\"Genotype Quality\">";
        vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=DP,Number=1,Type=Integer,Description=\"Read Depth\">";
        vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=RD,Number=1,Type=Integer,Description=\"Depth of reference-supporting bases (reads1)\">";
        vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=AD,Number=1,Type=Integer,Description=\"Depth of variant-supporting bases (reads2)\">";
        vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=FREQ,Number=1,Type=String,Description=\"Variant allele frequency\">";
        vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=DP4,Number=1,Type=String,Description=\"Strand read counts: ref/fwd, ref/rev, var/fwd, var/rev\">";
        vcfHeader = String.valueOf(vcfHeader) + "\n#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT\tNORMAL\tTUMOR";
        if (args.length < 3) {
            System.err.println(usage);
            System.exit(1);
        }
        String normalPileupFile = args[1];
        String tumorPileupFile = args[2];
        String outputName = "output";
        String outputSnp = "";
        String outputIndel = "";
        String outputCopy = "";
        if (args.length >= 4 && !args[3].startsWith("-")) {
            outputName = args[3];
            outputSnp = String.valueOf(outputName) + ".snp";
            outputIndel = String.valueOf(outputName) + ".indel";
        }
        System.err.println("Normal Pileup: " + normalPileupFile);
        System.err.println("Tumor Pileup: " + tumorPileupFile);
        int minCoverage = 8;
        int minCoverageNormal = 8;
        int minCoverageTumor = 6;
        int minReads2 = 2;
        int minStrands2 = 1;
        int minAvgQual = 15;
        double normalPurity = 1.0;
        double tumorPurity = 1.0;
        double dataRatio = 1.0;
        double minVarFreq = 0.2;
        double pValueThreshold = 0.99;
        double somaticPvalue = 0.05;
        double minFreqForHom = 0.75;
        HashMap params = VarScan.getParams(args);
        try {
            if (params.containsKey("output-snp")) {
                outputSnp = (String)params.get("output-snp");
            }
            if (params.containsKey("output-indel")) {
                outputIndel = (String)params.get("output-indel");
            }
            if (params.containsKey("min-coverage")) {
                minCoverageNormal = minCoverage = Integer.parseInt((String)params.get("min-coverage"));
                minCoverageTumor = minCoverage;
            }
            if (params.containsKey("min-coverage-normal")) {
                minCoverageNormal = Integer.parseInt((String)params.get("min-coverage-normal"));
            }
            if (params.containsKey("min-coverage-tumor")) {
                minCoverageTumor = Integer.parseInt((String)params.get("min-coverage-tumor"));
            }
            if (params.containsKey("min-reads2")) {
                minReads2 = Integer.parseInt((String)params.get("min-reads2"));
            }
            if (params.containsKey("min-strands2")) {
                minStrands2 = Integer.parseInt((String)params.get("min-strands2"));
            }
            if (params.containsKey("min-var-freq")) {
                minVarFreq = Double.parseDouble((String)params.get("min-var-freq"));
            }
            if (params.containsKey("min-freq-for-hom")) {
                minFreqForHom = Double.parseDouble((String)params.get("min-freq-for-hom"));
            }
            if (params.containsKey("min-avg-qual")) {
                minAvgQual = Integer.parseInt((String)params.get("min-avg-qual"));
            }
            if (params.containsKey("p-value")) {
                pValueThreshold = Double.parseDouble((String)params.get("p-value"));
            }
            if (params.containsKey("somatic-p-value")) {
                somaticPvalue = Double.parseDouble((String)params.get("somatic-p-value"));
            }
            if (params.containsKey("data-ratio")) {
                dataRatio = Double.parseDouble((String)params.get("data-ratio"));
            }
            if (params.containsKey("normal-purity") && (normalPurity = Double.parseDouble((String)params.get("normal-purity"))) > 1.0) {
                normalPurity /= 100.0;
            }
            if (params.containsKey("tumor-purity") && (tumorPurity = Double.parseDouble((String)params.get("tumor-purity"))) > 1.0) {
                tumorPurity = normalPurity / 100.0;
            }
            System.err.println("Min coverage:\t" + minCoverageNormal + "x for Normal, " + minCoverageTumor + "x for Tumor");
            System.err.println("Min reads2:\t" + minReads2);
            System.err.println("Min strands2:\t" + minStrands2);
            System.err.println("Min var freq:\t" + minVarFreq);
            System.err.println("Min freq for hom:\t" + minFreqForHom);
            System.err.println("Normal purity:\t" + normalPurity);
            System.err.println("Tumor purity:\t" + tumorPurity);
            System.err.println("Min avg qual:\t" + minAvgQual);
            System.err.println("P-value thresh:\t" + pValueThreshold);
            System.err.println("Somatic p-value:\t" + somaticPvalue);
            if (params.containsKey("validation")) {
                System.err.println("Validation mode: on");
            }
        }
        catch (Exception e) {
            System.err.println("Input Parameter Threw Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        if (params.containsKey("help") || params.containsKey("h")) {
            System.err.println(usage);
            return;
        }
        if (args.length < 3 && (outputSnp.length() == 0 || outputIndel.length() == 0)) {
            System.err.println("Please provide SNP and Indel output files!");
            System.err.println(usage);
            System.exit(1);
        }
        long tumorPositions = 0L;
        long sharedPositions = 0L;
        long comparedPositions = 0L;
        long calledReference = 0L;
        long indelFilter = 0L;
        long strandFilter = 0L;
        long calledGermline = 0L;
        long calledLOH = 0L;
        long calledSomatic = 0L;
        long calledUnknown = 0L;
        long calledVariant = 0L;
        DecimalFormat pvalueFormat = new DecimalFormat("0.####E0");
        try {
            String lineTumor;
            String[] normalContents;
            PrintStream outSnp = null;
            PrintStream outIndel = null;
            PrintStream outValidation = null;
            Object outCopyNumber = null;
            if (params.containsKey("output-vcf")) {
                if (!outputSnp.contains(".vcf")) {
                    outputSnp = String.valueOf(outputSnp) + ".vcf";
                }
                if (!outputIndel.contains(".vcf")) {
                    outputIndel = String.valueOf(outputIndel) + ".vcf";
                }
            }
            outSnp = new PrintStream(new FileOutputStream(outputSnp));
            outIndel = new PrintStream(new FileOutputStream(outputIndel));
            if (!params.containsKey("no-headers") && !params.containsKey("output-vcf")) {
                outSnp.println("chrom\tposition\tref\tvar\tnormal_reads1\tnormal_reads2\tnormal_var_freq\tnormal_gt\ttumor_reads1\ttumor_reads2\ttumor_var_freq\ttumor_gt\tsomatic_status\tvariant_p_value\tsomatic_p_value\ttumor_reads1_plus\ttumor_reads1_minus\ttumor_reads2_plus\ttumor_reads2_minus\tnormal_reads1_plus\tnormal_reads1_minus\tnormal_reads2_plus\tnormal_reads2_minus");
                outIndel.println("chrom\tposition\tref\tvar\tnormal_reads1\tnormal_reads2\tnormal_var_freq\tnormal_gt\ttumor_reads1\ttumor_reads2\ttumor_var_freq\ttumor_gt\tsomatic_status\tvariant_p_value\tsomatic_p_value\ttumor_reads1_plus\ttumor_reads1_minus\ttumor_reads2_plus\ttumor_reads2_minus\tnormal_reads1_plus\tnormal_reads1_minus\tnormal_reads2_plus\tnormal_reads2_minus");
            }
            if (params.containsKey("output-vcf")) {
                outSnp.println(vcfHeader);
                outIndel.println(vcfHeader);
            }
            if (params.containsKey("validation")) {
                outValidation = new PrintStream(new FileOutputStream(String.valueOf(outputName) + ".validation"));
                if (!params.containsKey("no-headers") && !params.containsKey("output-vcf")) {
                    outValidation.println("chrom\tposition\tref\tvar\tnormal_reads1\tnormal_reads2\tnormal_var_freq\tnormal_gt\ttumor_reads1\ttumor_reads2\ttumor_var_freq\ttumor_gt\tsomatic_status\tvariant_p_value\tsomatic_p_value\ttumor_reads1_plus\ttumor_reads1_minus\ttumor_reads2_plus\ttumor_reads2_minus\tnormal_reads1_plus\tnormal_reads1_minus\tnormal_reads2_plus\tnormal_reads2_minus");
                }
                if (params.containsKey("output-vcf")) {
                    outValidation.println(vcfHeader);
                }
            }
            BufferedReader normal = new BufferedReader(new FileReader(normalPileupFile));
            BufferedReader tumor = new BufferedReader(new FileReader(tumorPileupFile));
            int numNaps = 0;
            while (!normal.ready() || !tumor.ready()) {
                try {
                    Thread.sleep(5000L);
                    if (++numNaps <= 100) continue;
                    System.err.println("Input file(s) were not ready for parsing after 100 5-second cycles! Pileup output may be invalid or too slow");
                    System.exit(10);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!normal.ready() || !tumor.ready()) {
                System.err.println("ERROR: Input file(s) not ready for parsing! Pileup output may be invalid or too slow.");
                System.exit(10);
            }
            String chromNormal = "";
            String chromTumor = "";
            String prevChromNormal = "";
            String prevChromTumor = "";
            String refBase = "";
            int posNormal = 0;
            int posTumor = 0;
            DecimalFormat oneDigit = new DecimalFormat("#0.0");
            DecimalFormat threeDigits = new DecimalFormat("#0.000");
            String lineNormal = normal.readLine();
            if (lineNormal != null && (normalContents = lineNormal.split("\t")).length > 1) {
                chromNormal = normalContents[0];
                posNormal = Integer.parseInt(normalContents[1]);
            }
            while ((lineTumor = tumor.readLine()) != null) {
                String[] normalContents2;
                ++tumorPositions;
                String[] tumorContents = lineTumor.split("\t");
                if (tumorContents.length > 1) {
                    chromTumor = tumorContents[0];
                    posTumor = Integer.parseInt(tumorContents[1]);
                }
                boolean flagEOF = false;
                boolean normalWasReset = false;
                while (!(chromNormal.equals(chromTumor) || chromTumor.equals(prevChromTumor) || flagEOF || !chromNormal.equals(prevChromTumor) && !Somatic.inSortOrder(chromNormal, chromTumor))) {
                    lineNormal = normal.readLine();
                    if (lineNormal != null) {
                        normalContents2 = lineNormal.split("\t");
                        if (normalContents2.length <= 1) continue;
                        chromNormal = normalContents2[0];
                        posNormal = Integer.parseInt(normalContents2[1]);
                        continue;
                    }
                    flagEOF = true;
                }
                if (chromNormal.equals(chromTumor) && !chromNormal.equals("")) {
                    normalWasReset = false;
                    while (chromNormal.equals(chromTumor) && posNormal < posTumor && (lineNormal = normal.readLine()) != null) {
                        normalContents2 = lineNormal.split("\t");
                        if (normalContents2.length <= 1) continue;
                        chromNormal = normalContents2[0];
                        posNormal = Integer.parseInt(normalContents2[1]);
                    }
                    while (chromNormal.equals(chromTumor) && posTumor < posNormal && (lineTumor = tumor.readLine()) != null) {
                        tumorContents = lineTumor.split("\t");
                        if (tumorContents.length <= 1) continue;
                        chromTumor = tumorContents[0];
                        posTumor = Integer.parseInt(tumorContents[1]);
                    }
                    if (!chromNormal.equals(chromTumor) || !chromNormal.equals(chromTumor) || posNormal != posTumor) continue;
                    ++sharedPositions;
                    if (params.containsKey("verbose")) {
                        System.err.println("Comparing calls at " + chromTumor + ":" + posTumor);
                    }
                    refBase = tumorContents[2];
                    String compareResult = Somatic.comparePositions(lineNormal, lineTumor, minCoverage, minReads2, minVarFreq, minAvgQual, pValueThreshold, somaticPvalue, minFreqForHom, normalPurity, tumorPurity);
                    if (compareResult.length() > 0) {
                        String[] compareContents = compareResult.split("\t");
                        String allele1 = compareContents[0];
                        String allele2 = compareContents[1];
                        double strandedness1 = 0.5;
                        double strandedness2 = 0.5;
                        double strandednessDiff = 0.0;
                        if (compareContents.length >= 17) {
                            try {
                                int tumorReads1plus = Integer.parseInt(compareContents[13]);
                                int tumorReads1minus = Integer.parseInt(compareContents[14]);
                                int tumorReads2plus = Integer.parseInt(compareContents[15]);
                                int tumorReads2minus = Integer.parseInt(compareContents[16]);
                                if (tumorReads1plus > 0 || tumorReads1minus > 0) {
                                    strandedness1 = (double)tumorReads1plus / (double)(tumorReads1plus + tumorReads1minus);
                                }
                                if (tumorReads2plus > 0 || tumorReads2minus > 0) {
                                    strandedness2 = (double)tumorReads2plus / (double)(tumorReads2plus + tumorReads2minus);
                                    if (tumorReads1plus > 0 || tumorReads1minus > 0) {
                                        strandednessDiff = Math.abs(strandedness1 - strandedness2);
                                    }
                                }
                            }
                            catch (Exception tumorReads1plus) {
                                // empty catch block
                            }
                        }
                        ++comparedPositions;
                        if (params.containsKey("verbose") && !compareResult.contains("Reference")) {
                            System.err.println(String.valueOf(chromNormal) + "\t" + posNormal + "\t" + compareResult);
                        }
                        if (params.containsKey("output-vcf")) {
                            int normalReads1 = Integer.parseInt(compareContents[2]);
                            int normalReads2 = Integer.parseInt(compareContents[3]);
                            String normalFreq = compareContents[4];
                            String normalCall = compareContents[5];
                            int tumorReads1 = Integer.parseInt(compareContents[6]);
                            int tumorReads2 = Integer.parseInt(compareContents[7]);
                            String tumorFreq = compareContents[8];
                            String tumorCall = compareContents[9];
                            String somStatus = compareContents[10];
                            Double germlineP = Double.parseDouble(compareContents[11]);
                            Double somaticP = Double.parseDouble(compareContents[12]);
                            String[] normalContents3 = lineNormal.split("\t");
                            int pileupDepthNormal = Integer.parseInt(normalContents3[3]);
                            int pileupDepthTumor = Integer.parseInt(tumorContents[3]);
                            int totalDepth = pileupDepthNormal + pileupDepthTumor;
                            if (allele2.startsWith("+")) {
                                String varColumn = String.valueOf(allele1) + allele2.replace("+", "");
                                compareResult = ".\t" + allele1 + "\t" + varColumn + "\t" + ".";
                            } else if (allele2.startsWith("-")) {
                                String refColumn = String.valueOf(allele1) + allele2.replace("-", "");
                                compareResult = ".\t" + refColumn + "\t" + allele1 + "\t" + ".";
                            } else {
                                compareResult = ".\t" + allele1 + "\t" + allele2 + "\t" + ".";
                            }
                            compareResult = params.containsKey("strand-filter") && strandednessDiff > 0.1 && (strandedness2 < 0.1 || strandedness2 > 0.9) ? String.valueOf(compareResult) + "\tstr10" : (somStatus.equals("IndelFilter") ? String.valueOf(compareResult) + "\tindelError" : String.valueOf(compareResult) + "\tPASS");
                            int ssCode = 0;
                            double somScore = 0.0;
                            if (somStatus.equals("Reference")) {
                                ssCode = 0;
                                ++calledReference;
                            } else if (somStatus.equals("Germline")) {
                                ssCode = 1;
                                ++calledGermline;
                                somScore = somaticP == 0.0 ? 0.0 : 0.0 - 10.0 * Math.log10(somaticP);
                            } else if (somStatus.equals("Somatic")) {
                                ssCode = 2;
                                ++calledSomatic;
                                somScore = somaticP == 0.0 ? 255.0 : 0.0 - 10.0 * Math.log10(somaticP);
                            } else if (somStatus.equals("LOH")) {
                                ssCode = 3;
                                ++calledLOH;
                                somScore = somaticP == 0.0 ? 255.0 : 0.0 - 10.0 * Math.log10(somaticP);
                            } else {
                                ++calledUnknown;
                                ssCode = 5;
                            }
                            if (somScore > 255.0) {
                                somScore = 255.0;
                            }
                            compareResult = String.valueOf(compareResult) + "\tDP=" + totalDepth;
                            if (somStatus.equals("Somatic")) {
                                compareResult = String.valueOf(compareResult) + ";SOMATIC";
                            }
                            compareResult = String.valueOf(compareResult) + ";SS=" + ssCode;
                            compareResult = String.valueOf(compareResult) + ";SSC=" + (int)somScore;
                            compareResult = String.valueOf(compareResult) + ";GPV=" + pvalueFormat.format(germlineP);
                            compareResult = String.valueOf(compareResult) + ";SPV=" + pvalueFormat.format(somaticP);
                            String tumorDP4 = "";
                            String normalDP4 = "";
                            if (compareContents.length >= 17) {
                                try {
                                    tumorDP4 = String.valueOf(compareContents[13]) + "," + compareContents[14] + "," + compareContents[15] + "," + compareContents[16];
                                    normalDP4 = String.valueOf(compareContents[17]) + "," + compareContents[18] + "," + compareContents[19] + "," + compareContents[20];
                                }
                                catch (Exception e) {
                                    tumorDP4 = "";
                                    normalDP4 = "";
                                }
                            }
                            compareResult = tumorDP4.length() > 0 ? String.valueOf(compareResult) + "\tGT:GQ:DP:RD:AD:FREQ:DP4" : String.valueOf(compareResult) + "\tGT:GQ:DP:RD:AD:FREQ";
                            String normalGt = ".";
                            String tumorGt = ".";
                            normalGt = normalCall.equals(refBase) ? "0/0" : (VarScan.isHeterozygous(normalCall) ? "0/1" : "1/1");
                            tumorGt = tumorCall.equals(refBase) ? "0/0" : (VarScan.isHeterozygous(tumorCall) ? "0/1" : "1/1");
                            if (tumorDP4.length() > 0) {
                                compareResult = String.valueOf(compareResult) + "\t" + normalGt + ":.:" + pileupDepthNormal + ":" + normalReads1 + ":" + normalReads2 + ":" + normalFreq + ":" + normalDP4;
                                compareResult = String.valueOf(compareResult) + "\t" + tumorGt + ":.:" + pileupDepthTumor + ":" + tumorReads1 + ":" + tumorReads2 + ":" + tumorFreq + ":" + tumorDP4;
                            } else {
                                compareResult = String.valueOf(compareResult) + "\t" + normalGt + ":.:" + pileupDepthNormal + ":" + normalReads1 + ":" + normalReads2 + ":" + normalFreq;
                                compareResult = String.valueOf(compareResult) + "\t" + tumorGt + ":.:" + pileupDepthTumor + ":" + tumorReads1 + ":" + tumorReads2 + ":" + tumorFreq;
                            }
                        }
                        if (params.containsKey("validation")) {
                            outValidation.println(String.valueOf(chromNormal) + "\t" + posNormal + "\t" + compareResult);
                        }
                        if (params.containsKey("validation") || !compareResult.contains("Reference") && !compareResult.contains("SS=0") && !compareResult.contains("Filter")) {
                            if (params.containsKey("strand-filter") && strandednessDiff > 0.1 && (strandedness2 < 0.1 || strandedness2 > 0.9)) {
                                compareResult = "StrandFilter";
                            } else if (allele1.contains("-") || allele1.contains("+") || allele2.contains("-") || allele2.contains("+")) {
                                outIndel.println(String.valueOf(chromNormal) + "\t" + posNormal + "\t" + compareResult);
                            } else {
                                outSnp.println(String.valueOf(chromNormal) + "\t" + posNormal + "\t" + compareResult);
                            }
                        }
                    }
                    if (compareResult.contains("Reference")) {
                        ++calledReference;
                    } else if (compareResult.contains("IndelFilter")) {
                        ++indelFilter;
                    } else if (compareResult.contains("StrandFilter")) {
                        ++strandFilter;
                    } else if (compareResult.contains("Germline")) {
                        ++calledGermline;
                    } else if (compareResult.contains("Somatic")) {
                        ++calledSomatic;
                    } else if (compareResult.contains("LOH")) {
                        ++calledLOH;
                    } else if (compareResult.contains("Unknown")) {
                        ++calledUnknown;
                    } else if (compareResult.contains("Variant")) {
                        ++calledVariant;
                    }
                    prevChromNormal = chromNormal;
                    prevChromTumor = chromTumor;
                    continue;
                }
                if (Somatic.inSortOrder(chromNormal, chromTumor)) {
                    System.err.println("Not resetting normal file because " + chromNormal + " < " + chromTumor);
                    continue;
                }
                if (!flagEOF) continue;
                flagEOF = false;
                while (prevChromTumor.equals(chromTumor) && !flagEOF) {
                    lineTumor = tumor.readLine();
                    if (lineTumor != null) {
                        tumorContents = lineTumor.split("\t");
                        if (tumorContents.length <= 1) continue;
                        chromTumor = tumorContents[0];
                        posTumor = Integer.parseInt(tumorContents[1]);
                        continue;
                    }
                    flagEOF = true;
                }
                if (flagEOF || normalWasReset) continue;
                if (Somatic.inSortOrder(chromNormal, chromTumor)) {
                    System.err.println("Not resetting normal file because " + chromNormal + " < " + chromTumor);
                    continue;
                }
                System.err.println("Resetting normal file because " + chromNormal + " > " + chromTumor);
                normalWasReset = true;
                normal.close();
                normal = new BufferedReader(new FileReader(normalPileupFile));
            }
            normal.close();
            tumor.close();
            outSnp.close();
            outIndel.close();
            System.err.println(String.valueOf(tumorPositions) + " positions in tumor");
            System.err.println(String.valueOf(sharedPositions) + " positions shared in normal");
            System.err.println(String.valueOf(comparedPositions) + " had sufficient coverage for comparison");
            System.err.println(String.valueOf(calledReference) + " were called Reference");
            System.err.println(String.valueOf(indelFilter) + " were mixed SNP-indel calls and filtered");
            if (params.containsKey("strand-filter")) {
                System.err.println(String.valueOf(strandFilter) + " were removed by the strand filter");
            }
            System.err.println(String.valueOf(calledGermline) + " were called Germline");
            System.err.println(String.valueOf(calledLOH) + " were called LOH");
            System.err.println(String.valueOf(calledSomatic) + " were called Somatic");
            System.err.println(String.valueOf(calledUnknown) + " were called Unknown");
            System.err.println(String.valueOf(calledVariant) + " were called Variant");
        }
        catch (IOException e) {
            System.err.println("File Parsing Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            System.exit(11);
        }
    }

    static boolean inSortOrder(String chrom1, String chrom2) {
        Object[] testArray = new String[]{chrom1, chrom2};
        Arrays.sort(testArray);
        return ((String)testArray[0]).equals(chrom1);
    }

    static String comparePositions(String lineNormal, String lineTumor, int minCoverage, int minReads2, double minVarFreq, int minAvgQual, double pValueThreshold, double somaticPvalue, double minFreqForHom, double normalPurity, double tumorPurity) {
        block68: {
            block70: {
                int totalReads1;
                HashMap<String, String> readCountsNormal;
                String[] normalConsensusContents;
                String normalConsensus;
                String[] tumorConsensusContents;
                String tumorConsensus;
                double diffPvalue;
                double pValue;
                String allele2;
                String somaticStatus;
                String refBase;
                DecimalFormat df;
                block71: {
                    String normalConsensusLine;
                    String normalMapQuals;
                    String normalQualities;
                    String normalBases;
                    int normalDepth;
                    block69: {
                        try {
                            HashMap<String, String> readCountsTumor;
                            String tumorConsensusLine;
                            df = new DecimalFormat("###.##");
                            refBase = "";
                            normalDepth = 0;
                            normalBases = "";
                            normalQualities = "";
                            normalMapQuals = "";
                            int tumorDepth = 0;
                            String tumorBases = "";
                            String tumorQualities = "";
                            String tumorMapQuals = "";
                            String[] normalContents = lineNormal.split("\t");
                            refBase = normalContents[2].toUpperCase();
                            String[] tumorContents = lineTumor.split("\t");
                            if (normalContents.length >= 6 && normalContents.length <= 7) {
                                normalDepth = Integer.parseInt(normalContents[3]);
                                normalBases = normalContents[4];
                                normalQualities = normalContents[5];
                                normalMapQuals = "";
                                if (normalContents.length == 7) {
                                    normalMapQuals = normalContents[6];
                                }
                            } else if (normalContents.length >= 10 && normalContents.length <= 11) {
                                normalDepth = Integer.parseInt(normalContents[7]);
                                normalBases = normalContents[8];
                                normalQualities = normalContents[9];
                                normalMapQuals = "";
                                if (normalContents.length == 11) {
                                    normalMapQuals = normalContents[10];
                                }
                            }
                            if (tumorContents.length >= 6 && tumorContents.length <= 7) {
                                tumorDepth = Integer.parseInt(tumorContents[3]);
                                tumorBases = tumorContents[4];
                                tumorQualities = tumorContents[5];
                                tumorMapQuals = "";
                                if (tumorContents.length == 7) {
                                    tumorMapQuals = tumorContents[6];
                                }
                            } else if (tumorContents.length >= 10 && tumorContents.length <= 11) {
                                tumorDepth = Integer.parseInt(tumorContents[7]);
                                tumorBases = tumorContents[8];
                                tumorQualities = tumorContents[9];
                                tumorMapQuals = "";
                                if (tumorContents.length == 11) {
                                    tumorMapQuals = tumorContents[10];
                                }
                            }
                            somaticStatus = "";
                            allele2 = "";
                            pValue = 1.0;
                            diffPvalue = 1.0;
                            if (tumorDepth < minCoverage || normalDepth < minCoverage) break block68;
                            double tumorMinVarFreq = minVarFreq;
                            if (tumorPurity < 1.0) {
                                tumorMinVarFreq = minVarFreq * tumorPurity;
                            }
                            if (!(tumorConsensus = (tumorConsensusContents = (tumorConsensusLine = VarScan.callPosition(refBase, readCountsTumor = VarScan.getReadCounts(refBase, tumorBases, tumorQualities, minAvgQual, tumorMapQuals), "CNS", minReads2, tumorMinVarFreq, minAvgQual, 0.99, minFreqForHom)).split("\t"))[0]).equals("N")) break block69;
                            return "";
                        }
                        catch (Exception e) {
                            System.err.println("Warning:");
                            e.printStackTrace(System.err);
                            return "";
                        }
                    }
                    if (normalDepth < minCoverage) break block70;
                    double normalMinVarFreq = minVarFreq;
                    if (normalPurity < 1.0) {
                        normalMinVarFreq = minVarFreq / normalPurity;
                    }
                    if (!(normalConsensus = (normalConsensusContents = (normalConsensusLine = VarScan.callPosition(refBase, readCountsNormal = VarScan.getReadCounts(refBase, normalBases, normalQualities, minAvgQual, normalMapQuals), "CNS", minReads2, normalMinVarFreq, minAvgQual, 0.99, minFreqForHom)).split("\t"))[0]).equals("N")) break block71;
                    return "";
                }
                int tumorReads1 = Integer.parseInt(tumorConsensusContents[1]);
                int tumorReads2 = Integer.parseInt(tumorConsensusContents[2]);
                int tumorCoverage = tumorReads1 + tumorReads2;
                String tumorAllele2 = VarScan.getVarAllele(refBase, tumorConsensusContents[0]);
                int tumorReads1plus = 0;
                int tumorReads1minus = 0;
                int tumorReads2plus = 0;
                int tumorReads2minus = 0;
                if (tumorConsensusContents.length > 14) {
                    tumorReads1plus = Integer.parseInt(tumorConsensusContents[11]);
                    tumorReads1minus = Integer.parseInt(tumorConsensusContents[12]);
                    tumorReads2plus = Integer.parseInt(tumorConsensusContents[13]);
                    tumorReads2minus = Integer.parseInt(tumorConsensusContents[14]);
                }
                int normalReads1plus = 0;
                int normalReads1minus = 0;
                int normalReads2plus = 0;
                int normalReads2minus = 0;
                if (normalConsensusContents.length > 14) {
                    normalReads1plus = Integer.parseInt(normalConsensusContents[11]);
                    normalReads1minus = Integer.parseInt(normalConsensusContents[12]);
                    normalReads2plus = Integer.parseInt(normalConsensusContents[13]);
                    normalReads2minus = Integer.parseInt(normalConsensusContents[14]);
                }
                int normalReads1 = Integer.parseInt(normalConsensusContents[1]);
                int normalReads2 = Integer.parseInt(normalConsensusContents[2]);
                int normalCoverage = normalReads1 + normalReads2;
                String normalAllele2 = VarScan.getVarAllele(refBase, normalConsensusContents[0]);
                if (!tumorAllele2.equals(refBase)) {
                    allele2 = tumorAllele2;
                    if (readCountsNormal.containsKey(tumorAllele2)) {
                        String[] alleleContents = readCountsNormal.get(tumorAllele2).split("\t");
                        normalReads2 = Integer.parseInt(alleleContents[0]);
                        normalCoverage = normalReads1 + normalReads2;
                    }
                } else if (!normalAllele2.equals(refBase)) {
                    allele2 = normalAllele2;
                } else if (tumorConsensusContents.length > 15) {
                    allele2 = tumorConsensusContents[15];
                } else if (tumorConsensusContents.length == 10) {
                    allele2 = tumorConsensusContents[9];
                } else if (normalConsensusContents.length > 15) {
                    allele2 = normalConsensusContents[15];
                } else if (normalConsensusContents.length == 10) {
                    allele2 = normalConsensusContents[9];
                }
                double normalFreq = (double)normalReads2 / (double)normalCoverage;
                double tumorFreq = (double)tumorReads2 / (double)tumorCoverage;
                double freqDiff = tumorFreq - normalFreq;
                diffPvalue = VarScan.getSignificance(normalReads1, normalReads2, tumorReads1, tumorReads2);
                String normalFreqPrint = String.valueOf(df.format(normalFreq * 100.0)) + "%";
                String tumorFreqPrint = String.valueOf(df.format(tumorFreq * 100.0)) + "%";
                if (normalConsensus.equals(tumorConsensus) && (normalConsensus.equals(refBase) || diffPvalue > somaticPvalue)) {
                    if (normalConsensus.equals(refBase)) {
                        somaticStatus = "Reference";
                    } else {
                        totalReads1 = normalReads1 + tumorReads1;
                        int totalReads2 = normalReads2 + tumorReads2;
                        int totalCoverage = totalReads1 + totalReads2;
                        pValue = VarScan.getSignificance(totalCoverage, 0, totalReads1, totalReads2);
                        if (pValue <= somaticPvalue) {
                            somaticStatus = "Germline";
                            allele2 = tumorAllele2;
                        } else {
                            somaticStatus = "Reference";
                            allele2 = refBase;
                        }
                    }
                } else {
                    normalConsensus.equals(tumorConsensus);
                    if (tumorConsensus.contains("/") && !normalConsensus.contains("/") && !normalConsensus.equals(refBase)) {
                        somaticStatus = "IndelFilter";
                    } else if (normalConsensus.contains("/") && !tumorConsensus.contains("/") && !tumorConsensus.equals(refBase)) {
                        somaticStatus = "IndelFilter";
                    } else if (diffPvalue <= somaticPvalue || normalFreq == 0.0) {
                        if (normalConsensus.equals(refBase) && VarScan.isHeterozygous(tumorConsensus) && tumorFreq > normalFreq) {
                            somaticStatus = "Somatic";
                            allele2 = tumorAllele2;
                        } else if (normalConsensus.equals(refBase) && VarScan.isHomozygous(tumorConsensus)) {
                            somaticStatus = "Somatic";
                            allele2 = tumorAllele2;
                        } else if (tumorConsensus.equals(refBase) && VarScan.isHeterozygous(normalConsensus)) {
                            somaticStatus = "LOH";
                            allele2 = normalAllele2;
                        } else if (VarScan.isHeterozygous(normalConsensus) && VarScan.isHomozygous(tumorConsensus)) {
                            somaticStatus = "LOH";
                            allele2 = tumorAllele2;
                        } else if (tumorAllele2.equals(normalAllele2)) {
                            if (normalFreq > minVarFreq) {
                                somaticStatus = "Germline";
                            } else if (freqDiff >= 0.3 && tumorFreq > normalFreq) {
                                somaticStatus = "Somatic";
                            } else if (freqDiff <= -0.3 && tumorFreq < normalFreq) {
                                somaticStatus = "LOH";
                            } else {
                                somaticStatus = "Germline";
                                totalReads1 = normalReads1 + tumorReads1;
                                int totalReads2 = normalReads2 + tumorReads2;
                                int totalCoverage = totalReads1 + totalReads2;
                                pValue = VarScan.getSignificance(totalCoverage, 0, totalReads1, totalReads2);
                            }
                            allele2 = tumorAllele2;
                        } else if (tumorFreq > normalFreq && VarScan.isHeterozygous(normalConsensus) && VarScan.isHeterozygous(tumorConsensus)) {
                            normalConsensus = refBase;
                            somaticStatus = "Somatic";
                            allele2 = tumorAllele2;
                        } else {
                            somaticStatus = "Unknown";
                            allele2 = tumorAllele2.equals(refBase) ? normalAllele2 : tumorAllele2;
                        }
                    } else if (tumorAllele2.equals(normalAllele2)) {
                        totalReads1 = normalReads1 + tumorReads1;
                        int totalReads2 = normalReads2 + tumorReads2;
                        int totalCoverage = totalReads1 + totalReads2;
                        pValue = VarScan.getSignificance(totalCoverage, 0, totalReads1, totalReads2);
                        if (pValue <= pValueThreshold) {
                            somaticStatus = "Germline";
                            allele2 = tumorAllele2;
                        } else {
                            somaticStatus = "Reference";
                            allele2 = refBase;
                        }
                    } else if (normalConsensus.equals(refBase)) {
                        somaticStatus = "Reference";
                        allele2 = tumorAllele2;
                    } else if (tumorConsensus.equals(refBase)) {
                        somaticStatus = "Reference";
                        allele2 = normalAllele2;
                    } else {
                        somaticStatus = "Unknown";
                        allele2 = String.valueOf(normalAllele2) + "/" + tumorAllele2;
                    }
                }
                String resultLine = String.valueOf(refBase) + "\t" + allele2 + "\t";
                resultLine = String.valueOf(resultLine) + normalReads1 + "\t" + normalReads2 + "\t" + normalFreqPrint + "\t" + normalConsensus + "\t";
                resultLine = String.valueOf(resultLine) + tumorReads1 + "\t" + tumorReads2 + "\t" + tumorFreqPrint + "\t" + tumorConsensus + "\t";
                resultLine = String.valueOf(resultLine) + somaticStatus + "\t" + pValue + "\t" + diffPvalue + "\t";
                resultLine = String.valueOf(resultLine) + tumorReads1plus + "\t" + tumorReads1minus + "\t";
                resultLine = String.valueOf(resultLine) + tumorReads2plus + "\t" + tumorReads2minus + "\t";
                resultLine = String.valueOf(resultLine) + normalReads1plus + "\t" + normalReads1minus + "\t";
                resultLine = String.valueOf(resultLine) + normalReads2plus + "\t" + normalReads2minus;
                return resultLine;
            }
            return "";
        }
        return "";
    }

    static Boolean chromSorted(String chrom1, String chrom2) {
        Boolean answer = false;
        chrom1.replace("X", "23");
        chrom1.replace("Y", "24");
        chrom1.replace("M", "25");
        chrom2.replace("X", "23");
        chrom2.replace("Y", "24");
        chrom2.replace("M", "25");
        String[] unsorted = new String[]{chrom1, chrom2};
        Object[] sorted = new String[]{chrom1, chrom2};
        Arrays.sort(sorted);
        System.err.println("Sorted order is " + (String)sorted[0] + " " + (String)sorted[1]);
        try {
            if (((String)sorted[0]).equals(unsorted[0])) {
                answer = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return answer;
    }
}

