/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import net.sf.varscan.VarScan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadCounts {
    public ReadCounts(String[] args, HashMap<String, String> params) {
        String usage = "USAGE: java -jar VarScan.jar readcounts [pileup] OPTIONS\n\tOPTIONS:\n\t--variants-file\tA list of variants at which to report readcounts\n\t--output-file\tOutput file to contain the readcounts\n\t--min-coverage\tMinimum read depth at a position to make a call [1]\n\t--min-base-qual\tMinimum base quality at a position to count a read [20]\n";
        String variantsFile = "";
        String outputFile = "";
        int minCoverage = 1;
        int minBaseQual = 20;
        try {
            if (params.containsKey("min-coverage")) {
                minCoverage = Integer.parseInt(params.get("min-coverage"));
            }
            if (params.containsKey("min-base-qual")) {
                minBaseQual = Integer.parseInt(params.get("min-base-qual"));
            }
            if (params.containsKey("variants-file")) {
                variantsFile = params.get("variants-file");
            }
            if (params.containsKey("output-file")) {
                outputFile = params.get("output-file");
            }
            System.err.println("Min coverage:\t" + minCoverage);
            System.err.println("Min base qual:\t" + minBaseQual);
        }
        catch (Exception e) {
            System.err.println("Input Parameter Threw Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        if (params.containsKey("help") || params.containsKey("h")) {
            System.err.println(usage);
            return;
        }
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        stats.put("numPositions", 0);
        stats.put("numIncluded", 0);
        stats.put("numCovered", 0);
        HashMap<Object, Object> variantPositions = new HashMap();
        if (params.containsKey("variants-file")) {
            System.err.println("Loading variant positions from " + variantsFile);
            variantPositions = ReadCounts.loadVariants(variantsFile);
            System.err.println(String.valueOf(variantPositions.size()) + " variant positions saved");
        }
        try {
            BufferedReader in;
            PrintStream out = null;
            if (params.containsKey("output-file")) {
                out = new PrintStream(new FileOutputStream(outputFile));
                out.println("chrom\tposition\tref_base\tdepth\tq" + minBaseQual + "_depth\tbase:reads:strands:avg_qual:map_qual:plus_reads:minus_reads");
            }
            if ((in = VarScan.getInfile(args)) == null) {
                System.out.println(usage);
                System.exit(10);
            }
            int numNaps = 0;
            if (!in.ready()) {
                try {
                    Thread.sleep(5000L);
                    if (++numNaps > 100) {
                        System.err.println("Input file was not ready after 100 5-second cycles!");
                        System.exit(10);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (in.ready()) {
                String line;
                while ((line = in.readLine()) != null) {
                    stats.put("numPositions", (Integer)stats.get("numPositions") + 1);
                    if (params.containsKey("verbose") && (Integer)stats.get("numPositions") % 100000 == 0) {
                        System.err.println(stats.get("numPositions") + " positions parsed...");
                    }
                    try {
                        String[] lineContents = line.split("\t");
                        if (lineContents.length > 5 && lineContents[0].length() > 0 && lineContents[1].length() > 0 && lineContents[2].length() > 0 && lineContents[3].length() > 0) {
                            String refName = lineContents[0];
                            String position = lineContents[1];
                            String refBase = lineContents[2].toUpperCase();
                            int readDepth = Integer.parseInt(lineContents[3]);
                            String readBases = lineContents[4];
                            String readQualities = lineContents[5];
                            String mapQualities = "";
                            if (lineContents.length > 6) {
                                mapQualities = lineContents[6];
                            }
                            if (params.containsKey("variants-file") && !variantPositions.containsKey(String.valueOf(refName) + "\t" + position)) continue;
                            stats.put("numIncluded", (Integer)stats.get("numIncluded") + 1);
                            String outputLine = String.valueOf(refName) + "\t" + position + "\t" + refBase + "\t" + readDepth + "\t";
                            if (readDepth >= minCoverage) {
                                stats.put("numCovered", (Integer)stats.get("numCovered") + 1);
                                HashMap<String, String> readCounts = VarScan.getReadCounts(refBase, readBases, readQualities, minBaseQual, mapQualities);
                                Object[] alleleKeys = readCounts.keySet().toArray(new String[0]);
                                Arrays.sort(alleleKeys);
                                int readDepthQual = VarScan.qualityDepth(readQualities, minBaseQual);
                                outputLine = String.valueOf(outputLine) + readDepthQual + "\t";
                                String refResult = "0\t0\t0\t0\t0\t0";
                                if (readCounts.containsKey(refBase)) {
                                    refResult = readCounts.get(refBase);
                                }
                                refResult = String.valueOf(refBase) + ":" + refResult.replace("\t", ":");
                                outputLine = String.valueOf(outputLine) + refResult + "\t";
                                String desiredAllele = "";
                                if (variantPositions.containsKey(String.valueOf(refName) + "\t" + position)) {
                                    try {
                                        String[] varContents = ((String)variantPositions.get(String.valueOf(refName) + "\t" + position)).split("\t");
                                        if (varContents.length > 1 && varContents[1].length() > 0) {
                                            desiredAllele = varContents[1];
                                            String varResult = "0\t0\t0\t0\t0\t0";
                                            if (readCounts.containsKey(desiredAllele)) {
                                                varResult = readCounts.get(desiredAllele);
                                            }
                                            outputLine = String.valueOf(outputLine) + desiredAllele + "\t" + varResult + "\t";
                                        }
                                    }
                                    catch (Exception e) {
                                        System.err.println("Warning: Error parsing variant position entry: " + (String)variantPositions.get(String.valueOf(refName) + "\t" + position) + "\n" + e.getLocalizedMessage());
                                        e.printStackTrace(System.err);
                                    }
                                }
                                Object[] objectArray = alleleKeys;
                                int n = alleleKeys.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object allele = objectArray[n2];
                                    String[] alleleContents = readCounts.get(allele).split("\t");
                                    if (!((String)allele).equals(refBase) && !((String)allele).equals(desiredAllele)) {
                                        try {
                                            int thisReads2 = Integer.parseInt(alleleContents[0]);
                                            int thisStrands2 = Integer.parseInt(alleleContents[1]);
                                            int thisAvgQual2 = Integer.parseInt(alleleContents[2]);
                                            int thisMapQual2 = Integer.parseInt(alleleContents[3]);
                                            int thisReads2plus = Integer.parseInt(alleleContents[4]);
                                            int thisReads2minus = Integer.parseInt(alleleContents[5]);
                                            String varResult = String.valueOf(allele) + ":" + thisReads2 + ":" + thisStrands2 + ":" + thisAvgQual2 + ":" + thisMapQual2 + ":" + thisReads2plus + ":" + thisReads2minus;
                                            outputLine = String.valueOf(outputLine) + varResult + "\t";
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    ++n2;
                                }
                                if (params.containsKey("output-file")) {
                                    out.println(outputLine);
                                    continue;
                                }
                                System.err.println(outputLine);
                                continue;
                            }
                            if (!variantPositions.containsKey(String.valueOf(refName) + "\t" + position)) continue;
                            if (params.containsKey("output-file")) {
                                out.println(outputLine);
                                continue;
                            }
                            System.err.println(outputLine);
                            continue;
                        }
                        System.err.println("Error: Invalid format for pileup at line " + stats.get("numBases") + "\n" + line + "\n");
                        return;
                    }
                    catch (Exception e) {
                        System.err.println("Parsing Exception on line:\n" + line + "\n" + e.getLocalizedMessage());
                        stats.put("numParsingExceptions", (Integer)stats.get("numParsingExceptions") + 1);
                        if ((Integer)stats.get("numParsingExceptions") >= 5) {
                            System.err.println("Too many parsing exceptions encountered; exiting");
                            return;
                        }
                        return;
                    }
                }
            } else {
                System.err.println("Input was not ready for parsing!");
                return;
            }
            in.close();
            if (params.containsKey("output-file")) {
                out.close();
            }
            System.err.println(stats.get("numPositions") + " positions in pileup file");
            System.err.println(stats.get("numIncluded") + " included in readcount analysis");
            System.err.println(stats.get("numCovered") + " met minimum coverage");
        }
        catch (Exception e) {
            System.err.println("Error parsing input: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            System.exit(11);
        }
    }

    static HashMap<String, String> loadVariants(String fileName) {
        HashMap<String, String> variants = new HashMap<String, String>();
        try {
            BufferedReader infile = new BufferedReader(new FileReader(fileName));
            String line = "";
            int lineCounter = 0;
            while ((line = infile.readLine()) != null) {
                ++lineCounter;
                String[] lineContents = line.split("\t");
                if (lineContents.length < 2) continue;
                try {
                    String refName = lineContents[0];
                    int position = Integer.parseInt(lineContents[1]);
                    String allele1 = "";
                    String allele2 = "";
                    try {
                        allele1 = lineContents[2];
                        allele2 = lineContents[3];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String positionKey = String.valueOf(refName) + "\t" + position;
                    variants.put(positionKey, String.valueOf(allele1) + "\t" + allele2);
                }
                catch (Exception e) {
                    if (lineCounter <= 1) continue;
                    System.err.println("Warning: Unable to parse chrom/position from " + line);
                }
            }
            infile.close();
        }
        catch (Exception e) {
            System.err.println("ERROR: File Parsing Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
        }
        return variants;
    }
}

