/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.HashMap;
import net.sf.varscan.VarScan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessSomatic {
    public ProcessSomatic(String[] args) {
        String usage = "USAGE: java -jar VarScan.jar process [status-file] OPTIONS\n\tstatus-file - The VarScan output file for SNPs or Indels\n\tOPTIONS\n\t--min-tumor-freq - Minimum variant allele frequency in tumor [0.10]\n\t--max-normal-freq - Maximum variant allele frequency in normal [0.05]\n\t--p-value - P-value for high-confidence calling [0.07]";
        HashMap params = VarScan.getParams(args);
        String statusFile = "varScan.output";
        double maxNormalFreq = 0.05;
        double minTumorFreq = 0.1;
        double pValueForHC = 0.07;
        try {
            if (params.containsKey("min-tumor-freq")) {
                minTumorFreq = Double.parseDouble((String)params.get("min-tumor-freq"));
            }
            if (params.containsKey("max-normal-freq")) {
                maxNormalFreq = Double.parseDouble((String)params.get("max-normal-freq"));
            }
            if (params.containsKey("p-value")) {
                pValueForHC = Double.parseDouble((String)params.get("p-value"));
            }
        }
        catch (Exception e) {
            System.err.println("Input Parameter Threw Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        if (params.containsKey("help") || params.containsKey("h")) {
            System.err.println(usage);
            return;
        }
        try {
            BufferedReader infile = VarScan.getInfile(args);
            if (infile == null) {
                System.out.println(usage);
                return;
            }
            int numNaps = 0;
            while (!infile.ready()) {
                try {
                    Thread.sleep(5000L);
                    if (++numNaps <= 100) continue;
                    System.err.println("Input file was not ready after 100 5-second cycles!");
                    System.exit(10);
                }
                catch (Exception e) {
                    System.err.println("Exception while trying to get input" + e.getMessage());
                    System.exit(1);
                }
            }
            if (args.length > 1) {
                statusFile = args[1];
            }
            PrintStream outSomatic = null;
            PrintStream outSomaticHC = null;
            PrintStream outGermline = null;
            PrintStream outGermlineHC = null;
            PrintStream outLOH = null;
            PrintStream outLOHHC = null;
            boolean isVCF = false;
            if (statusFile.endsWith(".vcf")) {
                isVCF = true;
                String nameString = statusFile.replace(".vcf", "");
                System.err.println("Opening output files: " + nameString + ".Somatic.vcf " + nameString + ".Germline.vcf " + nameString + ".LOH.vcf ");
                outSomatic = new PrintStream(new FileOutputStream(String.valueOf(nameString) + ".Somatic.vcf"));
                outSomaticHC = new PrintStream(new FileOutputStream(String.valueOf(nameString) + ".Somatic.hc.vcf"));
                outGermline = new PrintStream(new FileOutputStream(String.valueOf(nameString) + ".Germline.vcf"));
                outGermlineHC = new PrintStream(new FileOutputStream(String.valueOf(nameString) + ".Germline.hc.vcf"));
                outLOH = new PrintStream(new FileOutputStream(String.valueOf(nameString) + ".LOH.vcf"));
                outLOHHC = new PrintStream(new FileOutputStream(String.valueOf(nameString) + ".LOH.hc.vcf"));
            } else {
                System.err.println("Opening output files: " + statusFile + ".Somatic " + statusFile + ".Germline " + statusFile + ".LOH ");
                outSomatic = new PrintStream(new FileOutputStream(String.valueOf(statusFile) + ".Somatic"));
                outSomaticHC = new PrintStream(new FileOutputStream(String.valueOf(statusFile) + ".Somatic.hc"));
                outGermline = new PrintStream(new FileOutputStream(String.valueOf(statusFile) + ".Germline"));
                outGermlineHC = new PrintStream(new FileOutputStream(String.valueOf(statusFile) + ".Germline.hc"));
                outLOH = new PrintStream(new FileOutputStream(String.valueOf(statusFile) + ".LOH"));
                outLOHHC = new PrintStream(new FileOutputStream(String.valueOf(statusFile) + ".LOH.hc"));
            }
            int numProcessed = 0;
            int numSomatic = 0;
            int numSomaticHC = 0;
            int numGermline = 0;
            int numLOH = 0;
            int numGermlineHC = 0;
            int numLOHHC = 0;
            String line = "";
            int lineCounter = 0;
            while ((line = infile.readLine()) != null) {
                ++lineCounter;
                String[] lineContents = line.split("\t");
                if (lineContents.length < 1) continue;
                try {
                    String refName = lineContents[0];
                    if (line.startsWith("#")) {
                        isVCF = true;
                        outSomatic.println(line);
                        outSomaticHC.println(line);
                        outGermline.println(line);
                        outGermlineHC.println(line);
                        outLOH.println(line);
                        outLOHHC.println(line);
                        continue;
                    }
                    if (refName.equals("chrom") || refName.equals("Chrom")) {
                        outSomatic.println(line);
                        outSomaticHC.println(line);
                        outGermline.println(line);
                        outGermlineHC.println(line);
                        outLOH.println(line);
                        outLOHHC.println(line);
                        continue;
                    }
                    int position = Integer.parseInt(lineContents[1]);
                    int normalReads1 = 0;
                    int normalReads2 = 0;
                    int tumorReads1 = 0;
                    int tumorReads2 = 0;
                    String somaticStatus = "";
                    double somaticPvalue = 0.0;
                    if (isVCF) {
                        String info = lineContents[7];
                        String normal = lineContents[9];
                        String tumor = lineContents[10];
                        String[] infoContents = info.split(";");
                        int colCounter = 0;
                        while (colCounter < infoContents.length) {
                            String element = infoContents[colCounter];
                            String[] elementContents = element.split("=");
                            if (elementContents[0].equals("SS")) {
                                somaticStatus = elementContents[1];
                            } else if (elementContents[0].equals("GPV") && somaticStatus.equals("1")) {
                                somaticPvalue = Double.parseDouble(elementContents[1]);
                            } else if (elementContents[0].equals("SPV") && !somaticStatus.equals("1")) {
                                somaticPvalue = Double.parseDouble(elementContents[1]);
                            }
                            ++colCounter;
                        }
                        String[] normalContents = normal.split(":");
                        normalReads1 = Integer.parseInt(normalContents[3]);
                        normalReads2 = Integer.parseInt(normalContents[4]);
                        String[] tumorContents = tumor.split(":");
                        tumorReads1 = Integer.parseInt(tumorContents[3]);
                        tumorReads2 = Integer.parseInt(tumorContents[4]);
                    } else if (!refName.equals("chrom")) {
                        normalReads1 = Integer.parseInt(lineContents[4]);
                        normalReads2 = Integer.parseInt(lineContents[5]);
                        tumorReads1 = Integer.parseInt(lineContents[8]);
                        tumorReads2 = Integer.parseInt(lineContents[9]);
                        somaticStatus = lineContents[12];
                        somaticPvalue = Double.parseDouble(lineContents[14]);
                    }
                    double normalFreq = 0.0;
                    double tumorFreq = 0.0;
                    if (normalReads1 > 0 || normalReads2 > 0) {
                        normalFreq = (double)normalReads2 / (double)(normalReads1 + normalReads2);
                    }
                    if (tumorReads1 > 0 || tumorReads2 > 0) {
                        tumorFreq = (double)tumorReads2 / (double)(tumorReads1 + tumorReads2);
                    }
                    ++numProcessed;
                    if (somaticStatus.equals("Somatic") || somaticStatus.equals("2")) {
                        ++numSomatic;
                        outSomatic.println(line);
                        if (!(normalFreq <= maxNormalFreq) || !(tumorFreq >= minTumorFreq) || !(somaticPvalue <= pValueForHC)) continue;
                        ++numSomaticHC;
                        outSomaticHC.println(line);
                        continue;
                    }
                    if (somaticStatus.equals("Germline") || somaticStatus.equals("1")) {
                        ++numGermline;
                        outGermline.println(line);
                        if (!(normalFreq >= minTumorFreq) || !(tumorFreq >= minTumorFreq) || !(somaticPvalue <= pValueForHC)) continue;
                        ++numGermlineHC;
                        outGermlineHC.println(line);
                        continue;
                    }
                    if (!somaticStatus.equals("LOH") && !somaticStatus.equals("3")) continue;
                    ++numLOH;
                    outLOH.println(line);
                    double normalHetDistance = Math.abs(0.5 - normalFreq);
                    double tumorHetDistance = Math.abs(0.5 - tumorFreq);
                    if (!(normalFreq >= minTumorFreq) || !(tumorHetDistance > normalHetDistance) || !(somaticPvalue <= pValueForHC)) continue;
                    ++numLOHHC;
                    outLOHHC.println(line);
                }
                catch (Exception e) {
                    if (lineCounter == 1) {
                        outSomatic.println(line);
                        outSomaticHC.println(line);
                        outGermline.println(line);
                        outLOH.println(line);
                        continue;
                    }
                    System.err.println("Warning: Unable to parse chrom/position from " + line);
                }
            }
            infile.close();
            outSomatic.close();
            outSomaticHC.close();
            outGermline.close();
            outLOH.close();
            outGermlineHC.close();
            outLOHHC.close();
            System.out.println(String.valueOf(numProcessed) + " VarScan calls processed");
            System.out.println(String.valueOf(numSomatic) + " were Somatic (" + numSomaticHC + " high confidence)");
            System.out.println(String.valueOf(numGermline) + " were Germline (" + numGermlineHC + " high confidence)");
            System.out.println(String.valueOf(numLOH) + " were LOH (" + numLOHHC + " high confidence)");
        }
        catch (Exception e) {
            System.err.println("ERROR: File Parsing Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            return;
        }
    }

    static HashMap<String, BitSet> loadTargets(String fileName, String fileType, int marginSize) {
        HashMap<String, BitSet> positionsByChrom = new HashMap<String, BitSet>();
        try {
            BufferedReader infile = new BufferedReader(new FileReader(fileName));
            String line = "";
            int lineCounter = 0;
            while ((line = infile.readLine()) != null) {
                ++lineCounter;
                String[] lineContents = line.split("\t");
                if (lineContents.length < 2) continue;
                try {
                    int position;
                    String refName = lineContents[0];
                    BitSet refPositions = positionsByChrom.containsKey(refName) ? positionsByChrom.get(refName) : new BitSet();
                    int chrStart = 0;
                    int chrStop = 0;
                    if (fileType.equals("positions") && lineContents.length > 1) {
                        position = Integer.parseInt(lineContents[1]);
                        chrStart = position - marginSize;
                        chrStop = position + marginSize;
                    } else if (fileType.equals("regions") && lineContents.length > 2) {
                        chrStart = Integer.parseInt(lineContents[1]) - marginSize;
                        chrStop = Integer.parseInt(lineContents[2]) + marginSize;
                    }
                    if (chrStart <= chrStop) {
                        position = chrStart;
                        while (position <= chrStop) {
                            refPositions.set(position, true);
                            ++position;
                        }
                    }
                    positionsByChrom.put(refName, refPositions);
                }
                catch (Exception e) {
                    if (lineCounter <= 1) continue;
                    System.err.println("Warning: Unable to parse chrom/position from " + line);
                }
            }
            infile.close();
        }
        catch (Exception e) {
            System.err.println("ERROR: File Parsing Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
        }
        return positionsByChrom;
    }
}

