/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.HashMap;
import net.sf.varscan.VarScan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitVariants {
    public LimitVariants(String[] args) {
        String usage = "USAGE: java -jar VarScan.jar limit [infile] OPTIONS\n\tinfile - A file of chromosome-positions, tab-delimited\n\tOPTIONS\n\t--positions-file - a file of chromosome-positions, tab delimited, or VCF\n\t--regions-file - a file of chromosome-start-stops, tab delimited\n\t--margin-size - shoulder bases to allow on either side of targets [0]\n\t--output-file - Output file for the matching variants\n\t--not-file - Output file for variants NOT matching regions/positions\n";
        String outFileName = "";
        String notFileName = "";
        String targetFileName = "";
        String targetFileType = "";
        int marginSize = 0;
        HashMap params = VarScan.getParams(args);
        try {
            if (params.containsKey("output-file")) {
                outFileName = (String)params.get("output-file");
            }
            if (params.containsKey("not-file")) {
                notFileName = (String)params.get("not-file");
            }
            if (params.containsKey("positions-file")) {
                targetFileName = (String)params.get("positions-file");
                targetFileType = "positions";
            } else if (params.containsKey("regions-file")) {
                targetFileName = (String)params.get("regions-file");
                targetFileType = "regions";
            } else {
                System.err.println("Please provide a regions file or a positions file");
                System.err.println(usage);
                return;
            }
            if (params.containsKey("margin-size")) {
                marginSize = Integer.parseInt((String)params.get("margin-size"));
            }
        }
        catch (Exception e) {
            System.err.println("Input Parameter Threw Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            return;
        }
        if (params.containsKey("help") || params.containsKey("h")) {
            System.err.println(usage);
            return;
        }
        try {
            BufferedReader infile = VarScan.getInfile(args);
            PrintStream outFile = null;
            if (params.containsKey("output-file")) {
                outFile = new PrintStream(new FileOutputStream(outFileName));
            }
            PrintStream notFile = null;
            if (params.containsKey("not-file")) {
                notFile = new PrintStream(new FileOutputStream(notFileName));
            }
            HashMap<String, BitSet> targetHash = LimitVariants.loadTargets(targetFileName, targetFileType, marginSize);
            String line = "";
            int lineCounter = 0;
            int numVariants = 0;
            int numInTarget = 0;
            while ((line = infile.readLine()) != null) {
                ++lineCounter;
                String[] lineContents = line.split("\t");
                if (line.substring(0, 1).equals("#")) {
                    outFile.println(line);
                    notFile.println(line);
                    continue;
                }
                if (line.substring(0, 5).toLowerCase().equals("chrom")) {
                    outFile.println(line);
                    if (!params.containsKey("not-file")) continue;
                    notFile.println(line);
                    continue;
                }
                if (lineContents.length < 2) continue;
                try {
                    BitSet refPositions;
                    String refName = lineContents[0];
                    int position = Integer.parseInt(lineContents[1]);
                    ++numVariants;
                    boolean inTarget = false;
                    if (targetHash.containsKey(refName) && (refPositions = targetHash.get(refName)).get(position)) {
                        inTarget = true;
                        ++numInTarget;
                        if (params.containsKey("output-file")) {
                            outFile.println(line);
                        }
                    }
                    if (inTarget || !params.containsKey("not-file")) continue;
                    notFile.println(line);
                }
                catch (Exception e) {
                    if (lineCounter == 1) continue;
                    System.err.println("Warning: Unable to parse chrom/position from " + line);
                }
            }
            float pctInTarget = 0.0f;
            if (numVariants > 0 && numInTarget > 0) {
                pctInTarget = (float)numInTarget / (float)numVariants * 100.0f;
            }
            System.err.println(String.valueOf(numVariants) + " variants in input file");
            System.err.println(String.valueOf(numInTarget) + " variants (" + pctInTarget + "%) matched target positions");
        }
        catch (Exception e) {
            System.err.println("ERROR: File Parsing Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            return;
        }
    }

    static HashMap<String, BitSet> loadTargets(String fileName, String fileType, int marginSize) {
        HashMap<String, BitSet> positionsByChrom = new HashMap<String, BitSet>();
        try {
            BufferedReader infile = new BufferedReader(new FileReader(fileName));
            String line = "";
            int lineCounter = 0;
            while ((line = infile.readLine()) != null) {
                ++lineCounter;
                String[] lineContents = line.split("\t");
                if (line.substring(0, 1).equals("#") || lineContents.length < 2) continue;
                try {
                    int position;
                    String refName = lineContents[0];
                    BitSet refPositions = positionsByChrom.containsKey(refName) ? positionsByChrom.get(refName) : new BitSet();
                    int chrStart = 0;
                    int chrStop = 0;
                    if (fileType.equals("positions") && lineContents.length > 1) {
                        position = Integer.parseInt(lineContents[1]);
                        chrStart = position - marginSize;
                        chrStop = position + marginSize;
                    } else if (fileType.equals("regions") && lineContents.length > 2) {
                        chrStart = Integer.parseInt(lineContents[1]) - marginSize;
                        chrStop = Integer.parseInt(lineContents[2]) + marginSize;
                    }
                    if (chrStart <= chrStop) {
                        position = chrStart;
                        while (position <= chrStop) {
                            refPositions.set(position, true);
                            ++position;
                        }
                    }
                    positionsByChrom.put(refName, refPositions);
                }
                catch (Exception e) {
                    if (lineCounter <= 1) continue;
                    System.err.println("Warning: Unable to parse chrom/position from " + line);
                }
            }
            infile.close();
        }
        catch (Exception e) {
            System.err.println("ERROR: File Parsing Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
        }
        return positionsByChrom;
    }
}

