/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import net.sf.varscan.VarScan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FpFilter {
    public FpFilter(String[] args) {
        block95: {
            String usage = "USAGE: java -jar VarScan.jar fpfilter [variant file] [readcount file] OPTIONS\n\tvariant file - A file of SNPs or indels in VarScan-native or VCF format\n\treadcount file - The output file from bam-readcount for those positions\n\t***For detailed filtering instructions, please visit http://varscan.sourceforge.net***\n\n\tOPTIONS:\n\t--output-file\t\tOptional output file for filter-pass variants\n\t--filtered-file\t\tOptional output file for filter-fail variants\n\t--keep-failures\t\tIf set to 1, include failures in the output file\n\n\t--min-var-count\t\tMinimum number of variant-supporting reads [4]\n\t--min-var-freq\t\tMinimum variant allele frequency [0.05]\n\t--min-var-readpos\t\tMinimum average read position of var-supporting reads [0.10]\n\t--min-var-dist3\t\tMinimum average relative distance to effective 3' end [0.10]\n\t--min-strandedness\tMinimum fraction of variant reads from each strand [0.01]\n\t--min-strand-reads\tMinimum allele depth required to perform the strand tests [5]\n\t--min-ref-basequal\t\tMinimum average base quality for ref allele [30]\n\t--min-var-basequal\t\tMinimum average base quality for var allele [30]\n\t--max-rl-diff\t\tMaximum average relative read length difference (ref - var) [0.25]\n\t--max-var-mmqs\t\tMaximum mismatch quality sum of variant-supporting reads [100]\n\t--max-mmqs-diff\t\tMaximum average mismatch quality sum (var - ref) [50]\n\t--min-ref-mapqual\t\tMinimum average mapping quality for ref allele [30]\n\t--min-var-mapqual\t\tMinimum average mapping quality for var allele [30]\n\t--max-mapqual-diff\tMaximum average mapping quality (ref - var) [50]";
            double minVarReadPos = 0.1;
            double minVarDist3 = 0.1;
            double minStrandedness = 0.01;
            int minStrandReads = 5;
            double maxReadLenDiff = 0.25;
            double minVarFreq = 0.05;
            int minVarCount = 4;
            int maxVarMMQS = 150;
            int maxMMQSdiff = 150;
            int minRefBaseQual = 30;
            int minVarBaseQual = 30;
            int minRefMapQual = 30;
            int minVarMapQual = 30;
            int maxMapQualDiff = 50;
            String outFileName = "";
            String filteredFileName = "";
            HashMap params = VarScan.getParams(args);
            try {
                if (params.containsKey("output-file")) {
                    outFileName = (String)params.get("output-file");
                }
                if (params.containsKey("filtered-file")) {
                    filteredFileName = (String)params.get("filtered-file");
                }
                if (params.containsKey("min-var-freq")) {
                    minVarFreq = Double.parseDouble((String)params.get("min-var-freq"));
                }
                if (params.containsKey("min-var-readpos")) {
                    minVarReadPos = Double.parseDouble((String)params.get("min-var-readpos"));
                }
                if (params.containsKey("min-var-dist3")) {
                    minVarDist3 = Double.parseDouble((String)params.get("min-var-dist3"));
                }
                if (params.containsKey("max-rl-diff")) {
                    maxReadLenDiff = Double.parseDouble((String)params.get("max-rl-diff"));
                }
                if (params.containsKey("min-strandedness")) {
                    minStrandedness = Double.parseDouble((String)params.get("min-strandedness"));
                }
                if (params.containsKey("min-strand-reads")) {
                    minStrandReads = Integer.parseInt((String)params.get("min-strand-reads"));
                }
                if (params.containsKey("min-var-count")) {
                    minVarCount = Integer.parseInt((String)params.get("min-var-count"));
                }
                if (params.containsKey("min-ref-mapqual")) {
                    minRefMapQual = Integer.parseInt((String)params.get("min-ref-mapqual"));
                }
                if (params.containsKey("min-var-mapqual")) {
                    minVarMapQual = Integer.parseInt((String)params.get("min-var-mapqual"));
                }
                if (params.containsKey("min-ref-basequal")) {
                    minRefBaseQual = Integer.parseInt((String)params.get("min-ref-basequal"));
                }
                if (params.containsKey("min-var-basequal")) {
                    minVarBaseQual = Integer.parseInt((String)params.get("min-var-basequal"));
                }
                if (params.containsKey("max-var-mmqs")) {
                    maxVarMMQS = Integer.parseInt((String)params.get("max-var-mmqs"));
                }
                if (params.containsKey("max-mmqs-diff")) {
                    maxMMQSdiff = Integer.parseInt((String)params.get("max-mmqs-diff"));
                }
                if (params.containsKey("max-mapqual-diff")) {
                    maxMapQualDiff = Integer.parseInt((String)params.get("max-mapqual-diff"));
                }
            }
            catch (Exception e) {
                System.err.println("Input Parameter Threw Exception: " + e.getLocalizedMessage());
                e.printStackTrace(System.err);
                System.exit(1);
            }
            if (params.containsKey("help") || params.containsKey("h")) {
                System.err.println(usage);
                return;
            }
            if (args.length < 3) {
                System.err.println("ERROR: Input files not provided!\n");
                System.err.println(usage);
                return;
            }
            DecimalFormat twoDigits = new DecimalFormat("#0.00");
            DecimalFormat threeDigits = new DecimalFormat("#0.000");
            HashMap<String, Integer> stats = new HashMap<String, Integer>();
            stats.put("numVariants", 0);
            stats.put("numWithRC", 0);
            stats.put("numWithReads1", 0);
            stats.put("numPassFilter", 0);
            stats.put("numFailFilter", 0);
            stats.put("numFailNoRC", 0);
            stats.put("numFailVarCount", 0);
            stats.put("numFailVarFreq", 0);
            stats.put("numFailStrand", 0);
            stats.put("numFailVarReadPos", 0);
            stats.put("numFailVarDist3", 0);
            stats.put("numFailVarMMQS", 0);
            stats.put("numFailMMQSdiff", 0);
            stats.put("numFailRefMapQual", 0);
            stats.put("numFailVarMapQual", 0);
            stats.put("numFailRefBaseQual", 0);
            stats.put("numFailVarBaseQual", 0);
            stats.put("numFailMapQualDiff", 0);
            stats.put("numFailReadLenDiff", 0);
            try {
                File variantFile = new File(args[1]);
                File readcountFile = new File(args[2]);
                if (!variantFile.exists() || !readcountFile.exists()) {
                    System.err.println("ERROR: One of your input files is missing!\n");
                    System.err.println(usage);
                    return;
                }
                int lineCounter = 0;
                boolean isVCF = false;
                HashMap<Object, Object> readcounts = new HashMap();
                System.err.println("Loading readcounts from " + args[2] + "...");
                readcounts = FpFilter.loadReadcounts(args[2]);
                System.err.println("Parsing variants from " + args[1] + "...");
                if (!variantFile.exists()) break block95;
                BufferedReader in = new BufferedReader(new FileReader(variantFile));
                if (in.ready()) {
                    String line;
                    PrintStream outFile = null;
                    if (params.containsKey("output-file")) {
                        outFile = new PrintStream(new FileOutputStream(outFileName));
                    }
                    PrintStream filteredFile = null;
                    if (params.containsKey("filtered-file")) {
                        filteredFile = new PrintStream(new FileOutputStream(filteredFileName));
                    }
                    String vcfHeaderInfo = "";
                    vcfHeaderInfo = "##FILTER=<ID=VarCount,Description=\"Fewer than " + minVarCount + " variant-supporting reads\">";
                    vcfHeaderInfo = String.valueOf(vcfHeaderInfo) + "\n##FILTER=<ID=VarFreq,Description=\"Variant allele frequency below " + minVarFreq + "\">";
                    vcfHeaderInfo = String.valueOf(vcfHeaderInfo) + "\n##FILTER=<ID=VarReadPos,Description=\"Relative average read position < " + minVarReadPos + "\">";
                    vcfHeaderInfo = String.valueOf(vcfHeaderInfo) + "\n##FILTER=<ID=VarDist3,Description=\"Average distance to effective 3' end < " + minVarDist3 + "\">";
                    vcfHeaderInfo = String.valueOf(vcfHeaderInfo) + "\n##FILTER=<ID=VarMMQS,Description=\"Average mismatch quality sum for variant reads > " + maxVarMMQS + "\">";
                    vcfHeaderInfo = String.valueOf(vcfHeaderInfo) + "\n##FILTER=<ID=VarMapQual,Description=\"Average mapping quality of variant reads < " + minVarMapQual + "\">";
                    vcfHeaderInfo = String.valueOf(vcfHeaderInfo) + "\n##FILTER=<ID=VarBaseQual,Description=\"Average base quality of variant reads < " + minVarBaseQual + "\">";
                    vcfHeaderInfo = String.valueOf(vcfHeaderInfo) + "\n##FILTER=<ID=Strand,Description=\"Strand representation of variant reads < " + minStrandedness + "\">";
                    vcfHeaderInfo = String.valueOf(vcfHeaderInfo) + "\n##FILTER=<ID=RefMapQual,Description=\"Average mapping quality of reference reads < " + minRefMapQual + "\">";
                    vcfHeaderInfo = String.valueOf(vcfHeaderInfo) + "\n##FILTER=<ID=RefBaseQual,Description=\"Average base quality of reference reads < " + minRefBaseQual + "\">";
                    vcfHeaderInfo = String.valueOf(vcfHeaderInfo) + "\n##FILTER=<ID=MMQSdiff,Description=\"Mismatch quality sum difference (ref - var) > " + maxMMQSdiff + "\">";
                    vcfHeaderInfo = String.valueOf(vcfHeaderInfo) + "\n##FILTER=<ID=MapQualDiff,Description=\"Mapping quality difference (ref - var) > " + maxMapQualDiff + "\">";
                    vcfHeaderInfo = String.valueOf(vcfHeaderInfo) + "\n##FILTER=<ID=ReadLenDiff,Description=\"Average supporting read length difference (ref - var) > " + maxReadLenDiff + "\">";
                    while ((line = in.readLine()) != null) {
                        ++lineCounter;
                        try {
                            double mapQualDiff;
                            double mmqsDiff;
                            double refStrandedness;
                            double varStrandedness;
                            double varDist3;
                            double varMMQS;
                            double varPos;
                            double varBaseQual;
                            double varMapQual;
                            int varReads;
                            double refDist3;
                            double refMMQS;
                            double refPos;
                            double refBaseQual;
                            double refMapQual;
                            int refReads;
                            boolean filterFlag;
                            String failReason;
                            String[] lineContents;
                            block96: {
                                lineContents = line.split("\t");
                                String chrom = lineContents[0];
                                failReason = "";
                                filterFlag = false;
                                if (chrom.equals("Chrom") || chrom.equals("chrom") || line.startsWith("#")) {
                                    if (line.startsWith("#")) {
                                        isVCF = true;
                                    }
                                    if (isVCF) {
                                        if (params.containsKey("output-file")) {
                                            if (line.startsWith("#CHROM")) {
                                                outFile.println(vcfHeaderInfo);
                                            }
                                            outFile.println(line);
                                        }
                                        if (!params.containsKey("filtered-file")) continue;
                                        if (line.startsWith("#CHROM")) {
                                            filteredFile.println(vcfHeaderInfo);
                                        }
                                        filteredFile.println(line);
                                        continue;
                                    }
                                    String filterHeader = "ref_reads\tvar_reads\tref_strand\tvar_strand\tref_basequal\tvar_basequal\tref_readpos\tvar_readpos\tref_dist3\tvar_dist3\tref_mapqual\tvar_mapqual\tmapqual_diff\tref_mmqs\tvar_mmqs\tmmqs_diff\tfilter_status";
                                    if (params.containsKey("output-file")) {
                                        outFile.println(String.valueOf(line) + "\t" + filterHeader);
                                    }
                                    if (!params.containsKey("filtered-file")) continue;
                                    filteredFile.println(String.valueOf(line) + "\t" + filterHeader);
                                    continue;
                                }
                                stats.put("numVariants", (Integer)stats.get("numVariants") + 1);
                                int position = Integer.parseInt(lineContents[1]);
                                String positionKey = String.valueOf(chrom) + "\t" + position;
                                boolean isIndel = false;
                                refReads = 0;
                                refMapQual = 0.0;
                                refBaseQual = 0.0;
                                int refReadsPlus = 0;
                                int refReadsMinus = 0;
                                refPos = 0.0;
                                double refSubs = 0.0;
                                refMMQS = 0.0;
                                double refRL = 0.0;
                                refDist3 = 0.0;
                                varReads = 0;
                                varMapQual = 0.0;
                                varBaseQual = 0.0;
                                int varReadsPlus = 0;
                                int varReadsMinus = 0;
                                varPos = 0.0;
                                double varSubs = 0.0;
                                varMMQS = 0.0;
                                double varRL = 0.0;
                                varDist3 = 0.0;
                                double varFreq = 0.0;
                                varStrandedness = -1.0;
                                refStrandedness = -1.0;
                                mmqsDiff = 0.0;
                                mapQualDiff = 0.0;
                                double avgReadLenDiff = 0.0;
                                try {
                                    String refCounts = "";
                                    String varCounts = "";
                                    String ref = "";
                                    String alt = "";
                                    if (isVCF) {
                                        ref = lineContents[3];
                                        String alts = lineContents[4];
                                        String[] altContents = alts.split(",");
                                        alt = altContents[0];
                                        if (ref.length() > 1) {
                                            isIndel = true;
                                            String thisVar = ref.replaceFirst(alt, "");
                                            ref = alt;
                                            alt = "-" + thisVar;
                                        } else if (alt.length() > 1) {
                                            isIndel = true;
                                            String thisVar = alt.replaceFirst(ref, "");
                                            alt = "+" + thisVar;
                                        }
                                    } else {
                                        ref = lineContents[2];
                                        String cns = lineContents[3];
                                        if (cns.length() > 1) {
                                            isIndel = true;
                                            if (cns.contains("/")) {
                                                String[] indelContents = cns.split("/");
                                                if (indelContents.length > 1) {
                                                    alt = indelContents[1];
                                                }
                                            } else {
                                                alt = cns;
                                            }
                                        } else {
                                            alt = VarScan.getVarAllele(ref, cns);
                                        }
                                    }
                                    if (alt.length() <= 0) break block96;
                                    String varKey = String.valueOf(chrom) + "\t" + position + "\t" + alt;
                                    if (ref.length() > 1 || alt.length() > 1) {
                                        isIndel = true;
                                        int indelSize = 0;
                                        indelSize = ref.length() > 1 ? ref.length() - 1 : alt.length() - 1;
                                        if (!readcounts.containsKey(varKey)) {
                                            int windowSize = indelSize + 1;
                                            while (windowSize >= 1) {
                                                String testKey1 = String.valueOf(chrom) + "\t" + (position - windowSize) + "\t" + alt;
                                                String testKey2 = String.valueOf(chrom) + "\t" + (position + windowSize) + "\t" + alt;
                                                if (readcounts.containsKey(testKey1)) {
                                                    varKey = testKey1;
                                                } else if (readcounts.containsKey(testKey2)) {
                                                    varKey = testKey2;
                                                }
                                                --windowSize;
                                            }
                                        }
                                    }
                                    if (readcounts.containsKey(varKey)) {
                                        stats.put("numWithRC", (Integer)stats.get("numWithRC") + 1);
                                        try {
                                            String[] rcContents = ((String)readcounts.get(varKey)).split("\t");
                                            int readDepth = Integer.parseInt(rcContents[0]);
                                            varCounts = rcContents[1];
                                            String[] varContents = varCounts.split(":");
                                            varReads = Integer.parseInt(varContents[1]);
                                            varMapQual = Double.parseDouble(varContents[2]);
                                            varBaseQual = Double.parseDouble(varContents[3]);
                                            varReadsPlus = Integer.parseInt(varContents[5]);
                                            varReadsMinus = Integer.parseInt(varContents[6]);
                                            varPos = Double.parseDouble(varContents[7]);
                                            varSubs = Double.parseDouble(varContents[8]);
                                            varMMQS = Double.parseDouble(varContents[9]);
                                            varRL = Double.parseDouble(varContents[12]);
                                            varDist3 = Double.parseDouble(varContents[13]);
                                            String refKey = String.valueOf(chrom) + "\t" + position + "\t" + ref;
                                            if (readcounts.containsKey(refKey)) {
                                                String[] rcContents2 = ((String)readcounts.get(refKey)).split("\t");
                                                int readDepth2 = Integer.parseInt(rcContents2[0]);
                                                refCounts = rcContents2[1];
                                                String[] refContents = refCounts.split(":");
                                                refReads = Integer.parseInt(refContents[1]);
                                                refMapQual = Double.parseDouble(refContents[2]);
                                                refBaseQual = Double.parseDouble(refContents[3]);
                                                refReadsPlus = Integer.parseInt(refContents[5]);
                                                refReadsMinus = Integer.parseInt(refContents[6]);
                                                refPos = Double.parseDouble(refContents[7]);
                                                refSubs = Double.parseDouble(refContents[8]);
                                                refMMQS = Double.parseDouble(refContents[9]);
                                                refRL = Double.parseDouble(refContents[12]);
                                                refDist3 = Double.parseDouble(refContents[13]);
                                            }
                                            if (varReads < minVarCount) {
                                                if (failReason.length() > 0) {
                                                    failReason = String.valueOf(failReason) + ",";
                                                }
                                                failReason = String.valueOf(failReason) + "VarCount";
                                                stats.put("numFailVarCount", (Integer)stats.get("numFailVarCount") + 1);
                                            }
                                            if ((varFreq = (double)varReads / (double)readDepth) < minVarFreq) {
                                                if (failReason.length() > 0) {
                                                    failReason = String.valueOf(failReason) + ",";
                                                }
                                                failReason = String.valueOf(failReason) + "VarFreq";
                                                stats.put("numFailVarFreq", (Integer)stats.get("numFailVarFreq") + 1);
                                            }
                                            if (varPos < minVarReadPos) {
                                                if (failReason.length() > 0) {
                                                    failReason = String.valueOf(failReason) + ",";
                                                }
                                                failReason = String.valueOf(failReason) + "VarReadPos";
                                                stats.put("numFailVarReadPos", (Integer)stats.get("numFailVarReadPos") + 1);
                                            }
                                            if (varDist3 < minVarDist3) {
                                                if (failReason.length() > 0) {
                                                    failReason = String.valueOf(failReason) + ",";
                                                }
                                                failReason = String.valueOf(failReason) + "VarDist3";
                                                stats.put("numFailVarDist3", (Integer)stats.get("numFailVarDist3") + 1);
                                            }
                                            if (varMMQS > (double)maxVarMMQS) {
                                                if (failReason.length() > 0) {
                                                    failReason = String.valueOf(failReason) + ",";
                                                }
                                                failReason = String.valueOf(failReason) + "VarMMQS";
                                                stats.put("numFailVarMMQS", (Integer)stats.get("numFailVarMMQS") + 1);
                                            }
                                            if (refReads > 0 && refMapQual < (double)minRefMapQual) {
                                                if (failReason.length() > 0) {
                                                    failReason = String.valueOf(failReason) + ",";
                                                }
                                                failReason = String.valueOf(failReason) + "RefMapQual";
                                                stats.put("numFailRefMapQual", (Integer)stats.get("numFailRefMapQual") + 1);
                                            }
                                            if (varReads > 0 && varMapQual < (double)minVarMapQual) {
                                                if (failReason.length() > 0) {
                                                    failReason = String.valueOf(failReason) + ",";
                                                }
                                                failReason = String.valueOf(failReason) + "VarMapQual";
                                                stats.put("numFailVarMapQual", (Integer)stats.get("numFailVarMapQual") + 1);
                                            }
                                            if (refReads > 0 && refBaseQual < (double)minRefBaseQual) {
                                                if (failReason.length() > 0) {
                                                    failReason = String.valueOf(failReason) + ",";
                                                }
                                                failReason = String.valueOf(failReason) + "RefBaseQual";
                                                stats.put("numFailRefBaseQual", (Integer)stats.get("numFailRefBaseQual") + 1);
                                            }
                                            if (!isIndel && varReads > 0 && varBaseQual < (double)minVarBaseQual) {
                                                if (failReason.length() > 0) {
                                                    failReason = String.valueOf(failReason) + ",";
                                                }
                                                failReason = String.valueOf(failReason) + "VarBaseQual";
                                                stats.put("numFailVarBaseQual", (Integer)stats.get("numFailVarBaseQual") + 1);
                                            }
                                            if (refReads >= minStrandReads && refReads > 0) {
                                                refStrandedness = (double)refReadsPlus / (double)refReads;
                                            }
                                            if (varReads >= minStrandReads && varReads > 0 && ((varStrandedness = (double)varReadsPlus / (double)varReads) < minStrandedness || 1.0 - varStrandedness < minStrandedness)) {
                                                if (failReason.length() > 0) {
                                                    failReason = String.valueOf(failReason) + ",";
                                                }
                                                failReason = String.valueOf(failReason) + "Strand";
                                                stats.put("numFailStrand", (Integer)stats.get("numFailStrand") + 1);
                                            }
                                            if (refReads >= 2 && varReads >= 2) {
                                                stats.put("numWithReads1", (Integer)stats.get("numWithReads1") + 1);
                                                mmqsDiff = varMMQS - refMMQS;
                                                if (mmqsDiff > (double)maxMMQSdiff) {
                                                    if (failReason.length() > 0) {
                                                        failReason = String.valueOf(failReason) + ",";
                                                    }
                                                    failReason = String.valueOf(failReason) + "MMQSdiff";
                                                    stats.put("numFailMMQSdiff", (Integer)stats.get("numFailMMQSdiff") + 1);
                                                }
                                                if ((mapQualDiff = refMapQual - varMapQual) > (double)maxMapQualDiff) {
                                                    if (failReason.length() > 0) {
                                                        failReason = String.valueOf(failReason) + ",";
                                                    }
                                                    failReason = String.valueOf(failReason) + "MapQualDiff";
                                                    stats.put("numFailMapQualDiff", (Integer)stats.get("numFailMapQualDiff") + 1);
                                                }
                                                if ((avgReadLenDiff = (refRL - varRL) / refRL) > maxReadLenDiff) {
                                                    if (failReason.length() > 0) {
                                                        failReason = String.valueOf(failReason) + ",";
                                                    }
                                                    failReason = String.valueOf(failReason) + "ReadLenDiff";
                                                    stats.put("numFailReadLenDiff", (Integer)stats.get("numFailReadLenDiff") + 1);
                                                }
                                            }
                                            if (failReason.length() > 0) {
                                                filterFlag = true;
                                            }
                                            break block96;
                                        }
                                        catch (Exception e) {
                                            System.err.println("Exception thrown while processing readcounts at " + positionKey + ": " + e.getLocalizedMessage());
                                            e.printStackTrace(System.err);
                                            return;
                                        }
                                    }
                                    failReason = "NoReadCounts";
                                    stats.put("numFailNoRC", (Integer)stats.get("numFailNoRC") + 1);
                                    filterFlag = true;
                                }
                                catch (Exception e) {
                                    System.err.println("Exception thrown while filtering at " + positionKey + ": " + e.getLocalizedMessage());
                                    e.printStackTrace(System.err);
                                    return;
                                }
                            }
                            String filterColumns = "";
                            filterColumns = String.valueOf(refReads) + "\t" + varReads + "\t" + threeDigits.format(refStrandedness) + "\t" + threeDigits.format(varStrandedness);
                            filterColumns = String.valueOf(filterColumns) + "\t" + refBaseQual + "\t" + varBaseQual + "\t" + refPos + "\t" + varPos;
                            filterColumns = String.valueOf(filterColumns) + "\t" + refDist3 + "\t" + varDist3 + "\t" + refMapQual + "\t" + varMapQual;
                            filterColumns = String.valueOf(filterColumns) + "\t" + twoDigits.format(mapQualDiff) + "\t" + refMMQS + "\t" + varMMQS + "\t" + twoDigits.format(mmqsDiff);
                            if (filterFlag) {
                                filterColumns = String.valueOf(filterColumns) + "\t" + failReason;
                                stats.put("numFailFilter", (Integer)stats.get("numFailFilter") + 1);
                            } else {
                                filterColumns = String.valueOf(filterColumns) + "\tPASS";
                                stats.put("numPassFilter", (Integer)stats.get("numPassFilter") + 1);
                            }
                            if (isVCF) {
                                String newVCFline = "";
                                int colCounter = 0;
                                while (colCounter < lineContents.length) {
                                    if (newVCFline.length() > 0) {
                                        newVCFline = String.valueOf(newVCFline) + "\t";
                                    }
                                    newVCFline = filterFlag && colCounter == 6 ? String.valueOf(newVCFline) + failReason : String.valueOf(newVCFline) + lineContents[colCounter];
                                    ++colCounter;
                                }
                                if (params.containsKey("output-file") && (!filterFlag || params.containsKey("keep-failures"))) {
                                    outFile.println(newVCFline);
                                }
                                if (!filterFlag || !params.containsKey("filtered-file")) continue;
                                filteredFile.println(newVCFline);
                                continue;
                            }
                            if (params.containsKey("output-file") && (!filterFlag || params.containsKey("keep-failures"))) {
                                outFile.println(String.valueOf(line) + "\t" + filterColumns);
                            }
                            if (!filterFlag || !params.containsKey("filtered-file")) continue;
                            filteredFile.println(String.valueOf(line) + "\t" + filterColumns);
                        }
                        catch (Exception e) {
                            System.err.println("Parsing Exception on line:\n" + line + "\n" + e.getLocalizedMessage());
                            e.printStackTrace(System.err);
                            return;
                        }
                    }
                    System.err.println(stats.get("numVariants") + " variants in input file");
                    System.err.println(stats.get("numWithRC") + " had a bam-readcount result");
                    System.err.println(stats.get("numWithReads1") + " had reads1>=2");
                    System.err.println(stats.get("numPassFilter") + " passed filters");
                    System.err.println(stats.get("numFailFilter") + " failed filters");
                    System.err.println("\t" + stats.get("numFailNoRC") + " failed because no readcounts were returned");
                    System.err.println("\t" + stats.get("numFailVarCount") + " failed minimim variant count < " + minVarCount);
                    System.err.println("\t" + stats.get("numFailVarFreq") + " failed minimum variant freq < " + minVarFreq);
                    System.err.println("\t" + stats.get("numFailStrand") + " failed minimum strandedness < " + minStrandedness);
                    System.err.println("\t" + stats.get("numFailVarReadPos") + " failed minimum variant readpos < " + minVarReadPos);
                    System.err.println("\t" + stats.get("numFailVarDist3") + " failed minimum variant dist3 < " + minVarDist3);
                    System.err.println("\t" + stats.get("numFailVarMMQS") + " failed maximum variant MMQS > " + maxVarMMQS);
                    System.err.println("\t" + stats.get("numFailMMQSdiff") + " failed maximum MMQS diff (var - ref) > " + maxMMQSdiff);
                    System.err.println("\t" + stats.get("numFailMapQualDiff") + " failed maximum mapqual diff (ref - var) > " + maxMapQualDiff);
                    System.err.println("\t" + stats.get("numFailRefMapQual") + " failed minimim ref mapqual < " + minRefMapQual);
                    System.err.println("\t" + stats.get("numFailVarMapQual") + " failed minimim var mapqual < " + minVarMapQual);
                    System.err.println("\t" + stats.get("numFailRefBaseQual") + " failed minimim ref basequal < " + minRefBaseQual);
                    System.err.println("\t" + stats.get("numFailVarBaseQual") + " failed minimim var basequal < " + minVarBaseQual);
                    System.err.println("\t" + stats.get("numFailReadLenDiff") + " failed maximum RL diff (ref - var) > " + maxReadLenDiff);
                    in.close();
                } else {
                    System.err.println("Unable to open SNVs file for reading");
                }
                in.close();
            }
            catch (Exception e) {
                System.err.println("Error Parsing SNV File: " + e.getMessage() + "\n" + e.getLocalizedMessage());
                e.printStackTrace(System.err);
            }
        }
    }

    static HashMap<String, String> loadReadcounts(String filename) {
        HashMap<String, String> readcounts = new HashMap<String, String>();
        try {
            File infile = new File(filename);
            if (infile.exists()) {
                BufferedReader in = new BufferedReader(new FileReader(infile));
                if (in.ready()) {
                    String line;
                    while ((line = in.readLine()) != null) {
                        String[] lineContents = line.split("\t");
                        try {
                            String chrom = lineContents[0];
                            String position = lineContents[1];
                            int colCounter = 4;
                            while (colCounter < lineContents.length) {
                                String[] alleleContents = lineContents[colCounter].split(":");
                                String thisAllele = alleleContents[0];
                                int thisReads = Integer.parseInt(alleleContents[1]);
                                if (!thisAllele.equals("N") && !thisAllele.equals("=") && thisReads != 0) {
                                    String rcLine = lineContents[3];
                                    rcLine = String.valueOf(rcLine) + "\t" + lineContents[colCounter];
                                    String snvKey = String.valueOf(chrom) + "\t" + position + "\t" + thisAllele;
                                    readcounts.put(snvKey, rcLine);
                                }
                                ++colCounter;
                            }
                        }
                        catch (Exception e) {
                            System.err.println("Warning: Exception thrown while loading bam-readcount: " + e.getMessage());
                            System.err.println("Attempting to continue, but please double-check file format and completeness");
                        }
                    }
                } else {
                    System.err.println("Unable to open SNVs file for reading");
                }
                in.close();
            }
        }
        catch (Exception e) {
            System.err.println("Error Parsing SNV File: " + e.getLocalizedMessage());
        }
        return readcounts;
    }
}

