/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

public class FishersExact {
    private static final boolean DEBUG = false;
    private double[] f;
    int maxSize;

    public FishersExact(int maxSize) {
        this.maxSize = maxSize;
        double cf = 1.0;
        this.f = new double[maxSize + 1];
        this.f[0] = 0.0;
        int i = 1;
        while (i <= this.maxSize) {
            this.f[i] = this.f[i - 1] + Math.log(i);
            ++i;
        }
    }

    public final double getP(int a, int b, int c, int d) {
        int n;
        block3: {
            try {
                n = a + b + c + d;
                if (n <= this.maxSize) break block3;
                return Double.NaN;
            }
            catch (Exception e) {
                return Double.NaN;
            }
        }
        double p = this.f[a + b] + this.f[c + d] + this.f[a + c] + this.f[b + d] - (this.f[a] + this.f[b] + this.f[c] + this.f[d] + this.f[n]);
        return Math.exp(p);
    }

    public final double getCumlativeP(int a, int b, int c, int d) {
        int i;
        int min;
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        if (a * d >= b * c) {
            min = c < b ? c : b;
            i = 0;
            while (i < min) {
                p += this.getP(++a, --b, --c, ++d);
                ++i;
            }
            System.out.println("");
        }
        if (a * d < b * c) {
            min = a < d ? a : d;
            i = 0;
            while (i < min) {
                double pTemp = this.getP(--a, ++b, ++c, --d);
                p += pTemp;
                ++i;
            }
        }
        return p;
    }

    public final double getRightTailedP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        int min = c < b ? c : b;
        int i = 0;
        while (i < min) {
            p += this.getP(++a, --b, --c, ++d);
            ++i;
        }
        return p;
    }

    public final double getLeftTailedP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        int min = a < d ? a : d;
        int i = 0;
        while (i < min) {
            double pTemp = this.getP(--a, ++b, ++c, --d);
            p += pTemp;
            ++i;
        }
        return p;
    }

    public final double getTwoTailedP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        double baseP = this.getP(a, b, c, d);
        int initialA = a;
        int initialB = b;
        int initialC = c;
        int initialD = d;
        p += baseP;
        int min = c < b ? c : b;
        int i = 0;
        while (i < min) {
            double tempP;
            if ((tempP = this.getP(++a, --b, --c, ++d)) <= baseP) {
                p += tempP;
            }
            ++i;
        }
        a = initialA;
        b = initialB;
        c = initialC;
        d = initialD;
        min = a < d ? a : d;
        i = 0;
        while (i < min) {
            double pTemp;
            if ((pTemp = this.getP(--a, ++b, ++c, --d)) <= baseP) {
                p += pTemp;
            }
            ++i;
        }
        return p;
    }

    public static void main(String[] args) {
        int[][] argInts = new int[15][4];
        argInts[0] = new int[]{2, 3, 6, 4};
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[1] = 1;
        nArray[2] = 3;
        argInts[1] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 3;
        nArray2[2] = 2;
        nArray2[3] = 1;
        argInts[2] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 1;
        nArray3[1] = 2;
        nArray3[3] = 3;
        argInts[3] = nArray3;
        argInts[4] = new int[]{3, 1, 1, 3};
        argInts[5] = new int[]{1, 3, 3, 1};
        int[] nArray4 = new int[4];
        nArray4[1] = 1;
        nArray4[2] = 1;
        argInts[6] = nArray4;
        int[] nArray5 = new int[4];
        nArray5[0] = 1;
        nArray5[3] = 1;
        argInts[7] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[0] = 11;
        nArray6[3] = 6;
        argInts[8] = nArray6;
        argInts[9] = new int[]{10, 1, 1, 5};
        int[] nArray7 = new int[4];
        nArray7[0] = 5;
        nArray7[1] = 6;
        nArray7[2] = 6;
        argInts[10] = nArray7;
        argInts[11] = new int[]{9, 2, 2, 4};
        argInts[12] = new int[]{6, 5, 5, 1};
        argInts[13] = new int[]{8, 3, 3, 3};
        argInts[14] = new int[]{7, 4, 4, 2};
        FishersExact fe = new FishersExact(100);
        int i = 0;
        while (i < argInts.length) {
            System.out.println("\na=" + argInts[i][0] + " b=" + argInts[i][1] + " c=" + argInts[i][2] + " d=" + argInts[i][3]);
            System.out.print("*****Original algorithm: ");
            double cumulativeP = fe.getCumlativeP(argInts[i][0], argInts[i][1], argInts[i][2], argInts[i][3]);
            System.out.println("\tcumulativeP = " + cumulativeP);
            System.out.print("*****Left Tailed: ");
            double leftTailedP = fe.getLeftTailedP(argInts[i][0], argInts[i][1], argInts[i][2], argInts[i][3]);
            System.out.println("\tleftTailedP = " + leftTailedP);
            System.out.print("*****Right Tailed: ");
            double rightTailedP = fe.getRightTailedP(argInts[i][0], argInts[i][1], argInts[i][2], argInts[i][3]);
            System.out.println("\trightTailedP = " + rightTailedP);
            System.out.print("*****Two Tailed: ");
            double twoTailedP = fe.getTwoTailedP(argInts[i][0], argInts[i][1], argInts[i][2], argInts[i][3]);
            System.out.println("\ttwoTailedP = " + twoTailedP);
            ++i;
        }
    }
}

