/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.HashMap;
import net.sf.varscan.VarScan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterVariants {
    public FilterVariants(String[] args) {
        String usage = "USAGE: java -jar VarScan.jar filter [variant file] OPTIONS\n\tvariant file - A file of SNPs or indels\n\n\tOPTIONS:\n\t--min-coverage\tMinimum read depth at a position to make a call [10]\n\t--min-reads2\tMinimum supporting reads at a position to call variants [2]\n\t--min-strands2\tMinimum # of strands on which variant observed (1 or 2) [1]\n\t--min-avg-qual\tMinimum average base quality for variant-supporting reads [20]\n\t--min-var-freq\tMinimum variant allele frequency threshold [0.20]\n\t--p-value\tDefault p-value threshold for calling variants [1e-01]\n\t--indel-file\tFile of indels for filtering nearby SNPs\n\t--output-file\tFile to contain variants passing filters\n";
        int minCoverage = 10;
        int minReads2 = 2;
        int minStrands2 = 1;
        int minAvgQual = 15;
        double minVarFreq = 0.2;
        double pValueThreshold = 0.1;
        HashMap<Object, Object> indelPositions = new HashMap();
        String outFileName = "";
        String notFileName = "";
        HashMap params = VarScan.getParams(args);
        try {
            if (params.containsKey("min-coverage")) {
                minCoverage = Integer.parseInt((String)params.get("min-coverage"));
            }
            if (params.containsKey("min-reads2")) {
                minReads2 = Integer.parseInt((String)params.get("min-reads2"));
            }
            if (params.containsKey("min-strands2")) {
                minStrands2 = Integer.parseInt((String)params.get("min-strands2"));
            }
            if (params.containsKey("min-var-freq")) {
                minVarFreq = Double.parseDouble((String)params.get("min-var-freq"));
            }
            if (params.containsKey("min-avg-qual")) {
                minAvgQual = Integer.parseInt((String)params.get("min-avg-qual"));
            }
            if (params.containsKey("p-value")) {
                pValueThreshold = Double.parseDouble((String)params.get("p-value"));
            }
            if (params.containsKey("indel-file")) {
                indelPositions = FilterVariants.loadIndels((String)params.get("indel-file"));
            }
            if (params.containsKey("output-file")) {
                outFileName = (String)params.get("output-file");
            }
            if (params.containsKey("not-file")) {
                notFileName = (String)params.get("not-file");
            }
            System.err.println("Min coverage:\t" + minCoverage);
            System.err.println("Min reads2:\t" + minReads2);
            System.err.println("Min strands2:\t" + minStrands2);
            System.err.println("Min var freq:\t" + minVarFreq);
            System.err.println("Min avg qual:\t" + minAvgQual);
            System.err.println("P-value thresh:\t" + pValueThreshold);
        }
        catch (Exception e) {
            System.err.println("Input Parameter Threw Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        if (params.containsKey("help") || params.containsKey("h")) {
            System.err.println(usage);
            return;
        }
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        stats.put("numVariants", 0);
        stats.put("numNearIndel", 0);
        stats.put("numPassFilter", 0);
        stats.put("numFailCoverage", 0);
        stats.put("numFailFreq", 0);
        stats.put("numFailQual", 0);
        stats.put("numFailStrands", 0);
        stats.put("numFailReads2", 0);
        stats.put("numFailPvalue", 0);
        stats.put("numParsingExceptions", 0);
        stats.put("numNoGenotype", 0);
        stats.put("numCalledRef", 0);
        try {
            BufferedReader in;
            PrintStream outFile = null;
            if (params.containsKey("output-file")) {
                outFile = new PrintStream(new FileOutputStream(outFileName));
            }
            PrintStream notFile = null;
            if (params.containsKey("not-file")) {
                notFile = new PrintStream(new FileOutputStream(notFileName));
            }
            if ((in = VarScan.getInfile(args)) == null) {
                System.out.println(usage);
                return;
            }
            int numNaps = 0;
            while (!in.ready()) {
                try {
                    Thread.sleep(5000L);
                    if (++numNaps <= 100) continue;
                    System.err.println("Input file was not ready after 100 5-second cycles!");
                    System.exit(10);
                }
                catch (Exception e) {
                    System.err.println("Exception while trying to get input" + e.getMessage());
                    System.exit(1);
                }
            }
            int lineCounter = 0;
            boolean isVCF = false;
            if (in != null && in.ready()) {
                String line;
                while ((line = in.readLine()) != null) {
                    try {
                        double varFreq;
                        ++lineCounter;
                        String[] lineContents = line.split("\t");
                        String chrom = lineContents[0];
                        if (line.startsWith("#")) {
                            isVCF = true;
                            if (params.containsKey("output-file")) {
                                outFile.println(line);
                            } else {
                                System.out.println(line);
                            }
                            if (!params.containsKey("not-file")) continue;
                            notFile.println(line);
                            continue;
                        }
                        if (chrom.equals("Chrom")) {
                            if (params.containsKey("output-file")) {
                                outFile.println(line);
                            } else {
                                System.out.println(line);
                            }
                            if (!params.containsKey("not-file")) continue;
                            notFile.println(line);
                            continue;
                        }
                        int position = Integer.parseInt(lineContents[1]);
                        boolean indelFilter = false;
                        if (params.containsKey("indel-file")) {
                            String key1 = String.valueOf(chrom) + "\t" + position;
                            String key2 = String.valueOf(chrom) + "\t" + (position - 1);
                            String key3 = String.valueOf(chrom) + "\t" + (position + 1);
                            if (indelPositions.containsKey(key1) || indelPositions.containsKey(key2) || indelPositions.containsKey(key3)) {
                                indelFilter = true;
                            }
                        }
                        if (indelFilter) {
                            stats.put("numNearIndel", (Integer)stats.get("numNearIndel") + 1);
                            stats.put("numVariants", (Integer)stats.get("numVariants") + 1);
                            if (!params.containsKey("not-file")) continue;
                            notFile.println(line);
                            continue;
                        }
                        if (isVCF) {
                            int maxCol = lineContents.length;
                            String vcfLine = "";
                            int numSamples = 0;
                            int numSamplesReferencePass = 0;
                            int numSamplesVariantPass = 0;
                            int colCounter = 0;
                            while (colCounter < maxCol) {
                                if (colCounter < 9) {
                                    if (colCounter > 0) {
                                        vcfLine = String.valueOf(vcfLine) + "\t";
                                    }
                                    vcfLine = String.valueOf(vcfLine) + lineContents[colCounter];
                                } else {
                                    ++numSamples;
                                    vcfLine = String.valueOf(vcfLine) + "\t";
                                    String[] sampleContents = lineContents[colCounter].split(":");
                                    String gt = sampleContents[0];
                                    stats.put("numVariants", (Integer)stats.get("numVariants") + 1);
                                    if (gt.contains(".")) {
                                        stats.put("numNoGenotype", (Integer)stats.get("numNoGenotype") + 1);
                                    } else {
                                        int qualityDepth = Integer.parseInt(sampleContents[3]);
                                        int reads1 = Integer.parseInt(sampleContents[4]);
                                        int reads2 = Integer.parseInt(sampleContents[5]);
                                        varFreq = (double)reads2 / (double)(reads1 + reads2);
                                        double pValue = Float.parseFloat(sampleContents[7]);
                                        int qual1 = Integer.parseInt(sampleContents[8]);
                                        int qual2 = Integer.parseInt(sampleContents[9]);
                                        int reads1plus = Integer.parseInt(sampleContents[10]);
                                        int reads1minus = Integer.parseInt(sampleContents[11]);
                                        int reads2plus = Integer.parseInt(sampleContents[12]);
                                        int reads2minus = Integer.parseInt(sampleContents[13]);
                                        boolean strandFail = false;
                                        if (reads1plus > 0 && reads1minus > 0 && (reads2plus == 0 || reads2minus == 0)) {
                                            strandFail = true;
                                        }
                                        boolean isFiltered = true;
                                        if (qualityDepth < minCoverage) {
                                            stats.put("numFailCoverage", (Integer)stats.get("numFailCoverage") + 1);
                                            isFiltered = true;
                                        }
                                        if (gt.equals("0/0")) {
                                            stats.put("numCalledRef", (Integer)stats.get("numCalledRef") + 1);
                                            if (!isFiltered) {
                                                ++numSamplesReferencePass;
                                            }
                                        } else if (reads2 < minReads2) {
                                            stats.put("numFailReads2", (Integer)stats.get("numFailReads2") + 1);
                                            isFiltered = true;
                                        } else if (qual2 < minAvgQual) {
                                            stats.put("numFailQual", (Integer)stats.get("numFailQual") + 1);
                                            isFiltered = true;
                                        } else if (varFreq < minVarFreq) {
                                            stats.put("numFailFreq", (Integer)stats.get("numFailFreq") + 1);
                                            isFiltered = true;
                                        } else if (strandFail) {
                                            stats.put("numFailStrands", (Integer)stats.get("numFailStrands") + 1);
                                            isFiltered = true;
                                        } else if (pValue > pValueThreshold) {
                                            stats.put("numFailPvalue", (Integer)stats.get("numFailPvalue") + 1);
                                            isFiltered = true;
                                        } else {
                                            stats.put("numPassFilter", (Integer)stats.get("numPassFilter") + 1);
                                            ++numSamplesVariantPass;
                                        }
                                        if (isFiltered) {
                                            lineContents[colCounter].replace(gt, "./.");
                                        }
                                    }
                                    vcfLine = String.valueOf(vcfLine) + lineContents[colCounter];
                                }
                                ++colCounter;
                            }
                            if (numSamplesVariantPass > 0 || numSamplesReferencePass > 0) {
                                if (params.containsKey("output-file")) {
                                    outFile.println(vcfLine);
                                    continue;
                                }
                                System.out.println(vcfLine);
                                continue;
                            }
                            if (!params.containsKey("not-file")) continue;
                            notFile.println(vcfLine);
                            continue;
                        }
                        stats.put("numVariants", (Integer)stats.get("numVariants") + 1);
                        String ref = lineContents[2];
                        String var = lineContents[3];
                        int reads1 = Integer.parseInt(lineContents[4]);
                        int reads2 = Integer.parseInt(lineContents[5]);
                        int strands1 = Integer.parseInt(lineContents[7]);
                        int strands2 = Integer.parseInt(lineContents[8]);
                        int qual1 = Integer.parseInt(lineContents[9]);
                        int qual2 = Integer.parseInt(lineContents[10]);
                        double pValue = Float.parseFloat(lineContents[11]);
                        int coverage = reads1 + reads2;
                        varFreq = (double)reads2 / (double)(reads1 + reads2);
                        boolean isFiltered = true;
                        if (coverage >= minCoverage) {
                            if (ref.equals(var)) {
                                stats.put("numCalledRef", (Integer)stats.get("numCalledRef") + 1);
                                if (params.containsKey("output-file")) {
                                    outFile.println(line);
                                } else {
                                    System.out.println(line);
                                }
                            } else if (reads2 >= minReads2) {
                                if (strands2 >= minStrands2) {
                                    if (qual2 >= minAvgQual) {
                                        if (varFreq >= minVarFreq) {
                                            if (pValue >= 0.98) {
                                                pValue = VarScan.getSignificance(reads1, reads2);
                                            }
                                            if (pValue <= pValueThreshold) {
                                                stats.put("numPassFilter", (Integer)stats.get("numPassFilter") + 1);
                                                if (params.containsKey("output-file")) {
                                                    outFile.println(line);
                                                } else {
                                                    System.out.println(line);
                                                }
                                                isFiltered = false;
                                            } else {
                                                stats.put("numFailPvalue", (Integer)stats.get("numFailPvalue") + 1);
                                            }
                                        } else {
                                            stats.put("numFailFreq", (Integer)stats.get("numFailFreq") + 1);
                                        }
                                    } else {
                                        stats.put("numFailQual", (Integer)stats.get("numFailQual") + 1);
                                    }
                                } else {
                                    stats.put("numFailStrands", (Integer)stats.get("numFailStrands") + 1);
                                }
                            } else {
                                stats.put("numFailReads2", (Integer)stats.get("numFailReads2") + 1);
                            }
                        } else {
                            stats.put("numFailCoverage", (Integer)stats.get("numFailCoverage") + 1);
                        }
                        if (!isFiltered || !params.containsKey("not-file")) continue;
                        notFile.println(line);
                    }
                    catch (Exception e) {
                        if (lineCounter == 1) {
                            System.out.println(line);
                            if (!params.containsKey("output-file")) continue;
                            outFile.println(line);
                            continue;
                        }
                        System.err.println("Parsing Exception on line:\n" + line + "\n" + e.getLocalizedMessage());
                        stats.put("numParsingExceptions", (Integer)stats.get("numParsingExceptions") + 1);
                        if ((Integer)stats.get("numParsingExceptions") < 5) continue;
                        System.err.println("Too many parsing exceptions encountered; exiting");
                        return;
                    }
                }
                System.err.println(stats.get("numVariants") + " entries in input stream");
                System.err.println(stats.get("numNoGenotype") + " had no genotype");
                System.err.println(stats.get("numCalledRef") + " were called wild-type");
                System.err.println(stats.get("numFailCoverage") + " failed coverage");
                System.err.println(stats.get("numFailReads2") + " failed reads2");
                System.err.println(stats.get("numFailStrands") + " failed strands");
                System.err.println(stats.get("numFailQual") + " failed quality");
                System.err.println(stats.get("numFailFreq") + " failed variant frequency < " + minVarFreq);
                System.err.println(stats.get("numFailPvalue") + " failed P-value > " + pValueThreshold);
                System.err.println(stats.get("numNearIndel") + " were removed near indels");
                System.err.println(stats.get("numPassFilter") + " passed filters");
                in.close();
            } else {
                System.err.println("Input file not found!");
                System.err.println(usage);
            }
        }
        catch (Exception e) {
            System.err.println("Error Parsing Input File: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            return;
        }
    }

    static HashMap<String, Boolean> loadIndels(String filename) {
        HashMap<String, Boolean> indels = new HashMap<String, Boolean>();
        try {
            File infile = new File(filename);
            if (infile.exists()) {
                BufferedReader in = new BufferedReader(new FileReader(infile));
                if (in.ready()) {
                    String line;
                    while ((line = in.readLine()) != null) {
                        if (line.startsWith("#")) continue;
                        String[] lineContents = line.split("\t");
                        String chrom = lineContents[0];
                        String position = lineContents[1];
                        String indelKey = String.valueOf(chrom) + "\t" + position;
                        indels.put(indelKey, Boolean.TRUE);
                    }
                } else {
                    System.err.println("Unable to open indels file for reading");
                }
                in.close();
            }
        }
        catch (Exception e) {
            System.err.println("Error Parsing Indel File: " + e.getLocalizedMessage());
        }
        return indels;
    }
}

