/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import net.sf.varscan.VarScan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterSomatic {
    public FilterSomatic(String[] args) {
        String usage = "USAGE: java -jar VarScan.jar filter [variant file] OPTIONS\n\tvariant file - A file of SNPs or indels\n\n\tOPTIONS:\n\t--min-coverage\tMinimum read depth at a position to make a call [10]\n\t--min-reads2\tMinimum supporting reads at a position to call variants [4]\n\t--min-strands2\tMinimum # of strands on which variant observed (1 or 2) [1]\n\t--min-var-freq\tMinimum variant allele frequency threshold [0.20]\n\t--p-value\tDefault p-value threshold for calling variants [5e-02]\n\t--indel-file\tFile of indels for filtering nearby SNPs\n\t--output-file\tOptional output file for filtered variants";
        int minCoverage = 8;
        int minReads2 = 4;
        int minStrands2 = 1;
        int minAvgQual = 20;
        double minVarFreq = 0.2;
        double pValueThreshold = 0.05;
        int windowSize = 10;
        int windowSNPs = 3;
        int indelMargin = 3;
        String outFileName = "";
        HashMap<Object, Object> indelPositions = new HashMap();
        HashMap params = VarScan.getParams(args);
        try {
            if (params.containsKey("output-file")) {
                outFileName = (String)params.get("output-file");
            }
            if (params.containsKey("window-size")) {
                windowSize = Integer.parseInt((String)params.get("window-size"));
            }
            if (params.containsKey("window-snps")) {
                windowSNPs = Integer.parseInt((String)params.get("window-snps"));
            }
            if (params.containsKey("indel-margin")) {
                indelMargin = Integer.parseInt((String)params.get("indel-margin"));
            }
            if (params.containsKey("indel-file")) {
                indelPositions = FilterSomatic.loadIndels((String)params.get("indel-file"));
            }
            if (params.containsKey("min-coverage")) {
                minCoverage = Integer.parseInt((String)params.get("min-coverage"));
            }
            if (params.containsKey("min-reads2")) {
                minReads2 = Integer.parseInt((String)params.get("min-reads2"));
            }
            if (params.containsKey("min-strands2")) {
                minStrands2 = Integer.parseInt((String)params.get("min-strands2"));
            }
            if (params.containsKey("min-var-freq")) {
                minVarFreq = Double.parseDouble((String)params.get("min-var-freq"));
            }
            if (params.containsKey("min-avg-qual")) {
                minAvgQual = Integer.parseInt((String)params.get("min-avg-qual"));
            }
            if (params.containsKey("p-value")) {
                pValueThreshold = Double.parseDouble((String)params.get("p-value"));
            }
            System.err.println("Window size:\t" + windowSize);
            System.err.println("Window SNPs:\t" + windowSNPs);
            System.err.println("Indel margin:\t" + indelMargin);
        }
        catch (Exception e) {
            System.err.println("Input Parameter Threw Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        if (params.containsKey("help") || params.containsKey("h")) {
            System.err.println(usage);
            return;
        }
        HashMap<String, Boolean> clusterSNPs = FilterSomatic.findSNPclusters(windowSize, windowSNPs, args);
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        stats.put("numVariants", 0);
        stats.put("numFailCoverage", 0);
        stats.put("numFailVarFreq", 0);
        stats.put("numFailPvalue", 0);
        stats.put("numFailReads2", 0);
        stats.put("numNearIndel", 0);
        stats.put("numSNPcluster", 0);
        stats.put("numPassFilter", 0);
        stats.put("numParsingExceptions", 0);
        try {
            BufferedReader in;
            PrintStream outFile = null;
            if (params.containsKey("output-file")) {
                outFile = new PrintStream(new FileOutputStream(outFileName));
            }
            if ((in = VarScan.getInfile(args)) == null) {
                System.out.println(usage);
                return;
            }
            int numNaps = 0;
            while (!in.ready()) {
                try {
                    Thread.sleep(5000L);
                    if (++numNaps <= 100) continue;
                    System.err.println("Input file was not ready after 100 5-second cycles!");
                    System.exit(10);
                }
                catch (Exception e) {
                    System.err.println("Exception while trying to get input" + e.getMessage());
                    System.exit(1);
                }
            }
            int lineCounter = 0;
            boolean isVCF = false;
            if (in != null && in.ready()) {
                String line;
                while ((line = in.readLine()) != null) {
                    ++lineCounter;
                    try {
                        String[] lineContents = line.split("\t");
                        String chrom = lineContents[0];
                        if (line.startsWith("#")) {
                            isVCF = true;
                        }
                        if (chrom.equals("Chrom") || chrom.equals("chrom") || line.startsWith("#")) {
                            if (!params.containsKey("output-file")) continue;
                            outFile.println(line);
                            continue;
                        }
                        stats.put("numVariants", (Integer)stats.get("numVariants") + 1);
                        int position = Integer.parseInt(lineContents[1]);
                        String thisKey = String.valueOf(chrom) + "\t" + position;
                        int normalReads1 = 0;
                        int normalReads2 = 0;
                        int tumorReads1 = 0;
                        int tumorReads2 = 0;
                        String somaticStatus = "";
                        double somaticPvalue = 0.0;
                        if (isVCF) {
                            String info = lineContents[7];
                            String normal = lineContents[9];
                            String tumor = lineContents[10];
                            String[] infoContents = info.split(";");
                            int colCounter = 0;
                            while (colCounter < infoContents.length) {
                                String element = infoContents[colCounter];
                                String[] elementContents = element.split("=");
                                if (elementContents[0].equals("SS")) {
                                    somaticStatus = elementContents[1];
                                } else if (elementContents[0].equals("GPV") && somaticStatus.equals("1")) {
                                    somaticPvalue = Double.parseDouble(elementContents[1]);
                                } else if (elementContents[0].equals("SPV") && !somaticStatus.equals("1")) {
                                    somaticPvalue = Double.parseDouble(elementContents[1]);
                                }
                                ++colCounter;
                            }
                            String[] normalContents = normal.split(":");
                            normalReads1 = Integer.parseInt(normalContents[3]);
                            normalReads2 = Integer.parseInt(normalContents[4]);
                            String[] tumorContents = tumor.split(":");
                            tumorReads1 = Integer.parseInt(tumorContents[3]);
                            tumorReads2 = Integer.parseInt(tumorContents[4]);
                        } else {
                            normalReads1 = Integer.parseInt(lineContents[4]);
                            normalReads2 = Integer.parseInt(lineContents[5]);
                            tumorReads1 = Integer.parseInt(lineContents[8]);
                            tumorReads2 = Integer.parseInt(lineContents[9]);
                            somaticStatus = lineContents[12];
                            somaticPvalue = Double.parseDouble(lineContents[14]);
                        }
                        double normalFreq = 0.0;
                        double tumorFreq = 0.0;
                        int normalCoverage = normalReads1 + normalReads2;
                        int tumorCoverage = tumorReads1 + tumorReads2;
                        if (normalReads1 > 0 || normalReads2 > 0) {
                            normalFreq = (double)normalReads2 / (double)(normalReads1 + normalReads2);
                        }
                        if (tumorReads1 > 0 || tumorReads2 > 0) {
                            tumorFreq = (double)tumorReads2 / (double)(tumorReads1 + tumorReads2);
                        }
                        if (normalReads1 > 0 || normalReads2 > 0) {
                            normalFreq = (double)normalReads2 / (double)(normalReads1 + normalReads2);
                        }
                        if (tumorReads1 > 0 || tumorReads2 > 0) {
                            tumorFreq = (double)tumorReads2 / (double)(tumorReads1 + tumorReads2);
                        }
                        boolean filterFlag = false;
                        boolean indelFlag = false;
                        boolean clusterFlag = false;
                        if (normalCoverage < minCoverage || tumorCoverage < minCoverage) {
                            filterFlag = true;
                            stats.put("numFailCoverage", (Integer)stats.get("numFailCoverage") + 1);
                        } else if (tumorReads2 < minReads2) {
                            filterFlag = true;
                            stats.put("numFailReads2", (Integer)stats.get("numFailReads2") + 1);
                        } else if (tumorFreq < minVarFreq) {
                            filterFlag = true;
                            stats.put("numFailVarFreq", (Integer)stats.get("numFailVarFreq") + 1);
                        } else if (somaticPvalue > pValueThreshold) {
                            filterFlag = true;
                            stats.put("numFailPvalue", (Integer)stats.get("numFailPvalue") + 1);
                        }
                        if (clusterSNPs.containsKey(thisKey)) {
                            clusterFlag = true;
                        } else if (params.containsKey("indel-file")) {
                            int thisPosition = position - indelMargin;
                            while (thisPosition <= position + indelMargin) {
                                String key = String.valueOf(chrom) + "\t" + thisPosition;
                                if (indelPositions.containsKey(key)) {
                                    indelFlag = true;
                                }
                                ++thisPosition;
                            }
                        }
                        if (filterFlag) continue;
                        if (indelFlag) {
                            stats.put("numNearIndel", (Integer)stats.get("numNearIndel") + 1);
                            continue;
                        }
                        if (clusterFlag) {
                            stats.put("numSNPcluster", (Integer)stats.get("numSNPcluster") + 1);
                            continue;
                        }
                        if (params.containsKey("output-file")) {
                            outFile.println(line);
                        }
                        stats.put("numPassFilter", (Integer)stats.get("numPassFilter") + 1);
                    }
                    catch (Exception e) {
                        if (lineCounter == 1) {
                            if (!params.containsKey("output-file")) continue;
                            outFile.println(line);
                            continue;
                        }
                        System.err.println("Parsing Exception on line:\n" + line + "\n" + e.getLocalizedMessage());
                        stats.put("numParsingExceptions", (Integer)stats.get("numParsingExceptions") + 1);
                        if ((Integer)stats.get("numParsingExceptions") < 5) continue;
                        System.err.println("Too many parsing exceptions encountered; exiting");
                        return;
                    }
                }
                System.err.println(stats.get("numVariants") + " variants in input stream");
                System.err.println(stats.get("numFailCoverage") + " failed to meet coverage requirement");
                System.err.println(stats.get("numFailReads2") + " failed to meet reads2 requirement");
                System.err.println(stats.get("numFailVarFreq") + " failed to meet varfreq requirement");
                System.err.println(stats.get("numFailPvalue") + " failed to meet p-value requirement");
                System.err.println(stats.get("numSNPcluster") + " in SNP clusters were removed");
                System.err.println(stats.get("numNearIndel") + " were removed near indels");
                System.err.println(stats.get("numPassFilter") + " passed filters");
                in.close();
            } else {
                System.err.println("Input file not found!");
                System.err.println(usage);
            }
        }
        catch (Exception e) {
            System.err.println("Error Parsing Input File: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            return;
        }
    }

    static HashMap<String, Boolean> loadIndels(String filename) {
        HashMap<String, Boolean> indels = new HashMap<String, Boolean>();
        try {
            File infile = new File(filename);
            if (infile.exists()) {
                BufferedReader in = new BufferedReader(new FileReader(infile));
                if (in.ready()) {
                    String line;
                    while ((line = in.readLine()) != null) {
                        String[] lineContents = line.split("\t");
                        String chrom = lineContents[0];
                        if (chrom.equals("Chrom") || line.startsWith("#")) continue;
                        String position = lineContents[1];
                        String indelKey = String.valueOf(chrom) + "\t" + position;
                        indels.put(indelKey, Boolean.TRUE);
                    }
                } else {
                    System.err.println("Unable to open indels file for reading");
                }
                in.close();
            }
        }
        catch (Exception e) {
            System.err.println("Error Parsing Indel File: " + e.getLocalizedMessage());
        }
        return indels;
    }

    static HashMap<String, Boolean> findSNPclusters(int windowSize, int windowSNPs, String[] args) {
        HashMap<String, Boolean> snps = new HashMap<String, Boolean>();
        HashMap<String, Boolean> clusterSNPs = new HashMap<String, Boolean>();
        BufferedReader in = VarScan.getInfile(args);
        int lineCounter = 0;
        try {
            if (in != null && in.ready()) {
                String line;
                while ((line = in.readLine()) != null) {
                    ++lineCounter;
                    try {
                        String[] lineContents = line.split("\t");
                        String chrom = lineContents[0];
                        if (chrom.equals("Chrom") || line.startsWith("#")) continue;
                        int position = Integer.parseInt(lineContents[1]);
                        String snpKey = String.valueOf(chrom) + "\t" + position;
                        snps.put(snpKey, Boolean.TRUE);
                    }
                    catch (Exception lineContents) {
                        // empty catch block
                    }
                }
                in.close();
            }
        }
        catch (Exception e) {
            System.err.println("Error loading SNP positions:" + e.getMessage());
        }
        int numClusterSNPs = 0;
        Object[] snpKeys = snps.keySet().toArray(new String[0]);
        Arrays.sort(snpKeys);
        Object[] objectArray = snpKeys;
        int n = snpKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Object snpPosition = objectArray[n2];
            try {
                String thisKey;
                String[] snpContents = ((String)snpPosition).split("\t");
                String chrom = snpContents[0];
                int position = Integer.parseInt(snpContents[1]);
                int numSNPsInWindow = 1;
                int thisPosition = position + 1;
                while (thisPosition <= position + windowSize) {
                    thisKey = String.valueOf(chrom) + "\t" + thisPosition;
                    if (snps.containsKey(thisKey)) {
                        ++numSNPsInWindow;
                    }
                    ++thisPosition;
                }
                if (numSNPsInWindow >= windowSNPs) {
                    clusterSNPs.put((String)snpPosition, true);
                    thisPosition = position + 1;
                    while (thisPosition <= position + windowSize) {
                        thisKey = String.valueOf(chrom) + "\t" + thisPosition;
                        if (snps.containsKey(thisKey)) {
                            clusterSNPs.put(thisKey, true);
                            ++numClusterSNPs;
                        }
                        ++thisPosition;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        System.err.println(String.valueOf(numClusterSNPs) + " cluster SNPs identified");
        return clusterSNPs;
    }
}

