/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.HashMap;
import net.sf.varscan.VarScan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coverage {
    public Coverage(String[] args) {
        String usage = "USAGE: java -jar VarScan.jar coverage [pileup-file] OPTIONS\n\n\tpileup-file - A SAMtools pileup file or piped input\n\tOPTIONS:\n\t--regions-file\tTab-delimited file of regions of interest (required)\n\t--min-base-qual\tMinimum base quality [20]\n\t--output-file\tOutput file for coverage report";
        String outFileName = "";
        String regionsFile = "";
        int minBaseQual = 20;
        int maxDepth = 50;
        String targetFileType = "regions";
        HashMap params = VarScan.getParams(args);
        try {
            if (params.containsKey("output-file")) {
                outFileName = (String)params.get("output-file");
            }
            if (params.containsKey("regions-file")) {
                regionsFile = (String)params.get("regions-file");
            }
            if (params.containsKey("min-base-qual")) {
                minBaseQual = Integer.parseInt((String)params.get("min-base-qual"));
            }
        }
        catch (Exception e) {
            System.err.println("Input Parameter Threw Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            return;
        }
        if (params.containsKey("help") || params.containsKey("h")) {
            System.err.println(usage);
            return;
        }
        HashMap<String, BitSet> targetHash = null;
        if (params.containsKey("regions-file")) {
            targetHash = Coverage.loadTargets(regionsFile, targetFileType, 0);
        }
        try {
            BufferedReader in = VarScan.getInfile(args);
            if (in == null) {
                System.out.println(usage);
                return;
            }
            int numNaps = 0;
            while (!in.ready()) {
                try {
                    Thread.sleep(5000L);
                    if (++numNaps <= 10) continue;
                    System.err.println("Input file was not ready after 10 5-second cycles!");
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            long[] positionsByDepth = new long[maxDepth + 1];
            long basesOnTarget = 0L;
            long basesOffTarget = 0L;
            int lineCounter = 0;
            int numParsingExceptions = 0;
            if (in != null && in.ready()) {
                String line;
                while ((line = in.readLine()) != null) {
                    if (params.containsKey("verbose") && ++lineCounter % 100000 == 0) {
                        System.err.println(String.valueOf(lineCounter) + " positions parsed...");
                    }
                    try {
                        String[] lineContents = line.split("\t");
                        if (lineContents.length > 5 && lineContents[0].length() > 0 && lineContents[1].length() > 0 && lineContents[2].length() > 0 && lineContents[3].length() > 0) {
                            Object refPositions;
                            String refName = lineContents[0];
                            int position = Integer.parseInt(lineContents[1]);
                            boolean inTarget = false;
                            if (!params.containsKey("regions-file")) {
                                inTarget = true;
                            } else if (targetHash.containsKey(refName) && ((BitSet)(refPositions = targetHash.get(refName))).get(position)) {
                                inTarget = true;
                            }
                            if (inTarget) {
                                ++basesOnTarget;
                                try {
                                    int readDepth = Integer.parseInt(lineContents[3]);
                                    String readQualities = lineContents[5];
                                    String mapQualities = "";
                                    if (lineContents.length > 6) {
                                        mapQualities = lineContents[6];
                                    }
                                    int qualDepth = VarScan.qualityDepth(readQualities, minBaseQual);
                                    int thisDepth = 0;
                                    while (thisDepth <= qualDepth) {
                                        int n = thisDepth++;
                                        positionsByDepth[n] = positionsByDepth[n] + 1L;
                                    }
                                }
                                catch (Exception readDepth) {}
                                continue;
                            }
                            ++basesOffTarget;
                            continue;
                        }
                        System.err.println("Error: Invalid format for pileup at line " + lineCounter + ":" + line + "\n");
                        return;
                    }
                    catch (Exception e) {
                        System.err.println("Parsing Exception on line:\n" + line + "\n" + e.getLocalizedMessage());
                        if (++numParsingExceptions >= 5) {
                            System.err.println("Too many parsing exceptions encountered; exiting");
                            return;
                        }
                        return;
                    }
                }
                in.close();
                long targetPositions = 0L;
                for (String refName : targetHash.keySet()) {
                    BitSet refPositions = targetHash.get(refName);
                    int thisPosition = 1;
                    while (thisPosition <= refPositions.size()) {
                        if (refPositions.get(thisPosition)) {
                            ++targetPositions;
                        }
                        ++thisPosition;
                    }
                }
                String outputReport = "";
                outputReport = String.valueOf(outputReport) + targetPositions + " positions targeted\n";
                outputReport = String.valueOf(outputReport) + lineCounter + " positions in pileup file\n";
                outputReport = String.valueOf(outputReport) + "TARGET SPECIFICITY\n";
                outputReport = String.valueOf(outputReport) + basesOffTarget + " bases off target\n";
                outputReport = String.valueOf(outputReport) + basesOnTarget + " bases on target\n";
                long cov50x = positionsByDepth[50];
                long cov40x = positionsByDepth[40] - positionsByDepth[50];
                long cov30x = positionsByDepth[30] - positionsByDepth[40];
                long cov20x = positionsByDepth[20] - positionsByDepth[30];
                long cov10x = positionsByDepth[10] - positionsByDepth[20];
                long cov8x = positionsByDepth[8] - positionsByDepth[10];
                long cov6x = positionsByDepth[6] - positionsByDepth[8];
                long cov2x = positionsByDepth[2] - positionsByDepth[6];
                long cov1x = positionsByDepth[1] - positionsByDepth[2];
                long cov0x = targetPositions - positionsByDepth[1];
                outputReport = String.valueOf(outputReport) + "COVERAGE BREADTH-BY-DEPTH\n";
                outputReport = String.valueOf(outputReport) + "min_depth\t50x\t40x\t30x\t20x\t10x\t8x\t6x\t2x\t1x\t0x\n";
                outputReport = String.valueOf(outputReport) + "num_positions\t" + cov50x + "\t" + cov40x + "\t" + cov30x + "\t" + cov20x + "\t" + cov10x + "\t" + cov8x + "\t" + cov6x + "\t" + cov2x + "\t" + cov1x + "\t" + cov0x + "\n";
                System.err.println(outputReport);
                outputReport = String.valueOf(outputReport) + "COVERED BASES BY DEPTH\n";
                outputReport = String.valueOf(outputReport) + "Depth\tBasesCovered\n";
                int thisDepth = 0;
                while (thisDepth <= maxDepth) {
                    outputReport = String.valueOf(outputReport) + thisDepth + "\t" + positionsByDepth[thisDepth] + "\n";
                    ++thisDepth;
                }
                if (params.containsKey("output-file")) {
                    PrintStream outFile = new PrintStream(new FileOutputStream(outFileName));
                    outFile.println(outputReport);
                    outFile.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error extracting SAM from BAM: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            return;
        }
    }

    static HashMap<String, BitSet> loadTargets(String fileName, String fileType, int marginSize) {
        HashMap<String, BitSet> positionsByChrom = new HashMap<String, BitSet>();
        int numRegions = 0;
        int numBases = 0;
        try {
            BufferedReader infile = new BufferedReader(new FileReader(fileName));
            String line = "";
            int lineCounter = 0;
            while ((line = infile.readLine()) != null) {
                ++lineCounter;
                String[] lineContents = line.split("\t");
                if (lineContents.length < 2) continue;
                try {
                    int position;
                    String refName = lineContents[0];
                    BitSet refPositions = positionsByChrom.containsKey(refName) ? positionsByChrom.get(refName) : new BitSet();
                    int chrStart = 0;
                    int chrStop = 0;
                    if (fileType.equals("positions") && lineContents.length > 1) {
                        position = Integer.parseInt(lineContents[1]);
                        chrStart = position - marginSize;
                        chrStop = position + marginSize;
                    } else if (fileType.equals("regions") && lineContents.length > 2) {
                        chrStart = Integer.parseInt(lineContents[1]) - marginSize;
                        chrStop = Integer.parseInt(lineContents[2]) + marginSize;
                    }
                    if (chrStart <= chrStop) {
                        ++numRegions;
                        position = chrStart;
                        while (position <= chrStop) {
                            if (!refPositions.get(position)) {
                                ++numBases;
                                refPositions.set(position, true);
                            }
                            ++position;
                        }
                    }
                    positionsByChrom.put(refName, refPositions);
                }
                catch (Exception e) {
                    if (lineCounter <= 1) continue;
                    System.err.println("Warning: Unable to parse chrom/position from " + line);
                }
            }
            infile.close();
        }
        catch (Exception e) {
            System.err.println("ERROR: File Parsing Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
        }
        System.err.println(String.valueOf(numRegions) + " regions parsed");
        System.err.println(String.valueOf(numBases) + " unique positions targeted");
        return positionsByChrom;
    }
}

