/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import net.sf.varscan.VarScan;

public class Copynumber {
    public Copynumber(String[] args, boolean isMpileup) {
        String usage = "USAGE: java -jar VarScan.jar copynumber [normal-tumor.mpileup] [Opt: output] OPTIONS\n\tnormal-tumor.mpileup - The SAMtools mpileup file for Normal and Tumor\n\toutput - Output base name for files\n\nOPTIONS:\n\t--min-base-qual - Minimum base quality to count for coverage [20]\n\t--min-map-qual - Minimum read mapping quality to count for coverage [20]\n\t--min-coverage - Minimum coverage threshold for copynumber segments [20]\n\t--min-segment-size - Minimum number of consecutive bases to report a segment [10]\n\t--max-segment-size - Max size before a new segment is made [100]\n\t--p-value - P-value threshold for significant copynumber change-point [0.01]\n\t--data-ratio - The normal/tumor input data ratio for copynumber adjustment [1.0]\n";
        if (args.length < 2) {
            System.err.println(usage);
            return;
        }
        HashMap params = VarScan.getParams(args);
        DecimalFormat pvalueFormat = new DecimalFormat("0.####E0");
        String outputName = "output";
        if (args.length >= 3 && !args[2].startsWith("-")) {
            outputName = args[2];
        }
        int minCoverage = 10;
        int minBaseQual = 15;
        int minSegmentSize = 10;
        int maxSegmentSize = 100;
        double dataRatio = 1.0;
        double pValueThreshold = 0.01;
        try {
            if (params.containsKey("min-coverage")) {
                minCoverage = Integer.parseInt((String)params.get("min-coverage"));
            }
            if (params.containsKey("min-base-qual")) {
                minBaseQual = Integer.parseInt((String)params.get("min-base-qual"));
            }
            if (params.containsKey("min-segment-size")) {
                minSegmentSize = Integer.parseInt((String)params.get("min-segment-size"));
            }
            if (params.containsKey("max-segment-size")) {
                maxSegmentSize = Integer.parseInt((String)params.get("max-segment-size"));
            }
            if (params.containsKey("p-value")) {
                pValueThreshold = Double.parseDouble((String)params.get("p-value"));
            }
            if (params.containsKey("data-ratio")) {
                dataRatio = Double.parseDouble((String)params.get("data-ratio"));
            }
            System.err.println("Min coverage:\t" + minCoverage);
            System.err.println("Min avg qual:\t" + minBaseQual);
            System.err.println("P-value thresh:\t" + pValueThreshold);
        }
        catch (Exception e) {
            System.err.println("Input Parameter Threw Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        if (params.containsKey("help") || params.containsKey("h")) {
            System.err.println(usage);
            return;
        }
        if (args.length < 3) {
            System.err.println("Please provide an output file basename!");
            System.err.println(usage);
            System.exit(1);
        }
        try {
            BufferedReader in = VarScan.getInfile(args);
            if (in == null) {
                System.out.println(usage);
                return;
            }
            int numNaps = 0;
            while (!in.ready()) {
                try {
                    Thread.sleep(5000L);
                    if (++numNaps <= 100) continue;
                    System.err.println("Input file was not ready after 100 5-second cycles!");
                    System.exit(10);
                }
                catch (Exception e) {
                    System.err.println("Exception while trying to get input" + e.getMessage());
                    System.exit(1);
                }
            }
            if (in != null && in.ready()) {
                String line;
                PrintStream outCopySegments = null;
                outCopySegments = new PrintStream(new FileOutputStream(String.valueOf(outputName) + ".copynumber"));
                outCopySegments.println("chrom\tchr_start\tchr_stop\tnum_positions\tnormal_depth\ttumor_depth\tlog2_ratio\tgc_content");
                System.err.println("Reading mpileup input...");
                int numParsingExceptions = 0;
                long sharedPositions = 0L;
                long comparedPositions = 0L;
                long rawCopySegments = 0L;
                long goodCopySegments = 0L;
                String chromNormal = "";
                String chromTumor = "";
                String refBase = "";
                int posNormal = 0;
                int posTumor = 0;
                String copyChrom = "";
                int copyStart = 0;
                int copyStop = 0;
                int copyDepthNormal = 0;
                int copyDepthTumor = 0;
                long copySumNormal = 0L;
                long copySumTumor = 0L;
                long copyPositions = 0L;
                long copyPositionsGC = 0L;
                DecimalFormat oneDigit = new DecimalFormat("#0.0");
                DecimalFormat threeDigits = new DecimalFormat("#0.000");
                while ((line = in.readLine()) != null) {
                    try {
                        String[] lineContents = line.split("\t");
                        if (lineContents.length > 5 && lineContents[0].length() > 0 && lineContents[1].length() > 0 && lineContents[2].length() > 0 && lineContents[3].length() > 0) {
                            ++sharedPositions;
                            String refName = lineContents[0];
                            int position = Integer.parseInt(lineContents[1]);
                            refBase = lineContents[2].toUpperCase();
                            chromNormal = refName;
                            chromTumor = refName;
                            posNormal = position;
                            posTumor = position;
                            int normalOffset = 3;
                            int pileupDepthNormal = Integer.parseInt(lineContents[normalOffset]);
                            String normalQualities = lineContents[normalOffset + 2];
                            int tumorOffset = 6;
                            int pileupDepthTumor = Integer.parseInt(lineContents[tumorOffset]);
                            String tumorQualities = lineContents[tumorOffset + 2];
                            if (pileupDepthNormal >= minCoverage && normalQualities.length() > 0) {
                                double changePvalue;
                                ++comparedPositions;
                                int normalDepth = VarScan.qualityDepth(normalQualities, minBaseQual);
                                int tumorDepth = 0;
                                if (tumorQualities.length() > 0) {
                                    tumorDepth = VarScan.qualityDepth(tumorQualities, minBaseQual);
                                }
                                int diffNormal = Math.abs(copyDepthNormal - normalDepth);
                                int diffTumor = Math.abs(copyDepthTumor - tumorDepth);
                                int posDiff = posTumor - copyStop;
                                boolean continueFlag = false;
                                continueFlag = posDiff > 2 || !copyChrom.equals(chromTumor) ? false : (copyPositions >= (long)maxSegmentSize ? false : (diffNormal <= 2 && diffTumor <= 2 ? true : (changePvalue = VarScan.getSignificance(copyDepthNormal, copyDepthTumor, normalDepth, tumorDepth)) >= pValueThreshold));
                                if (continueFlag) {
                                    copySumNormal += (long)normalDepth;
                                    copySumTumor += (long)tumorDepth;
                                    ++copyPositions;
                                    if (refBase.equals("G") || refBase.equals("C") || refBase.equals("g") || refBase.equals("c")) {
                                        ++copyPositionsGC;
                                    }
                                    copyStop = posTumor;
                                    continue;
                                }
                                if (copyPositions >= (long)minSegmentSize) {
                                    ++rawCopySegments;
                                    String regionResults = Copynumber.processCopyRegion(copyChrom, copyStart, copyStop, copyPositions, copyPositionsGC, copySumNormal, copySumTumor, minCoverage, dataRatio);
                                    if (regionResults.length() > 0) {
                                        outCopySegments.println(regionResults);
                                        ++goodCopySegments;
                                    }
                                }
                                copyChrom = chromTumor;
                                copyStart = posTumor;
                                copyStop = posTumor;
                                copyDepthNormal = normalDepth;
                                copyDepthTumor = tumorDepth;
                                copySumNormal = normalDepth;
                                copySumTumor = tumorDepth;
                                copyPositions = 1L;
                                if (refBase.equals("G") || refBase.equals("C") || refBase.equals("g") || refBase.equals("c")) {
                                    copyPositionsGC = 1L;
                                    continue;
                                }
                                copyPositionsGC = 0L;
                                continue;
                            }
                            if (copyPositions >= (long)minSegmentSize) {
                                ++rawCopySegments;
                                String regionResults = Copynumber.processCopyRegion(copyChrom, copyStart, copyStop, copyPositions, copyPositionsGC, copySumNormal, copySumTumor, minCoverage, dataRatio);
                                if (regionResults.length() > 0) {
                                    outCopySegments.println(regionResults);
                                    ++goodCopySegments;
                                }
                            }
                            copyChrom = "";
                            copyStart = 0;
                            copyStop = 0;
                            copyDepthNormal = 0;
                            copyDepthTumor = 0;
                            copySumNormal = 0L;
                            copySumTumor = 0L;
                            copyPositions = 0L;
                            copyPositionsGC = 0L;
                            continue;
                        }
                        System.err.println("Error: Invalid format or not enough samples in mpileup: " + line + "\n");
                        return;
                    }
                    catch (Exception e) {
                        System.err.println("Parsing Exception on line:\n" + line + "\n" + e.getLocalizedMessage());
                        if (++numParsingExceptions >= 5) {
                            System.err.println("Too many parsing exceptions encountered; exiting");
                            return;
                        }
                        return;
                    }
                }
                if (copyPositions > (long)minSegmentSize) {
                    ++rawCopySegments;
                    String regionResults = Copynumber.processCopyRegion(copyChrom, copyStart, copyStop, copyPositions, copyPositionsGC, copySumNormal, copySumTumor, minCoverage, dataRatio);
                    if (regionResults.length() > 0) {
                        outCopySegments.println(regionResults);
                        ++goodCopySegments;
                    }
                }
                in.close();
                System.err.println(String.valueOf(sharedPositions) + " positions in mpileup");
                System.err.println(String.valueOf(comparedPositions) + " had sufficient coverage for comparison");
                System.err.println(String.valueOf(rawCopySegments) + " raw copynumber segments with size > " + minSegmentSize);
                System.err.println(String.valueOf(goodCopySegments) + " good copynumber segments with depth > " + minCoverage);
            } else {
                System.err.println("Input file never ready for parsing (maybe due to file I/O)...");
                System.exit(10);
            }
        }
        catch (IOException e) {
            System.err.println("File Parsing Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            System.exit(11);
        }
    }

    public Copynumber(String[] args) {
        String usage = "USAGE: VarScan copynumber [normal_pileup] [tumor_pileup] [Opt: output] OPTIONS\n\tnormal_pileup - The SAMtools pileup file for Normal\n\ttumor_pileup - The SAMtools pileup file for Tumor\n\toutput - Output base name for files\n***If you have a single mpileup, see VarScan copynumber -mpileup 1 -h ***\n\nOPTIONS:\n\t--min-base-qual - Minimum base quality to count for coverage [20]\n\t--min-map-qual - Minimum read mapping quality to count for coverage [20]\n\t--min-coverage - Minimum coverage threshold for copynumber segments [20]\n\t--min-segment-size - Minimum number of consecutive bases to report a segment [10]\n\t--max-segment-size - Max size before a new segment is made [100]\n\t--p-value - P-value threshold for significant copynumber change-point [0.01]\n\t--data-ratio - The normal/tumor input data ratio for copynumber adjustment [1.0]\n";
        if (args.length < 3) {
            System.err.println(usage);
            return;
        }
        String normalPileupFile = args[1];
        String tumorPileupFile = args[2];
        String outputName = "output";
        if (args.length >= 4 && !args[3].startsWith("-")) {
            outputName = args[3];
        }
        System.err.println("Normal Pileup: " + normalPileupFile);
        System.err.println("Tumor Pileup: " + tumorPileupFile);
        int minCoverage = 10;
        int minBaseQual = 15;
        int minSegmentSize = 10;
        int maxSegmentSize = 100;
        double dataRatio = 1.0;
        double pValueThreshold = 0.01;
        HashMap params = VarScan.getParams(args);
        try {
            if (params.containsKey("min-coverage")) {
                minCoverage = Integer.parseInt((String)params.get("min-coverage"));
            }
            if (params.containsKey("min-base-qual")) {
                minBaseQual = Integer.parseInt((String)params.get("min-base-qual"));
            }
            if (params.containsKey("min-segment-size")) {
                minSegmentSize = Integer.parseInt((String)params.get("min-segment-size"));
            }
            if (params.containsKey("max-segment-size")) {
                maxSegmentSize = Integer.parseInt((String)params.get("max-segment-size"));
            }
            if (params.containsKey("p-value")) {
                pValueThreshold = Double.parseDouble((String)params.get("p-value"));
            }
            if (params.containsKey("data-ratio")) {
                dataRatio = Double.parseDouble((String)params.get("data-ratio"));
            }
            System.err.println("Min coverage:\t" + minCoverage);
            System.err.println("Min avg qual:\t" + minBaseQual);
            System.err.println("P-value thresh:\t" + pValueThreshold);
        }
        catch (Exception e) {
            System.err.println("Input Parameter Threw Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        if (params.containsKey("help") || params.containsKey("h")) {
            System.err.println(usage);
            return;
        }
        if (args.length < 3) {
            System.err.println("Please provide an output file basename!");
            System.err.println(usage);
            System.exit(1);
        }
        long tumorPositions = 0L;
        long sharedPositions = 0L;
        long comparedPositions = 0L;
        long rawCopySegments = 0L;
        long goodCopySegments = 0L;
        try {
            String lineTumor;
            String[] normalContents;
            PrintStream outCopySegments = null;
            outCopySegments = new PrintStream(new FileOutputStream(String.valueOf(outputName) + ".copynumber"));
            outCopySegments.println("chrom\tchr_start\tchr_stop\tnum_positions\tnormal_depth\ttumor_depth\tlog2_ratio\tgc_content");
            BufferedReader normal = new BufferedReader(new FileReader(normalPileupFile));
            BufferedReader tumor = new BufferedReader(new FileReader(tumorPileupFile));
            if (!normal.ready() || !tumor.ready()) {
                try {
                    Thread.sleep(5000L);
                    if (!normal.ready() || !tumor.ready()) {
                        Thread.sleep(5000L);
                    }
                    if (!normal.ready() || !tumor.ready()) {
                        Thread.sleep(5000L);
                    }
                    if (!normal.ready() || !tumor.ready()) {
                        Thread.sleep(5000L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!normal.ready() || !tumor.ready()) {
                System.err.println("ERROR: Invalid input file(s)");
                System.exit(10);
            }
            String chromNormal = "";
            String chromTumor = "";
            String prevChromNormal = "";
            String prevChromTumor = "";
            String refBase = "";
            int posNormal = 0;
            int posTumor = 0;
            String copyChrom = "";
            int copyStart = 0;
            int copyStop = 0;
            int copyDepthNormal = 0;
            int copyDepthTumor = 0;
            long copySumNormal = 0L;
            long copySumTumor = 0L;
            long copyPositions = 0L;
            long copyPositionsGC = 0L;
            DecimalFormat oneDigit = new DecimalFormat("#0.0");
            DecimalFormat threeDigits = new DecimalFormat("#0.000");
            String lineNormal = normal.readLine();
            if (lineNormal != null && (normalContents = lineNormal.split("\t")).length > 1) {
                chromNormal = normalContents[0];
                posNormal = Integer.parseInt(normalContents[1]);
            }
            while ((lineTumor = tumor.readLine()) != null) {
                String[] normalContents2;
                ++tumorPositions;
                String[] tumorContents = lineTumor.split("\t");
                if (tumorContents.length > 1) {
                    chromTumor = tumorContents[0];
                    posTumor = Integer.parseInt(tumorContents[1]);
                }
                boolean flagEOF = false;
                boolean normalWasReset = false;
                while (!(chromNormal.equals(chromTumor) || chromTumor.equals(prevChromTumor) || flagEOF || !chromNormal.equals(prevChromTumor) && !Copynumber.inSortOrder(chromNormal, chromTumor))) {
                    lineNormal = normal.readLine();
                    if (lineNormal != null) {
                        normalContents2 = lineNormal.split("\t");
                        if (normalContents2.length <= 1) continue;
                        chromNormal = normalContents2[0];
                        posNormal = Integer.parseInt(normalContents2[1]);
                        continue;
                    }
                    flagEOF = true;
                }
                if (chromNormal.equals(chromTumor) && !chromNormal.equals("")) {
                    int pileupDepthNormal;
                    normalWasReset = false;
                    while (chromNormal.equals(chromTumor) && posNormal < posTumor && (lineNormal = normal.readLine()) != null) {
                        normalContents2 = lineNormal.split("\t");
                        if (normalContents2.length <= 1) continue;
                        chromNormal = normalContents2[0];
                        posNormal = Integer.parseInt(normalContents2[1]);
                        if (posNormal >= posTumor) continue;
                        pileupDepthNormal = 0;
                        String normalQualities = "";
                        if (normalContents2.length <= 7) {
                            pileupDepthNormal = Integer.parseInt(normalContents2[3]);
                            normalQualities = normalContents2[5];
                            continue;
                        }
                        if (normalContents2.length < 10 || normalContents2.length > 11) continue;
                        pileupDepthNormal = Integer.parseInt(normalContents2[7]);
                        normalQualities = normalContents2[9];
                    }
                    while (chromNormal.equals(chromTumor) && posTumor < posNormal && (lineTumor = tumor.readLine()) != null) {
                        tumorContents = lineTumor.split("\t");
                        if (tumorContents.length <= 1) continue;
                        chromTumor = tumorContents[0];
                        posTumor = Integer.parseInt(tumorContents[1]);
                    }
                    if (!chromNormal.equals(chromTumor) || !chromNormal.equals(chromTumor) || posNormal != posTumor) continue;
                    ++sharedPositions;
                    refBase = tumorContents[2];
                    normalContents2 = lineNormal.split("\t");
                    pileupDepthNormal = 0;
                    int pileupDepthTumor = 0;
                    String normalQualities = "";
                    String tumorQualities = "";
                    if (normalContents2.length >= 6 && normalContents2.length <= 7) {
                        pileupDepthNormal = Integer.parseInt(normalContents2[3]);
                        normalQualities = normalContents2[5];
                    } else if (normalContents2.length >= 10 && normalContents2.length <= 11) {
                        pileupDepthNormal = Integer.parseInt(normalContents2[7]);
                        normalQualities = normalContents2[9];
                    }
                    if (tumorContents.length >= 6 && tumorContents.length <= 7) {
                        tumorQualities = tumorContents[5];
                        pileupDepthTumor = Integer.parseInt(tumorContents[3]);
                    } else if (tumorContents.length >= 10 && tumorContents.length <= 11) {
                        tumorQualities = tumorContents[9];
                        pileupDepthTumor = Integer.parseInt(tumorContents[7]);
                    }
                    if (pileupDepthNormal >= minCoverage && normalQualities.length() > 0) {
                        double changePvalue;
                        ++comparedPositions;
                        int normalDepth = VarScan.qualityDepth(normalQualities, minBaseQual);
                        int tumorDepth = VarScan.qualityDepth(tumorQualities, minBaseQual);
                        int diffNormal = Math.abs(copyDepthNormal - normalDepth);
                        int diffTumor = Math.abs(copyDepthTumor - tumorDepth);
                        int posDiff = posTumor - copyStop;
                        boolean continueFlag = false;
                        continueFlag = posDiff > 2 || !copyChrom.equals(chromTumor) ? false : (copyPositions >= (long)maxSegmentSize ? false : (diffNormal <= 2 && diffTumor <= 2 ? true : (changePvalue = VarScan.getSignificance(copyDepthNormal, copyDepthTumor, normalDepth, tumorDepth)) >= pValueThreshold));
                        if (continueFlag) {
                            copySumNormal += (long)normalDepth;
                            copySumTumor += (long)tumorDepth;
                            ++copyPositions;
                            if (refBase.equals("G") || refBase.equals("C") || refBase.equals("g") || refBase.equals("c")) {
                                ++copyPositionsGC;
                            }
                            copyStop = posTumor;
                        } else {
                            if (copyPositions >= (long)minSegmentSize) {
                                ++rawCopySegments;
                                String regionResults = Copynumber.processCopyRegion(copyChrom, copyStart, copyStop, copyPositions, copyPositionsGC, copySumNormal, copySumTumor, minCoverage, dataRatio);
                                if (regionResults.length() > 0) {
                                    outCopySegments.println(regionResults);
                                    ++goodCopySegments;
                                }
                            }
                            copyChrom = chromTumor;
                            copyStart = posTumor;
                            copyStop = posTumor;
                            copyDepthNormal = normalDepth;
                            copyDepthTumor = tumorDepth;
                            copySumNormal = normalDepth;
                            copySumTumor = tumorDepth;
                            copyPositions = 1L;
                            copyPositionsGC = refBase.equals("G") || refBase.equals("C") || refBase.equals("g") || refBase.equals("c") ? 1L : 0L;
                        }
                    } else {
                        if (copyPositions >= (long)minSegmentSize) {
                            ++rawCopySegments;
                            String regionResults = Copynumber.processCopyRegion(copyChrom, copyStart, copyStop, copyPositions, copyPositionsGC, copySumNormal, copySumTumor, minCoverage, dataRatio);
                            if (regionResults.length() > 0) {
                                outCopySegments.println(regionResults);
                                ++goodCopySegments;
                            }
                        }
                        copyChrom = "";
                        copyStart = 0;
                        copyStop = 0;
                        copyDepthNormal = 0;
                        copyDepthTumor = 0;
                        copySumNormal = 0L;
                        copySumTumor = 0L;
                        copyPositions = 0L;
                        copyPositionsGC = 0L;
                    }
                    prevChromNormal = chromNormal;
                    prevChromTumor = chromTumor;
                    continue;
                }
                if (Copynumber.inSortOrder(chromNormal, chromTumor)) {
                    System.err.println("Not resetting normal file because " + chromNormal + " < " + chromTumor);
                    continue;
                }
                if (!flagEOF) continue;
                flagEOF = false;
                while (prevChromTumor.equals(chromTumor) && !flagEOF) {
                    lineTumor = tumor.readLine();
                    if (lineTumor != null) {
                        tumorContents = lineTumor.split("\t");
                        if (tumorContents.length <= 1) continue;
                        chromTumor = tumorContents[0];
                        posTumor = Integer.parseInt(tumorContents[1]);
                        continue;
                    }
                    flagEOF = true;
                }
                if (flagEOF || normalWasReset) continue;
                if (Copynumber.inSortOrder(chromNormal, chromTumor)) {
                    System.err.println("Not resetting normal file because " + chromNormal + " < " + chromTumor);
                    continue;
                }
                System.err.println("Resetting normal file because " + chromNormal + " > " + chromTumor);
                normalWasReset = true;
                normal.close();
                normal = new BufferedReader(new FileReader(normalPileupFile));
            }
            normal.close();
            tumor.close();
            if (copyPositions > (long)minSegmentSize) {
                ++rawCopySegments;
                String regionResults = Copynumber.processCopyRegion(copyChrom, copyStart, copyStop, copyPositions, copyPositionsGC, copySumNormal, copySumTumor, minCoverage, dataRatio);
                if (regionResults.length() > 0) {
                    outCopySegments.println(regionResults);
                    ++goodCopySegments;
                }
            }
            outCopySegments.close();
            System.err.println(String.valueOf(tumorPositions) + " positions in tumor");
            System.err.println(String.valueOf(sharedPositions) + " positions shared in normal");
            System.err.println(String.valueOf(comparedPositions) + " had sufficient coverage for comparison");
            System.err.println(String.valueOf(rawCopySegments) + " raw copynumber segments with size > " + minSegmentSize);
            System.err.println(String.valueOf(goodCopySegments) + " good copynumber segments with depth > " + minCoverage);
        }
        catch (IOException e) {
            System.err.println("File Parsing Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            System.exit(11);
        }
    }

    static String processCopyRegion(String copyChrom, int copyStart, int copyStop, long copyPositions, long copyPositionsGC, long copySumNormal, long copySumTumor, int minCoverage, double dataRatio) {
        DecimalFormat oneDigit = new DecimalFormat("#0.0");
        DecimalFormat threeDigits = new DecimalFormat("#0.000");
        try {
            float avgNormal = (float)copySumNormal / (float)copyPositions;
            float avgTumor = (float)copySumTumor / (float)copyPositions;
            float adjustedTumorDepth = (float)dataRatio * avgTumor;
            float gcContent = (float)copyPositionsGC / (float)copyPositions * 100.0f;
            if (avgNormal >= (float)minCoverage || avgTumor >= (float)minCoverage) {
                if ((double)avgNormal >= 0.01 && (double)avgTumor >= 0.01) {
                    float tumorNormalRatio = adjustedTumorDepth / avgNormal;
                    double log2ratio = Math.log(tumorNormalRatio) / Math.log(2.0);
                    return String.valueOf(copyChrom) + "\t" + copyStart + "\t" + copyStop + "\t" + copyPositions + "\t" + oneDigit.format(avgNormal) + "\t" + oneDigit.format(avgTumor) + "\t" + threeDigits.format(log2ratio) + "\t" + oneDigit.format(gcContent);
                }
                if ((double)avgTumor >= 0.01) {
                    double log2ratio = 2.0;
                    return String.valueOf(copyChrom) + "\t" + copyStart + "\t" + copyStop + "\t" + copyPositions + "\t" + oneDigit.format(avgNormal) + "\t" + oneDigit.format(avgTumor) + "\t" + threeDigits.format(log2ratio) + "\t" + oneDigit.format(gcContent);
                }
                double log2ratio = -2.0;
                return String.valueOf(copyChrom) + "\t" + copyStart + "\t" + copyStop + "\t" + copyPositions + "\t" + oneDigit.format(avgNormal) + "\t" + oneDigit.format(avgTumor) + "\t" + threeDigits.format(log2ratio) + "\t" + oneDigit.format(gcContent);
            }
        }
        catch (Exception e) {
            System.err.println("Warning: Error while processing copynumber segment:" + e.getMessage());
        }
        return "";
    }

    static boolean inSortOrder(String chrom1, String chrom2) {
        Object[] testArray = new String[]{chrom1, chrom2};
        Arrays.sort(testArray);
        return ((String)testArray[0]).equals(chrom1);
    }

    static Boolean chromSorted(String chrom1, String chrom2) {
        Boolean answer = false;
        chrom1.replace("X", "23");
        chrom1.replace("Y", "24");
        chrom1.replace("M", "25");
        chrom2.replace("X", "23");
        chrom2.replace("Y", "24");
        chrom2.replace("M", "25");
        String[] unsorted = new String[]{chrom1, chrom2};
        Object[] sorted = new String[]{chrom1, chrom2};
        Arrays.sort(sorted);
        System.err.println("Sorted order is " + (String)sorted[0] + " " + (String)sorted[1]);
        try {
            if (((String)sorted[0]).equals(unsorted[0])) {
                answer = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return answer;
    }
}

