/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import net.sf.varscan.VarScan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyCaller {
    /*
     * Unable to fully structure code
     */
    public CopyCaller(String[] args, HashMap<String, String> params) {
        super();
        usage = "USAGE: java -jar VarScan.jar copyCaller [varScan.copynumber] OPTIONS\nThis command will adjust VarScan copynumber output for GC content, apply amp/del thresholds,\n and (optionally) recenter the data\n\tINPUT:\n\tRaw output from the VarScan copynumber command (eg. varScan.output.copynumber)\n\n\tOPTIONS:\n\t--output-file\tOutput file to contain the calls\n\t--output-homdel-file\tOptional output file for candidate homozygous deletions\n\t--min-coverage\tMinimum normal read depth at a position to make a call [20]\n\t--min-tumor-coverage\tMinimum tumor read depth at a position to make a non-homdel call [10]\n\t--max-homdel-coverage\tMaximum depth in tumor for candidate homozygous deletions [5]\n\t--amp-threshold\tLower bound for log ratio to call amplification [0.25]\n\t--del-threshold\tUpper bound for log ratio to call deletion (provide as positive number) [0.25]\n\t--min-region-size\tMinimum size (in bases) for a region to be counted [10]\n\t--recenter-up\tRecenter data around an adjusted baseline > 0 [0]\n\t--recenter-down\tRecenter data around an adjusted baseline < 0 [0]\n";
        regionsFile = "";
        outputFile = "";
        homdelFile = "";
        minCoverage = 20;
        minTumorCoverage = 10;
        maxHomdelCoverage = 5;
        minRegionSize = 10;
        ampThreshold = 0.25;
        delThreshold = -0.25;
        recenterBaseline = 0.0;
        gcLogSum = new Float[101];
        gcLogNum = new Integer[101];
        i = 0;
        while (i <= 100) {
            gcLogSum[i] = Float.valueOf(0.0f);
            gcLogNum[i] = 0;
            ++i;
        }
        try {
            if (params.containsKey("min-coverage")) {
                minCoverage = Integer.parseInt(params.get("min-coverage"));
            }
            if (params.containsKey("min-tumor-coverage")) {
                minTumorCoverage = Integer.parseInt(params.get("min-tumor-coverage"));
            }
            if (params.containsKey("max-homdel-coverage")) {
                maxHomdelCoverage = Integer.parseInt(params.get("max-homdel-coverage"));
            }
            if (params.containsKey("min-region-size")) {
                minRegionSize = Integer.parseInt(params.get("min-region-size"));
            }
            if (params.containsKey("amp-threshold")) {
                ampThreshold = Double.parseDouble(params.get("amp-threshold"));
            }
            if (params.containsKey("del-threshold")) {
                delThreshold = 0.0 - Double.parseDouble(params.get("del-threshold"));
            }
            if (params.containsKey("recenter-up")) {
                recenterBaseline = Double.parseDouble(params.get("recenter-up"));
            }
            if (params.containsKey("recenter-down")) {
                recenterBaseline = Double.parseDouble(params.get("recenter-down"));
                recenterBaseline = 0.0 - recenterBaseline;
            }
            if (params.containsKey("output-file")) {
                outputFile = params.get("output-file");
            }
            if (params.containsKey("output-homdel-file")) {
                homdelFile = params.get("output-homdel-file");
            }
            System.err.println("Min coverage:\t" + minCoverage);
        }
        catch (Exception e) {
            System.err.println("Input Parameter Threw Exception: " + e.getLocalizedMessage());
            System.err.println("Parsing " + params.get("del-threshold"));
            e.printStackTrace(System.err);
            System.exit(1);
        }
        if (params.containsKey("help") || params.containsKey("h")) {
            System.err.println(usage);
            return;
        }
        stats = new HashMap<String, Integer>();
        stats.put("numRegions", 0);
        stats.put("metMinDepth", 0);
        stats.put("metMinSize", 0);
        stats.put("numAmp", 0);
        stats.put("numDel", 0);
        stats.put("numHomDel", 0);
        stats.put("numNeutral", 0);
        threeDigits = new DecimalFormat("#0.000");
        baseCounts = new HashMap<String, Long>();
        baseCounts.put("numAmp", 0L);
        baseCounts.put("numDel", 0L);
        baseCounts.put("numHomDel", 0L);
        baseCounts.put("numNeutral", 0L);
        try {
            block57: {
                out = null;
                outGC = null;
                outHomdel = null;
                if (params.containsKey("output-file")) {
                    out = new PrintStream(new FileOutputStream(outputFile));
                    out.println("chrom\tchr_start\tchr_stop\tnum_positions\tnormal_depth\ttumor_depth\tadjusted_log_ratio\tgc_content\tregion_call\traw_ratio");
                    outGC = new PrintStream(new FileOutputStream(String.valueOf(outputFile) + ".gc"));
                    outGC.println("gc\tregions\tavg_log2\tmean_sd_log2");
                }
                if (params.containsKey("output-homdel-file")) {
                    outHomdel = new PrintStream(new FileOutputStream(homdelFile));
                    outHomdel.println("chrom\tchr_start\tchr_stop\tnum_positions\tnormal_depth\ttumor_depth\tadjusted_log_ratio\tgc_content\tregion_call\traw_ratio");
                }
                if ((in = VarScan.getInfile(args)) == null) {
                    System.out.println(usage);
                    return;
                }
                numNaps = 0;
                if (!in.ready()) {
                    try {
                        Thread.sleep(5000L);
                        if (++numNaps > 100) {
                            System.err.println("Input file was not ready after 100 5-second cycles!");
                            System.exit(10);
                        }
                    }
                    catch (Exception var28_27) {
                        // empty catch block
                    }
                }
                gcWarned = false;
                if (in.ready()) {
                    while ((line = in.readLine()) != null) {
                        if (params.containsKey("verbose") && (Integer)stats.get("numRegions") % 10000 == 0) {
                            System.err.println(stats.get("numRegions") + " regions parsed...");
                        }
                        try {
                            lineContents = line.split("\t");
                            if (lineContents.length > 4 && lineContents[0].length() > 0 && lineContents[1].length() > 0 && lineContents[2].length() > 0 && lineContents[3].length() > 0) {
                                refName = lineContents[0];
                                if (refName.equals("chrom") || refName.equals("chrom")) continue;
                                stats.put("numRegions", (Integer)stats.get("numRegions") + 1);
                                regionStart = Long.parseLong(lineContents[1]);
                                regionStop = Long.parseLong(lineContents[2]);
                                numPositions = Long.parseLong(lineContents[3]);
                                normalDepth = Float.parseFloat(lineContents[4].replace(',', '.'));
                                tumorDepth = Float.parseFloat(lineContents[5].replace(',', '.'));
                                logratio = Double.parseDouble(lineContents[6].replace(',', '.'));
                                if (recenterBaseline != 0.0) {
                                    logratio -= recenterBaseline;
                                }
                                if (lineContents.length >= 8) {
                                    if (!(normalDepth >= (float)minCoverage) || !(tumorDepth >= (float)minTumorCoverage) || (gcBin = (int)(gcContent = Float.parseFloat(lineContents[7].replace(',', '.')))) < 0 || gcBin > 100) continue;
                                    v0 = gcBin;
                                    gcLogSum[v0] = Float.valueOf(gcLogSum[v0].floatValue() + (float)logratio);
                                    v1 = gcBin;
                                    gcLogNum[v1] = gcLogNum[v1] + 1;
                                    continue;
                                }
                                if (gcWarned) continue;
                                System.err.println("Warning: Older VarScan copynumber output (without GC content column) detected, so no GC adjustment will be performed");
                                gcWarned = true;
                                continue;
                            }
                            System.err.println("Error: Invalid format for pileup at line " + stats.get("numBases") + "\n" + line + "\n");
                            return;
                        }
                        catch (Exception e) {
                            System.err.println("Parsing Exception on line:\n" + line + "\n" + e.getLocalizedMessage());
                            stats.put("numParsingExceptions", (Integer)stats.get("numParsingExceptions") + 1);
                            if ((Integer)stats.get("numParsingExceptions") < 5) continue;
                            System.err.println("Too many parsing exceptions encountered; exiting");
                            System.exit(11);
                        }
                    }
                } else {
                    System.err.println("Input was not ready for parsing!");
                    System.exit(10);
                }
                in.close();
                totalAvgSum = 0.0f;
                totalAvgNum = 0L;
                i = 0;
                while (i <= 100) {
                    if (gcLogNum[i] > 0) {
                        totalAvgSum += gcLogSum[i].floatValue();
                        totalAvgNum += (long)gcLogNum[i].intValue();
                    }
                    ++i;
                }
                totalAvgLog = totalAvgSum / (float)totalAvgNum;
                if (!gcWarned) {
                    System.err.println(String.valueOf(totalAvgLog) + " was the average log2 of copy number change");
                    System.err.println("Copy number change by GC content bin:");
                    System.err.println("bin\tregions\tavg_log2\tmean_sd");
                }
                gcLogMeanSD = new Float[101];
                try {
                    i = 0;
                    while (i <= 100) {
                        if (gcLogNum[i] > 0) {
                            binAvgLog = gcLogSum[i].floatValue() / (float)gcLogNum[i].intValue();
                            binMeanSD = binAvgLog - totalAvgLog;
                            outGC.println(String.valueOf(i) + "\t" + gcLogNum[i] + "\t" + binAvgLog + "\t" + binMeanSD);
                            System.err.println(String.valueOf(i) + "\t" + gcLogNum[i] + "\t" + binAvgLog + "\t" + binMeanSD);
                            gcLogMeanSD[i] = Float.valueOf(binMeanSD);
                        } else {
                            gcLogMeanSD[i] = Float.valueOf(0.0f);
                        }
                        ++i;
                    }
                    break block57;
                }
                catch (Exception e) {
                    System.err.println("Insufficient data for GC adjustment, so adjustment will be skipped");
                    i = 0;
                    ** while (i <= 100)
                }
lbl-1000:
                // 1 sources

                {
                    gcLogMeanSD[i] = Float.valueOf(0.0f);
                    ++i;
                    continue;
                }
            }
            in = VarScan.getInfile(args);
            if (in.ready()) {
                while ((line = in.readLine()) != null) {
                    if (params.containsKey("verbose") && (Integer)stats.get("numRegions") % 10000 == 0) {
                        System.err.println(stats.get("numRegions") + " regions parsed...");
                    }
                    try {
                        lineContents = line.split("\t");
                        if (lineContents.length > 4 && lineContents[0].length() > 0 && lineContents[1].length() > 0 && lineContents[2].length() > 0 && lineContents[3].length() > 0) {
                            refName = lineContents[0];
                            if (refName.equals("chrom") || refName.equals("chrom")) continue;
                            stats.put("numRegions", (Integer)stats.get("numRegions") + 1);
                            regionStart = Long.parseLong(lineContents[1]);
                            regionStop = Long.parseLong(lineContents[2]);
                            numPositions = Long.parseLong(lineContents[3]);
                            normalDepth = Float.parseFloat(lineContents[4].replace(',', '.'));
                            tumorDepth = Float.parseFloat(lineContents[5].replace(',', '.'));
                            adjustedRatio = logratio = Double.parseDouble(lineContents[6].replace(',', '.'));
                            if (recenterBaseline != 0.0) {
                                adjustedRatio -= recenterBaseline;
                            }
                            gcContent = -1.0f;
                            if (lineContents.length >= 8 && (gcBin = (int)(gcContent = Float.parseFloat(lineContents[7].replace(',', '.')))) >= 0 && gcBin <= 100 && gcLogMeanSD[gcBin].floatValue() != 0.0f) {
                                adjustedRatio -= (double)gcLogMeanSD[gcBin].floatValue();
                            }
                            regionSize = regionStop - regionStart + 1L;
                            if (normalDepth >= (float)minCoverage && tumorDepth >= (float)minTumorCoverage) {
                                stats.put("metMinDepth", (Integer)stats.get("metMinDepth") + 1);
                                regionCall = "neutral";
                                if (regionSize < (long)minRegionSize) continue;
                                stats.put("metMinSize", (Integer)stats.get("metMinSize") + 1);
                                if (adjustedRatio >= ampThreshold) {
                                    stats.put("numAmp", (Integer)stats.get("numAmp") + 1);
                                    baseCounts.put("numAmp", (Long)baseCounts.get("numAmp") + regionSize);
                                    regionCall = "amp";
                                } else if (adjustedRatio <= delThreshold) {
                                    stats.put("numDel", (Integer)stats.get("numDel") + 1);
                                    baseCounts.put("numDel", (Long)baseCounts.get("numDel") + regionSize);
                                    regionCall = "del";
                                } else {
                                    stats.put("numNeutral", (Integer)stats.get("numNeutral") + 1);
                                    baseCounts.put("numNeutral", (Long)baseCounts.get("numNeutral") + regionSize);
                                }
                                outLine = String.valueOf(refName) + "\t" + regionStart + "\t" + regionStop + "\t" + numPositions + "\t";
                                outLine = String.valueOf(outLine) + normalDepth + "\t" + tumorDepth + "\t" + threeDigits.format(adjustedRatio) + "\t" + gcContent + "\t" + regionCall + "\t" + logratio;
                                if (params.containsKey("output-file")) {
                                    out.println(outLine);
                                    continue;
                                }
                                System.err.println(outLine);
                                continue;
                            }
                            if (!(normalDepth >= (float)minCoverage) || !(tumorDepth <= (float)maxHomdelCoverage) || regionSize < (long)minRegionSize || !(adjustedRatio <= delThreshold)) continue;
                            outLine = String.valueOf(refName) + "\t" + regionStart + "\t" + regionStop + "\t" + numPositions + "\t";
                            outLine = String.valueOf(outLine) + normalDepth + "\t" + tumorDepth + "\t" + threeDigits.format(adjustedRatio) + "\t" + gcContent + "\thomozygous_deletion\t" + logratio;
                            stats.put("numHomDel", (Integer)stats.get("numHomDel") + 1);
                            baseCounts.put("numHomDel", (Long)baseCounts.get("numHomDel") + regionSize);
                            if (!params.containsKey("output-homdel-file")) continue;
                            outHomdel.println(outLine);
                            continue;
                        }
                        System.err.println("Error: Invalid format for pileup at line " + stats.get("numBases") + "\n" + line + "\n");
                        return;
                    }
                    catch (Exception e) {
                        System.err.println("Parsing Exception on line:\n" + line + "\n" + e.getMessage() + "\n" + e.getLocalizedMessage());
                        System.err.println(e.toString());
                        stats.put("numParsingExceptions", (Integer)stats.get("numParsingExceptions") + 1);
                        if ((Integer)stats.get("numParsingExceptions") < 5) continue;
                        System.err.println("Too many parsing exceptions encountered; exiting");
                        System.exit(11);
                    }
                }
            } else {
                System.err.println("Input was not ready for parsing!");
                System.exit(10);
            }
            if (params.containsKey("output-file")) {
                out.close();
                outGC.close();
            }
            System.err.println(stats.get("numRegions") + " raw regions parsed");
            System.err.println(stats.get("metMinDepth") + " met min depth");
            System.err.println(stats.get("metMinSize") + " met min size");
            System.err.println(stats.get("numAmp") + " regions (" + baseCounts.get("numAmp") + " bp)" + " were called amplification (log2 > " + ampThreshold + ")");
            System.err.println(stats.get("numNeutral") + " regions (" + baseCounts.get("numNeutral") + " bp)" + " were called neutral");
            System.err.println(stats.get("numDel") + " regions (" + baseCounts.get("numDel") + " bp)" + " were called deletion (log2 <" + delThreshold + ")");
            System.err.println(stats.get("numHomDel") + " regions (" + baseCounts.get("numHomDel") + " bp)" + " were called homozygous deletion (normal cov >= " + minCoverage + " and tumor cov <= " + maxHomdelCoverage + ")");
        }
        catch (Exception e) {
            System.err.println("Error parsing input: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            System.exit(11);
        }
    }

    static String processRegion(String regionRef, long regionStart, long regionStop, int regionCalls, long regionSumNormal, long regionSumTumor) {
        float regionDepthNormal = regionSumNormal / (long)regionCalls;
        float regionDepthTumor = regionSumTumor / (long)regionCalls;
        double tumorNormalRatio = 100.0;
        double log2ratio = 0.0;
        if (regionDepthNormal > 0.0f) {
            tumorNormalRatio = regionDepthTumor / regionDepthNormal;
            log2ratio = Math.log(tumorNormalRatio) / Math.log(2.0);
        }
        return String.valueOf(regionRef) + "\t" + regionStart + "\t" + regionStop + "\t" + regionCalls + "\t" + regionDepthNormal + "\t" + regionDepthTumor + "\t" + log2ratio;
    }
}

