/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comparison {
    public Comparison(String[] args) {
        String usage = "USAGE: java -jar VarScan.jar compare [file1] [file2] [type] [output] OPTIONS\n\tfile1 - A file of chromosome-positions, tab-delimited\n\tfile2 - A file of chromosome-positions, tab-delimited\n\ttype - Type of comparison [intersect|merge|unique1|unique2]\n\toutput - Output file for the comparison result\n";
        if (args.length < 5) {
            System.out.println(usage);
            return;
        }
        String fileName1 = args[1];
        String fileName2 = args[2];
        String comparisonType = args[3];
        String outFileName = args[4];
        System.err.println("File 1: " + fileName1);
        System.err.println("File 2: " + fileName2);
        try {
            BitSet refPositions;
            boolean inFile2;
            boolean inFile1;
            int position;
            String refName;
            String[] lineContents;
            PrintStream outFile = null;
            outFile = new PrintStream(new FileOutputStream(outFileName));
            BufferedReader file1 = new BufferedReader(new FileReader(fileName1));
            BufferedReader file2 = new BufferedReader(new FileReader(fileName2));
            if (!file1.ready() || !file2.ready()) {
                System.err.println("ERROR: Invalid input file(s)");
                return;
            }
            System.err.println("Loading positions from file 1");
            HashMap<String, BitSet> positionHash1 = Comparison.loadPositions(fileName1);
            System.err.println("Loading positions from file 2");
            HashMap<String, BitSet> positionHash2 = Comparison.loadPositions(fileName2);
            System.err.println("Done");
            int numShared = 0;
            int uniqueToFile1 = 0;
            int uniqueToFile2 = 0;
            String line = "";
            int lineCounter = 0;
            while ((line = file1.readLine()) != null) {
                ++lineCounter;
                lineContents = line.split("\t");
                if (lineContents.length < 2) continue;
                try {
                    refName = lineContents[0];
                    position = Integer.parseInt(lineContents[1]);
                    inFile1 = false;
                    inFile2 = false;
                    if (positionHash1.containsKey(refName) && (refPositions = positionHash1.get(refName)).get(position)) {
                        inFile1 = true;
                    }
                    if (positionHash2.containsKey(refName) && (refPositions = positionHash2.get(refName)).get(position)) {
                        inFile2 = true;
                    }
                    if (inFile1 && inFile2) {
                        ++numShared;
                        if (comparisonType.equals("intersect")) {
                            outFile.println(line);
                        }
                    } else if (inFile1) {
                        if (comparisonType.equals("unique1")) {
                            outFile.println(line);
                        }
                        ++uniqueToFile1;
                    }
                    if (!comparisonType.equals("merge")) continue;
                    outFile.println(line);
                }
                catch (Exception e) {
                    if (lineCounter == 1) continue;
                    System.err.println("Warning: Unable to parse chrom/position from " + line);
                }
            }
            while ((line = file2.readLine()) != null) {
                ++lineCounter;
                lineContents = line.split("\t");
                if (lineContents.length < 2) continue;
                try {
                    refName = lineContents[0];
                    position = Integer.parseInt(lineContents[1]);
                    inFile1 = false;
                    inFile2 = false;
                    if (positionHash1.containsKey(refName) && (refPositions = positionHash1.get(refName)).get(position)) {
                        inFile1 = true;
                    }
                    if (positionHash2.containsKey(refName) && (refPositions = positionHash2.get(refName)).get(position)) {
                        inFile2 = true;
                    }
                    if (inFile1 && inFile2 || !inFile2) continue;
                    if (comparisonType.equals("merge") || comparisonType.equals("unique2")) {
                        outFile.println(line);
                    }
                    ++uniqueToFile2;
                }
                catch (Exception e) {
                    if (lineCounter == 1) {
                        outFile.println(line);
                        continue;
                    }
                    System.err.println("Warning: Unable to parse chrom/position from " + line);
                }
            }
            file1.close();
            file2.close();
            int numTotal = numShared + uniqueToFile1 + uniqueToFile2;
            System.err.println(String.valueOf(numTotal) + " total positions");
            System.err.println(String.valueOf(uniqueToFile1) + " positions unique to file 1");
            System.err.println(String.valueOf(uniqueToFile2) + " positions unique to file 2");
            System.err.println(String.valueOf(numShared) + " positions shared");
        }
        catch (Exception e) {
            System.err.println("ERROR: File Parsing Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
            return;
        }
    }

    static HashMap<String, BitSet> loadPositions(String fileName) {
        HashMap<String, BitSet> positionsByChrom = new HashMap<String, BitSet>();
        try {
            BufferedReader infile = new BufferedReader(new FileReader(fileName));
            String line = "";
            int lineCounter = 0;
            while ((line = infile.readLine()) != null) {
                ++lineCounter;
                String[] lineContents = line.split("\t");
                if (lineContents.length < 2) continue;
                try {
                    String refName = lineContents[0];
                    int position = Integer.parseInt(lineContents[1]);
                    BitSet refPositions = positionsByChrom.containsKey(refName) ? positionsByChrom.get(refName) : new BitSet(position + 1);
                    refPositions.set(position, true);
                    positionsByChrom.put(refName, refPositions);
                }
                catch (Exception e) {
                    if (lineCounter <= 1) continue;
                    System.err.println("Warning: Unable to parse chrom/position from " + line);
                }
            }
            infile.close();
        }
        catch (Exception e) {
            System.err.println("ERROR: File Parsing Exception: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
        }
        return positionsByChrom;
    }
}

