/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

import java.io.BufferedReader;
import java.util.HashMap;
import net.sf.varscan.VarScan;

public class CallPileup {
    public CallPileup(String[] args, String callType) {
        block42: {
            String usage = "USAGE: java -jar VarScan.jar pileup2cns [pileup file] OPTIONS\n\tpileup file - The SAMtools pileup file\n\n\tOPTIONS:\n\t--min-coverage\tMinimum read depth at a position to make a call [8]\n\t--min-reads2\tMinimum supporting reads at a position to call variants [2]\n\t--min-avg-qual\tMinimum base quality at a position to count a read [15]\n\t--min-var-freq\tMinimum variant allele frequency threshold [0.01]\n\t--min-freq-for-hom\tMinimum frequency to call homozygote [0.75]\n\t--p-value\tDefault p-value threshold for calling variants [99e-02]\n\t--variants\tReport only variant (SNP/indel) positions [0]";
            HashMap params = VarScan.getParams(args);
            int minCoverage = 8;
            int minReads2 = 2;
            int minAvgQual = 15;
            double minVarFreq = 0.01;
            double minFreqForHom = 0.75;
            double pValueThreshold = 0.99;
            if (callType.equals("CNS")) {
                minVarFreq = 0.2;
                pValueThreshold = 0.01;
            }
            try {
                if (params.containsKey("min-coverage")) {
                    minCoverage = Integer.parseInt((String)params.get("min-coverage"));
                }
                if (params.containsKey("min-reads2")) {
                    minReads2 = Integer.parseInt((String)params.get("min-reads2"));
                }
                if (params.containsKey("min-var-freq")) {
                    minVarFreq = Double.parseDouble((String)params.get("min-var-freq"));
                }
                if (params.containsKey("min-freq-for-hom")) {
                    minFreqForHom = Double.parseDouble((String)params.get("min-freq-for-hom"));
                }
                if (params.containsKey("min-avg-qual")) {
                    minAvgQual = Integer.parseInt((String)params.get("min-avg-qual"));
                }
                if (params.containsKey("p-value")) {
                    pValueThreshold = Double.parseDouble((String)params.get("p-value"));
                } else {
                    System.err.println("Warning: No p-value threshold provided, so p-values will not be calculated");
                }
                System.err.println("Min coverage:\t" + minCoverage);
                System.err.println("Min reads2:\t" + minReads2);
                System.err.println("Min var freq:\t" + minVarFreq);
                System.err.println("Min avg qual:\t" + minAvgQual);
                System.err.println("P-value thresh:\t" + pValueThreshold);
            }
            catch (Exception e) {
                System.err.println("Input Parameter Threw Exception: " + e.getLocalizedMessage());
                e.printStackTrace(System.err);
                return;
            }
            if (params.containsKey("help") || params.containsKey("h")) {
                System.err.println(usage);
                return;
            }
            long numBases = 0L;
            long numCovered = 0L;
            long numCalled = 0L;
            long calledRef = 0L;
            long calledIndel = 0L;
            long calledSNP = 0L;
            int numParsingExceptions = 0;
            try {
                BufferedReader in = VarScan.getInfile(args);
                if (in == null) {
                    System.out.println(usage);
                    return;
                }
                int numNaps = 0;
                while (!in.ready()) {
                    try {
                        Thread.sleep(5000L);
                        if (++numNaps <= 100) continue;
                        System.err.println("Input file was not ready after 100 5-second cycles!");
                        System.exit(10);
                    }
                    catch (Exception e) {
                        System.err.println("Exception while trying to get input" + e.getMessage());
                        System.exit(1);
                    }
                }
                if (in != null && in.ready()) {
                    String line;
                    if (!params.containsKey("no-headers")) {
                        System.out.println("Chrom\tPosition\tRef\tCons\tReads1\tReads2\tVarFreq\tStrands1\tStrands2\tQual1\tQual2\tPvalue\tMapQual1\tMapQual2\tReads1Plus\tReads1Minus\tReads2Plus\tReads2Minus\tVarAllele");
                    }
                    while ((line = in.readLine()) != null) {
                        if (params.containsKey("verbose") && ++numBases % 100000L == 0L) {
                            System.err.println(String.valueOf(numBases) + " positions parsed...");
                        }
                        try {
                            String[] lineContents = line.split("\t", -1);
                            if (lineContents.length > 5 && lineContents[0].length() > 0 && lineContents[1].length() > 0 && lineContents[2].length() > 0 && lineContents[3].length() > 0) {
                                String refName = "";
                                String position = "";
                                String refBase = "";
                                int readDepth = 0;
                                String readBases = "";
                                String readQualities = "";
                                String mapQualities = "";
                                if (lineContents.length <= 7) {
                                    refName = lineContents[0];
                                    position = lineContents[1];
                                    refBase = lineContents[2].toUpperCase();
                                    readDepth = Integer.parseInt(lineContents[3]);
                                    readBases = lineContents[4];
                                    readQualities = lineContents[5];
                                    mapQualities = "";
                                    if (lineContents.length > 6) {
                                        mapQualities = lineContents[6];
                                    }
                                } else if (lineContents.length >= 10 && lineContents.length <= 11) {
                                    refName = lineContents[0];
                                    position = lineContents[1];
                                    refBase = lineContents[2].toUpperCase();
                                    readDepth = Integer.parseInt(lineContents[7]);
                                    readBases = lineContents[8];
                                    readQualities = lineContents[9];
                                    mapQualities = "";
                                    if (lineContents.length > 10) {
                                        mapQualities = lineContents[10];
                                    }
                                } else if (lineContents.length >= 15) {
                                    int cfr_ignored_0 = lineContents.length;
                                }
                                if (readDepth < minCoverage || VarScan.qualityDepth(readQualities, minAvgQual) < minCoverage) continue;
                                ++numCovered;
                                HashMap<String, String> readCounts = VarScan.getReadCounts(refBase, readBases, readQualities, minAvgQual, mapQualities);
                                String positionCall = VarScan.callPosition(refBase, readCounts, callType, minReads2, minVarFreq, minAvgQual, pValueThreshold, minFreqForHom);
                                if (positionCall.length() <= 0) continue;
                                ++numCalled;
                                String[] callLines = positionCall.split("\n");
                                int lineCounter = 0;
                                while (lineCounter < callLines.length) {
                                    String[] callContents = callLines[lineCounter].split("\t");
                                    String consBase = callContents[0];
                                    if (consBase.equals(refBase)) {
                                        ++calledRef;
                                    } else if (consBase.length() > 1) {
                                        ++calledIndel;
                                    } else {
                                        ++calledSNP;
                                    }
                                    if (!params.containsKey("variants") || !consBase.equals(refBase) && !consBase.equals("N")) {
                                        System.out.println(String.valueOf(refName) + "\t" + position + "\t" + refBase + "\t" + callLines[lineCounter]);
                                    }
                                    ++lineCounter;
                                }
                                continue;
                            }
                            System.err.println("Error: Invalid format for pileup at line " + numBases + "\n" + line + "\n");
                            return;
                        }
                        catch (Exception e) {
                            System.err.println("Parsing Exception on line:\n" + line + "\n" + e.getLocalizedMessage());
                            if (++numParsingExceptions >= 5) {
                                System.err.println("Too many parsing exceptions encountered; exiting");
                                return;
                            }
                            return;
                        }
                    }
                    in.close();
                    System.err.println(String.valueOf(numBases) + " bases in pileup file");
                    System.err.println(String.valueOf(numCovered) + " met minimum coverage of " + minCoverage + "x");
                    if (callType.equals("SNP")) {
                        System.err.println(String.valueOf(calledSNP) + " SNPs predicted");
                    } else if (callType.equals("INDEL")) {
                        System.err.println(String.valueOf(calledIndel) + " indels predicted");
                    } else {
                        System.err.println(String.valueOf(numCalled) + " positions were called");
                        System.err.println(String.valueOf(calledRef) + " called Reference");
                        System.err.println(String.valueOf(calledSNP) + " called SNP");
                        System.err.println(String.valueOf(calledIndel) + " called indel");
                    }
                    break block42;
                }
                System.err.println("Please provide an input file!\n" + usage);
                System.exit(10);
            }
            catch (Exception e) {
                System.err.println("Exception: " + e.getLocalizedMessage());
                e.printStackTrace(System.err);
                System.exit(11);
            }
        }
    }
}

