/*
 * Decompiled with CFR 0.152.
 */
package net.sf.varscan;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.util.HashMap;
import net.sf.varscan.VarScan;

public class CallMpileup {
    public CallMpileup(String[] args, String callType) {
        block123: {
            String usage = "USAGE: java -jar VarScan.jar mpileup2cns [pileup file] OPTIONS\n\tmpileup file - The SAMtools mpileup file\n\n\tOPTIONS:\n\t--min-coverage\tMinimum read depth at a position to make a call [8]\n\t--min-reads2\tMinimum supporting reads at a position to call variants [2]\n\t--min-avg-qual\tMinimum base quality at a position to count a read [15]\n\t--min-var-freq\tMinimum variant allele frequency threshold [0.01]\n\t--min-freq-for-hom\tMinimum frequency to call homozygote [0.75]\n\t--p-value\tDefault p-value threshold for calling variants [99e-02]\n\t--strand-filter\tIgnore variants with >90% support on one strand [1]\n\t--output-vcf\tIf set to 1, outputs in VCF format\n\t--vcf-sample-list\tFor VCF output, a list of sample names in order, one per line\n\t--variants\tReport only variant (SNP/indel) positions [0]";
            HashMap params = VarScan.getParams(args);
            DecimalFormat pvalueFormat = new DecimalFormat("0.####E0");
            if (args[0].equals("mpileup2snp")) {
                params.put("variants", "snp");
            }
            if (args[0].equals("mpileup2indel")) {
                params.put("variants", "indel");
            }
            if (args[0].equals("mpileup2vcf")) {
                params.put("output-vcf", "1");
            }
            int minCoverage = 8;
            int minReads2 = 2;
            int minAvgQual = 15;
            double minVarFreq = 0.01;
            double minFreqForHom = 0.75;
            double pValueThreshold = 0.99;
            double strandPvalueThreshold = 0.01;
            boolean variantsOnly = false;
            boolean snpsOnly = false;
            boolean indelsOnly = false;
            boolean strandFilter = true;
            String sampleList = "";
            if (callType.equals("CNS")) {
                minVarFreq = 0.2;
                pValueThreshold = 0.01;
            }
            try {
                if (params.containsKey("min-coverage")) {
                    minCoverage = Integer.parseInt((String)params.get("min-coverage"));
                }
                if (params.containsKey("min-reads2")) {
                    minReads2 = Integer.parseInt((String)params.get("min-reads2"));
                }
                if (params.containsKey("min-var-freq")) {
                    minVarFreq = Double.parseDouble((String)params.get("min-var-freq"));
                }
                if (params.containsKey("min-freq-for-hom")) {
                    minFreqForHom = Double.parseDouble((String)params.get("min-freq-for-hom"));
                }
                if (params.containsKey("min-avg-qual")) {
                    minAvgQual = Integer.parseInt((String)params.get("min-avg-qual"));
                }
                if (params.containsKey("p-value")) {
                    pValueThreshold = Double.parseDouble((String)params.get("p-value"));
                }
                if (params.containsKey("strand-filter")) {
                    int filter = Integer.parseInt((String)params.get("strand-filter"));
                    strandFilter = filter > 0;
                }
                if (params.containsKey("vcf-sample-list")) {
                    File samplefile = new File((String)params.get("vcf-sample-list"));
                    if (samplefile.exists()) {
                        BufferedReader in = new BufferedReader(new FileReader(samplefile));
                        String line = "";
                        if (in.ready()) {
                            while ((line = in.readLine()) != null) {
                                String sampleName = line;
                                if (sampleList.length() > 0) {
                                    sampleList = String.valueOf(sampleList) + "\t";
                                }
                                sampleList = String.valueOf(sampleList) + sampleName;
                            }
                        } else {
                            System.err.println("Unable to open sample list");
                        }
                        in.close();
                    }
                    System.err.println("Got the following sample list: ");
                    System.err.println(sampleList);
                }
                if (params.containsKey("variants")) {
                    String variants = (String)params.get("variants");
                    if (variants.equals("snp")) {
                        snpsOnly = true;
                        System.err.println("Only SNPs will be reported");
                    } else if (variants.equals("indel")) {
                        indelsOnly = true;
                        System.err.println("Only indels will be reported");
                    } else {
                        variantsOnly = true;
                        System.err.println("Only variants will be reported");
                    }
                }
                if (params.containsKey("p-value")) {
                    pValueThreshold = Double.parseDouble((String)params.get("p-value"));
                } else {
                    System.err.println("Warning: No p-value threshold provided, so p-values will not be calculated");
                }
                System.err.println("Min coverage:\t" + minCoverage);
                System.err.println("Min reads2:\t" + minReads2);
                System.err.println("Min var freq:\t" + minVarFreq);
                System.err.println("Min avg qual:\t" + minAvgQual);
                System.err.println("P-value thresh:\t" + pValueThreshold);
            }
            catch (Exception e) {
                System.err.println("Input Parameter Threw Exception: " + e.getLocalizedMessage());
                e.printStackTrace(System.err);
                return;
            }
            if (params.containsKey("help") || params.containsKey("h")) {
                System.err.println(usage);
                return;
            }
            long numBases = 0L;
            long numVariantPositions = 0L;
            long numSNPpositions = 0L;
            long numIndelPositions = 0L;
            long numFailStrandFilter = 0L;
            long numVariantsReported = 0L;
            long numSNPsReported = 0L;
            long numIndelsReported = 0L;
            int numParsingExceptions = 0;
            try {
                BufferedReader in = VarScan.getInfile(args);
                if (in == null) {
                    System.out.println(usage);
                    return;
                }
                int numNaps = 0;
                while (!in.ready()) {
                    try {
                        Thread.sleep(5000L);
                        if (++numNaps <= 100) continue;
                        System.err.println("Input file was not ready after 100 5-second cycles!");
                        System.exit(10);
                    }
                    catch (Exception e) {
                        System.err.println("Exception while trying to get input" + e.getMessage());
                        System.exit(1);
                    }
                }
                String vcfHeader = "##fileformat=VCFv4.1";
                if (in != null && in.ready()) {
                    String line;
                    if (!params.containsKey("no-headers")) {
                        if (params.containsKey("output-vcf")) {
                            vcfHeader = String.valueOf(vcfHeader) + "\n##source=VarScan2";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=ADP,Number=1,Type=Integer,Description=\"Average per-sample depth of bases with Phred score >= " + minAvgQual + "\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=WT,Number=1,Type=Integer,Description=\"Number of samples called reference (wild-type)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=HET,Number=1,Type=Integer,Description=\"Number of samples called heterozygous-variant\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=HOM,Number=1,Type=Integer,Description=\"Number of samples called homozygous-variant\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##INFO=<ID=NC,Number=1,Type=Integer,Description=\"Number of samples not called\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FILTER=<ID=str10,Description=\"Less than 10% or more than 90% of variant supporting reads on one strand\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FILTER=<ID=indelError,Description=\"Likely artifact due to indel reads at this position\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=GT,Number=1,Type=String,Description=\"Genotype\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=GQ,Number=1,Type=Integer,Description=\"Genotype Quality\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=SDP,Number=1,Type=Integer,Description=\"Raw Read Depth as reported by SAMtools\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=DP,Number=1,Type=Integer,Description=\"Quality Read Depth of bases with Phred score >= " + minAvgQual + "\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=RD,Number=1,Type=Integer,Description=\"Depth of reference-supporting bases (reads1)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=AD,Number=1,Type=Integer,Description=\"Depth of variant-supporting bases (reads2)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=FREQ,Number=1,Type=String,Description=\"Variant allele frequency\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=PVAL,Number=1,Type=String,Description=\"P-value from Fisher's Exact Test\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=RBQ,Number=1,Type=Integer,Description=\"Average quality of reference-supporting bases (qual1)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=ABQ,Number=1,Type=Integer,Description=\"Average quality of variant-supporting bases (qual2)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=RDF,Number=1,Type=Integer,Description=\"Depth of reference-supporting bases on forward strand (reads1plus)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=RDR,Number=1,Type=Integer,Description=\"Depth of reference-supporting bases on reverse strand (reads1minus)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=ADF,Number=1,Type=Integer,Description=\"Depth of variant-supporting bases on forward strand (reads2plus)\">";
                            vcfHeader = String.valueOf(vcfHeader) + "\n##FORMAT=<ID=ADR,Number=1,Type=Integer,Description=\"Depth of variant-supporting bases on reverse strand (reads2minus)\">";
                        } else {
                            System.out.println("Chrom\tPosition\tRef\tVar\tCons:Cov:Reads1:Reads2:Freq:P-value\tStrandFilter:R1+:R1-:R2+:R2-:pval\tSamplesRef\tSamplesHet\tSamplesHom\tSamplesNC\tCons:Cov:Reads1:Reads2:Freq:P-value");
                        }
                    }
                    while ((line = in.readLine()) != null) {
                        if (params.containsKey("verbose") && ++numBases % 100000L == 0L) {
                            System.err.println(String.valueOf(numBases) + " positions parsed...");
                        }
                        try {
                            String[] lineContents = line.split("\t", -1);
                            if (numBases == 1L && params.containsKey("output-vcf")) {
                                vcfHeader = String.valueOf(vcfHeader) + "\n#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT";
                                if (sampleList.length() > 0) {
                                    vcfHeader = String.valueOf(vcfHeader) + "\t" + sampleList;
                                } else {
                                    int sampleCounter = 0;
                                    int colCounter = 3;
                                    while (colCounter <= lineContents.length - 3) {
                                        vcfHeader = String.valueOf(vcfHeader) + "\tSample" + ++sampleCounter;
                                        colCounter += 3;
                                    }
                                }
                                System.out.println(vcfHeader);
                            }
                            if (lineContents.length > 5 && lineContents[0].length() > 0 && lineContents[1].length() > 0 && lineContents[2].length() > 0 && lineContents[3].length() > 0) {
                                HashMap<String, String> readCounts;
                                String positionCall;
                                String refName = lineContents[0];
                                String position = lineContents[1];
                                String refBase = lineContents[2].toUpperCase();
                                String callDepths = "";
                                String callResults = "";
                                String vcfResults = "";
                                HashMap<String, Integer> varAlleles = new HashMap<String, Integer>();
                                boolean variantFlag = false;
                                boolean snpFlag = false;
                                boolean indelFlag = false;
                                int samplesRef = 0;
                                int samplesHet = 0;
                                int samplesHom = 0;
                                int samplesUncalled = 0;
                                int allReadDepth = 0;
                                int allReads1plus = 0;
                                int allReads1minus = 0;
                                int allReads2plus = 0;
                                int allReads2minus = 0;
                                double strandPvalue = 1.0;
                                String allReadBases = "";
                                String allReadQualities = "";
                                int colCounter = 3;
                                while (colCounter <= lineContents.length - 3) {
                                    int readDepth = 0;
                                    String readBases = "";
                                    String readQualities = "";
                                    String mapQualities = "";
                                    readDepth = Integer.parseInt(lineContents[colCounter]);
                                    readBases = lineContents[colCounter + 1];
                                    readQualities = lineContents[colCounter + 2];
                                    allReadDepth += readDepth;
                                    allReadBases = String.valueOf(allReadBases) + readBases;
                                    allReadQualities = String.valueOf(allReadQualities) + readQualities;
                                    int qualityDepth = 0;
                                    qualityDepth = VarScan.qualityDepth(readQualities, minAvgQual);
                                    String thisCall = "N:" + qualityDepth + ":-:-:-:-";
                                    String thisVCF = "./.:.:" + qualityDepth;
                                    if (readDepth >= minCoverage && qualityDepth >= minCoverage) {
                                        HashMap<String, String> readCounts2 = VarScan.getReadCounts(refBase, readBases, readQualities, minAvgQual, mapQualities);
                                        String positionCall2 = VarScan.callPosition(refBase, readCounts2, "CNS", minReads2, minVarFreq, minAvgQual, pValueThreshold, minFreqForHom);
                                        if (positionCall2.length() > 0) {
                                            String[] callLines = positionCall2.split("\n");
                                            int lineCounter = 0;
                                            while (lineCounter < callLines.length) {
                                                String[] callContents = callLines[lineCounter].split("\t");
                                                String consBase = callContents[0];
                                                int reads1 = Integer.parseInt(callContents[1]);
                                                int reads2 = Integer.parseInt(callContents[2]);
                                                String varFreq = callContents[3];
                                                int strands1 = Integer.parseInt(callContents[4]);
                                                int strands2 = Integer.parseInt(callContents[5]);
                                                int qual1 = Integer.parseInt(callContents[6]);
                                                int qual2 = Integer.parseInt(callContents[7]);
                                                double pValue = Double.parseDouble(callContents[8]);
                                                int reads1plus = Integer.parseInt(callContents[11]);
                                                int reads1minus = Integer.parseInt(callContents[12]);
                                                int reads2plus = Integer.parseInt(callContents[13]);
                                                int reads2minus = Integer.parseInt(callContents[14]);
                                                String varAllele = "";
                                                double logP = 0.0;
                                                try {
                                                    logP = 0.0 - 10.0 * Math.log10(pValue);
                                                    if (logP > 255.0) {
                                                        logP = 255.0;
                                                    }
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                                if (!consBase.equals(refBase) && !consBase.equals("N") && callContents.length > 15) {
                                                    varAllele = callContents[15];
                                                    int varAlleleNumber = 0;
                                                    if (varAlleles.containsKey(varAllele)) {
                                                        varAlleleNumber = (Integer)varAlleles.get(varAllele);
                                                    } else {
                                                        varAlleleNumber = varAlleles.size() + 1;
                                                        varAlleles.put(varAllele, varAlleleNumber);
                                                    }
                                                    if (VarScan.isHomozygous(consBase)) {
                                                        ++samplesHom;
                                                        thisVCF = String.valueOf(varAlleleNumber) + "/" + varAlleleNumber;
                                                    } else {
                                                        ++samplesHet;
                                                        thisVCF = "0/" + varAlleleNumber;
                                                    }
                                                    thisVCF = String.valueOf(thisVCF) + ":" + (int)logP + ":" + readDepth + ":" + qualityDepth;
                                                    thisVCF = String.valueOf(thisVCF) + ":" + reads1 + ":" + reads2 + ":" + varFreq + ":" + pvalueFormat.format(pValue);
                                                    thisVCF = String.valueOf(thisVCF) + ":" + qual1 + ":" + qual2;
                                                    thisVCF = String.valueOf(thisVCF) + ":" + reads1plus + ":" + reads1minus + ":" + reads2plus + ":" + reads2minus;
                                                } else if (consBase.equals(refBase)) {
                                                    int expReads1 = (reads1 + reads2) / 2;
                                                    int expReads2 = reads1 + reads2 - expReads1;
                                                    double newPvalue = VarScan.getSignificance(reads1, reads2, expReads1, expReads2);
                                                    double newLogP = 0.0;
                                                    try {
                                                        newLogP = 0.0 - 10.0 * Math.log10(newPvalue);
                                                    }
                                                    catch (Exception exception) {
                                                        // empty catch block
                                                    }
                                                    thisVCF = "0/0";
                                                    thisVCF = String.valueOf(thisVCF) + ":" + (int)newLogP + ":" + readDepth + ":" + qualityDepth;
                                                    thisVCF = String.valueOf(thisVCF) + ":" + reads1 + ":" + reads2 + ":" + varFreq + ":" + pvalueFormat.format(pValue);
                                                    thisVCF = String.valueOf(thisVCF) + ":" + qual1 + ":" + qual2;
                                                    thisVCF = String.valueOf(thisVCF) + ":" + reads1plus + ":" + reads1minus + ":" + reads2plus + ":" + reads2minus;
                                                }
                                                thisCall = String.valueOf(consBase) + ":" + qualityDepth + ":" + reads1 + ":" + reads2 + ":" + varFreq;
                                                thisCall = String.valueOf(thisCall) + ":" + pvalueFormat.format(pValue);
                                                if (!consBase.equals(refBase) && !consBase.equals("N")) {
                                                    variantFlag = true;
                                                    if (consBase.length() > 1) {
                                                        indelFlag = true;
                                                    } else {
                                                        snpFlag = true;
                                                    }
                                                    allReads1plus += reads1plus;
                                                    allReads1minus += reads1minus;
                                                    allReads2plus += reads2plus;
                                                    allReads2minus += reads2minus;
                                                } else {
                                                    ++samplesRef;
                                                }
                                                ++lineCounter;
                                            }
                                        } else {
                                            ++samplesUncalled;
                                        }
                                    } else {
                                        ++samplesUncalled;
                                    }
                                    if (callDepths.length() > 0) {
                                        callDepths = String.valueOf(callDepths) + " ";
                                    }
                                    callDepths = String.valueOf(callDepths) + readDepth;
                                    if (callResults.length() > 0) {
                                        callResults = String.valueOf(callResults) + " ";
                                    }
                                    callResults = String.valueOf(callResults) + thisCall;
                                    if (vcfResults.length() > 0) {
                                        vcfResults = String.valueOf(vcfResults) + "\t";
                                    }
                                    vcfResults = String.valueOf(vcfResults) + thisVCF;
                                    colCounter += 3;
                                }
                                int qualityDepth = 0;
                                qualityDepth = VarScan.qualityDepth(allReadQualities, minAvgQual);
                                String allMapQualities = "";
                                String allConsensusCall = "N:" + qualityDepth + ":-:-:-:-";
                                if (!params.containsKey("output-vcf") && allReadDepth >= minCoverage && qualityDepth >= minCoverage && (positionCall = VarScan.callPosition(refBase, readCounts = VarScan.getReadCounts(refBase, allReadBases, allReadQualities, minAvgQual, allMapQualities), "CNS", minReads2, minVarFreq, minAvgQual, pValueThreshold, minFreqForHom)).length() > 0) {
                                    String[] callLines = positionCall.split("\n");
                                    int lineCounter = 0;
                                    while (lineCounter < callLines.length) {
                                        String[] callContents = callLines[lineCounter].split("\t");
                                        String consBase = callContents[0];
                                        int reads1 = Integer.parseInt(callContents[1]);
                                        int reads2 = Integer.parseInt(callContents[2]);
                                        String varFreq = callContents[3];
                                        double pValue = Double.parseDouble(callContents[8]);
                                        String varAllele = "";
                                        if (!consBase.equals(refBase) && callContents.length > 15 && !varAlleles.containsKey(varAllele = callContents[15])) {
                                            int varAlleleNumber = varAlleles.size() + 1;
                                            varAlleles.put(varAllele, varAlleleNumber);
                                        }
                                        allConsensusCall = String.valueOf(consBase) + ":" + qualityDepth + ":" + reads1 + ":" + reads2 + ":" + varFreq;
                                        allConsensusCall = String.valueOf(allConsensusCall) + ":" + pvalueFormat.format(pValue);
                                        if (!consBase.equals(refBase) && !consBase.equals("N")) {
                                            variantFlag = true;
                                            if (consBase.length() > 1) {
                                                indelFlag = true;
                                            } else {
                                                snpFlag = true;
                                            }
                                        }
                                        ++lineCounter;
                                    }
                                }
                                String varBases = "";
                                String[] sortedKeys = varAlleles.keySet().toArray(new String[0]);
                                String[] alleleKeys = new String[sortedKeys.length];
                                String[] reads1 = sortedKeys;
                                int consBase = sortedKeys.length;
                                int callContents = 0;
                                while (callContents < consBase) {
                                    String allele = reads1[callContents];
                                    int arrayIndex = (Integer)varAlleles.get(allele) - 1;
                                    alleleKeys[arrayIndex] = allele;
                                    ++callContents;
                                }
                                reads1 = alleleKeys;
                                consBase = alleleKeys.length;
                                callContents = 0;
                                while (callContents < consBase) {
                                    String allele = reads1[callContents];
                                    if (varBases.length() > 0) {
                                        varBases = String.valueOf(varBases) + ",";
                                    }
                                    varBases = String.valueOf(varBases) + allele;
                                    ++callContents;
                                }
                                if (varBases.length() == 0) {
                                    varBases = ".";
                                }
                                if (variantFlag) {
                                    ++numVariantPositions;
                                }
                                if (snpFlag) {
                                    ++numSNPpositions;
                                }
                                if (indelFlag) {
                                    ++numIndelPositions;
                                }
                                String strandFilterStatus = "Pass:" + allReads1plus + ":" + allReads1minus + ":" + allReads2plus + ":" + allReads2minus + ":" + pvalueFormat.format(strandPvalue);
                                boolean failedStrandFilter = false;
                                if (strandFilter && variantFlag && (allReads1plus > 0 || allReads1minus > 0 || allReads2plus > 0 || allReads2plus > 0)) {
                                    double refStrandPlus = 0.5;
                                    double varStrandPlus = 0.5;
                                    if (allReads2plus + allReads2minus > 0) {
                                        varStrandPlus = (double)allReads2plus / (double)(allReads2plus + allReads2minus);
                                    }
                                    if (varStrandPlus < 0.1 || varStrandPlus > 0.9) {
                                        if (allReads1plus + allReads1minus > 1) {
                                            refStrandPlus = (double)allReads1plus / (double)(allReads1plus + allReads1minus);
                                            strandPvalue = VarScan.getSignificance(allReads1plus, allReads1minus, allReads2plus, allReads2minus);
                                        } else {
                                            int testReads1plus = (allReads2plus + allReads2minus) / 2;
                                            int testReads1minus = allReads2plus + allReads2minus - testReads1plus;
                                            strandPvalue = VarScan.getSignificance(testReads1plus, testReads1minus, allReads2plus, allReads2minus);
                                        }
                                        strandFilterStatus = "Pass:" + varStrandPlus + ":" + allReads1plus + ":" + allReads1minus + ":" + allReads2plus + ":" + allReads2minus + ":" + pvalueFormat.format(strandPvalue);
                                        if (refStrandPlus >= 0.1 && refStrandPlus <= 0.9 && (!(varStrandPlus >= 0.1) || !(varStrandPlus <= 0.9)) && strandPvalue < strandPvalueThreshold) {
                                            strandFilterStatus = "Fail:" + allReads1plus + ":" + allReads1minus + ":" + allReads2plus + ":" + allReads2minus + ":" + pvalueFormat.format(strandPvalue);
                                            ++numFailStrandFilter;
                                            failedStrandFilter = true;
                                        }
                                    }
                                }
                                String outLine = String.valueOf(refName) + "\t" + position + "\t";
                                if (params.containsKey("output-vcf")) {
                                    int avgQualityDepth = 0;
                                    if (samplesRef + samplesHet + samplesHom + samplesUncalled > 0) {
                                        avgQualityDepth = qualityDepth / (samplesRef + samplesHet + samplesHom + samplesUncalled);
                                    }
                                    String refColumn = "";
                                    String varColumn = "";
                                    if (varBases.contains(",") && (varBases.contains("-") || varBases.contains("+"))) {
                                        String[] varBaseContents;
                                        int maxDelSize = 0;
                                        String maxDelBases = "";
                                        String[] stringArray = varBaseContents = varBases.split(",");
                                        int n = varBaseContents.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String varAllele = stringArray[n2];
                                            if (varAllele.startsWith("-") && (varAllele = varAllele.replace("-", "")).length() > maxDelSize) {
                                                maxDelBases = varAllele;
                                                maxDelSize = varAllele.length();
                                            }
                                            ++n2;
                                        }
                                        refColumn = String.valueOf(refBase) + maxDelBases;
                                        varColumn = "";
                                        stringArray = varBaseContents;
                                        n = varBaseContents.length;
                                        n2 = 0;
                                        while (n2 < n) {
                                            String varEntry;
                                            String varAllele = stringArray[n2];
                                            if (varColumn.length() > 0) {
                                                varColumn = String.valueOf(varColumn) + ",";
                                            }
                                            if (varAllele.startsWith("-")) {
                                                if ((varAllele = varAllele.replace("-", "")).length() < maxDelSize) {
                                                    varEntry = maxDelBases.replace(varAllele, "");
                                                    varColumn = String.valueOf(varColumn) + refBase + varEntry;
                                                } else {
                                                    varColumn = String.valueOf(varColumn) + refBase;
                                                }
                                            } else if (varAllele.startsWith("+")) {
                                                varAllele = varAllele.replace("+", "");
                                                varEntry = String.valueOf(refBase) + varAllele + maxDelBases;
                                                varColumn = String.valueOf(varColumn) + varEntry;
                                            } else {
                                                varEntry = String.valueOf(varAllele) + maxDelBases;
                                                varColumn = String.valueOf(varColumn) + varEntry;
                                            }
                                            ++n2;
                                        }
                                    } else if (varBases.startsWith("+")) {
                                        refColumn = refBase;
                                        varColumn = String.valueOf(refBase) + varBases.replace("+", "");
                                    } else if (varBases.startsWith("-")) {
                                        refColumn = String.valueOf(refBase) + varBases.replace("-", "");
                                        varColumn = refBase;
                                    } else {
                                        refColumn = refBase;
                                        varColumn = varBases;
                                    }
                                    varColumn = varColumn.replace("+", "");
                                    varColumn = varColumn.replace("-", "");
                                    outLine = String.valueOf(outLine) + ".\t" + refColumn + "\t" + varColumn + "\t.\t";
                                    outLine = strandFilterStatus.contains("Pass") ? String.valueOf(outLine) + "PASS\t" : String.valueOf(outLine) + "str10\t";
                                    outLine = String.valueOf(outLine) + "ADP=" + avgQualityDepth + ";WT=" + samplesRef + ";HET=" + samplesHet + ";HOM=" + samplesHom + ";NC=" + samplesUncalled;
                                    outLine = String.valueOf(outLine) + "\tGT:GQ:SDP:DP:RD:AD:FREQ:PVAL:RBQ:ABQ:RDF:RDR:ADF:ADR\t";
                                    outLine = String.valueOf(outLine) + vcfResults;
                                } else {
                                    outLine = String.valueOf(outLine) + refBase + "\t" + varBases + "\t";
                                    outLine = String.valueOf(outLine) + allConsensusCall + "\t" + strandFilterStatus + "\t";
                                    outLine = String.valueOf(outLine) + samplesRef + "\t" + samplesHet + "\t" + samplesHom + "\t" + samplesUncalled + "\t";
                                    outLine = String.valueOf(outLine) + callResults;
                                }
                                boolean reportFlag = false;
                                if (variantFlag && strandFilter && failedStrandFilter) {
                                    if (!(variantsOnly || snpsOnly || indelsOnly)) {
                                        reportFlag = true;
                                    }
                                } else if (!variantsOnly && !snpsOnly && !indelsOnly || variantFlag) {
                                    if (!(variantsOnly || snpsOnly || indelsOnly)) {
                                        reportFlag = true;
                                    } else if (variantFlag && variantsOnly) {
                                        reportFlag = true;
                                    } else if (snpFlag && snpsOnly) {
                                        reportFlag = true;
                                    } else if (indelFlag && indelsOnly) {
                                        reportFlag = true;
                                    }
                                }
                                if (!reportFlag) continue;
                                System.out.println(outLine);
                                if (variantFlag) {
                                    ++numVariantsReported;
                                }
                                if (snpFlag) {
                                    ++numSNPsReported;
                                }
                                if (!indelFlag) continue;
                                ++numIndelsReported;
                                continue;
                            }
                            if (lineContents.length >= 4 && lineContents[3].equals("0")) continue;
                            System.err.println("Warning: Line ignored: Invalid format for pileup at line " + numBases + "\n" + line + "\n");
                            return;
                        }
                        catch (Exception e) {
                            System.err.println("Parsing Exception on line:\n" + line + "\n" + e.getLocalizedMessage());
                            if (++numParsingExceptions >= 5) {
                                System.err.println("Too many parsing exceptions encountered; exiting");
                                return;
                            }
                            return;
                        }
                    }
                    in.close();
                    System.err.println(String.valueOf(numBases) + " bases in pileup file");
                    System.err.println(String.valueOf(numVariantPositions) + " variant positions (" + numSNPpositions + " SNP, " + numIndelPositions + " indel)");
                    System.err.println(String.valueOf(numFailStrandFilter) + " were failed by the strand-filter");
                    System.err.println(String.valueOf(numVariantsReported) + " variant positions reported (" + numSNPsReported + " SNP, " + numIndelsReported + " indel)");
                    break block123;
                }
                System.err.println("Please provide an input file!\n" + usage);
                System.exit(10);
            }
            catch (Exception e) {
                System.err.println("Exception: " + e.getLocalizedMessage());
                e.printStackTrace(System.err);
                System.exit(11);
            }
        }
    }
}

