from django.urls import path, include
from . import views
from zenblog.sitemaps import PostSitemap
from django.contrib.sitemaps.views import sitemap

app_name = 'zenblog'

sitemaps = {
    "posts": PostSitemap,
}

urlpatterns = [
    path('', views.home, name='home'),
    path('about/', views.about, name='about'),
    path('contact/', views.contact, name='contact'),
    path('category/<int:category_int>', views.Category.as_view(), name='category'),
    path('search-result/', views.SearchResult.as_view(), name='search_result'),
    path('search-tag/<str:tag>', views.SearchTag.as_view(), name='search_tag'),
    path('<slug:slug>/', views.PostDetailView.as_view(), name='post_detail'),
    path('hitcount/', include(('hitcount.urls', 'hitcount'), namespace='hitcount')),
    path('sitemap.xml', sitemap, {"sitemaps": sitemaps}),
]
