"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MyRedis = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
/**
 * @experimental
 */
class MyRedis extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, name, opts) {
        var _b, _c, _d, _e, _f, _g, _h, _j;
        super(scope, name);
        const namespace = (_b = opts.namespace) !== null && _b !== void 0 ? _b : 'default';
        this.namespace = namespace;
        var storageClassName = (_c = opts.storageClassName) !== null && _c !== void 0 ? _c : 'gp2';
        const volumeProvisioner = (_d = opts.volumeProvisioner) !== null && _d !== void 0 ? _d : 'kubernetes.io/aws-ebs';
        const storageClassParams = (_e = opts.storageClassParams) !== null && _e !== void 0 ? _e : { type: 'gp2', fsType: 'ext4' };
        const volumeRequest = {
            storage: k8s.Quantity.fromString(String(opts.volumeSize)),
        };
        const replicas = (_f = opts.replicas) !== null && _f !== void 0 ? _f : 1;
        const resources = {
            limits: convertQuantity((_g = opts.resources) === null || _g === void 0 ? void 0 : _g.limits, {
                cpu: '400m',
                memory: '512Mi',
            }),
            requests: convertQuantity((_h = opts.resources) === null || _h === void 0 ? void 0 : _h.requests, {
                cpu: '200m',
                memory: '256Mi',
            }),
        };
        const nodeSelectorParams = (_j = opts.nodeSelectorParams) !== null && _j !== void 0 ? _j : undefined;
        const label = {
            ...opts.labels,
            app: name,
        };
        if (opts.createStorageClass === true) {
            const storageClassOpts = {
                metadata: {
                    name: storageClassName,
                },
                provisioner: volumeProvisioner,
                allowVolumeExpansion: true,
                reclaimPolicy: 'Retain',
                parameters: {
                    ...storageClassParams,
                },
            };
            const storageclass = new k8s.KubeStorageClass(this, 'storageclass', storageClassOpts);
            this.name = storageclass.name;
            var storageClassName = storageclass.name;
        }
        const serviceOpts = {
            metadata: {
                labels: label,
                name: name,
                namespace: namespace,
            },
            spec: {
                type: 'ClusterIP',
                selector: label,
                ports: [{ port: 6379, targetPort: k8s.IntOrString.fromNumber(6379) }],
            },
        };
        const svc = new k8s.KubeService(this, 'service', serviceOpts);
        this.name = svc.name;
        const pvcProps = {
            metadata: {
                name: name,
                namespace: namespace,
            },
            spec: {
                accessModes: ['ReadWriteOnce'],
                storageClassName: storageClassName,
                resources: {
                    requests: volumeRequest,
                },
            },
        };
        // const initRedis: k8s.Container = {
        //   name: 'init-redis',
        //   image: opts.image,
        //   command: [
        //     'bash',
        //     '-c',
        //     'set -ex\n# Generate mysql server-id from pod ordinal index.\nmkdir -p /etc/redis\n[[ `hostname` =~ -([0-9]+)$ ]] || exit 1\nordinal=${BASH_REMATCH[1]}\n# Copy appropriate conf.d files from config-map to emptyDir.\nif [[ $ordinal -eq 0 ]]; then\ncp /mnt/redis/master.conf /etc/redis/redis.conf\nelse\ncp /mnt/redis/slave.conf /etc/redis/redis.conf\nfi',
        //   ],
        //   volumeMounts: [{
        //     name: name,
        //     mountPath: '/data',
        //   },
        //   {
        //     name: `${name}-redis-conf`,
        //     mountPath: '/mnt/config-map',
        //   }],
        // };
        const redis = {
            name: 'redis',
            image: opts.image,
            ports: [{
                    containerPort: 6379,
                }],
            command: [
                'bash',
                '-c',
                '[[ `hostname` =~ -([0-9]+)$ ]] || exit 1\nordinal=${BASH_REMATCH[1]}\nif [[ $ordinal -eq 0 ]]; then\nredis-server /mnt/redis/master.conf\nelse\nredis-server /mnt/redis/slave.conf\nfi',
            ],
            resources: resources,
            env: renderEnv(opts.env),
            volumeMounts: [{
                    name: name,
                    mountPath: '/data',
                },
                {
                    name: `${name}-redis-conf`,
                    mountPath: '/mnt/redis/',
                }],
        };
        const stsOpts = {
            metadata: {
                labels: label,
                name: name,
                namespace: namespace,
            },
            spec: {
                serviceName: svc.name,
                replicas: replicas,
                selector: { matchLabels: label },
                template: {
                    metadata: { labels: label },
                    spec: {
                        containers: [
                            redis,
                        ],
                        terminationGracePeriodSeconds: 10,
                        nodeSelector: nodeSelectorParams,
                        volumes: [{
                                name: `${name}-redis-conf`,
                                configMap: {
                                    name: `${name}-redis-conf`,
                                },
                            }],
                    },
                },
                volumeClaimTemplates: [pvcProps],
            },
        };
        const sts = new k8s.KubeStatefulSet(this, 'statefulset', stsOpts);
        this.name = sts.name;
    }
}
exports.MyRedis = MyRedis;
_a = JSII_RTTI_SYMBOL_1;
MyRedis[_a] = { fqn: "@opencdk8s/cdk8s-redis-sts.MyRedis", version: "0.0.6" };
function renderEnv(env = {}) {
    const result = new Array();
    for (const [key, value] of Object.entries(env)) {
        result.push({
            name: key,
            value: value,
        });
    }
    return result;
}
/**
 * Converts a `ResourceQuantity` type to a k8s.Quantity map.
 *
 * If `user` is defined, the values provided there (or lack thereof) will be
 * passed on. This means that if the user, for example, did not specify a value
 * for `cpu`, this value will be omitted from the resource requirements. This is
 * intentional, in case the user intentionally wants to omit a constraint.
 *
 * If `user` is not defined, `defaults` are used.
 */
function convertQuantity(user, defaults) {
    // defaults
    if (!user) {
        return {
            cpu: k8s.Quantity.fromString(defaults.cpu),
            memory: k8s.Quantity.fromString(defaults.memory),
        };
    }
    const result = {};
    if (user.cpu) {
        result.cpu = k8s.Quantity.fromString(user.cpu);
    }
    if (user.memory) {
        result.memory = k8s.Quantity.fromString(user.memory);
    }
    return result;
}
//# sourceMappingURL=data:application/json;base64,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