from airflow.providers.cncf.kubernetes.operators.kubernetes_pod import KubernetesPodOperator
from airflow.utils.context import Context

from pathlib import Path
import json


class FlowuiKubernetesPodOperator(KubernetesPodOperator):

    def execute(self, context: Context):
        upstream_task_ids = [t.task_id for t in self.get_direct_relatives(upstream=True)]
        upstream_xcoms = dict()
        for tid in upstream_task_ids:
            upstream_xcoms[tid] = context['ti'].xcom_pull(task_ids=tid) 
        
        # Save upstream tasks XCOM data in temp file
        xcom_in_file = Path("/opt/mnt/fs/tmp/xcom_input.json")
        with open(xcom_in_file, "w") as f:
            json.dump(upstream_xcoms, f, indent=4)
        
        super().execute(context=context)