/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.impl.DSIDataEngine;
import com.amazon.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.amazon.dsi.dataengine.impl.DSITableTypeOnlyMetadataSource;
import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.interfaces.IQueryExecutor;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.dataengine.utilities.MetadataSourceID;
import com.amazon.dsi.dataengine.utilities.OrderType;
import com.amazon.dsi.exceptions.ParsingException;
import com.amazon.jdbc.utils.ParseQueryUtils;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCallableStatementParser;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCConnection;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.PGBatchQueryExecutor;
import com.amazon.redshift.dataengine.PGCatalogQueryBuilder;
import com.amazon.redshift.dataengine.PGEscaper;
import com.amazon.redshift.dataengine.PGQueryExecutor;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.redshift.dataengine.metadata.PGJDBCTypeInfoMetadataSource;
import com.amazon.redshift.dataengine.metadata.PGMetadatSourceFromQuery;
import com.amazon.redshift.dataengine.metadata.PGProcedureColumnsMetadatSourceFromQuery;
import com.amazon.redshift.dataengine.metadata.PGTablePrivilegesMetadatSourceFromQuery;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PGDataEngine
extends DSIDataEngine {
    private PGClient m_client;
    private PGJDBCStatement m_statement;
    private ILogger m_log;
    private boolean m_isDirectExecution;
    private int m_socketTimeoutMS;
    private final PGJDBCConnection m_connection;
    private PGJDBCSettings m_settings;
    private PGEscaper m_jdbcEscaper = new PGEscaper();
    private Map<String, PGMessagingContext> m_contextMap = new HashMap<String, PGMessagingContext>();

    public PGDataEngine(PGJDBCStatement pGJDBCStatement, PGJDBCConnection pGJDBCConnection, PGClient pGClient, PGJDBCSettings pGJDBCSettings, ILogger iLogger, int n) {
        super(pGJDBCStatement);
        this.m_statement = pGJDBCStatement;
        this.m_log = iLogger;
        this.m_connection = pGJDBCConnection;
        this.m_client = pGClient;
        this.m_settings = pGJDBCSettings;
        this.m_isDirectExecution = false;
        this.m_socketTimeoutMS = n;
    }

    @Override
    public IQueryExecutor prepareBatch(List<String> list) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, list);
        return new PGBatchQueryExecutor(null, list, this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS, this.m_jdbcEscaper.parameterCounter(list.get(0)), true);
    }

    @Override
    public IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        if (this.m_statement.isCallableStatement()) {
            try {
                PGCallableStatementParser pGCallableStatementParser = new PGCallableStatementParser(this.m_log);
                string = pGCallableStatementParser.changeSelectToCall(string);
                string = pGCallableStatementParser.translate(string);
                this.m_statement.sethasReturnQuestionMark(pGCallableStatementParser.isReturnParameter());
                String string2 = this.m_jdbcEscaper.apply(string);
                if (this.m_connection.isReadOnly()) {
                    this.m_jdbcEscaper.checkReadOnly(string2);
                }
                return new PGQueryExecutor(string2, this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS, this.m_jdbcEscaper.parameterCounter());
            }
            catch (Exception exception) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PREPARE_CALL_ERROR, (Throwable)exception);
                throw errorException;
            }
        }
        List<String> list = ParseQueryUtils.splitQueries(string, true);
        if (1 == list.size()) {
            String string3 = this.m_jdbcEscaper.apply(list.get(0));
            if (this.m_connection.isReadOnly()) {
                this.m_jdbcEscaper.checkReadOnly(string3);
            }
            return new PGQueryExecutor(string3, this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS, this.m_jdbcEscaper.parameterCounter());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Integer n = null;
        for (String string4 : list) {
            String string5 = this.m_jdbcEscaper.apply(string4);
            if (null == n) {
                n = this.m_jdbcEscaper.parameterCounter();
            }
            if (this.m_connection.isReadOnly()) {
                this.m_jdbcEscaper.checkReadOnly(string5);
            }
            arrayList.add(string5);
        }
        return new PGBatchQueryExecutor(string, arrayList, this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS, n, false);
    }

    @Override
    public void setDirectExecute() {
        this.m_isDirectExecution = true;
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl, OrderType orderType) throws ErrorException {
        if (MetadataSourceID.PRIMARY_KEYS == metadataSourceID) {
            return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl, OrderType.NONE);
        }
        return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl, orderType);
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        switch (metadataSourceID) {
            case TYPE_INFO: {
                return new PGJDBCTypeInfoMetadataSource(this.getLog());
            }
            case TABLETYPE_ONLY: {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("TABLE");
                arrayList.add("VIEW");
                arrayList.add("SEQUENCE");
                arrayList.add("INDEX");
                arrayList.add("SYSTEM TABLE");
                arrayList.add("SYSTEM TOAST TABLE");
                arrayList.add("TEMPORARY TABLE");
                arrayList.add("EXTERNAL TABLE");
                arrayList.add("SYSTEM VIEW");
                arrayList.add("TEMPORARY VIEW");
                arrayList.add("SYSTEM INDEX");
                arrayList.add("SYSTEM TOAST INDEX");
                arrayList.add("TEMPORARY INDEX");
                arrayList.add("TEMPORARY SEQUENCE");
                arrayList.add("TYPE");
                return new DSITableTypeOnlyMetadataSource(this.getLog(), arrayList);
            }
            case TABLES: {
                this.setHasExtSchemaPatternMatch(map);
                return this.runGetTables(metadataSourceID, map);
            }
            case COLUMNS: {
                this.setHasExtSchemaPatternMatch(map);
                return this.runGetColumns(metadataSourceID, map);
            }
            case CATALOG_ONLY: {
                if (null == this.m_contextMap.get("getCatalogs")) {
                    String string3 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getCatalogs", this.m_client.prepareStatement(string3, null, true, false));
                }
                this.m_client.executePreparedStatement(this.m_contextMap.get("getCatalogs"), 0, 0, true, null, 0);
                return new PGMetadatSourceFromQuery(metadataSourceID, this.m_contextMap.get("getCatalogs"), 0, this.m_log);
            }
            case CATALOG_SCHEMA_ONLY: 
            case SCHEMA_ONLY: {
                if (null == this.m_contextMap.get("getSchemas")) {
                    String string4 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getSchemas", this.m_client.prepareStatement(string4, null, true, false));
                }
                this.m_client.executePreparedStatement(this.m_contextMap.get("getSchemas"), 0, 0, true, null, 0);
                return new PGMetadatSourceFromQuery(metadataSourceID, this.m_contextMap.get("getSchemas"), 0, this.m_log);
            }
            case FOREIGN_KEYS: {
                return this.runGetForeignKeys(metadataSourceID, map);
            }
            case PRIMARY_KEYS: {
                return this.runGetPrimaryKeys(metadataSourceID, map);
            }
            case TABLE_PRIVILEGES: {
                return this.runGetTablePrivileges(metadataSourceID, map);
            }
            case PROCEDURES: {
                return this.runGetProcedures(metadataSourceID, map);
            }
            case PROCEDURE_COLUMNS: {
                String string5 = PGCoreUtils.SERVER_VERSION;
                int n = Integer.parseInt(string5.split("\\.")[0]);
                int n2 = Integer.parseInt(string5.split("\\.")[1]);
                if (n >= 8 && n2 >= 4) {
                    return this.runGetProcedureColumns(metadataSourceID, map);
                }
                return this.runGetOldProcedureColumns(metadataSourceID, map);
            }
            case FUNCTIONS_JDBC4: {
                if (!PGCoreUtils.REDSHIFT_SERVER) {
                    return this.runGetFunctionsJDBC4(metadataSourceID, map);
                }
                return new DSIEmptyMetadataSource(this.getLog());
            }
        }
        return new DSIEmptyMetadataSource(this.getLog());
    }

    public void setHasExtSchemaPatternMatch(Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        if (null != string && !string.equals("")) {
            if (null == this.m_contextMap.get("checkExternalSchema")) {
                this.m_contextMap.put("checkExternalSchema", this.m_client.prepareStatement("select 1 from svv_external_schemas where schemaname like ? ", null, true, false));
            }
            byte[][] byArray = new byte[1][0];
            byArray[0] = string.getBytes();
            this.m_client.executePreparedStatement(this.m_contextMap.get("checkExternalSchema"), 0, 0, true, byArray, 0);
            PGResultSet pGResultSet = new PGResultSet(this.m_contextMap.get("checkExternalSchema"), this.m_log);
            pGResultSet.closeCursor();
            this.m_settings.m_hasExtSchemaPatternMatch = pGResultSet.getRowCount() > 0L;
        } else {
            this.m_settings.m_hasExtSchemaPatternMatch = true;
        }
    }

    public IMetadataSource runGetTables(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.TABLE_TYPE);
        if (null != string && !string.equals("")) {
            bl = true;
        }
        if (null != string2 && !string2.equals("")) {
            bl2 = true;
        }
        if (null != string3 && !string3.equals("")) {
            bl3 = true;
            object = string3.split(",");
            n = ((String[])object).length;
        }
        if (!this.m_settings.m_hasExtSchemaPatternMatch && bl) {
            if (bl2) {
                if (bl3) {
                    object = "getTablesSchemaTableTypes" + n;
                    if (null == this.m_contextMap.get(object)) {
                        String string4 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                        this.m_contextMap.put((String)object, this.m_client.prepareStatement(string4, null, true, false));
                    }
                    return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(object));
                }
                if (null == this.m_contextMap.get("getTablesSchemaTable")) {
                    object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getTablesSchemaTable", this.m_client.prepareStatement((String)object, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getTablesSchemaTable"));
            }
            if (bl3) {
                object = "getTablesSchemaTypes" + n;
                if (null == this.m_contextMap.get(object)) {
                    String string5 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put((String)object, this.m_client.prepareStatement(string5, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(object));
            }
            if (null == this.m_contextMap.get("getTablesSchema")) {
                object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getTablesSchema", this.m_client.prepareStatement((String)object, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getTablesSchema"));
        }
        if (bl) {
            if (bl2) {
                if (bl3) {
                    object = "getTablesSchemaTableTypesExt" + n;
                    if (null == this.m_contextMap.get(object)) {
                        String string6 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                        this.m_contextMap.put((String)object, this.m_client.prepareStatement(string6, null, true, false));
                    }
                    return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(object));
                }
                if (null == this.m_contextMap.get("getTablesSchemaTableExt")) {
                    object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getTablesSchemaTableExt", this.m_client.prepareStatement((String)object, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getTablesSchemaTableExt"));
            }
            if (bl3) {
                object = "getTablesSchemaTypesExt" + n;
                if (null == this.m_contextMap.get(object)) {
                    String string7 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put((String)object, this.m_client.prepareStatement(string7, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(object));
            }
            if (null == this.m_contextMap.get("getTablesSchemaExt")) {
                object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getTablesSchemaExt", this.m_client.prepareStatement((String)object, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getTablesSchemaExt"));
        }
        if (bl2) {
            if (bl3) {
                object = "getTablesTableTypesExt" + n;
                if (null == this.m_contextMap.get(object)) {
                    String string8 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put((String)object, this.m_client.prepareStatement(string8, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(object));
            }
            if (null == this.m_contextMap.get("getTablesTableExt")) {
                object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getTablesTableExt", this.m_client.prepareStatement((String)object, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getTablesTableExt"));
        }
        if (bl3) {
            object = "getTablesTypesExt" + n;
            if (null == this.m_contextMap.get(object)) {
                String string9 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put((String)object, this.m_client.prepareStatement(string9, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(object));
        }
        if (null == this.m_contextMap.get("getTablesNoParams")) {
            object = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
            this.m_contextMap.put("getTablesNoParams", this.m_client.prepareStatement((String)object, null, true, false));
        }
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getTablesNoParams"));
    }

    public IMetadataSource runGetColumns(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        if (null != string && !string.equals("")) {
            bl = true;
        }
        if (null != string2 && !string2.equals("")) {
            bl2 = true;
        }
        if (null != string3 && !string3.equals("")) {
            bl3 = true;
        }
        if (!this.m_settings.m_hasExtSchemaPatternMatch && bl) {
            if (bl2) {
                if (bl3) {
                    if (null == this.m_contextMap.get("getColumnsSchemaTableColumn")) {
                        String string4 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                        this.m_contextMap.put("getColumnsSchemaTableColumn", this.m_client.prepareStatement(string4, null, true, false));
                    }
                    return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getColumnsSchemaTableColumn"));
                }
                if (null == this.m_contextMap.get("getColumnsSchemaTable")) {
                    String string5 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getColumnsSchemaTable", this.m_client.prepareStatement(string5, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getColumnsSchemaTable"));
            }
            if (bl3) {
                if (null == this.m_contextMap.get("getColumnsSchemaColumn")) {
                    String string6 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getColumnsSchemaColumn", this.m_client.prepareStatement(string6, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getColumnsSchemaColumn"));
            }
            if (null == this.m_contextMap.get("getColumnsSchema")) {
                String string7 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getColumnsSchema", this.m_client.prepareStatement(string7, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getColumnsSchema"));
        }
        if (bl) {
            if (bl2) {
                if (bl3) {
                    if (null == this.m_contextMap.get("getColumnsSchemaTableColumnExt")) {
                        String string8 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                        this.m_contextMap.put("getColumnsSchemaTableColumnExt", this.m_client.prepareStatement(string8, null, true, false));
                    }
                    return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getColumnsSchemaTableColumnExt"));
                }
                if (null == this.m_contextMap.get("getColumnsSchemaTableExt")) {
                    String string9 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getColumnsSchemaTableExt", this.m_client.prepareStatement(string9, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getColumnsSchemaTableExt"));
            }
            if (bl3) {
                if (null == this.m_contextMap.get("getColumnsSchemaColumnExt")) {
                    String string10 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getColumnsSchemaColumnExt", this.m_client.prepareStatement(string10, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getColumnsSchemaColumnExt"));
            }
            if (null == this.m_contextMap.get("getColumnsSchemaExt")) {
                String string11 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getColumnsSchemaExt", this.m_client.prepareStatement(string11, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getColumnsSchemaExt"));
        }
        if (bl2) {
            if (bl3) {
                if (null == this.m_contextMap.get("getColumnsTableColumnExt")) {
                    String string12 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getColumnsTableColumnExt", this.m_client.prepareStatement(string12, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getColumnsTableColumnExt"));
            }
            if (null == this.m_contextMap.get("getColumnsTableExt")) {
                String string13 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getColumnsTableExt", this.m_client.prepareStatement(string13, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getColumnsTableExt"));
        }
        if (bl3) {
            if (null == this.m_contextMap.get("getColumnsColumnExt")) {
                String string14 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getColumnsColumnExt", this.m_client.prepareStatement(string14, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getColumnsColumnExt"));
        }
        if (null == this.m_contextMap.get("getColumnsNoParams")) {
            String string15 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
            this.m_contextMap.put("getColumnsNoParams", this.m_client.prepareStatement(string15, null, true, false));
        }
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getColumnsNoParams"));
    }

    public IMetadataSource runGetForeignKeys(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
        String string4 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
        if (null == string && null == string2) {
            return this.runGetImportedKeys(metadataSourceID, map);
        }
        if (null != string2 && !string2.equals("")) {
            bl = true;
        }
        if (null != string && !string.equals("")) {
            bl2 = true;
        }
        if (null != string3 && !string3.equals("")) {
            bl3 = true;
        }
        if (null != string4 && !string4.equals("")) {
            bl4 = true;
        }
        if (bl) {
            if (bl2) {
                if (bl3) {
                    if (bl4) {
                        if (null == this.m_contextMap.get("getSchemaTableFTableFSchemaForeignKeys")) {
                            String string5 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                            this.m_contextMap.put("getSchemaTableFTableFSchemaForeignKeys", this.m_client.prepareStatement(string5, null, true, false));
                        }
                        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getSchemaTableFTableFSchemaForeignKeys"));
                    }
                    if (null == this.m_contextMap.get("getSchemaTableFTableForeignKeys")) {
                        String string6 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                        this.m_contextMap.put("getSchemaTableFTableForeignKeys", this.m_client.prepareStatement(string6, null, true, false));
                    }
                    return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getSchemaTableFTableForeignKeys"));
                }
                if (bl4) {
                    if (null == this.m_contextMap.get("getSchemaTableFSchemaForeignKeys")) {
                        String string7 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                        this.m_contextMap.put("getSchemaTableFSchemaForeignKeys", this.m_client.prepareStatement(string7, null, true, false));
                    }
                    return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getSchemaTableFSchemaForeignKeys"));
                }
                if (null == this.m_contextMap.get("getSchemaTableForeignKeys")) {
                    String string8 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getSchemaTableForeignKeys", this.m_client.prepareStatement(string8, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getSchemaTableForeignKeys"));
            }
            if (bl3) {
                if (bl4) {
                    if (null == this.m_contextMap.get("getSchemaFTableFSchemaForeignKeys")) {
                        String string9 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                        this.m_contextMap.put("getSchemaFTableFSchemaForeignKeys", this.m_client.prepareStatement(string9, null, true, false));
                    }
                    return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getSchemaFTableFSchemaForeignKeys"));
                }
                if (null == this.m_contextMap.get("getSchemaFTableForeignKeys")) {
                    String string10 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getSchemaFTableForeignKeys", this.m_client.prepareStatement(string10, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getSchemaFTableForeignKeys"));
            }
            if (bl4) {
                if (null == this.m_contextMap.get("getSchemaFSchemaForeignKeys")) {
                    String string11 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getSchemaFSchemaForeignKeys", this.m_client.prepareStatement(string11, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getSchemaFSchemaForeignKeys"));
            }
            if (null == this.m_contextMap.get("getSchemaForeignKeys")) {
                String string12 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getSchemaForeignKeys", this.m_client.prepareStatement(string12, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getSchemaForeignKeys"));
        }
        if (bl2) {
            if (bl3) {
                if (bl4) {
                    if (null == this.m_contextMap.get("getTableFTableFSchemaForeignKeys")) {
                        String string13 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                        this.m_contextMap.put("getTableFTableFSchemaForeignKeys", this.m_client.prepareStatement(string13, null, true, false));
                    }
                    return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getTableFTableFSchemaForeignKeys"));
                }
                if (null == this.m_contextMap.get("getTableFTableForeignKeys")) {
                    String string14 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getTableFTableForeignKeys", this.m_client.prepareStatement(string14, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getTableFTableForeignKeys"));
            }
            if (bl4) {
                if (null == this.m_contextMap.get("getTableFSchemaForeignKeys")) {
                    String string15 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getTableFSchemaForeignKeys", this.m_client.prepareStatement(string15, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getTableFSchemaForeignKeys"));
            }
            if (null == this.m_contextMap.get("getTableForeignKeys")) {
                String string16 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getTableForeignKeys", this.m_client.prepareStatement(string16, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getTableForeignKeys"));
        }
        if (bl3) {
            if (bl4) {
                if (null == this.m_contextMap.get("getFTableFSchemaForeignKeys")) {
                    String string17 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getFTableFSchemaForeignKeys", this.m_client.prepareStatement(string17, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getFTableFSchemaForeignKeys"));
            }
            if (null == this.m_contextMap.get("getFTableForeignKeys")) {
                String string18 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getFTableForeignKeys", this.m_client.prepareStatement(string18, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getFTableForeignKeys"));
        }
        if (bl4) {
            if (null == this.m_contextMap.get("getFSchemaForeignKeys")) {
                String string19 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getFSchemaForeignKeys", this.m_client.prepareStatement(string19, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getFSchemaForeignKeys"));
        }
        if (null == this.m_contextMap.get("getForeignKeys")) {
            String string20 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
            this.m_contextMap.put("getForeignKeys", this.m_client.prepareStatement(string20, null, true, false));
        }
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getForeignKeys"));
    }

    public IMetadataSource runGetPrimaryKeys(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        boolean bl = false;
        boolean bl2 = false;
        String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
        if (null != string && !string.equals("")) {
            bl = true;
        }
        if (null != string2 && !string2.equals("")) {
            bl2 = true;
        }
        if (bl) {
            if (bl2) {
                if (null == this.m_contextMap.get("GetSchemaTablePrimaryKeys")) {
                    String string3 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("GetSchemaTablePrimaryKeys", this.m_client.prepareStatement(string3, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("GetSchemaTablePrimaryKeys"));
            }
            if (null == this.m_contextMap.get("GetSchemaPrimaryKeys")) {
                String string4 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("GetSchemaPrimaryKeys", this.m_client.prepareStatement(string4, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("GetSchemaPrimaryKeys"));
        }
        if (bl2) {
            if (null == this.m_contextMap.get("GetTablePrimaryKeys")) {
                String string5 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("GetTablePrimaryKeys", this.m_client.prepareStatement(string5, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("GetTablePrimaryKeys"));
        }
        if (null == this.m_contextMap.get("GetPrimaryKeys")) {
            String string6 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
            this.m_contextMap.put("GetPrimaryKeys", this.m_client.prepareStatement(string6, null, true, false));
        }
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("GetPrimaryKeys"));
    }

    public IMetadataSource runGetTablePrivileges(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        boolean bl = false;
        boolean bl2 = false;
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        if (null != string && !string.equals("")) {
            bl = true;
        }
        if (null != string2 && !string2.equals("")) {
            bl2 = true;
        }
        byte[][] byArray = this.getCatalogQueryParameters(metadataSourceID, map);
        if (bl) {
            if (bl2) {
                if (null == this.m_contextMap.get("getSchemaTableTablePrivileges")) {
                    String string3 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getSchemaTableTablePrivileges", this.m_client.prepareStatement(string3, null, true, false));
                }
                this.m_client.executePreparedStatement(this.m_contextMap.get("getSchemaTableTablePrivileges"), 0, 0, true, byArray, 0);
                return new PGTablePrivilegesMetadatSourceFromQuery(this.m_contextMap.get("getSchemaTableTablePrivileges"), this.m_log);
            }
            if (null == this.m_contextMap.get("getSchemaTablePrivileges")) {
                String string4 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getSchemaTablePrivileges", this.m_client.prepareStatement(string4, null, true, false));
            }
            this.m_client.executePreparedStatement(this.m_contextMap.get("getSchemaTablePrivileges"), 0, 0, true, byArray, 0);
            return new PGTablePrivilegesMetadatSourceFromQuery(this.m_contextMap.get("getSchemaTablePrivileges"), this.m_log);
        }
        if (bl2) {
            if (null == this.m_contextMap.get("getTableTablePrivileges")) {
                String string5 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getTableTablePrivileges", this.m_client.prepareStatement(string5, null, true, false));
            }
            this.m_client.executePreparedStatement(this.m_contextMap.get("getTableTablePrivileges"), 0, 0, true, byArray, 0);
            return new PGTablePrivilegesMetadatSourceFromQuery(this.m_contextMap.get("getTableTablePrivileges"), this.m_log);
        }
        if (null == this.m_contextMap.get("getTablePrivileges")) {
            String string6 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
            this.m_contextMap.put("getTablePrivileges", this.m_client.prepareStatement(string6, null, true, false));
        }
        this.m_client.executePreparedStatement(this.m_contextMap.get("getTablePrivileges"), 0, 0, true, byArray, 0);
        return new PGTablePrivilegesMetadatSourceFromQuery(this.m_contextMap.get("getTablePrivileges"), this.m_log);
    }

    public IMetadataSource runGetProcedures(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        boolean bl = false;
        boolean bl2 = false;
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        if (null != string && !string.equals("")) {
            bl = true;
        }
        if (null != string2 && !string2.equals("")) {
            bl2 = true;
        }
        if (bl) {
            if (bl2) {
                if (null == this.m_contextMap.get("getSchemaProcedureProcedures")) {
                    String string3 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getSchemaProcedureProcedures", this.m_client.prepareStatement(string3, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getSchemaProcedureProcedures"));
            }
            if (null == this.m_contextMap.get("getSchemaProcedures")) {
                String string4 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getSchemaProcedures", this.m_client.prepareStatement(string4, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getSchemaProcedures"));
        }
        if (bl2) {
            if (null == this.m_contextMap.get("getProcedureProcedures")) {
                String string5 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getProcedureProcedures", this.m_client.prepareStatement(string5, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getProcedureProcedures"));
        }
        if (null == this.m_contextMap.get("getProcedures")) {
            String string6 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
            this.m_contextMap.put("getProcedures", this.m_client.prepareStatement(string6, null, true, false));
        }
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getProcedures"));
    }

    public IMetadataSource runGetProcedureColumns(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        boolean bl = false;
        boolean bl2 = false;
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        if (null != string && !string.equals("")) {
            bl = true;
        }
        if (null != string2 && !string2.equals("")) {
            bl2 = true;
        }
        if (bl) {
            if (bl2) {
                if (null == this.m_contextMap.get("getSchemaProcedureProcedureColumns")) {
                    String string3 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("getSchemaProcedureProcedureColumns", this.m_client.prepareStatement(string3, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getSchemaProcedureProcedureColumns"));
            }
            if (null == this.m_contextMap.get("getSchemaProcedureColumns")) {
                String string4 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getSchemaProcedureColumns", this.m_client.prepareStatement(string4, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getSchemaProcedureColumns"));
        }
        if (bl2) {
            if (null == this.m_contextMap.get("getProcedureProcedureColumns")) {
                String string5 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("getProcedureProcedureColumns", this.m_client.prepareStatement(string5, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getProcedureProcedureColumns"));
        }
        if (null == this.m_contextMap.get("getProcedureColumns")) {
            String string6 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
            this.m_contextMap.put("getProcedureColumns", this.m_client.prepareStatement(string6, null, true, false));
        }
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("getProcedureColumns"));
    }

    public IMetadataSource runGetOldProcedureColumns(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        boolean bl = false;
        boolean bl2 = false;
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        if (null != string && !string.equals("")) {
            bl = true;
        }
        if (null != string2 && !string2.equals("")) {
            bl2 = true;
        }
        byte[][] byArray = this.getCatalogQueryParameters(metadataSourceID, map);
        if (bl) {
            if (bl2) {
                if (null == this.m_contextMap.get("getSchemaProcedureOldProcedureColumns")) {
                    String string3 = PGCatalogQueryBuilder.buildProcedureColumnsQueryForOldPostgres(map);
                    this.m_contextMap.put("getSchemaProcedureOldProcedureColumns", this.m_client.prepareStatement(string3, null, true, false));
                }
                this.m_client.executePreparedStatement(this.m_contextMap.get("getSchemaProcedureOldProcedureColumns"), 0, 0, true, byArray, 0);
                return new PGProcedureColumnsMetadatSourceFromQuery(this.m_contextMap.get("getSchemaProcedureOldProcedureColumns"), 0, this.m_log);
            }
            if (null == this.m_contextMap.get("getSchemaOldProcedureColumns")) {
                String string4 = PGCatalogQueryBuilder.buildProcedureColumnsQueryForOldPostgres(map);
                this.m_contextMap.put("getSchemaOldProcedureColumns", this.m_client.prepareStatement(string4, null, true, false));
            }
            this.m_client.executePreparedStatement(this.m_contextMap.get("getSchemaOldProcedureColumns"), 0, 0, true, byArray, 0);
            return new PGProcedureColumnsMetadatSourceFromQuery(this.m_contextMap.get("getSchemaOldProcedureColumns"), 0, this.m_log);
        }
        if (bl2) {
            if (null == this.m_contextMap.get("getProcedureOldProcedureColumns")) {
                String string5 = PGCatalogQueryBuilder.buildProcedureColumnsQueryForOldPostgres(map);
                this.m_contextMap.put("getProcedureOldProcedureColumns", this.m_client.prepareStatement(string5, null, true, false));
            }
            this.m_client.executePreparedStatement(this.m_contextMap.get("getProcedureOldProcedureColumns"), 0, 0, true, byArray, 0);
            return new PGProcedureColumnsMetadatSourceFromQuery(this.m_contextMap.get("getProcedureOldProcedureColumns"), 0, this.m_log);
        }
        if (null == this.m_contextMap.get("getOldProcedureColumns")) {
            String string6 = PGCatalogQueryBuilder.buildProcedureColumnsQueryForOldPostgres(map);
            this.m_contextMap.put("getOldProcedureColumns", this.m_client.prepareStatement(string6, null, true, false));
        }
        this.m_client.executePreparedStatement(this.m_contextMap.get("getOldProcedureColumns"), 0, 0, true, byArray, 0);
        return new PGProcedureColumnsMetadatSourceFromQuery(this.m_contextMap.get("getOldProcedureColumns"), 0, this.m_log);
    }

    public IMetadataSource runGetFunctionsJDBC4(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        boolean bl = false;
        boolean bl2 = false;
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        if (null != string && !string.equals("")) {
            bl = true;
        }
        if (null != string2 && !string2.equals("")) {
            bl2 = true;
        }
        if (bl) {
            if (bl2) {
                if (null == this.m_contextMap.get("GetSchemaProcedureFunctionsJDBC4")) {
                    String string3 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("GetSchemaProcedureFunctionsJDBC4", this.m_client.prepareStatement(string3, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("GetSchemaProcedureFunctionsJDBC4"));
            }
            if (null == this.m_contextMap.get("GetSchemaFunctionsJDBC4")) {
                String string4 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("GetSchemaFunctionsJDBC4", this.m_client.prepareStatement(string4, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("GetSchemaFunctionsJDBC4"));
        }
        if (bl2) {
            if (null == this.m_contextMap.get("GetProcedureFunctionsJDBC4")) {
                String string5 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("GetProcedureFunctionsJDBC4", this.m_client.prepareStatement(string5, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("GetProcedureFunctionsJDBC4"));
        }
        if (null == this.m_contextMap.get("GetFunctionsJDBC4")) {
            String string6 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
            this.m_contextMap.put("GetFunctionsJDBC4", this.m_client.prepareStatement(string6, null, true, false));
        }
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("GetFunctionsJDBC4"));
    }

    private IMetadataSource runGetImportedKeys(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        boolean bl = false;
        boolean bl2 = false;
        String string = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
        if (null != string2 && !string2.equals("")) {
            bl2 = true;
        }
        if (null != string && !string.equals("")) {
            bl = true;
        }
        if (bl) {
            if (bl2) {
                if (null == this.m_contextMap.get("GetImportedFTableFSchemaKeys")) {
                    String string3 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                    this.m_contextMap.put("GetImportedFTableFSchemaKeys", this.m_client.prepareStatement(string3, null, true, false));
                }
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("GetImportedFTableFSchemaKeys"));
            }
            if (null == this.m_contextMap.get("GetImportedFTableKeys")) {
                String string4 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("GetImportedFTableKeys", this.m_client.prepareStatement(string4, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("GetImportedFTableKeys"));
        }
        if (bl2) {
            if (null == this.m_contextMap.get("GetImportedFSchemaKeys")) {
                String string5 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
                this.m_contextMap.put("GetImportedFSchemaKeys", this.m_client.prepareStatement(string5, null, true, false));
            }
            return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("GetImportedFSchemaKeys"));
        }
        if (null == this.m_contextMap.get("GetImportedKeys")) {
            String string6 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings);
            this.m_contextMap.put("GetImportedKeys", this.m_client.prepareStatement(string6, null, true, false));
        }
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get("GetImportedKeys"));
    }

    public IMetadataSource executePreparedCatalogFunction(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, PGMessagingContext pGMessagingContext) throws ErrorException {
        byte[][] byArray = this.getCatalogQueryParameters(metadataSourceID, map);
        this.m_client.executePreparedStatement(pGMessagingContext, 0, 0, true, byArray, 0);
        return new PGMetadatSourceFromQuery(metadataSourceID, pGMessagingContext, 0, this.m_log);
    }

    private byte[][] getCatalogQueryParameters(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        Object object2;
        int n = map.size();
        int n2 = 0;
        n2 += map.containsKey((Object)MetadataSourceColumnTag.CATALOG_NAME) ? 1 : 0;
        n2 += map.containsKey((Object)MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME) ? 1 : 0;
        n2 += map.containsKey((Object)MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME) ? 1 : 0;
        for (Object object2 : map.keySet()) {
            if (object2.equals((Object)MetadataSourceColumnTag.CATALOG_NAME) || object2.equals((Object)MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME) || object2.equals((Object)MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME) || null != map.get(object2) && !map.get(object2).isEmpty()) continue;
            ++n2;
        }
        if (n < n2) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_CATALOG_FUNC_ARG_ERR.name(), map.keySet().toString());
        }
        int n3 = n - n2;
        object2 = new byte[n3][];
        int n4 = 0;
        switch (metadataSourceID) {
            case TABLES: {
                String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
                String string3 = map.get((Object)MetadataSourceColumnTag.TABLE_TYPE);
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                }
                if (null != string2 && !string2.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string2.getBytes();
                }
                if (null != string3 && !string3.isEmpty()) {
                    String[] stringArray = string3.split(",");
                    if (1 < stringArray.length) {
                        object2 = (byte[][])Arrays.copyOf(object2, ((MetadataSourceColumnTag)object2).length - 1 + stringArray.length);
                        int n5 = 0;
                        while (((MetadataSourceColumnTag)object2).length > n4) {
                            object2[n4++] = (MetadataSourceColumnTag)stringArray[n5++].getBytes();
                        }
                    } else {
                        object2[n4++] = (MetadataSourceColumnTag)stringArray[0].getBytes();
                    }
                }
                return object2;
            }
            case COLUMNS: {
                if (this.m_settings.m_hasExtSchemaPatternMatch) {
                    String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                    String string4 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
                    String string5 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
                    if (null != string && !string.isEmpty()) {
                        object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                    }
                    if (null != string4 && !string4.isEmpty()) {
                        object2[n4++] = (MetadataSourceColumnTag)string4.getBytes();
                    }
                    if (null != string5 && !string5.isEmpty()) {
                        object2[n4++] = (MetadataSourceColumnTag)string5.getBytes();
                    }
                } else {
                    object2 = new byte[n3 * 2][];
                    String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                    String string6 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
                    String string7 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
                    if (null != string && !string.isEmpty()) {
                        object2[n4] = (MetadataSourceColumnTag)string.getBytes();
                        object2[n3 + n4++] = (MetadataSourceColumnTag)string.getBytes();
                    }
                    if (null != string6 && !string6.isEmpty()) {
                        object2[n4] = (MetadataSourceColumnTag)string6.getBytes();
                        object2[n3 + n4++] = (MetadataSourceColumnTag)string6.getBytes();
                    }
                    if (null != string7 && !string7.isEmpty()) {
                        object2[n4] = (MetadataSourceColumnTag)string7.getBytes();
                        object2[n3 + n4++] = (MetadataSourceColumnTag)string7.getBytes();
                    }
                }
                return object2;
            }
            case FOREIGN_KEYS: {
                String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
                String string8 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
                String string9 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
                String string10 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                }
                if (null != string8 && !string8.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string8.getBytes();
                }
                if (null != string9 && !string9.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string9.toLowerCase().getBytes();
                }
                if (null != string10 && !string10.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string10.getBytes();
                }
                return object2;
            }
            case PRIMARY_KEYS: {
                String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
                String string11 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
                if (null != string11) {
                    object2[n4++] = (MetadataSourceColumnTag)string11.toLowerCase().getBytes();
                }
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string.toLowerCase().getBytes();
                }
                return object2;
            }
            case PROCEDURES: {
                String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string12 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                }
                if (null != string12 && !string12.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string12.getBytes();
                }
                return object2;
            }
            case FUNCTIONS_JDBC4: {
                String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string13 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                }
                if (null != string13 && !string13.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string13.getBytes();
                }
                return object2;
            }
            case PROCEDURE_COLUMNS: {
                object2 = new byte[2 * n3][];
                String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string14 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
                if (null != string && !string.isEmpty()) {
                    if (null != string14 && !string14.isEmpty()) {
                        object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                        object2[n4++] = (MetadataSourceColumnTag)string14.getBytes();
                        object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                        object2[n4++] = (MetadataSourceColumnTag)string14.getBytes();
                    } else {
                        object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                        object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                    }
                } else if (null != string14 && !string14.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string14.getBytes();
                    object2[n4++] = (MetadataSourceColumnTag)string14.getBytes();
                }
                return object2;
            }
            case TABLE_PRIVILEGES: {
                String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string15 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string.getBytes();
                }
                if (null != string15 && !string15.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)string15.getBytes();
                }
                return object2;
            }
        }
        return object2;
    }
}

