/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.services.redshift.model.transform;

import com.amazon.redshift.amazonaws.DefaultRequest;
import com.amazon.redshift.amazonaws.Request;
import com.amazon.redshift.amazonaws.SdkClientException;
import com.amazon.redshift.amazonaws.http.HttpMethodName;
import com.amazon.redshift.amazonaws.internal.SdkInternalList;
import com.amazon.redshift.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsRequest;
import com.amazon.redshift.amazonaws.transform.Marshaller;
import com.amazon.redshift.amazonaws.util.StringUtils;

public class DescribeSnapshotCopyGrantsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotCopyGrantsRequest>, DescribeSnapshotCopyGrantsRequest> {
    @Override
    public Request<DescribeSnapshotCopyGrantsRequest> marshall(DescribeSnapshotCopyGrantsRequest describeSnapshotCopyGrantsRequest) {
        SdkInternalList tagValuesList;
        SdkInternalList tagKeysList;
        if (describeSnapshotCopyGrantsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeSnapshotCopyGrantsRequest> request = new DefaultRequest<DescribeSnapshotCopyGrantsRequest>(describeSnapshotCopyGrantsRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeSnapshotCopyGrants");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSnapshotCopyGrantsRequest.getSnapshotCopyGrantName() != null) {
            request.addParameter("SnapshotCopyGrantName", StringUtils.fromString(describeSnapshotCopyGrantsRequest.getSnapshotCopyGrantName()));
        }
        if (describeSnapshotCopyGrantsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeSnapshotCopyGrantsRequest.getMaxRecords()));
        }
        if (describeSnapshotCopyGrantsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeSnapshotCopyGrantsRequest.getMarker()));
        }
        if (!(tagKeysList = (SdkInternalList)describeSnapshotCopyGrantsRequest.getTagKeys()).isEmpty() || !tagKeysList.isAutoConstruct()) {
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString(tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (!(tagValuesList = (SdkInternalList)describeSnapshotCopyGrantsRequest.getTagValues()).isEmpty() || !tagValuesList.isAutoConstruct()) {
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString(tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

