/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.services.redshift.model.transform;

import com.amazon.redshift.amazonaws.DefaultRequest;
import com.amazon.redshift.amazonaws.Request;
import com.amazon.redshift.amazonaws.SdkClientException;
import com.amazon.redshift.amazonaws.http.HttpMethodName;
import com.amazon.redshift.amazonaws.internal.SdkInternalList;
import com.amazon.redshift.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest;
import com.amazon.redshift.amazonaws.services.redshift.model.Tag;
import com.amazon.redshift.amazonaws.transform.Marshaller;
import com.amazon.redshift.amazonaws.util.StringUtils;

public class CreateClusterSubnetGroupRequestMarshaller
implements Marshaller<Request<CreateClusterSubnetGroupRequest>, CreateClusterSubnetGroupRequest> {
    @Override
    public Request<CreateClusterSubnetGroupRequest> marshall(CreateClusterSubnetGroupRequest createClusterSubnetGroupRequest) {
        SdkInternalList tagsList;
        SdkInternalList subnetIdsList;
        if (createClusterSubnetGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateClusterSubnetGroupRequest> request = new DefaultRequest<CreateClusterSubnetGroupRequest>(createClusterSubnetGroupRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateClusterSubnetGroup");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createClusterSubnetGroupRequest.getClusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringUtils.fromString(createClusterSubnetGroupRequest.getClusterSubnetGroupName()));
        }
        if (createClusterSubnetGroupRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createClusterSubnetGroupRequest.getDescription()));
        }
        if (!(subnetIdsList = (SdkInternalList)createClusterSubnetGroupRequest.getSubnetIds()).isEmpty() || !subnetIdsList.isAutoConstruct()) {
            int subnetIdsListIndex = 1;
            for (String subnetIdsListValue : subnetIdsList) {
                if (subnetIdsListValue != null) {
                    request.addParameter("SubnetIds.SubnetIdentifier." + subnetIdsListIndex, StringUtils.fromString(subnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        if (!(tagsList = (SdkInternalList)createClusterSubnetGroupRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

