/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.services.redshift.model.transform;

import com.amazon.redshift.amazonaws.DefaultRequest;
import com.amazon.redshift.amazonaws.Request;
import com.amazon.redshift.amazonaws.SdkClientException;
import com.amazon.redshift.amazonaws.http.HttpMethodName;
import com.amazon.redshift.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest;
import com.amazon.redshift.amazonaws.transform.Marshaller;
import com.amazon.redshift.amazonaws.util.StringUtils;

public class AuthorizeClusterSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<AuthorizeClusterSecurityGroupIngressRequest>, AuthorizeClusterSecurityGroupIngressRequest> {
    @Override
    public Request<AuthorizeClusterSecurityGroupIngressRequest> marshall(AuthorizeClusterSecurityGroupIngressRequest authorizeClusterSecurityGroupIngressRequest) {
        if (authorizeClusterSecurityGroupIngressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AuthorizeClusterSecurityGroupIngressRequest> request = new DefaultRequest<AuthorizeClusterSecurityGroupIngressRequest>(authorizeClusterSecurityGroupIngressRequest, "AmazonRedshift");
        request.addParameter("Action", "AuthorizeClusterSecurityGroupIngress");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeClusterSecurityGroupIngressRequest.getClusterSecurityGroupName() != null) {
            request.addParameter("ClusterSecurityGroupName", StringUtils.fromString(authorizeClusterSecurityGroupIngressRequest.getClusterSecurityGroupName()));
        }
        if (authorizeClusterSecurityGroupIngressRequest.getCIDRIP() != null) {
            request.addParameter("CIDRIP", StringUtils.fromString(authorizeClusterSecurityGroupIngressRequest.getCIDRIP()));
        }
        if (authorizeClusterSecurityGroupIngressRequest.getEC2SecurityGroupName() != null) {
            request.addParameter("EC2SecurityGroupName", StringUtils.fromString(authorizeClusterSecurityGroupIngressRequest.getEC2SecurityGroupName()));
        }
        if (authorizeClusterSecurityGroupIngressRequest.getEC2SecurityGroupOwnerId() != null) {
            request.addParameter("EC2SecurityGroupOwnerId", StringUtils.fromString(authorizeClusterSecurityGroupIngressRequest.getEC2SecurityGroupOwnerId()));
        }
        return request;
    }
}

