/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.redshift.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.exception.ValidationErrors;
import liquibase.ext.redshift.database.RedshiftDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.TagDatabaseGenerator;
import liquibase.statement.core.TagDatabaseStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;

public class RedshiftTagDatabaseGenerator
extends TagDatabaseGenerator {
    public ValidationErrors validate(TagDatabaseStatement tagDatabaseStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tag", (Object)tagDatabaseStatement.getTag());
        return validationErrors;
    }

    public int getPriority() {
        return 6;
    }

    public Sql[] generateSql(TagDatabaseStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String tableNameEscaped = database.escapeTableName(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName());
        String orderColumnNameEscaped = database.escapeObjectName("ORDEREXECUTED", Column.class);
        String dateColumnNameEscaped = database.escapeObjectName("DATEEXECUTED", Column.class);
        String tagColumnNameEscaped = database.escapeObjectName("TAG", Column.class);
        String tagEscaped = DataTypeFactory.getInstance().fromObject((Object)statement.getTag(), database).objectToSql((Object)statement.getTag(), database);
        if (database instanceof RedshiftDatabase) {
            return new Sql[]{new UnparsedSql("UPDATE " + tableNameEscaped + " SET " + tagColumnNameEscaped + " = " + tagEscaped + " FROM (SELECT " + dateColumnNameEscaped + ", " + orderColumnNameEscaped + " FROM " + tableNameEscaped + " ORDER BY " + dateColumnNameEscaped + " DESC, " + orderColumnNameEscaped + " DESC LIMIT 1) AS sub WHERE " + tableNameEscaped + "." + dateColumnNameEscaped + "=sub." + dateColumnNameEscaped + " AND " + tableNameEscaped + "." + orderColumnNameEscaped + "=sub." + orderColumnNameEscaped, new DatabaseObject[0])};
        }
        return super.generateSql(statement, database, sqlGeneratorChain);
    }
}

