/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.support.security;

import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.ObjectWrapper;
import com.simba.googlebigquery.support.security.ICredentialFactory;
import com.simba.googlebigquery.support.security.ICredentials;
import com.simba.googlebigquery.support.security.SimbaAuthenticatedCredentials;
import com.simba.googlebigquery.support.security.SimbaLocalCredentials;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;

public class SimbaCredentialFactory
implements ICredentialFactory {
    private GSSManager m_gssManager = GSSManager.getInstance();
    private final ILogger m_logger;
    private SimbaLocalCredentials m_acceptorCredentials = null;
    private GSSContext m_remoteContext = null;

    public SimbaCredentialFactory(ILogger iLogger) {
        this.m_logger = iLogger;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public ICredentials getLocalCredentials() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return new SimbaLocalCredentials(this.m_logger, this.m_gssManager, false);
    }

    @Override
    public ICredentials getAuthenticatedCredentials(byte[] byArray, ObjectWrapper<byte[]> objectWrapper) throws Exception {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            if (null == byArray) {
                byArray = new byte[]{};
            }
            if (null == this.m_acceptorCredentials) {
                this.m_acceptorCredentials = new SimbaLocalCredentials(this.m_logger, this.m_gssManager, true);
                this.m_remoteContext = this.m_gssManager.createContext(this.m_acceptorCredentials.getCredentialHandle());
                this.m_remoteContext.requestCredDeleg(true);
            }
            objectWrapper.setValue(this.m_remoteContext.acceptSecContext(byArray, 0, byArray.length));
            if (this.m_remoteContext.isEstablished()) {
                return new SimbaAuthenticatedCredentials(this.m_logger, this.m_gssManager, this.m_remoteContext);
            }
            return null;
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_logger);
            throw exception;
        }
    }
}

