/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.jdbc;

import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.jdbc42.BQJDBC42ObjectFactory;
import com.simba.googlebigquery.googlebigquery.utils.BQCoreUtils;
import com.simba.googlebigquery.jdbc.common.AbstractDataSource;
import com.simba.googlebigquery.jdbc.common.JDBCObjectFactory;
import com.simba.googlebigquery.jdbc.jdbc42.JDBC42AbstractDataSource;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import com.simba.support.InvariantName;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

@InvariantName
public class DataSource
extends JDBC42AbstractDataSource {
    private static final String ENABLED = "1";
    private static final String DISABLED = "0";
    public final Map<String, String> propertyMap = new HashMap<String, String>();

    @Override
    protected JDBCObjectFactory createJDBCObjectFactory() {
        return new BQJDBC42ObjectFactory();
    }

    @Override
    protected Properties getProperties() {
        Properties properties = super.getProperties();
        for (String string : this.propertyMap.keySet()) {
            properties.put(string, this.propertyMap.get(string));
        }
        return properties;
    }

    @Override
    protected String getSubProtocol() {
        return "bigquery";
    }

    @Override
    protected boolean parseSubName(String string, Properties properties) {
        return BQCoreUtils.parseSubName(string, properties);
    }

    public String getAdditionalProjects() {
        return this.propertyMap.get("AdditionalProjects");
    }

    public boolean getAllowLargeResults() {
        String string = this.propertyMap.get("AllowLargeResults");
        return this.isEnabled(string, false);
    }

    public String getDefaultDataset() {
        return this.propertyMap.get("DefaultDataset");
    }

    public boolean getEnableHighThroughputAPI() {
        String string = this.propertyMap.get("EnableHighThroughPutAPI");
        return this.isEnabled(string, false);
    }

    public boolean getFilerTablesOnDataset() {
        String string = this.propertyMap.get("FilterTablesOnDefaultDataset");
        return this.isEnabled(string, false);
    }

    public Integer getHighThroughputActivationRatio() {
        return this.getInteger(this.propertyMap.get("HighThroughPutActivationRatio"), null);
    }

    public Integer getHighThroughputMinTableSize() {
        return this.getInteger(this.propertyMap.get("HighThroughPutMinTableSize"), null);
    }

    public String getKMSKeyName() {
        return this.propertyMap.get("KMSKeyName");
    }

    public String getLargeResultDataSet() {
        return this.propertyMap.get("LargeResultDataset");
    }

    public Long getLargeResultsDatasetExpirationTime() {
        return this.getLong(this.propertyMap.get("LargeResultsDatasetExpirationTime"), null);
    }

    public String getLargeResultTable() {
        return this.propertyMap.get("LargeResultTable");
    }

    public String getLocation() {
        return this.propertyMap.get("Location");
    }

    public Long getMaxResults() {
        return this.getLong(this.propertyMap.get("MaxResults"), null);
    }

    public String getOAuthAccessToken() {
        return this.propertyMap.get("OAuthAccessToken");
    }

    public String getOAuthClientId() {
        return this.propertyMap.get("OAuthClientId");
    }

    public String getOAuthClientSecret() {
        return this.propertyMap.get("OAuthClientSecret");
    }

    public String getOAuthPvtKeyFilePath() {
        return this.propertyMap.get("OAuthPvtKeyPath");
    }

    public String getOAuthPvtKey() {
        return this.propertyMap.get("OAuthPvtKey");
    }

    public String getOAuthRefreshToken() {
        return this.propertyMap.get("OAuthRefreshToken");
    }

    public String getOAuthServiceAcctEmail() {
        return this.propertyMap.get("OAuthServiceAcctEmail");
    }

    public Integer getOAuthType() {
        return this.getInteger(this.propertyMap.get("OAuthType"), null);
    }

    public String getProjectId() {
        return this.propertyMap.get("ProjectId");
    }

    public String getProxyHost() {
        return this.propertyMap.get("ProxyHost");
    }

    public Integer getProxyPort() {
        return this.getInteger(this.propertyMap.get("ProxyPort"), null);
    }

    public String getProxyUsername() {
        return this.propertyMap.get("ProxyUid");
    }

    public String getProxyPassword() {
        return this.propertyMap.get("ProxyPwd");
    }

    public String getQueryDialect() {
        return this.propertyMap.get("QueryDialect");
    }

    public String getQueryProperties() {
        return this.propertyMap.get("QueryProperties");
    }

    public boolean getRequestGoogleDriveScope() {
        return this.isEnabled(this.propertyMap.get("RequestGoogleDriveScope"), false);
    }

    public String getSSLTrustStore() {
        return this.propertyMap.get("SSLTrustStore");
    }

    public String getSSLTrustStorePassword() {
        return this.propertyMap.get("SSLTrustStorePwd");
    }

    public Long getStringColumnLength() {
        return this.getLong(this.propertyMap.get("StringColumnLength"), null);
    }

    public Long getTimeout() {
        return this.getLong(this.propertyMap.get("Timeout"), null);
    }

    public boolean getTimestampFallback() {
        return this.isEnabled(this.propertyMap.get("TimestampFallback"), false);
    }

    public boolean getUseQueryCache() {
        return this.isEnabled(this.propertyMap.get("useQueryCache"), true);
    }

    public void setAdditionalProjects(String string) {
        this.propertyMap.put("AdditionalProjects", string);
    }

    public void setAllowLargeResults(boolean bl) {
        String string = bl ? ENABLED : DISABLED;
        this.propertyMap.put("AllowLargeResults", string);
    }

    public void setDefaultDataset(String string) {
        this.propertyMap.put("DefaultDataset", string);
    }

    public void setEnableHighThroughputAPI(boolean bl) {
        String string = bl ? ENABLED : DISABLED;
        this.propertyMap.put("EnableHighThroughPutAPI", string);
    }

    public void setFilerTablesOnDataset(boolean bl) {
        String string = bl ? ENABLED : DISABLED;
        this.propertyMap.put("FilterTablesOnDefaultDataset", string);
    }

    public void setHighThroughputActivationRatio(int n) {
        this.propertyMap.put("HighThroughPutActivationRatio", String.valueOf(n));
    }

    public void setHighThroughputMinTableSize(int n) {
        this.propertyMap.put("HighThroughPutMinTableSize", String.valueOf(n));
    }

    public void setKMSKeyName(String string) {
        this.propertyMap.put("KMSKeyName", string);
    }

    public void setLargeResultDataSet(String string) {
        this.propertyMap.put("LargeResultDataset", string);
    }

    public void setLargeResultsDatasetExpirationTime(long l) {
        this.propertyMap.put("LargeResultsDatasetExpirationTime", String.valueOf(l));
    }

    public void setLargeResultTable(String string) {
        this.propertyMap.put("LargeResultTable", string);
    }

    public void setLocation(String string) {
        this.propertyMap.put("Location", string);
    }

    public void setMaxResults(long l) throws ErrorException {
        this.propertyMap.put("MaxResults", String.valueOf(l));
    }

    public void setOAuthAccessToken(String string) {
        this.propertyMap.put("OAuthAccessToken", string);
    }

    public void setOAuthClientId(String string) {
        this.propertyMap.put("OAuthClientId", string);
    }

    public void setOAuthClientSecret(String string) {
        this.propertyMap.put("OAuthClientSecret", string);
    }

    public void setOAuthPvtKeyFilePath(String string) {
        this.propertyMap.put("OAuthPvtKeyPath", string);
    }

    public void setOAuthPvtKey(String string) {
        this.propertyMap.put("OAuthPvtKey", string);
    }

    public void setOAuthRefreshToken(String string) {
        this.propertyMap.put("OAuthRefreshToken", string);
    }

    public void setOAuthServiceAcctEmail(String string) {
        this.propertyMap.put("OAuthServiceAcctEmail", string);
    }

    public void setOAuthType(int n) {
        this.propertyMap.put("OAuthType", String.valueOf(n));
    }

    public void setProjectId(String string) {
        this.propertyMap.put("ProjectId", string);
    }

    public void setProxyHost(String string) {
        this.propertyMap.put("ProxyHost", string);
    }

    public void setProxyPort(int n) {
        this.propertyMap.put("ProxyPort", String.valueOf(n));
    }

    public void setProxyUsername(String string) {
        this.propertyMap.put("ProxyUid", string);
    }

    public void setProxyPassword(String string) {
        this.propertyMap.put("ProxyPwd", string);
    }

    public void setQueryDialect(String string) {
        this.propertyMap.put("QueryDialect", string);
    }

    public void setQueryProperties(String string) {
        this.propertyMap.put("QueryProperties", string);
    }

    public void setRequestGoogleDriveScope(boolean bl) {
        String string = bl ? ENABLED : DISABLED;
        this.propertyMap.put("RequestGoogleDriveScope", string);
    }

    public void setSSLTrustStore(String string) {
        this.propertyMap.put("SSLTrustStore", string);
    }

    public void setSSLTrustStorePassword(String string) {
        this.propertyMap.put("SSLTrustStorePwd", string);
    }

    public void setStringColumnLength(long l) {
        this.propertyMap.put("StringColumnLength", String.valueOf(l));
    }

    public void setTimeout(long l) {
        this.propertyMap.put("Timeout", String.valueOf(l));
    }

    public void setTimestampFallback(boolean bl) {
        String string = bl ? ENABLED : DISABLED;
        this.propertyMap.put("TimestampFallback", String.valueOf(string));
    }

    public void setUseQueryCache(boolean bl) {
        String string = bl ? ENABLED : DISABLED;
        this.propertyMap.put("useQueryCache", String.valueOf(string));
    }

    private boolean isEnabled(String string, boolean bl) {
        return null == string || string.equals("null") ? bl : string.equals(ENABLED);
    }

    private Integer getInteger(String string, Integer n) {
        return null == string || string.equals("null") ? n : Integer.valueOf(string);
    }

    private Long getLong(String string, Long l) {
        return null == string || string.equals("null") ? l : Long.valueOf(string);
    }

    static {
        AbstractDataSource.initialize(BQDriver.class.getName());
    }
}

