/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine.metadata;

import com.simba.googlebigquery.dsi.dataengine.filters.IFilter;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.googlebigquery.googlebigquery.core.BQConnection;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQMetadataSource;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.Map;

public class BQCatalogSchemaOnlyMetadataSource
extends BQMetadataSource {
    public BQCatalogSchemaOnlyMetadataSource(ILogger iLogger, BQConnection bQConnection, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        super(iLogger, bQConnection, map);
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_filters = new IFilter[2];
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.closeCursor();
    }

    @Override
    public void closeCursor() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedSchemasFetch = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        if (null != this.m_cachedException) {
            throw this.m_cachedException;
        }
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData((String)this.m_catalogs.get(this.m_catalogIdx), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData((String)this.m_schemas.get(this.m_schemaIdx), dataWrapper, l, l2);
            }
        }
        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.METADATA_COLUMN_NOT_FOUND_ERR.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return !this.m_hasStartedSchemasFetch;
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        boolean bl = false;
        try {
            bl = this.moveToNextSchema();
        }
        catch (ErrorException errorException) {
            this.m_cachedException = errorException;
            return true;
        }
        return bl;
    }
}

