/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.dsi.core.utilities.impl.future;

import com.simba.googlebigquery.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.NumericJDBCDataSource;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class SignedSmallIntJDBCDataSource
extends NumericJDBCDataSource {
    public SignedSmallIntJDBCDataSource(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    public Short get() throws ErrorException {
        try {
            short s = this.getShort();
            if (s == 0 && this.wasNull()) {
                return null;
            }
            return s;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, SQLException {
        short s = this.getShort();
        if (s == 0 && this.wasNull()) {
            return null;
        }
        return Short.toString(s);
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getShort() != 0;
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, SQLException {
        short s = this.getShort();
        byte by = NonTrivialJDBCConversions.LongConverter.toByte(s, this.getAndClearListener());
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                throw new RuntimeException("Unexpected fractional truncation!");
            }
            case OVERFLOW: {
                this.onOverflow(s, "getByte");
            }
        }
        return by;
    }

    @Override
    public abstract short getShort() throws ErrorException, SQLException;

    @Override
    public int getInt() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getShort();
    }

    @Override
    public long getLong() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getShort();
    }

    @Override
    public float getFloat() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getShort();
    }

    @Override
    public double getDouble() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getShort();
    }

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, SQLException {
        short s = this.getShort();
        if (s == 0 && this.wasNull()) {
            return null;
        }
        return new BigDecimal(s);
    }
}

