/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.dsi.core.utilities.impl.future;

import com.simba.googlebigquery.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.NumberJDBCDataSink;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class SignedSmallIntJDBCDataSink
extends NumberJDBCDataSink<Short> {
    public SignedSmallIntJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object == null || object instanceof Short) {
            this.doSet((Short)object);
        } else {
            short s = NonTrivialJDBCConversions.objectToShort(object, this.getAndClearListener());
            this.handleConversionResult(object, "set");
            this.doSet(s);
        }
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, SQLException, ErrorException {
        this.setShort(by);
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, SQLException, ErrorException {
        this.doSet(s);
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, SQLException, ErrorException {
        short s = NonTrivialJDBCConversions.LongConverter.toShort(n, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(n, "setInt");
        }
        this.setShort(s);
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, SQLException, ErrorException {
        short s = NonTrivialJDBCConversions.LongConverter.toShort(l, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(l, "setLong");
        }
        this.setShort(s);
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, SQLException, ErrorException {
        short s = NonTrivialJDBCConversions.DoubleConverter.toShort(f, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(Float.valueOf(f), "setFloat");
        }
        this.setShort(s);
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, SQLException, ErrorException {
        short s = NonTrivialJDBCConversions.DoubleConverter.toShort(d, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(d, "setDouble");
        }
        this.setShort(s);
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, SQLException, ErrorException {
        if (bigDecimal == null) {
            this.setNull(3);
        } else {
            short s = NonTrivialJDBCConversions.DecimalConverter.toShort(bigDecimal, this.getAndClearListener());
            this.handleConversionResult(bigDecimal, "setBigDecimal");
            this.setShort(s);
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            try {
                this.setShort(Short.parseShort(string));
            }
            catch (NumberFormatException numberFormatException) {
                short s = NonTrivialJDBCConversions.DecimalConverter.toShort(new BigDecimal(string.trim()), this.getAndClearListener());
                this.handleConversionResult(string, "setString");
                this.setShort(s);
            }
        }
    }
}

