/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.dsi.core.utilities.impl.future;

import com.simba.googlebigquery.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.NumberJDBCDataSink;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class SignedBigIntJDBCDataSink
extends NumberJDBCDataSink<Long> {
    public SignedBigIntJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object == null || object instanceof Long) {
            this.doSet((Long)object);
        } else {
            long l = NonTrivialJDBCConversions.objectToLong(object, this.getAndClearListener());
            this.handleConversionResult(object, "set");
            this.doSet(l);
        }
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, SQLException, ErrorException {
        this.setLong(by);
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, SQLException, ErrorException {
        this.setLong(s);
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, SQLException, ErrorException {
        this.setLong(n);
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, SQLException, ErrorException {
        this.doSet(l);
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, SQLException, ErrorException {
        long l = NonTrivialJDBCConversions.DoubleConverter.toLong(f, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(Float.valueOf(f), "setFloat");
        }
        this.setLong(l);
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, SQLException, ErrorException {
        long l = NonTrivialJDBCConversions.DoubleConverter.toLong(d, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(d, "setDouble");
        }
        this.setLong(l);
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, SQLException, ErrorException {
        if (bigDecimal == null) {
            this.setNull(3);
        } else {
            long l = NonTrivialJDBCConversions.DecimalConverter.toLong(bigDecimal, this.getAndClearListener());
            this.handleConversionResult(bigDecimal, "setBigDecimal");
            this.setLong(l);
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            try {
                this.setLong(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                long l = NonTrivialJDBCConversions.DecimalConverter.toLong(new BigDecimal(string.trim()), this.getAndClearListener());
                this.handleConversionResult(string, "setString");
                this.setLong(l);
            }
        }
    }
}

