# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev6
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from synctera_client import schemas  # noqa: F401


class Relationship(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    The relationship of the account and the customer/business. Either customer_id OR business_id must be specified, but not both.
    """


    class MetaOapg:
        required = {
            "relationship_type",
        }
        
        class properties:
        
            @staticmethod
            def relationship_type() -> typing.Type['AccountRelationshipType']:
                return AccountRelationshipType
            business_id = schemas.UUIDSchema
            customer_id = schemas.UUIDSchema
            id = schemas.UUIDSchema
            person_id = schemas.UUIDSchema
            __annotations__ = {
                "relationship_type": relationship_type,
                "business_id": business_id,
                "customer_id": customer_id,
                "id": id,
                "person_id": person_id,
            }
    
    relationship_type: 'AccountRelationshipType'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["relationship_type"]) -> 'AccountRelationshipType': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["business_id"]) -> MetaOapg.properties.business_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["customer_id"]) -> MetaOapg.properties.customer_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["person_id"]) -> MetaOapg.properties.person_id: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["relationship_type", "business_id", "customer_id", "id", "person_id", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["relationship_type"]) -> 'AccountRelationshipType': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["business_id"]) -> typing.Union[MetaOapg.properties.business_id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["customer_id"]) -> typing.Union[MetaOapg.properties.customer_id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> typing.Union[MetaOapg.properties.id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["person_id"]) -> typing.Union[MetaOapg.properties.person_id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["relationship_type", "business_id", "customer_id", "id", "person_id", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        relationship_type: 'AccountRelationshipType',
        business_id: typing.Union[MetaOapg.properties.business_id, str, uuid.UUID, schemas.Unset] = schemas.unset,
        customer_id: typing.Union[MetaOapg.properties.customer_id, str, uuid.UUID, schemas.Unset] = schemas.unset,
        id: typing.Union[MetaOapg.properties.id, str, uuid.UUID, schemas.Unset] = schemas.unset,
        person_id: typing.Union[MetaOapg.properties.person_id, str, uuid.UUID, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'Relationship':
        return super().__new__(
            cls,
            *_args,
            relationship_type=relationship_type,
            business_id=business_id,
            customer_id=customer_id,
            id=id,
            person_id=person_id,
            _configuration=_configuration,
            **kwargs,
        )

from synctera_client.model.account_relationship_type import AccountRelationshipType
