# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['synctera_client',
 'synctera_client.apis',
 'synctera_client.apis.paths',
 'synctera_client.apis.tags',
 'synctera_client.model',
 'synctera_client.models',
 'synctera_client.paths',
 'synctera_client.paths.accounts',
 'synctera_client.paths.accounts_account_id',
 'synctera_client.paths.accounts_account_id_relationships',
 'synctera_client.paths.accounts_account_id_relationships_relationship_id',
 'synctera_client.paths.accounts_products',
 'synctera_client.paths.accounts_products_product_id',
 'synctera_client.paths.accounts_templates',
 'synctera_client.paths.accounts_templates_template_id',
 'synctera_client.paths.ach',
 'synctera_client.paths.ach_transaction_id',
 'synctera_client.paths.ach_transaction_simulations_receiving_return',
 'synctera_client.paths.ach_transaction_simulations_receiving_transaction',
 'synctera_client.paths.businesses',
 'synctera_client.paths.businesses_business_id',
 'synctera_client.paths.cards',
 'synctera_client.paths.cards_activate',
 'synctera_client.paths.cards_card_id',
 'synctera_client.paths.cards_card_id_barcodes',
 'synctera_client.paths.cards_card_id_changes',
 'synctera_client.paths.cards_card_id_client_token',
 'synctera_client.paths.cards_card_id_digital_wallet_tokens_applepay',
 'synctera_client.paths.cards_card_id_digital_wallet_tokens_googlepay',
 'synctera_client.paths.cards_card_id_webhook_simulations_fulfillment',
 'synctera_client.paths.cards_card_widget_url',
 'synctera_client.paths.cards_digital_wallet_tokens',
 'synctera_client.paths.cards_digital_wallet_tokens_digital_wallet_token_id',
 'synctera_client.paths.cards_gateways',
 'synctera_client.paths.cards_gateways_gateway_id',
 'synctera_client.paths.cards_images',
 'synctera_client.paths.cards_images_card_image_id',
 'synctera_client.paths.cards_images_card_image_id_data',
 'synctera_client.paths.cards_products',
 'synctera_client.paths.cards_single_use_token',
 'synctera_client.paths.cards_transaction_simulations_authorization',
 'synctera_client.paths.cards_transaction_simulations_authorization_advice',
 'synctera_client.paths.cards_transaction_simulations_clearing',
 'synctera_client.paths.cards_transaction_simulations_financial',
 'synctera_client.paths.cards_transaction_simulations_financial_advice',
 'synctera_client.paths.cards_transaction_simulations_financial_balance_inquiry',
 'synctera_client.paths.cards_transaction_simulations_financial_original_credit',
 'synctera_client.paths.cards_transaction_simulations_financial_withdrawal',
 'synctera_client.paths.cards_transaction_simulations_reversal',
 'synctera_client.paths.cash_pickups',
 'synctera_client.paths.cash_pickups_cash_pickup_id',
 'synctera_client.paths.customers',
 'synctera_client.paths.customers_customer_id',
 'synctera_client.paths.customers_customer_id_disclosures',
 'synctera_client.paths.customers_customer_id_employment',
 'synctera_client.paths.customers_customer_id_employment_employment_id',
 'synctera_client.paths.customers_customer_id_prefill',
 'synctera_client.paths.customers_customer_id_risk_ratings',
 'synctera_client.paths.customers_customer_id_risk_ratings_risk_rating_id',
 'synctera_client.paths.customers_customer_id_verifications',
 'synctera_client.paths.customers_customer_id_verifications_verification_id',
 'synctera_client.paths.customers_customer_id_verify',
 'synctera_client.paths.customers_customer_id_watchlists_alerts',
 'synctera_client.paths.customers_customer_id_watchlists_alerts_alert_id',
 'synctera_client.paths.customers_customer_id_watchlists_subscriptions',
 'synctera_client.paths.customers_customer_id_watchlists_subscriptions_subscription_id',
 'synctera_client.paths.customers_customer_id_watchlists_suppressions',
 'synctera_client.paths.disclosures',
 'synctera_client.paths.disclosures_disclosure_id',
 'synctera_client.paths.documents',
 'synctera_client.paths.documents_document_id',
 'synctera_client.paths.documents_document_id_contents',
 'synctera_client.paths.documents_document_id_versions',
 'synctera_client.paths.documents_document_id_versions_document_version',
 'synctera_client.paths.documents_document_id_versions_document_version_contents',
 'synctera_client.paths.external_accounts',
 'synctera_client.paths.external_accounts_access_tokens',
 'synctera_client.paths.external_accounts_add_vendor_accounts',
 'synctera_client.paths.external_accounts_external_account_id',
 'synctera_client.paths.external_accounts_external_account_id_balance',
 'synctera_client.paths.external_accounts_external_account_id_transactions',
 'synctera_client.paths.external_accounts_link_tokens',
 'synctera_client.paths.external_accounts_sync_vendor_accounts',
 'synctera_client.paths.external_cards',
 'synctera_client.paths.external_cards_external_card_id',
 'synctera_client.paths.external_cards_tokens',
 'synctera_client.paths.external_cards_transfers',
 'synctera_client.paths.external_cards_transfers_transfer_id',
 'synctera_client.paths.external_cards_transfers_transfer_id_reversals',
 'synctera_client.paths.internal_accounts',
 'synctera_client.paths.internal_accounts_internal_account_id',
 'synctera_client.paths.monitoring_alerts',
 'synctera_client.paths.monitoring_alerts_alert_id',
 'synctera_client.paths.monitoring_subscriptions',
 'synctera_client.paths.monitoring_subscriptions_subscription_id',
 'synctera_client.paths.payment_schedules',
 'synctera_client.paths.payment_schedules_payment_schedule_id',
 'synctera_client.paths.payment_schedules_payments',
 'synctera_client.paths.persons',
 'synctera_client.paths.persons_person_id',
 'synctera_client.paths.persons_person_id_prefill',
 'synctera_client.paths.rdc_deposits',
 'synctera_client.paths.rdc_deposits_deposit_id',
 'synctera_client.paths.reconciliations',
 'synctera_client.paths.reconciliations_reconciliation_id',
 'synctera_client.paths.relationships',
 'synctera_client.paths.relationships_relationship_id',
 'synctera_client.paths.spend_controls',
 'synctera_client.paths.spend_controls_spend_control_id',
 'synctera_client.paths.statements',
 'synctera_client.paths.statements_statement_id',
 'synctera_client.paths.transactions_internal_transfer',
 'synctera_client.paths.transactions_internal_transfer_id',
 'synctera_client.paths.transactions_pending',
 'synctera_client.paths.transactions_pending_id',
 'synctera_client.paths.transactions_posted',
 'synctera_client.paths.transactions_posted_id',
 'synctera_client.paths.verifications',
 'synctera_client.paths.verifications_adhoc',
 'synctera_client.paths.verifications_verification_id',
 'synctera_client.paths.verifications_verify',
 'synctera_client.paths.webhooks',
 'synctera_client.paths.webhooks_trigger',
 'synctera_client.paths.webhooks_webhook_id',
 'synctera_client.paths.webhooks_webhook_id_events',
 'synctera_client.paths.webhooks_webhook_id_events_event_id',
 'synctera_client.paths.webhooks_webhook_id_events_event_id_resend',
 'synctera_client.paths.wipe',
 'synctera_client.paths.wires',
 'synctera_client.paths.wires_wire_id']

package_data = \
{'': ['*']}

install_requires = \
['certifi>=2017.4.17,<2018.0.0',
 'frozendict>=2.3.4,<3.0.0',
 'python-dateutil>=2.7.0,<3.0.0',
 'typing_extensions>=4.3.0,<5.0.0',
 'urllib3>=1.26.7,<2.0.0']

setup_kwargs = {
    'name': 'synctera-client',
    'version': '0.32.0.dev6',
    'description': 'Synctera API Client generated by openapi-generator',
    'long_description': '# synctera-client\n<h2>Let\'s build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company\'s banking needs and are designed to be easy to understand and implement.</p><p>We\'re continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class=\'text-blue-600\' href=\'https://synctera.com/contact\' target=\'_blank\' rel=\'noreferrer\'>contact us</a>.</p>\n\n\nThis Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:\n\n- API version: 0.32.0.dev6\n- Package version: 1.0.0\n- Build package: org.openapitools.codegen.languages.PythonClientCodegen\n\n## Requirements.\n\nPython &gt;&#x3D;3.7\n\n## Migration from other generators like python and python-legacy\n\n### Changes\n1. This generator uses spec case for all (object) property names and parameter names.\n    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case\n    - So you will need to update how you input and read properties to use spec case\n2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)\n    - So you will need to update how you pass data in to endpoints\n3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers\n    - So you will need to update your code to use response.body to access deserialized data\n4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO\n    - This means that you can use isinstance to check if a payload validated against a schema class\n    - This means that no data will be of type None/True/False\n        - ingested None will subclass NoneClass\n        - ingested True will subclass BoolClass\n        - ingested False will subclass BoolClass\n        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()\n5. All validated class instances are immutable except for ones based on io.File\n    - This is because if properties were changed after validation, that validation would no longer apply\n    - So no changing values or property values after a class has been instantiated\n6. String + Number types with formats\n    - String type data is stored as a string and if you need to access types based on its format like date,\n    date-time, uuid, number etc then you will need to use accessor functions on the instance\n    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg\n    - type number + format: See .as_float_oapg, .as_int_oapg\n    - this was done because openapi/json-schema defines constraints. string data may be type string with no format\n    keyword in one schema, and include a format constraint in another schema\n    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg\n    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg\n7. Property access on AnyType(type unset) or object(dict) schemas\n    - Only required keys with valid python names are properties like .someProp and have type hints\n    - All optional keys may not exist, so properties are not defined for them\n    - One can access optional values with dict_instance[\'optionalProp\'] and KeyError will be raised if it does not exist\n    - Use get_item_oapg if you need a way to always get a value whether or not the key exists\n        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg(\'optionalProp\')\n        - All required and optional keys have type hints for this method, and @typing.overload is used\n        - A type hint is also generated for additionalProperties accessed using this method\n    - So you will need to update you code to use some_instance[\'optionalProp\'] to access optional property\n    and additionalProperty values\n8. The location of the api classes has changed\n    - Api classes are located in your_package.apis.tags.some_api\n    - This change was made to eliminate redundant code generation\n    - Legacy generators generated the same endpoint twice if it had > 1 tag on it\n    - This generator defines an endpoint in one class, then inherits that class to generate\n      apis by tags and by paths\n    - This change reduces code and allows quicker run time if you use the path apis\n        - path apis are at your_package.apis.paths.some_path\n    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api\n    - So you will need to update your import paths to the api classes\n\n### Why are Oapg and _oapg used in class and method names?\nClasses can have arbitrarily named properties set on them\nEndpoints can have arbitrary operationId method names set\nFor those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions\non protected + public classes/methods.\noapg stands for OpenApi Python Generator.\n\n### Object property spec case\nThis was done because when payloads are ingested, they can be validated against N number of schemas.\nIf the input signature used a different property name then that has mutated the payload.\nSo SchemaA and SchemaB must both see the camelCase spec named variable.\nAlso it is possible to send in two properties, named camelCase and camel_case in the same payload.\nThat use case should be support so spec case is used.\n\n### Parameter spec case\nParameters can be included in different locations including:\n- query\n- path\n- header\n- cookie\n\nAny of those parameters could use the same parameter names, so if every parameter\nwas included as an endpoint parameter in a function signature, they would collide.\nFor that reason, each of those inputs have been separated out into separate typed dictionaries:\n- query_params\n- path_params\n- header_params\n- cookie_params\n\nSo when updating your code, you will need to pass endpoint parameters in using those\ndictionaries.\n\n### Endpoint responses\nEndpoint responses have been enriched to now include more information.\nAny response reom an endpoint will now include the following properties:\nresponse: urllib3.HTTPResponse\nbody: typing.Union[Unset, Schema]\nheaders: typing.Union[Unset, TODO]\nNote: response header deserialization has not yet been added\n\n\n## Installation & Usage\n### pip install\n\nIf the python package is hosted on a repository, you can install directly using:\n\n```sh\npip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git\n```\n(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)\n\nThen import the package:\n```python\nimport synctera_client\n```\n\n### Setuptools\n\nInstall via [Setuptools](http://pypi.python.org/pypi/setuptools).\n\n```sh\npython setup.py install --user\n```\n(or `sudo python setup.py install` to install the package for all users)\n\nThen import the package:\n```python\nimport synctera_client\n```\n\n## Getting Started\n\nPlease follow the [installation procedure](#installation--usage) and then run the following:\n\n```python\n\nimport time\nimport synctera_client\nfrom pprint import pprint\nfrom synctera_client.apis.tags import ach_api\nfrom synctera_client.model.error import Error\nfrom synctera_client.model.outgoing_ach import OutgoingAch\nfrom synctera_client.model.outgoing_ach_list import OutgoingAchList\nfrom synctera_client.model.outgoing_ach_patch import OutgoingAchPatch\nfrom synctera_client.model.outgoing_ach_request import OutgoingAchRequest\n# Defining the host is optional and defaults to https://api.synctera.com/v0\n# See configuration.py for a list of all supported configuration parameters.\nconfiguration = synctera_client.Configuration(\n    host = "https://api.synctera.com/v0"\n)\n\n# The client must configure the authentication and authorization parameters\n# in accordance with the API server security policy.\n# Examples for each auth method are provided below, use the example that\n# satisfies your auth use case.\n\n# Configure Bearer authorization (api_key): bearerAuth\nconfiguration = synctera_client.Configuration(\n    access_token = \'YOUR_BEARER_TOKEN\'\n)\n\n# Enter a context with an instance of the API client\nwith synctera_client.ApiClient(configuration) as api_client:\n    # Create an instance of the API class\n    api_instance = ach_api.ACHApi(api_client)\n    outgoing_ach_request = OutgoingAchRequest(\n        amount=607,\n        company_entry_description="PAYROLL",\n        currency="USD",\n        customer_id="e9061cf1-b472-4066-bf4b-2491b33fd182",\n        dc_sign="debit",\n        effective_date="Fri Mar 18 00:00:00 UTC 2022",\n        external_data=dict(),\n        final_customer_id="final_customer_id_example",\n        hold=AchRequestHoldData(\n            amount=1,\n            duration=2,\n        ),\n        id="cf0b50d4-f2f9-429b-bb6d-995a2e06d83a",\n        is_same_day=True,\n        memo="memo_example",\n        originating_account_id="b58b33b8-9629-4414-91ee-62c0b200c7b4",\n        receiving_account_id="3110c3f4-7937-4010-bded-86917767f50b",\n        reference_info="Tempore atque et cum.",\n        risk=RiskData(\n            client_ip="client_ip_example",\n        ),\n    ) # OutgoingAchRequest | Send ACH request\nidempotency_key = "7d943c51-e4ff-4e57-9558-08cab6b963c7" # str | An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry. (optional)\n\n    try:\n        # Send an ACH\n        api_response = api_instance.add_transaction_out(outgoing_ach_requestidempotency_key=idempotency_key)\n        pprint(api_response)\n    except synctera_client.ApiException as e:\n        print("Exception when calling ACHApi->add_transaction_out: %s\\n" % e)\n```\n\n## Documentation for API Endpoints\n\nAll URIs are relative to *https://api.synctera.com/v0*\n\nClass | Method | HTTP request | Description\n------------ | ------------- | ------------- | -------------\n*ACHApi* | [**add_transaction_out**](docs/apis/tags/ACHApi.md#add_transaction_out) | **post** /ach | Send an ACH\n*ACHApi* | [**get_transaction_out**](docs/apis/tags/ACHApi.md#get_transaction_out) | **get** /ach/{transaction_id} | Get a sent ACH transaction\n*ACHApi* | [**list_transactions_out**](docs/apis/tags/ACHApi.md#list_transactions_out) | **get** /ach | List sent ACH transactions\n*ACHApi* | [**patch_transaction_out**](docs/apis/tags/ACHApi.md#patch_transaction_out) | **patch** /ach/{transaction_id} | Update a sent ACH transaction\n*ACHTransactionSimulationsApi* | [**ach_return_simulation**](docs/apis/tags/ACHTransactionSimulationsApi.md#ach_return_simulation) | **post** /ach/transaction_simulations/receiving_return | Simulate receiving ACH return\n*ACHTransactionSimulationsApi* | [**ach_transaction_simulation**](docs/apis/tags/ACHTransactionSimulationsApi.md#ach_transaction_simulation) | **post** /ach/transaction_simulations/receiving_transaction | Simulate receiving ACH transaction\n*AccountsApi* | [**create_account**](docs/apis/tags/AccountsApi.md#create_account) | **post** /accounts | Create an account\n*AccountsApi* | [**create_account_relationship**](docs/apis/tags/AccountsApi.md#create_account_relationship) | **post** /accounts/{account_id}/relationships | Create account relationship\n*AccountsApi* | [**create_account_resource_product**](docs/apis/tags/AccountsApi.md#create_account_resource_product) | **post** /accounts/products | Create an account product\n*AccountsApi* | [**create_account_template**](docs/apis/tags/AccountsApi.md#create_account_template) | **post** /accounts/templates | Create an account template\n*AccountsApi* | [**delete_account_relationship**](docs/apis/tags/AccountsApi.md#delete_account_relationship) | **delete** /accounts/{account_id}/relationships/{relationship_id} | Delete account relationship\n*AccountsApi* | [**delete_account_template**](docs/apis/tags/AccountsApi.md#delete_account_template) | **delete** /accounts/templates/{template_id} | Delete account template\n*AccountsApi* | [**get_account**](docs/apis/tags/AccountsApi.md#get_account) | **get** /accounts/{account_id} | Get account\n*AccountsApi* | [**get_account_relationship**](docs/apis/tags/AccountsApi.md#get_account_relationship) | **get** /accounts/{account_id}/relationships/{relationship_id} | Get account relationship\n*AccountsApi* | [**get_account_template**](docs/apis/tags/AccountsApi.md#get_account_template) | **get** /accounts/templates/{template_id} | Get account template\n*AccountsApi* | [**list_account_relationship**](docs/apis/tags/AccountsApi.md#list_account_relationship) | **get** /accounts/{account_id}/relationships | List account relationships\n*AccountsApi* | [**list_account_resource_products**](docs/apis/tags/AccountsApi.md#list_account_resource_products) | **get** /accounts/products | List account products\n*AccountsApi* | [**list_account_templates**](docs/apis/tags/AccountsApi.md#list_account_templates) | **get** /accounts/templates | List account templates\n*AccountsApi* | [**list_accounts**](docs/apis/tags/AccountsApi.md#list_accounts) | **get** /accounts | List accounts\n*AccountsApi* | [**patch_account**](docs/apis/tags/AccountsApi.md#patch_account) | **patch** /accounts/{account_id} | Patch account\n*AccountsApi* | [**patch_account_product**](docs/apis/tags/AccountsApi.md#patch_account_product) | **patch** /accounts/products/{product_id} | Patch account product\n*AccountsApi* | [**update_account**](docs/apis/tags/AccountsApi.md#update_account) | **put** /accounts/{account_id} | Update account\n*AccountsApi* | [**update_account_relationship**](docs/apis/tags/AccountsApi.md#update_account_relationship) | **put** /accounts/{account_id}/relationships/{relationship_id} | Update account relationship\n*AccountsApi* | [**update_account_template**](docs/apis/tags/AccountsApi.md#update_account_template) | **put** /accounts/templates/{template_id} | Update account template\n*BusinessesApi* | [**create_business**](docs/apis/tags/BusinessesApi.md#create_business) | **post** /businesses | Create a business\n*BusinessesApi* | [**get_business**](docs/apis/tags/BusinessesApi.md#get_business) | **get** /businesses/{business_id} | Get business\n*BusinessesApi* | [**list_businesses**](docs/apis/tags/BusinessesApi.md#list_businesses) | **get** /businesses | List business\n*BusinessesApi* | [**update_business**](docs/apis/tags/BusinessesApi.md#update_business) | **patch** /businesses/{business_id} | Patch business\n*CardTransactionSimulationsApi* | [**simulate_authorization**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_authorization) | **post** /cards/transaction_simulations/authorization | Simulate authorization\n*CardTransactionSimulationsApi* | [**simulate_authorization_advice**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_authorization_advice) | **post** /cards/transaction_simulations/authorization/advice | Simulate authorization advice\n*CardTransactionSimulationsApi* | [**simulate_balance_inquiry**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_balance_inquiry) | **post** /cards/transaction_simulations/financial/balance_inquiry | Simulate balance inquiry\n*CardTransactionSimulationsApi* | [**simulate_clearing**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_clearing) | **post** /cards/transaction_simulations/clearing | Simulate clearing or refund\n*CardTransactionSimulationsApi* | [**simulate_financial**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_financial) | **post** /cards/transaction_simulations/financial | Simulate financial\n*CardTransactionSimulationsApi* | [**simulate_financial_advice**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_financial_advice) | **post** /cards/transaction_simulations/financial/advice | Simulate financial advice\n*CardTransactionSimulationsApi* | [**simulate_original_credit**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_original_credit) | **post** /cards/transaction_simulations/financial/original_credit | Simulate OCT\n*CardTransactionSimulationsApi* | [**simulate_reversal**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_reversal) | **post** /cards/transaction_simulations/reversal | Simulate reversal\n*CardTransactionSimulationsApi* | [**simulate_withdrawal**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_withdrawal) | **post** /cards/transaction_simulations/financial/withdrawal | Simulate ATM withdrawal\n*CardWebhookSimulationsApi* | [**simulate_card_fulfillment_event**](docs/apis/tags/CardWebhookSimulationsApi.md#simulate_card_fulfillment_event) | **post** /cards/{card_id}/webhook_simulations/fulfillment | Simulate Card Fulfillment Event\n*CardsApi* | [**activate_card**](docs/apis/tags/CardsApi.md#activate_card) | **post** /cards/activate | Activate a card\n*CardsApi* | [**create_card_image**](docs/apis/tags/CardsApi.md#create_card_image) | **post** /cards/images | Create Card Image\n*CardsApi* | [**create_gateway**](docs/apis/tags/CardsApi.md#create_gateway) | **post** /cards/gateways | Create Gateway\n*CardsApi* | [**get_card**](docs/apis/tags/CardsApi.md#get_card) | **get** /cards/{card_id} | Get Card\n*CardsApi* | [**get_card_barcode**](docs/apis/tags/CardsApi.md#get_card_barcode) | **get** /cards/{card_id}/barcodes | Get Card Barcode\n*CardsApi* | [**get_card_image_data**](docs/apis/tags/CardsApi.md#get_card_image_data) | **get** /cards/images/{card_image_id}/data | Get Card Image Data\n*CardsApi* | [**get_card_image_details**](docs/apis/tags/CardsApi.md#get_card_image_details) | **get** /cards/images/{card_image_id} | Get Card Image Details\n*CardsApi* | [**get_card_widget_url**](docs/apis/tags/CardsApi.md#get_card_widget_url) | **get** /cards/card_widget_url | Get card widget URL\n*CardsApi* | [**get_client_access_token**](docs/apis/tags/CardsApi.md#get_client_access_token) | **post** /cards/{card_id}/client_token | Get a client token\n*CardsApi* | [**get_client_single_use_token**](docs/apis/tags/CardsApi.md#get_client_single_use_token) | **post** /cards/single_use_token | Get single-use token\n*CardsApi* | [**get_gateway**](docs/apis/tags/CardsApi.md#get_gateway) | **get** /cards/gateways/{gateway_id} | Get Gateway\n*CardsApi* | [**issue_card**](docs/apis/tags/CardsApi.md#issue_card) | **post** /cards | Issue a Card\n*CardsApi* | [**list_card_image_details**](docs/apis/tags/CardsApi.md#list_card_image_details) | **get** /cards/images | List Card Image Details\n*CardsApi* | [**list_card_products**](docs/apis/tags/CardsApi.md#list_card_products) | **get** /cards/products | List Card Products\n*CardsApi* | [**list_cards**](docs/apis/tags/CardsApi.md#list_cards) | **get** /cards | List Cards\n*CardsApi* | [**list_changes**](docs/apis/tags/CardsApi.md#list_changes) | **get** /cards/{card_id}/changes | List Card Changes\n*CardsApi* | [**list_gateways**](docs/apis/tags/CardsApi.md#list_gateways) | **get** /cards/gateways | List Gateways\n*CardsApi* | [**update_card**](docs/apis/tags/CardsApi.md#update_card) | **patch** /cards/{card_id} | Update Card\n*CardsApi* | [**update_card_image_details**](docs/apis/tags/CardsApi.md#update_card_image_details) | **patch** /cards/images/{card_image_id} | Update Card Image Details\n*CardsApi* | [**update_gateway**](docs/apis/tags/CardsApi.md#update_gateway) | **patch** /cards/gateways/{gateway_id} | Update Gateway\n*CardsApi* | [**upload_card_image_data**](docs/apis/tags/CardsApi.md#upload_card_image_data) | **post** /cards/images/{card_image_id}/data | Upload Card Image\n*CashPickupsAlphaApi* | [**create_cash_pickup**](docs/apis/tags/CashPickupsAlphaApi.md#create_cash_pickup) | **post** /cash_pickups | Create a cash pickup\n*CashPickupsAlphaApi* | [**get_cash_pickup**](docs/apis/tags/CashPickupsAlphaApi.md#get_cash_pickup) | **get** /cash_pickups/{cash_pickup_id} | Get a cash pickup\n*CashPickupsAlphaApi* | [**list_cash_pickups**](docs/apis/tags/CashPickupsAlphaApi.md#list_cash_pickups) | **get** /cash_pickups | List cash pickups\n*CashPickupsAlphaApi* | [**patch_cash_pickup**](docs/apis/tags/CashPickupsAlphaApi.md#patch_cash_pickup) | **patch** /cash_pickups/{cash_pickup_id} | Update a cash pickup\n*CustomersApi* | [**create_customer**](docs/apis/tags/CustomersApi.md#create_customer) | **post** /customers | Create a Customer\n*CustomersApi* | [**create_customer_employment**](docs/apis/tags/CustomersApi.md#create_customer_employment) | **post** /customers/{customer_id}/employment | Create employment record\n*CustomersApi* | [**create_customer_risk_rating**](docs/apis/tags/CustomersApi.md#create_customer_risk_rating) | **post** /customers/{customer_id}/risk_ratings | Create customer risk rating\n*CustomersApi* | [**get_all_customer_employment**](docs/apis/tags/CustomersApi.md#get_all_customer_employment) | **get** /customers/{customer_id}/employment | List customer employment records\n*CustomersApi* | [**get_all_customer_risk_ratings**](docs/apis/tags/CustomersApi.md#get_all_customer_risk_ratings) | **get** /customers/{customer_id}/risk_ratings | List customer risk ratings\n*CustomersApi* | [**get_customer**](docs/apis/tags/CustomersApi.md#get_customer) | **get** /customers/{customer_id} | Get Customer\n*CustomersApi* | [**get_customer_risk_rating**](docs/apis/tags/CustomersApi.md#get_customer_risk_rating) | **get** /customers/{customer_id}/risk_ratings/{risk_rating_id} | Get customer risk rating\n*CustomersApi* | [**get_party_employment**](docs/apis/tags/CustomersApi.md#get_party_employment) | **get** /customers/{customer_id}/employment/{employment_id} | Get customer employment record\n*CustomersApi* | [**list_customers**](docs/apis/tags/CustomersApi.md#list_customers) | **get** /customers | List Customers\n*CustomersApi* | [**patch_customer**](docs/apis/tags/CustomersApi.md#patch_customer) | **patch** /customers/{customer_id} | Patch Customer\n*CustomersApi* | [**prefill_customer**](docs/apis/tags/CustomersApi.md#prefill_customer) | **post** /customers/{customer_id}/prefill | Prefill customer\n*CustomersApi* | [**update_customer**](docs/apis/tags/CustomersApi.md#update_customer) | **put** /customers/{customer_id} | Update Customer\n*CustomersApi* | [**update_party_employment**](docs/apis/tags/CustomersApi.md#update_party_employment) | **put** /customers/{customer_id}/employment/{employment_id} | Update customer employment record\n*DigitalWalletTokensApi* | [**create_digital_wallet_apple**](docs/apis/tags/DigitalWalletTokensApi.md#create_digital_wallet_apple) | **post** /cards/{card_id}/digital_wallet_tokens/applepay | Create digital wallet token provision request for Apple Pay\n*DigitalWalletTokensApi* | [**create_digital_wallet_google**](docs/apis/tags/DigitalWalletTokensApi.md#create_digital_wallet_google) | **post** /cards/{card_id}/digital_wallet_tokens/googlepay | Create digital wallet token provision request for Google Pay\n*DigitalWalletTokensApi* | [**get_digital_wallet_token**](docs/apis/tags/DigitalWalletTokensApi.md#get_digital_wallet_token) | **get** /cards/digital_wallet_tokens/{digital_wallet_token_id} | Get Digital Wallet Token\n*DigitalWalletTokensApi* | [**list_digital_wallet_tokens**](docs/apis/tags/DigitalWalletTokensApi.md#list_digital_wallet_tokens) | **get** /cards/digital_wallet_tokens | List Digital Wallet Tokens\n*DigitalWalletTokensApi* | [**update_digital_wallet_token_status**](docs/apis/tags/DigitalWalletTokensApi.md#update_digital_wallet_token_status) | **patch** /cards/digital_wallet_tokens/{digital_wallet_token_id} | Update Digital Wallet Token&#x27;s life cycle status\n*DisclosuresApi* | [**create_disclosure**](docs/apis/tags/DisclosuresApi.md#create_disclosure) | **post** /disclosures | Create disclosure record\n*DisclosuresApi* | [**get_disclosure**](docs/apis/tags/DisclosuresApi.md#get_disclosure) | **get** /disclosures/{disclosure_id} | Get disclosure\n*DisclosuresApi* | [**list_disclosures**](docs/apis/tags/DisclosuresApi.md#list_disclosures) | **get** /disclosures | List disclosures\n*DisclosuresDeprecatedApi* | [**create_disclosure1**](docs/apis/tags/DisclosuresDeprecatedApi.md#create_disclosure1) | **post** /customers/{customer_id}/disclosures | Create a Disclosure\n*DisclosuresDeprecatedApi* | [**list_disclosures1**](docs/apis/tags/DisclosuresDeprecatedApi.md#list_disclosures1) | **get** /customers/{customer_id}/disclosures | List Disclosures\n*DocumentsApi* | [**create_document**](docs/apis/tags/DocumentsApi.md#create_document) | **post** /documents | Create a document\n*DocumentsApi* | [**create_document_version**](docs/apis/tags/DocumentsApi.md#create_document_version) | **post** /documents/{document_id}/versions | Create a new document version\n*DocumentsApi* | [**get_document**](docs/apis/tags/DocumentsApi.md#get_document) | **get** /documents/{document_id} | Get a document\n*DocumentsApi* | [**get_document_contents**](docs/apis/tags/DocumentsApi.md#get_document_contents) | **get** /documents/{document_id}/contents | Get contents of latest document version\n*DocumentsApi* | [**get_document_version**](docs/apis/tags/DocumentsApi.md#get_document_version) | **get** /documents/{document_id}/versions/{document_version} | Get a document by version\n*DocumentsApi* | [**get_document_version_contents**](docs/apis/tags/DocumentsApi.md#get_document_version_contents) | **get** /documents/{document_id}/versions/{document_version}/contents | Get document contents by version\n*DocumentsApi* | [**list_documents**](docs/apis/tags/DocumentsApi.md#list_documents) | **get** /documents | List documents\n*DocumentsApi* | [**update_document**](docs/apis/tags/DocumentsApi.md#update_document) | **patch** /documents/{document_id} | Update a document\n*ExternalAccountsApi* | [**add_external_accounts**](docs/apis/tags/ExternalAccountsApi.md#add_external_accounts) | **post** /external_accounts | Add an external account\n*ExternalAccountsApi* | [**add_vendor_external_accounts**](docs/apis/tags/ExternalAccountsApi.md#add_vendor_external_accounts) | **post** /external_accounts/add_vendor_accounts | Add external accounts through a vendor, such as Plaid.\n*ExternalAccountsApi* | [**create_access_token**](docs/apis/tags/ExternalAccountsApi.md#create_access_token) | **post** /external_accounts/access_tokens | Create a permanent access token for an external account\n*ExternalAccountsApi* | [**create_verification_link_token**](docs/apis/tags/ExternalAccountsApi.md#create_verification_link_token) | **post** /external_accounts/link_tokens | Create a link token to verify an external account\n*ExternalAccountsApi* | [**delete_external_account**](docs/apis/tags/ExternalAccountsApi.md#delete_external_account) | **delete** /external_accounts/{external_account_id} | Delete an external account\n*ExternalAccountsApi* | [**get_external_account**](docs/apis/tags/ExternalAccountsApi.md#get_external_account) | **get** /external_accounts/{external_account_id} | Get an external account\n*ExternalAccountsApi* | [**get_external_account_balance**](docs/apis/tags/ExternalAccountsApi.md#get_external_account_balance) | **get** /external_accounts/{external_account_id}/balance | Get an external account balance\n*ExternalAccountsApi* | [**get_external_account_transactions**](docs/apis/tags/ExternalAccountsApi.md#get_external_account_transactions) | **get** /external_accounts/{external_account_id}/transactions | List transactions of a given external account\n*ExternalAccountsApi* | [**list_external_accounts**](docs/apis/tags/ExternalAccountsApi.md#list_external_accounts) | **get** /external_accounts | List external accounts\n*ExternalAccountsApi* | [**sync_vendor_external_accounts**](docs/apis/tags/ExternalAccountsApi.md#sync_vendor_external_accounts) | **post** /external_accounts/sync_vendor_accounts | Sync external accounts through a vendor, such as Plaid.\n*ExternalAccountsApi* | [**update_external_account**](docs/apis/tags/ExternalAccountsApi.md#update_external_account) | **patch** /external_accounts/{external_account_id} | Patch an external account\n*ExternalCardsAlphaApi* | [**create_external_card_from_token**](docs/apis/tags/ExternalCardsAlphaApi.md#create_external_card_from_token) | **post** /external_cards/tokens | Create External Card from token\n*ExternalCardsAlphaApi* | [**create_external_card_transfer**](docs/apis/tags/ExternalCardsAlphaApi.md#create_external_card_transfer) | **post** /external_cards/transfers | Create External Card Transfer\n*ExternalCardsAlphaApi* | [**create_external_card_transfer_reversal**](docs/apis/tags/ExternalCardsAlphaApi.md#create_external_card_transfer_reversal) | **post** /external_cards/transfers/{transfer_id}/reversals | Create External Card Transfer Reversal\n*ExternalCardsAlphaApi* | [**get_external_card**](docs/apis/tags/ExternalCardsAlphaApi.md#get_external_card) | **get** /external_cards/{external_card_id} | Get External Card\n*ExternalCardsAlphaApi* | [**get_external_card_transfer**](docs/apis/tags/ExternalCardsAlphaApi.md#get_external_card_transfer) | **get** /external_cards/transfers/{transfer_id} | Get External Card Transfer\n*ExternalCardsAlphaApi* | [**list_external_card_transfers**](docs/apis/tags/ExternalCardsAlphaApi.md#list_external_card_transfers) | **get** /external_cards/transfers | List External Card Transfers\n*ExternalCardsAlphaApi* | [**list_external_cards**](docs/apis/tags/ExternalCardsAlphaApi.md#list_external_cards) | **get** /external_cards | List External Cards\n*InternalAccountsApi* | [**add_internal_accounts**](docs/apis/tags/InternalAccountsApi.md#add_internal_accounts) | **post** /internal_accounts | Add internal accounts\n*InternalAccountsApi* | [**get_internal_accounts**](docs/apis/tags/InternalAccountsApi.md#get_internal_accounts) | **get** /internal_accounts/{internal_account_id} | Get internal account by id\n*InternalAccountsApi* | [**list_internal_accounts**](docs/apis/tags/InternalAccountsApi.md#list_internal_accounts) | **get** /internal_accounts | List internal accounts\n*InternalAccountsApi* | [**patch_internal_account**](docs/apis/tags/InternalAccountsApi.md#patch_internal_account) | **patch** /internal_accounts/{internal_account_id} | Patch internal account\n*InternalTransferApi* | [**create_internal_transfer**](docs/apis/tags/InternalTransferApi.md#create_internal_transfer) | **post** /transactions/internal_transfer | Create an internal transfer\n*InternalTransferApi* | [**get_internal_transfer_by_id**](docs/apis/tags/InternalTransferApi.md#get_internal_transfer_by_id) | **get** /transactions/internal_transfer/{id} | Get an internal transfer\n*InternalTransferApi* | [**update_internal_transfer_by_id**](docs/apis/tags/InternalTransferApi.md#update_internal_transfer_by_id) | **patch** /transactions/internal_transfer/{id} | Update an internal transfer\n*KYCVerificationDeprecatedApi* | [**create_customer_verification_result**](docs/apis/tags/KYCVerificationDeprecatedApi.md#create_customer_verification_result) | **post** /customers/{customer_id}/verifications | Create a customer verification result\n*KYCVerificationDeprecatedApi* | [**get_verification**](docs/apis/tags/KYCVerificationDeprecatedApi.md#get_verification) | **get** /customers/{customer_id}/verifications/{verification_id} | Get verification result\n*KYCVerificationDeprecatedApi* | [**list_verifications**](docs/apis/tags/KYCVerificationDeprecatedApi.md#list_verifications) | **get** /customers/{customer_id}/verifications | List verification results\n*KYCVerificationDeprecatedApi* | [**verify_customer**](docs/apis/tags/KYCVerificationDeprecatedApi.md#verify_customer) | **post** /customers/{customer_id}/verify | Verify a customer&#x27;s identity\n*KYCKYBVerificationsApi* | [**create_verification**](docs/apis/tags/KYCKYBVerificationsApi.md#create_verification) | **post** /verifications | Create a verification\n*KYCKYBVerificationsApi* | [**get_verification1**](docs/apis/tags/KYCKYBVerificationsApi.md#get_verification1) | **get** /verifications/{verification_id} | Get verification\n*KYCKYBVerificationsApi* | [**list_verifications1**](docs/apis/tags/KYCKYBVerificationsApi.md#list_verifications1) | **get** /verifications | List verifications\n*KYCKYBVerificationsApi* | [**verify**](docs/apis/tags/KYCKYBVerificationsApi.md#verify) | **post** /verifications/verify | Verify a customer&#x27;s identity\n*KYCKYBVerificationsApi* | [**verify_ad_hoc**](docs/apis/tags/KYCKYBVerificationsApi.md#verify_ad_hoc) | **post** /verifications/adhoc | Check if an individual is on any watchlists\n*MonitoringApi* | [**create_subscription**](docs/apis/tags/MonitoringApi.md#create_subscription) | **post** /monitoring/subscriptions | Subscribe a customer or business to monitoring\n*MonitoringApi* | [**delete_subscription**](docs/apis/tags/MonitoringApi.md#delete_subscription) | **delete** /monitoring/subscriptions/{subscription_id} | Delete monitoring subscription\n*MonitoringApi* | [**get_alert**](docs/apis/tags/MonitoringApi.md#get_alert) | **get** /monitoring/alerts/{alert_id} | Retrieve a monitoring alert\n*MonitoringApi* | [**get_subscription**](docs/apis/tags/MonitoringApi.md#get_subscription) | **get** /monitoring/subscriptions/{subscription_id} | Retrieve monitoring subscription\n*MonitoringApi* | [**list_alerts**](docs/apis/tags/MonitoringApi.md#list_alerts) | **get** /monitoring/alerts | List monitoring alerts\n*MonitoringApi* | [**list_subscriptions**](docs/apis/tags/MonitoringApi.md#list_subscriptions) | **get** /monitoring/subscriptions | List monitoring subscriptions\n*MonitoringApi* | [**update_alert**](docs/apis/tags/MonitoringApi.md#update_alert) | **patch** /monitoring/alerts/{alert_id} | Update a monitoring alert\n*PaymentSchedulesApi* | [**create_payment_schedule**](docs/apis/tags/PaymentSchedulesApi.md#create_payment_schedule) | **post** /payment_schedules | Create a payment schedule\n*PaymentSchedulesApi* | [**list_payment_schedules**](docs/apis/tags/PaymentSchedulesApi.md#list_payment_schedules) | **get** /payment_schedules | List payment schedules\n*PaymentSchedulesApi* | [**list_payments**](docs/apis/tags/PaymentSchedulesApi.md#list_payments) | **get** /payment_schedules/payments | List payments\n*PaymentSchedulesApi* | [**patch_payment_schedule**](docs/apis/tags/PaymentSchedulesApi.md#patch_payment_schedule) | **patch** /payment_schedules/{payment_schedule_id} | Update a payment schedule\n*PersonsApi* | [**create_person**](docs/apis/tags/PersonsApi.md#create_person) | **post** /persons | Create a person\n*PersonsApi* | [**get_person**](docs/apis/tags/PersonsApi.md#get_person) | **get** /persons/{person_id} | Get person\n*PersonsApi* | [**list_persons**](docs/apis/tags/PersonsApi.md#list_persons) | **get** /persons | List persons\n*PersonsApi* | [**prefill_person**](docs/apis/tags/PersonsApi.md#prefill_person) | **post** /persons/{person_id}/prefill | Prefill person\n*PersonsApi* | [**update_person**](docs/apis/tags/PersonsApi.md#update_person) | **patch** /persons/{person_id} | Update person\n*ReconciliationsApi* | [**create_reconciliation**](docs/apis/tags/ReconciliationsApi.md#create_reconciliation) | **post** /reconciliations | Create a reconciliation\n*ReconciliationsApi* | [**get_reconciliation**](docs/apis/tags/ReconciliationsApi.md#get_reconciliation) | **get** /reconciliations/{reconciliation_id} | Get reconciliation\n*ReconciliationsApi* | [**list_reconciliations**](docs/apis/tags/ReconciliationsApi.md#list_reconciliations) | **get** /reconciliations | List reconciliations\n*RelationshipsApi* | [**create_relationship**](docs/apis/tags/RelationshipsApi.md#create_relationship) | **post** /relationships | Create a relationship\n*RelationshipsApi* | [**delete_relationship**](docs/apis/tags/RelationshipsApi.md#delete_relationship) | **delete** /relationships/{relationship_id} | Delete relationship\n*RelationshipsApi* | [**get_relationship**](docs/apis/tags/RelationshipsApi.md#get_relationship) | **get** /relationships/{relationship_id} | Get relationship\n*RelationshipsApi* | [**list_relationships**](docs/apis/tags/RelationshipsApi.md#list_relationships) | **get** /relationships | List relationships\n*RelationshipsApi* | [**update_relationship**](docs/apis/tags/RelationshipsApi.md#update_relationship) | **patch** /relationships/{relationship_id} | Update relationship\n*RemoteCheckDepositBetaApi* | [**create_rdc_deposit**](docs/apis/tags/RemoteCheckDepositBetaApi.md#create_rdc_deposit) | **post** /rdc/deposits | Create a Remote Check Deposit\n*RemoteCheckDepositBetaApi* | [**get_rdc_deposit**](docs/apis/tags/RemoteCheckDepositBetaApi.md#get_rdc_deposit) | **get** /rdc/deposits/{deposit_id} | Get Remote Check Deposit\n*RemoteCheckDepositBetaApi* | [**list_rdc_deposits**](docs/apis/tags/RemoteCheckDepositBetaApi.md#list_rdc_deposits) | **get** /rdc/deposits | List Remote Check Deposits\n*SandboxWipeAlphaApi* | [**wipe_workspace**](docs/apis/tags/SandboxWipeAlphaApi.md#wipe_workspace) | **post** /wipe | Delete data\n*SpendControlsBetaApi* | [**create_spend_control**](docs/apis/tags/SpendControlsBetaApi.md#create_spend_control) | **post** /spend_controls | Create Spend Control\n*SpendControlsBetaApi* | [**get_spend_control**](docs/apis/tags/SpendControlsBetaApi.md#get_spend_control) | **get** /spend_controls/{spend_control_id} | Get Spend Control\n*SpendControlsBetaApi* | [**list_spend_controls**](docs/apis/tags/SpendControlsBetaApi.md#list_spend_controls) | **get** /spend_controls | List Spend Controls\n*SpendControlsBetaApi* | [**update_spend_control**](docs/apis/tags/SpendControlsBetaApi.md#update_spend_control) | **patch** /spend_controls/{spend_control_id} | Update Spend Control\n*StatementsApi* | [**get_statement**](docs/apis/tags/StatementsApi.md#get_statement) | **get** /statements/{statement_id} | Get a statement\n*StatementsApi* | [**list_statements**](docs/apis/tags/StatementsApi.md#list_statements) | **get** /statements | List statements\n*TransactionsApi* | [**get_pending_transaction_by_id**](docs/apis/tags/TransactionsApi.md#get_pending_transaction_by_id) | **get** /transactions/pending/{id} | Get a pending transaction\n*TransactionsApi* | [**get_posted_transaction_by_id**](docs/apis/tags/TransactionsApi.md#get_posted_transaction_by_id) | **get** /transactions/posted/{id} | Get a posted transaction\n*TransactionsApi* | [**list_pending_transactions**](docs/apis/tags/TransactionsApi.md#list_pending_transactions) | **get** /transactions/pending | List pending transactions\n*TransactionsApi* | [**list_posted_transactions**](docs/apis/tags/TransactionsApi.md#list_posted_transactions) | **get** /transactions/posted | List posted transactions\n*WatchlistDeprecatedApi* | [**get_watchlist_alert**](docs/apis/tags/WatchlistDeprecatedApi.md#get_watchlist_alert) | **get** /customers/{customer_id}/watchlists/alerts/{alert_id} | Retrieve watchlist monitoring alert\n*WatchlistDeprecatedApi* | [**get_watchlist_subscription**](docs/apis/tags/WatchlistDeprecatedApi.md#get_watchlist_subscription) | **get** /customers/{customer_id}/watchlists/subscriptions/{subscription_id} | Retrieve watchlist monitoring subscription\n*WatchlistDeprecatedApi* | [**list_watchlist_alerts**](docs/apis/tags/WatchlistDeprecatedApi.md#list_watchlist_alerts) | **get** /customers/{customer_id}/watchlists/alerts | List watchlist monitoring alerts for a customer\n*WatchlistDeprecatedApi* | [**list_watchlist_subscriptions**](docs/apis/tags/WatchlistDeprecatedApi.md#list_watchlist_subscriptions) | **get** /customers/{customer_id}/watchlists/subscriptions | List watchlist monitoring subscriptions for a customer\n*WatchlistDeprecatedApi* | [**suppress_watchlist_entity_alert**](docs/apis/tags/WatchlistDeprecatedApi.md#suppress_watchlist_entity_alert) | **post** /customers/{customer_id}/watchlists/suppressions | Suppress entity alert\n*WatchlistDeprecatedApi* | [**update_watchlist_alert**](docs/apis/tags/WatchlistDeprecatedApi.md#update_watchlist_alert) | **put** /customers/{customer_id}/watchlists/alerts/{alert_id} | Update watchlist alert\n*WatchlistDeprecatedApi* | [**update_watchlist_subscription**](docs/apis/tags/WatchlistDeprecatedApi.md#update_watchlist_subscription) | **put** /customers/{customer_id}/watchlists/subscriptions/{subscription_id} | Update watchlist monitoring subscription\n*WatchlistDeprecatedApi* | [**watchlist_subscribe**](docs/apis/tags/WatchlistDeprecatedApi.md#watchlist_subscribe) | **post** /customers/{customer_id}/watchlists/subscriptions | Subscribe a customer to watchlist monitoring\n*WebhooksApi* | [**create_webhook1**](docs/apis/tags/WebhooksApi.md#create_webhook1) | **post** /webhooks | Create a webhook\n*WebhooksApi* | [**delete_webhook**](docs/apis/tags/WebhooksApi.md#delete_webhook) | **delete** /webhooks/{webhook_id} | Delete a webhook\n*WebhooksApi* | [**get_event**](docs/apis/tags/WebhooksApi.md#get_event) | **get** /webhooks/{webhook_id}/events/{event_id} | Get webhook event\n*WebhooksApi* | [**get_webhook1**](docs/apis/tags/WebhooksApi.md#get_webhook1) | **get** /webhooks/{webhook_id} | Get a webhook\n*WebhooksApi* | [**list_events**](docs/apis/tags/WebhooksApi.md#list_events) | **get** /webhooks/{webhook_id}/events | List webhook events\n*WebhooksApi* | [**list_webhooks1**](docs/apis/tags/WebhooksApi.md#list_webhooks1) | **get** /webhooks | List webhooks\n*WebhooksApi* | [**resend_event**](docs/apis/tags/WebhooksApi.md#resend_event) | **post** /webhooks/{webhook_id}/events/{event_id}/resend | Resend an event\n*WebhooksApi* | [**trigger_event**](docs/apis/tags/WebhooksApi.md#trigger_event) | **post** /webhooks/trigger | Trigger an event\n*WebhooksApi* | [**update_webhook**](docs/apis/tags/WebhooksApi.md#update_webhook) | **put** /webhooks/{webhook_id} | Update a webhook\n*WiresAlphaApi* | [**cancel_wire**](docs/apis/tags/WiresAlphaApi.md#cancel_wire) | **patch** /wires/{wire_id} | Cancel an outgoing wire\n*WiresAlphaApi* | [**create_wire**](docs/apis/tags/WiresAlphaApi.md#create_wire) | **post** /wires | Send a wire\n*WiresAlphaApi* | [**get_wire**](docs/apis/tags/WiresAlphaApi.md#get_wire) | **get** /wires/{wire_id} | Get a wire by id\n*WiresAlphaApi* | [**list_wires**](docs/apis/tags/WiresAlphaApi.md#list_wires) | **get** /wires | List wires\n\n## Documentation For Models\n\n - [Account](docs/models/Account.md)\n - [AccountAccessStatus](docs/models/AccountAccessStatus.md)\n - [AccountBase](docs/models/AccountBase.md)\n - [AccountChargeSecured](docs/models/AccountChargeSecured.md)\n - [AccountCreation](docs/models/AccountCreation.md)\n - [AccountDepository](docs/models/AccountDepository.md)\n - [AccountGenericResponse](docs/models/AccountGenericResponse.md)\n - [AccountId](docs/models/AccountId.md)\n - [AccountIdentifiers](docs/models/AccountIdentifiers.md)\n - [AccountLineOfCredit](docs/models/AccountLineOfCredit.md)\n - [AccountList](docs/models/AccountList.md)\n - [AccountProduct](docs/models/AccountProduct.md)\n - [AccountProductList](docs/models/AccountProductList.md)\n - [AccountRange](docs/models/AccountRange.md)\n - [AccountRangeId](docs/models/AccountRangeId.md)\n - [AccountRangeResponse](docs/models/AccountRangeResponse.md)\n - [AccountRangeResponseList](docs/models/AccountRangeResponseList.md)\n - [AccountRangeUpdateRequest](docs/models/AccountRangeUpdateRequest.md)\n - [AccountRelationshipType](docs/models/AccountRelationshipType.md)\n - [AccountRouting](docs/models/AccountRouting.md)\n - [AccountSummary](docs/models/AccountSummary.md)\n - [AccountTemplate](docs/models/AccountTemplate.md)\n - [AccountTemplateResponse](docs/models/AccountTemplateResponse.md)\n - [AccountToAccountTransferRequest](docs/models/AccountToAccountTransferRequest.md)\n - [AccountType](docs/models/AccountType.md)\n - [AccountVerification](docs/models/AccountVerification.md)\n - [AccrualPayoutSchedule](docs/models/AccrualPayoutSchedule.md)\n - [AchInstruction](docs/models/AchInstruction.md)\n - [AchRequestHoldData](docs/models/AchRequestHoldData.md)\n - [AchReturnSimulationRequest](docs/models/AchReturnSimulationRequest.md)\n - [AchTransaction](docs/models/AchTransaction.md)\n - [AchTransactionData](docs/models/AchTransactionData.md)\n - [AchTransactionSimulationRequest](docs/models/AchTransactionSimulationRequest.md)\n - [AchTransactionSubtypes](docs/models/AchTransactionSubtypes.md)\n - [AddAccountsRequest](docs/models/AddAccountsRequest.md)\n - [AddAccountsRequestAccountIdentifiers](docs/models/AddAccountsRequestAccountIdentifiers.md)\n - [AddAccountsRequestRoutingIdentifiers](docs/models/AddAccountsRequestRoutingIdentifiers.md)\n - [AddVendorAccountFailure](docs/models/AddVendorAccountFailure.md)\n - [AddVendorAccountsErrorReason](docs/models/AddVendorAccountsErrorReason.md)\n - [AddVendorAccountsRequest](docs/models/AddVendorAccountsRequest.md)\n - [AddVendorAccountsResponse](docs/models/AddVendorAccountsResponse.md)\n - [AdditionalData](docs/models/AdditionalData.md)\n - [AdditionalOwnerData](docs/models/AdditionalOwnerData.md)\n - [Address](docs/models/Address.md)\n - [Address1](docs/models/Address1.md)\n - [Address2](docs/models/Address2.md)\n - [AdhocVerificationRequest](docs/models/AdhocVerificationRequest.md)\n - [AdhocVerificationResponse](docs/models/AdhocVerificationResponse.md)\n - [Alias](docs/models/Alias.md)\n - [AliasList](docs/models/AliasList.md)\n - [AppleDigitalWalletProvisionRequest](docs/models/AppleDigitalWalletProvisionRequest.md)\n - [AppleDigitalWalletProvisionResponse](docs/models/AppleDigitalWalletProvisionResponse.md)\n - [ApplicationListResponse](docs/models/ApplicationListResponse.md)\n - [ApplicationRequest](docs/models/ApplicationRequest.md)\n - [ApplicationResponse](docs/models/ApplicationResponse.md)\n - [ApplicationType](docs/models/ApplicationType.md)\n - [ApplicationUpdateRequest](docs/models/ApplicationUpdateRequest.md)\n - [AuthRequestModel](docs/models/AuthRequestModel.md)\n - [AuthorizationAdviceModel](docs/models/AuthorizationAdviceModel.md)\n - [Balance](docs/models/Balance.md)\n - [BalanceCeiling](docs/models/BalanceCeiling.md)\n - [BalanceFloor](docs/models/BalanceFloor.md)\n - [BalanceInquiryRequestModel](docs/models/BalanceInquiryRequestModel.md)\n - [BalanceType](docs/models/BalanceType.md)\n - [BanRule](docs/models/BanRule.md)\n - [BanRuleList](docs/models/BanRuleList.md)\n - [BanRulePatch](docs/models/BanRulePatch.md)\n - [BanRuleStatus](docs/models/BanRuleStatus.md)\n - [BanStatus](docs/models/BanStatus.md)\n - [BankDebitNetworkResponse](docs/models/BankDebitNetworkResponse.md)\n - [Base](docs/models/Base.md)\n - [BaseAccountVerification](docs/models/BaseAccountVerification.md)\n - [BaseCard](docs/models/BaseCard.md)\n - [BaseCashPickup](docs/models/BaseCashPickup.md)\n - [BaseDisclosure](docs/models/BaseDisclosure.md)\n - [BaseMasterDisclosure](docs/models/BaseMasterDisclosure.md)\n - [BasePerson](docs/models/BasePerson.md)\n - [BasePerson1](docs/models/BasePerson1.md)\n - [BaseStatement](docs/models/BaseStatement.md)\n - [BaseTemplateFields](docs/models/BaseTemplateFields.md)\n - [BaseTransaction](docs/models/BaseTransaction.md)\n - [BillingAddress](docs/models/BillingAddress.md)\n - [BillingPeriod](docs/models/BillingPeriod.md)\n - [Bin](docs/models/Bin.md)\n - [BinAndDebitNetwork](docs/models/BinAndDebitNetwork.md)\n - [BinAndDebitNetworkList](docs/models/BinAndDebitNetworkList.md)\n - [BinId](docs/models/BinId.md)\n - [BinNetworkMapping](docs/models/BinNetworkMapping.md)\n - [BinNetworkMappingResponse](docs/models/BinNetworkMappingResponse.md)\n - [BinResponse](docs/models/BinResponse.md)\n - [BinResponseList](docs/models/BinResponseList.md)\n - [BinStatus](docs/models/BinStatus.md)\n - [BinUpdateRequest](docs/models/BinUpdateRequest.md)\n - [BrandProductCode](docs/models/BrandProductCode.md)\n - [Business](docs/models/Business.md)\n - [Business1](docs/models/Business1.md)\n - [BusinessBusinessOwnerRelationship](docs/models/BusinessBusinessOwnerRelationship.md)\n - [BusinessId](docs/models/BusinessId.md)\n - [BusinessId1](docs/models/BusinessId1.md)\n - [BusinessId2](docs/models/BusinessId2.md)\n - [BusinessId3](docs/models/BusinessId3.md)\n - [BusinessId4](docs/models/BusinessId4.md)\n - [BusinessId5](docs/models/BusinessId5.md)\n - [BusinessList](docs/models/BusinessList.md)\n - [CalculationMethod](docs/models/CalculationMethod.md)\n - [CardAcceptorModel](docs/models/CardAcceptorModel.md)\n - [CardActivationRequest](docs/models/CardActivationRequest.md)\n - [CardBrand](docs/models/CardBrand.md)\n - [CardCategory](docs/models/CardCategory.md)\n - [CardChange](docs/models/CardChange.md)\n - [CardChangeState](docs/models/CardChangeState.md)\n - [CardChangesList](docs/models/CardChangesList.md)\n - [CardEditRequest](docs/models/CardEditRequest.md)\n - [CardFormat](docs/models/CardFormat.md)\n - [CardFulfillmentStatus](docs/models/CardFulfillmentStatus.md)\n - [CardId](docs/models/CardId.md)\n - [CardImageDetails](docs/models/CardImageDetails.md)\n - [CardImageDetailsList](docs/models/CardImageDetailsList.md)\n - [CardImageId](docs/models/CardImageId.md)\n - [CardImageMode](docs/models/CardImageMode.md)\n - [CardImageRejectionReason](docs/models/CardImageRejectionReason.md)\n - [CardImageStatus](docs/models/CardImageStatus.md)\n - [CardIssuanceRequest](docs/models/CardIssuanceRequest.md)\n - [CardListResponse](docs/models/CardListResponse.md)\n - [CardMetadata](docs/models/CardMetadata.md)\n - [CardOptions](docs/models/CardOptions.md)\n - [CardPin](docs/models/CardPin.md)\n - [CardPinStatus](docs/models/CardPinStatus.md)\n - [CardProduct](docs/models/CardProduct.md)\n - [CardProductId](docs/models/CardProductId.md)\n - [CardProductInternal](docs/models/CardProductInternal.md)\n - [CardProductListResponse](docs/models/CardProductListResponse.md)\n - [CardProductResponse](docs/models/CardProductResponse.md)\n - [CardProductType](docs/models/CardProductType.md)\n - [CardProductUpdateRequest](docs/models/CardProductUpdateRequest.md)\n - [CardProgram](docs/models/CardProgram.md)\n - [CardProgramId](docs/models/CardProgramId.md)\n - [CardProgramResponse](docs/models/CardProgramResponse.md)\n - [CardProgramResponseList](docs/models/CardProgramResponseList.md)\n - [CardProgramUpdateRequest](docs/models/CardProgramUpdateRequest.md)\n - [CardResponse](docs/models/CardResponse.md)\n - [CardStatus](docs/models/CardStatus.md)\n - [CardStatusObject](docs/models/CardStatusObject.md)\n - [CardStatusReasonCode](docs/models/CardStatusReasonCode.md)\n - [CardStatusReasonMemo](docs/models/CardStatusReasonMemo.md)\n - [CardStatusRequest](docs/models/CardStatusRequest.md)\n - [CardTransaction](docs/models/CardTransaction.md)\n - [CardTransactionData](docs/models/CardTransactionData.md)\n - [CardTransactionSubtypes](docs/models/CardTransactionSubtypes.md)\n - [CardWidgetUrlResponse](docs/models/CardWidgetUrlResponse.md)\n - [CashPickup](docs/models/CashPickup.md)\n - [CashPickupList](docs/models/CashPickupList.md)\n - [CashPickupPatchRequest](docs/models/CashPickupPatchRequest.md)\n - [CashPickupPostRequest](docs/models/CashPickupPostRequest.md)\n - [CashPickupStatus](docs/models/CashPickupStatus.md)\n - [ChangeChannel](docs/models/ChangeChannel.md)\n - [ChangeType](docs/models/ChangeType.md)\n - [CheckTransaction](docs/models/CheckTransaction.md)\n - [CheckTransactionData](docs/models/CheckTransactionData.md)\n - [CheckTransactionSubtypes](docs/models/CheckTransactionSubtypes.md)\n - [ClearingModel](docs/models/ClearingModel.md)\n - [ClientToken](docs/models/ClientToken.md)\n - [Content](docs/models/Content.md)\n - [ContestAch](docs/models/ContestAch.md)\n - [CountryCode](docs/models/CountryCode.md)\n - [CreateCardImageRequest](docs/models/CreateCardImageRequest.md)\n - [CreateGatewayRequest](docs/models/CreateGatewayRequest.md)\n - [CreateWebhookRequest](docs/models/CreateWebhookRequest.md)\n - [CurrencyCode](docs/models/CurrencyCode.md)\n - [CustomHeaders](docs/models/CustomHeaders.md)\n - [Customer](docs/models/Customer.md)\n - [CustomerAlias](docs/models/CustomerAlias.md)\n - [CustomerAliasList](docs/models/CustomerAliasList.md)\n - [CustomerId](docs/models/CustomerId.md)\n - [CustomerId1](docs/models/CustomerId1.md)\n - [CustomerInBody](docs/models/CustomerInBody.md)\n - [CustomerKycStatus](docs/models/CustomerKycStatus.md)\n - [CustomerList](docs/models/CustomerList.md)\n - [CustomerType](docs/models/CustomerType.md)\n - [CustomerVerification](docs/models/CustomerVerification.md)\n - [CustomerVerificationResult](docs/models/CustomerVerificationResult.md)\n - [CustomerVerificationResultList](docs/models/CustomerVerificationResultList.md)\n - [CustomerVerifyResponse](docs/models/CustomerVerifyResponse.md)\n - [DcSign](docs/models/DcSign.md)\n - [DebitNetwork](docs/models/DebitNetwork.md)\n - [DebitNetworkCreateRequest](docs/models/DebitNetworkCreateRequest.md)\n - [DebitNetworkId](docs/models/DebitNetworkId.md)\n - [DebitNetworkResponse](docs/models/DebitNetworkResponse.md)\n - [DebitNetworkResponseList](docs/models/DebitNetworkResponseList.md)\n - [DeleteResponse](docs/models/DeleteResponse.md)\n - [Deposit](docs/models/Deposit.md)\n - [DepositList](docs/models/DepositList.md)\n - [DepositPatchRequest](docs/models/DepositPatchRequest.md)\n - [Detail](docs/models/Detail.md)\n - [Details](docs/models/Details.md)\n - [DeviceType](docs/models/DeviceType.md)\n - [DigitalWalletTokenAddressVerification](docs/models/DigitalWalletTokenAddressVerification.md)\n - [DigitalWalletTokenEditRequest](docs/models/DigitalWalletTokenEditRequest.md)\n - [DigitalWalletTokenId](docs/models/DigitalWalletTokenId.md)\n - [DigitalWalletTokenResponse](docs/models/DigitalWalletTokenResponse.md)\n - [DigitalWalletTokenState](docs/models/DigitalWalletTokenState.md)\n - [DigitalWalletTokenization](docs/models/DigitalWalletTokenization.md)\n - [Disclosure](docs/models/Disclosure.md)\n - [Disclosure1](docs/models/Disclosure1.md)\n - [DisclosureList](docs/models/DisclosureList.md)\n - [DisclosureResponse](docs/models/DisclosureResponse.md)\n - [DisclosureType](docs/models/DisclosureType.md)\n - [DishonorAch](docs/models/DishonorAch.md)\n - [Document](docs/models/Document.md)\n - [DocumentList](docs/models/DocumentList.md)\n - [DocumentType](docs/models/DocumentType.md)\n - [DocumentVersion](docs/models/DocumentVersion.md)\n - [DocumentVersions](docs/models/DocumentVersions.md)\n - [EmbossName](docs/models/EmbossName.md)\n - [Employment](docs/models/Employment.md)\n - [EmploymentList](docs/models/EmploymentList.md)\n - [Encryption](docs/models/Encryption.md)\n - [EnhancedTransactionData](docs/models/EnhancedTransactionData.md)\n - [Environment](docs/models/Environment.md)\n - [Error](docs/models/Error.md)\n - [EvaluationContext](docs/models/EvaluationContext.md)\n - [EvaluationContextCustomer](docs/models/EvaluationContextCustomer.md)\n - [EvaluationResponse](docs/models/EvaluationResponse.md)\n - [EvaluationResult](docs/models/EvaluationResult.md)\n - [Event](docs/models/Event.md)\n - [EventList](docs/models/EventList.md)\n - [EventResend](docs/models/EventResend.md)\n - [EventTrigger](docs/models/EventTrigger.md)\n - [EventType](docs/models/EventType.md)\n - [EventType1](docs/models/EventType1.md)\n - [EventTypeExplicit](docs/models/EventTypeExplicit.md)\n - [EventTypeWildcard](docs/models/EventTypeWildcard.md)\n - [ExtAccountCustomerType](docs/models/ExtAccountCustomerType.md)\n - [ExternalAccount](docs/models/ExternalAccount.md)\n - [ExternalAccountAccessToken](docs/models/ExternalAccountAccessToken.md)\n - [ExternalAccountBalance](docs/models/ExternalAccountBalance.md)\n - [ExternalAccountLinkToken](docs/models/ExternalAccountLinkToken.md)\n - [ExternalAccountTransaction](docs/models/ExternalAccountTransaction.md)\n - [ExternalAccountVendorData](docs/models/ExternalAccountVendorData.md)\n - [ExternalAccountVendorValues](docs/models/ExternalAccountVendorValues.md)\n - [ExternalAccountsList](docs/models/ExternalAccountsList.md)\n - [ExternalAccountsTransactionList](docs/models/ExternalAccountsTransactionList.md)\n - [ExternalCardId](docs/models/ExternalCardId.md)\n - [ExternalCardListResponse](docs/models/ExternalCardListResponse.md)\n - [ExternalCardRequest](docs/models/ExternalCardRequest.md)\n - [ExternalCardResponse](docs/models/ExternalCardResponse.md)\n - [ExternalCardTransaction](docs/models/ExternalCardTransaction.md)\n - [ExternalCardTransactionSubtypes](docs/models/ExternalCardTransactionSubtypes.md)\n - [ExternalCardVerifications](docs/models/ExternalCardVerifications.md)\n - [ExternalPaymentDate](docs/models/ExternalPaymentDate.md)\n - [Fee](docs/models/Fee.md)\n - [FinancialInstitution](docs/models/FinancialInstitution.md)\n - [FinancialRequestModel](docs/models/FinancialRequestModel.md)\n - [FinicityAccountVerification](docs/models/FinicityAccountVerification.md)\n - [Form](docs/models/Form.md)\n - [FulfillmentDetails](docs/models/FulfillmentDetails.md)\n - [FundingSource](docs/models/FundingSource.md)\n - [FundingSourceResponse](docs/models/FundingSourceResponse.md)\n - [FundingSourceResponseList](docs/models/FundingSourceResponseList.md)\n - [GatewayCustomHeaders](docs/models/GatewayCustomHeaders.md)\n - [GatewayId](docs/models/GatewayId.md)\n - [GatewayListResponse](docs/models/GatewayListResponse.md)\n - [GatewayResponse](docs/models/GatewayResponse.md)\n - [GetViralLoopWaitlists](docs/models/GetViralLoopWaitlists.md)\n - [GoogleDigitalWalletProvisionRequest](docs/models/GoogleDigitalWalletProvisionRequest.md)\n - [GoogleDigitalWalletProvisionResponse](docs/models/GoogleDigitalWalletProvisionResponse.md)\n - [HoldCancelRequest](docs/models/HoldCancelRequest.md)\n - [HoldCreateRequest](docs/models/HoldCreateRequest.md)\n - [HoldCreateRequestStatus](docs/models/HoldCreateRequestStatus.md)\n - [HoldData](docs/models/HoldData.md)\n - [HoldDeclineRequest](docs/models/HoldDeclineRequest.md)\n - [HoldModifyRequest](docs/models/HoldModifyRequest.md)\n - [HoldPatchRequest](docs/models/HoldPatchRequest.md)\n - [HoldPostingRequest](docs/models/HoldPostingRequest.md)\n - [Id](docs/models/Id.md)\n - [InAppProvisioning](docs/models/InAppProvisioning.md)\n - [IngestionStatus](docs/models/IngestionStatus.md)\n - [Interest](docs/models/Interest.md)\n - [InternalAccount](docs/models/InternalAccount.md)\n - [InternalAccountPatch](docs/models/InternalAccountPatch.md)\n - [InternalAccountPurpose](docs/models/InternalAccountPurpose.md)\n - [InternalAccountType](docs/models/InternalAccountType.md)\n - [InternalAccountsList](docs/models/InternalAccountsList.md)\n - [InternalTransfer](docs/models/InternalTransfer.md)\n - [InternalTransferInstruction](docs/models/InternalTransferInstruction.md)\n - [InternalTransferPatch](docs/models/InternalTransferPatch.md)\n - [InternalTransferResponse](docs/models/InternalTransferResponse.md)\n - [InternalTransferTransaction](docs/models/InternalTransferTransaction.md)\n - [InternalTransferTransactionData](docs/models/InternalTransferTransactionData.md)\n - [InternalTransferTransactionSubtypes](docs/models/InternalTransferTransactionSubtypes.md)\n - [IsCustomer](docs/models/IsCustomer.md)\n - [ManualAccountVerification](docs/models/ManualAccountVerification.md)\n - [ManualEntry](docs/models/ManualEntry.md)\n - [MasterDisclosure](docs/models/MasterDisclosure.md)\n - [MasterDisclosureList](docs/models/MasterDisclosureList.md)\n - [Merchant](docs/models/Merchant.md)\n - [MinimumPayment](docs/models/MinimumPayment.md)\n - [MinimumPaymentFull](docs/models/MinimumPaymentFull.md)\n - [MinimumPaymentPartial](docs/models/MinimumPaymentPartial.md)\n - [MinimumPaymentType](docs/models/MinimumPaymentType.md)\n - [MinimumPaymentTypeFull](docs/models/MinimumPaymentTypeFull.md)\n - [MinimumPaymentTypeRateOrAmount](docs/models/MinimumPaymentTypeRateOrAmount.md)\n - [MonitoringAlert](docs/models/MonitoringAlert.md)\n - [MonitoringAlertList](docs/models/MonitoringAlertList.md)\n - [MonitoringStatus](docs/models/MonitoringStatus.md)\n - [MonitoringSubscription](docs/models/MonitoringSubscription.md)\n - [MonitoringSubscriptionList](docs/models/MonitoringSubscriptionList.md)\n - [NetworkFeeModel](docs/models/NetworkFeeModel.md)\n - [NoteCreate](docs/models/NoteCreate.md)\n - [NoteList](docs/models/NoteList.md)\n - [NoteResponse](docs/models/NoteResponse.md)\n - [OriginalCreditRequestModel](docs/models/OriginalCreditRequestModel.md)\n - [OriginalCreditSenderData](docs/models/OriginalCreditSenderData.md)\n - [OriginatingAccountId](docs/models/OriginatingAccountId.md)\n - [OutgoingAch](docs/models/OutgoingAch.md)\n - [OutgoingAchList](docs/models/OutgoingAchList.md)\n - [OutgoingAchPatch](docs/models/OutgoingAchPatch.md)\n - [OutgoingAchRequest](docs/models/OutgoingAchRequest.md)\n - [PaginatedResponse](docs/models/PaginatedResponse.md)\n - [PaginatedResponse1](docs/models/PaginatedResponse1.md)\n - [PaginatedTransactions](docs/models/PaginatedTransactions.md)\n - [PatchAccountProduct](docs/models/PatchAccountProduct.md)\n - [PatchAccountsRequestAccountIdentifiers](docs/models/PatchAccountsRequestAccountIdentifiers.md)\n - [PatchAccountsRequestRoutingIdentifiers](docs/models/PatchAccountsRequestRoutingIdentifiers.md)\n - [PatchBanStatus](docs/models/PatchBanStatus.md)\n - [PatchBusiness](docs/models/PatchBusiness.md)\n - [PatchBusinessBusinessOwnerRelationship](docs/models/PatchBusinessBusinessOwnerRelationship.md)\n - [PatchCustomer](docs/models/PatchCustomer.md)\n - [PatchDocument](docs/models/PatchDocument.md)\n - [PatchExternalAccount](docs/models/PatchExternalAccount.md)\n - [PatchInterest](docs/models/PatchInterest.md)\n - [PatchPaymentSchedule](docs/models/PatchPaymentSchedule.md)\n - [PatchPerson](docs/models/PatchPerson.md)\n - [PatchPersonBusinessOwnerRelationship](docs/models/PatchPersonBusinessOwnerRelationship.md)\n - [PatchPersonBusinessRelationship](docs/models/PatchPersonBusinessRelationship.md)\n - [PatchRelationshipIn](docs/models/PatchRelationshipIn.md)\n - [Payment](docs/models/Payment.md)\n - [PaymentDate](docs/models/PaymentDate.md)\n - [PaymentErrorDetails](docs/models/PaymentErrorDetails.md)\n - [PaymentInstruction](docs/models/PaymentInstruction.md)\n - [PaymentList](docs/models/PaymentList.md)\n - [PaymentSchedule](docs/models/PaymentSchedule.md)\n - [PaymentScheduleList](docs/models/PaymentScheduleList.md)\n - [PaymentScheduleStatus](docs/models/PaymentScheduleStatus.md)\n - [PaymentStatus](docs/models/PaymentStatus.md)\n - [PaymentType](docs/models/PaymentType.md)\n - [PaymentTypeList](docs/models/PaymentTypeList.md)\n - [PendingTransaction](docs/models/PendingTransaction.md)\n - [PendingTransactionData](docs/models/PendingTransactionData.md)\n - [PendingTransactionHistory](docs/models/PendingTransactionHistory.md)\n - [PendingTransactionHistoryData](docs/models/PendingTransactionHistoryData.md)\n - [PendingTransactions](docs/models/PendingTransactions.md)\n - [Person](docs/models/Person.md)\n - [Person1](docs/models/Person1.md)\n - [PersonBusinessOwnerRelationship](docs/models/PersonBusinessOwnerRelationship.md)\n - [PersonBusinessRelationship](docs/models/PersonBusinessRelationship.md)\n - [PersonId](docs/models/PersonId.md)\n - [PersonId1](docs/models/PersonId1.md)\n - [PersonList](docs/models/PersonList.md)\n - [PhysicalCard](docs/models/PhysicalCard.md)\n - [PhysicalCardFormat](docs/models/PhysicalCardFormat.md)\n - [PhysicalCardIssuanceRequest](docs/models/PhysicalCardIssuanceRequest.md)\n - [PhysicalCardPlusStatus](docs/models/PhysicalCardPlusStatus.md)\n - [PhysicalCardResponse](docs/models/PhysicalCardResponse.md)\n - [PhysicalCardResponseStatus](docs/models/PhysicalCardResponseStatus.md)\n - [PingResponse](docs/models/PingResponse.md)\n - [PlaidAccountVerification](docs/models/PlaidAccountVerification.md)\n - [PostedTransaction](docs/models/PostedTransaction.md)\n - [PostedTransactionData](docs/models/PostedTransactionData.md)\n - [PostedTransactionReverseRequest](docs/models/PostedTransactionReverseRequest.md)\n - [PostedTransactions](docs/models/PostedTransactions.md)\n - [PrefillRequest](docs/models/PrefillRequest.md)\n - [Prospect](docs/models/Prospect.md)\n - [Prospect1](docs/models/Prospect1.md)\n - [ProspectEditable](docs/models/ProspectEditable.md)\n - [ProspectStatus](docs/models/ProspectStatus.md)\n - [ProspectsList](docs/models/ProspectsList.md)\n - [ProviderType](docs/models/ProviderType.md)\n - [ProvisioningAppVersion](docs/models/ProvisioningAppVersion.md)\n - [ProvisioningControls](docs/models/ProvisioningControls.md)\n - [PushTokenizeRequestData](docs/models/PushTokenizeRequestData.md)\n - [QuickstartT10](docs/models/QuickstartT10.md)\n - [QuickstartT10Response](docs/models/QuickstartT10Response.md)\n - [RateDetails](docs/models/RateDetails.md)\n - [Rates](docs/models/Rates.md)\n - [RawResponse](docs/models/RawResponse.md)\n - [RecipientName](docs/models/RecipientName.md)\n - [Reconciliation](docs/models/Reconciliation.md)\n - [ReconciliationInput](docs/models/ReconciliationInput.md)\n - [ReconciliationList](docs/models/ReconciliationList.md)\n - [RelatedResourceId](docs/models/RelatedResourceId.md)\n - [RelatedResourceType](docs/models/RelatedResourceType.md)\n - [RelatedResourceType1](docs/models/RelatedResourceType1.md)\n - [Relationship](docs/models/Relationship.md)\n - [Relationship1](docs/models/Relationship1.md)\n - [RelationshipIn](docs/models/RelationshipIn.md)\n - [RelationshipList](docs/models/RelationshipList.md)\n - [RelationshipRole](docs/models/RelationshipRole.md)\n - [RelationshipsList](docs/models/RelationshipsList.md)\n - [ResendResponse](docs/models/ResendResponse.md)\n - [ResourceType](docs/models/ResourceType.md)\n - [ResponseHistoryItem](docs/models/ResponseHistoryItem.md)\n - [ReturnAch](docs/models/ReturnAch.md)\n - [ReversalModel](docs/models/ReversalModel.md)\n - [RiskData](docs/models/RiskData.md)\n - [RiskRating](docs/models/RiskRating.md)\n - [RiskRatingList](docs/models/RiskRatingList.md)\n - [SavingsSummary](docs/models/SavingsSummary.md)\n - [ScheduleConfig](docs/models/ScheduleConfig.md)\n - [Security](docs/models/Security.md)\n - [Shipping](docs/models/Shipping.md)\n - [SimulateCardFulfillment](docs/models/SimulateCardFulfillment.md)\n - [SingleUseTokenRequest](docs/models/SingleUseTokenRequest.md)\n - [SingleUseTokenResponse](docs/models/SingleUseTokenResponse.md)\n - [SocureEventBody](docs/models/SocureEventBody.md)\n - [SocureGlobalWatchlist](docs/models/SocureGlobalWatchlist.md)\n - [SocureMatch](docs/models/SocureMatch.md)\n - [SocureMatchList](docs/models/SocureMatchList.md)\n - [SocureMatches](docs/models/SocureMatches.md)\n - [SocureReasonCode](docs/models/SocureReasonCode.md)\n - [SocureWatchlistResult](docs/models/SocureWatchlistResult.md)\n - [SpendControl](docs/models/SpendControl.md)\n - [SpendControlDirection](docs/models/SpendControlDirection.md)\n - [SpendControlId](docs/models/SpendControlId.md)\n - [SpendControlIds](docs/models/SpendControlIds.md)\n - [SpendControlResponse](docs/models/SpendControlResponse.md)\n - [SpendControlResponseList](docs/models/SpendControlResponseList.md)\n - [SpendControlRollingWindowDays](docs/models/SpendControlRollingWindowDays.md)\n - [SpendControlTimeRange](docs/models/SpendControlTimeRange.md)\n - [SpendControlTimeRangeType](docs/models/SpendControlTimeRangeType.md)\n - [SpendControlUpdateRequest](docs/models/SpendControlUpdateRequest.md)\n - [SpendingLimitWithTime](docs/models/SpendingLimitWithTime.md)\n - [SpendingLimits](docs/models/SpendingLimits.md)\n - [SsnSource](docs/models/SsnSource.md)\n - [Statement](docs/models/Statement.md)\n - [StatementList](docs/models/StatementList.md)\n - [StatementSummary](docs/models/StatementSummary.md)\n - [Status](docs/models/Status.md)\n - [Status1](docs/models/Status1.md)\n - [TemplateFields](docs/models/TemplateFields.md)\n - [TemplateFieldsChargeSecured](docs/models/TemplateFieldsChargeSecured.md)\n - [TemplateFieldsDepository](docs/models/TemplateFieldsDepository.md)\n - [TemplateFieldsGenericResponse](docs/models/TemplateFieldsGenericResponse.md)\n - [TemplateFieldsLineOfCredit](docs/models/TemplateFieldsLineOfCredit.md)\n - [TemplateList](docs/models/TemplateList.md)\n - [TenantId](docs/models/TenantId.md)\n - [TenantId1](docs/models/TenantId1.md)\n - [TokenList](docs/models/TokenList.md)\n - [TokenListResponse](docs/models/TokenListResponse.md)\n - [Transaction](docs/models/Transaction.md)\n - [Transaction1](docs/models/Transaction1.md)\n - [TransactionData](docs/models/TransactionData.md)\n - [TransactionDirectPostRequest](docs/models/TransactionDirectPostRequest.md)\n - [TransactionLine](docs/models/TransactionLine.md)\n - [TransactionLine1](docs/models/TransactionLine1.md)\n - [TransactionOptions](docs/models/TransactionOptions.md)\n - [TransactionUpdateMetaRequest](docs/models/TransactionUpdateMetaRequest.md)\n - [TransferListResponse](docs/models/TransferListResponse.md)\n - [TransferRequest](docs/models/TransferRequest.md)\n - [TransferResponse](docs/models/TransferResponse.md)\n - [TransferReversalRequest](docs/models/TransferReversalRequest.md)\n - [TransferType](docs/models/TransferType.md)\n - [TransferTypeRequest](docs/models/TransferTypeRequest.md)\n - [TxnEnhancer](docs/models/TxnEnhancer.md)\n - [UpdateCardImageRequest](docs/models/UpdateCardImageRequest.md)\n - [UpdateGatewayRequest](docs/models/UpdateGatewayRequest.md)\n - [UpdateTransfer](docs/models/UpdateTransfer.md)\n - [VendorInfo](docs/models/VendorInfo.md)\n - [VendorInfo1](docs/models/VendorInfo1.md)\n - [VendorJson](docs/models/VendorJson.md)\n - [VendorXml](docs/models/VendorXml.md)\n - [Verification](docs/models/Verification.md)\n - [VerificationList](docs/models/VerificationList.md)\n - [VerificationRequest](docs/models/VerificationRequest.md)\n - [VerificationResult](docs/models/VerificationResult.md)\n - [VerificationStatus](docs/models/VerificationStatus.md)\n - [VerificationType](docs/models/VerificationType.md)\n - [VerificationType1](docs/models/VerificationType1.md)\n - [VerificationVendorInfo](docs/models/VerificationVendorInfo.md)\n - [VerificationVendorInfoDetail](docs/models/VerificationVendorInfoDetail.md)\n - [VerificationVendorJson](docs/models/VerificationVendorJson.md)\n - [VerificationVendorXml](docs/models/VerificationVendorXml.md)\n - [VerifyResponse](docs/models/VerifyResponse.md)\n - [Version](docs/models/Version.md)\n - [ViralLoopWaitlists](docs/models/ViralLoopWaitlists.md)\n - [VirtualCard](docs/models/VirtualCard.md)\n - [VirtualCardIssuanceRequest](docs/models/VirtualCardIssuanceRequest.md)\n - [VirtualCardPlusStatus](docs/models/VirtualCardPlusStatus.md)\n - [VirtualCardResponse](docs/models/VirtualCardResponse.md)\n - [VirtualCardResponseStatus](docs/models/VirtualCardResponseStatus.md)\n - [Waitlist](docs/models/Waitlist.md)\n - [WaitlistAnalytics](docs/models/WaitlistAnalytics.md)\n - [WaitlistAnalyticsList](docs/models/WaitlistAnalyticsList.md)\n - [WaitlistEditable](docs/models/WaitlistEditable.md)\n - [WaitlistsList](docs/models/WaitlistsList.md)\n - [WalletProviderCardOnFile](docs/models/WalletProviderCardOnFile.md)\n - [WatchlistAlert](docs/models/WatchlistAlert.md)\n - [WatchlistAlertList](docs/models/WatchlistAlertList.md)\n - [WatchlistSubscription](docs/models/WatchlistSubscription.md)\n - [WatchlistSubscriptionList](docs/models/WatchlistSubscriptionList.md)\n - [WatchlistSuppress](docs/models/WatchlistSuppress.md)\n - [Webhook](docs/models/Webhook.md)\n - [WebhookConfig](docs/models/WebhookConfig.md)\n - [WebhookEvent](docs/models/WebhookEvent.md)\n - [WebhookList](docs/models/WebhookList.md)\n - [WebhookRequest](docs/models/WebhookRequest.md)\n - [WebhookRequestObject](docs/models/WebhookRequestObject.md)\n - [WebhookResponse](docs/models/WebhookResponse.md)\n - [WidgetType](docs/models/WidgetType.md)\n - [Wire](docs/models/Wire.md)\n - [WireList](docs/models/WireList.md)\n - [WireRequest](docs/models/WireRequest.md)\n - [WireTransaction](docs/models/WireTransaction.md)\n - [WireTransactionData](docs/models/WireTransactionData.md)\n - [WireTransactionSubtypes](docs/models/WireTransactionSubtypes.md)\n - [WithdrawalRequestModel](docs/models/WithdrawalRequestModel.md)\n - [Workspace](docs/models/Workspace.md)\n - [WorkspaceList](docs/models/WorkspaceList.md)\n\n## Documentation For Authorization\n\n Authentication schemes defined for the API:\n## bearerAuth\n\n- **Type**: Bearer authentication (api_key)\n\n\n## Author\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n## Notes for Large OpenAPI documents\nIf the OpenAPI document is large, imports in synctera_client.apis and synctera_client.models may fail with a\nRecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:\n\nSolution 1:\nUse specific imports for apis and models like:\n- `from synctera_client.apis.default_api import DefaultApi`\n- `from synctera_client.model.pet import Pet`\n\nSolution 1:\nBefore importing the package, adjust the maximum recursion limit as shown below:\n```\nimport sys\nsys.setrecursionlimit(1500)\nimport synctera_client\nfrom synctera_client.apis import *\nfrom synctera_client.models import *\n```\n',
    'author': 'Swadesh',
    'author_email': 'dev@swadesh.co',
    'maintainer': 'D. Kasi Pavan Kumar',
    'maintainer_email': 'kasi@swadesh.co',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
