# Flickr Mirroring
* This project develops a command-line tool to mirror Flickr photo.
## Requirements
*  [Python 3.6](https://www.python.org/)
*  [langdetect](https://pypi.org/project/langdetect/)
*  [httplib2](https://pypi.org/project/httplib2/)
*  [iso-639](https://pypi.org/project/iso-639/)
## Installation
* Install the package from the PyPI database or clone the source code from github:
- Install from PyPI database:
```bash
$ pip install FlickrMirroring 
```
- Dowload the source code from github:
```bash
$ git clone https://github.com/intek-training-jsc/flickr-mirroring-tcthai.git
$ cd flickr-mirroring-tcthai
$ ~/flickr-mirroring-tcthai
$ ./setup.py
```
## Usage
* Using Flickr Mirroring to download Flickr photo likes other CLI tools:
```bash
$ mirror_flickr --help
usage: __main__.py [-h] [--username USERNAME] [--cache_path CACHE PATH]
                   [--consumer-key CONSUMER KEY]
                   [--consumer-secret CONSUMER SECRET] [--image-only]
                   [--info-level LEVEL] [--info-only] [--save-api-keys]
                   [--lifo] [--fifo]

Flickr Mirroring

optional arguments:
  -h, --help            show this help message and exit
  --username USERNAME   username of the account of a user on Flickr to mirror
                        their photostream
  --cache_path CACHE PATH
                        specify the absolute path where the photos downloaded
                        from Flickr need to be cached
  --consumer-key CONSUMER KEY
                        a unique string used by the Consumer to identify
                        themselves to the Flickr API
  --consumer-secret CONSUMER SECRET
                        a secret used by the Consumer to establish ownership
                        of the Consumer Key
  --image-only          specify whether the script must only download photos'
                        images
  --info-level LEVEL    specify the level of information of a photo to fetch
                        (value between 0 and 2)
  --info-only           specify whether the script must only download photos'
                        information
  --save-api-keys       specify whether to save the Flickr API keys for
                        further usage
  --lifo                specify the First-In First-Out method to mirror the
                        user's photostream, from the oldest uploaded photo to
                        the earliest
  --fifo                specify the Last-In First-Out method to mirror the
                        user's photostream, from the earliest uploaded photo
                        to the oldest (default option)
```
Example:
 * Enter and cache your Flickr API keys:
```bash
$ mirror_flickr --username manhhai --save-api-keys
Enter your Flickr API key:
Enter your Flickr API secret:
2020-05-09 16:06:47 [INFO] Scanning page 1/10275...
2020-05-09 16:06:49 [INFO] caching image of photo 49871839828_8f9547d85a_k.jpg...
2020-05-09 16:06:50 [INFO] caching image of photo 49871839808_792347bf20_k.jpg...
```
* Mirror manhhai's photo image only from Flickr photostream from the latest photo to the oldest:
```bash
$ mirror_flickr --username manhhai --lifo --image-only
2020-05-09 16:06:47 [INFO] Scanning page 1/10275...
2020-05-09 16:06:49 [INFO] caching image of photo 49871839828_8f9547d85a_k.jpg...
2020-05-09 16:06:50 [INFO] caching image of photo 49871839808_792347bf20_k.jpg...
2020-05-09 16:06:52 [INFO] caching image of photo 49871839788_c9c8939150_k.jpg...
2020-05-09 16:06:53 [INFO] caching image of photo 49872683362_b92fe21c4e_k.jpg...
2020-05-09 16:06:55 [INFO] caching image of photo 49871838263_6d1b0e037d_k.jpg...
2020-05-09 16:06:56 [INFO] caching image of photo 49871838238_fe08d646c9_k.jpg...
2020-05-09 16:06:57 [INFO] caching image of photo 49871838223_35ca37058c_k.jpg...
2020-05-09 16:06:58 [INFO] caching image of photo 49868707158_35df8f1bb3_h.jpg...
2020-05-09 16:06:59 [INFO] caching image of photo 49868707143_aa709e6b00_h.jpg...
2020-05-09 16:07:00 [INFO] caching image of photo 49869546352_fe699aaac4_h.jpg...
2020-05-09 16:07:01 [INFO] Scanning page 2/10275...
2020-05-09 16:07:02 [INFO] caching image of photo 49869546327_5d040383a0_h.jpg...
2020-05-09 16:07:03 [INFO] caching image of photo 49869237541_e5dbd3328b_h.jpg...
2020-05-09 16:07:05 [INFO] caching image of photo 49868707073_73e0456e89_h.jpg...
2020-05-09 16:07:05 [INFO] caching image of photo 49870180252_00db383fa6_h.jpg...
2020-05-09 16:07:07 [INFO] caching image of photo 49869544157_c73e2f2c18_3k.jpg...
2020-05-09 16:07:08 [INFO] caching image of photo 49869544132_015e8c1bf4_h.jpg...
2020-05-09 16:07:10 [INFO] caching image of photo 49869544117_b138f04307_o.jpg...
2020-05-09 16:07:10 [INFO] caching image of photo 49869234961_d29c26bc70_h.jpg...
2020-05-09 16:07:11 [INFO] caching image of photo 49869544057_2aa27bcd05_h.jpg...
```
* The tool will skip photo images that have downloaded already:
```bash
$ mirror_flickr --username manhhai --lifo
2020-05-09 16:09:07 [INFO] Scanning page 1/10275...
2020-05-09 16:09:09 [INFO] caching info of photo 49871839828_8f9547d85a_k.jpg...
2020-05-09 16:09:09 [INFO] caching info of photo 49871839808_792347bf20_k.jpg...
2020-05-09 16:09:09 [INFO] caching info of photo 49871839788_c9c8939150_k.jpg...
2020-05-09 16:09:10 [INFO] caching info of photo 49872683362_b92fe21c4e_k.jpg...
2020-05-09 16:09:11 [INFO] caching info of photo 49871838263_6d1b0e037d_k.jpg...
2020-05-09 16:09:11 [INFO] caching info of photo 49871838238_fe08d646c9_k.jpg...
2020-05-09 16:09:12 [INFO] caching info of photo 49871838223_35ca37058c_k.jpg...
2020-05-09 16:09:13 [INFO] caching info of photo 49868707158_35df8f1bb3_h.jpg...
2020-05-09 16:09:13 [INFO] caching info of photo 49868707143_aa709e6b00_h.jpg...
2020-05-09 16:09:14 [INFO] caching info of photo 49869546352_fe699aaac4_h.jpg...
2020-05-09 16:09:14 [INFO] Scanning page 2/10275...
2020-05-09 16:09:15 [INFO] caching info of photo 49869546327_5d040383a0_h.jpg...
2020-05-09 16:09:16 [INFO] caching info of photo 49869237541_e5dbd3328b_h.jpg...
2020-05-09 16:09:16 [INFO] caching info of photo 49868707073_73e0456e89_h.jpg...
2020-05-09 16:09:17 [INFO] caching info of photo 49870180252_00db383fa6_h.jpg...
2020-05-09 16:09:17 [INFO] caching info of photo 49869544157_c73e2f2c18_3k.jpg...
2020-05-09 16:09:18 [INFO] caching info of photo 49869544132_015e8c1bf4_h.jpg...
2020-05-09 16:09:19 [INFO] caching info of photo 49869544117_b138f04307_o.jpg...
2020-05-09 16:09:19 [INFO] caching info of photo 49869234961_d29c26bc70_h.jpg...
2020-05-09 16:09:20 [INFO] caching info of photo 49869544057_2aa27bcd05_h.jpg...
2020-05-09 16:09:21 [INFO] caching image of photo 49868704598_31fb603d38_h.jpg...
2020-05-09 16:09:21 [INFO] caching info of photo 49868704598_31fb603d38_h.jpg...
2020-05-09 16:09:21 [INFO] Scanning page 3/10275...
2020-05-09 16:09:22 [INFO] caching image of photo 49868702798_bf5a09e62d_4k.jpg...
2020-05-09 16:09:22 [INFO] caching info of photo 49868702798_bf5a09e62d_4k.jpg...
2020-05-09 16:09:23 [INFO] caching image of photo 49868702783_5cbac0a40b_h.jpg...
2020-05-09 16:09:23 [INFO] caching info of photo 49868702783_5cbac0a40b_h.jpg...
2020-05-09 16:09:24 [INFO] caching image of photo 49869542367_6c73e868a3_h.jpg...
2020-05-09 16:09:24 [INFO] caching info of photo 49869542367_6c73e868a3_h.jpg...
2020-05-09 16:09:24 [INFO] caching image of photo 49869542322_556654f78d_o.jpg...
2020-05-09 16:09:24 [INFO] caching info of photo 49869542322_556654f78d_o.jpg...
```
