# Generated by Django 4.2.16 on 2025-01-26 22:33

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("eveonline", "0017_alliance_and_corp_names_are_not_unique"),
        ("authentication", "0024_alter_userprofile_language"),
        ("eveuniverse", "0010_alter_eveindustryactivityduration_eve_type_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="General",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "permissions": (
                    ("basic_access", "Can access this app"),
                    (
                        "corporation_view",
                        "Can view all dens anchored by members of their corporation",
                    ),
                    (
                        "alliance_view",
                        "Can view all dens anchored by members of their alliance",
                    ),
                    ("manager", "Can see all user's mercenary dens"),
                ),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="DenOwner",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "is_enabled",
                    models.BooleanField(
                        db_index=True,
                        default=True,
                        help_text="Disabled characters won't be synced",
                    ),
                ),
                (
                    "character_ownership",
                    models.ForeignKey(
                        help_text="Character used to sync mercenary dens",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="authentication.characterownership",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="MercenaryDen",
            fields=[
                (
                    "id",
                    models.BigIntegerField(
                        help_text="Eve online id of the den",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        help_text="Location of the den",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveuniverse.eveplanet",
                    ),
                ),
                (
                    "owner",
                    models.ForeignKey(
                        help_text="Character that anchored the den",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="dens.denowner",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="MercenaryDenReinforcedNotification",
            fields=[
                ("id", models.BigIntegerField(primary_key=True, serialize=False)),
                (
                    "enter_reinforcement",
                    models.DateTimeField(help_text="Timer when the den was reinforced"),
                ),
                (
                    "exit_reinforcement",
                    models.DateTimeField(
                        help_text="Timer when the den will leave reinforcement"
                    ),
                ),
                (
                    "den",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="dens.mercenaryden",
                    ),
                ),
                (
                    "reinforced_by",
                    models.ForeignKey(
                        help_text="Character that reinforced the Mercenary Den",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveonline.evecharacter",
                    ),
                ),
            ],
        ),
    ]
