# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/006_data.validation.ipynb (unless otherwise specified).

__all__ = ['TrainValTestSplitter', 'get_splits', 'check_overlap', 'leakage_finder']

# Cell
from ..imports import *

# Cell
from sklearn.model_selection import train_test_split

# Cell
def TrainValTestSplitter(valid_size=0.2, test_size=0.2, random_state=None, stratify=None, **kwargs):
    "Split `items` into random train, valid and test subsets using sklearn train_test_split utility."
    valid_size = valid_size / (1 - test_size)
    stratify1 = None if stratify is None else stratify
    def _inner(o, **kwargs):
        train_valid, test = train_test_split(range(len(o)), test_size=test_size, random_state=random_state, stratify=stratify1, **kwargs)
        stratify2 = None if stratify1 is None else stratify1[train_valid]
        train, valid = train_test_split(range(len(train_valid)), test_size=valid_size, random_state=random_state, stratify=stratify2, **kwargs)
        return L(L(train_valid)[train]), L(L(train_valid)[valid]), L(test)
    return _inner

def get_splits(y, valid_size=0.2, test_size=0.2, stratify=True, merge_train_valid=False, merge_train_test=False, train_perc=None,
               random_state=None, **kwargs):
    if test_size == 0: splits = L(TrainTestSplitter(test_size=valid_size, random_state=random_state, stratify=y if stratify else None)(y))
    else: splits = L(TrainValTestSplitter(valid_size=valid_size, test_size=test_size, random_state=random_state, stratify=y if stratify else None)(y))
    if merge_train_valid: splits[0] = concat(splits[0], splits[1])
    if merge_train_test: splits[0] = concat(splits[0], splits[2])
    if train_perc: splits[0] = L(np.random.choice(len(train), int(len(train) * train_perc), False))
    leakage_finder(*splits)
    return splits

def check_overlap(a, b):
    overlap = L([i for i in a if i in b])
    if overlap == []: return
    return overlap

def leakage_finder(train, val, test=None):
    if check_overlap(train, val) is not None:
        print('train-val leakage!')
        print(check_overlap(train, val), '\n')
    if test is not None:
        if check_overlap(train, test) is not None:
            print('train-test leakage!')
            print(check_overlap(train, test), '\n')
        if check_overlap(val, test) is not None:
            print('val-test leakage!')
            print(check_overlap(val, test), '\n')