import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PipelineScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The activation of pipeline schedule. If false is set, the pipeline schedule will deactivated initially.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/pipeline_schedule#active PipelineSchedule#active}
    */
    readonly active?: boolean | cdktf.IResolvable;
    /**
    * The cron (e.g. `0 1 * * *`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/pipeline_schedule#cron PipelineSchedule#cron}
    */
    readonly cron: string;
    /**
    * The timezone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/pipeline_schedule#cron_timezone PipelineSchedule#cron_timezone}
    */
    readonly cronTimezone?: string;
    /**
    * The description of the pipeline schedule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/pipeline_schedule#description PipelineSchedule#description}
    */
    readonly description: string;
    /**
    * The name or id of the project to add the schedule to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/pipeline_schedule#project PipelineSchedule#project}
    */
    readonly project: string;
    /**
    * The branch/tag name to be triggered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/pipeline_schedule#ref PipelineSchedule#ref}
    */
    readonly ref: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/pipeline_schedule gitlab_pipeline_schedule}
*/
export declare class PipelineSchedule extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_pipeline_schedule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/pipeline_schedule gitlab_pipeline_schedule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PipelineScheduleConfig
    */
    constructor(scope: Construct, id: string, config: PipelineScheduleConfig);
    private _active?;
    get active(): boolean | cdktf.IResolvable;
    set active(value: boolean | cdktf.IResolvable);
    resetActive(): void;
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    private _cron?;
    get cron(): string;
    set cron(value: string);
    get cronInput(): string | undefined;
    private _cronTimezone?;
    get cronTimezone(): string;
    set cronTimezone(value: string);
    resetCronTimezone(): void;
    get cronTimezoneInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    get id(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _ref?;
    get ref(): string;
    set ref(value: string);
    get refInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=pipeline-schedule.d.ts.map