# coding: utf-8

"""
    VPlex REST API

    A defnition for the next-gen VPlex API  # noqa: E501

    OpenAPI spec version: 0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vplexapi.api_client import ApiClient


class DistributedStorageApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_distributed_consistency_group(self, distributed_consistency_group_payload, **kwargs):  # noqa: E501
        """Create a new distributed ConsistencyGroup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_distributed_consistency_group(distributed_consistency_group_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param DistributedConsistencyGroupPayload distributed_consistency_group_payload: (required)
        :param str x_include_object: When passed as part of a POST request, controls whether the representation of the newly created object is included in the response. Defaults to 'true' which will include the object in the response. This header is useful because refreshing the newly created object is usually the slowest part of a POST operation. 
        :return: ConsistencyGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_distributed_consistency_group_with_http_info(distributed_consistency_group_payload, **kwargs)  # noqa: E501
        else:
            (data) = self.create_distributed_consistency_group_with_http_info(distributed_consistency_group_payload, **kwargs)  # noqa: E501
            return data

    def create_distributed_consistency_group_with_http_info(self, distributed_consistency_group_payload, **kwargs):  # noqa: E501
        """Create a new distributed ConsistencyGroup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_distributed_consistency_group_with_http_info(distributed_consistency_group_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param DistributedConsistencyGroupPayload distributed_consistency_group_payload: (required)
        :param str x_include_object: When passed as part of a POST request, controls whether the representation of the newly created object is included in the response. Defaults to 'true' which will include the object in the response. This header is useful because refreshing the newly created object is usually the slowest part of a POST operation. 
        :return: ConsistencyGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['distributed_consistency_group_payload', 'x_include_object']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_distributed_consistency_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'distributed_consistency_group_payload' is set
        if ('distributed_consistency_group_payload' not in params or
                params['distributed_consistency_group_payload'] is None):
            raise ValueError("Missing the required parameter `distributed_consistency_group_payload` when calling `create_distributed_consistency_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_include_object' in params:
            header_params['X-Include-Object'] = params['x_include_object']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'distributed_consistency_group_payload' in params:
            body_params = params['distributed_consistency_group_payload']
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_consistency_groups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConsistencyGroup',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_distributed_device(self, distributed_device_payload, **kwargs):  # noqa: E501
        """Create a new DistributedDevice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_distributed_device(distributed_device_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param DistributedDevicePayload distributed_device_payload: (required)
        :param str x_include_object: When passed as part of a POST request, controls whether the representation of the newly created object is included in the response. Defaults to 'true' which will include the object in the response. This header is useful because refreshing the newly created object is usually the slowest part of a POST operation. 
        :return: DistributedDevice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_distributed_device_with_http_info(distributed_device_payload, **kwargs)  # noqa: E501
        else:
            (data) = self.create_distributed_device_with_http_info(distributed_device_payload, **kwargs)  # noqa: E501
            return data

    def create_distributed_device_with_http_info(self, distributed_device_payload, **kwargs):  # noqa: E501
        """Create a new DistributedDevice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_distributed_device_with_http_info(distributed_device_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param DistributedDevicePayload distributed_device_payload: (required)
        :param str x_include_object: When passed as part of a POST request, controls whether the representation of the newly created object is included in the response. Defaults to 'true' which will include the object in the response. This header is useful because refreshing the newly created object is usually the slowest part of a POST operation. 
        :return: DistributedDevice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['distributed_device_payload', 'x_include_object']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_distributed_device" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'distributed_device_payload' is set
        if ('distributed_device_payload' not in params or
                params['distributed_device_payload'] is None):
            raise ValueError("Missing the required parameter `distributed_device_payload` when calling `create_distributed_device`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_include_object' in params:
            header_params['X-Include-Object'] = params['x_include_object']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'distributed_device_payload' in params:
            body_params = params['distributed_device_payload']
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_devices', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DistributedDevice',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_distributed_virtual_volume(self, distributed_virtual_volume_payload, **kwargs):  # noqa: E501
        """Create a new distributed VirtualVolume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_distributed_virtual_volume(distributed_virtual_volume_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param DistributedVirtualVolumePayload distributed_virtual_volume_payload: (required)
        :param str x_include_object: When passed as part of a POST request, controls whether the representation of the newly created object is included in the response. Defaults to 'true' which will include the object in the response. This header is useful because refreshing the newly created object is usually the slowest part of a POST operation. 
        :return: VirtualVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_distributed_virtual_volume_with_http_info(distributed_virtual_volume_payload, **kwargs)  # noqa: E501
        else:
            (data) = self.create_distributed_virtual_volume_with_http_info(distributed_virtual_volume_payload, **kwargs)  # noqa: E501
            return data

    def create_distributed_virtual_volume_with_http_info(self, distributed_virtual_volume_payload, **kwargs):  # noqa: E501
        """Create a new distributed VirtualVolume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_distributed_virtual_volume_with_http_info(distributed_virtual_volume_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param DistributedVirtualVolumePayload distributed_virtual_volume_payload: (required)
        :param str x_include_object: When passed as part of a POST request, controls whether the representation of the newly created object is included in the response. Defaults to 'true' which will include the object in the response. This header is useful because refreshing the newly created object is usually the slowest part of a POST operation. 
        :return: VirtualVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['distributed_virtual_volume_payload', 'x_include_object']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_distributed_virtual_volume" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'distributed_virtual_volume_payload' is set
        if ('distributed_virtual_volume_payload' not in params or
                params['distributed_virtual_volume_payload'] is None):
            raise ValueError("Missing the required parameter `distributed_virtual_volume_payload` when calling `create_distributed_virtual_volume`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_include_object' in params:
            header_params['X-Include-Object'] = params['x_include_object']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'distributed_virtual_volume_payload' in params:
            body_params = params['distributed_virtual_volume_payload']
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_virtual_volumes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VirtualVolume',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_distributed_consistency_group(self, name, **kwargs):  # noqa: E501
        """Deletes a single distributed ConsistencyGroup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_distributed_consistency_group(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_distributed_consistency_group_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_distributed_consistency_group_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def delete_distributed_consistency_group_with_http_info(self, name, **kwargs):  # noqa: E501
        """Deletes a single distributed ConsistencyGroup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_distributed_consistency_group_with_http_info(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_distributed_consistency_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_distributed_consistency_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_consistency_groups/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_distributed_device(self, name, **kwargs):  # noqa: E501
        """Deletes a single DistributedDevice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_distributed_device(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_distributed_device_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_distributed_device_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def delete_distributed_device_with_http_info(self, name, **kwargs):  # noqa: E501
        """Deletes a single DistributedDevice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_distributed_device_with_http_info(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_distributed_device" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_distributed_device`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_devices/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_distributed_virtual_volume(self, name, **kwargs):  # noqa: E501
        """Deletes a single distributed VirtualVolume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_distributed_virtual_volume(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_distributed_virtual_volume_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_distributed_virtual_volume_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def delete_distributed_virtual_volume_with_http_info(self, name, **kwargs):  # noqa: E501
        """Deletes a single distributed VirtualVolume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_distributed_virtual_volume_with_http_info(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_distributed_virtual_volume" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_distributed_virtual_volume`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_virtual_volumes/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def expand_distributed_virtual_volume(self, name, distributed_virtual_volume_expand_payload, **kwargs):  # noqa: E501
        """Expand the capacity of a distributed VirtualVolume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.expand_distributed_virtual_volume(name, distributed_virtual_volume_expand_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param DistributedVirtualVolumeExpandPayload distributed_virtual_volume_expand_payload: (required)
        :return: VirtualVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.expand_distributed_virtual_volume_with_http_info(name, distributed_virtual_volume_expand_payload, **kwargs)  # noqa: E501
        else:
            (data) = self.expand_distributed_virtual_volume_with_http_info(name, distributed_virtual_volume_expand_payload, **kwargs)  # noqa: E501
            return data

    def expand_distributed_virtual_volume_with_http_info(self, name, distributed_virtual_volume_expand_payload, **kwargs):  # noqa: E501
        """Expand the capacity of a distributed VirtualVolume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.expand_distributed_virtual_volume_with_http_info(name, distributed_virtual_volume_expand_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param DistributedVirtualVolumeExpandPayload distributed_virtual_volume_expand_payload: (required)
        :return: VirtualVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'distributed_virtual_volume_expand_payload']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method expand_distributed_virtual_volume" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `expand_distributed_virtual_volume`")  # noqa: E501
        # verify the required parameter 'distributed_virtual_volume_expand_payload' is set
        if ('distributed_virtual_volume_expand_payload' not in params or
                params['distributed_virtual_volume_expand_payload'] is None):
            raise ValueError("Missing the required parameter `distributed_virtual_volume_expand_payload` when calling `expand_distributed_virtual_volume`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'distributed_virtual_volume_expand_payload' in params:
            body_params = params['distributed_virtual_volume_expand_payload']
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_virtual_volumes/{name}/expand', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VirtualVolume',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_distributed_consistency_group(self, name, **kwargs):  # noqa: E501
        """Returns a single distributed ConsistencyGroup object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_distributed_consistency_group(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: ConsistencyGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_distributed_consistency_group_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_distributed_consistency_group_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_distributed_consistency_group_with_http_info(self, name, **kwargs):  # noqa: E501
        """Returns a single distributed ConsistencyGroup object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_distributed_consistency_group_with_http_info(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: ConsistencyGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_distributed_consistency_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_distributed_consistency_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_consistency_groups/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConsistencyGroup',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_distributed_consistency_groups(self, **kwargs):  # noqa: E501
        """Returns a list of distributed ConsistencyGroups  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_distributed_consistency_groups(async=True)
        >>> result = thread.get()

        :param async bool
        :param int offset: Index of the first element to include in paginated results.<br> <b>'limit' must also be specified.</b>
        :param int limit: <p>Maximum number of elements to include in paginated results.<br> <b>'offset' must also be specified.<b>
        :param str name: Filter results by name. See LexicalQueryExpression for details.
        :param str operational_status: Filter results by operational_status. See LexicalQueryExpression for details.
        :param str sort_by: Specify the field priority order and direction for sorting.  See SortingOrderExpression for details. 
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :return: list[ConsistencyGroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_distributed_consistency_groups_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_distributed_consistency_groups_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_distributed_consistency_groups_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a list of distributed ConsistencyGroups  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_distributed_consistency_groups_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int offset: Index of the first element to include in paginated results.<br> <b>'limit' must also be specified.</b>
        :param int limit: <p>Maximum number of elements to include in paginated results.<br> <b>'offset' must also be specified.<b>
        :param str name: Filter results by name. See LexicalQueryExpression for details.
        :param str operational_status: Filter results by operational_status. See LexicalQueryExpression for details.
        :param str sort_by: Specify the field priority order and direction for sorting.  See SortingOrderExpression for details. 
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :return: list[ConsistencyGroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'name', 'operational_status', 'sort_by', 'fields']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_distributed_consistency_groups" % key
                )
            params[key] = val
        del params['kwargs']

        if 'offset' in params and params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_distributed_consistency_groups`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_distributed_consistency_groups`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_distributed_consistency_groups`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'operational_status' in params:
            query_params.append(('operational_status', params['operational_status']))  # noqa: E501
        if 'sort_by' in params:
            query_params.append(('sort_by', params['sort_by']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_consistency_groups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ConsistencyGroup]',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_distributed_device(self, name, **kwargs):  # noqa: E501
        """Returns a single DistributedDevice object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_distributed_device(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :return: DistributedDevice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_distributed_device_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_distributed_device_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_distributed_device_with_http_info(self, name, **kwargs):  # noqa: E501
        """Returns a single DistributedDevice object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_distributed_device_with_http_info(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :return: DistributedDevice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'fields']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_distributed_device" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_distributed_device`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_devices/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DistributedDevice',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_distributed_devices(self, **kwargs):  # noqa: E501
        """Returns a list of DistributedDevices  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_distributed_devices(async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: Filter results by name. See LexicalQueryExpression for details.
        :param str capacity: Filter results by capacity.  See NumericQueryExpression for details.
        :param str thin_capable: Filter results by thin_capable.  See LexicalQueryExpression for details.
        :param str health_state: Filter results by health_state. See LexicalQueryExpression for details.
        :param str operational_status: Filter results by operational_status. See LexicalQueryExpression for details.
        :param int offset: Index of the first element to include in paginated results.<br> <b>'limit' must also be specified.</b>
        :param int limit: <p>Maximum number of elements to include in paginated results.<br> <b>'offset' must also be specified.<b>
        :param str sort_by: Specify the field priority order and direction for sorting.  See SortingOrderExpression for details. 
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :return: list[DistributedDevice]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_distributed_devices_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_distributed_devices_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_distributed_devices_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a list of DistributedDevices  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_distributed_devices_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: Filter results by name. See LexicalQueryExpression for details.
        :param str capacity: Filter results by capacity.  See NumericQueryExpression for details.
        :param str thin_capable: Filter results by thin_capable.  See LexicalQueryExpression for details.
        :param str health_state: Filter results by health_state. See LexicalQueryExpression for details.
        :param str operational_status: Filter results by operational_status. See LexicalQueryExpression for details.
        :param int offset: Index of the first element to include in paginated results.<br> <b>'limit' must also be specified.</b>
        :param int limit: <p>Maximum number of elements to include in paginated results.<br> <b>'offset' must also be specified.<b>
        :param str sort_by: Specify the field priority order and direction for sorting.  See SortingOrderExpression for details. 
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :return: list[DistributedDevice]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'capacity', 'thin_capable', 'health_state', 'operational_status', 'offset', 'limit', 'sort_by', 'fields']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_distributed_devices" % key
                )
            params[key] = val
        del params['kwargs']

        if 'offset' in params and params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_distributed_devices`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_distributed_devices`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_distributed_devices`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'capacity' in params:
            query_params.append(('capacity', params['capacity']))  # noqa: E501
        if 'thin_capable' in params:
            query_params.append(('thin_capable', params['thin_capable']))  # noqa: E501
        if 'health_state' in params:
            query_params.append(('health_state', params['health_state']))  # noqa: E501
        if 'operational_status' in params:
            query_params.append(('operational_status', params['operational_status']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'sort_by' in params:
            query_params.append(('sort_by', params['sort_by']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_devices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DistributedDevice]',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_distributed_virtual_volume(self, name, **kwargs):  # noqa: E501
        """Returns a single distributed VirtualVolume object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_distributed_virtual_volume(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: VirtualVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_distributed_virtual_volume_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_distributed_virtual_volume_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_distributed_virtual_volume_with_http_info(self, name, **kwargs):  # noqa: E501
        """Returns a single distributed VirtualVolume object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_distributed_virtual_volume_with_http_info(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: VirtualVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_distributed_virtual_volume" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_distributed_virtual_volume`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_virtual_volumes/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VirtualVolume',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_distributed_virtual_volumes(self, **kwargs):  # noqa: E501
        """Returns a list of distributed VirtualVolumes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_distributed_virtual_volumes(async=True)
        >>> result = thread.get()

        :param async bool
        :param int offset: Index of the first element to include in paginated results.<br> <b>'limit' must also be specified.</b>
        :param int limit: <p>Maximum number of elements to include in paginated results.<br> <b>'offset' must also be specified.<b>
        :param str name: Filter results by name. See LexicalQueryExpression for details.
        :param str capacity: Filter results by capacity.  See NumericQueryExpression for details.
        :param str sort_by: Specify the field priority order and direction for sorting.  See SortingOrderExpression for details. 
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :param str consistency_group: Filter results by consistency_group. See LexicalQueryExpression for details.
        :param str health_state: Filter results by health_state. See LexicalQueryExpression for details.
        :param str operational_status: Filter results by operational_status. See LexicalQueryExpression for details.
        :param str service_status: Filter results by service_status. See LexicalQueryExpression for details.
        :param str thin_enabled: Filter results by thin_enabled. See LexicalQueryExpression for details.
        :return: list[VirtualVolume]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_distributed_virtual_volumes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_distributed_virtual_volumes_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_distributed_virtual_volumes_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a list of distributed VirtualVolumes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_distributed_virtual_volumes_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int offset: Index of the first element to include in paginated results.<br> <b>'limit' must also be specified.</b>
        :param int limit: <p>Maximum number of elements to include in paginated results.<br> <b>'offset' must also be specified.<b>
        :param str name: Filter results by name. See LexicalQueryExpression for details.
        :param str capacity: Filter results by capacity.  See NumericQueryExpression for details.
        :param str sort_by: Specify the field priority order and direction for sorting.  See SortingOrderExpression for details. 
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :param str consistency_group: Filter results by consistency_group. See LexicalQueryExpression for details.
        :param str health_state: Filter results by health_state. See LexicalQueryExpression for details.
        :param str operational_status: Filter results by operational_status. See LexicalQueryExpression for details.
        :param str service_status: Filter results by service_status. See LexicalQueryExpression for details.
        :param str thin_enabled: Filter results by thin_enabled. See LexicalQueryExpression for details.
        :return: list[VirtualVolume]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'name', 'capacity', 'sort_by', 'fields', 'consistency_group', 'health_state', 'operational_status', 'service_status', 'thin_enabled']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_distributed_virtual_volumes" % key
                )
            params[key] = val
        del params['kwargs']

        if 'offset' in params and params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_distributed_virtual_volumes`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_distributed_virtual_volumes`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_distributed_virtual_volumes`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'capacity' in params:
            query_params.append(('capacity', params['capacity']))  # noqa: E501
        if 'sort_by' in params:
            query_params.append(('sort_by', params['sort_by']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'consistency_group' in params:
            query_params.append(('consistency_group', params['consistency_group']))  # noqa: E501
        if 'health_state' in params:
            query_params.append(('health_state', params['health_state']))  # noqa: E501
        if 'operational_status' in params:
            query_params.append(('operational_status', params['operational_status']))  # noqa: E501
        if 'service_status' in params:
            query_params.append(('service_status', params['service_status']))  # noqa: E501
        if 'thin_enabled' in params:
            query_params.append(('thin_enabled', params['thin_enabled']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_virtual_volumes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[VirtualVolume]',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rule_set(self, name, **kwargs):  # noqa: E501
        """Returns a single RuleSet object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_rule_set(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: RuleSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_rule_set_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rule_set_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_rule_set_with_http_info(self, name, **kwargs):  # noqa: E501
        """Returns a single RuleSet object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_rule_set_with_http_info(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: RuleSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rule_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_rule_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/rule_sets/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleSet',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rule_sets(self, **kwargs):  # noqa: E501
        """Returns a list of RuleSets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_rule_sets(async=True)
        >>> result = thread.get()

        :param async bool
        :param int offset: Index of the first element to include in paginated results.<br> <b>'limit' must also be specified.</b>
        :param int limit: <p>Maximum number of elements to include in paginated results.<br> <b>'offset' must also be specified.<b>
        :param str name: Filter results by name. See LexicalQueryExpression for details.
        :return: list[RuleSet]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_rule_sets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_rule_sets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_rule_sets_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a list of RuleSets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_rule_sets_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int offset: Index of the first element to include in paginated results.<br> <b>'limit' must also be specified.</b>
        :param int limit: <p>Maximum number of elements to include in paginated results.<br> <b>'offset' must also be specified.<b>
        :param str name: Filter results by name. See LexicalQueryExpression for details.
        :return: list[RuleSet]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'name']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rule_sets" % key
                )
            params[key] = val
        del params['kwargs']

        if 'offset' in params and params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_rule_sets`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_rule_sets`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_rule_sets`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/rule_sets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RuleSet]',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_distributed_consistency_group(self, name, distributed_consistency_group_patch_payload, **kwargs):  # noqa: E501
        """Update attributes on a distributed ConsistencyGroup  # noqa: E501

        Patchable attributes are 'storage_at_clusters' (add/remove), 'virtual_volumes' (add/remove), 'visibility' (add/remove), 'name', 'recoverpoint_enabled', 'auto_resume_at_loser' and 'detach_rule'   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.patch_distributed_consistency_group(name, distributed_consistency_group_patch_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param list[JsonPatchOp] distributed_consistency_group_patch_payload: (required)
        :return: ConsistencyGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.patch_distributed_consistency_group_with_http_info(name, distributed_consistency_group_patch_payload, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_distributed_consistency_group_with_http_info(name, distributed_consistency_group_patch_payload, **kwargs)  # noqa: E501
            return data

    def patch_distributed_consistency_group_with_http_info(self, name, distributed_consistency_group_patch_payload, **kwargs):  # noqa: E501
        """Update attributes on a distributed ConsistencyGroup  # noqa: E501

        Patchable attributes are 'storage_at_clusters' (add/remove), 'virtual_volumes' (add/remove), 'visibility' (add/remove), 'name', 'recoverpoint_enabled', 'auto_resume_at_loser' and 'detach_rule'   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.patch_distributed_consistency_group_with_http_info(name, distributed_consistency_group_patch_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param list[JsonPatchOp] distributed_consistency_group_patch_payload: (required)
        :return: ConsistencyGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'distributed_consistency_group_patch_payload']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_distributed_consistency_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_distributed_consistency_group`")  # noqa: E501
        # verify the required parameter 'distributed_consistency_group_patch_payload' is set
        if ('distributed_consistency_group_patch_payload' not in params or
                params['distributed_consistency_group_patch_payload'] is None):
            raise ValueError("Missing the required parameter `distributed_consistency_group_patch_payload` when calling `patch_distributed_consistency_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'distributed_consistency_group_patch_payload' in params:
            body_params = params['distributed_consistency_group_patch_payload']
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_consistency_groups/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConsistencyGroup',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_distributed_device(self, name, distributed_device_patch_payload, **kwargs):  # noqa: E501
        """Update attributes on a DistributedDevice  # noqa: E501

        Settable attributes: 'name', 'legs', 'transfer_size', 'rule_set_name'   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.patch_distributed_device(name, distributed_device_patch_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param list[JsonPatchOp] distributed_device_patch_payload: (required)
        :return: DistributedDevice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.patch_distributed_device_with_http_info(name, distributed_device_patch_payload, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_distributed_device_with_http_info(name, distributed_device_patch_payload, **kwargs)  # noqa: E501
            return data

    def patch_distributed_device_with_http_info(self, name, distributed_device_patch_payload, **kwargs):  # noqa: E501
        """Update attributes on a DistributedDevice  # noqa: E501

        Settable attributes: 'name', 'legs', 'transfer_size', 'rule_set_name'   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.patch_distributed_device_with_http_info(name, distributed_device_patch_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param list[JsonPatchOp] distributed_device_patch_payload: (required)
        :return: DistributedDevice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'distributed_device_patch_payload']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_distributed_device" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_distributed_device`")  # noqa: E501
        # verify the required parameter 'distributed_device_patch_payload' is set
        if ('distributed_device_patch_payload' not in params or
                params['distributed_device_patch_payload'] is None):
            raise ValueError("Missing the required parameter `distributed_device_patch_payload` when calling `patch_distributed_device`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'distributed_device_patch_payload' in params:
            body_params = params['distributed_device_patch_payload']
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_devices/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DistributedDevice',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_distributed_virtual_volume(self, name, distributed_virtual_volume_patch_payload, **kwargs):  # noqa: E501
        """Update attributes on a distributed VirtualVolume  # noqa: E501

        Settable attributes: 'name'   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.patch_distributed_virtual_volume(name, distributed_virtual_volume_patch_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param list[JsonPatchOp] distributed_virtual_volume_patch_payload: (required)
        :return: VirtualVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.patch_distributed_virtual_volume_with_http_info(name, distributed_virtual_volume_patch_payload, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_distributed_virtual_volume_with_http_info(name, distributed_virtual_volume_patch_payload, **kwargs)  # noqa: E501
            return data

    def patch_distributed_virtual_volume_with_http_info(self, name, distributed_virtual_volume_patch_payload, **kwargs):  # noqa: E501
        """Update attributes on a distributed VirtualVolume  # noqa: E501

        Settable attributes: 'name'   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.patch_distributed_virtual_volume_with_http_info(name, distributed_virtual_volume_patch_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param list[JsonPatchOp] distributed_virtual_volume_patch_payload: (required)
        :return: VirtualVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'distributed_virtual_volume_patch_payload']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_distributed_virtual_volume" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_distributed_virtual_volume`")  # noqa: E501
        # verify the required parameter 'distributed_virtual_volume_patch_payload' is set
        if ('distributed_virtual_volume_patch_payload' not in params or
                params['distributed_virtual_volume_patch_payload'] is None):
            raise ValueError("Missing the required parameter `distributed_virtual_volume_patch_payload` when calling `patch_distributed_virtual_volume`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'distributed_virtual_volume_patch_payload' in params:
            body_params = params['distributed_virtual_volume_patch_payload']
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_virtual_volumes/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VirtualVolume',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resume(self, name, cg_resume_payload, **kwargs):  # noqa: E501
        """Manually resume I/O to the virtual-volumes in a distributed consistency group.  In a cluster-partition scenario where the ruleset does not indicate an automatic winner, this endpoint will select the winning cluster where I/O should continue.  After a cluster-partition is resolved, in the case that auto-resume-at-loser is set to false, this endpoint will resume I/O on the losing cluster.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.resume(name, cg_resume_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param CgResumePayload cg_resume_payload: (required)
        :return: ConsistencyGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.resume_with_http_info(name, cg_resume_payload, **kwargs)  # noqa: E501
        else:
            (data) = self.resume_with_http_info(name, cg_resume_payload, **kwargs)  # noqa: E501
            return data

    def resume_with_http_info(self, name, cg_resume_payload, **kwargs):  # noqa: E501
        """Manually resume I/O to the virtual-volumes in a distributed consistency group.  In a cluster-partition scenario where the ruleset does not indicate an automatic winner, this endpoint will select the winning cluster where I/O should continue.  After a cluster-partition is resolved, in the case that auto-resume-at-loser is set to false, this endpoint will resume I/O on the losing cluster.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.resume_with_http_info(name, cg_resume_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param CgResumePayload cg_resume_payload: (required)
        :return: ConsistencyGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'cg_resume_payload']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resume" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `resume`")  # noqa: E501
        # verify the required parameter 'cg_resume_payload' is set
        if ('cg_resume_payload' not in params or
                params['cg_resume_payload'] is None):
            raise ValueError("Missing the required parameter `cg_resume_payload` when calling `resume`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cg_resume_payload' in params:
            body_params = params['cg_resume_payload']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_consistency_groups/{name}/resume', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConsistencyGroup',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resume_link_up(self, name, **kwargs):  # noqa: E501
        """Manually resume I/O to a distributed device that supports a distributed virtual-volume.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.resume_link_up(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: DistributedDevice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.resume_link_up_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.resume_link_up_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def resume_link_up_with_http_info(self, name, **kwargs):  # noqa: E501
        """Manually resume I/O to a distributed device that supports a distributed virtual-volume.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.resume_link_up_with_http_info(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: DistributedDevice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resume_link_up" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `resume_link_up`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/distributed_storage/distributed_devices/{name}/resume', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DistributedDevice',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
