# coding: utf-8

"""
    VPlex REST API

    A defnition for the next-gen VPlex API  # noqa: E501

    OpenAPI spec version: 0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vplexapi.api_client import ApiClient


class DataMigrationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_device_migration(self, device_migration_payload, **kwargs):  # noqa: E501
        """Create a new DeviceMigration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_device_migration(device_migration_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param DeviceMigrationPayload device_migration_payload: (required)
        :return: DeviceMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_device_migration_with_http_info(device_migration_payload, **kwargs)  # noqa: E501
        else:
            (data) = self.create_device_migration_with_http_info(device_migration_payload, **kwargs)  # noqa: E501
            return data

    def create_device_migration_with_http_info(self, device_migration_payload, **kwargs):  # noqa: E501
        """Create a new DeviceMigration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_device_migration_with_http_info(device_migration_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param DeviceMigrationPayload device_migration_payload: (required)
        :return: DeviceMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_migration_payload']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_device_migration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_migration_payload' is set
        if ('device_migration_payload' not in params or
                params['device_migration_payload'] is None):
            raise ValueError("Missing the required parameter `device_migration_payload` when calling `create_device_migration`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'device_migration_payload' in params:
            body_params = params['device_migration_payload']
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/data_migrations/device_migrations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeviceMigration',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_extent_migration(self, extent_migration_payload, **kwargs):  # noqa: E501
        """Create a new ExtentMigration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_extent_migration(extent_migration_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param ExtentMigrationPayload extent_migration_payload: (required)
        :return: ExtentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_extent_migration_with_http_info(extent_migration_payload, **kwargs)  # noqa: E501
        else:
            (data) = self.create_extent_migration_with_http_info(extent_migration_payload, **kwargs)  # noqa: E501
            return data

    def create_extent_migration_with_http_info(self, extent_migration_payload, **kwargs):  # noqa: E501
        """Create a new ExtentMigration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_extent_migration_with_http_info(extent_migration_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param ExtentMigrationPayload extent_migration_payload: (required)
        :return: ExtentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extent_migration_payload']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_extent_migration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extent_migration_payload' is set
        if ('extent_migration_payload' not in params or
                params['extent_migration_payload'] is None):
            raise ValueError("Missing the required parameter `extent_migration_payload` when calling `create_extent_migration`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'extent_migration_payload' in params:
            body_params = params['extent_migration_payload']
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/data_migrations/extent_migrations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExtentMigration',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_device_migration(self, name, **kwargs):  # noqa: E501
        """Deletes a single canceled or committed DeviceMigration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_device_migration(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_device_migration_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_device_migration_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def delete_device_migration_with_http_info(self, name, **kwargs):  # noqa: E501
        """Deletes a single canceled or committed DeviceMigration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_device_migration_with_http_info(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_device_migration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_device_migration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/data_migrations/device_migrations/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_extent_migration(self, name, **kwargs):  # noqa: E501
        """Deletes a single canceled or committed ExtentMigration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_extent_migration(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_extent_migration_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_extent_migration_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def delete_extent_migration_with_http_info(self, name, **kwargs):  # noqa: E501
        """Deletes a single canceled or committed ExtentMigration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_extent_migration_with_http_info(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_extent_migration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_extent_migration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/data_migrations/extent_migrations/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_migration(self, name, **kwargs):  # noqa: E501
        """Returns a single DeviceMigration object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_device_migration(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :return: DeviceMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_device_migration_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_migration_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_device_migration_with_http_info(self, name, **kwargs):  # noqa: E501
        """Returns a single DeviceMigration object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_device_migration_with_http_info(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :return: DeviceMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'fields']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_migration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_device_migration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/data_migrations/device_migrations/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeviceMigration',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_migrations(self, **kwargs):  # noqa: E501
        """Returns a list of device migrations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_device_migrations(async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: Filter results by name. See LexicalQueryExpression for details.
        :param str to_cluster: Filter results by to_cluster. See LexicalQueryExpression for details.
        :param str from_cluster: Filter results by from_cluster. See LexicalQueryExpression for details.
        :param int offset: Index of the first element to include in paginated results.<br> <b>'limit' must also be specified.</b>
        :param int limit: <p>Maximum number of elements to include in paginated results.<br> <b>'offset' must also be specified.<b>
        :param str sort_by: Specify the field priority order and direction for sorting.  See SortingOrderExpression for details. 
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :return: list[DeviceMigration]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_device_migrations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_device_migrations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_device_migrations_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a list of device migrations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_device_migrations_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: Filter results by name. See LexicalQueryExpression for details.
        :param str to_cluster: Filter results by to_cluster. See LexicalQueryExpression for details.
        :param str from_cluster: Filter results by from_cluster. See LexicalQueryExpression for details.
        :param int offset: Index of the first element to include in paginated results.<br> <b>'limit' must also be specified.</b>
        :param int limit: <p>Maximum number of elements to include in paginated results.<br> <b>'offset' must also be specified.<b>
        :param str sort_by: Specify the field priority order and direction for sorting.  See SortingOrderExpression for details. 
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :return: list[DeviceMigration]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'to_cluster', 'from_cluster', 'offset', 'limit', 'sort_by', 'fields']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_migrations" % key
                )
            params[key] = val
        del params['kwargs']

        if 'offset' in params and params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_device_migrations`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_device_migrations`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_device_migrations`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'to_cluster' in params:
            query_params.append(('to_cluster', params['to_cluster']))  # noqa: E501
        if 'from_cluster' in params:
            query_params.append(('from_cluster', params['from_cluster']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'sort_by' in params:
            query_params.append(('sort_by', params['sort_by']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/data_migrations/device_migrations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeviceMigration]',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_extent_migration(self, name, **kwargs):  # noqa: E501
        """Returns a single ExtentMigration object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_extent_migration(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :return: ExtentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_extent_migration_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_extent_migration_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_extent_migration_with_http_info(self, name, **kwargs):  # noqa: E501
        """Returns a single ExtentMigration object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_extent_migration_with_http_info(name, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :return: ExtentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'fields']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extent_migration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_extent_migration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/data_migrations/extent_migrations/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExtentMigration',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_extent_migrations(self, **kwargs):  # noqa: E501
        """Returns a list of extent migrations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_extent_migrations(async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: Filter results by name. See LexicalQueryExpression for details.
        :param str to_cluster: Filter results by to_cluster. See LexicalQueryExpression for details.
        :param str from_cluster: Filter results by from_cluster. See LexicalQueryExpression for details.
        :param int offset: Index of the first element to include in paginated results.<br> <b>'limit' must also be specified.</b>
        :param int limit: <p>Maximum number of elements to include in paginated results.<br> <b>'offset' must also be specified.<b>
        :param str sort_by: Specify the field priority order and direction for sorting.  See SortingOrderExpression for details. 
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :return: list[ExtentMigration]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_extent_migrations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_extent_migrations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_extent_migrations_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a list of extent migrations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_extent_migrations_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: Filter results by name. See LexicalQueryExpression for details.
        :param str to_cluster: Filter results by to_cluster. See LexicalQueryExpression for details.
        :param str from_cluster: Filter results by from_cluster. See LexicalQueryExpression for details.
        :param int offset: Index of the first element to include in paginated results.<br> <b>'limit' must also be specified.</b>
        :param int limit: <p>Maximum number of elements to include in paginated results.<br> <b>'offset' must also be specified.<b>
        :param str sort_by: Specify the field priority order and direction for sorting.  See SortingOrderExpression for details. 
        :param str fields: Select which fields are included in the response. 'name' is always included. See FieldSelectionExpression for details. 
        :return: list[ExtentMigration]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'to_cluster', 'from_cluster', 'offset', 'limit', 'sort_by', 'fields']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_extent_migrations" % key
                )
            params[key] = val
        del params['kwargs']

        if 'offset' in params and params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_extent_migrations`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_extent_migrations`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_extent_migrations`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'to_cluster' in params:
            query_params.append(('to_cluster', params['to_cluster']))  # noqa: E501
        if 'from_cluster' in params:
            query_params.append(('from_cluster', params['from_cluster']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'sort_by' in params:
            query_params.append(('sort_by', params['sort_by']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/data_migrations/extent_migrations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ExtentMigration]',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_device_migration(self, name, device_migration_patch_payload, **kwargs):  # noqa: E501
        """Update attributes on a DeviceMigration  # noqa: E501

        Settable attributes: 'name', 'transfer_size' and 'status'(replace)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.patch_device_migration(name, device_migration_patch_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param list[JsonPatchOp] device_migration_patch_payload: (required)
        :return: DeviceMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.patch_device_migration_with_http_info(name, device_migration_patch_payload, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_device_migration_with_http_info(name, device_migration_patch_payload, **kwargs)  # noqa: E501
            return data

    def patch_device_migration_with_http_info(self, name, device_migration_patch_payload, **kwargs):  # noqa: E501
        """Update attributes on a DeviceMigration  # noqa: E501

        Settable attributes: 'name', 'transfer_size' and 'status'(replace)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.patch_device_migration_with_http_info(name, device_migration_patch_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param list[JsonPatchOp] device_migration_patch_payload: (required)
        :return: DeviceMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'device_migration_patch_payload']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_device_migration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_device_migration`")  # noqa: E501
        # verify the required parameter 'device_migration_patch_payload' is set
        if ('device_migration_patch_payload' not in params or
                params['device_migration_patch_payload'] is None):
            raise ValueError("Missing the required parameter `device_migration_patch_payload` when calling `patch_device_migration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'device_migration_patch_payload' in params:
            body_params = params['device_migration_patch_payload']
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/data_migrations/device_migrations/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeviceMigration',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_extent_migration(self, name, extent_migration_patch_payload, **kwargs):  # noqa: E501
        """Update attributes on a ExtentMigration  # noqa: E501

        Settable attributes: 'name', 'transfer_size' and 'status'(replace)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.patch_extent_migration(name, extent_migration_patch_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param list[JsonPatchOp] extent_migration_patch_payload: (required)
        :return: ExtentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.patch_extent_migration_with_http_info(name, extent_migration_patch_payload, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_extent_migration_with_http_info(name, extent_migration_patch_payload, **kwargs)  # noqa: E501
            return data

    def patch_extent_migration_with_http_info(self, name, extent_migration_patch_payload, **kwargs):  # noqa: E501
        """Update attributes on a ExtentMigration  # noqa: E501

        Settable attributes: 'name', 'transfer_size' and 'status'(replace)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.patch_extent_migration_with_http_info(name, extent_migration_patch_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str name: The name of a specific instance of the resource (required)
        :param list[JsonPatchOp] extent_migration_patch_payload: (required)
        :return: ExtentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'extent_migration_patch_payload']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_extent_migration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_extent_migration`")  # noqa: E501
        # verify the required parameter 'extent_migration_patch_payload' is set
        if ('extent_migration_patch_payload' not in params or
                params['extent_migration_patch_payload'] is None):
            raise ValueError("Missing the required parameter `extent_migration_patch_payload` when calling `patch_extent_migration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'extent_migration_patch_payload' in params:
            body_params = params['extent_migration_patch_payload']
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/data_migrations/extent_migrations/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExtentMigration',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
