# coding: utf-8

"""
    VPlex REST API

    A defnition for the next-gen VPlex API  # noqa: E501

    OpenAPI spec version: 0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vplexapi.api_client import ApiClient


class CertificatesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_certificate(self, external_certificate, certificate_payload, **kwargs):  # noqa: E501
        """Add the certificate to the keystore.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.add_certificate(external_certificate, certificate_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str external_certificate: The IP:PORT of system associated with this certificate. (required)
        :param CertificatePayload certificate_payload: (required)
        :return: Certificate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.add_certificate_with_http_info(external_certificate, certificate_payload, **kwargs)  # noqa: E501
        else:
            (data) = self.add_certificate_with_http_info(external_certificate, certificate_payload, **kwargs)  # noqa: E501
            return data

    def add_certificate_with_http_info(self, external_certificate, certificate_payload, **kwargs):  # noqa: E501
        """Add the certificate to the keystore.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.add_certificate_with_http_info(external_certificate, certificate_payload, async=True)
        >>> result = thread.get()

        :param async bool
        :param str external_certificate: The IP:PORT of system associated with this certificate. (required)
        :param CertificatePayload certificate_payload: (required)
        :return: Certificate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_certificate', 'certificate_payload']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_certificate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'external_certificate' is set
        if ('external_certificate' not in params or
                params['external_certificate'] is None):
            raise ValueError("Missing the required parameter `external_certificate` when calling `add_certificate`")  # noqa: E501
        # verify the required parameter 'certificate_payload' is set
        if ('certificate_payload' not in params or
                params['certificate_payload'] is None):
            raise ValueError("Missing the required parameter `certificate_payload` when calling `add_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'external_certificate' in params:
            path_params['external_certificate'] = params['external_certificate']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'certificate_payload' in params:
            body_params = params['certificate_payload']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/external_certificates/trusted/{external_certificate}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Certificate',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def external_certificates_untrusted_external_certificate_get(self, external_certificate, **kwargs):  # noqa: E501
        """Fetches the SSL Certificate of an external system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.external_certificates_untrusted_external_certificate_get(external_certificate, async=True)
        >>> result = thread.get()

        :param async bool
        :param str external_certificate: The IP:PORT of system associated with this certificate. (required)
        :return: Certificate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.external_certificates_untrusted_external_certificate_get_with_http_info(external_certificate, **kwargs)  # noqa: E501
        else:
            (data) = self.external_certificates_untrusted_external_certificate_get_with_http_info(external_certificate, **kwargs)  # noqa: E501
            return data

    def external_certificates_untrusted_external_certificate_get_with_http_info(self, external_certificate, **kwargs):  # noqa: E501
        """Fetches the SSL Certificate of an external system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.external_certificates_untrusted_external_certificate_get_with_http_info(external_certificate, async=True)
        >>> result = thread.get()

        :param async bool
        :param str external_certificate: The IP:PORT of system associated with this certificate. (required)
        :return: Certificate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_certificate']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method external_certificates_untrusted_external_certificate_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'external_certificate' is set
        if ('external_certificate' not in params or
                params['external_certificate'] is None):
            raise ValueError("Missing the required parameter `external_certificate` when calling `external_certificates_untrusted_external_certificate_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'external_certificate' in params:
            path_params['external_certificate'] = params['external_certificate']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/external_certificates/untrusted/{external_certificate}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Certificate',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trusted_certificate(self, external_certificate, **kwargs):  # noqa: E501
        """Fetch the certificate from the keystore.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_trusted_certificate(external_certificate, async=True)
        >>> result = thread.get()

        :param async bool
        :param str external_certificate: The IP:PORT of system associated with this certificate. (required)
        :return: Certificate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_trusted_certificate_with_http_info(external_certificate, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trusted_certificate_with_http_info(external_certificate, **kwargs)  # noqa: E501
            return data

    def get_trusted_certificate_with_http_info(self, external_certificate, **kwargs):  # noqa: E501
        """Fetch the certificate from the keystore.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_trusted_certificate_with_http_info(external_certificate, async=True)
        >>> result = thread.get()

        :param async bool
        :param str external_certificate: The IP:PORT of system associated with this certificate. (required)
        :return: Certificate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_certificate']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trusted_certificate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'external_certificate' is set
        if ('external_certificate' not in params or
                params['external_certificate'] is None):
            raise ValueError("Missing the required parameter `external_certificate` when calling `get_trusted_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'external_certificate' in params:
            path_params['external_certificate'] = params['external_certificate']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/external_certificates/trusted/{external_certificate}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Certificate',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_certificate(self, external_certificate, **kwargs):  # noqa: E501
        """Remove the certificate from the keystore.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.remove_certificate(external_certificate, async=True)
        >>> result = thread.get()

        :param async bool
        :param str external_certificate: The IP:PORT of system associated with this certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.remove_certificate_with_http_info(external_certificate, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_certificate_with_http_info(external_certificate, **kwargs)  # noqa: E501
            return data

    def remove_certificate_with_http_info(self, external_certificate, **kwargs):  # noqa: E501
        """Remove the certificate from the keystore.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.remove_certificate_with_http_info(external_certificate, async=True)
        >>> result = thread.get()

        :param async bool
        :param str external_certificate: The IP:PORT of system associated with this certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_certificate']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_certificate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'external_certificate' is set
        if ('external_certificate' not in params or
                params['external_certificate'] is None):
            raise ValueError("Missing the required parameter `external_certificate` when calling `remove_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'external_certificate' in params:
            path_params['external_certificate'] = params['external_certificate']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'jwtAuth']  # noqa: E501

        return self.api_client.call_api(
            '/external_certificates/trusted/{external_certificate}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
