# Generated by Django 1.9.7 on 2016-07-14 12:23
from __future__ import unicode_literals

import autoslug.fields
import dartcms.utils.fields
import django.db.models.deletion
import django.db.models.manager
import mptt.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('description', dartcms.utils.fields.RteField(blank=True, default=b'', verbose_name='Description')),
                ('seo_keywords', models.TextField(blank=True, default=b'', verbose_name='Keywords (meta keywords)')),
                ('seo_description', models.TextField(blank=True, default=b'', verbose_name='Keywords (meta keywords)')),
                ('is_visible', models.BooleanField(default=True, verbose_name='Is Visible')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('slug', autoslug.fields.AutoSlugField(editable=False, populate_from=b'name', unique=True, verbose_name='URL')),
                ('code', models.CharField(blank=True, default=b'', max_length=100, verbose_name='Code')),
                ('short_description', dartcms.utils.fields.RteField(blank=True, default=b'', verbose_name='Short description')),
                ('residue', models.IntegerField(default=1, verbose_name='Residue')),
                ('price', models.DecimalField(decimal_places=2, default=0, max_digits=10, verbose_name='Price')),
                ('image', models.ImageField(blank=True, null=True, upload_to=b'shop/product/%Y/%m/%d', verbose_name='Image')),
            ],
            options={
                'ordering': ['name'],
                'abstract': False,
                'verbose_name': 'product',
                'verbose_name_plural': 'products',
            },
        ),
        migrations.CreateModel(
            name='ProductCatalog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('description', dartcms.utils.fields.RteField(blank=True, default=b'', verbose_name='Description')),
                ('seo_keywords', models.TextField(blank=True, default=b'', verbose_name='Keywords (meta keywords)')),
                ('seo_description', models.TextField(blank=True, default=b'', verbose_name='Keywords (meta keywords)')),
                ('is_visible', models.BooleanField(default=True, verbose_name='Is Visible')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('slug', models.SlugField(unique=True, verbose_name='URL')),
                ('image', models.ImageField(blank=True, null=True, upload_to=b'shop/catalog', verbose_name='Image')),
            ],
            options={
                'ordering': ['name'],
                'abstract': False,
                'verbose_name': 'product catalog',
                'verbose_name_plural': 'product catalogs',
            },
        ),
        migrations.CreateModel(
            name='ProductImage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(upload_to=b'shop/product_images/%Y/%m/%d', verbose_name='Image')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pictures', to='shop.Product', verbose_name='Product')),
            ],
            options={
                'ordering': ['-date_created'],
                'abstract': False,
                'verbose_name': 'product picture',
                'verbose_name_plural': 'product pictures',
            },
        ),
        migrations.CreateModel(
            name='ProductLabel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('description', dartcms.utils.fields.RteField(blank=True, default=b'', verbose_name='Description')),
                ('seo_keywords', models.TextField(blank=True, default=b'', verbose_name='Keywords (meta keywords)')),
                ('seo_description', models.TextField(blank=True, default=b'', verbose_name='Keywords (meta keywords)')),
                ('is_visible', models.BooleanField(default=True, verbose_name='Is Visible')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('slug', models.SlugField(unique=True, verbose_name='URL')),
                ('image', models.ImageField(blank=True, null=True, upload_to=b'shop/label', verbose_name='Image')),
            ],
            options={
                'ordering': ['name'],
                'abstract': False,
                'verbose_name': 'product label',
                'verbose_name_plural': 'product labels',
            },
        ),
        migrations.CreateModel(
            name='ProductSection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('description', dartcms.utils.fields.RteField(blank=True, default=b'', verbose_name='Description')),
                ('seo_keywords', models.TextField(blank=True, default=b'', verbose_name='Keywords (meta keywords)')),
                ('seo_description', models.TextField(blank=True, default=b'', verbose_name='Keywords (meta keywords)')),
                ('is_visible', models.BooleanField(default=True, verbose_name='Is Visible')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('slug', autoslug.fields.AutoSlugField(editable=False, populate_from=b'name', unique=True, verbose_name='URL')),
                ('image', models.ImageField(blank=True, null=True, upload_to=b'shop/section', verbose_name='Image')),
                ('sort', models.IntegerField(default=1)),
                ('lft', models.PositiveIntegerField(db_index=True, editable=False)),
                ('rght', models.PositiveIntegerField(db_index=True, editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(db_index=True, editable=False)),
                ('catalog', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='sections', to='shop.ProductCatalog', verbose_name='Product catalog')),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='shop.ProductSection', verbose_name='Parent Section')),
            ],
            options={
                'ordering': ['sort'],
                'abstract': False,
                'verbose_name': 'product section',
                'verbose_name_plural': 'product sections',
            },
            managers=[
                ('objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.AddField(
            model_name='product',
            name='labels',
            field=models.ManyToManyField(blank=True, related_name='label_products', to='shop.ProductLabel', verbose_name='Labels'),
        ),
        migrations.AddField(
            model_name='product',
            name='section',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='products', to='shop.ProductSection', verbose_name='Section'),
        ),
        migrations.AlterUniqueTogether(
            name='productsection',
            unique_together=set([('catalog', 'slug')]),
        ),
    ]
