# Generated by Django 1.9.6 on 2016-05-20 02:26
from __future__ import unicode_literals

from django.db import migrations
from django.utils import translation
from django.utils.translation import gettext_lazy as _

MODULE_GROUPS = [
    {
        'sort': 4,
        'description': '',
        'fa': 'fa-rocket',
        'slug': 'ads',
        'name': _('Advertising'),
        'modules': [
            {
                'sort': 1,
                'is_enabled': True,
                'name': _('Ad banners'),
                'slug': 'ad',
                'description': ''
            },
            {
                'sort': 2,
                'is_enabled': True,
                'name': _('Ad places'),
                'slug': 'adplace',
                'description': ''
            },
            {
                'sort': 3,
                'is_enabled': True,
                'name': _('Ad sections'),
                'slug': 'adsection',
                'description': ''
            }
        ]
    }
]


def insert_modules(apps, schema):
    from django.conf import settings
    translation.activate(settings.LANGUAGE_CODE)

    ModuleGroup = apps.get_model('modules', 'ModuleGroup')
    Module = apps.get_model('modules', 'Module')

    for group in MODULE_GROUPS:
        group_modules = group.pop('modules', [])
        group = ModuleGroup.objects.create(**group)
        for module in group_modules:
            module['group'] = group
            Module.objects.create(**module)

    translation.deactivate()


def delete_modules(apps, schema):
    ModuleGroup = apps.get_model('modules', 'ModuleGroup')

    for group in MODULE_GROUPS:
        ModuleGroup.objects.get(slug=group['slug']).delete()


class Migration(migrations.Migration):
    dependencies = [
        ('modules', '0004_insert_feedback_module'),
    ]

    operations = [
        migrations.RunPython(insert_modules, delete_modules)
    ]
