/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OCommonMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import ai.h2o.sparkling.ml.params.NullableDataFrameParam;
import com.google.gson.JsonObject;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all metrics that shared across all algorithms supporting binomial classification.")
@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u00015\u0011!\u0003\u0013\u001aP\u0005&tw.\\5bY6+GO]5dg*\u00111\u0001B\u0001\b[\u0016$(/[2t\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\ngB\f'o\u001b7j]\u001eT!!\u0003\u0006\u0002\u0007!\u0014tNC\u0001\f\u0003\t\t\u0017n\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005AA%gT\"p[6|g.T3ue&\u001c7\u000f\u0003\u0005\u0014\u0001\t\u0015\r\u0011\"\u0011\u0015\u0003\r)\u0018\u000eZ\u000b\u0002+A\u0011a\u0003\b\b\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004G\u0001\u0007!J,G-\u001a4\n\u0005uq\"AB*ue&twM\u0003\u0002\u001c1!A\u0001\u0005\u0001B\u0001B\u0003%Q#\u0001\u0003vS\u0012\u0004\u0003\"\u0002\u0012\u0001\t\u0003\u0019\u0013A\u0002\u001fj]&$h\b\u0006\u0002%KA\u0011q\u0002\u0001\u0005\u0006'\u0005\u0002\r!\u0006\u0005\u0006E\u0001!\ta\n\u000b\u0002I!9\u0011\u0006\u0001b\u0001\n#Q\u0013A\u0001:3+\u0005Y\u0003C\u0001\u00177\u001b\u0005i#B\u0001\u00180\u0003\u0015\u0001\u0018M]1n\u0015\t)\u0001G\u0003\u00022e\u0005)1\u000f]1sW*\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0013\t9TFA\u0006E_V\u0014G.\u001a)be\u0006l\u0007BB\u001d\u0001A\u0003%1&A\u0002se\u0001Bqa\u000f\u0001C\u0002\u0013E!&A\u0004m_\u001edwn]:\t\ru\u0002\u0001\u0015!\u0003,\u0003!awn\u001a7pgN\u0004\u0003bB \u0001\u0005\u0004%\tBK\u0001\u0004CV\u001c\u0007BB!\u0001A\u0003%1&\u0001\u0003bk\u000e\u0004\u0003bB\"\u0001\u0005\u0004%\tBK\u0001\u0006aJ\fWo\u0019\u0005\u0007\u000b\u0002\u0001\u000b\u0011B\u0016\u0002\rA\u0014\u0018-^2!\u0011\u001d9\u0005A1A\u0005\u0012)\nAaZ5oS\"1\u0011\n\u0001Q\u0001\n-\nQaZ5oS\u0002Bqa\u0013\u0001C\u0002\u0013E!&A\tnK\u0006t\u0007+\u001a:DY\u0006\u001c8/\u0012:s_JDa!\u0014\u0001!\u0002\u0013Y\u0013AE7fC:\u0004VM]\"mCN\u001cXI\u001d:pe\u0002Bqa\u0014\u0001C\u0002\u0013E\u0001+A\bd_:4Wo]5p]6\u000bGO]5y+\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+\u0005\u0003\u0019\u0001\u0018M]1ng&\u0011ak\u0015\u0002\u0017\u001dVdG.\u00192mK\u0012\u000bG/\u0019$sC6,\u0007+\u0019:b[\"1\u0001\f\u0001Q\u0001\nE\u000b\u0001cY8oMV\u001c\u0018n\u001c8NCR\u0014\u0018\u000e\u001f\u0011\t\u000fi\u0003!\u0019!C\t!\u0006IB\u000f\u001b:fg\"|G\u000eZ:B]\u0012lU\r\u001e:jGN\u001bwN]3t\u0011\u0019a\u0006\u0001)A\u0005#\u0006QB\u000f\u001b:fg\"|G\u000eZ:B]\u0012lU\r\u001e:jGN\u001bwN]3tA!9a\f\u0001b\u0001\n#\u0001\u0016AG7bq\u000e\u0013\u0018\u000e^3sS\u0006\fe\u000eZ'fiJL7mU2pe\u0016\u001c\bB\u00021\u0001A\u0003%\u0011+A\u000enCb\u001c%/\u001b;fe&\f\u0017I\u001c3NKR\u0014\u0018nY*d_J,7\u000f\t\u0005\bE\u0002\u0011\r\u0011\"\u0005Q\u000399\u0017-\u001b8t\u0019&4G\u000fV1cY\u0016Da\u0001\u001a\u0001!\u0002\u0013\t\u0016aD4bS:\u001cH*\u001b4u)\u0006\u0014G.\u001a\u0011\t\u000b\u0019\u0004A\u0011A4\u0002\u000b\u001d,GO\u0015\u001a\u0015\u0003!\u0004\"aF5\n\u0005)D\"A\u0002#pk\ndW\rC\u0003m\u0001\u0011\u0005q-\u0001\u0006hKRdun\u001a7pgNDQA\u001c\u0001\u0005\u0002\u001d\faaZ3u\u0003V\u001b\u0005\"\u00029\u0001\t\u00039\u0017\u0001C4fiB\u0013\u0016)V\"\t\u000bI\u0004A\u0011A4\u0002\u000f\u001d,GoR5oS\")A\u000f\u0001C\u0001O\u0006!r-\u001a;NK\u0006t\u0007+\u001a:DY\u0006\u001c8/\u0012:s_JDQA\u001e\u0001\u0005\u0002]\f!cZ3u\u0007>tg-^:j_:l\u0015\r\u001e:jqR\t\u0001\u0010E\u0002z\u0003'q1A_A\u0007\u001d\rY\u0018\u0011\u0002\b\u0004y\u0006\u001dabA?\u0002\u00069\u0019a0a\u0001\u000e\u0003}T1!!\u0001\r\u0003\u0019a$o\\8u}%\tQ'\u0003\u00024i%\u0011\u0011GM\u0005\u0004\u0003\u0017\u0001\u0014aA:rY&!\u0011qBA\t\u0003\u001d\u0001\u0018mY6bO\u0016T1!a\u00031\u0013\u0011\t)\"a\u0006\u0003\u0013\u0011\u000bG/\u0019$sC6,'\u0002BA\b\u0003#Aa!a\u0007\u0001\t\u00039\u0018\u0001H4fiRC'/Z:i_2$7/\u00118e\u001b\u0016$(/[2TG>\u0014Xm\u001d\u0005\u0007\u0003?\u0001A\u0011A<\u0002;\u001d,G/T1y\u0007JLG/\u001a:jC\u0006sG-T3ue&\u001c7kY8sKNDa!a\t\u0001\t\u00039\u0018!E4fi\u001e\u000b\u0017N\\:MS\u001a$H+\u00192mK\"9\u0011q\u0005\u0001\u0005B\u0005%\u0012AC:fi6+GO]5dgR1\u00111FA\u0019\u0003\u0013\u00022aFA\u0017\u0013\r\ty\u0003\u0007\u0002\u0005+:LG\u000f\u0003\u0005\u00024\u0005\u0015\u0002\u0019AA\u001b\u0003\u0011Q7o\u001c8\u0011\t\u0005]\u0012QI\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005!qm]8o\u0015\u0011\ty$!\u0011\u0002\r\u001d|wn\u001a7f\u0015\t\t\u0019%A\u0002d_6LA!a\u0012\u0002:\tQ!j]8o\u001f\nTWm\u0019;\t\u000f\u0005-\u0013Q\u0005a\u0001+\u000591m\u001c8uKb$\bbBA(\u0001\u0011\u0005\u0013\u0011K\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003\u0002T\u0005US\"\u0001\u0001\t\u0011\u0005]\u0013Q\na\u0001\u00033\nQ!\u001a=ue\u0006\u00042\u0001LA.\u0013\r\ti&\f\u0002\t!\u0006\u0014\u0018-\\'ba\":\u0001!!\u0019\u0002h\u0005%\u0004cA\b\u0002d%\u0019\u0011Q\r\u0002\u0003%5+GO]5dg\u0012+7o\u0019:jaRLwN\\\u0001\fI\u0016\u001c8M]5qi&|g.\t\u0002\u0002l\u0005YG\u000b[3!G2\f7o\u001d\u0011nC.,7\u000fI1wC&d\u0017M\u00197fA\u0005dG\u000eI7fiJL7m\u001d\u0011uQ\u0006$\be\u001d5be\u0016$\u0007%Y2s_N\u001c\b%\u00197mA\u0005dwm\u001c:ji\"l7\u000fI:vaB|'\u000f^5oO\u0002\u0012\u0017N\\8nS\u0006d\u0007e\u00197bgNLg-[2bi&|gN\f")
public class H2OBinomialMetrics
extends H2OCommonMetrics {
    private final String uid;
    private final DoubleParam r2;
    private final DoubleParam logloss;
    private final DoubleParam auc;
    private final DoubleParam prauc;
    private final DoubleParam gini;
    private final DoubleParam meanPerClassError;
    private final NullableDataFrameParam confusionMatrix;
    private final NullableDataFrameParam thresholdsAndMetricScores;
    private final NullableDataFrameParam maxCriteriaAndMetricScores;
    private final NullableDataFrameParam gainsLiftTable;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam r2() {
        return this.r2;
    }

    public DoubleParam logloss() {
        return this.logloss;
    }

    public DoubleParam auc() {
        return this.auc;
    }

    public DoubleParam prauc() {
        return this.prauc;
    }

    public DoubleParam gini() {
        return this.gini;
    }

    public DoubleParam meanPerClassError() {
        return this.meanPerClassError;
    }

    public NullableDataFrameParam confusionMatrix() {
        return this.confusionMatrix;
    }

    public NullableDataFrameParam thresholdsAndMetricScores() {
        return this.thresholdsAndMetricScores;
    }

    public NullableDataFrameParam maxCriteriaAndMetricScores() {
        return this.maxCriteriaAndMetricScores;
    }

    public NullableDataFrameParam gainsLiftTable() {
        return this.gainsLiftTable;
    }

    public double getR2() {
        return BoxesRunTime.unboxToDouble(this.$(this.r2()));
    }

    public double getLogloss() {
        return BoxesRunTime.unboxToDouble(this.$(this.logloss()));
    }

    public double getAUC() {
        return BoxesRunTime.unboxToDouble(this.$(this.auc()));
    }

    public double getPRAUC() {
        return BoxesRunTime.unboxToDouble(this.$(this.prauc()));
    }

    public double getGini() {
        return BoxesRunTime.unboxToDouble(this.$(this.gini()));
    }

    public double getMeanPerClassError() {
        return BoxesRunTime.unboxToDouble(this.$(this.meanPerClassError()));
    }

    public Dataset<Row> getConfusionMatrix() {
        return this.$(this.confusionMatrix());
    }

    public Dataset<Row> getThresholdsAndMetricScores() {
        return this.$(this.thresholdsAndMetricScores());
    }

    public Dataset<Row> getMaxCriteriaAndMetricScores() {
        return this.$(this.maxCriteriaAndMetricScores());
    }

    public Dataset<Row> getGainsLiftTable() {
        return this.$(this.gainsLiftTable());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setMetrics(JsonObject json, String context) {
        Params params;
        Params params2;
        Params params3;
        Params params4;
        Params params5;
        Params params6;
        Params params7;
        Params params8;
        Params params9;
        super.setMetrics(json, context);
        if (json.has("r2")) {
            try {
                params9 = this.set("r2", BoxesRunTime.boxToDouble((double)json.get("r2").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 == null) throw throwable;
                Throwable throwable3 = throwable2;
                String string = System.getProperty("spark.testing", "false");
                String string2 = "true";
                if (string == null) {
                    if (string2 == null) throw throwable;
                } else if (string.equals(string2)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'r2' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable3);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params9 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'r2' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string3 = "true";
            if (string == null) {
                if (string3 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string3)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            params9 = BoxedUnit.UNIT;
        }
        if (json.has("logloss")) {
            try {
                params8 = this.set("logloss", BoxesRunTime.boxToDouble((double)json.get("logloss").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable4 = throwable;
                if (throwable4 == null) throw throwable;
                Throwable throwable5 = throwable4;
                String string = System.getProperty("spark.testing", "false");
                String string4 = "true";
                if (string == null) {
                    if (string4 == null) throw throwable;
                } else if (string.equals(string4)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'logloss' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable5);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params8 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'logloss' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string5 = "true";
            if (string == null) {
                if (string5 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string5)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$2;

                public final String apply() {
                    return this.message$2;
                }
                {
                    this.message$2 = message$2;
                }
            });
            params8 = BoxedUnit.UNIT;
        }
        if (json.has("AUC")) {
            try {
                params7 = this.set("auc", BoxesRunTime.boxToDouble((double)json.get("AUC").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable6 = throwable;
                if (throwable6 == null) throw throwable;
                Throwable throwable7 = throwable6;
                String string = System.getProperty("spark.testing", "false");
                String string6 = "true";
                if (string == null) {
                    if (string6 == null) throw throwable;
                } else if (string.equals(string6)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'AUC' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable7);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params7 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'AUC' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string7 = "true";
            if (string == null) {
                if (string7 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string7)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$3;

                public final String apply() {
                    return this.message$3;
                }
                {
                    this.message$3 = message$3;
                }
            });
            params7 = BoxedUnit.UNIT;
        }
        if (json.has("pr_auc")) {
            try {
                params6 = this.set("prauc", BoxesRunTime.boxToDouble((double)json.get("pr_auc").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable8 = throwable;
                if (throwable8 == null) throw throwable;
                Throwable throwable9 = throwable8;
                String string = System.getProperty("spark.testing", "false");
                String string8 = "true";
                if (string == null) {
                    if (string8 == null) throw throwable;
                } else if (string.equals(string8)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'pr_auc' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable9);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params6 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'pr_auc' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string9 = "true";
            if (string == null) {
                if (string9 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string9)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$4;

                public final String apply() {
                    return this.message$4;
                }
                {
                    this.message$4 = message$4;
                }
            });
            params6 = BoxedUnit.UNIT;
        }
        if (json.has("Gini")) {
            try {
                params5 = this.set("gini", BoxesRunTime.boxToDouble((double)json.get("Gini").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable10 = throwable;
                if (throwable10 == null) throw throwable;
                Throwable throwable11 = throwable10;
                String string = System.getProperty("spark.testing", "false");
                String string10 = "true";
                if (string == null) {
                    if (string10 == null) throw throwable;
                } else if (string.equals(string10)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'Gini' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable11);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params5 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'Gini' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string11 = "true";
            if (string == null) {
                if (string11 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string11)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$5;

                public final String apply() {
                    return this.message$5;
                }
                {
                    this.message$5 = message$5;
                }
            });
            params5 = BoxedUnit.UNIT;
        }
        if (json.has("mean_per_class_error")) {
            try {
                params4 = this.set("meanPerClassError", BoxesRunTime.boxToDouble((double)json.get("mean_per_class_error").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable12 = throwable;
                if (throwable12 == null) throw throwable;
                Throwable throwable13 = throwable12;
                String string = System.getProperty("spark.testing", "false");
                String string12 = "true";
                if (string == null) {
                    if (string12 == null) throw throwable;
                } else if (string.equals(string12)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'mean_per_class_error' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable13);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params4 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'mean_per_class_error' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string13 = "true";
            if (string == null) {
                if (string13 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string13)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$6;

                public final String apply() {
                    return this.message$6;
                }
                {
                    this.message$6 = message$6;
                }
            });
            params4 = BoxedUnit.UNIT;
        }
        if (json.has("cm")) {
            try {
                params3 = this.set("confusionMatrix", this.jsonFieldToDataFrame(json.getAsJsonObject("cm"), "table"));
            }
            catch (Throwable throwable) {
                Throwable throwable14 = throwable;
                if (throwable14 == null) throw throwable;
                Throwable throwable15 = throwable14;
                String string = System.getProperty("spark.testing", "false");
                String string14 = "true";
                if (string == null) {
                    if (string14 == null) throw throwable;
                } else if (string.equals(string14)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'cm' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable15);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params3 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'cm' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string15 = "true";
            if (string == null) {
                if (string15 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string15)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$7;

                public final String apply() {
                    return this.message$7;
                }
                {
                    this.message$7 = message$7;
                }
            });
            params3 = BoxedUnit.UNIT;
        }
        if (json.has("thresholds_and_metric_scores")) {
            try {
                params2 = this.set("thresholdsAndMetricScores", this.jsonFieldToDataFrame(json, "thresholds_and_metric_scores"));
            }
            catch (Throwable throwable) {
                Throwable throwable16 = throwable;
                if (throwable16 == null) throw throwable;
                Throwable throwable17 = throwable16;
                String string = System.getProperty("spark.testing", "false");
                String string16 = "true";
                if (string == null) {
                    if (string16 == null) throw throwable;
                } else if (string.equals(string16)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'thresholds_and_metric_scores' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable17);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params2 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'thresholds_and_metric_scores' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string17 = "true";
            if (string == null) {
                if (string17 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string17)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$8;

                public final String apply() {
                    return this.message$8;
                }
                {
                    this.message$8 = message$8;
                }
            });
            params2 = BoxedUnit.UNIT;
        }
        if (json.has("max_criteria_and_metric_scores")) {
            try {
                params = this.set("maxCriteriaAndMetricScores", this.jsonFieldToDataFrame(json, "max_criteria_and_metric_scores"));
            }
            catch (Throwable throwable) {
                Throwable throwable18 = throwable;
                if (throwable18 == null) throw throwable;
                Throwable throwable19 = throwable18;
                String string = System.getProperty("spark.testing", "false");
                String string18 = "true";
                if (string == null) {
                    if (string18 == null) throw throwable;
                } else if (string.equals(string18)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'max_criteria_and_metric_scores' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable19);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'max_criteria_and_metric_scores' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string19 = "true";
            if (string == null) {
                if (string19 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string19)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$9;

                public final String apply() {
                    return this.message$9;
                }
                {
                    this.message$9 = message$9;
                }
            });
            params = BoxedUnit.UNIT;
        }
        if (json.has("gains_lift_table")) {
            try {
                this.set("gainsLiftTable", this.jsonFieldToDataFrame(json, "gains_lift_table"));
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable20 = throwable;
                if (throwable20 == null) throw throwable;
                Throwable throwable21 = throwable20;
                String string = System.getProperty("spark.testing", "false");
                String string20 = "true";
                if (string == null) {
                    if (string20 == null) throw throwable;
                } else if (string.equals(string20)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'gains_lift_table' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable21);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'gains_lift_table' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string21 = "true";
            if (string == null) {
                if (string21 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string21)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$10;

                public final String apply() {
                    return this.message$10;
                }
                {
                    this.message$10 = message$10;
                }
            });
            return;
        }
    }

    @Override
    public H2OBinomialMetrics copy(ParamMap extra) {
        return (H2OBinomialMetrics)this.defaultCopy(extra);
    }

    public H2OBinomialMetrics(String uid) {
        this.uid = uid;
        this.r2 = this.doubleParam("r2", "The R^2 for this scoring run.");
        this.logloss = this.doubleParam("logloss", "The logarithmic loss for this scoring run.");
        this.auc = this.doubleParam("auc", "The AUC for this scoring run.");
        this.prauc = this.doubleParam("prauc", "The precision-recall AUC for this scoring run.");
        this.gini = this.doubleParam("gini", "The Gini score for this scoring run.");
        this.meanPerClassError = this.doubleParam("meanPerClassError", "The mean misclassification error per class.");
        this.confusionMatrix = this.nullableDataFrameParam("confusionMatrix", "The ConfusionMatrix at the threshold for maximum F1.");
        this.thresholdsAndMetricScores = this.nullableDataFrameParam("thresholdsAndMetricScores", "The Metrics for various thresholds.");
        this.maxCriteriaAndMetricScores = this.nullableDataFrameParam("maxCriteriaAndMetricScores", "The Metrics for various criteria.");
        this.gainsLiftTable = this.nullableDataFrameParam("gainsLiftTable", "Gains and Lift table.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.r2().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.logloss().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.auc().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.prauc().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.gini().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.meanPerClassError().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.confusionMatrix().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.thresholdsAndMetricScores().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxCriteriaAndMetricScores().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.gainsLiftTable().$minus$greater(null)}));
    }

    public H2OBinomialMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2OBinomialMetrics"));
    }
}

