/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OCommonMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import com.google.gson.JsonObject;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.util.Identifiable$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all metrics that shared across all algorithms supporting anomaly detection.")
@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u001b\t\t\u0002JM(B]>l\u0017\r\\=NKR\u0014\u0018nY:\u000b\u0005\r!\u0011aB7fiJL7m\u001d\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!C:qCJ\\G.\u001b8h\u0015\tI!\"A\u0002ie=T\u0011aC\u0001\u0003C&\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u0011\u0011Jz5i\\7n_:lU\r\u001e:jGND\u0001b\u0005\u0001\u0003\u0006\u0004%\t\u0005F\u0001\u0004k&$W#A\u000b\u0011\u0005YabBA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\u0012A\u0002)sK\u0012,g-\u0003\u0002\u001e=\t11\u000b\u001e:j]\u001eT!a\u0007\r\t\u0011\u0001\u0002!\u0011!Q\u0001\nU\tA!^5eA!)!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001J\u0013\u0011\u0005=\u0001\u0001\"B\n\"\u0001\u0004)\u0002\"\u0002\u0012\u0001\t\u00039C#\u0001\u0013\t\u000f%\u0002!\u0019!C\tU\u0005IQ.Z1o'\u000e|'/Z\u000b\u0002WA\u0011AFN\u0007\u0002[)\u0011afL\u0001\u0006a\u0006\u0014\u0018-\u001c\u0006\u0003\u000bAR!!\r\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005M\"\u0014AB1qC\u000eDWMC\u00016\u0003\ry'oZ\u0005\u0003o5\u00121\u0002R8vE2,\u0007+\u0019:b[\"1\u0011\b\u0001Q\u0001\n-\n!\"\\3b]N\u001bwN]3!\u0011\u001dY\u0004A1A\u0005\u0012)\n1#\\3b]:{'/\\1mSj,GmU2pe\u0016Da!\u0010\u0001!\u0002\u0013Y\u0013\u0001F7fC:tuN]7bY&TX\rZ*d_J,\u0007\u0005C\u0003@\u0001\u0011\u0005\u0001)\u0001\u0007hKRlU-\u00198TG>\u0014X\rF\u0001B!\t9\")\u0003\u0002D1\t1Ai\\;cY\u0016DQ!\u0012\u0001\u0005\u0002\u0001\u000bacZ3u\u001b\u0016\fgNT8s[\u0006d\u0017N_3e'\u000e|'/\u001a\u0005\u0006\u000f\u0002!\t\u0005S\u0001\u000bg\u0016$X*\u001a;sS\u000e\u001cHcA%M1B\u0011qCS\u0005\u0003\u0017b\u0011A!\u00168ji\")QJ\u0012a\u0001\u001d\u0006!!n]8o!\tye+D\u0001Q\u0015\t\t&+\u0001\u0003hg>t'BA*U\u0003\u00199wn\\4mK*\tQ+A\u0002d_6L!a\u0016)\u0003\u0015)\u001bxN\\(cU\u0016\u001cG\u000fC\u0003Z\r\u0002\u0007Q#A\u0004d_:$X\r\u001f;\t\u000bm\u0003A\u0011\t/\u0002\t\r|\u0007/\u001f\u000b\u0003;zk\u0011\u0001\u0001\u0005\u0006?j\u0003\r\u0001Y\u0001\u0006Kb$(/\u0019\t\u0003Y\u0005L!AY\u0017\u0003\u0011A\u000b'/Y7NCBDC\u0001\u00013hQB\u0011q\"Z\u0005\u0003M\n\u0011!#T3ue&\u001c7\u000fR3tGJL\u0007\u000f^5p]\u0006YA-Z:de&\u0004H/[8oC\u0005I\u0017!\u001a+iK\u0002\u001aG.Y:tA5\f7.Z:!CZ\f\u0017\u000e\\1cY\u0016\u0004\u0013\r\u001c7![\u0016$(/[2tAQD\u0017\r\u001e\u0011tQ\u0006\u0014X\r\u001a\u0011bGJ|7o\u001d\u0011bY2\u0004\u0013\r\\4pe&$\b.\\:!gV\u0004\bo\u001c:uS:<\u0007%\u00198p[\u0006d\u0017\u0010\t3fi\u0016\u001cG/[8o]\u0001")
public class H2OAnomalyMetrics
extends H2OCommonMetrics {
    private final String uid;
    private final DoubleParam meanScore;
    private final DoubleParam meanNormalizedScore;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam meanScore() {
        return this.meanScore;
    }

    public DoubleParam meanNormalizedScore() {
        return this.meanNormalizedScore;
    }

    public double getMeanScore() {
        return BoxesRunTime.unboxToDouble(this.$(this.meanScore()));
    }

    public double getMeanNormalizedScore() {
        return BoxesRunTime.unboxToDouble(this.$(this.meanNormalizedScore()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setMetrics(JsonObject json, String context) {
        BoxedUnit boxedUnit;
        super.setMetrics(json, context);
        if (json.has("mean_score")) {
            try {
                boxedUnit = this.set("meanScore", BoxesRunTime.boxToDouble((double)json.get("mean_score").getAsDouble()));
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit2;
                Throwable throwable2 = throwable;
                if (throwable2 == null) throw throwable;
                Throwable throwable3 = throwable2;
                String string = System.getProperty("spark.testing", "false");
                String string2 = "true";
                if (string == null) {
                    if (string2 == null) throw throwable;
                } else if (string.equals(string2)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'mean_score' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable3);
                boxedUnit = boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (!json.has("mean_normalized_score")) return;
        try {
            this.set("meanNormalizedScore", BoxesRunTime.boxToDouble((double)json.get("mean_normalized_score").getAsDouble()));
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (throwable4 == null) throw throwable;
            Throwable throwable5 = throwable4;
            String string = System.getProperty("spark.testing", "false");
            String string3 = "true";
            if (string == null) {
                if (string3 == null) throw throwable;
            } else if (string.equals(string3)) throw throwable;
            this.logError((Function0<String>)new Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final String context$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Unsuccessful try to extract 'mean_normalized_score' from ").append((Object)this.context$1).toString();
                }
                {
                    this.context$1 = context$1;
                }
            }, throwable5);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        }
    }

    @Override
    public H2OAnomalyMetrics copy(ParamMap extra) {
        return (H2OAnomalyMetrics)this.defaultCopy(extra);
    }

    public H2OAnomalyMetrics(String uid) {
        this.uid = uid;
        this.meanScore = this.doubleParam("meanScore", "Mean Anomaly Score.");
        this.meanNormalizedScore = this.doubleParam("meanNormalizedScore", "Mean Normalized Anomaly Score.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.meanScore().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.meanNormalizedScore().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
    }

    public H2OAnomalyMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2OAnomalyMetrics"));
    }
}

