# PPshare 平台介绍

## PPshare 的概况及使用说明

PPshare是一个长期专注于科研数据的应用性平台，平台提供直接从互联网爬取、社区采取和团队整理数据并将其存入数据库，通过对数据质量进行严格控制为用户提供高质量科研数据。PPshare是一个开放的、免费的数据众享平台、不带任何商业性质和目的。

首先要特别感谢  [FuShare](https://github.com/jindaxiang/fushare), [TuShare](https://github.com/waditu/tushare) 在代码和项目开发上对本项目提供的借鉴和学习的机会!

PPshare 是基于 Python 的经管类数据接口库, 目的是实现对宏观经济、区域经济、产业经济、金融类数据股等常用的基本面数据、实时和历史行情数据、衍生数据从数据采集、数据清洗到数据落地的一套工具, 主要用于学术研究目的.

将继续开放公众号平台和网站：[数据皮皮侠](http://www.ppmandata.cn/) 等社区工具为大家提供服务，感兴趣的朋友请扫描关注“数据皮皮侠”公众号：

![code]（./code.jpg)

# PPshare 数据说明

## PPshare 宏观经济

### 中国宏观杠杆率

接口: macro_cnbs

目标地址: http://114.115.232.154:8080/

描述: 获取中国国家金融与发展实验室-中国宏观杠杆率数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称           | 类型  | 默认显示 | 描述        |
| :------------- | :---- | :------- | :---------- |
| 年份           | str   | Y        | 日期, 年-月 |
| 居民部门       | float | Y        | –           |
| 非金融企业部门 | float | Y        | –           |
| 政府部门       | float | Y        | –           |
| 中央政府       | float | Y        | –           |
| 地方政府       | float | Y        | –           |
| 实体经济部门   | float | Y        | –           |
| 金融部门资产方 | float | Y        | –           |
| 金融部门负债方 | float | Y        | –           |

接口示例

```python
import ppshare as pp
macro_cnbs_df = pp.macro_cnbs()
print(macro_cnbs_df)
```

数据示例

```
年份       居民部门     非金融企业部门  ...      实体经济部门    金融部门资产方    金融部门负债方
0   1993-12   8.311222   91.658000  ...  107.791459   8.896441   7.128428
1   1994-12   7.808230   82.411703  ...   98.354271   9.808787   6.796868
2   1995-12   8.240004   80.950106  ...   97.850373  10.009081   7.006151
3   1996-03   8.403456   81.711651  ...   99.241521  10.183896   7.186300
4   1996-06   8.581114   82.051373  ...   99.679459  10.379730   7.380510
..      ...        ...         ...  ...         ...        ...        ...
93  2018-09  52.575456  155.641011  ...  245.227043  61.350917  60.645733
94  2018-12  53.198837  153.553140  ...  243.702122  60.638348  60.936158
95  2019-03  54.277928  156.881879  ...  248.828108  60.542178  59.417322
96  2019-06  55.304291  155.743313  ...  249.533412  58.736094  58.727086
97  2019-09  56.314848  155.618498  ...  251.147265  55.820243  59.358625
```

### 国民经济运行状况

#### 经济状况

##### LPR品种数据

接口: macro_china_lpr

目标地址: http://data.eastmoney.com/cjsj/globalRateLPR.html

描述: 获取中国LPR品种数据, 数据区间从19910421-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型  | 默认显示 | 描述                           |
| :--------- | :---- | :------- | :----------------------------- |
| TRADE_DATE | str   | Y        | 日期                           |
| LPR1Y      | float | Y        | LPR_1Y利率(%)                  |
| LPR5Y      | float | Y        | LPR_5Y利率(%)                  |
| RATE_1     | float | Y        | 短期贷款利率:6个月至1年(含)(%) |
| RATE_2     | float | Y        | 中长期贷款利率:5年以上(%)      |

接口示例

```python
import PPshare as pp
macro_china_lpr_df = PP.macro_china_lpr()
print(macro_china_lpr_df)
```

数据示例

```
               TRADE_DATE  LPR1Y  LPR5Y  RATE_1  RATE_2
0     2020-03-20 00:00:00   4.05   4.75    4.35    4.90
1     2020-02-20 00:00:00   4.05   4.75    4.35    4.90
2     2020-01-20 00:00:00   4.15   4.80    4.35    4.90
3     2019-12-20 00:00:00   4.15   4.80    4.35    4.90
4     2019-11-20 00:00:00   4.15   4.80    4.35    4.90
                   ...    ...    ...     ...     ...
1493  1995-07-01 00:00:00    NaN    NaN   12.06   15.30
1494  1995-01-01 00:00:00    NaN    NaN   10.98   14.76
1495  1993-07-11 00:00:00    NaN    NaN   10.98   14.04
1496  1993-05-15 00:00:00    NaN    NaN    9.36   12.24
1497  1991-04-21 00:00:00    NaN    NaN    8.64    9.72
```

##### 中国GDP年率报告

接口: macro_china_gdp_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_gdp_yoy

描述: 获取中国年度GDP数据, 数据区间从20110120-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as pp
macro_china_gdp_yearly_df = pp.macro_china_gdp_yearly()
print(macro_china_gdp_yearly_df)
print(macro_china_gdp_yearly_df.name)
```

数据示例

macro_china_gdp_yearly_df.name:

```
gdp
```

macro_china_gdp_yearly_df:

```
2011-01-20    9.8
2011-04-15    9.7
2011-07-13    9.5
2011-10-18    9.1
2012-01-17    8.9
2019-01-21    6.4
2019-04-17    6.4
2019-07-15    6.2
2019-10-18      6
2020-01-17      0
```

#### 物价水平

##### 中国CPI年率报告

接口: macro_china_cpi_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_cpi_yoy

描述: 获取中国年度CPI数据, 数据区间从19860201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as pp
macro_china_cpi_yearly_df = pp.macro_china_cpi_yearly()
print(macro_china_cpi_yearly_df)
print(macro_china_cpi_yearly_df.name)
```

数据示例

macro_china_cpi_yearly_df.name:

```
cpi
```

macro_china_cpi_yearly_df:

```
1986-02-01     7.1
1986-03-01     7.1
1986-04-01     7.1
1986-05-01     7.1
1986-06-01     7.1
1986-07-01     7.1
1986-08-01     7.1
1986-09-01     7.1
2019-08-09     2.8
2019-09-10     2.8
2019-10-15       3
2019-11-09     3.8
2019-12-10     4.5
2020-01-09     4.5
```

##### 中国CPI月率报告

接口: macro_china_cpi_monthly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_cpi_mom

描述: 获取中国月度CPI数据, 数据区间从19960201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_cpi_monthly_df = PP.macro_china_cpi_monthly()
print(macro_china_cpi_monthly_df)
print(macro_china_cpi_monthly_df.name)
```

数据示例

macro_china_cpi_monthly_df.name:

```
cpi
```

macro_china_cpi_monthly_df:

```
1996-02-01     2.1
1996-03-01     2.3
1996-04-01     0.6
1996-05-01     0.7
2019-07-10    -0.1
2019-08-09     0.4
2019-09-10     0.7
2019-10-15     0.9
2019-11-09     0.9
2019-12-10     0.4
2020-01-09       0
```

##### 中国PPI年率报告

接口: macro_china_ppi_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_ppi_yoy

描述: 获取中国年度PPI数据, 数据区间从19950801-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_ppi_yearly_df = PP.macro_china_ppi_yearly()
print(macro_china_ppi_yearly_df)
print(macro_china_ppi_yearly_df.name)
```

数据示例

macro_china_ppi_yearly_df.name:

```
ppi
```

macro_china_ppi_yearly_df:

```
1995-08-01    13.5
1995-09-01      13
1995-10-01    12.9
1995-11-01    12.5
1995-12-01    11.1
2019-08-09    -0.3
2019-09-10    -0.8
2019-10-15    -1.2
2019-11-09    -1.6
2019-12-10    -1.4
2020-01-09    -0.5
```

### 贸易状况

#### 以美元计算出口年率

接口: macro_china_exports_yoy

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_exports_yoy

描述: 获取中国以美元计算出口年率报告, 数据区间从19820201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_exports_yoy_df = PP.macro_china_exports_yoy()
print(macro_china_exports_yoy_df)
print(macro_china_exports_yoy_df.name)
```

数据示例

macro_china_exports_yoy_df.name:

```
china_exports_yoy
```

macro_china_exports_yoy_df:

```
1982-02-01      8.7
1982-03-01     23.2
1982-04-01     12.2
1982-05-01     -2.5
1982-06-01     41.5
2019-03-08    -20.8
2019-04-12     14.2
2019-05-08     -2.7
2019-06-10      1.1
2019-07-12     -1.3
2019-08-08      3.3
2019-09-08       -1
2019-10-14     -3.2
2019-11-08     -0.9
2019-12-08     -1.1
2020-01-14        0
```

#### 以美元计算进口年率

接口: macro_china_imports_yoy

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_imports_yoy

描述: 获取中国以美元计算进口年率报告, 数据区间从19960201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_imports_yoy_df = PP.macro_china_imports_yoy()
print(macro_china_imports_yoy_df)
print(macro_china_imports_yoy_df.name)
```

数据示例

macro_china_imports_yoy_df.name:

```
china_imports_yoy
```

macro_china_imports_yoy_df:

```
1996-02-01    55.8
1996-03-01    14.2
1996-04-01     8.7
1996-05-01     6.4
1996-06-01     4.5
2019-06-10    -8.5
2019-07-12    -7.3
2019-08-08    -5.6
2019-09-08    -5.6
2019-10-14    -8.5
2019-11-08    -6.5
2019-12-08     0.3
2020-01-14       0
```

#### 以美元计算贸易帐(亿美元)

接口: macro_china_trade_balance

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_trade_balance

描述: 获取中国以美元计算贸易帐报告, 数据区间从19810201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_trade_balance_df = PP.macro_china_trade_balance()
print(macro_china_trade_balance_df)
print(macro_china_trade_balance_df.name)
```

数据示例

macro_china_trade_balance_df.name:

```
china_trade_balance
```

macro_china_trade_balance_df:

```
1981-02-01     -2.2
1981-03-01     -4.9
1981-04-01     -7.4
1981-05-01     -4.8
2019-10-14    396.5
2019-11-08    430.2
2019-12-08    387.3
2019-12-09        0
2020-01-14        0
```

### 产业指标

#### 规模以上工业增加值年率

接口: macro_china_industrial_production_yoy

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_industrial_production_yoy

描述: 获取中国规模以上工业增加值年率报告, 数据区间从19900301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_industrial_production_yoy_df = PP.macro_china_industrial_production_yoy()
print(macro_china_industrial_production_yoy_df)
print(macro_china_industrial_production_yoy_df.name)
```

数据示例

macro_china_industrial_production_yoy_df.name:

```
china_industrial_production_yoy
```

macro_china_industrial_production_yoy_df:

```
1990-03-01      5
1990-04-01    0.8
1990-05-01    1.7
1990-06-01    3.3
1990-07-01      5
             ... 
2019-09-16    4.4
2019-10-18    5.8
2019-11-14    4.7
2019-12-16    6.2
2020-01-17      0
```

#### 官方制造业PMI

接口: macro_china_pmi_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_manufacturing_pmi

描述: 获取中国年度PMI数据, 数据区间从20050201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_pmi_yearly_df = PP.macro_china_pmi_yearly()
print(macro_china_pmi_yearly_df)
print(macro_china_pmi_yearly_df.name)
```

数据示例

macro_china_pmi_yearly_df.name:

```
pmi
```

macro_china_pmi_yearly_df:

```
2005-02-01    54.7
2005-03-01    54.5
2005-04-01    57.9
2005-05-01    56.7
2005-06-01    52.9
              ... 
2019-09-30    49.8
2019-10-31    49.3
2019-11-30    50.2
2019-12-31    50.2
2020-01-31       0
```

#### 财新制造业PMI终值

接口: macro_china_cx_pmi_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_caixin_manufacturing_pmi

描述: 获取中国年度财新 PMI 数据, 数据区间从20120120-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_cx_pmi_yearly_df = PP.macro_china_cx_pmi_yearly()
print(macro_china_cx_pmi_yearly_df)
print(macro_china_cx_pmi_yearly_df.name)
```

数据示例

macro_china_cx_pmi_yearly_df.name:

```
cx_pmi
```

macro_china_cx_pmi_yearly_df:

```
2012-01-20    48.8
2012-02-22    49.6
2012-03-22    48.3
2012-04-23    49.1
2012-05-02    49.3
              ... 
2019-09-02    50.4
2019-09-30    51.4
2019-11-01    51.7
2019-12-02    51.8
2020-01-02    51.5
```

#### 财新服务业PMI

接口: macro_china_cx_services_pmi_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_caixin_services_pmi

描述: 获取中国财新服务业PMI报告, 数据区间从20120405-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_cx_services_pmi_yearly_df = PP.macro_china_cx_services_pmi_yearly()
print(macro_china_cx_services_pmi_yearly_df)
print(macro_china_cx_services_pmi_yearly_df.name)
```

数据示例

macro_china_cx_services_pmi_yearly_df.name:

```
cx_services_pmi
```

macro_china_cx_services_pmi_yearly_df:

```
2012-04-05    53.3
2012-05-04    54.1
2012-06-05    54.7
2012-07-04    52.3
2012-08-03    53.1
              ... 
2019-09-04    52.1
2019-10-08    51.3
2019-11-05    51.1
2019-12-04    53.5
2020-01-06    52.5
```

#### 中国官方非制造业PMI

接口: macro_china_non_man_pmi

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_non_manufacturing_pmi

描述: 获取中国官方非制造业PMI, 数据区间从20160101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_non_man_pmi_df = PP.macro_china_non_man_pmi()
print(macro_china_non_man_pmi_df)
print(macro_china_non_man_pmi_df.name)
```

数据示例

macro_china_non_man_pmi_df.name:

```
cx_services_pmi
```

macro_china_non_man_pmi_df:

```
2007-02-01    60.4
2007-03-01    60.6
2007-04-01    58.2
2007-05-01    60.4
2007-06-01    62.2
              ... 
2019-09-30    53.7
2019-10-31    52.8
2019-11-30    54.4
2019-12-31    53.5
2020-01-31       0
```

### 金融指标

#### 外汇储备(亿美元)

接口: macro_china_fx_reserves_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_fx_reserves

描述: 获取中国年度外汇储备数据, 数据区间从20140115-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_fx_reserves_yearly_df = PP.macro_china_fx_reserves_yearly()
print(macro_china_fx_reserves_yearly_df)
print(macro_china_fx_reserves_yearly_df.name)
```

数据示例

macro_china_fx_reserves_yearly_df.name:

```
fx_reserves
```

macro_china_fx_reserves_yearly_df:

```
2014-01-15    39500
2014-07-15    39900
2015-01-15    32300
2016-03-07    32020
2016-04-07    32100
              ...  
2019-09-07    31070
2019-10-08    30920
2019-11-07    31050
2019-12-07    30960
2020-01-07    31080
```

#### M2货币供应年率

接口: macro_china_m2_yearly

目标地址: https://datacenter.jin10.com/reportType/dc_chinese_m2_money_supply_yoy

描述: 获取中国年度M2数据, 数据区间从19980201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 年率 | float | Y        | 年率      |

接口示例

```
import PPshare as PP
macro_china_m2_yearly_df = PP.macro_china_m2_yearly()
print(macro_china_m2_yearly_df)
print(macro_china_m2_yearly_df.name)
```

数据示例

macro_china_m2_yearly_df.name:

```
m2
```

macro_china_m2_yearly_df:

```
1998-02-01    17.4
1998-03-01    16.7
1998-04-01    15.4
1998-05-01    14.6
1998-06-01    15.5
              ... 
2019-11-11     8.4
2019-11-14       0
2019-12-10     8.2
2019-12-13       0
2020-01-14       0
```

#### 中国货币供应量

接口: macro_china_money_supply

目标地址: http://data.eastmoney.com/cjsj/moneysupply.aspx

描述: 获取中国货币供应量月度数据, 数据区间从200801-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称        | 类型  | 默认显示 | 描述           |
| :---------- | :---- | :------- | :------------- |
| 月份        | str   | Y        | 日期-索引      |
| M2-数量     | float | Y        | 注意单位: 亿元 |
| M2-同比增长 | str   | Y        | 注意单位: %    |
| M2-环比增长 | str   | Y        | 注意单位: %    |
| M1-数量     | float | Y        | 注意单位: 亿元 |
| M1-同比增长 | str   | Y        | 注意单位: %    |
| M1-环比增长 | str   | Y        | 注意单位: %    |
| M0-数量     | float | Y        | 注意单位: 亿元 |
| M0-同比增长 | str   | Y        | 注意单位: %    |
| M0-环比增长 | str   | Y        | 注意单位: %    |

接口示例

```
import PPshare as PP
macro_china_money_supply_df = PP.macro_china_money_supply()
print(macro_china_money_supply_df)
```

数据示例

```
            月份       M2-数量 M2-同比增长 M2-环比增长  ... M1-环比增长     M0-数量 M0-同比增长  M0-环比增长
0    2020年03月份  2080900.00  10.10%   2.47%  ...   4.05%  83000.00  10.80%   -5.90%
1    2020年02月份  2030800.00   8.80%   0.38%  ...   1.32%  88200.00  10.90%   -5.36%
2    2020年01月份  2023100.00   8.40%   1.84%  ...  -5.30%  93200.00   6.60%   20.73%
3    2019年12月份  1986500.00   8.70%   1.28%  ...   2.40%  77200.00   5.40%    4.36%
4    2019年11月份  1961429.56   8.20%   0.81%  ...   0.78%  73973.82   4.80%    0.79%
..         ...         ...     ...     ...  ...     ...       ...     ...      ...
142  2008年05月份   436221.60  18.07%   1.61%  ...   1.09%  30169.30  12.88%   -2.01%
143  2008年04月份   429313.72  16.94%   1.48%  ...   0.55%  30789.61  10.70%    1.17%
144  2008年03月份   423054.53  16.19%   0.48%  ...   0.46%  30433.07  11.12%   -6.23%
145  2008年02月份   421037.84  17.39%   0.76%  ...  -3.03%  32454.47   5.96%  -11.50%
146  2008年01月份   417846.17  18.88%   3.58%  ...   1.54%  36673.15  31.21%   20.90%
```

#### 新房价指数

接口: macro_china_new_house_price

目标地址: http://data.eastmoney.com/cjsj/newhouse.html

描述: 获取中国新房价指数月度数据, 数据区间从201101-至今

限量: 单次返回所有历史数据, 目前该指数由上海和北京房价构成

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                      | 类型  | 默认显示 | 描述 |
| :------------------------ | :---- | :------- | :--- |
| 日期                      | str   | Y        | 日期 |
| 城市                      | str   | Y        | –    |
| 新建住宅价格指数-环比     | float | Y        | –    |
| 新建住宅价格指数-同比     | float | Y        | –    |
| 新建住宅价格指数-定基     | float | Y        | –    |
| 新建商品住宅价格指数-环比 | float | Y        | –    |
| 新建商品住宅价格指数-同比 | float | Y        | –    |
| 新建商品住宅价格指数-定基 | float | Y        | –    |
| 二手住宅价格指数-环比     | float | Y        | –    |
| 二手住宅价格指数-同比     | float | Y        | –    |

接口示例

```
import PPshare as PP
macro_china_new_house_price_df = PP.macro_china_new_house_price()
print(macro_china_new_house_price_df)
```

数据示例

```
              日期  城市 新建住宅价格指数-环比  ... 新建商品住宅价格指数-定基 二手住宅价格指数-环比 二手住宅价格指数-同比
0    2020年03月01日  北京           -  ...             -       100.2        99.3
1    2020年03月01日  上海           -  ...             -       100.3       101.6
2    2020年02月01日  北京           -  ...             -        99.8        99.6
3    2020年02月01日  上海           -  ...             -       100.2       101.6
4    2020年01月01日  北京           -  ...             -       100.4       100.0
..           ...  ..         ...  ...           ...         ...         ...
217  2011年03月01日  上海       100.2  ...         102.3       100.4       100.5
218  2011年02月01日  北京       100.4  ...         103.5       100.4       102.9
219  2011年02月01日  上海       100.9  ...         102.1       100.4       102.0
220  2011年01月01日  北京       100.8  ...         103.0       100.3       102.6
221  2011年01月01日  上海       100.9  ...         101.0       100.5       101.7
```

#### 企业景气及企业家信心指数

接口: macro_china_enterprise_boom_index

目标地址: http://data.eastmoney.com/cjsj/qyjqzs.html

描述: 获取中国企业景气及企业家信心指数数据, 数据区间从 2005 一季度-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                | 类型  | 默认显示 | 描述        |
| :------------------ | :---- | :------- | :---------- |
| 季度                | str   | Y        | 日期        |
| 企业景气指数-指数   | float | Y        | –           |
| 企业景气指数-同比   | float | Y        | 注意单位: % |
| 企业景气指数-环比   | float | Y        | 注意单位: % |
| 企业家信心指数-指数 | float | Y        | –           |
| 企业家信心指数-同比 | float | Y        | 注意单位: % |
| 企业家信心指数-环比 | float | Y        | 注意单位: % |

接口示例

```
import PPshare as PP
macro_china_enterprise_boom_index_df = PP.macro_china_enterprise_boom_index()
print(macro_china_enterprise_boom_index_df)
```

数据示例

```
          季度 企业景气指数-指数 企业景气指数-同比 企业景气指数-环比 企业家信心指数-指数 企业家信心指数-同比 企业家信心指数-环比
0   2020第1季度      88.2   -11.78%   -34.58%       90.9     -9.14%    -32.74%
1   2019第4季度     122.8    22.80%    -0.60%      123.6     23.60%     -0.70%
2   2019第3季度     123.4    23.40%     0.20%      124.3     24.30%      0.20%
3   2019第2季度     123.2    23.20%    -3.40%      124.1     24.10%     -3.80%
4   2019第1季度     126.6    26.60%     6.40%      127.9     27.90%      6.60%
..       ...       ...       ...       ...        ...        ...        ...
56  2006第1季度     131.5    31.50%    -0.20%      133.1     33.10%      7.70%
57  2005第4季度     131.7    31.70%    -0.30%      125.4     25.40%     -2.20%
58  2005第3季度     132.0    32.00%     0.29%      127.6     27.60%     -0.90%
59  2005第2季度     131.7    31.71%    -0.75%      128.5     28.50%     -7.35%
60  2005第1季度     132.5    32.46%    -2.27%      135.9     35.85%      5.04%
```

#### 全国税收收入

接口: macro_china_national_tax_receipts

目标地址: http://data.eastmoney.com/cjsj/nationaltaxreceipts.aspx

描述: 获取中国全国税收收入数据, 数据区间从 2005 一季度-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称         | 类型  | 默认显示 | 描述           |
| :----------- | :---- | :------- | :------------- |
| 季度         | str   | Y        | 日期           |
| 税收收入合计 | float | Y        | 注意单位: 亿元 |
| 较上年同期   | float | Y        | 注意单位: %    |
| 季度环比     | float | Y        | 注意单位: %    |

接口示例

```
import PPshare as PP
macro_china_national_tax_receipts_df = PP.macro_china_national_tax_receipts()
print(macro_china_national_tax_receipts_df)
```

数据示例

```
            季度     税收收入合计    较上年同期    季度环比
0     2020年第1季度   39029.00  -16.40%  -0.75%
1   2019年第1-4季度  157992.00    1.00%  -0.10%
2   2019年第1-3季度  126970.00   -0.40%  -0.24%
3   2019年第1-2季度   92424.00    0.90%   2.94%
4     2019年第1季度   46706.00    5.40%  -0.60%
..          ...        ...      ...     ...
54  2006年第1-2季度   18484.80   22.00%   0.14%
55    2006年第1季度    8626.32   19.00%   0.83%
56  2005年第1-3季度   21855.35   15.90%  -0.15%
57  2005年第1-2季度   15149.73   13.40%   0.09%
58    2005年第1季度    7249.16   10.70%   0.97%
```

#### 新增信贷数据

接口: macro_china_new_financial_credit

目标地址: http://data.eastmoney.com/cjsj/xzxd.html

描述: 获取中国新增信贷数据数据, 数据区间从 200801 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称          | 类型 | 默认显示 | 描述           |
| :------------ | :--- | :------- | :------------- |
| 月份          | str  | Y        | –              |
| 当月          | str  | Y        | 注意单位: 亿元 |
| 当月-同比增长 | str  | Y        | 注意单位: %    |
| 当月-环比增长 | str  | Y        | 注意单位: %    |
| 累计          | str  | Y        | 注意单位: 亿元 |
| 累计-同比增长 | str  | Y        | 注意单位: %    |

接口示例

```
import PPshare as PP
macro_china_new_financial_credit_df = PP.macro_china_new_financial_credit()
print(macro_china_new_financial_credit_df)
```

数据示例

```
            月份       当月 当月-同比增长  当月-环比增长       累计 累计-同比增长
0    2020年06月份  19043.6   13.78    22.86   123300   23.03
1    2020年05月份    15500   30.74    -4.55   104256   24.89
2    2020年04月份  16239.5   85.96   -46.56  88756.4   23.92
3    2020年03月份  30390.3   55.18   321.96  72516.9    15.3
4    2020年02月份  7202.13   -5.74   -79.38  42126.6   -2.73
..         ...      ...     ...      ...      ...     ...
145  2008年05月份     3185   28.79   -32.09    21201    1.39
146  2008年04月份     4690   11.14    65.49    18016   -2.29
147  2008年03月份     2834  -35.84    16.43    13326   -6.27
148  2008年02月份     2434  -41.18   -69.79    10492    7.05
149  2008年01月份     8058   42.29  1561.44     8058   42.29
```

#### 居民消费价格指数

接口: macro_china_cpi

目标地址: http://data.eastmoney.com/cjsj/cpi.html

描述: 获取中国居民消费价格指数, 数据区间从 200801 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称          | 类型 | 默认显示 | 描述        |
| :------------ | :--- | :------- | :---------- |
| 月份          | str  | Y        | –           |
| 全国-当月     | str  | Y        | –           |
| 全国-同比增长 | str  | Y        | 注意单位: % |
| 全国-环比增长 | str  | Y        | 注意单位: % |
| 全国-累计     | str  | Y        | –           |
| 城市-当月     | str  | Y        | –           |
| 城市-同比增长 | str  | Y        | 注意单位: % |
| 城市-环比增长 | str  | Y        | 注意单位: % |
| 城市-累计     | str  | Y        | –           |
| 农村-当月     | str  | Y        | –           |
| 农村-同比增长 | str  | Y        | 注意单位: % |
| 农村-环比增长 | str  | Y        | 注意单位: % |
| 农村-累计     | str  | Y        | –           |

接口示例

```
import PPshare as PP
macro_china_cpi_df = PP.macro_china_cpi()
print(macro_china_cpi_df)
```

数据示例

```
           月份  全国-当月 全国-同比增长 全国-环比增长  ...  农村-当月 农村-同比增长 农村-环比增长  农村-累计
0   2020年07月份  102.7    2.7%    0.6%  ...  103.7    3.7%    0.8%  104.5
1   2020年06月份  102.5    2.5%   -0.1%  ...  103.2    3.2%    0.0%  104.7
2   2020年05月份  102.4    2.4%   -0.8%  ...  103.0    3.0%   -0.9%  105.0
3   2020年04月份  103.3    3.3%   -0.9%  ...  104.0    4.0%   -1.0%  105.5
4   2020年03月份  104.3    4.3%   -1.2%  ...  105.3    5.3%   -1.3%  105.9
..        ...    ...     ...     ...  ...    ...     ...     ...    ...
6   2008年05月份  107.7    7.7%   -0.4%  ...  108.5    8.5%   -0.3%  108.8
7   2008年04月份  108.5    8.5%    0.1%  ...  109.3    9.3%    0.1%  108.8
8   2008年03月份  108.3    8.3%   -0.7%  ...  109.0    9.0%   -0.5%  108.7
9   2008年02月份  108.7    8.7%    2.6%  ...  109.2    9.2%    2.4%  108.5
10  2008年01月份  107.1    7.1%    1.2%  ...  107.7    7.7%    1.2%  107.7
```

#### 国内生产总值

接口: macro_china_gdp

目标地址: http://data.eastmoney.com/cjsj/gdp.html

描述: 获取中国国内生产总值, 数据区间从 200601 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                  | 类型 | 默认显示 | 描述           |
| :-------------------- | :--- | :------- | :------------- |
| 季度                  | str  | Y        | –              |
| 国内生产总值-绝对值   | str  | Y        | 注意单位: 亿元 |
| 国内生产总值-同比增长 | str  | Y        | 注意单位: %    |
| 第一产业-绝对值       | str  | Y        | 注意单位: 亿元 |
| 第一产业-同比增长     | str  | Y        | 注意单位: %    |
| 第二产业-绝对值       | str  | Y        | 注意单位: 亿元 |
| 第二产业-同比增长     | str  | Y        | 注意单位: %    |
| 第三产业-绝对值       | str  | Y        | 注意单位: 亿元 |
| 第三产业-同比增长     | str  | Y        | 注意单位: %    |

接口示例

```
import PPshare as PP
macro_china_gdp_df = PP.macro_china_gdp()
print(macro_china_gdp_df)
```

数据示例

```
             季度 国内生产总值-绝对值 国内生产总值-同比增长  ... 第二产业-同比增长   第三产业-绝对值 第三产业-同比增长
0   2020年第1-2季度  456614.00      -1.60%  ...    -1.90%  257802.00    -1.60%
1     2020年第1季度  206504.30      -6.80%  ...    -9.60%  122680.10    -5.20%
2   2019年第1-4季度  990865.10       6.10%  ...     5.70%  534233.10     6.90%
3   2019年第1-3季度  712845.40       6.20%  ...     5.60%  392927.90     7.00%
4   2019年第1-2季度  460636.70       6.30%  ...     5.80%  258307.50     7.00%
..          ...        ...         ...  ...       ...        ...       ...
13    2007年第1季度   57159.30      13.80%  ...    14.80%   27702.50    14.10%
14  2006年第1-4季度  219438.50      12.70%  ...    13.50%   91759.70    14.10%
15  2006年第1-3季度  155816.80      12.80%  ...    13.70%   67185.10    13.70%
16  2006年第1-2季度   99752.20      13.10%  ...    14.20%   44995.30    13.60%
17    2006年第1季度   47078.90      12.50%  ...    13.10%   22647.40    13.10%
```

#### 工业品出厂价格指数

接口: macro_china_ppi

目标地址: http://data.eastmoney.com/cjsj/ppi.html

描述: 获取工业品出厂价格指数, 数据区间从 200601 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称         | 类型 | 默认显示 | 描述        |
| :----------- | :--- | :------- | :---------- |
| 月份         | str  | Y        | –           |
| 当月         | str  | Y        | –           |
| 当月同比增长 | str  | Y        | 注意单位: % |
| 累计         | str  | Y        | –           |

接口示例

```
import PPshare as PP
macro_china_ppi_df = PP.macro_china_ppi()
print(macro_china_ppi_df)
```

数据示例

```
           月份     当月  当月同比增长      累计
0   2020年07月份   97.6  -2.40%   98.00
1   2020年06月份   97.0  -3.00%   98.10
2   2020年05月份   96.3  -3.70%   98.30
3   2020年04月份   96.9  -3.10%   98.80
4   2020年03月份   98.5  -1.50%   99.40
..        ...    ...     ...     ...
10  2006年05月份  102.4   2.43%  102.57
11  2006年04月份  101.9   1.87%  102.60
12  2006年03月份  102.5   2.49%  102.90
13  2006年02月份  103.0   3.01%  103.00
14  2006年01月份  103.1   3.05%  103.05
```

#### 采购经理人指数

接口: macro_china_pmi

目标地址: http://data.eastmoney.com/cjsj/pmi.html

描述: 获取采购经理人指数, 数据区间从 200801 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称              | 类型 | 默认显示 | 描述        |
| :---------------- | :--- | :------- | :---------- |
| 月份              | str  | Y        | –           |
| 制造业-指数       | str  | Y        | –           |
| 制造业-同比增长   | str  | Y        | 注意单位: % |
| 非制造业-指数     | str  | Y        | –           |
| 非制造业-同比增长 | str  | Y        | 注意单位: % |

接口示例

```
import PPshare as PP
macro_china_pmi_df = PP.macro_china_pmi()
print(macro_china_pmi_df)
```

数据示例

```
      月份 制造业-指数 制造业-同比增长 非制造业-指数 非制造业-同比增长
0   2020年07月份   51.1    2.82%    54.2     0.93%
1   2020年06月份   50.9    3.04%    54.4     0.37%
2   2020年05月份   50.6    2.43%    53.6    -1.29%
3   2020年04月份   50.8    1.40%    53.2    -2.03%
4   2020年03月份   52.0    2.97%    52.3    -4.56%
..        ...    ...      ...     ...       ...
6   2008年05月份   53.3   -4.31%    57.4    -7.72%
7   2008年04月份   59.2    1.02%    58.4    -3.31%
8   2008年03月份   58.4    4.10%    58.9     1.20%
9   2008年02月份   53.4    0.56%    59.3    -2.15%
10  2008年01月份   53.0   -3.81%    60.2    -0.33%
```

#### 中国城镇固定资产投资

接口: macro_china_gdzctz

目标地址: http://data.eastmoney.com/cjsj/gdzctz.html

描述: 获取中国城镇固定资产投资, 数据区间从 200802 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型 | 默认显示 | 描述           |
| :--------- | :--- | :------- | :------------- |
| 月份       | str  | Y        | –              |
| 当月       | str  | Y        | 注意单位: 亿元 |
| 同比增长   | str  | Y        | 注意单位: %    |
| 环比增长   | str  | Y        | 注意单位: %    |
| 自年初累计 | str  | Y        | 注意单位: 亿元 |

接口示例

```
import PPshare as PP
macro_china_gdzctz_df = PP.macro_china_gdzctz()
print(macro_china_gdzctz_df)
```

数据示例

```
           月份     当月     同比增长     环比增长   自年初累计
0   2020年07月份  47611   -4.38%  -42.23%  329214
1   2020年06月份  82409    1.06%   32.13%  281603
2   2020年05月份  62370    0.91%   18.40%  199194
3   2020年04月份  52679   -2.22%    3.65%  136824
4   2020年03月份  50822  -10.87%    0.00%   84145
..        ...    ...      ...      ...     ...
13  2008年06月份  18172   29.49%   53.29%   58436
14  2008年05月份  11854   25.44%   17.45%   40264
15  2008年04月份  10093   25.37%   -1.01%   28410
16  2008年03月份  10196   27.31%    0.00%   18317
17  2008年02月份      0    0.00%    0.00%    8121
```

#### 海关进出口增减情况一览表

接口: macro_china_hgjck

目标地址: http://data.eastmoney.com/cjsj/hgjck.html

描述: 获取中国海关进出口增减情况一览表, 数据区间从 200801 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                | 类型 | 默认显示 | 描述             |
| :------------------ | :--- | :------- | :--------------- |
| 月份                | str  | Y        | –                |
| 当月出口额-金额     | str  | Y        | 注意单位: 亿美元 |
| 当月出口额-同比增长 | str  | Y        | 注意单位: %      |
| 当月出口额-环比增长 | str  | Y        | 注意单位: %      |
| 当月进口额-金额     | str  | Y        | 注意单位: 亿美元 |
| 当月进口额-同比增长 | str  | Y        | 注意单位: %      |
| 当月进口额-环比增长 | str  | Y        | 注意单位: %      |
| 累计出口额-金额     | str  | Y        | 注意单位: 亿美元 |
| 累计出口额-同比增长 | str  | Y        | 注意单位: %      |
| 累计进口额-金额     | str  | Y        | 注意单位: 亿美元 |
| 累计进口额-同比增长 | str  | Y        | 注意单位: %      |

接口示例

```
import PPshare as PP
macro_china_hgjck_df = PP.macro_china_hgjck()
print(macro_china_hgjck_df)
```

数据示例

```
           月份 当月出口额-金额 当月出口额-同比增长  ... 累计出口额-同比增长  累计进口额-金额 累计进口额-同比增长
0   2020年07月份  2376.31      7.20%  ...     -4.10%  11062.48     -5.70%
1   2020年06月份  2135.74      0.50%  ...     -6.20%   9309.46     -7.10%
2   2020年05月份  2068.13     -3.30%  ...     -7.70%   7636.29     -8.20%
3   2020年04月份  2002.82      3.50%  ...     -9.00%   6200.48     -5.90%
4   2020年03月份  1851.48     -6.60%  ...    -13.30%   4650.11     -2.90%
..        ...      ...        ...  ...        ...       ...        ...
5   2008年05月份  1204.96     28.10%  ...     22.90%   4670.27     30.40%
6   2008年04月份  1187.07     21.80%  ...     21.50%   3665.73     27.90%
7   2008年03月份  1089.63     30.60%  ...     21.40%   2644.79     28.60%
8   2008年02月份   873.68      6.50%  ...     16.80%   1689.38     30.90%
9   2008年01月份  1096.40     26.60%  ...     26.60%    901.74     27.60%
```

#### 财政收入

接口: macro_china_czsr

目标地址: http://data.eastmoney.com/cjsj/czsr.html

描述: 获取中国财政收入, 数据区间从 200801 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称          | 类型 | 默认显示 | 描述             |
| :------------ | :--- | :------- | :--------------- |
| 月份          | str  | Y        | –                |
| 当月          | str  | Y        | 注意单位: 亿元   |
| 当月-同比增长 | str  | Y        | 注意单位: %      |
| 当月-环比增长 | str  | Y        | 注意单位: %      |
| 累计          | str  | Y        | 注意单位: 亿美元 |
| 累计-同比增长 | str  | Y        | 注意单位: %      |

接口示例

```
import PPshare as PP
macro_china_czsr_df = PP.macro_china_czsr()
print(macro_china_czsr_df)
```

数据示例

```
      月份        当月  当月-同比增长  当月-环比增长  累计  累计-同比增长
0   2020年06月份  18504.00    3.22%   19.08%  96176.00  -10.80%
1   2020年05月份  15539.00  -10.01%   -3.78%  77672.00  -13.60%
2   2020年04月份  16149.00  -14.98%   50.20%  62133.00  -14.50%
3   2020年03月份  10752.00  -26.11%    0.00%  45984.00  -14.30%
4   2020年02月份      0.00    0.00%    0.00%  35232.00   -9.90%
..        ...       ...      ...      ...       ...      ...
3   2008年05月份   6268.18   52.60%   -8.16%  29064.37   33.80%
4   2008年04月份   6824.90   17.02%   54.55%  22796.22   29.40%
5   2008年03月份   4416.00   24.67%    6.18%  15971.34   35.50%
6   2008年02月份   4158.80   36.55%  -43.77%  11555.39   40.20%
7   2008年01月份   7396.64   42.35%  135.20%   7396.64   42.40%
```

#### 外汇贷款数据

接口: macro_china_whxd

目标地址: http://data.eastmoney.com/cjsj/whxd.html

描述: 获取外汇贷款数据, 数据区间从 200802 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称     | 类型 | 默认显示 | 描述             |
| :------- | :--- | :------- | :--------------- |
| 月份     | str  | Y        | –                |
| 当月     | str  | Y        | 注意单位: 亿美元 |
| 同比增长 | str  | Y        | 注意单位: %      |
| 环比增长 | str  | Y        | 注意单位: %      |
| 累计     | str  | Y        | 注意单位: 亿美元 |

接口示例

```
import PPshare as PP
macro_china_whxd_df = PP.macro_china_whxd()
print(macro_china_whxd_df)
```

数据示例

```
      月份        当月      同比增长      环比增长       累计
0   2020年07月份  192.00   256.10%    24.68%  8835.00
1   2020年06月份  154.00   294.94%    -2.53%  8643.00
2   2020年05月份  158.00   154.84%   -23.67%  8489.00
3   2020年04月份  207.00   200.49%   727.27%  8331.00
4   2020年03月份  -33.00  -153.23%  -116.58%  8124.00
..        ...     ...       ...       ...      ...
13  2008年06月份   14.02   -84.35%   -53.33%  2753.36
14  2008年05月份   30.04   -13.15%    40.70%  2739.34
15  2008年04月份   21.35    39.82%   -79.40%  2709.30
16  2008年03月份  103.62   279.28%   -52.25%  2687.95
17  2008年02月份  217.02   754.75%   -90.83%  2584.33
```

#### 本外币存款

接口: macro_china_wbck

目标地址: http://data.eastmoney.com/cjsj/wbck.html

描述: 获取本外币存款, 数据区间从 200802 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称     | 类型 | 默认显示 | 描述           |
| :------- | :--- | :------- | :------------- |
| 月份     | str  | Y        | –              |
| 当月     | str  | Y        | 注意单位: 亿元 |
| 同比增长 | str  | Y        | 注意单位: %    |
| 环比增长 | str  | Y        | 注意单位: %    |
| 累计     | str  | Y        | 注意单位: 亿元 |

接口示例

```
import PPshare as PP
macro_china_wbck_df = PP.macro_china_wbck()
print(macro_china_wbck_df)
```

数据示例

```
           月份        当月     同比增长     环比增长          累计
0   2020年07月份   1133.15  -79.29%  -96.33%  2131019.48
1   2020年06月份  30853.36   33.17%   33.24%  2129886.33
2   2020年05月份  23155.64   88.19%   97.66%  2099032.97
3   2020年04月份  11715.18  377.15%  -71.19%  2075877.33
4   2020年03月份  40661.59  129.27%  253.39%  2064162.15
..        ...       ...      ...      ...         ...
13  2008年06月份   7686.63  -14.22%  -12.28%   450227.49
14  2008年05月份   8763.12  370.97%   22.04%   442540.86
15  2008年04月份   7180.81   69.12%  -33.13%   433777.74
16  2008年03月份  10737.68   25.85%  -19.69%   426596.93
17  2008年02月份  13370.18  152.67%  -96.68%   415859.25
```

#### 币净投放与净回笼

接口: macro_china_hb

目标地址: http://www.chinamoney.com.cn/chinese/hb/

描述: 央行币净投放与净回笼, 数据区间从 19970310 至今, 周频率

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型 | 默认显示 | 描述       |
| :--------- | :--- | :------- | :--------- |
| start_date | str  | Y        | 开始日期   |
| net_put_in | str  | Y        | 净投放(亿) |
| back       | str  | Y        | 回笼量(亿) |
| end_date   | str  | Y        | 结束日期   |
| put_in     | str  | Y        | 投放量(亿) |
| date       | str  | Y        | 周期       |

接口示例

```
import PPshare as PP
macro_china_hb_df = PP.macro_china_hb()
print(macro_china_hb_df)
```

数据示例

```
      start_date net_put_in  back    end_date put_in     date
0     1997-03-10          0     0  1997-03-16      0  1997-11
1     1997-03-17          0     0  1997-03-23      0  1997-12
2     1997-03-24          0     0  1997-03-30      0  1997-13
3     1997-03-31          0     0  1997-04-06      0  1997-14
4     1997-04-07          0     0  1997-04-13      0  1997-15
          ...        ...   ...         ...    ...      ...
1215  2020-07-20      -1650  3300  2020-07-26   1650  2020-30
1216  2020-07-27       1200  1600  2020-08-02   2800  2020-31
1217  2020-08-03      -2700  2800  2020-08-09    100  2020-32
1218  2020-08-10       4900   100  2020-08-16   5000  2020-33
1219  2020-08-17      -3500  5000  2020-08-23   1500  2020-34
```

#### 央行公开市场操作

接口: macro_china_gksccz

目标地址: http://www.chinamoney.com.cn/chinese/yhgkscczh/

描述: 央行公开市场操作, 数据区间从 20040116 至今, 周频率

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                | 类型 | 默认显示 | 描述        |
| :------------------ | :--- | :------- | :---------- |
| rate                | str  | Y        | 中标利率(%) |
| trading_method      | str  | Y        | 正/逆回购   |
| deal_amount         | str  | Y        | 交易量(亿)  |
| period              | str  | Y        | 期限(天)    |
| operation_from_date | str  | Y        | 操作日期    |

接口示例

```
import PPshare as PP
macro_china_gksccz_df = PP.macro_china_gksccz()
print(macro_china_gksccz_df)
```

数据示例

```
      rate trading_method deal_amount period operation_from_date
0     2.82            逆回购         400     14          2004-01-16
1     2.83            正回购          50     91          2004-05-13
2     2.55            正回购         150     28          2004-05-13
3     2.65            正回购         300     28          2004-05-20
4     2.69            正回购         200     28          2004-05-27
    ...            ...         ...    ...                 ...
1955   2.2            逆回购         500      7          2020-08-17
1956   2.2            逆回购        1000      7          2020-08-18
1957   2.2            逆回购        1500      7          2020-08-19
1958  2.35            逆回购         500     14          2020-08-21
1959   2.2            逆回购        1500      7          2020-08-21
```

#### 新债券发行

接口: macro_china_bond_public

目标地址: http://www.chinamoney.com.cn/chinese/xzj

描述: 债券信息披露-新债券发行, 近期债券发行数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                | 类型 | 默认显示 | 描述 |
| :------------------ | :--- | :------- | :--- |
| issue_price         | str  | Y        | –    |
| emit_enty           | str  | Y        | –    |
| coupon_type         | str  | Y        | –    |
| plnd_issue_vlmn_str | str  | Y        | –    |
| issue_price_str     | str  | Y        | –    |
| issue_date          | str  | Y        | –    |
| bond_type           | str  | Y        | –    |
| plnd_issue_vlmn     | str  | Y        | –    |
| bond_name           | str  | Y        | –    |
| bond_code           | str  | Y        | –    |
| rtng_shrt           | str  | Y        | –    |
| bond_period         | str  | Y        | –    |
| defined_code        | str  | Y        | –    |

接口示例

```
import PPshare as PP
macro_china_bond_public_df = PP.macro_china_bond_public()
print(macro_china_bond_public_df)
```

数据示例

```
    issue_price emit_enty coupon_type  ... rtng_shrt bond_period defined_code
0          None      None         未计息  ...      None        340日   eabej8aq8n
1          None      None         零息式  ...       AAA        340日   eabeitsg7n
2          None      None     附息式固定利率  ...       AAA         10年   eadgek956e
3          None      None     附息式固定利率  ...       AAA         15年   eadgdm86f1
4          None      None     附息式固定利率  ...       AAA          5年   eadgclnd8n
..          ...       ...         ...  ...       ...         ...          ...
410        None      None     附息式固定利率  ...       AAA          3年   digaam0gri
411        None      None     附息式固定利率  ...       AAA          3年   31101hrowk
412        None      None     附息式固定利率  ...       AA+          5年   277522ta3a
413        None      None     附息式固定利率  ...       AA-          5年   djbgj9xcxt
414        None      None     附息式固定利率  ...       AAA          3年   djaabv3nd8
```

#### 外汇和黄金储备

接口: macro_china_fx_gold

目标地址: http://data.eastmoney.com/cjsj/hjwh.html

描述: 获取中国外汇和黄金储备, 数据区间从 200801 至今, 月度数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称                     | 类型 | 默认显示 | 描述             |
| :----------------------- | :--- | :------- | :--------------- |
| date                     | str  | Y        | 年度和月份       |
| foreign_exchange_reserve | str  | Y        | 注意单位: 亿美元 |
| gold_reserves            | str  | Y        | 注意单位: 万盎司 |

接口示例

```
import PPshare as PP
macro_china_fx_gold_df = PP.macro_china_fx_gold()
print(macro_china_fx_gold_df)
```

数据示例

```
      date foreign_exchange_reserve gold_reserves
0    08年1月                15898.104          1929
1    08年2月               16471.3371          1929
2    08年3月                 16821.77          1929
3    08年4月               17566.5514          1929
4    08年5月               17969.6074          1929
..     ...                      ...           ...
145  20年2月                 31067.18          6264
146  20年3月                 30606.33          6264
147  20年4月                 30914.59          6264
148  20年5月                 31016.92          6264
149  20年6月                 31123.28          6264
```

#### 上海银行业同业拆借报告

接口: macro_china_shibor_all

目标地址: https://datacenter.jin10.com/reportType/dc_shibor

描述: 获取上海银行业同业拆借报告, 数据区间从20170317-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型  | 默认显示 | 描述      |
| :--------- | :---- | :------- | :-------- |
| 日期       | str   | Y        | 日期-索引 |
| O/N_定价   | float | Y        | –         |
| O/N_涨跌幅 | float | Y        | 单位: 点  |
| 1W_定价    | float | Y        | –         |
| 1W_涨跌幅  | float | Y        | 单位: 点  |
| 2W_定价    | float | Y        | –         |
| 2W_涨跌幅  | float | Y        | 单位: 点  |
| 1M_定价    | float | Y        | –         |
| 1M_涨跌幅  | float | Y        | 单位: 点  |
| 3M_定价    | float | Y        | –         |
| 3M_涨跌幅  | float | Y        | 单位: 点  |
| 6M_定价    | float | Y        | –         |
| 6M_涨跌幅  | float | Y        | 单位: 点  |
| 9M_定价    | float | Y        | –         |
| 9M_涨跌幅  | float | Y        | 单位: 点  |
| 1Y_定价    | float | Y        | –         |
| 1Y_涨跌幅  | float | Y        | 单位: 点  |
| ON_定价    | float | Y        | –         |
| ON_涨跌幅  | float | Y        | 单位: 点  |
| 2M_定价    | float | Y        | –         |
| 2M_涨跌幅  | float | Y        | 单位: 点  |

接口示例

```
import PPshare as PP
macro_china_shibor_all_df = PP.macro_china_shibor_all()
print(macro_china_shibor_all_df)
```

数据示例

```
            O/N_定价  O/N_涨跌幅   1W_定价  1W_涨跌幅  ...   ON_定价  ON_涨跌幅   2M_定价  2M_涨跌幅
2017-03-17  2.6330      NaN  2.7250     NaN  ...     NaN     NaN     NaN     NaN
2017-03-20  2.6325    -0.05  3.9428  121.78  ...  2.0283     NaN  4.5915     NaN
2017-03-21  2.6477     1.52  3.9094  116.23  ...  2.3883   36.00  4.6113    1.98
2017-03-22  2.6507     0.30  4.3795  161.15  ...  2.3100   -7.83  4.8365   22.52
2017-03-23  2.6570     0.63  4.3538  156.28  ...  2.2263   -8.37  4.5410  -29.55
            ...      ...     ...     ...  ...     ...     ...     ...     ...
2020-04-16  0.7020    -9.90  1.3475  -28.45  ...  1.2485    5.68  1.9365   -2.60
2020-04-17  0.7160     1.40  1.3490  -30.80  ...  1.2717    2.32  1.9140   -2.25
2020-04-20  0.8960    18.00  1.4882  -24.88  ...  1.4213   14.97  2.0012    8.72
2020-04-21  0.9010     0.50  1.4832  -25.08  ...  1.3310   -9.03  1.9972   -0.40
2020-04-22  0.9010     0.00  1.4188  -18.72  ...  1.2177  -11.33  1.9992    0.20
```

#### 人民币香港银行同业拆息

接口: macro_china_hk_market_info

目标地址: https://datacenter.jin10.com/reportType/dc_hk_market_info

描述: 获取香港同业拆借报告, 数据区间从20170320-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型  | 默认显示 | 描述      |
| :--------- | :---- | :------- | :-------- |
| 日期       | str   | Y        | 日期-索引 |
| O/N_定价   | float | Y        | –         |
| O/N_涨跌幅 | float | Y        | 单位: 点  |
| 1W_定价    | float | Y        | –         |
| 1W_涨跌幅  | float | Y        | 单位: 点  |
| 2W_定价    | float | Y        | –         |
| 2W_涨跌幅  | float | Y        | 单位: 点  |
| 1M_定价    | float | Y        | –         |
| 1M_涨跌幅  | float | Y        | 单位: 点  |
| 3M_定价    | float | Y        | –         |
| 3M_涨跌幅  | float | Y        | 单位: 点  |
| 6M_定价    | float | Y        | –         |
| 6M_涨跌幅  | float | Y        | 单位: 点  |
| 9M_定价    | float | Y        | –         |
| 9M_涨跌幅  | float | Y        | 单位: 点  |
| 1Y_定价    | float | Y        | –         |
| 1Y_涨跌幅  | float | Y        | 单位: 点  |
| ON_定价    | float | Y        | –         |
| ON_涨跌幅  | float | Y        | 单位: 点  |
| 2M_定价    | float | Y        | –         |
| 2M_涨跌幅  | float | Y        | 单位: 点  |

接口示例

```
import PPshare as PP
macro_china_hk_market_info_df = PP.macro_china_hk_market_info()
print(macro_china_hk_market_info_df)
```

数据示例

```
            O/N_定价  O/N_涨跌幅   1W_定价  1W_涨跌幅  ...   ON_定价  ON_涨跌幅   2M_定价  2M_涨跌幅
2017-03-17  2.6330      NaN  2.7250     NaN  ...     NaN     NaN     NaN     NaN
2017-03-20  2.6325    -0.05  3.9428  121.78  ...  2.0283     NaN  4.5915     NaN
2017-03-21  2.6477     1.52  3.9094  116.23  ...  2.3883   36.00  4.6113    1.98
2017-03-22  2.6507     0.30  4.3795  161.15  ...  2.3100   -7.83  4.8365   22.52
2017-03-23  2.6570     0.63  4.3538  156.28  ...  2.2263   -8.37  4.5410  -29.55
            ...      ...     ...     ...  ...     ...     ...     ...     ...
2020-04-16  0.7020    -9.90  1.3475  -28.45  ...  1.2485    5.68  1.9365   -2.60
2020-04-17  0.7160     1.40  1.3490  -30.80  ...  1.2717    2.32  1.9140   -2.25
2020-04-20  0.8960    18.00  1.4882  -24.88  ...  1.4213   14.97  2.0012    8.72
2020-04-21  0.9010     0.50  1.4832  -25.08  ...  1.3310   -9.03  1.9972   -0.40
2020-04-22  0.9010     0.00  1.4188  -18.72  ...  1.2177  -11.33  1.9992    0.20
```

### 其他指标

#### 中国日度沿海六大电库存

接口: macro_china_daily_energy

目标地址: https://datacenter.jin10.com/reportType/dc_qihuo_energy_report

描述: 获取中国日度沿海六大电库存数据, 数据区间从20160101-至今, 不再更新, 只能获得历史数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 数值 | float | Y        | energy    |

接口示例

```
import PPshare as PP
macro_china_daily_energy_df = PP.macro_china_daily_energy()
print(macro_china_daily_energy_df)
```

数据示例

macro_china_daily_energy_df:

```
          沿海六大电库存      日耗 存煤可用天数
2016-01-01  1167.60   64.20   18.19
2016-01-02  1162.90   63.40   18.34
2016-01-03  1160.80   62.60   18.54
2016-01-04  1185.30   57.60   20.58
2016-01-05  1150.20   57.20   20.11
              ...     ...    ...
2019-05-17   1639.47   61.71  26.56
2019-05-21   1591.92   62.67  25.40
2019-05-22   1578.63   59.54  26.51
2019-05-24   1671.83   60.65  27.56
2019-06-21   1786.64   66.57  26.84
```

#### 人民币汇率中间价报告

接口: macro_china_rmb

目标地址: https://datacenter.jin10.com/reportType/dc_rmb_data

描述: 获取中国人民币汇率中间价报告, 数据区间从20170103-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                         | 类型  | 默认显示 | 描述       |
| :--------------------------- | :---- | :------- | :--------- |
| 日期                         | str   | Y        | 日期-索引  |
| 美元/人民币_中间价           | float | Y        | –          |
| 美元/人民币_涨跌幅           | float | Y        | 单位: 点   |
| 欧元/人民币_中间价           | float | Y        | –          |
| 欧元/人民币_涨跌幅           | float | Y        | 单位: 点   |
| 100日元/人民币_中间价        | float | Y        | –          |
| 100日元/人民币_涨跌幅        | float | Y        | 单位: 点对 |
| 港元/人民币_中间价           | float | Y        | –          |
| 港元/人民币_涨跌幅           | float | Y        | 单位: 点   |
| 英镑/人民币_中间价           | float | Y        | –          |
| 英镑/人民币_涨跌幅           | float | Y        | 单位: 点   |
| 澳元/人民币_中间价           | float | Y        | –          |
| 澳元/人民币_涨跌幅           | float | Y        | 单位: 点   |
| 新西兰元/人民币_中间价       | float | Y        | –          |
| 新西兰元/人民币_涨跌幅       | float | Y        | 单位: 点   |
| 新加坡元/人民币_中间价       | float | Y        | –          |
| 新加坡元/人民币_涨跌幅       | float | Y        | 单位: 点   |
| 瑞郎/人民币_中间价           | float | Y        | –          |
| 瑞郎/人民币_涨跌幅           | float | Y        | 单位: 点   |
| 加元/人民币_中间价           | float | Y        | –          |
| 加元/人民币_涨跌幅           | float | Y        | 单位: 点   |
| 人民币/马来西亚林吉特_中间价 | float | Y        | –          |
| 人民币/马来西亚林吉特_涨跌幅 | float | Y        | 单位: 点   |
| 人民币/俄罗斯卢布_中间价     | float | Y        | –          |
| 人民币/俄罗斯卢布_涨跌幅     | float | Y        | 单位: 点   |
| 人民币/南非兰特_中间价       | float | Y        | –          |
| 人民币/南非兰特_涨跌幅       | float | Y        | 单位: 点   |
| 人民币/韩元_中间价           | float | Y        | –          |
| 人民币/韩元_涨跌幅           | float | Y        | 单位: 点   |
| 人民币/阿联酋迪拉姆_中间价   | float | Y        | –          |
| 人民币/阿联酋迪拉姆_涨跌幅   | float | Y        | 单位: 点   |
| 人民币/沙特里亚尔_中间价     | float | Y        | –          |
| 人民币/沙特里亚尔_涨跌幅     | float | Y        | 单位: 点   |
| 人民币/匈牙利福林_中间价     | float | Y        | –          |
| 人民币/匈牙利福林_涨跌幅     | float | Y        | 单位: 点   |
| 人民币/波兰兹罗提_中间价     | float | Y        | –          |
| 人民币/波兰兹罗提_涨跌幅     | float | Y        | 单位: 点   |
| 人民币/丹麦克朗_中间价       | float | Y        | –          |
| 人民币/丹麦克朗_涨跌幅       | float | Y        | 单位: 点   |
| 人民币/瑞典克朗_中间价       | float | Y        | –          |
| 人民币/瑞典克朗_涨跌幅       | float | Y        | 单位: 点   |
| 人民币/丹麦克朗_中间价       | float | Y        | –          |
| 人民币/丹麦克朗_涨跌幅       | float | Y        | 单位: 点   |
| 人民币/挪威克朗_中间价       | float | Y        | –          |
| 人民币/挪威克朗_涨跌幅       | float | Y        | 单位: 点   |
| 人民币/土耳其里拉_中间价     | float | Y        | –          |
| 人民币/土耳其里拉_涨跌幅     | float | Y        | 单位: 点   |
| 人民币/墨西哥比索_中间价     | float | Y        | –          |
| 人民币/墨西哥比索_涨跌幅     | float | Y        | 单位: 点   |
| 人民币/泰铢_中间价           | float | Y        | –          |
| 人民币/泰铢_涨跌幅           | float | Y        | 单位: 点   |

接口示例

```
import PPshare as PP
macro_china_rmb_df = PP.macro_china_rmb()
print(macro_china_rmb_df)
```

数据示例

macro_china_rmb_df:

```
            美元/人民币_中间价  美元/人民币_涨跌幅  ...  人民币/泰铢_定价  人民币/泰铢_涨跌幅
2018-02-06      6.3072         NaN  ...     5.0191         NaN
2018-02-07      6.2882      -190.0  ...     5.0178       -13.0
2018-02-08      6.2822       -60.0  ...     5.0429       251.0
2018-02-09      6.3194       372.0  ...     5.0406       -23.0
2018-02-12      6.3001      -193.0  ...     5.0310       -96.0
                ...         ...  ...        ...         ...
2020-04-16      7.0714       312.0  ...     4.6260      -156.0
2020-04-17      7.0718         4.0  ...     4.6083      -177.0
2020-04-20      7.0657       -61.0  ...     4.5977      -106.0
2020-04-21      7.0752        95.0  ...     4.5929       -48.0
2020-04-22      7.0903       151.0  ...     4.5843       -86.0
```

#### 深圳融资融券报告

接口: macro_china_market_margin_sz

目标地址: https://datacenter.jin10.com/reportType/dc_market_margin_sz

描述: 获取深圳融资融券报告, 数据区间从20100331-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称             | 类型  | 默认显示 | 描述      |
| :--------------- | :---- | :------- | :-------- |
| 日期             | str   | Y        | 日期-索引 |
| 融资买入额(元)   | float | Y        | –         |
| 融资余额(元)     | float | Y        | –         |
| 融券卖出量(股)   | float | Y        | –         |
| 融券余量(股)     | float | Y        | –         |
| 融券余额(元)     | float | Y        | –         |
| 融资融券余额(元) | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_china_market_margin_sz_df = PP.macro_china_market_margin_sz()
print(macro_china_market_margin_sz_df)
```

数据示例

```
               融资买入额(元)       融资余额(元)  融券卖出量(股)    融券余量(股)     融券余额(元)  \
2010-03-31       684569        670796      4000       3900       70895
2010-04-08      6713260      14467758      2100       3100       56023
2010-04-09      9357095      19732998      6700       5400      108362
2010-04-12     10406563      24813027      2200       1000        8100
2010-04-15     16607172      47980287      4200       5200       97676
                 ...           ...       ...        ...         ...
2019-12-12  25190412075  423457288662  29769255  209557883  2504593151
2019-12-13  29636811209  423422868505  32820867  206092170  2509424768
2019-12-16  39166060634  428851154451  44000215  217123568  2647520178
2019-12-17  46930557203  433966722200  40492711  220945538  2750371397
2019-12-18  41043515833  438511398249  39150376  224554586  2761303194
               融资融券余额(元)
2010-03-31        741691
2010-04-08      14523781
2010-04-09      19841360
2010-04-12      24821127
2010-04-15      48077963
                  ...
2019-12-12  425961881813
2019-12-13  425932293273
2019-12-16  431498674629
2019-12-17  436717093597
2019-12-18  441272701443
```

#### 上海融资融券报告

接口: macro_china_market_margin_sh

目标地址: https://datacenter.jin10.com/reportType/dc_market_margin_sse

描述: 获取上海融资融券报告, 数据区间从20100331-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称         | 类型  | 默认显示 | 描述         |
| :----------- | :---- | :------- | :----------- |
| 日期         | str   | Y        | 日期-索引    |
| 融资余额     | float | Y        | 注意单位：元 |
| 融资买入额   | float | Y        | 注意单位：元 |
| 融券余量     | float | Y        | 注意单位：股 |
| 融券余额     | float | Y        | 注意单位：元 |
| 融券卖出量   | float | Y        | 注意单位：股 |
| 融资融券余额 | float | Y        | 注意单位：元 |

接口示例

```
import PPshare as PP
macro_china_market_margin_sh_df = PP.macro_china_market_margin_sh()
print(macro_china_market_margin_sh_df)
```

数据示例

```
                    融资余额         融资买入额  ...        融券卖出量        融资融券余额
2010-03-31  5.824813e+06  5.866316e+06  ...       3100.0  5.848955e+06
2010-04-01  6.842114e+06  1.054024e+06  ...          0.0  6.859439e+06
2010-04-02  6.762781e+06  2.075160e+05  ...          0.0  6.774710e+06
2010-04-06  1.009124e+07  3.329461e+06  ...          0.0  1.010151e+07
2010-04-07  2.508683e+07  1.514140e+07  ...       1400.0  2.512524e+07
                  ...           ...  ...          ...           ...
2020-08-17  7.320815e+11  6.532228e+10  ...  311910304.0  7.735001e+11
2020-08-18  7.371393e+11  5.588143e+10  ...  236068903.0  7.784736e+11
2020-08-19  7.381023e+11  5.470145e+10  ...  302792889.0  7.794299e+11
2020-08-20  7.368085e+11  3.763784e+10  ...  203660295.0  7.778967e+11
2020-08-21  7.352210e+11  3.599241e+10  ...  196118235.0  7.765762e+11
```

#### 上海黄金交易所报告

接口: macro_china_au_report

目标地址: https://datacenter.jin10.com/reportType/dc_sge_report

描述: 获取上海黄金交易所报告, 数据区间从20140905-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型  | 默认显示 | 描述      |
| :--------- | :---- | :------- | :-------- |
| 日期       | str   | Y        | 日期-索引 |
| 商品       | float | Y        | –         |
| 开盘价     | float | Y        | –         |
| 最高价     | float | Y        | –         |
| 最低价     | float | Y        | –         |
| 收盘价     | float | Y        | –         |
| 涨跌       | float | Y        | –         |
| 涨跌幅     | float | Y        | –         |
| 加权平均价 | float | Y        | –         |
| 成交量     | float | Y        | –         |
| 成交金额   | float | Y        | –         |
| 持仓量     | float | Y        | –         |
| 交收方向   | float | Y        | –         |
| 交收量     | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_china_au_report_df = PP.macro_china_au_report()
print(macro_china_au_report_df)
```

数据示例

```
                  商品      开盘价      最高价  ...          持仓量   交收方向    交收量
日期                                      ...                           
2014-09-05    Pt9995   293.50   293.50  ...          NaN           NaN
2014-09-05   Ag(T+D)  4159.00  4197.00  ...  5.25224e+06   空支付多    NaN
2014-09-05   Ag99.99  4218.00  4218.00  ...          322           NaN
2014-09-05   Au(T+D)   250.52   252.48  ...       144574   多支付空  11848
2014-09-05  mAu(T+D)   250.87   252.50  ...       130808   多支付空  23644
              ...      ...      ...  ...          ...    ...    ...
2020-04-22  NYAuTN12   379.80   385.00  ...        63446           NaN
2020-04-22    PGC30g   375.83   379.50  ...          NaN           NaN
2020-04-22   Pt99.95   173.30   181.96  ...          NaN           NaN
2020-04-22   Au99.99   372.00   374.45  ...          NaN           NaN
2020-04-22   Ag(T+D)  3554.00  3620.00  ...  1.06485e+07  多支付给空  67050
```

### 中国电煤价格指数

#### 全国综合电煤价格指数

接口: macro_china_ctci

目标地址: http://jgjc.ndrc.gov.cn/dmzs.aspx?clmId=741

描述: 获取中国电煤价格指数-全国综合电煤价格指数图, 20140101-至今的所有历史数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称  | 类型  | 默认显示 | 描述 |
| :---- | :---- | :------- | :--- |
| date  | str   | Y        | 日期 |
| value | float | Y        | –    |

接口示例

```
import PPshare as PP
macro_china_ctci_df = PP.macro_china_ctci()
print(macro_china_ctci_df)
```

数据示例

```
        date   value
0   20140201  495.79
1   20140301  484.88
2   20140401  470.61
3   20140501  461.02
4   20140601  454.23
5   20140701  443.48
6   20140801  430.77
7   20140901  417.76
8   20141001  412.30
9   20141101  415.58
67  20190901  486.79
68  20191001  489.88
69  20191101  492.01
70  20191201  483.09
```

#### 各价区电煤价格指数

接口: macro_china_ctci_detail

目标地址: http://jgjc.ndrc.gov.cn/dmzs.aspx?clmId=741

描述: 获取中国电煤价格指数-各价区电煤价格指数, 具体年具体月的历史数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述 |
| :--- | :---- | :------- | :--- |
| 环比 | str   | Y        | 日期 |
| 上期 | float | Y        | –    |
| 同比 | float | Y        | –    |
| 本期 | float | Y        | –    |

接口示例

```
import PPshare as PP
macro_china_ctci_detail_df = PP.macro_china_ctci_detail()
print(macro_china_ctci_detail_df)
```

数据示例

```
          环比      上期      同比      本期
全国     -1.81  492.01   -7.11  483.09
天津市    -1.72  482.96  -12.83  474.65
冀北      0.56  453.80   -6.82  456.32
冀南     -0.89  471.71   -8.22  467.51
山西省    -2.43  344.46  -11.06  336.08
蒙西      0.51  292.07    4.31  293.56
蒙东     -0.04  274.00   11.53  273.90
辽宁省    -1.25  545.90   -6.91  539.09
吉林省    -0.97  556.83   -5.14  551.43
黑龙江省   -0.27  540.51   -0.84  539.07
上海市    -1.43  519.98  -10.75  512.55
江苏省    -0.85  535.04   -9.17  530.51
浙江省    -0.29  571.41   -2.57  569.78
安徽省    -1.12  574.23   -8.08  567.78
福建省    -1.01  532.02  -13.31  526.62
江西省     0.41  649.13   -5.46  651.79
山东省    -1.62  547.18  -12.24  538.33
河南省    -2.10  499.34  -18.86  488.87
湖北省    -0.75  583.65  -10.48  579.30
湖南省    -0.55  616.56   -9.44  613.18
广东省    -1.38  562.91   -8.65  555.12
广西自治区   0.48  682.33   -6.23  685.59
海南省     3.02  505.27   -4.46  520.53
重庆市    -5.14  613.98   -4.42  582.43
四川省    -0.10  570.25   -8.56  569.70
贵州省     0.85  488.61   -1.55  492.78
云南省    -3.38  457.68  -19.56  442.19
陕西省    -2.02  393.92  -10.11  385.95
甘肃省     0.30  463.03   -9.62  464.42
青海省     2.49  529.57    2.57  542.76
宁夏自治区  -2.46  362.00   -3.44  353.08
新疆自治区  -0.33  258.74    0.09  257.89
```

#### 历史电煤价格指数

接口: macro_china_ctci_detail_hist

目标地址: http://jgjc.ndrc.gov.cn/dmzs.aspx?clmId=741

描述: 获取中国电煤价格指数-历史电煤价格指数, 具体年的历史数据

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述                         |
| :--- | :--- | :--- | :--------------------------- |
| year | str  | Y    | year=”2018″, 从 2014-2019 年 |

输出参数

| 名称 | 类型  | 默认显示 | 描述 |
| :--- | :---- | :------- | :--- |
| 地区 | str   | Y        | 日期 |
| 月份 | float | Y        | –    |
| —    | —     | —        | –    |
| 月份 | float | Y        | –    |

接口示例

```
import PPshare as PP
macro_china_ctci_detail_hist_df = PP.macro_china_ctci_detail_hist(year="2018")
print(macro_china_ctci_detail_hist_df)
```

数据示例

```
       地区 2018年01月 2018年02月 2018年03月 2018年04月 2018年05月 2018年06月 2018年07月  \
0      全国   549.12   567.21   546.58   522.78   515.39   528.57   532.53   
1     天津市   561.23   583.85   585.94   551.54   524.41   528.97   540.94   
2      冀北   510.57   534.05   517.08   474.42   453.55   461.06   467.58   
3      冀南   530.74   540.18   532.12   514.28   503.97   497.25   493.77   
4     山西省   393.98   408.07   396.38   370.90   364.30   374.28   376.38   
5      蒙西   301.63   301.46   292.33   276.21   275.37   286.48   281.19   
6      蒙东   230.38   227.76   242.35   246.00   248.76   250.37   242.71   
7     辽宁省   563.70   563.07   558.31   538.79   530.65   537.27   553.26   
8     吉林省   543.02   548.27   535.59   513.15   506.41   522.02   544.06   
9    黑龙江省   519.31   522.83   495.48   477.43   470.00   472.85   483.66   
10    上海市   645.34   643.98   647.36   600.11   578.45   584.03   602.29   
11    江苏省   644.64   651.17   624.19   588.70   576.74   583.94   589.85   
12    浙江省   636.39   637.83   625.57   592.52   609.26   618.92   586.79   
13    安徽省   647.37   661.77   635.92   604.14   587.82   592.20   603.95   
14    福建省   656.82   650.69   649.71   613.20   573.53   600.93   618.63   
15    江西省   751.64   765.61   739.68   691.16   662.62   677.83   690.77   
16    山东省   628.53   649.27   634.08   592.92   573.53   586.10   594.91   
17    河南省   613.92   631.25   621.77   594.66   593.18   601.12   608.91   
18    湖北省   677.92   703.40   686.57   632.80   610.36   621.44   642.14   
19    湖南省   718.96   737.04   719.14   668.50   640.31   649.64   678.89   
20    广东省   651.36   657.91   649.06   634.28   630.47   640.65   639.35   
21  广西自治区   756.91   754.45   757.12   745.06   716.98   721.96   705.18   
22    海南省   614.98   625.04   637.07   593.45   525.72   565.77   587.75   
23    重庆市   619.37   629.52   620.51   598.80   571.14   570.81   611.41   
24    四川省   648.10   654.02   651.93   619.14   601.58   605.26   612.76   
25    贵州省   518.60   505.77   500.04   497.16   493.63   486.77   489.90   
26    云南省   467.09   388.74   421.98   447.52   482.76   513.48   510.29   
27    陕西省   463.31   478.76   465.24   442.26   435.63   436.38   428.95   
28    甘肃省   505.24   509.11   500.83   489.16   487.85   468.13   464.82   
29    青海省   544.92   549.28   548.58   536.46   524.28   510.17   516.74   
30  宁夏自治区   400.22   398.22   391.12   370.74   370.42   382.99   378.98   
31  新疆自治区   254.34   269.80   250.79   235.72   238.54   245.57   234.11   
   2018年08月 2018年09月 2018年10月 2018年11月 2018年12月  
0    522.40   522.16   523.47   520.09   522.20  
1    544.64   541.17   548.94   544.48   541.99  
2    466.16   471.52   485.16   489.72   490.16  
3    500.48   499.84   505.87   509.36   513.28  
4    371.11   371.23   378.49   377.88   375.88  
5    273.10   282.96   286.80   281.42   284.51  
6    228.15   242.71   251.47   245.58   250.44  
7    563.19   573.65   577.80   579.09   563.81  
8    573.05   588.78   592.40   581.29   568.79  
9    520.07   539.22   537.95   543.64   535.24  
10   607.19   585.45   574.96   574.26   555.67  
11   583.12   577.07   582.36   584.04   576.59  
12   575.81   583.42   587.16   584.79   587.46  
13   599.81   598.09   605.65   617.72   610.69  
14   609.29   604.87   601.59   607.44   608.93  
15   690.62   691.52   695.14   689.43   678.53  
16   590.17   588.25   596.28   613.43   616.25  
17   605.13   595.11   597.53   602.47   599.72  
18   638.43   625.53   629.82   647.10   653.36  
19   677.36   671.32   678.18   677.13   668.14  
20   629.72   626.41   616.66   607.70   612.66  
21   712.84   724.77   729.57   731.13   716.45  
22   587.61   590.36   558.11   544.82   534.33  
23   594.85   597.89   608.23   609.34   618.87  
24   622.66   608.49   601.19   623.04   642.92  
25   502.76   503.33   498.03   500.56   513.44  
26   530.24   540.00   541.58   549.68   569.41  
27   412.37   418.11   420.12   429.35   434.98  
28   454.77   482.04   502.39   513.85   501.55  
29   522.63   516.94   517.64   529.17   546.25  
30   374.67   376.04   372.16   365.67   368.41  
31   229.33   251.85   254.20   257.66   265.38  
```

## 美国宏观

### 经济状况

#### 美国GDP

接口: macro_usa_gdp_monthly

目标地址: https://datacenter.jin10.com/reportType/dc_usa_gdp

描述: 获取美国国内生产总值(GDP)报告, 数据区间从20080228-至今

限量: 单次返回某一个所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_gdp_monthly_se = PP.macro_usa_gdp_monthly()
print(macro_usa_gdp_monthly_se.name)
print(macro_usa_gdp_monthly_se)
```

数据示例

macro_usa_gdp_monthly_se.name

```
gdp
```

macro_usa_gdp_monthly_se: pandas.Series

```
2008-02-28    0.6
2008-03-27    0.6
2008-04-30    0.9
2008-06-26      1
2008-07-31    1.9
             ... 
2019-09-26      2
2019-10-30      2
2019-11-27      2
2019-12-20    2.1
2020-01-30      0
```

### 物价水平

#### 美国CPI月率报告

接口: macro_usa_cpi_monthly

目标地址: https://datacenter.jin10.com/reportType/dc_usa_cpi

描述: 获取美国CPI月率报告, 数据区间从19700101-至今

限量: 单次返回某一个所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_cpi_monthly_se = PP.macro_usa_cpi_monthly()
print(macro_usa_cpi_monthly_se.name)
print(macro_usa_cpi_monthly_se)
```

数据示例

macro_usa_cpi_monthly_se.name

```
cpi_monthly
```

macro_usa_cpi_monthly_se: pandas.Series

```
1970-01-01    0.5
1970-02-01    0.5
1970-03-01    0.5
1970-04-01    0.5
1970-05-01    0.5
             ... 
2019-09-12    0.1
2019-10-10    0.1
2019-11-13    0.4
2019-12-11    0.3
2020-01-14      0
```

#### 美国核心CPI月率报告

接口: macro_usa_core_cpi_monthly

目标地址: https://datacenter.jin10.com/reportType/dc_usa_core_cpi

描述: 获取美国核心CPI月率报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_core_cpi_monthly_se = PP.macro_usa_core_cpi_monthly()
print(macro_usa_core_cpi_monthly_se.name)
print(macro_usa_core_cpi_monthly_se)
```

数据示例

macro_usa_core_cpi_monthly_se.name

```
usa_core_cpi
```

macro_usa_core_cpi_monthly_se: pandas.Series

```
1970-01-01    0.5
1970-02-01    0.5
1970-03-01    0.5
1970-04-01    0.8
1970-05-01    0.7
             ... 
2019-09-12    0.3
2019-10-10    0.1
2019-11-13    0.2
2019-12-11    0.2
2020-01-14      0
```

#### 美国个人支出月率报告

接口: macro_usa_personal_spending

目标地址: https://datacenter.jin10.com/reportType/dc_usa_personal_spending

描述: 获取美国个人支出月率报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_personal_spending_se = PP.macro_usa_personal_spending()
print(macro_usa_personal_spending_se.name)
print(macro_usa_personal_spending_se)
```

数据示例

macro_usa_personal_spending_se.name

```
usa_personal_spending
```

macro_usa_personal_spending_se: pandas.Series

```
1970-01-01    0.4
1970-02-01      1
1970-03-01    0.8
1970-04-01   -0.3
1970-05-01    0.6
             ... 
2019-09-27    0.2
2019-10-31    0.2
2019-11-27    0.3
2019-12-20    0.4
2020-01-31      0
```

#### 美国零售销售月率报告

接口: macro_usa_retail_sales

目标地址: https://datacenter.jin10.com/reportType/dc_usa_retail_sales

描述: 获取美国零售销售月率报告, 数据区间从19920301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_retail_sales_se = PP.macro_usa_retail_sales()
print(macro_usa_retail_sales_se.name)
print(macro_usa_retail_sales_se)
```

数据示例

macro_usa_retail_sales_se.name

```
usa_retail_sales
```

macro_usa_retail_sales_se: pandas.Series

```
1992-03-01     0.1
1992-04-01    -0.3
1992-05-01     0.6
1992-06-01     0.5
1992-07-01     0.3
              ... 
2019-09-13     0.6
2019-10-16    -0.3
2019-11-15     0.4
2019-12-13     0.2
2020-01-16       0
```

#### 美国进口物价指数报告

接口: macro_usa_import_price

目标地址: https://datacenter.jin10.com/reportType/dc_usa_import_price

描述: 获取美国进口物价指数报告, 数据区间从19890201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_import_price_se = PP.macro_usa_import_price()
print(macro_usa_import_price_se.name)
print(macro_usa_import_price_se)
```

数据示例

macro_usa_import_price_se.name

```
usa_import_price
```

macro_usa_import_price_se: pandas.Series

```
1989-02-01       2
1989-03-01    -0.5
1989-04-01     0.8
1989-05-01     0.8
1989-06-01     0.7
              ... 
2019-09-13    -0.2
2019-10-11     0.1
2019-11-15    -0.5
2019-12-13     0.2
2020-01-16       0
```

#### 美国出口价格指数报告

接口: macro_usa_export_price

目标地址: https://datacenter.jin10.com/reportType/dc_usa_export_price

描述: 获取美国出口价格指数报告, 数据区间从19890201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_export_price_se = PP.macro_usa_export_price()
print(macro_usa_export_price_se.name)
print(macro_usa_export_price_se)
```

数据示例

macro_usa_export_price_se.name

```
usa_export_price
```

macro_usa_export_price_se: pandas.Series

```
1989-02-01     1.2
1989-03-01    -0.3
1989-04-01     0.6
1989-05-01    -0.2
1989-06-01     0.4
              ... 
2019-09-13    -0.6
2019-10-11    -0.2
2019-11-15    -0.1
2019-12-13     0.2
2020-01-16       0
```

### 劳动力市场

#### LMCI

接口: macro_usa_lmci

目标地址: https://datacenter.jin10.com/reportType/dc_usa_lmci

描述: 获取美联储劳动力市场状况指数报告, 数据区间从20141006-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_lmci_se = PP.macro_usa_lmci()
print(macro_usa_lmci_se.name)
print(macro_usa_lmci_se)
```

数据示例

macro_usa_lmci_se.name

```
lmci
```

macro_usa_lmci_se: pandas.Series

```
2014-10-06      4
2014-11-10    3.9
2014-12-08    5.5
2015-01-12    7.3
2015-02-09    4.9
             ... 
2017-05-08    3.5
2017-06-05      0
2017-06-16    3.3
2017-07-10    1.5
2017-08-07      0
```

#### 失业率

##### 美国失业率报告

接口: macro_usa_unemployment_rate

目标地址: https://datacenter.jin10.com/reportType/dc_usa_unemployment_rate

描述: 获取美国失业率报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_unemployment_rate_se = PP.macro_usa_unemployment_rate()
print(macro_usa_unemployment_rate_se.name)
print(macro_usa_unemployment_rate_se)
```

数据示例

macro_usa_unemployment_rate_se.name

```
unemployment_rate
```

macro_usa_unemployment_rate_se: pandas.Series

```
1970-01-01    3.5
1970-02-01    3.9
1970-03-01    4.2
1970-04-01    4.4
1970-05-01    4.6
             ... 
2019-09-06    3.7
2019-10-04    3.5
2019-11-01    3.6
2019-12-06    3.5
2020-01-10    3.5
```

##### 美国挑战者企业裁员人数报告

接口: macro_usa_job_cuts

目标地址: https://datacenter.jin10.com/reportType/dc_usa_job_cuts

描述: 获取美国挑战者企业裁员人数报告, 数据区间从19940201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_job_cuts_se = PP.macro_usa_job_cuts()
print(macro_usa_job_cuts_se.name)
print(macro_usa_job_cuts_se)
```

数据示例

macro_usa_job_cuts_se.name

```
usa_job_cuts
```

macro_usa_job_cuts_se: pandas.Series

```
1994-02-01     10.89
1994-03-01      3.46
1994-04-01       4.9
1994-05-01      3.61
1994-06-01      3.63
               ...  
2019-10-31    5.0275
2019-12-05    4.4569
2020-01-02    3.2843
2020-01-09         0
2020-02-06         0
```

#### 就业人口

##### 美国非农就业人数报告

接口: macro_usa_non_farm

目标地址: https://datacenter.jin10.com/reportType/dc_nonfarm_payrolls

描述: 获取美国非农就业人数报告, 数据区间从19700102-至今

限量: 单次返回某一个所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型  | 默认显示 | 描述       |
| :--------- | :---- | :------- | :--------- |
| 日期       | str   | Y        | 日期-索引  |
| 今值(万人) | float | Y        | 今值(万人) |

接口示例

```
import PPshare as PP
macro_usa_non_farm_se = PP.macro_usa_non_farm()
print(macro_usa_non_farm_se.name)
print(macro_usa_non_farm_se)
```

数据示例

macro_usa_non_farm_se.name

```
non_farm
```

macro_usa_non_farm_se: pandas.Series

```
1970-01-02    15.3
1970-02-06    -6.4
1970-03-06    12.8
1970-04-03    14.8
1970-05-01   -10.4
              ...
2019-07-05    19.3
2019-08-02    15.9
2019-09-06    16.8
2019-10-04    13.6
2019-11-01       0
```

##### 美国ADP就业人数报告

接口: macro_usa_adp_employment

目标地址: https://datacenter.jin10.com/reportType/dc_adp_nonfarm_employment

描述: 获取美国ADP就业人数报告, 数据区间从20010601-至今

限量: 单次返回某一个所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称       | 类型  | 默认显示 | 描述       |
| :--------- | :---- | :------- | :--------- |
| 日期       | str   | Y        | 日期-索引  |
| 今值(万人) | float | Y        | 今值(万人) |

接口示例

```
import PPshare as PP
macro_usa_adp_employment_se = PP.macro_usa_adp_employment()
print(macro_usa_adp_employment_se.name)
print(macro_usa_adp_employment_se)
```

数据示例

macro_usa_adp_employment_se.name

```
adp
```

macro_usa_adp_employment_se: pandas.Series

```
2001-06-01   -17.5
2001-07-01     -23
2001-08-01   -20.3
2001-09-01   -24.6
2001-10-01   -26.1
              ... 
2019-09-05    15.7
2019-10-02     9.3
2019-10-30    12.1
2019-12-04    12.4
2020-01-08    20.2
```

#### 消费者收入与支出

##### 美国核心PCE物价指数年率报告

接口: macro_usa_core_pce_price

目标地址: https://datacenter.jin10.com/reportType/dc_usa_core_pce_price

描述: 获取美国核心PCE物价指数年率报告, 数据区间从19700101-至今

限量: 单次返回某一个所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_core_pce_price_se = PP.macro_usa_core_pce_price()
print(macro_usa_core_pce_price_se.name)
print(macro_usa_core_pce_price_se)
```

数据示例

macro_usa_core_pce_price_se.name

```
core_pce_price
```

macro_usa_core_pce_price_se: pandas.Series

```
1970-01-01    4.8
1970-02-01    4.7
1970-03-01    4.8
1970-04-01    4.7
1970-05-01    4.7
             ... 
2019-09-27    1.8
2019-10-31    1.7
2019-11-27    1.7
2019-12-20    1.6
2020-01-31      0
```

##### 美国实际个人消费支出季率初值报告

接口: macro_usa_real_consumer_spending

目标地址: https://datacenter.jin10.com/reportType/dc_usa_real_consumer_spending

描述: 获取美国实际个人消费支出季率初值报告, 数据区间从20131107-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_real_consumer_spending_se = PP.macro_usa_real_consumer_spending()
print(macro_usa_real_consumer_spending_se.name)
print(macro_usa_real_consumer_spending_se)
```

数据示例

macro_usa_real_consumer_spending_se.name

```
usa_real_consumer_spending
```

macro_usa_real_consumer_spending_se: pandas.Series

```
2013-11-07    1.5
2013-12-05    1.4
2013-12-20      2
2014-01-30    3.3
2014-02-28    2.6
             ... 
2019-09-26    4.6
2019-10-30    2.9
2019-11-27    2.9
2019-12-20    3.2
2020-01-30      0
```

### 贸易状况

#### 美国贸易帐报告

接口: macro_usa_trade_balance

目标地址: https://datacenter.jin10.com/reportType/dc_usa_trade_balance

描述: 获取美国贸易帐报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_trade_balance_se = PP.macro_usa_trade_balance()
print(macro_usa_trade_balance_se.name)
print(macro_usa_trade_balance_se)
```

数据示例

macro_usa_trade_balance_se.name

```
usa_trade_balance
```

macro_usa_trade_balance_se: pandas.Series

```
1970-01-01       2
1970-02-01       1
1970-03-01       2
1970-04-01       1
1970-05-01       1
              ... 
2019-09-04    -540
2019-10-04    -550
2019-11-05    -511
2019-12-05    -469
2020-01-07    -431
```

#### 美国经常帐报告

接口: macro_usa_current_account

目标地址: https://datacenter.jin10.com/reportType/dc_usa_current_account

描述: 获取美国经常帐报告, 数据区间从20080317-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_current_account_se = PP.macro_usa_current_account()
print(macro_usa_current_account_se.name)
print(macro_usa_current_account_se)
```

数据示例

macro_usa_current_account_se.name

```
usa_current_account
```

macro_usa_current_account_se: pandas.Series

```
2008-03-17    -1730
2008-06-17    -1760
2008-09-17    -1830
2008-12-17    -1740
2009-03-18    -1549
              ...  
2019-03-21        0
2019-03-27    -1439
2019-06-20    -1362
2019-09-19    -1252
2019-12-19    -1241
```

### 产业指标

#### 制造业

##### 贝克休斯钻井报告

接口: macro_usa_rig_count

目标地址: https://datacenter.jin10.com/reportType/dc_rig_count_summary

描述: 获取贝克休斯钻井报告, 数据区间从19870717-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                  | 类型  | 默认显示 | 描述      |
| :-------------------- | :---- | :------- | :-------- |
| 日期                  | str   | Y        | 日期-索引 |
| 钻井总数_钻井数       | float | Y        | –         |
| 钻井总数_变化         | float | Y        | –         |
| 美国石油钻井_钻井数   | float | Y        | –         |
| 美国石油钻井_变化     | float | Y        | –         |
| 混合钻井_钻井数       | float | Y        | –         |
| 混合钻井_变化         | float | Y        | –         |
| 美国天然气钻井_钻井数 | float | Y        | –         |
| 美国天然气钻井_变化   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_rig_count_df = PP.macro_usa_rig_count()
print(macro_usa_rig_count_df)
```

数据示例

```
            钻井总数_钻井数  钻井总数_变化  美国石油钻井_钻井数  ...  混合钻井_变化  美国天然气钻井_钻井数  美国天然气钻井_变化
2020-04-03      66.4     -6.4        56.2  ...      0.0         10.0        -0.2
2020-03-27      72.8     -4.4        62.4  ...      0.0         10.2        -0.4
2020-03-20      77.2     -2.0        66.4  ...      0.0         10.6        -0.1
2020-03-13      79.2     -0.1        68.3  ...      0.0         10.7        -0.2
2020-03-06      79.3      0.3        68.2  ...      0.0         10.9        -0.1
              ...      ...         ...  ...      ...          ...         ...
1987-08-14      99.8      1.5        62.0  ...      0.5         35.2         0.3
1987-08-07      98.3      1.0        61.3  ...     -0.1         34.9         0.3
1987-07-31      97.3      5.6        60.5  ...      0.1         34.6         1.5
1987-07-24      91.7     -0.5        56.5  ...     -0.5         33.1        -0.6
1987-07-17      92.2      NaN        55.9  ...      NaN         33.7         NaN
```

##### 美国生产者物价指数(PPI)报告

接口: macro_usa_ppi

目标地址: https://datacenter.jin10.com/reportType/dc_usa_ppi

描述: 获取美国生产者物价指数(PPI)报告, 数据区间从20080226-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_ppi_se = PP.macro_usa_ppi()
print(macro_usa_ppi_se.name)
print(macro_usa_ppi_se)
```

数据示例

macro_usa_ppi_se.name

```
usa_ppi
```

macro_usa_ppi_se: pandas.Series

```
2008-02-26       1
2008-03-18     0.3
2008-04-15     1.1
2008-05-20     0.2
2008-06-17     1.4
              ... 
2019-09-11     0.1
2019-10-08    -0.3
2019-11-14     0.4
2019-12-12       0
2020-01-15       0
```

##### 美国核心生产者物价指数(PPI)报告

接口: macro_usa_core_ppi

目标地址: https://datacenter.jin10.com/reportType/dc_usa_core_ppi

描述: 获取美国核心生产者物价指数(PPI)报告, 数据区间从20080318-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_core_ppi_se = PP.macro_usa_core_ppi()
print(macro_usa_core_ppi_se.name)
print(macro_usa_core_ppi_se)
```

数据示例

macro_usa_core_ppi_se.name

```
usa_core_ppi
```

macro_usa_core_ppi_se: pandas.Series

```
2008-03-18     0.5
2008-04-15     0.2
2008-05-20     0.4
2008-06-17     0.2
2008-08-19     0.7
              ... 
2019-09-11     0.3
2019-10-08    -0.3
2019-11-14     0.3
2019-12-12    -0.2
2020-01-15       0
```

##### 美国API原油库存报告

接口: macro_usa_api_crude_stock

目标地址: https://datacenter.jin10.com/reportType/dc_usa_api_crude_stock

描述: 获取美国API原油库存报告, 数据区间从20120328-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_api_crude_stock_se = PP.macro_usa_api_crude_stock()
print(macro_usa_api_crude_stock_se.name)
print(macro_usa_api_crude_stock_se)
```

数据示例

macro_usa_api_crude_stock_se.name

```
usa_api_crude_stock
```

macro_usa_api_crude_stock_se: pandas.Series

```
2012-03-28     360.2
2012-04-04     784.8
2012-04-11     658.4
2012-04-18     340.9
2012-04-25     -98.5
               ...  
2019-12-27         0
2020-01-01         0
2020-01-02         0
2020-01-08    -594.5
2020-01-15         0
```

##### 美国Markit制造业PMI初值报告

接口: macro_usa_pmi

目标地址: https://datacenter.jin10.com/reportType/dc_usa_pmi

描述: 获取美国Markit制造业PMI初值报告, 数据区间从20120601-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_pmi_se = PP.macro_usa_pmi()
print(macro_usa_pmi_se.name)
print(macro_usa_pmi_se)
```

数据示例

macro_usa_pmi_se.name

```
usa_pmi
```

macro_usa_pmi_se: pandas.Series

```
2012-06-01    52.9
2012-07-02    52.5
2012-07-24    51.8
2012-08-01    51.4
2012-08-23    51.9
              ... 
2019-11-22    52.2
2019-12-02    52.6
2019-12-16    52.6
2020-01-02    52.4
2020-01-24       0
```

##### 美国ISM制造业PMI报告

接口: macro_usa_ism_pmi

目标地址: https://datacenter.jin10.com/reportType/dc_usa_ism_pmi

描述: 获取美国ISM制造业PMI报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_ism_pmi_se = PP.macro_usa_ism_pmi()
print(macro_usa_ism_pmi_se.name)
print(macro_usa_ism_pmi_se)
```

数据示例

macro_usa_ism_pmi_se.name

```
usa_ism_pmi
```

macro_usa_ism_pmi_se: pandas.Series

```
1970-01-01      52
1970-02-01    48.7
1970-03-01    47.4
1970-04-01    46.9
1970-05-01      45
              ... 
2019-09-03    49.1
2019-10-01    47.8
2019-11-01    48.3
2019-12-02    48.1
2020-01-03    47.2
```

#### 工业

##### 美国工业产出月率报告

接口: macro_usa_industrial_production

目标地址: https://datacenter.jin10.com/reportType/dc_usa_industrial_production

描述: 获取美国工业产出月率报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_industrial_production_se = PP.macro_usa_industrial_production()
print(macro_usa_industrial_production_se.name)
print(macro_usa_industrial_production_se)
```

数据示例

macro_usa_industrial_production_se.name

```
usa_industrial_production
```

macro_usa_industrial_production_se: pandas.Series

```
1970-01-01    -0.3
1970-02-01    -1.9
1970-03-01    -0.1
1970-04-01    -0.1
1970-05-01    -0.3
              ... 
2019-09-17     0.8
2019-10-17    -0.3
2019-11-15    -0.9
2019-12-17     1.1
2020-01-17       0
```

##### 美国耐用品订单月率报告

接口: macro_usa_durable_goods_orders

目标地址: https://datacenter.jin10.com/reportType/dc_usa_durable_goods_orders

描述: 获取美国耐用品订单月率报告, 数据区间从20080227-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_durable_goods_orders_se = PP.macro_usa_durable_goods_orders()
print(macro_usa_durable_goods_orders_se.name)
print(macro_usa_durable_goods_orders_se)
```

数据示例

macro_usa_durable_goods_orders_se.name

```
usa_durable_goods_orders
```

macro_usa_durable_goods_orders_se: pandas.Series

```
2008-02-27    -5.3
2008-03-26    -1.1
2008-04-24    -0.3
2008-05-28    -0.6
2008-06-25       0
              ... 
2019-10-24    -1.4
2019-11-27     0.2
2019-12-23    -2.1
2019-12-24       0
2020-01-28       0
```

##### 美国工厂订单月率报告

接口: macro_usa_factory_orders

目标地址: https://datacenter.jin10.com/reportType/dc_usa_factory_orders

描述: 获取美国工厂订单月率报告, 数据区间从19920401-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_factory_orders_se = PP.macro_usa_factory_orders()
print(macro_usa_factory_orders_se.name)
print(macro_usa_factory_orders_se)
```

数据示例

macro_usa_factory_orders_se.name

```
usa_factory_orders
```

macro_usa_factory_orders_se: pandas.Series

```
1992-04-01     4.6
1992-05-01     1.9
1992-06-01     1.6
1992-07-01    -0.5
1992-08-01    -0.9
              ... 
2019-09-05     1.4
2019-10-03    -0.1
2019-11-04    -0.8
2019-12-05     0.2
2020-01-07    -0.7
```

#### 服务业

##### 美国Markit服务业PMI初值报告

接口: macro_usa_services_pmi

目标地址: https://datacenter.jin10.com/reportType/dc_usa_services_pmi

描述: 获取美国Markit服务业PMI初值报告, 数据区间从20120701-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_services_pmi_se = PP.macro_usa_services_pmi()
print(macro_usa_services_pmi_se.name)
print(macro_usa_services_pmi_se)
```

数据示例

macro_usa_services_pmi_se.name

```
usa_services_pmi
```

macro_usa_services_pmi_se: pandas.Series

```
2012-07-01    53.2
2012-08-01    51.2
2012-09-01      52
2012-10-01    50.7
2012-11-01    52.7
              ... 
2019-11-22    50.6
2019-12-04    51.6
2019-12-16    51.6
2020-01-06    52.8
2020-01-24       0
```

##### 美国商业库存月率报告

接口: macro_usa_business_inventories

目标地址: https://datacenter.jin10.com/reportType/dc_usa_business_inventories

描述: 获取美国商业库存月率报告, 数据区间从19920301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```python
import PPshare as pp
macro_usa_business_inventories_se = pp.macro_usa_business_inventories()
print(macro_usa_business_inventories_se.name)
print(macro_usa_business_inventories_se)
```

数据示例

macro_usa_business_inventories_se.name

```
usa_business_inventories
```

macro_usa_business_inventories_se: pandas.Series

```
1992-03-01     0.2
1992-04-01     0.4
1992-05-01     0.3
1992-06-01    -0.1
1992-07-01     0.7
              ... 
2019-09-13     0.3
2019-10-16    -0.1
2019-11-15    -0.1
2019-12-13     0.2
2020-01-16       0
```

##### 美国ISM非制造业PMI报告

接口: macro_usa_ism_non_pmi

目标地址: https://datacenter.jin10.com/reportType/dc_usa_ism_non_pmi

描述: 获取美国ISM非制造业PMI报告, 数据区间从19970801-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```python
import PPshare as pp
macro_usa_ism_non_pmi_se = PP.macro_usa_ism_non_pmi()
print(macro_usa_ism_non_pmi_se.name)
print(macro_usa_ism_non_pmi_se)
```

数据示例

macro_usa_ism_non_pmi_se.name

```
usa_ism_non_pmi
```

macro_usa_ism_non_pmi_se: pandas.Series

```
1997-08-01    56.7
1997-09-01      62
1997-10-01    56.2
1997-11-01    56.6
1997-12-01    58.5
              ... 
2019-09-05    56.4
2019-10-03    52.6
2019-11-05    54.7
2019-12-04    53.9
2020-01-07    55.0
```

##### 美国NAHB房产市场指数报告

接口: macro_usa_nahb_house_market_index

目标地址: https://datacenter.jin10.com/reportType/dc_usa_nahb_house_market_index

描述: 获取美国NAHB房产市场指数报告, 数据区间从19850201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```python
import PPshare as pp
macro_usa_nahb_house_market_index_se = pp.macro_usa_nahb_house_market_index()
print(macro_usa_nahb_house_market_index_se.name)
print(macro_usa_nahb_house_market_index_se)
```

数据示例

macro_usa_nahb_house_market_index_se.name

```
usa_nahb_house_market_index
```

macro_usa_nahb_house_market_index_se: pandas.Series

```
1985-02-01    50
1985-03-01    58
1985-04-01    54
1985-05-01    49
1985-06-01    51
              ..
2019-09-17    68
2019-10-16    71
2019-11-18    71
2019-12-16    76
2020-01-16     0
```

#### 房地产

##### 美国NAHB房产市场指数报告

接口: macro_usa_nahb_house_market_index

目标地址: https://datacenter.jin10.com/reportType/dc_usa_nahb_house_market_index

描述: 获取美国NAHB房产市场指数报告, 数据区间从19850201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_nahb_house_market_index_se = PP.macro_usa_nahb_house_market_index()
print(macro_usa_nahb_house_market_index_se.name)
print(macro_usa_nahb_house_market_index_se)
```

数据示例

macro_usa_nahb_house_market_index_se.name

```
usa_nahb_house_market_index
```

macro_usa_nahb_house_market_index_se: pandas.Series

```
1985-02-01    50
1985-03-01    58
1985-04-01    54
1985-05-01    49
1985-06-01    51
              ..
2019-09-17    68
2019-10-16    71
2019-11-18    71
2019-12-16    76
2020-01-16     0
```

##### 美国新屋开工总数年化报告

接口: macro_usa_house_starts

目标地址: https://datacenter.jin10.com/reportType/dc_usa_house_starts

描述: 获取美国新屋开工总数年化报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_house_starts_se = PP.macro_usa_house_starts()
print(macro_usa_house_starts_se.name)
print(macro_usa_house_starts_se)
```

数据示例

macro_usa_house_starts_se.name

```
usa_house_starts
```

macro_usa_house_starts_se: pandas.Series

```
1970-01-01    132.7
1970-02-01    108.5
1970-03-01    130.5
1970-04-01    131.9
1970-05-01    126.4
              ...  
2019-09-18    138.6
2019-10-17    126.6
2019-11-19    132.3
2019-12-17    136.5
2020-01-17        0
```

##### 美国新屋销售总数年化报告

接口: macro_usa_new_home_sales

目标地址: https://datacenter.jin10.com/reportType/dc_usa_new_home_sales

描述: 获取美国新屋销售总数年化报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_new_home_sales_se = PP.macro_usa_new_home_sales()
print(macro_usa_new_home_sales_se.name)
print(macro_usa_new_home_sales_se)
```

数据示例

macro_usa_new_home_sales_se.name

```
usa_new_home_sales
```

macro_usa_new_home_sales_se: pandas.Series

```
1970-01-01    45.2
1970-02-01    46.1
1970-03-01    37.3
1970-04-01    38.9
1970-05-01    44.5
              ... 
2019-09-25    70.6
2019-10-24    73.8
2019-11-26      71
2019-12-23    71.9
2020-01-27       0
```

##### 美国营建许可总数报告

接口: macro_usa_building_permits

目标地址: https://datacenter.jin10.com/reportType/dc_usa_building_permits

描述: 获取美国营建许可总数报告, 数据区间从20080220-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_building_permits_se = PP.macro_usa_building_permits()
print(macro_usa_building_permits_se.name)
print(macro_usa_building_permits_se)
```

数据示例

macro_usa_building_permits_se.name

```
usa_building_permits
```

macro_usa_building_permits_se: pandas.Series

```
2008-02-20      106
2008-03-18       98
2008-04-16       93
2008-05-16       98
2008-06-17       98
              ...  
2019-09-18    142.5
2019-10-17    139.1
2019-11-19    146.1
2019-12-17    147.4
2020-01-17        0
```

##### 美国成屋销售总数年化报告

接口: macro_usa_exist_home_sales

目标地址: https://datacenter.jin10.com/reportType/dc_usa_exist_home_sales

描述: 获取美国成屋销售总数年化报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```python
import PPshare as PP
macro_usa_exist_home_sales_se = PP.macro_usa_exist_home_sales()
print(macro_usa_exist_home_sales_se.name)
print(macro_usa_exist_home_sales_se)
```

数据示例

macro_usa_exist_home_sales_se.name

```python
usa_exist_home_sales
```

macro_usa_exist_home_sales_se: pandas.Series

```
1970-01-01    160
1970-02-01    153
1970-03-01    146
1970-04-01    137
1970-05-01    151
             ... 
2019-09-19    550
2019-10-22    536
2019-11-21    544
2019-12-19    535
2020-01-22      0
```

##### 美国FHFA房价指数月率报告

接口: macro_usa_house_price_index

目标地址: https://datacenter.jin10.com/reportType/dc_usa_house_price_index

描述: 获取美国FHFA房价指数月率报告, 数据区间从19910301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```python
import PPshare as pp
macro_usa_house_price_index_se = PP.macro_usa_house_price_index()
print(macro_usa_house_price_index_se.name)
print(macro_usa_house_price_index_se)
```

数据示例

macro_usa_house_price_index_se.name

```
usa_house_price_index
```

macro_usa_house_price_index_se: pandas.Series

```
1991-03-01    0.5
1991-04-01      0
1991-05-01   -0.2
1991-06-01    0.1
1991-07-01    0.1
             ... 
2019-09-24    0.4
2019-10-23    0.2
2019-11-26    0.6
2019-12-31    0.2
2020-01-22      0
```

##### 美国S&P/CS20座大城市房价指数年率报告

接口: macro_usa_spcs20

目标地址: https://datacenter.jin10.com/reportType/dc_usa_spcs20

描述: 获取美国S&P/CS20座大城市房价指数年率报告, 数据区间从20010201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as pp
macro_usa_spcs20_se = pp.macro_usa_spcs20()
print(macro_usa_spcs20_se.name)
print(macro_usa_spcs20_se)
```

数据示例

macro_usa_spcs20_se.name

```
usa_spcs20
```

macro_usa_spcs20_se: pandas.Series

```
2001-02-01    12.4
2001-03-01    12.2
2001-04-01      12
2001-05-01    11.4
2001-06-01    10.5
              ... 
2019-09-24       2
2019-10-29       2
2019-11-26     2.1
2019-12-31     2.2
2020-01-28       0
```

##### 美国成屋签约销售指数月率报告

接口: macro_usa_pending_home_sales

目标地址: https://datacenter.jin10.com/reportType/dc_usa_pending_home_sales

描述: 获取美国成屋签约销售指数月率报告, 数据区间从20010301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```python
import PPshare as pp
macro_usa_pending_home_sales_se = PP.macro_usa_pending_home_sales()
print(macro_usa_pending_home_sales_se.name)
print(macro_usa_pending_home_sales_se)
```

数据示例

macro_usa_pending_home_sales_se.name

```
usa_pending_home_sales
```

macro_usa_pending_home_sales_se: pandas.Series

```
2001-03-01     5.1
2001-04-01    -4.7
2001-05-01    -2.9
2001-06-01     2.7
2001-07-01    -3.4
              ... 
2019-09-26     1.4
2019-10-29     1.4
2019-11-27    -1.3
2019-12-30     1.2
2020-01-29       0
```

### 领先指标

#### 美国谘商会消费者信心指数报告

接口: macro_usa_cb_consumer_confidence

目标地址: https://cdn.jin10.com/reports/dc_usa_cb_consumer_confidence_all.js?v=1578576859

描述: 获取美国谘商会消费者信心指数报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_cb_consumer_confidence_se = PP.macro_usa_cb_consumer_confidence()
print(macro_usa_cb_consumer_confidence_se.name)
print(macro_usa_cb_consumer_confidence_se)
```

数据示例

macro_usa_cb_consumer_confidence_se.name

```
cb_consumer_confidence
```

macro_usa_cb_consumer_confidence_se: pandas.Series

```
1970-01-01      126
1970-02-01      126
1970-03-01    101.7
1970-04-01    101.7
1970-05-01       98
              ...  
2019-09-24    126.3
2019-10-29    126.1
2019-11-26    126.8
2019-12-31    126.5
2020-01-28        0
```

#### 美国NFIB小型企业信心指数报告

接口: macro_usa_nfib_small_business

目标地址: https://cdn.jin10.com/reports/dc_usa_nfib_small_business_all.js?v=1578576631

描述: 获取美国NFIB小型企业信心指数报告, 数据区间从19750201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_nfib_small_business_se = PP.macro_usa_nfib_small_business()
print(macro_usa_nfib_small_business_se.name)
print(macro_usa_nfib_small_business_se)
```

数据示例

macro_usa_nfib_small_business_se.name

```
nfib_small_business
```

macro_usa_nfib_small_business_se: pandas.Series

```
1975-02-01     86.67
1975-05-01     95.16
1975-08-01     99.36
1975-11-01    100.37
1976-02-01    102.01
               ...  
2019-09-10     103.1
2019-10-08     101.8
2019-11-12     102.4
2019-12-10     104.7
2020-01-14         0
```

#### 美国密歇根大学消费者信心指数初值报告

接口: macro_usa_michigan_consumer_sentiment

目标地址: https://cdn.jin10.com/reports/dc_usa_michigan_consumer_sentiment_all.js?v=1578576228

描述: 获取美国密歇根大学消费者信心指数初值报告, 数据区间从19700301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_michigan_consumer_sentiment_se = PP.macro_usa_michigan_consumer_sentiment()
print(macro_usa_michigan_consumer_sentiment_se.name)
print(macro_usa_michigan_consumer_sentiment_se)
```

数据示例

macro_usa_michigan_consumer_sentiment_se.name

```
michigan_consumer_sentiment
```

macro_usa_michigan_consumer_sentiment_se: pandas.Series

```
1970-03-01    78.1
1970-06-01    75.4
1970-09-01    77.6
1970-12-01    72.4
1971-03-01    78.1
              ... 
2019-11-08    95.5
2019-11-22    96.8
2019-12-06    96.8
2019-12-20    99.3
2020-01-17       0
```

### 其他

#### 美国EIA原油库存报告

接口: macro_usa_eia_crude_rate

目标地址: https://cdn.jin10.com/reports/dc_usa_michigan_consumer_sentiment_all.js?v=1578576228

描述: 获取美国EIA原油库存报告, 数据区间从19950801-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_eia_crude_rate_se = PP.macro_usa_eia_crude_rate()
print(macro_usa_eia_crude_rate_se.name)
print(macro_usa_eia_crude_rate_se)
```

数据示例

macro_usa_eia_crude_rate_se.name

```
eia_crude_rate
```

macro_usa_eia_crude_rate_se: pandas.Series

```
1982-09-01     -262.6
1982-10-01         -8
1982-11-01      -41.3
1982-12-01      -87.6
1983-01-01       51.3
               ...   
2019-12-27          0
2019-12-28     -547.4
2020-01-04    -1146.3
2020-01-08      116.4
2020-01-15          0
```

#### 美国初请失业金人数报告

接口: macro_usa_initial_jobless

目标地址: https://cdn.jin10.com/reports/dc_usa_michigan_consumer_sentiment_all.js?v=1578576228

描述: 获取美国初请失业金人数报告, 数据区间从19700101-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_initial_jobless_se = PP.macro_usa_initial_jobless()
print(macro_usa_initial_jobless_se.name)
print(macro_usa_initial_jobless_se)
```

数据示例

macro_usa_initial_jobless_se.name

```
initial_jobless
```

macro_usa_initial_jobless_se: pandas.Series

```
1970-01-01    22.1087
1970-02-01    24.9318
1970-03-01      25.85
1970-04-01    26.8682
1970-05-01    33.1591
               ...   
2019-12-19       23.5
2019-12-26       22.4
2020-01-02       22.3
2020-01-09       21.4
2020-01-16          0
```

#### 美国原油产量报告

接口: macro_usa_crude_inner

目标地址: https://cdn.jin10.com/reports/dc_usa_michigan_consumer_sentiment_all.js?v=1578576228

描述: 获取美国原油产量报告, 数据区间从19830107-至今, 每周三公布(美国节假日除外), 美国能源信息署(EIA)

限量: 单次返回所有历史数据

报告内容: 美国能源信息署（EIA）在北京时间每周三晚公布EIA报告，除了公布美国原油库存、汽油库存等数据外，报告还包含美国上周国内原油产量的数据。
报告组成：美国国内原油产量、美国本土48州原油产量和美国阿拉斯加州原油产量。
数据关系：美国国内原油产量=美国本土48州原油产量+美国阿拉斯加州原油产量
单位均为万桶/日。

数据解读: 该数据反映了美国原油供应侧的情况，理论而言，当美国国内原油产量录得增加，通常导致油价下跌；当产量减少，则通常导致油价上扬。

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称                        | 类型  | 默认显示 | 描述      |
| :-------------------------- | :---- | :------- | :-------- |
| 日期                        | str   | Y        | 日期-索引 |
| 美国国内原油总量_产量       | float | Y        | –         |
| 美国国内原油总量_变化       | float | Y        | –         |
| 美国本土48州原油产量_产量   | float | Y        | –         |
| 美国本土48州原油产量_变化   | float | Y        | –         |
| 美国阿拉斯加州原油产量_产量 | float | Y        | –         |
| 美国阿拉斯加州原油产量_变化 | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_usa_crude_inner_df = PP.macro_usa_crude_inner()
print(macro_usa_crude_inner_df)
```

数据示例

```
            美国国内原油总量_产量  美国国内原油总量_变化  ...  美国阿拉斯加州原油产量_产量  美国阿拉斯加州原油产量_变化
2020-04-10       1230.0        -10.0  ...            47.7            -0.4
2020-04-03       1240.0        -60.0  ...            48.1             0.6
2020-03-27       1300.0          0.0  ...            47.5             1.6
2020-03-20       1300.0        -10.0  ...            45.9            -1.9
2020-03-13       1310.0         10.0  ...            47.8             0.5
                 ...          ...  ...             ...             ...
1983-02-04        866.0          2.6  ...             0.0             0.0
1983-01-28        863.4          0.0  ...             0.0             0.0
1983-01-21        863.4          0.0  ...             0.0             0.0
1983-01-14        863.4          0.0  ...             0.0             0.0
1983-01-07        863.4          NaN  ...             0.0             NaN
```

## 欧元区宏观

### 国民经济运行状况

#### 经济状况

##### 欧元区季度GDP年率报告

接口: macro_euro_gdp_yoy

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_gdp_yoy

描述: 获取欧元区季度GDP年率报告, 数据区间从20131114-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_gdp_yoy_se = PP.macro_euro_gdp_yoy()
print(macro_euro_gdp_yoy_se.name)
print(macro_euro_gdp_yoy_se)
```

数据示例

macro_euro_gdp_yoy_se.name

```
gdp_yoy
```

macro_euro_gdp_yoy_se: pandas.Series

```
2013-11-14   -0.4
2013-12-04   -0.4
2014-01-10   -0.3
2014-02-14    0.5
2014-03-05    0.5
             ... 
2019-08-14    1.3
2019-09-06    1.2
2019-10-31    1.1
2019-11-14    1.2
2019-12-05    1.2
```

#### 物价水平

##### 欧元区CPI月率报告

接口: macro_euro_cpi_mom

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_cpi_mom

描述: 获取欧元区CPI月率报告, 数据区间从19900301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_cpi_mom_se = PP.macro_euro_cpi_mom()
print(macro_euro_cpi_mom_se.name)
print(macro_euro_cpi_mom_se)
```

数据示例

macro_euro_cpi_mom_se.name

```
cpi_mom
```

macro_euro_cpi_mom_se: pandas.Series

```
1990-03-01     0.4
1990-04-01     0.2
1990-05-01     0.4
1990-06-01     0.2
1990-07-01     0.1
              ... 
2019-09-18     0.1
2019-10-16     0.2
2019-11-15     0.1
2019-12-18    -0.3
2020-01-17       0
```

##### 欧元区CPI年率报告

接口: macro_euro_cpi_yoy

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_cpi_yoy

描述: 获取欧元区CPI年率报告, 数据区间从19910201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_cpi_yoy_se = PP.macro_euro_cpi_yoy()
print(macro_euro_cpi_yoy_se.name)
print(macro_euro_cpi_yoy_se)
```

数据示例

macro_euro_cpi_yoy_se.name

```
cpi_yoy
```

macro_euro_cpi_yoy_se: pandas.Series

```
1991-02-01    3.9
1991-03-01    4.1
1991-04-01    3.9
1991-05-01    3.9
1991-06-01    4.1
             ... 
2019-11-29    0.7
2019-12-18      1
2020-01-07    1.3
2020-01-17      0
2020-01-31      0
```

##### 欧元区PPI月率报告

接口: macro_euro_ppi_mom

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_ppi_mom

描述: 获取欧元区PPI月率报告, 数据区间从19810301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_ppi_mom_se = PP.macro_euro_ppi_mom()
print(macro_euro_ppi_mom_se.name)
print(macro_euro_ppi_mom_se)
```

数据示例

macro_euro_ppi_mom_se.name

```
ppi_mom
```

macro_euro_ppi_mom_se: pandas.Series

```
1981-03-01       1
1981-04-01     0.7
1981-05-01     1.5
1981-06-01     0.7
1981-07-01     0.6
              ... 
2019-09-03     0.1
2019-10-03    -0.5
2019-11-05     0.1
2019-12-03     0.1
2020-01-06     0.2
```

##### 欧元区零售销售月率报告

接口: macro_euro_retail_sales_mom

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_retail_sales_mom

描述: 获取欧元区零售销售月率报告, 数据区间从20000301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_retail_sales_mom_se = PP.macro_euro_retail_sales_mom()
print(macro_euro_retail_sales_mom_se.name)
print(macro_euro_retail_sales_mom_se)
```

数据示例

macro_euro_retail_sales_mom_se.name

```
retail_sales_mom
```

macro_euro_retail_sales_mom_se: pandas.Series

```
2000-03-01     0.7
2000-04-01    -0.3
2000-05-01     0.7
2000-06-01     0.3
2000-07-01     0.1
              ... 
2019-09-04    -0.5
2019-10-03     0.6
2019-11-06    -0.2
2019-12-05    -0.3
2020-01-07       1
```

#### 劳动力市场

##### 欧元区季调后就业人数季率报告

接口: macro_euro_employment_change_qoq

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_employment_change_qoq

描述: 获取欧元区季调后就业人数季率报告, 数据区间从20083017-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_employment_change_qoq_se = PP.macro_euro_employment_change_qoq()
print(macro_euro_employment_change_qoq_se.name)
print(macro_euro_employment_change_qoq_se)
```

数据示例

macro_euro_employment_change_qoq_se.name

```
employment_change_qoq
```

macro_euro_employment_change_qoq_se: pandas.Series

```
2008-03-17    0.2
2008-06-13    0.3
2008-09-12    0.2
2008-12-16   -0.1
2009-03-16   -0.4
             ... 
2019-08-14    0.4
2019-09-06    0.2
2019-09-14      0
2019-11-14    0.2
2019-12-05    0.1
```

##### 欧元区失业率报告

接口: macro_euro_unemployment_rate_mom

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_unemployment_rate_mom

描述: 获取欧元区失业率报告, 数据区间从19980501-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_unemployment_rate_mom_se = PP.macro_euro_unemployment_rate_mom()
print(macro_euro_unemployment_rate_mom_se.name)
print(macro_euro_unemployment_rate_mom_se)
```

数据示例

macro_euro_unemployment_rate_mom_se.name

```
unemployment_rate_mom
```

macro_euro_unemployment_rate_mom_se: pandas.Series

```
1998-05-01    10.6
1998-06-01    10.5
1998-07-01    10.5
1998-08-01    10.4
1998-09-01    10.4
              ... 
2019-09-30     7.5
2019-10-31     7.6
2019-11-29     7.5
2020-01-09     7.5
2020-01-30       0
```

### 贸易状况

#### 欧元区未季调贸易帐报告

接口: macro_euro_trade_balance

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_trade_balance_mom

描述: 获取欧元区未季调贸易帐报告, 数据区间从19990201-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_trade_balance_se = PP.macro_euro_trade_balance()
print(macro_euro_trade_balance_se.name)
print(macro_euro_trade_balance_se)
```

数据示例

macro_euro_trade_balance_se.name

```
trade_balance
```

macro_euro_trade_balance_se: pandas.Series

```
1999-02-01    -27
1999-03-01     19
1999-04-01     27
1999-05-01     21
1999-06-01     -9
             ... 
2019-09-13    248
2019-10-16    147
2019-11-15    187
2019-12-17    280
2020-01-15      0
```

#### 欧元区经常帐报告

接口: macro_euro_current_account_mom

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_current_account_mom

描述: 获取欧元区经常帐报告, 数据区间从20080221-至今, 前两个值需要去掉

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_current_account_mom_se = PP.macro_euro_current_account_mom()
print(macro_euro_current_account_mom_se.name)
print(macro_euro_current_account_mom_se)
```

数据示例

macro_euro_current_account_mom_se.name

```
current_account_mom
```

macro_euro_current_account_mom_se: pandas.Series

```
1999-02-01       0
2003-07-01       7
2008-02-21    -103
2008-03-26    -106
2008-04-24      43
              ... 
2019-09-19     216
2019-10-18     285
2019-11-19     282
2019-12-20     324
2020-01-17       0
```

### 产业指标

#### 欧元区工业产出月率报告

接口: macro_euro_industrial_production_mom

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_industrial_production_mom

描述: 获取欧元区工业产出月率报告, 数据区间从19910301-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_industrial_production_mom_se = PP.macro_euro_industrial_production_mom()
print(macro_euro_industrial_production_mom_se.name)
print(macro_euro_industrial_production_mom_se)
```

数据示例

macro_euro_industrial_production_mom_se.name

```
industrial_production_mom
```

macro_euro_industrial_production_mom_se: pandas.Series

```
1991-03-01    -1.1
1991-04-01      -1
1991-05-01    -0.5
1991-06-01    -0.1
1991-07-01     1.9
              ... 
2019-09-12    -0.4
2019-10-14     0.4
2019-11-13    -0.1
2019-12-12    -0.5
2020-01-15       0
```

#### 欧元区制造业PMI初值报告

接口: macro_euro_manufacturing_pmi

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_manufacturing_pmi

描述: 获取欧元区制造业PMI初值报告, 数据区间从20080222-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_manufacturing_pmi_se = PP.macro_euro_manufacturing_pmi()
print(macro_euro_manufacturing_pmi_se.name)
print(macro_euro_manufacturing_pmi_se)
```

数据示例

macro_euro_manufacturing_pmi_se.name

```
manufacturing_pmi
```

macro_euro_manufacturing_pmi_se: pandas.Series

```
2008-02-22    52.3
2008-03-03    52.3
2008-03-20      52
2008-04-01      52
2008-04-23    50.8
              ... 
2019-11-22    46.6
2019-12-02    46.9
2019-12-16    45.9
2020-01-02    46.3
2020-01-24       0
```

#### 欧元区服务业PMI终值报告

接口: macro_euro_services_pmi

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_services_pmi

描述: 获取欧元区服务业PMI终值报告, 数据区间从20080222-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_services_pmi_se = PP.macro_euro_services_pmi()
print(macro_euro_services_pmi_se.name)
print(macro_euro_services_pmi_se)
```

数据示例

macro_euro_services_pmi_se.name

```
services_pmi
```

macro_euro_services_pmi_se: pandas.Series

```
2008-02-22    52.3
2008-03-05    51.7
2008-04-03    51.6
2008-04-23    51.8
2008-05-06      52
              ... 
2019-11-22    52.2
2019-12-04    51.9
2019-12-16    52.4
2020-01-06    52.8
2020-01-24       0
```

### 领先指标

#### 欧元区ZEW经济景气指数报告

接口: macro_euro_zew_economic_sentiment

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_zew_economic_sentiment

描述: 获取欧元区ZEW经济景气指数报告, 数据区间从20080212-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_zew_economic_sentiment_se = PP.macro_euro_zew_economic_sentiment()
print(macro_euro_zew_economic_sentiment_se.name)
print(macro_euro_zew_economic_sentiment_se)
```

数据示例

macro_euro_zew_economic_sentiment_se.name

```
zew_economic_sentiment
```

macro_euro_zew_economic_sentiment_se: pandas.Series

```
2008-02-12    -41.4
2008-03-11      -35
2008-04-15    -44.8
2008-05-20    -43.6
2008-06-17    -52.7
              ...  
2019-09-17    -22.4
2019-10-15    -23.5
2019-11-12     -1.0
2019-12-10     11.2
2020-01-21        0
```

#### 欧元区Sentix投资者信心指数报告

接口: macro_euro_sentix_investor_confidence

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取欧元区Sentix投资者信心指数报告, 数据区间从20020801-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_euro_sentix_investor_confidence_se = PP.macro_euro_sentix_investor_confidence()
print(macro_euro_sentix_investor_confidence_se.name)
print(macro_euro_sentix_investor_confidence_se)
```

数据示例

macro_euro_sentix_investor_confidence_se.name

```
sentix_investor_confidence
```

macro_euro_sentix_investor_confidence_se: pandas.Series

```
2002-08-01       13
2002-10-01     -8.5
2003-02-01    -21.8
2003-03-01    -22.8
2003-04-01    -19.4
              ...  
2019-09-09    -11.1
2019-10-07    -16.8
2019-11-04     -4.5
2019-12-09      0.7
2020-01-06      7.6
```

## 重要机构

### 全球最大黄金ETF—SPDR Gold Trust持仓报告

#### 总库存

接口: macro_cons_gold_volume

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取全球最大黄金ETF—SPDR Gold Trust持仓报告-总库存(吨), 数据区间从20041118-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述       |
| :--- | :---- | :------- | :--------- |
| 日期 | str   | Y        | 日期-索引  |
| 值   | float | Y        | 总库存(吨) |

接口示例

```
import PPshare as PP
macro_cons_gold_volume_se = PP.macro_cons_gold_volume()
print(macro_cons_gold_volume_se.name)
print(macro_cons_gold_volume_se)
```

数据示例

macro_euro_sentix_investor_confidence_se.name

```
gold_volume
```

macro_euro_sentix_investor_confidence_se: pandas.Series

```
2004-11-18      8.09
2004-11-19     57.85
2004-11-22     87.09
2004-11-23     87.09
2004-11-24     96.42
               ...
2019-10-20    924.64
2019-10-21    924.64
2019-10-22    919.66
2019-10-23    918.48
2019-10-24    918.48
```

#### 增持-减持

接口: macro_cons_gold_change

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取全球最大黄金ETF—SPDR Gold Trust持仓报告-增持-减持(吨), 数据区间从20041118-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述          |
| :--- | :---- | :------- | :------------ |
| 日期 | str   | Y        | 日期-索引     |
| 值   | float | Y        | 增持-减持(吨) |

接口示例

```
import PPshare as PP
macro_cons_gold_change_se = PP.macro_cons_gold_change()
print(macro_cons_gold_change_se.name)
print(macro_cons_gold_change_se)
```

数据示例

macro_cons_gold_change_se.name

```
gold_change
```

macro_cons_gold_change_se: pandas.Series

```
2004-11-18        0
2004-11-19    49.76
2004-11-22    29.24
2004-11-23     0.00
2004-11-24     9.33
              ...
2019-10-20     0.00
2019-10-21     0.00
2019-10-22    -4.98
2019-10-23    -1.18
2019-10-24     0.00
```

#### 总价值

接口: macro_cons_gold_amount

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取全球最大黄金ETF—SPDR Gold Trust持仓报告-总价值(美元), 数据区间从20041118-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述         |
| :--- | :---- | :------- | :----------- |
| 日期 | str   | Y        | 日期-索引    |
| 值   | float | Y        | 总价值(美元) |

接口示例

```
import PPshare as PP
macro_cons_gold_amount_se = PP.macro_cons_gold_amount()
print(macro_cons_gold_amount_se.name)
print(macro_cons_gold_amount_se)
```

数据示例

macro_cons_gold_amount_se.name

```
gold_amount
```

macro_cons_gold_amount_se: pandas.Series

```
2004-11-18      114920000.00
2004-11-19      828806907.20
2004-11-22     1253785205.50
2004-11-23     1254751438.19
2004-11-24     1390568824.08
                   ...
2019-10-20    44286078486.23
2019-10-21    44333677232.68
2019-10-22    43907962483.56
2019-10-23    44120217405.82
2019-10-24    44120217405.82
```

### 全球最大白银ETF–iShares Silver Trust持仓报告

#### 总库存

接口: macro_cons_silver_volume

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取全球最大白银ETF–iShares Silver Trust持仓报告-总库存(吨), 数据区间从20060429-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述       |
| :--- | :---- | :------- | :--------- |
| 日期 | str   | Y        | 日期-索引  |
| 值   | float | Y        | 总库存(吨) |

接口示例

```
import PPshare as PP
macro_cons_silver_volume_se = PP.macro_cons_silver_volume()
print(macro_cons_silver_volume_se.name)
print(macro_cons_silver_volume_se)
```

数据示例

macro_cons_silver_volume_se.name

```
silver_volume
```

macro_cons_silver_volume_se: pandas.Series

```
2006-04-29      653.17
2006-05-02      653.17
2006-05-03      995.28
2006-05-04     1197.43
2006-05-05     1306.29
                ...
2019-10-17    11847.91
2019-10-18    11847.91
2019-10-21    11813.02
2019-10-22    11751.96
2019-10-23    11751.96
```

#### 增持-减持

接口: macro_cons_silver_change

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取全球最大白银ETF–iShares Silver Trust持仓报告-增持-减持(吨), 数据区间从20060429-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述          |
| :--- | :---- | :------- | :------------ |
| 日期 | str   | Y        | 日期-索引     |
| 值   | float | Y        | 增持-减持(吨) |

接口示例

```
import PPshare as PP
macro_cons_silver_change_se = PP.macro_cons_silver_change()
print(macro_cons_silver_change_se.name)
print(macro_cons_silver_change_se)
```

数据示例

macro_cons_silver_change_se.name

```
silver_change
```

macro_cons_silver_change_se: pandas.Series

```
2006-04-29          0
2006-05-02       0.00
2006-05-03     342.11
2006-05-04     202.15
2006-05-05     108.86
               ...   
2020-01-06       0.00
2020-01-07     -37.76
2020-01-08       0.00
2020-01-09    -101.66
2020-01-10       0.00
```

#### 总价值

接口: macro_cons_silver_amount

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取全球最大白银ETF–iShares Silver Trust持仓报告-总价值(美元), 数据区间从20060429-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述         |
| :--- | :---- | :------- | :----------- |
| 日期 | str   | Y        | 日期-索引    |
| 值   | float | Y        | 总价值(美元) |

接口示例

```
import PPshare as PP
macro_cons_silver_amount_se = PP.macro_cons_silver_amount()
print(macro_cons_silver_amount_se.name)
print(macro_cons_silver_amount_se)
```

数据示例

macro_cons_silver_amount_se.name

```
silver_amount
```

macro_cons_silver_amount_se: pandas.Series

```
2006-04-29    263651152
2006-05-02    263651152
2006-05-03    445408550
2006-05-04    555123947
2006-05-05    574713264
                ...
2019-10-17     Show All
2019-10-18     Show All
2019-10-21     Show All
2019-10-22     Show All
2019-10-23     Show All
```

### 欧佩克报告

#### 欧佩克报告-变动

接口: macro_cons_opec_near_change, 此接口由于数据更新的缘故只能提取到 **20190613** 前数据, 可以自行使用 **macro_cons_opec_month** 提取后计算

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取欧佩克报告, 数据区间从20170118-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型  | 默认显示 | 描述      |
| :--- | :---- | :------- | :-------- |
| 日期 | str   | Y        | 日期-索引 |
| 值   | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_cons_opec_near_change_df = PP.macro_cons_opec_near_change()
print(macro_cons_opec_near_change_df)
```

数据示例

macro_cons_opec_near_change_df

```
            阿尔及利亚   安哥拉   厄瓜多尔    加蓬     伊朗     伊拉克    科威特    利比亚   尼日利亚  \
2017-01-18  -0.87  3.56  -0.25 -0.87   0.95    4.26   0.20   3.13 -11.35   
2017-02-13  -4.17 -2.32  -1.67 -1.00   5.02  -16.57 -14.12   6.47  10.18   
2017-03-14  -0.02 -1.82  -0.44 -0.69   3.61   -6.20  -0.93  -1.11   5.80   
2017-04-12   0.45 -1.87  -0.28  0.19  -2.87   -0.85  -0.95  -6.08  -2.98   
2017-05-11  -0.75  9.71  -0.06  0.88  -3.47   -3.91   0.03  -6.16   5.08   
           ...   ...    ...   ...    ...     ...    ...    ...    ...   
2018-11-13  -0.40  2.20  -0.30  0.30 -15.60  465.30  -3.30   6.00  -1.70   
2018-12-12  -0.50  0.30   0.10 -1.10 -38.00   -2.30   4.50  -1.10  -3.00   
2019-03-14   0.20  2.20   0.50  0.70   1.20   -7.00  -1.40   2.30   1.00   
2019-04-10  -0.70  0.70  52.40  0.90  -2.80  -12.60  -0.10  19.60   1.10   
2019-06-13   0.60  7.40  -0.10  2.30 -22.70    9.40   1.30  -0.30  -9.20   
               沙特    阿联酋   委内瑞拉  欧佩克产量  
2017-01-18 -14.93  -0.63  -4.52 -22.09  
2017-02-13 -49.62 -15.93  -3.05 -89.02  
2017-03-14  -6.81  -3.69  -1.60 -13.95  
2017-04-12   4.16  -3.27  -2.59 -15.27  
2017-05-11   4.92  -6.23  -2.60  -1.82  
           ...    ...    ...    ...  
2018-11-13  12.70  14.20  -4.00  12.70  
2018-12-12  37.70   7.10  -5.20  -1.10  
2019-03-14  -8.60  -0.40 -14.20 -22.10  
2019-04-10 -32.40  -0.90 -28.90 -53.40  
2019-06-13  -7.60   0.30  -3.50 -23.60  
```

#### 欧佩克报告-月度

接口: macro_cons_opec_month

目标地址: https://datacenter.jin10.com/reportType/dc_eurozone_sentix_investor_confidence

描述: 获取欧佩克报告, 数据区间从20170118-至今

限量: 单次返回所有历史数据, 以网页数据为准.

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称       | 类型  | 默认显示 | 描述      |
| :--------- | :---- | :------- | :-------- |
| 日期       | str   | Y        | 日期-索引 |
| 阿尔及利亚 | float | Y        | –         |
| 安哥拉     | float | Y        | –         |
| 厄瓜多尔   | float | Y        | –         |
| 加蓬       | float | Y        | –         |
| 伊朗       | float | Y        | –         |
| 伊拉克     | float | Y        | –         |
| 科威特     | float | Y        | –         |
| 利比亚     | float | Y        | –         |
| 尼日利亚   | float | Y        | –         |
| 沙特       | float | Y        | –         |
| 阿联酋     | float | Y        | –         |
| 委内瑞拉   | float | Y        | –         |
| 欧佩克产量 | float | Y        | –         |

接口示例

```
import PPshare as PP
macro_cons_opec_month_df = PP.macro_cons_opec_month()
print(macro_cons_opec_month_df)
```

数据示例

macro_cons_opec_month_df

```
日期       阿尔及利亚    安哥拉  厄瓜多尔    加蓬     伊朗    伊拉克    科威特    利比亚   尼日利亚      沙特  \
2016/12  108.7  167.4  54.4  20.9  372.5  464.2  285.9     61  147.4  1044.3   
2017/01  105.3  165.8    53  20.3    378  447.5  272.2   67.8  153.3   980.9   
2017/02  105.7  163.9  52.9  19.8  381.9  441.4  271.2   68.1  156.4   995.2   
2017/03  105.1  159.9  52.5  20.2  379.2  442.5  270.2   61.2  145.6   990.5   
2017/04  105.6  166.7  52.6  20.5  379.2  438.1  270.5   55.2  149.6   993.4   
        ...    ...   ...   ...    ...    ...    ...    ...    ...     ...   
2019/08  101.6  138.5  54.3  20.4  219.3  478.1  263.8  107.4    187   985.1   
2019/09    102  140.4    55  19.7  216.3  473.2  265.8  116.2  185.1   879.6   
2019/10  101.9  135.8  45.9  20.7  214.7  469.3  264.8  116.6  180.9  1000.1   
2019/11  102.8  128.3  52.8  19.7  210.7  464.1  270.1  118.3  179.4   987.3   
2019/12  101.7  140.8  53.8  22.2  209.2  456.5  270.8  113.9    177   976.2   
日期         阿联酋   委内瑞拉   欧佩克产量  
2016/12    309  203.4  3302.9  
2017/01  295.8  200.7  3202.6  
2017/02  293.3  199.8  3208.6  
2017/03  290.9  198.2    3177  
2017/04  290.6  196.7  3197.4  
        ...    ...     ...  
2019/08  308.2   73.5  2980.9  
2019/09  308.3   64.4  2871.6  
2019/10  310.5   68.7  2975.3  
2019/11  310.8   71.7  2960.6  
2019/12  306.2   71.4  2944.4  
```

### 伦敦金属交易所

#### 持仓报告

接口: macro_euro_lme_holding

目标地址: https://datacenter.jin10.com/reportType/dc_lme_traders_report

描述: 获取伦敦金属交易所(LME)-持仓报告, 数据区间从 20151022-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型 | 默认显示 | 描述                                 |
| :--- | :--- | :------- | :----------------------------------- |
| –    | –    | –        | 不同品种的多头仓位、空头仓位和净仓位 |

接口示例

```
import PPshare as PP
macro_euro_lme_holding_df = PP.macro_euro_lme_holding()
print(macro_euro_lme_holding_df)
```

数据示例

```
               铝-多头仓位     铝-空头仓位      铝-净仓位  ...  锡-多头仓位  锡-空头仓位   锡-净仓位
2015-10-22  327120.00 -304606.00  631726.00  ...    5462 -2129.0  7591.0
2015-10-23  326996.00 -304797.00  631793.00  ...    5339 -2090.0  7429.0
2015-10-26  327814.00 -305974.00  633788.00  ...    5388 -2239.0  7627.0
2015-10-27  331239.00 -305348.00  636587.00  ...    5338 -2289.0  7627.0
2015-10-28  331586.00 -302432.00  634018.00  ...    5264 -2370.0  7634.0
               ...        ...        ...  ...     ...     ...     ...
2020-05-01  737311.18  546268.81  191042.37  ...   12044  8966.0  3078.0
2020-05-07  715146.83  525746.88  189399.95  ...   11919  9101.0  2818.0
2020-05-15  741948.06  552763.07  189184.99  ...   11977  9159.0  2818.0
2020-05-22  726923.87  551171.11  175752.76  ...   11234  8762.0  2472.0
2020-05-29  730646.63  552041.55  178605.08  ...   11648  9110.0  2538.0
```

#### 库存报告

接口: macro_euro_lme_stock

目标地址: https://datacenter.jin10.com/reportType/dc_lme_report

描述: 获取伦敦金属交易所(LME)-库存报告, 数据区间从 20140702-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型 | 默认显示 | 描述                               |
| :--- | :--- | :------- | :--------------------------------- |
| –    | –    | –        | 不同品种的库存、注册仓单和注销仓单 |

接口示例

```
import PPshare as PP
macro_euro_lme_stock_df = PP.macro_euro_lme_stock()
print(macro_euro_lme_stock_df)
```

数据示例

```
               铝-库存   铝-注册仓单   铝-注销仓单    铜-库存  ...  锡-注销仓单    锌-库存  锌-注册仓单  锌-注销仓单
2014-07-02  5066400  2075450  2990950  156775  ...    2470  666775  610175   56600
2014-07-03  5058325  2074950  2983375  157050  ...    2500  665600  610175   55425
2014-07-04  5049225  2074450  2974775  156500  ...    2500  664650  604050   60600
2014-07-07  5038525  2072925  2965600  159350  ...    2500  663650  603950   59700
2014-07-08  5034200  2070925  2963275  158050  ...    2470  663150  603950   59200
             ...      ...      ...     ...  ...     ...     ...     ...     ...
2020-06-01  1496050  1283000   213050  255725  ...     840   99575   80150   19425
2020-06-02  1505550  1295200   210350  254275  ...     910   97850   79650   18200
2020-06-03  1500900  1295200   205700  252375  ...    1005   97800   79650   18150
2020-06-04  1526250  1324400   201850  248275  ...    1030   96275   79475   16800
2020-06-05  1521325  1305725   215600  243750  ...     905   94675   79450   15225
```

### 美国商品期货交易委员会

#### 外汇类非商业持仓报告

接口: macro_usa_cftc_nc_holding

目标地址: https://datacenter.jin10.com/reportType/dc_cftc_nc_report

描述: 获取美国商品期货交易委员会CFTC外汇类非商业持仓报告, 数据区间从 19830107-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型 | 默认显示 | 描述                                 |
| :--- | :--- | :------- | :----------------------------------- |
| –    | –    | –        | 不同品种的多头仓位、空头仓位和净仓位 |

接口示例

```
import PPshare as PP
macro_usa_cftc_nc_holding_df = PP.macro_usa_cftc_nc_holding()
print(macro_usa_cftc_nc_holding_df)
```

数据示例

```
            美元-多头仓位  美元-空头仓位  美元-净仓位  瑞郎-多头仓位  ...  英镑-净仓位  澳元-多头仓位  澳元-空头仓位  澳元-净仓位
1986-01-15        0        0       0        0  ...       0        0        0       0
1986-01-31        0        0       0        0  ...       0        0        0       0
1986-02-14        0        0       0        0  ...       0        0        0       0
1986-02-28        0        0       0        0  ...       0        0        0       0
1986-03-14        0        0       0        0  ...       0        0        0       0
             ...      ...     ...      ...  ...     ...      ...      ...     ...
2020-05-05   324795   350743  -25948    12967  ...  -12005    23541    56996  -33455
2020-05-12   337226   347594  -10368    12624  ...  -13688    23719    59144  -35425
2020-05-19   359429   352735    6694    13678  ...  -18989    25301    64859  -39558
2020-05-26   376764   388231  -11467    13246  ...  -22257    25530    66068  -40538
2020-06-02   385801   394030   -8229    13364  ...  -36044    26571    67362  -40791
```

#### 商品类非商业持仓报告

接口: macro_usa_cftc_c_holding

目标地址: https://datacenter.jin10.com/reportType/dc_cftc_c_report

描述: 获取美国商品期货交易委员会CFTC商品类非商业持仓报告, 数据区间从 19830107-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型 | 默认显示 | 描述                                 |
| :--- | :--- | :------- | :----------------------------------- |
| –    | –    | –        | 不同品种的多头仓位、空头仓位和净仓位 |

接口示例

```
import PPshare as PP
macro_usa_cftc_c_holding_df = PP.macro_usa_cftc_c_holding()
print(macro_usa_cftc_c_holding_df)
```

数据示例

```
            原糖-多头仓位  原糖-空头仓位  原糖-净仓位  大豆-多头仓位  ...  棉花-净仓位  玉米-多头仓位  玉米-空头仓位  玉米-净仓位
1986-01-15        0        0       0    47835  ...       0    45615    16565   29050
1986-01-31        0        0       0    42610  ...       0    32135    34145   -2010
1986-02-14        0        0       0    24555  ...       0    14030    50275  -36245
1986-02-28        0        0       0    22805  ...       0    17735    59835  -42100
1986-03-14        0        0       0    43290  ...       0    18725    58090  -39365
             ...      ...     ...      ...  ...     ...      ...      ...     ...
2020-05-05   177939   145745   32194   173136  ...   -2633   213746   366836 -153090
2020-05-12   186688   142574   44114   188262  ...    1078   210833   388404 -177571
2020-05-19   208295   138673   69622   186743  ...    3320   218328   417374 -199046
2020-05-26   217461   130398   87063   182102  ...    3817   223361   443436 -220075
2020-06-02   221084   127678   93406   178933  ...    9596   235871   455309 -219438
```

#### 外汇类商业持仓报告

接口: macro_usa_cftc_merchant_currency_holding

目标地址: https://datacenter.jin10.com/reportType/dc_cftc_merchant_currency

描述: 获取美国商品期货交易委员会CFTC外汇类商业持仓报告, 数据区间从 19860115-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型 | 默认显示 | 描述                                 |
| :--- | :--- | :------- | :----------------------------------- |
| –    | –    | –        | 不同品种的多头仓位、空头仓位和净仓位 |

接口示例

```
import PPshare as PP
macro_usa_cftc_merchant_currency_holding_df = PP.macro_usa_cftc_merchant_currency_holding()
print(macro_usa_cftc_merchant_currency_holding_df)
```

数据示例

```
            美元-多头仓位  美元-空头仓位  美元-净仓位  瑞郎-多头仓位  ...  英镑-净仓位  澳元-多头仓位  澳元-空头仓位  澳元-净仓位
1986-01-15        0        0       0        0  ...       0        0        0       0
1986-01-31        0        0       0        0  ...       0        0        0       0
1986-02-14        0        0       0        0  ...       0        0        0       0
1986-02-28        0        0       0        0  ...       0        0        0       0
1986-03-14        0        0       0        0  ...       0        0        0       0
             ...      ...     ...      ...  ...     ...      ...      ...     ...
2020-05-05   761167   740678   20489    12783  ...   23207    90061    41987   48074
2020-05-12   764765   764586     179    16793  ...   28146    89686    39723   49963
2020-05-19   761649   773386  -11737    14422  ...   33299    91226    39980   51246
2020-05-26   790831   792542   -1711    14593  ...   35289    94516    40279   54237
2020-06-02   810672   794088   16584    14432  ...   44403    91638    37786   53852
```

#### 商品类商业持仓报告

接口: macro_usa_cftc_merchant_goods_holding

目标地址: https://datacenter.jin10.com/reportType/dc_cftc_merchant_goods

描述: 获取美国商品期货交易委员会CFTC商品类商业持仓报告, 数据区间从 19860115-至今

限量: 单次返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称 | 类型 | 默认显示 | 描述                                 |
| :--- | :--- | :------- | :----------------------------------- |
| –    | –    | –        | 不同品种的多头仓位、空头仓位和净仓位 |

接口示例

```
import PPshare as PP
macro_usa_cftc_merchant_goods_holding_df = PP.macro_usa_cftc_merchant_goods_holding()
print(macro_usa_cftc_merchant_goods_holding_df)
```

数据示例

```python
原糖-多头仓位  原糖-空头仓位  原糖-净仓位  大豆-多头仓位  ...  棉花-净仓位  玉米-多头仓位  玉米-空头仓位  玉米-净仓位
1986-01-15        0        0       0   117120  ...       0   307790   307815     -25
1986-01-31        0        0       0   122430  ...       0   323200   247390   75810
1986-02-14        0        0       0   130140  ...       0   303885   205150   98735
1986-02-28        0        0       0   145015  ...       0   288625   204725   83900
1986-03-14        0        0       0   125300  ...       0   276865   220480   56385
             ...      ...     ...      ...  ...     ...      ...      ...     ...
2020-05-05   581116   619230  -38114   402631  ...    2543   749637   613914  135723
2020-05-12   586013   638394  -52381   423150  ...   -1981   758783   603070  155713
2020-05-19   588614   670244  -81630   431829  ...   -5068   764876   593689  171187
2020-05-26   589614   686994  -97380   440560  ...   -4773   773465   589063  184402
2020-06-02   593359   695146 -101787   446474  ...  -10899   787667   608847  178820
```

# PPshare 能源数据

## 碳排放权

接口: energy_carbon

目标地址: https://www.bjets.com.cn/jyxx/

描述: 获取北京市碳排放权电子交易平台-北京市碳排放权公开交易行情

限量: 全部历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称            | 类型  | 默认显示 | 描述     |
| :-------------- | :---- | :------- | :------- |
| 日期            | str   | –        |          |
| 成交量(吨)      | float | –        | 注意单位 |
| 成交均价(元/吨) | float | –        | 注意单位 |
| 成交额(元)      | str   | –        | 注意单位 |

接口示例

```
import PPshare as PP
energy_carbon_df = PP.energy_carbon()
print(energy_carbon_df)
```

数据示例

```
              日期  成交量(吨)  成交均价(元/吨)             成交额(元)
0     2019-12-13       1      60.00         60.00（BEA）
1     2019-12-12    9215      74.66    687,957.00（BEA）
2     2019-12-11   14315      76.48  1,094,789.50（BEA）
3     2019-12-10     780      75.38     58,800.00（BEA）
4     2019-12-03    9500      72.11    685,000.00(BEA)
          ...     ...        ...                ...
1065  2013-12-11     100      50.50               5050
1066  2013-12-06     100      50.00               5000
1067  2013-12-05     100      50.20               5020
1068  2013-12-02     300      55.10              16530
1069  2013-11-28     800      51.25              41000
```

## 中国油价

### 汽柴油历史调价信息

接口: energy_oil_hist

目标地址: http://data.eastmoney.com/cjsj/oil_default.html

描述: 获取东方财富-数据中心-中国油价-汽柴油历史调价信息

限量: 全部中国油价的所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称     | 类型  | 默认显示 | 描述           |
| :------- | :---- | :------- | :------------- |
| 日期     | str   | –        | 价格调整的日期 |
| 汽油价格 | float | –        | 价格(元/吨)    |
| 柴油价格 | float | –        | 价格(元/吨)    |
| 汽油涨幅 | str   | –        | 价格(元/吨)    |
| 柴油涨幅 | str   | –        | 价格(元/吨)    |

接口示例

```
import PPshare as PP
energy_oil_hist_df = PP.energy_oil_hist()
print(energy_oil_hist_df)
```

数据示例

```
             日期    汽油价格    柴油价格    汽油涨幅   柴油涨幅
0     2020/3/19  6090.0  5165.0 -1015.0 -975.0
1     2020/2/19  7105.0  6140.0  -415.0 -400.0
2      2020/2/5  7520.0  6540.0  -420.0 -405.0
3    2019/12/31  7940.0  6945.0   235.0  230.0
4     2019/12/3  7705.0  6715.0    55.0   50.0
..          ...     ...     ...     ...    ...
194  2000/10/20  3435.0  3440.0     NaN    NaN
195   2000/9/20  3615.0  3070.0     NaN    NaN
196   2000/8/18  3405.0  2770.0     NaN    NaN
197   2000/7/15  3135.0  2610.0     NaN    NaN
198    2000/6/6  2935.0  2430.0     NaN    NaN
```

### 地区油价

接口: energy_oil_detail

目标地址: http://data.eastmoney.com/cjsj/oil_default.html

描述: 获取东方财富-数据中心-中国油价-地区油价

限量: 指定调价日的地区油价历史数据

输入参数

| 名称 | 类型 | 必选 | 描述                                                         |
| :--- | :--- | :--- | :----------------------------------------------------------- |
| date | str  | Y    | date=”2020-03-19″; 此日期为调价日期, 通过调用 **energy_oil_hist** 可以获取历史调价日期 |

输出参数

| 名称     | 类型  | 默认显示 | 描述                                |
| :------- | :---- | :------- | :---------------------------------- |
| DIM_DATE | str   | –        | 价格调整的日期                      |
| V_0      | float | –        | 0#柴油价格(单位:元/升)              |
| V_92     | float | –        | 92#汽油价格(单位:元/升)             |
| V_95     | str   | –        | 95#汽油价格(单位:元/升)             |
| V_89     | str   | –        | 89#汽油价格(单位:元/升)             |
| CITYNAME | str   | –        | 地区                                |
| ZDE_0    | str   | –        | 0#柴油涨幅(单位:元/升)              |
| ZDE_92   | str   | –        | 92#汽油涨幅(单位:元/升)             |
| ZDE_95   | str   | –        | 95#汽油涨幅(单位:元/升)             |
| ZDE_89   | str   | –        | 89#汽油涨幅(单位:元/升)             |
| QE_0     | str   | –        | 上一次调整时0#柴油价格(单位:元/升)  |
| QE_92    | str   | –        | 上一次调整时92#汽油价格(单位:元/升) |
| QE_95    | str   | –        | 上一次调整时95#汽油价格(单位:元/升) |
| QE_89    | str   | –        | 上一次调整时89#汽油价格(单位:元/升) |

接口示例

```
import PPshare as PP
energy_oil_detail_df = PP.energy_oil_detail()
print(energy_oil_detail_df)
```

数据示例

```python
     DIM_DATE       V_0      V_92  ...     QE_92     QE_95    QE_89
0   2020/3/19  5.130000  5.490000  ...  6.620000  7.100000  6.20000
1   2020/3/19  5.130000  5.500000  ...  6.650000  7.080000  6.23000
2   2020/3/19  5.100000  5.490000  ...  6.630000  7.070000  6.17000
3   2020/3/19  5.021243  5.411418  ...  6.548571  6.997642  6.14084
4   2020/3/19  5.110000  5.530000  ...  6.670000  7.230000  6.20000
5   2020/3/19  5.170000  5.570000  ...  6.720000  7.260000  6.25000
6   2020/3/19  5.210000  5.630000  ...  6.780000  7.160000  6.40000
7   2020/3/19  5.190000  5.570000  ...  7.770000  8.240000  7.18000
8   2020/3/19  5.090000  5.490000  ...  6.640000  7.020000  6.16000
9   2020/3/19  5.090000  5.500000  ...  6.800000  7.270000      NaN
10  2020/3/19  5.090000  5.510000  ...  7.000000  7.490000      NaN
11  2020/3/19  5.159620  5.474944  ...  6.610000  7.030000  6.20000
12  2020/3/19  5.070000  5.490000  ...  6.630000  7.050000  6.21000
13  2020/3/19  5.140000  5.480000  ...  6.620000  7.110000  6.15000
14  2020/3/19  5.010000  5.430000  ...  6.560000  6.930000  6.19000
15  2020/3/19  5.050000  5.460000  ...  6.610000  7.080000  6.20000
16  2020/3/19  5.090000  5.480000  ...  6.970000  7.480000  6.48000
17  2020/3/19  5.150000  5.480000  ...  6.610000  7.140000  6.19000
18  2020/3/19  5.020000  5.410000  ...  6.550000  6.920000  6.18000
19  2020/3/19  5.080000  5.470000  ...  6.620000  7.040000  6.17000
20  2020/3/19  5.210000  5.560000  ...  6.690000  7.210000  6.27000
21  2020/3/19  5.090000  5.490000  ...  6.640000  7.020000  6.16000
22  2020/3/19  5.670000  6.410000  ...  7.690000  8.130000  7.25000
23  2020/3/19  5.190505  5.648464  ...  7.134902  7.658112  6.57120
24  2020/3/19  5.090000  5.490000  ...  6.630000  7.050000  6.15000
```

# PPshare 数字货币

接口: get_js_dc_current

目标地址: https://datacenter.jin10.com/reportType/dc_bitcoin_current

描述: 获取数字货币实时行情, 实时更新

限量: 单次返回主流数字货币当前时点行情数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| 无   | 无   | 无   | 无   |

输出参数

| 名称           | 类型  | 默认显示 | 描述                       |
| :------------- | :---- | :------- | :------------------------- |
| reported_at    | str   | Y        | 日期时间-索引              |
| bourse         | float | Y        | 市场                       |
| currency_pair  | str   | Y        | 货币对代码                 |
| price          | float | Y        | 最新价(注意货币币种)       |
| up_down        | str   | Y        | 涨跌幅                     |
| up_down_rate   | float | Y        | –                          |
| hightest_price | str   | Y        | 24小时最高价(注意货币币种) |
| lowest_price   | float | Y        | 24小时最低价(注意货币币种) |
| volume         | str   | Y        | 24小时成交量               |

接口示例

```
import PPshare as PP
get_js_dc_current_df = PP.get_js_dc_current()
print(get_js_dc_current_df)
```

数据示例

```python
   bourse currency_pair  ...  lowest_price        volume   reported_at                                        ...                            
2020-02-28 16:37:15    Bitfinex(香港)        LTCUSD  ...        59.666  83980.753551
2020-02-28 16:37:15    Bitflyer(日本)        BTCJPY  ...    940368.000   6566.954034
2020-02-28 16:37:15    Bitstamp(美国)        BTCUSD  ...      8585.470   6958.242385
2020-02-28 16:36:27      CEX.IO(伦敦)        BTCUSD  ...      8653.900    129.747383
2020-02-28 16:37:15  KrPPen_EUR(美国)        BTCEUR  ...      7897.100   5300.456910
2020-02-28 16:36:27      KrPPen(美国)        LTCUSD  ...        58.410  40829.390880
2020-02-28 16:36:27      OKCoin(中国)        BTCUSD  ...      8614.120    756.123400
2020-02-28 16:36:27    Bitfinex(香港)        BCHUSD  ...       312.050  10427.392214
2020-02-28 16:37:15    Bitfinex(香港)        BTCUSD  ...      8569.200   5229.230908
2020-02-28 16:37:15      KrPPen(美国)        BTCUSD  ...      8553.200   3910.324878
```

# PPshare 特色数据

## 日出和日落

### 日出和日落-天

接口: sunrise_daily

目标地址: https://www.timeanddate.com/sun/china/

描述: 获取中国各大城市-日出和日落时间, 数据区间从19990101-至今, 推荐使用代理访问

限量: 单次返回指定日期和指定城市的数据

输入参数

| 名称 | 类型 | 必选 | 描述                                              |
| :--- | :--- | :--- | :------------------------------------------------ |
| date | str  | Y    | date=”20190801″                                   |
| city | str  | Y    | city=”北京”; 注意输入的格式, e.g., “北京”, “上海” |

输出参数

| 名称       | 类型              | 默认显示 | 描述                        |
| :--------- | :---------------- | :------- | :-------------------------- |
| date       | datetime.datetime | Y        | 日期-索引                   |
| Sunrise    | str               | Y        | 日出                        |
| Sunset     | float             | Y        | 日落                        |
| Length     | str               | Y        | Daylength-Length            |
| Difference | float             | Y        | Daylength-Difference        |
| Start      | str               | Y        | Astronomical Twilight-Start |
| End        | float             | Y        | Astronomical Twilight-End   |
| Start.1    | str               | Y        | Nautical Twilight-Start     |
| End.1      | float             | Y        | Nautical Twilight-End       |
| Start.2    | str               | Y        | Civil Twilight-Start        |
| End.2      | float             | Y        | Civil Twilight-End          |
| Time       | str               | Y        | Solar Noon-Time             |
| Mil. km    | float             | Y        | Solar Noon-Mil. km          |

接口示例

```
import PPshare as PP
sunrise_daily_df = PP.sunrise_daily(date="20190801", city="北京")
print(sunrise_daily_df)
```

数据示例

```
八月        Sunrise          Sunset  ...  End.2           Time Mil. km
2019-08-01  1  05:12 ↑ (65°)  19:28 ↑ (295°)  ...  19:58  12:20 (68,2°)  151857
```

### 日出和日落-月

接口: sunrise_monthly

目标地址: https://www.timeanddate.com/sun/china/

描述: 获取中国各大城市-日出和日落时间, 数据区间从19990101-至今, 推荐使用代理访问

限量: 单次返回指定日期所在月份每天的数据, 如果是未来日期则为预测值

输入参数

| 名称 | 类型 | 必选 | 描述            |
| :--- | :--- | :--- | :-------------- |
| date | str  | Y    | date=”20190801″ |
| city | str  | Y    | city=”北京”     |

输出参数

| 名称       | 类型  | 默认显示 | 描述                        |
| :--------- | :---- | :------- | :-------------------------- |
| month      | str   | Y        | 日期-索引; XXXX-XX 格式     |
| Sunrise    | str   | Y        | 日出                        |
| Sunset     | float | Y        | 日落                        |
| Length     | str   | Y        | Daylength-Length            |
| Difference | float | Y        | Daylength-Difference        |
| Start      | str   | Y        | Astronomical Twilight-Start |
| End        | float | Y        | Astronomical Twilight-End   |
| Start.1    | str   | Y        | Nautical Twilight-Start     |
| End.1      | float | Y        | Nautical Twilight-End       |
| Start.2    | str   | Y        | Civil Twilight-Start        |
| End.2      | float | Y        | Civil Twilight-End          |
| Time       | str   | Y        | Solar Noon-Time             |
| Mil. km    | float | Y        | Solar Noon-Mil. km          |

接口示例

```
import PPshare as PP
sunrise_monthly_df = PP.sunrise_monthly(date="20200328", city="北京")
print(sunrise_monthly_df)
```

数据示例

```
       Mar        Sunrise          Sunset  ...  End.2           Time  Mil. km
202003   1  06:47 ↑ (99°)  18:06 ↑ (261°)  ...  18:33  12:26 (42.7°)  148.234
202003   2  06:46 ↑ (99°)  18:07 ↑ (262°)  ...  18:34  12:26 (43.1°)  148.270
202003   3  06:44 ↑ (98°)  18:08 ↑ (262°)  ...  18:35  12:26 (43.4°)  148.306
202003   4  06:43 ↑ (98°)  18:09 ↑ (263°)  ...  18:36  12:26 (43.8°)  148.343
202003   5  06:41 ↑ (97°)  18:10 ↑ (263°)  ...  18:37  12:25 (44.2°)  148.380
202003   6  06:40 ↑ (97°)  18:11 ↑ (264°)  ...  18:38  12:25 (44.6°)  148.417
202003   7  06:38 ↑ (96°)  18:12 ↑ (264°)  ...  18:39  12:25 (45.0°)  148.455
202003   8  06:37 ↑ (96°)  18:13 ↑ (265°)  ...  18:40  12:25 (45.4°)  148.493
202003   9  06:35 ↑ (95°)  18:15 ↑ (265°)  ...  18:42  12:24 (45.8°)  148.532
202003  10  06:33 ↑ (95°)  18:16 ↑ (266°)  ...  18:43  12:24 (46.2°)  148.572
202003  11  06:32 ↑ (94°)  18:17 ↑ (266°)  ...  18:44  12:24 (46.6°)  148.612
202003  12  06:30 ↑ (94°)  18:18 ↑ (267°)  ...  18:45  12:24 (46.9°)  148.652
202003  13  06:29 ↑ (93°)  18:19 ↑ (267°)  ...  18:46  12:23 (47.3°)  148.693
202003  14  06:27 ↑ (93°)  18:20 ↑ (268°)  ...  18:47  12:23 (47.7°)  148.734
202003  15  06:25 ↑ (92°)  18:21 ↑ (268°)  ...  18:48  12:23 (48.1°)  148.776
202003  16  06:24 ↑ (91°)  18:22 ↑ (269°)  ...  18:49  12:23 (48.5°)  148.818
202003  17  06:22 ↑ (91°)  18:23 ↑ (269°)  ...  18:50  12:22 (48.9°)  148.861
202003  18  06:21 ↑ (90°)  18:24 ↑ (270°)  ...  18:51  12:22 (49.3°)  148.903
202003  19  06:19 ↑ (90°)  18:25 ↑ (270°)  ...  18:52  12:22 (49.7°)  148.946
202003  20  06:17 ↑ (89°)  18:26 ↑ (271°)  ...  18:53  12:21 (50.1°)  148.988
202003  21  06:16 ↑ (89°)  18:27 ↑ (271°)  ...  18:54  12:21 (50.5°)  149.031
202003  22  06:14 ↑ (88°)  18:28 ↑ (272°)  ...  18:55  12:21 (50.9°)  149.074
202003  23  06:13 ↑ (88°)  18:29 ↑ (272°)  ...  18:56  12:20 (51.3°)  149.116
202003  24  06:11 ↑ (87°)  18:30 ↑ (273°)  ...  18:57  12:20 (51.7°)  149.159
202003  25  06:09 ↑ (87°)  18:31 ↑ (273°)  ...  18:58  12:20 (52.1°)  149.201
202003  26  06:08 ↑ (86°)  18:32 ↑ (274°)  ...  18:59  12:20 (52.5°)  149.244
202003  27  06:06 ↑ (86°)  18:33 ↑ (274°)  ...  19:00  12:19 (52.9°)  149.286
202003  28  06:04 ↑ (85°)  18:34 ↑ (275°)  ...  19:01  12:19 (53.2°)  149.328
202003  29  06:03 ↑ (85°)  18:35 ↑ (275°)  ...  19:02  12:19 (53.6°)  149.371
202003  30  06:01 ↑ (84°)  18:36 ↑ (276°)  ...  19:03  12:18 (54.0°)  149.413
202003  31  06:00 ↑ (84°)  18:37 ↑ (276°)  ...  19:04  12:18 (54.4°)  149.455
```

## 空气质量-河北

### 近期空气质量

接口: air_quality_hebei

目标地址: http://110.249.223.67/publish/

描述: 获取河北省近 6 天空气质量情况

注释:

注释-等级划分

1. 空气污染指数为0－50，空气质量级别为一级，空气质量状况属于优。此时，空气质量令人满意，基本无空气污染，各类人群可正常活动。
2. 空气污染指数为51－100，空气质量级别为二级，空气质量状况属于良。此时空气质量可接受，但某些污染物可能对极少数异常敏感人群健康有较弱影响，建议极少数异常敏感人群应减少户外活动。
3. 空气污染指数为101－150，空气质量级别为三级，空气质量状况属于轻度污染。此时，易感人群症状有轻度加剧，健康人群出现刺激症状。建议儿童、老年人及心脏病、呼吸系统疾病患者应减少长时间、高强度的户外锻炼。
4. 空气污染指数为151－200，空气质量级别为四级，空气质量状况属于中度污染。此时，进一步加剧易感人群症状，可能对健康人群心脏、呼吸系统有影响，建议疾病患者避免长时间、高强度的户外锻练，一般人群适量减少户外运动。
5. 空气污染指数为201－300，空气质量级别为五级，空气质量状况属于重度污染。此时，心脏病和肺病患者症状显著加剧，运动耐受力降低，健康人群普遍出现症状，建议儿童、老年人和心脏病、肺病患者应停留在室内，停止户外运动，一般人群减少户外运动。
6. 空气污染指数大于300，空气质量级别为六级，空气质量状况属于严重污染。此时，健康人群运动耐受力降低，有明显强烈症状，提前出现某些疾病，建议儿童、老年人和病人应当留在室内，避免体力消耗，一般人群应避免户外活动。

注释-发布单位

河北省环境应急与重污染天气预警中心

注释-技术支持

中国科学院大气物理研究所, 中科三清科技有限公司

限量: 单次返回 6 天的数据

输入参数

| 名称 | 类型 | 必选 | 描述                                                         |
| :--- | :--- | :--- | :----------------------------------------------------------- |
| city | str  | Y    | city=”定州市”, 返回具体市的数据; city=””, 则返回所有城市数据 |

输出参数

| 名称      | 类型  | 默认显示 | 描述      |
| :-------- | :---- | :------- | :-------- |
| 城市      | str   | Y        | 城市-索引 |
| Datadate  | str   | Y        | 日期      |
| Pollutant | float | Y        | PM2.5     |
| MinAQI    | str   | Y        | 最小      |
| MaxAQI    | float | Y        | 最大      |
| Level     | str   | Y        | 程度      |

接口示例

```
import PPshare as PP
air_quality_hebei_df = PP.air_quality_hebei(city="定州市")
print(air_quality_hebei_df)
```

数据示例

```
               Datadate Pollutant MinAQI MaxAQI  Level
定州市  2019/11/27 0:00:00     PM2.5     80    110   良-轻度
定州市  2019/11/28 0:00:00     PM2.5     90    120   良-轻度
定州市  2019/11/29 0:00:00     PM2.5    175    205  中度-重度
定州市  2019/11/30 0:00:00     PM2.5    175    205  中度-重度
定州市   2019/12/1 0:00:00     PM2.5    175    205  中度-重度
定州市   2019/12/2 0:00:00     PM2.5     80    110   良-轻度
```

## 空气质量-全国

### 城市列表

接口: air_city_list

目标地址: https://www.aqistudy.cn/

描述: 获取所有空气质量数据的城市列表

限量: 单次返回所有可以获取的城市的列表

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称        | 类型 | 默认显示 | 描述 |
| :---------- | :--- | :------- | :--- |
| 168城市列表 | list | Y        | list |

接口示例

```
import PPshare as PP
air_city_list_map = PP.air_city_list()
print(air_city_list_map)
```

数据示例

```
['北京', '廊坊', '承德', '唐山', '晋城', '保定', '德阳', '秦皇岛', '天津', '朝阳', '临汾', '运城', '成都', '焦作', '长治', '锦州', '绵阳', '资阳', '葫芦岛', '广安', '长春', '石家庄', '三门峡', '兰州', '沧州', '沈阳', '哈尔滨', '衡水', '洛阳', '滨州', '眉山', '东营', '阳泉', '内江', '铜川', '宜宾', '淄博', '邢台', '晋中', '自贡', '新乡', '安阳', '邯郸', '南充', '忻州', '临沂', '太原', '重庆', '乐山', '潍坊', '张家口', '济南', '德州', '聊城', '鹤壁', '青岛', '亳州', '日照', '枣庄', '西安', '咸阳', '宝鸡', '宿州', '泰安', '商丘', '达州', '济宁', '南阳', '吕梁', '连云港', '雅安', '郑州', '南昌', '阜阳', '渭南', '周口', '宿迁', '许昌', '武汉', '徐州', '开封', '泸州', '平顶山', '驻马店', '信阳', '菏泽', '淮南', '漯河', '朔州', '孝感', '濮阳', '杭州', '呼和浩特', '银川', '遂宁', '随州', '湖州', '襄阳', '淮安', '宜昌', '益阳', '淮北', '常州', '泰州', '拉萨', '包头', '蚌埠', '盐城', '六安', '西宁', '岳阳', '九江', '镇江', '苏州', '广州', '贵阳', '大同', '乌鲁木齐', '荆门', '铜陵', '新余', '扬州', '鄂州', '南通', '常德', '荆州', '无锡', '长沙', '咸宁', '嘉兴', '衢州', '大连', '黄冈', '温州', '厦门', '黄石', '绍兴', '合肥', '宜春', '上海', '昆明', '福州', '株洲', '金华', '南京', '湘潭', '丽水', '马鞍山', '萍乡', '宣城', '芜湖', '滁州', '安庆', '池州', '佛山', '黄山', '江门', '南宁', '台州', '惠州', '宁波', '肇庆', '舟山', '中山', '东莞', '深圳', '珠海', '海口']
```

### 空气质量历史数据

接口: air_quality_hist

目标地址: https://www.zq12369.com/

描述: 获取指定城市和数据频率下并且在指定时间段内的空气质量数据

限量: 单次返回所有的数据, 在提取一小时频率数据时请注意时间跨度不宜过长

输入参数

| 名称       | 类型 | 必选 | 描述                                                         |
| :--------- | :--- | :--- | :----------------------------------------------------------- |
| city       | str  | Y    | city=”北京”; 调用 air_city_list 接口获取所有城市列表         |
| period     | str  | Y    | period=”day”; “hour”: 每小时一个数据, 由于数据量比较大, 下载较慢; “day”: 每天一个数据; “month”: 每个月一个数据 |
| start_date | str  | Y    | start_date=”2020-03-20″; 注意 **start_date** 和 **end_date** 跨度不宜过长 |
| end_date   | str  | Y    | end_date=”2020-04-27″; 注意 **start_date** 和 **end_date** 跨度不宜过长 |

输出参数

| 名称              | 类型  | 默认显示 | 描述         |
| :---------------- | :---- | :------- | :----------- |
| time              | str   | Y        | 日期时间索引 |
| aqi               | str   | Y        | AQI          |
| pm2_5             | float | Y        | PM2.5        |
| pm10              | str   | Y        | PM10         |
| co                | float | Y        | CO           |
| no2               | str   | Y        | NO2          |
| o3                | str   | Y        | O3           |
| so2               | str   | Y        | SO2          |
| complexindex      | str   | Y        | 综合指数     |
| rank              | str   | Y        | 排名         |
| primary_pollutant | str   | Y        | 主要污染物   |
| temp              | str   | Y        | 温度         |
| humi              | str   | Y        | 湿度         |
| windlevel         | str   | Y        | 风级         |
| winddirection     | str   | Y        | 风向         |
| weather           | str   | Y        | 天气         |

接口示例-小时频率

```
import PPshare as PP
air_quality_hist_df = PP.air_quality_hist(city="北京", period="hour", start_date="2020-04-25", end_date="2020-04-27")
print(air_quality_hist_df)
```

数据示例-小时频率

```
                   time  aqi pm2_5 pm10  ... humi windlevel winddirection weather
0   2020-04-25 00:00:00  111    27  172  ...   16         4           东北风    晴转多云
1   2020-04-25 01:00:00  103    20  156  ...   16         4           东北风    晴转多云
2   2020-04-25 02:00:00  110    14  170  ...   18         3            北风    晴转多云
3   2020-04-25 03:00:00   87    11  123  ...   18         4            北风    晴转多云
4   2020-04-25 04:00:00   68     9   85  ...   16         4            北风    晴转多云
..                  ...  ...   ...  ...  ...  ...       ...           ...     ...
67  2020-04-27 19:00:00   68    48   85  ...   25         2           西南风       晴
68  2020-04-27 20:00:00   66    47   82  ...   25         2           西南风       晴
69  2020-04-27 21:00:00   67    46   84  ...   30         2           西南风       晴
70  2020-04-27 22:00:00   68    42   86  ...   28         3           西南风       晴
71  2020-04-27 23:00:00   69    43   87  ...   32         2           西南风       晴  
```

接口示例-天频率

```
import PPshare as PP
air_quality_hist_df = PP.air_quality_hist(city="北京", period="day", start_date="2020-03-20", end_date="2020-04-27")
print(air_quality_hist_df)
```

数据示例-天频率

```
          time  aqi pm2_5 pm10  ...    humi windlevel winddirection weather
0   2020-03-20   60    29   70  ...  28.667     1.542                      
1   2020-03-21   72    27   94  ...  25.250     2.042                      
2   2020-03-22   62    30   74  ...  32.375     2.167                      
3   2020-03-23   53    28   55  ...  35.333     1.542                      
4   2020-03-24   70    51   68  ...  36.958     1.458                      
5   2020-03-25  153   117  111  ...  49.833     1.792                      
6   2020-03-26   39     8   24  ...  41.500     3.125                      
7   2020-03-27   40     5   21  ...  15.083     2.500                      
8   2020-03-28   39    10   28  ...  23.917     1.792                      
9   2020-03-29   63    45   72  ...  35.292     1.958                      
10  2020-03-30   92    68   87  ...  48.208     2.208                      
11  2020-03-31   87    64   75  ...  53.826     2.130                      
12  2020-04-01   42     9   21  ...  19.250     2.250                      
13  2020-04-02   42    16   34  ...  34.458     1.500                      
14  2020-04-03   47    14   36  ...  28.000     2.000                      
15  2020-04-04  102    23  154  ...  24.708     2.500                      
16  2020-04-05   69    30   88  ...  32.250     1.667                      
17  2020-04-06   86    62  122  ...  42.500     1.667                      
18  2020-04-07   77    45  103  ...  34.167     2.042                      
19  2020-04-08   55    21   60  ...  33.042     1.750                      
20  2020-04-09   49    34   47  ...  56.500     1.875                      
21  2020-04-10   70    39   50  ...  46.542     1.417                      
22  2020-04-11   51    20   38  ...  30.083     1.708                      
23  2020-04-12   54    17   52  ...  13.333     1.958                      
24  2020-04-13   59    26   67  ...  31.435     1.391                      
25  2020-04-14  104    66  102  ...  35.500     1.750                      
26  2020-04-15   95    63   93  ...  45.292     1.875                      
27  2020-04-16   63    23   75  ...  54.583     2.250                      
28  2020-04-17   78    23   37  ...  36.292     2.167                      
29  2020-04-18   75    33   45  ...  40.000     1.500                      
30  2020-04-19   94    39   54  ...  49.227     2.546                      
31  2020-04-20   45     7   31  ...  23.708     3.167                      
32  2020-04-21   42     7   33  ...  18.917     2.833                      
33  2020-04-22   43     6   24  ...  12.125     2.667                      
34  2020-04-23   45     7   21  ...  13.727     2.091                      
35  2020-04-24   91    19  132  ...  12.375     2.875                      
36  2020-04-25   52    10   53  ...  16.375     2.458                      
37  2020-04-26   50    14   33  ...  25.375     1.792                      
38  2020-04-27   76    41   63  ...  35.958     1.875                      
```

接口示例-月频率

```python
import PPshare as PP
air_quality_hist_df = PP.air_quality_hist(city="北京", period="month", start_date="2019-04-25", end_date="2020-04-27")
print(air_quality_hist_df)
```

数据示例-月频率

```python
     aqi cityname     time  ... complexindex fcomplexindex primary_pollutant
0    94       北京  2019-05  ...         None         4.596              None
1   123       北京  2019-06  ...         None         4.629              None
2   106       北京  2019-07  ...         None         4.150              None
3    71       北京  2019-08  ...         None         3.206              None
4    97       北京  2019-09  ...         None         4.295              None
5    68       北京  2019-10  ...         None         3.829              None
6    76       北京  2019-11  ...         None         4.402              None
7    74       北京  2019-12  ...         None         4.225              None
8    87       北京  2020-01  ...         None         4.774              None
9    88       北京  2020-02  ...         None         4.349              None
10   62       北京  2020-03  ...         None         3.174              None          
```

### 空气质量排名

接口: air_quality_rank

目标地址: https://www.zq12369.com/environment.php

描述: 获取指定 **date** 时间点上所有城市(168个)的空气质量数据

限量: 单次返回所有的数据

输入参数

| 名称 | 类型 | 必选 | 描述                                                         |
| :--- | :--- | :--- | :----------------------------------------------------------- |
| date | str  | Y    | date=”2020-03-12″; “实时”: 当前时刻空气质量排名; “2020-03-12”: 当日空气质量排名; “2020-03”: 当月空气质量排名; “2019”: 当年空气质量排名; |

输出参数

| 名称       | 类型  | 默认显示 | 描述 |
| :--------- | :---- | :------- | :--- |
| 降序       | str   | Y        | 排名 |
| 省份       | str   | Y        | –    |
| 城市       | str   | Y        | –    |
| AQI        | float | Y        | –    |
| 空气质量   | str   | Y        | –    |
| PM2.5浓度  | str   | Y        | –    |
| 首要污染物 | str   | Y        | –    |

接口示例-实时

```python
import PPshare as PP
air_quality_rank_df = PP.air_quality_rank(date="实时")
print(air_quality_rank_df)
```

数据示例-实时

```
        降序  省份  城市    AQI  空气质量   PM2.5浓度  首要污染物
1      1.0  山西  太原  123.0  轻度污染  93 ug/m3  PM2.5
2      2.0  山东  德州  116.0  轻度污染  33 ug/m3   PM10
3      3.0  河南  安阳  111.0  轻度污染  60 ug/m3   PM10
4      4.0  吉林  长春  108.0  轻度污染  81 ug/m3  PM2.5
5      5.0  广东  佛山  100.0     良  55 ug/m3     O3
..     ...  ..  ..    ...   ...       ...    ...
164  164.0  广东  珠海   34.0     优  16 ug/m3    NaN
165  165.0  江苏  南通   34.0     优  23 ug/m3    NaN
166  166.0  浙江  舟山   30.0     优  11 ug/m3    NaN
167  167.0  四川  雅安   30.0     优  13 ug/m3    NaN
168  168.0  西藏  拉萨   29.0     优   9 ug/m3    NaN            
```

接口示例-具体某天

```python
import PPshare as PP
air_quality_rank_df = PP.air_quality_rank(date="2020-03-20")
print(air_quality_rank_df)
```

数据示例-具体某天

```
        降序   省份    城市    AQI  空气质量   PM2.5浓度 首要污染物
1      1.0   山西    晋城  124.0  轻度污染  42 ug/m3  PM10
2      2.0   山东    德州  120.0  轻度污染  36 ug/m3  PM10
3      3.0   河南    焦作  118.0  轻度污染  42 ug/m3  PM10
4      4.0   山东    菏泽  118.0  轻度污染  33 ug/m3  PM10
5      5.0   河南    安阳  118.0  轻度污染  44 ug/m3  PM10
..     ...  ...   ...    ...   ...       ...   ...
164  164.0   广东    深圳   45.0     优  29 ug/m3   NaN
165  165.0  黑龙江   哈尔滨   43.0     优  30 ug/m3   NaN
166  166.0   广东    惠州   43.0     优  30 ug/m3   NaN
167  167.0   新疆  乌鲁木齐   32.0     优  17 ug/m3   NaN
168  168.0   海南    海口   29.0     优  13 ug/m3   NaN
```

接口示例-具体某月

```python
import PPshare as PP
air_quality_rank_df = PP.air_quality_rank(date="2020-03")
print(air_quality_rank_df)
```

数据示例-具体某月

```
        降序  省份  城市  综合指数  最大指数  首要污染物
1      1.0  河南  安阳  5.29  1.60  PM2.5
2      2.0  山东  淄博  5.27  1.51  PM2.5
3      3.0  山东  枣庄  5.19  1.54  PM2.5
4      4.0  河南  焦作  5.16  1.54   PM10
5      5.0  陕西  西安  5.11  1.59   PM10
..     ...  ..  ..   ...   ...    ...
164  164.0  广东  惠州  2.52  0.69     O3
165  165.0  广东  中山  2.51  0.74     O3
166  166.0  浙江  舟山  2.27  0.70     O3
167  167.0  海南  海口  1.84  0.58     O3
168  168.0  西藏  拉萨  1.78  0.72     O3
```

接口示例-具体某年

```python
import PPshare as PP
air_quality_rank_df = PP.air_quality_rank(date="2019")
print(air_quality_rank_df)
```

数据示例-具体某年

```
        降序  省份   城市  综合指数  最大指数  首要污染物
1      1.0  河南   安阳  6.91  2.03  PM2.5
2      2.0  河北   邢台  6.85  1.86  PM2.5
3      3.0  河北  石家庄  6.80  1.80  PM2.5
4      4.0  河北   邯郸  6.77  1.89  PM2.5
5      5.0  山西   临汾  6.74  1.77  PM2.5
..     ...  ..  ...   ...   ...    ...
164  164.0  福建   厦门  2.98  0.84     O3
165  165.0  安徽   黄山  2.95  0.84     O3
166  166.0  浙江   舟山  2.68  0.82     O3
167  167.0  海南   海口  2.47  0.90     O3
168  168.0  西藏   拉萨  2.39  0.81     O3
```

### 监测点空气质量

接口: air_quality_watch_point

目标地址: https://www.zq12369.com/environment.php

描述: 获取每个城市的所有空气质量监测点的数据

限量: 单次返回指定城市指定日期区间的所有监测点的空气质量数据

输入参数

| 名称       | 类型 | 必选 | 描述                                                 |
| :--------- | :--- | :--- | :--------------------------------------------------- |
| city       | str  | Y    | city=”杭州”; 调用 air_city_list 接口获取所有城市列表 |
| start_date | str  | Y    | start_date=”2018-01-01″                              |
| end_date   | str  | Y    | end_date=”2020-04-27″                                |

输出参数

| 名称      | 类型  | 默认显示 | 描述       |
| :-------- | :---- | :------- | :--------- |
| pointname | str   | Y        | 监测点名称 |
| aqi       | float | Y        | AQI        |
| pm2_5     | float | Y        | PM2.5      |
| pm10      | float | Y        | PM10       |
| no2       | float | Y        | NO2        |
| so2       | float | Y        | SO2        |
| o3        | float | Y        | O3         |
| co        | float | Y        | CO         |

接口示例

```python
import PPshare as PP
air_quality_watch_point_df = PP.air_quality_watch_point(city="杭州", start_date="2018-01-01", end_date="2020-04-27")
print(air_quality_watch_point_df)
```

数据示例

```
   pointname      aqi  ...                  o3                  co
0       朝晖五区  83.9315  ...               162.4  1.3581999999999999
1       浙江农大  82.7099  ...                 183                 1.3
2        城厢镇  82.2618  ...                 175              1.2643
3         下沙  81.5554  ...                 175                 1.2
4        临平镇  80.2429  ...               174.6              1.2182
5       和睦小学  79.7488  ...                 170              1.2209
6         西溪  78.5832  ...                 173                 1.1
7         滨江  77.9729  ...                 172                 1.3
8        卧龙桥  71.1863  ...                 161             1.13265
9         云栖  70.4404  ...                 168                 1.2
10       千岛湖  55.8762  ...  143.00000000000003                   1        
```

## 财富排行榜-中文

接口: fortune_rank

目标地址: http://www.fortunechina.com/fortune500/node_65.htm

描述: 获取指定年份财富世界500强公司排行榜

限量: 单次返回某一个年份的所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述        |
| :--- | :--- | :--- | :---------- |
| year | int  | Y    | year=”2019″ |

输出参数

| 名称     | 类型  | 默认显示 | 描述     |
| :------- | :---- | :------- | :------- |
| 公司名称 | str   | Y        | –        |
| 营业收入 | float | Y        | 注意单位 |
| 利润     | float | Y        | 注意单位 |
| 国家     | float | Y        | –        |

接口示例

```python
import PPshare as PP
fortune_df = PP.fortune_rank(year="2019")
print(fortune_df)
```

数据示例

```
公司名称(中英文)  营业收入(百万美元)  利润(百万美元)   国家
0                             沃尔玛（WALMART)    514405.0    6670.0   美国
1                中国石油化工集团公司（SINOPEC GROUP)    414649.9    5845.0   中国
2            荷兰皇家壳牌石油公司（ROYAL DUTCH SHELL)    396556.0   23352.0   荷兰
3    中国石油天然气集团公司（CHINA NATIONAL PETROLEUM)    392976.6    2270.5   中国
4                       国家电网公司（STATE GRID)    387056.0    8174.8   中国
..                                     ...         ...       ...  ...
495                              纽柯（NUCOR)     25067.3    2360.8   美国
496               蒙特利尔银行（BANK OF MONTREAL)     25002.7    4235.1  加拿大
497        泰康保险集团（TAIKANG INSURANCE GROUP)     24931.7    1794.6   中国
498        Ultrapar控股公司（ULTRAPAR HOLDINGS)     24816.0     314.8   巴西
499                  法国液化空气集团（AIR LIQUIDE)     24796.6    2494.2   法国
```

## 财富排行榜-英文

接口: fortune_rank_eng

目标地址: https://fortune.com/global500/

描述: 获取指定年份财富世界500强公司排行榜-英文版本, 从1995年开始, 数据和格式较中文版本完整

限量: 单次返回某一个年份的所有历史数据, 早期数据可能不足 500 家公司

输入参数

| 名称 | 类型 | 必选 | 描述        |
| :--- | :--- | :--- | :---------- |
| year | int  | Y    | year=”2019″ |

输出参数

| 名称 | 类型  | 默认显示 | 描述                             |
| :--- | :---- | :------- | :------------------------------- |
| rank | str   | Y        | 排名                             |
| –    | float | Y        | 以当年的数据为准, 输入的字段不一 |

接口示例

```python
import PPshare as PP
fortune_df = PP.fortune_rank_eng(year="2015")
print(fortune_df)
```

数据示例

```
     rank   revenues  ... hqCountry                       title
476     1  175835.60  ...     Japan      Mitsubishi Corporation
477     2  171490.50  ...     Japan      Mitsui &amp; Co., Ltd.
478     3  167824.70  ...     Japan          Itochu Corporation
479     4  162475.90  ...     Japan        Sumitomo Corporation
480     5  154951.20  ...      U.S.  General Motors Corporation
..    ...        ...  ...       ...                         ...
194   496    7919.20  ...   Germany                Quelle Group
195   497    7868.70  ...   Germany             SPAR Handels AG
196   498    7857.10  ...      U.S.        Banc One Corporation
197   499    7849.50  ...     Japan     New Oji Paper Co., Ltd.
198   500    7843.80  ...     Japan    Toyo Seikan Kaisha, Ltd.
```

## 电影票房-实时

接口: box_office_spot(疫情期间，暂无数据)

目标地址: https://maoyan.com/board/1

描述: 获取上映中电影的实时票房数据

限量: 将昨日国内热映的影片, 按照昨日票房从高到低排序, 每天上午 10 点更新

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称     | 类型 | 默认显示 | 描述         |
| :------- | :--- | :------- | :----------- |
| 电影名称 | str  | –        | –            |
| 主演     | str  | –        | –            |
| 上映时间 | str  | –        | 注意具体时区 |
| 实时票房 | str  | –        | 注意票房单位 |
| 总票房   | str  | –        | 注意票房单位 |

接口示例

```python
import PPshare as PP
box_office_spot_df = PP.box_office_spot()
print(box_office_spot_df)
```

数据示例

```python
          电影名称                           主演             上映时间          实时票房  \
0           误杀                  主演：肖央,谭卓,陈冲  上映时间：2019-12-13  实时票房:7981.7万   
1          天·火                 主演：王学圻,昆凌,窦骁  上映时间：2019-12-12  实时票房:3569.5万   
2        冰雪奇缘2   主演：克里斯汀·贝尔,伊迪娜·门泽尔,乔纳森·格罗夫  上映时间：2019-11-22  实时票房:1649.3万   
3  勇敢者游戏2：再战巅峰        主演：道恩·强森,凯伦·吉兰,杰克·布莱克  上映时间：2019-12-06  实时票房:1395.1万   
4       被光抓走的人                 主演：黄渤,王珞丹,谭卓  上映时间：2019-12-13  实时票房:1176.2万   
5        我为你牺牲                 主演：李琦,国永振,陈姝  上映时间：2019-12-05  实时票房:1012.7万   
6      南方车站的聚会                 主演：胡歌,桂纶镁,廖凡  上映时间：2019-12-06   实时票房:514.8万   
7         早安公主               主演：田雨,朱颜曼滋,邱雨铄  上映时间：2019-12-13   实时票房:411.0万   
8         唐顿庄园     主演：休·博纳维尔,劳拉·卡尔迈克尔,吉姆·卡特  上映时间：2019-12-13   实时票房:403.3万   
9         利刃出鞘  主演：丹尼尔·克雷格,克里斯·埃文斯,安娜·德·阿玛斯  上映时间：2019-11-29   实时票房:369.6万   
           总票房  
0    总票房:2.25亿  
1    总票房:1.41亿  
2    总票房:7.84亿  
3    总票房:2.69亿  
4  总票房:5894.0万  
5  总票房:4696.0万  
6    总票房:1.95亿  
7  总票房:1170.0万  
8  总票房:1171.0万  
9    总票房:1.92亿  
```

## 生活成本

接口: cost_living

目标地址: https://expatistan.com/cost-of-living/index

描述: 获取世界各大城市生活成本数据

限量: 返回当前时点所有数据

输入参数

| 名称   | 类型 | 必选 | 描述                                                         |
| :----- | :--- | :--- | :----------------------------------------------------------- |
| region | str  | –    | region=”world”, 默认, 返回所有城市数据, 其他城市请查看 **城市一览表** |

城市一览表

| 名称          | 类型             |
| :------------ | :--------------- |
| europe        | 欧洲             |
| north-america | 北美洲           |
| latin-america | 拉丁美洲         |
| asia          | 亚洲             |
| middle-east   | 中东             |
| africa        | 非洲             |
| oceania       | 大洋洲           |
| world         | 默认全球所有城市 |

输出参数

| 名称  | 类型 | 默认显示 | 描述     |
| :---- | :--- | :------- | :------- |
| rank  | str  | –        | 排名     |
| city  | str  | –        | 城市名称 |
| index | str  | –        | 价格指数 |

接口示例

```python
import PPshare as PP
cost_living_df = PP.cost_living()
print(cost_living_df)
```

数据示例

```python
      rank                                       city  index
0      1st              Grand Cayman (Cayman Islands)    271
1      2nd  Mountain View, California (United States)    259
2      3rd      Palo Alto, California (United States)    259
3      4th              New York City (United States)    253
4      5th                       Zurich (Switzerland)    246
..     ...                                        ...    ...
295  296th                             Indore (India)     62
296  297th                             Madras (India)     62
297  298th                        Córdoba (Argentina)     58
298  299th                        Rosario (Argentina)     56
299  300th                        Mendoza (Argentina)     48
```

## 新经济公司

### 倒闭公司

接口: death_company

目标地址: https://www.itjuzi.com/deathCompany

描述: 获取新经济死亡公司数据库

限量: 返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称     | 类型 | 默认显示 | 描述 |
| :------- | :--- | :------- | :--- |
| 公司名称 | str  | –        | –    |
| 成立时间 | str  | –        | –    |
| 倒闭时间 | str  | –        | –    |
| 存活天数 | str  | –        | –    |
| 总投资   | str  | –        | –    |
| 所属行业 | str  | –        | –    |
| 所属省份 | str  | –        | –    |

接口示例

```python
import PPshare as PP
death_df = PP.death_company()
print(death_df)
```

数据示例

```python
     com_name        born com_change_close_date  ...  total_money cat_name com_prov
0         空车位  2015-06-01            2017-08-07  ...         None     汽车交通       北京
1        禅啸星空  2015-06-01            2017-08-07  ...         None     文娱传媒       北京
2         壹校招  2015-05-01            2017-08-07  ...         None     企业服务       广东
3  灵犀Linkhere  2015-10-01            2017-08-07  ...         None     社交网络       上海
4        弹个吉他  2015-04-01            2017-08-07  ...         None       教育       北京
5        共时数据  2014-11-01            2017-08-07  ...         None       金融       浙江
6        缘分市集  2015-03-01            2017-08-07  ...         None     社交网络       北京
7         馋一指  2014-12-01            2017-08-07  ...         None     电子商务      内蒙古
8        红果生活  2014-10-01            2017-08-07  ...         None     本地生活       云南
9         壹手车  2014-12-01            2017-08-07  ...         None     汽车交通       北京
```

### 独角兽公司

接口: nicorn_company

目标地址: https://www.itjuzi.com

描述: 获取独角兽公司数据库

限量: 返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称     | 类型 | 默认显示 | 描述 |
| :------- | :--- | :------- | :--- |
| 公司名称 | str  | –        | –    |
| 成立时间 | str  | –        | –    |
| 总投资   | str  | –        | –    |
| 所属行业 | str  | –        | –    |
| 所属省份 | str  | –        | –    |

接口示例

```python
import PPshare as PP
nicorn_df = PP.nicorn_company()
print(nicorn_df)
```

数据示例

```python
       com_id                                   com_logo_archive com_name  \
0       18092  https://cdn.itjuzi.com/images/900637e42dec75cc...     蚂蚁金服   
1    34048160  https://cdn.itjuzi.com/images/c36e423fd300b774...     字节跳动   
2       24348  https://cdn.itjuzi.com/images/116bef02d9859fbf...      阿里云   
3         157  https://cdn.itjuzi.com/images/8badb6e5188dbfb3...       滴滴   
4       16470  https://cdn.itjuzi.com/images/2b4263b060d94abd...      陆金所   
225      1634  https://cdn.itjuzi.com/images/f2d94f031e8ed8fe...      返利网   
226       335  https://cdn.itjuzi.com/images/141dd540d2894608...   一起教育科技   
227     25188  https://cdn.itjuzi.com/images/9d06a4ebeed7bee1...     微鲸科技   
228     53629  https://cdn.itjuzi.com/images/3acab9539a788f02...  Momenta   
229     17081  https://cdn.itjuzi.com/images/6948f54e6b3e28c3...     云鸟配送   
    com_prov com_city  invse_year  invse_month  invse_day  \
0         浙江       杭州        2018            6         23   
1         北京      海淀区        2018           10         20   
2         浙江       杭州        2015            7         29   
3         北京      海淀区        2019            7         25   
4         上海     浦东新区        2018           12         15   
225       上海      崇明县        2015            4         21   
226       上海      嘉定区        2018            3         20   
227       上海     浦东新区        2015            8         14   
228       北京      海淀区        2018           10         18   
229       北京      海淀区        2017            2         13   
     invse_guess_particulars  invse_detail_money  invse_currency_id  \
0                  100000000              160000                  1   
1                    7500000              400000                  2   
2                   43550000              600000                  1   
3                    5800000               60000                  2   
4                    3940000              133000                  2   
225                   100000               10000                  2   
226                   100000               25000                  2   
227                   650000              200000                  1   
228                   100000               20000                  2   
229                   100000               10000                  2   
     invse_similar_money_id cat_name sub_cat_name  invse_round_id  \
0                         4       金融       金融综合服务              11   
1                         4     文娱传媒        媒体及阅读               7   
2                         4     企业服务       IT基础设施              11   
3                         4     汽车交通         交通出行              11   
4                         4       金融           理财               4   
225                       4     电子商务       电商解决方案               4   
226                       4       教育          K12               6   
227                       4       硬件         消费电子               2   
228                       4     汽车交通      自动/无人驾驶              11   
229                       4       物流         同城物流               5   
           money invse_money   round  
0    15384615.38        ￥16亿    战略投资  
1     7500000.00        $40亿  F轮-上市前  
2     6700000.00        ￥60亿    战略投资  
3     5800000.00         $6亿    战略投资  
4     3940000.00      $13.3亿      C轮  
225    100000.00         $1亿      C轮  
226    100000.00       $2.5亿      E轮  
227    100000.00        ￥20亿      A轮  
228    100000.00         $2亿    战略投资  
229    100000.00         $1亿      D轮  
```

### 千里马公司

接口: maxima_company

目标地址: https://www.itjuzi.com

描述: 获取千里马公司数据库

限量: 返回所有历史数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称     | 类型 | 默认显示 | 描述 |
| :------- | :--- | :------- | :--- |
| 公司名称 | str  | –        | –    |
| 成立时间 | str  | –        | –    |
| 总投资   | str  | –        | –    |
| 所属行业 | str  | –        | –    |
| 所属省份 | str  | –        | –    |

接口示例

```python
import PPshare as PP
maxima_df = PP.maxima_company()
print(maxima_df)
```

数据示例

```python
       com_id                                   com_logo_archive com_name  \
0       71450  https://cdn.itjuzi.com/images/f7b24798925366be...  震坤行工业超市   
1       51816  https://cdn.itjuzi.com/images/aea5b40629a453f8...     能力风暴   
2       13023  https://cdn.itjuzi.com/images/4875e1ca28fdee9e...       达令   
3       77478  https://cdn.itjuzi.com/images/a3e1719475670315...     奈雪的茶   
4       10727  https://cdn.itjuzi.com/images/53dec5f8b5b69de2...      车置宝   
652     20743  https://cdn.itjuzi.com/images/37c552ea7b695bc0...      未来域   
653     33390  https://cdn.itjuzi.com/images/6c118658e0e9d487...     慧择保险   
654  32967275  https://cdn.itjuzi.com/images/da96ddf10e8709bb...      微天下   
655     15553  https://cdn.itjuzi.com/images/7b8d53bbc21e5ed8...     小熊尼奥   
656     17958  https://cdn.itjuzi.com/images/435f1f5e7fe4882b...      好彩头   
     com_scope_id cat_name com_prov  invse_year  invse_month  invse_day  \
0             145     电子商务       上海        2019            6         18   
1             103       硬件       上海        2016           10          8   
2             145     电子商务       北京        2017           11          3   
3              70     本地生活       广东        2018            3         19   
4              28     汽车交通       江苏        2018            6          6   
652            38     房产服务       北京        2017            6          8   
653            12       金融       广东        2016            8          3   
654           126     企业服务       浙江        2018            6         15   
655             1       教育       上海        2016           10         21   
656           145     电子商务       福建        2015            2         15   
     invse_similar_money_id  invse_guess_particulars  invse_detail_money  \
0                         4                    96000               16000   
1                         4                   600000               60000   
2                         3                   600000                   0   
3                         4                   600000                   0   
4                         4                   600000               80000   
652                       4                   100000               20000   
653                       4                   100000               10000   
654                       4                   100000               20000   
655                       4                   100000               25000   
656                       4                   100000               20000   
     invse_currency_id  invse_round_id     money invse_money round  
0                    2               5  624000.0       $1.6亿    D轮  
1                    1               2  600000.0         ￥6亿    A轮  
2                    1              11  600000.0        ￥数千万  战略投资  
3                    1              14  600000.0      ￥亿元及以上   A+轮  
4                    1               5  600000.0         ￥8亿    D轮  
652                  1               3  100000.0         ￥2亿    B轮  
653                  1              16  100000.0         ￥1亿   B+轮  
654                  1               2  100000.0         ￥2亿    A轮  
655                  1               3  100000.0       ￥2.5亿    B轮  
656                  1               2  100000.0         ￥2亿    A轮  
```

## 特许经营许可

接口: franchise_china

目标地址: http://txjy.syggs.mofcom.gov.cn/

描述: 获取中国-特许经营许可数据

限量: 单次返回所有特许经营许可数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称       | 类型 | 默认显示 | 描述 |
| :--------- | :--- | :------- | :--- |
| 特许人名称 | str  | Y        | –    |
| 备案时间   | str  | Y        | –    |
| 地址       | str  | Y        | –    |

接口示例

```python
import PPshare as PP
franchise_china_df = PP.franchise_china()
print(franchise_china_df)
```

数据示例

```python
                             特许人名称  ...                                                 地址
0             特许人名称：深圳市百果园投资发展有限公司  ...                  地址：深圳市龙岗区南湾街道下李朗社区平吉大道1号建昇大厦B1305
1                特许人名称：深圳市唯爱控股有限公司  ...                       地址：深圳市福田区福保街道石厦北三街4号雅云轩29楼A室
2               特许人名称：广州绿色医药贸易有限公司  ...                      地址：广州市白云区京溪桥东侧广州新百佳小商品城B1303室
3              特许人名称：广州萌茶茶餐饮管理有限公司  ...                         地址：广州市天河区黄埔大道中309号自编3-18-7
4              特许人名称：福州汕之膳餐饮管理有限公司  ...     地址：福建省福州市台江区瀛洲街道江滨中大道116号君临闽江公寓1-7#楼连地下1层216铺位
                            ...  ...                                                ...
5395           特许人名称：北京车爵仕汽车用品有限公司  ...                          地址：北京市宣武区广安门外马连道路11号1125室
5396          特许人名称：北京风尚引力投资顾问有限公司  ...                             地址：北京市大兴区魏善庄镇工业区龙江路95号
5397          特许人名称：奥力赛克服装（北京）有限公司  ...                    地址：北京市宣武区宣武门外大街6号（庄胜广场北办公室楼902）
5398        特许人名称：中达睿信投资管理(北京)有限公司  ...                 地址：北京市丰台区航丰路1号院2号楼1015、1016、1017房间
5399  特许人名称：DDBR International LLC  ...  地址：The Corporation Trust Company, Corporation ...
```

## 慈善中国

### 慈善组织查询

接口: charity_china_organization

目标地址: http://cishan.chinanpo.gov.cn/biz/ma/csmh/a/csmhaindex.html

描述: 获取慈善中国-慈善组织查询数据

限量: 单次返回所有慈善中国-慈善组织查询数据, 但是要注意网络稳定性, 建议获取后存储

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称             | 类型 | 默认显示 | 描述 |
| :--------------- | :--- | :------- | :--- |
| 序号             | str  | Y        | –    |
| 统一社会信用代码 | str  | Y        | –    |
| 组织名称         | str  | Y        | –    |
| 成立时间         | str  | Y        | –    |
| 登记管理机关     | str  | Y        | –    |

接口示例

```python
import PPshare as PP
charity_china_organization_df = PP.charity_china_organization()
print(charity_china_organization_df)
```

数据示例

```
    序号            统一社会信用代码              组织名称          成立时间            登记管理机关
0    1  53330000501876705E        温州市人民教育基金会   Jan 1, 1989            浙江省民政厅
1    2  51440100572156377E        广州市乐善助学促进会  Mar 14, 2011            广州市民政局
2    3  51440106C149234018         广州市天河区慈善会  Mar 26, 1995         广州市天河区民政局
3    4  13220100013829643R           长春市红十字会  Nov 11, 1998        长春市机构编制委员会
4    5  514206245037423566            南漳县慈善会   Apr 3, 1994             南漳民政局
5    6  12420624MB1856281C           南漳县红十字会  Aug 13, 2018      南漳县事业单位登记管理局
6    7  51370103MJD7207131          济南市中慈善总会  Aug 30, 2005         济南市市中区民政局
7    8  13330726674784083R           浦江县红十字会  Jun 15, 2010        浦江县机构编制委员会
8    9  13450100007578462M           南宁市红十字会  Dec 29, 2001        南宁市机构编制委员会
9   10  51222402774243137N           图们市慈善总会  Aug 29, 2003            图们市民政局
10  11  51110102500530454R          北京西城慈善协会  Sep 10, 1995         北京市西城区民政局
11  12  12411402554217009W        商丘市梁园区红十字会  Oct 16, 1998       商丘市梁园区编制委员会
12  13  51661200697824762N  新疆生产建设兵团第十二师红十字会  Oct 24, 2008           第十二师民政局
13  14  11421304MB1C163392            随县红十字会  Sep 30, 2009  中共随县县委机构编制委员会办公室
14  15  123203054665457747        徐州市贾汪区红十字会  Sep 20, 2012         徐州市贾汪区民政局
```

### 慈善信托查询

接口: charity_china_trust

目标地址: http://cishan.chinanpo.gov.cn/biz/ma/csmh/e/csmheindex.html

描述: 获取慈善中国-慈善信托查询数据

限量: 单次返回所有慈善中国-慈善信托查询数据, 但是要注意网络稳定性, 建议获取后存储

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称               | 类型 | 默认显示 | 描述 |
| :----------------- | :--- | :------- | :--- |
| 序号               | str  | Y        | –    |
| 慈善信托名称       | str  | Y        | –    |
| 备案单位           | str  | Y        | –    |
| 受托人             | str  | Y        | –    |
| 财产总规模（万元） | str  | Y        | –    |
| 信托期限           | str  | Y        | –    |

接口示例

```python
import PPshare as PP
charity_china_trust_df = PP.charity_china_trust()
print(charity_china_trust_df)
```

数据示例

```python
    序号                    慈善信托名称  ... 财产总规模（万元）    信托期限
0    1     华宝善行•抗击新型冠状病毒肺炎疫情慈善信托  ...    272.81      2年
1    2           华信信托-抗击新型肺炎慈善信托  ...    100.00   无固定期限
2    3        “上善”系列赴鄂救援抗击疫情慈善信托  ...    500.00      2年
3    4                   泰来县红十字会  ...  30000.00      5年
4    5  天信世嘉·信德众志成城抗击新型肺炎01期慈善信托  ...     50.00      1年
5    6                  根生博爱慈善信托  ...    114.70      永续
6    7         中融-深圳市慈善会托普思维慈善信托  ...     50.00      10
7    8             重庆信托·温暖童心慈善信托  ...      7.00      1年
8    9             华润信托•银杏乐天慈善信托  ...    100.00     10年
9   10            光信善·益中专项教育慈善信托  ...   1000.00   无固定期限
10  11      光信善·祥生扶贫1号阳光益投系列慈善信托  ...      5.00      2年
11  12                    骏昆慈善信托  ...      5.00   无固定期限
12  13          厦门信托-星之助公益进堂慈善信托  ...     12.00  不设固定期限
13  14      光信善·瀚京尊享1号阳光益投系列慈善信托  ...     10.00      3年
14  15                光信善·云焕慈善信托  ...     10.00      永续
```

### 募捐方案备案

接口: charity_china_plan

目标地址: http://cishan.chinanpo.gov.cn/biz/ma/csmh/c/csmhcindex.html

描述: 获取慈善中国-募捐方案备案数据

限量: 单次返回所有慈善中国-募捐方案备案数据, 但是要注意网络稳定性, 建议获取后存储

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称   | 类型 | 默认显示 | 描述 |
| :----- | :--- | :------- | :--- |
| 组织   | str  | Y        | –    |
| 状态   | str  | Y        | –    |
| 名称   | str  | Y        | –    |
| 备案号 | str  | Y        | –    |

接口示例

```python
import PPshare as PP
charity_china_plan_df = PP.charity_china_plan()
print(charity_china_plan_df)
```

数据示例

```
                 组织  ...                                备案号
0           重庆市慈善总会  ...  募捐方案备案编号：51500000504029915YA20015
1           重庆市慈善总会  ...  募捐方案备案编号：51500000504029915YA20014
2           重庆市慈善总会  ...  募捐方案备案编号：51500000504029915YA20013
3  新疆维吾尔族自治区资助教育基金会  ...  募捐方案备案编号：536501045762170776A20003
4           钦州市红十字会  ...  募捐方案备案编号：13450700K32947229MA20001
5           山东省红十字会  ...  募捐方案备案编号：133700000045025699A20001
6           南宁市红十字会  ...  募捐方案备案编号：13450100007578462MA20001
7       天祝藏族自治县红十字会  ...  募捐方案备案编号：11620623576286750DA20001
```

### 慈善项目进展

接口: charity_china_progress

目标地址: http://cishan.chinanpo.gov.cn/biz/ma/csmh/b/csmhbindex.html

描述: 获取慈善中国-慈善项目进展数据

限量: 单次返回所有慈善中国-慈善项目进展数据, 但是要注意网络稳定性, 建议获取后存储

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称         | 类型 | 默认显示 | 描述 |
| :----------- | :--- | :------- | :--- |
| 组织         | str  | Y        | –    |
| 名称         | str  | Y        | –    |
| 项目编号     | str  | Y        | –    |
| 发起慈善组织 | str  | Y        | –    |
| 项目状态     | str  | Y        | –    |

接口示例

```python
import PPshare as PP
charity_china_progress_df = PP.charity_china_progress()
print(charity_china_progress_df)
```

数据示例

```
          组织                             名称  ...     发起慈善组织 项目状态
0  中国华侨公益基金会                爱步寒冷—冰雪徒步志愿服务项目  ...  中国华侨公益基金会  已完成
1  中国华侨公益基金会      童沐书香 首都图书馆文化志愿服务讲故事智力脱贫项目  ...  中国华侨公益基金会  已完成
2  中国华侨公益基金会                      经典导读，点亮心灯  ...  中国华侨公益基金会  已完成
3  中国华侨公益基金会            山区帮扶励志“阳光小讲台”志愿服务活动  ...  中国华侨公益基金会  已完成
4  中国华侨公益基金会                 青春守护点对点 关爱留守儿童  ...  中国华侨公益基金会  已完成
5  中国华侨公益基金会                      爱心部落·公益超市  ...  中国华侨公益基金会  已完成
6  中国华侨公益基金会             农村牧区“12345”扶贫攻坚义工队  ...  中国华侨公益基金会  已完成
7  中国华侨公益基金会  “授渔”-呼和浩特天使公益协会山区贫困儿童家庭精准扶贫项目  ...  中国华侨公益基金会  已完成
```

### 慈善组织年报

接口: charity_china_report

目标地址: http://cishan.chinanpo.gov.cn/biz/ma/csmh/d/csmhdindex.html

描述: 获取慈善中国-慈善组织年报数据

限量: 单次返回所有慈善中国-慈善组织年报数据, 但是要注意网络稳定性, 建议获取后存储

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称             | 类型 | 默认显示 | 描述                |
| :--------------- | :--- | :------- | :------------------ |
| 序号             | str  | Y        | –                   |
| 统一社会信用代码 | str  | Y        | –                   |
| 组织名称         | str  | Y        | –                   |
| 社会组织类别     | str  | Y        | –                   |
| 年度             | str  | Y        | –                   |
| 操作             | str  | Y        | 提供下载 PDF 的地址 |

接口示例

```python
import PPshare as PP
charity_china_report_df = PP.charity_china_report()
print(charity_china_report_df)
```

数据示例

```python
   序号  ...                                                 操作
0   1  ...  http://cishan.chinanpo.gov.cn/mz/upload/pub/lo...
1   2  ...  http://cishan.chinanpo.gov.cn/mz/upload/pub/lo...
2   3  ...  http://cishan.chinanpo.gov.cn/mz/upload/pub/lo...
3   4  ...  http://cishan.chinanpo.gov.cn/mz/upload/pub/lo...
4   5  ...  http://cishan.chinanpo.gov.cn/mz/upload/pub/lo...
5   6  ...  http://cishan.chinanpo.gov.cn/mz/upload/pub/lo...
6   7  ...  http://cishan.chinanpo.gov.cn/mz/upload/pub/lo...
7   8  ...  http://cishan.chinanpo.gov.cn/mz/upload/pub/lo...
8   9  ...  http://cishan.chinanpo.gov.cn/mz/upload/pub/lo...
9  10  ...  http://cishan.chinanpo.gov.cn/mz/upload/pub/lo...
```

### 募捐信息平台

接口: charity_china_platform

目标地址: http://cishan.chinanpo.gov.cn/biz/ma/csmh/h/csmhhindex.html

描述: 获取慈善中国-募捐信息平台数据

限量: 单次返回所有慈善中国-募捐信息平台数据, 但是要注意网络稳定性, 建议获取后存储

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称     | 类型 | 默认显示 | 描述 |
| :------- | :--- | :------- | :--- |
| 网址     | str  | Y        | –    |
| 组织     | str  | Y        | –    |
| 名称     | str  | Y        | –    |
| 联系方式 | str  | Y        | –    |

接口示例

```python
import PPshare as PP
charity_china_platform_df = PP.charity_china_platform()
print(charity_china_platform_df)
```

数据示例

```
                                                   网址  ...                       联系方式
0                               http://gongyi.qq.com/  ...      gongyi_TS@tencent.com
1                          https://gongyi.taobao.com/  ...              0571-88157858
2                            https://love.alipay.com/  ...              0571-88158090
3                             http://gongyi.weibo.com  ...               010-60618539
4   http://gongyi.m.jd.com/index.html?&utm_source=...  ...               010-89126602
5                            http://gongyi.baidu.com/  ...               010-50803597
6                            http://www.gongyibao.cn/  ...               010-82609011
7                           http://xhgy.xinhuanet.com  ...                 4000260110
8                             https://www.qschou.com/  ...                   10101019
9                  https://www.lianquan.org/index.jsp  ...           021-60146234-801
10                               http://www.gyufc.org  ...                 4008599595
11                          http://gongyi.meituan.com  ...                 4000810990
12                                 javascript:void(0)  ...  didigongyi@didiglobal.com
13                 https://www.shanyuanfoundation.com  ...        sygy@17shanyuan.com
14  http://channels1.mall.icbc.com.cn/channels/pc/...  ...                 4009195588
15                   http://www.shuidichou.com/gongyi  ...      gongyi@shuidichou.com
16                          https://gongyi.suning.com  ...        gongyi@cnsuning.com
17                        https://www.bangbangwang.cn  ...               010-85693651
18                           http://gongyi.yeepay.com  ...               4001-500-800
19                           http://www.zgshfp.com.cn  ...               400-600-1017
20                             http://www.mca.gov.cn/  ...                       None
21              http://www.chinanpo.gov.cn/index.html  ...                       None
22                      http://www.chinavolunteer.cn/  ...                       None
23               http://www.jianzai.gov.cn/DRpublish/  ...                       None
24                         http://www.neusoft.com/cn/  ...                       None
25                 http://www.foundationcenter.org.cn  ...                       None
26                                                  #  ...                       None
27                                                  #  ...                       None
```

## 微博舆情报告

接口: stock_js_weibo_report

目标地址: https://datacenter.jin10.com/market

描述: 获取微博舆情报告中近期受关注的股票

限量: 单次返回指定时间内微博舆情报告中近期受关注的股票

输入参数

| 名称        | 类型 | 必选 | 描述                                                         |
| :---------- | :--- | :--- | :----------------------------------------------------------- |
| time_period | str  | Y    | time_period=”CNHOUR12″; 详见下表**time_period参数一览表**, 可通过调用 **stock_js_weibo_nlp_time** 获取 |

time_period参数一览表

| 参数     | 说明   |
| :------- | :----- |
| CNHOUR2  | 2小时  |
| CNHOUR6  | 6小时  |
| CNHOUR12 | 12小时 |
| CNHOUR24 | 1天    |
| CNDAY7   | 1周    |
| CNDAY30  | 1月    |

输出参数

| 名称 | 类型 | 默认显示 | 描述         |
| :--- | :--- | :------- | :----------- |
| name | str  | Y        | 股票名称     |
| rate | str  | Y        | 人气排行指数 |

接口示例

```python
import PPshare as PP
stock_js_weibo_report_df = PP.stock_js_weibo_report(time_period="CNHOUR12")
print(stock_js_weibo_report_df)
```

数据示例

```
    name   rate
0   黄河旋风   9.86
1   东方财富   6.91
2   海王生物  10.09
3   秀强股份   4.56
4   江淮汽车  10.08
5    欧菲光  10.00
6   中兴通讯   9.98
7   鲁抗医药   9.97
8   海陆重工  10.07
9   中通客车   9.75
10  华天科技  10.02
11  亚星客车   7.70
12  中国平安  -0.66
13  新日恒力   9.98
14   同花顺  -0.90
15  赣锋锂业  10.00
16  北玻股份  10.09
17   比亚迪   7.02
18  沪电股份  10.00
19   太平洋   9.92
20  深康佳A  -8.02
21  天齐锂业   9.34
22  泰达股份   9.99
23  中信证券   0.68
24  欣龙控股  10.00
25  均胜电子  10.00
26   安居宝   9.98
27  联环药业  10.00
28  乾照光电   2.93
29  山东黄金  -3.38
30  国海证券   7.20
31  永鼎股份  10.00
32   漫步者  -4.51
33  江苏吴中  10.03
34  国农科技  10.00
35  中环股份   9.98
36  阳普医疗  10.01
37   新宙邦   8.91
38  兴森科技   9.98
39  南大光电   7.46
40  四环生物   9.98
41  海特高新  10.01
42  光环新网   7.97
43  晶方科技  -2.73
44  铜峰电子  10.04
45  华力创通  10.00
46  复星医药   9.41
47  力帆股份  10.14
48  永太科技   9.65
49  四维图新   8.76
```

## 彭博亿万富豪指数

接口: index_bloomberg_billionaires

目标地址: https://www.bloomberg.com/billionaires/

描述: 获取彭博亿万富豪指数, 全球前 500 名

限量: 单次返回所有数据彭博亿万富豪排名数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称            | 类型 | 默认显示 | 描述            |
| :-------------- | :--- | :------- | :-------------- |
| rank            | str  | Y        | Rank            |
| name            | str  | Y        | Name            |
| total_net_worth | str  | Y        | Total net worth |
| last_change     | str  | Y        | $ Last change   |
| YTD_change      | str  | Y        | $ YTD change    |
| country         | str  | Y        | Country         |
| industry        | str  | Y        | Industry        |

接口示例

```python
import PPshare as PP
index_bloomberg_billionaires_df = PP.index_bloomberg_billionaires()
print(index_bloomberg_billionaires_df)
```

数据示例

```
    rank                        name  ...             country     industry
0      1                  Jeff Bezos  ...       United States   Technology
1      2                  Bill Gates  ...       United States   Technology
2      3             Mark Zuckerberg  ...       United States   Technology
3      4             Bernard Arnault  ...              France     Consumer
4      5               Steve Ballmer  ...       United States   Technology
..   ...                         ...  ...                 ...          ...
494  496                 Ira Rennert  ...       United States  Commodities
495  497  Traudl Engelhorn-Vechiatto  ...         Switzerland  Diversified
496  498            Sergey Galitskiy  ...  Russian Federation       Retail
497  499                  Xu Jingren  ...               China  Health Care
498  500                Shi Yonghong  ...           Singapore     Consume
```

# PPshare 指数数据

## 中国股票指数数据

### 实时行情数据

接口: stock_zh_index_spot

目标地址: http://vip.stock.finance.sina.com.cn/mkt/

描述: 中国股票指数数据-所有指数

限量: 单次返回所有指数的实时行情数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数-实时行情数据

| 名称   | 类型  | 默认显示 | 描述 |
| :----- | :---- | :------- | :--- |
| 代码   | str   | Y        | –    |
| 名称   | str   | Y        | –    |
| 最新价 | float | Y        | –    |
| 涨跌幅 | float | Y        | –    |
| 涨跌额 | float | Y        | –    |
| 买入   | float | Y        | –    |
| 卖出   | float | Y        | –    |
| 成交量 | float | Y        | –    |
| 成交额 | float | Y        | –    |
| 今开   | float | Y        | –    |
| 昨收   | float | Y        | –    |
| 最高   | float | Y        | –    |
| 最低   | float | Y        | –    |

接口示例

```
import PPshare as PP
stock_df = PP.stock_zh_index_spot()
print(stock_df)
```

数据示例-实时行情数据

```
       symbol  name      trade pricechange changepercent    buy   sell  \
0    sh000001  上证指数  2891.3431     -18.527        -0.637      0      0   
1    sh000002  Ａ股指数  3029.2626     -19.372        -0.635      0      0   
2    sh000003  Ｂ股指数   255.2202      -2.955        -1.145      0      0   
3    sh000004  工业指数  2265.4238     -19.259        -0.843      0      0   
4    sh000005  商业指数  2625.3647     -31.024        -1.168      0      0   
..        ...   ...        ...         ...           ...    ...    ...   
556  sz399994  信息安全   1632.732     -10.892        -0.663  0.000  0.000   
557  sz399995  基建工程   3537.133     -60.242        -1.675  0.000  0.000   
558  sz399996  智能家居   2542.981     -18.931        -0.739  0.000  0.000   
559  sz399997  中证白酒   8291.824     -56.333        -0.675  0.000  0.000   
560  sz399998  中证煤炭   1166.536     -14.255        -1.207  0.000  0.000   
    settlement       open       high        low      volume        amount  \
0    2909.8697  2911.3500  2917.8293  2891.2043   135519463  152576392736   
1    3048.6349  3050.1878  3057.0351  3029.1168   135417123  152529532272   
2     258.1752   258.2375   258.2375   255.2202      102341      46860464   
3    2284.6832  2284.4955  2288.8948  2265.4238    81989859  100573430149   
4    2656.3890  2654.1212  2661.1885  2624.7153     9706663   10959125999   
..         ...        ...        ...        ...         ...           ...   
556   1643.624   1639.190   1660.037   1632.520  2080351534   37408606715   
557   3597.375   3592.926   3593.429   3537.133   713555150    4222607122   
558   2561.912   2554.687   2591.331   2542.960  3722590965   53372657908   
559   8348.157   8348.558   8365.188   8284.100   100483206    7398284729   
560   1180.791   1181.090   1181.739   1165.898   338309880    2216286578   
       code  ticktime  
0    000001  15:02:03  
1    000002  15:02:03  
2    000003  15:02:03  
3    000004  15:02:03  
4    000005  15:02:03  
..      ...       ...  
556  399994  15:01:48  
557  399995  15:01:48  
558  399996  15:01:48  
559  399997  15:01:48  
560  399998  15:01:48 
```

### 历史行情数据

#### 历史行情数据-新浪

接口: stock_zh_index_daily

目标地址: https://finance.sina.com.cn/realcompany/sz399552/nc.shtml(示例)

描述: 股票指数数据是从[新浪财经](http://vip.stock.finance.sina.com.cn/mkt/)获取的数据, 历史数据按日频率更新

限量: 单次返回具体某个指数的所有历史行情数据

输入参数

| 名称   | 类型 | 必选 | 描述              |
| :----- | :--- | :--- | :---------------- |
| symbol | str  | Y    | symbol=”sz399552″ |

输出参数-历史行情数据

| 名称   | 类型  | 默认显示 | 描述                                 |
| :----- | :---- | :------- | :----------------------------------- |
| date   | str   | Y        | 新浪的数据开始时间, 不是证券上市时间 |
| open   | float | Y        | –                                    |
| close  | float | Y        | –                                    |
| high   | float | Y        | –                                    |
| low    | float | Y        | –                                    |
| amount | float | Y        | –                                    |

接口示例

```
import PPshare as PP
stock_zh_index_daily_df = PP.stock_zh_index_daily(symbol="sz399552")
print(stock_zh_index_daily_df)
```

数据示例-历史行情数据

```
                open      high       low     close        volume
date                                                            
2013-06-06  3353.536  3367.362  3325.742  3331.724  6.976691e+08
2013-06-07  3325.795  3338.029  3264.914  3276.253  7.975941e+08
2013-06-13  3227.157  3227.157  3138.502  3170.727  9.214073e+08
2013-06-14  3168.941  3190.161  3157.245  3184.553  7.290986e+08
2013-06-17  3189.969  3196.282  3153.118  3158.014  7.514038e+08
              ...       ...       ...       ...           ...
2019-11-11  7903.771  7903.771  7812.036  7827.082  1.500865e+09
2019-11-12  7826.054  7846.032  7759.229  7804.985  1.387154e+09
2019-11-13  7816.080  7817.346  7759.580  7803.760  1.169749e+09
2019-11-14  7815.102  7826.694  7785.544  7803.063  1.886548e+09
2019-11-15  7813.952  7823.045  7752.760  7752.760  1.514993e+09
```

#### 历史行情数据-腾讯

接口: stock_zh_index_daily_tx

目标地址: http://gu.qq.com/sh000919/zs

描述: 获取股票指数(或者股票)历史行情数据

限量: 单次返回具体某个股票指数(或者股票)的所有历史行情数据

输入参数

| 名称   | 类型 | 必选 | 描述              |
| :----- | :--- | :--- | :---------------- |
| symbol | str  | Y    | symbol=”sh000919″ |

输出参数-历史行情数据

| 名称   | 类型     | 默认显示 | 描述                                 |
| :----- | :------- | :------- | :----------------------------------- |
| date   | datetime | Y        | 腾讯的数据开始时间, 不是证券上市时间 |
| open   | float    | Y        | –                                    |
| close  | float    | Y        | –                                    |
| high   | float    | Y        | –                                    |
| low    | float    | Y        | –                                    |
| amount | float    | Y        | –                                    |

接口示例

```
import PPshare as PP
stock_zh_index_daily_tx_df = PP.stock_zh_index_daily_tx(symbol="sh000919")
print(stock_zh_index_daily_tx_df)
```

数据示例-历史行情数据

```
               open    close     high      low      amount
date                                                      
2005-01-04   993.11   978.14   993.11   976.82   4235500.0
2005-01-05   976.94   981.50   985.52   972.79   3366739.0
2005-01-06   982.37   968.90   982.37   966.52   3137880.0
2005-01-07   968.77   967.72   978.27   963.10   3340480.0
2005-01-10   967.81   977.77   978.15   963.31   2680019.0
             ...      ...      ...      ...         ...
2020-01-21  5057.77  4985.22  5057.77  4983.42  47773440.0
2020-01-22  4964.64  4993.16  5003.42  4916.75  44316915.0
2020-01-23  4952.00  4851.44  4952.00  4823.68  59821336.0
2020-02-03  4414.92  4486.51  4544.62  4414.92  87252491.0
2020-02-04  4472.27  4591.61  4595.76  4472.27  81098211.0
```

#### 历史行情数据-东方财富

接口: stock_zh_index_daily_em

目标地址: http://quote.eastmoney.com/center/hszs.html

描述: 东方财富股票指数数据, 历史数据按日频率更新

限量: 单次返回具体某个指数的所有历史行情数据

输入参数

| 名称   | 类型 | 必选 | 描述              |
| :----- | :--- | :--- | :---------------- |
| symbol | str  | Y    | symbol=”sz399552″ |

输出参数

| 名称   | 类型  | 默认显示 | 描述                                     |
| :----- | :---- | :------- | :--------------------------------------- |
| date   | str   | Y        | 东方财富的数据开始时间, 不是证券上市时间 |
| open   | float | Y        | –                                        |
| close  | float | Y        | –                                        |
| high   | float | Y        | –                                        |
| low    | float | Y        | –                                        |
| volume | float | Y        | –                                        |
| amount | float | Y        | –                                        |

接口示例

```
import PPshare as PP
stock_zh_index_daily_em_df = PP.stock_zh_index_daily_em(symbol="sz399812")
print(stock_zh_index_daily_em_df)
```

数据示例

```
            date      open     close  ...       low      volume        amount
0     2005-01-04    996.03    989.56  ...    986.46    675733.0  4.986503e+08
1     2005-01-05    989.87   1008.59  ...    989.46   1037894.0  9.068431e+08
2     2005-01-06   1008.88   1002.81  ...    999.76    779152.0  5.631133e+08
3     2005-01-07   1002.10   1004.06  ...    999.56    898377.0  7.554397e+08
4     2005-01-10   1002.63   1014.12  ...   1000.90    651187.0  5.609582e+08
          ...       ...       ...  ...       ...         ...           ...
3785  2020-07-31   9925.95  10076.45  ...   9856.84  25572982.0  8.913588e+10
3786  2020-08-03  10171.99  10277.40  ...  10078.86  30955440.0  1.042277e+11
3787  2020-08-04  10261.82  10260.95  ...  10194.95  33366317.0  1.187024e+11
3788  2020-08-05  10183.52  10329.20  ...  10116.86  26614930.0  8.924673e+10
3789  2020-08-06  10337.09  10175.92  ...  10049.05  32541265.0  1.055893e+11
```

## 中国股票指数成份

### 最新成份

接口: index_stock_cons

目标地址: http://vip.stock.finance.sina.com.cn/corp/view/vII_NewestComponent.php?page=1&indexid=399639

描述: 获取指定指数的最新成份股票信息, 注意该接口返回的数据有部分是重复会导致数据缺失, 可以调用 **index_stock_cons_sina** 获取主流指数数据

输入参数

| 名称  | 类型 | 必选 | 描述                                                         |
| :---- | :--- | :--- | :----------------------------------------------------------- |
| index | str  | Y    | index=”000300″, 获取沪深300最新成份股, 指数代码见 **股票指数信息一览表** |

股票指数信息一览表(可以在 PPShare 中通过如下代码获取本表)

```
import PPshare as PP
index_stock_info_df = PP.index_stock_info()
print(index_stock_info_df)
```

| index_code | display_name                   | publish_date |
| :--------- | :----------------------------- | :----------- |
| 000001     | 上证指数                       | 1991/7/15    |
| 000002     | A股指数                        | 1992/2/21    |
| 000003     | B股指数                        | 1992/2/21    |
| 000004     | 工业指数                       | 1993/5/3     |
| 000005     | 商业指数                       | 1993/5/3     |
| 000006     | 地产指数                       | 1993/5/3     |
| 000007     | 公用指数                       | 1993/5/3     |
| 000008     | 综合指数                       | 1993/5/3     |
| 000009     | 上证380                        | 2010/11/29   |
| 000010     | 上证180                        | 2002/7/1     |
| 000011     | 基金指数                       | 2000/6/9     |
| 000012     | 国债指数                       | 2003/1/2     |
| 000013     | 上证企业债指数                 | 2003/6/9     |
| 000015     | 红利指数                       | 2005/1/4     |
| 000016     | 上证50                         | 2004/1/2     |
| 000017     | 新综指                         | 2006/1/4     |
| 000018     | 180金融                        | 2007/12/10   |
| 000019     | 治理指数                       | 2008/1/2     |
| 000020     | 中型综指                       | 2008/5/12    |
| 000021     | 180治理                        | 2008/9/10    |
| 000022     | 上证公司债指数                 | 2008/11/19   |
| 000025     | 180基建                        | 2008/12/15   |
| 000026     | 180资源                        | 2008/12/15   |
| 000027     | 180运输                        | 2008/12/15   |
| 000028     | 180成长                        | 2009/1/9     |
| 000029     | 180价值                        | 2009/1/9     |
| 000030     | 180R成长                       | 2009/1/9     |
| 000031     | 180R价值                       | 2009/1/9     |
| 000032     | 上证能源                       | 2009/1/9     |
| 000033     | 上证材料                       | 2009/1/9     |
| 000034     | 上证工业                       | 2009/1/9     |
| 000035     | 上证可选                       | 2009/1/9     |
| 000036     | 上证消费                       | 2009/1/9     |
| 000037     | 上证医药                       | 2009/1/9     |
| 000038     | 上证金融                       | 2009/1/9     |
| 000039     | 上证信息                       | 2009/1/9     |
| 000040     | 上证电信                       | 2009/1/9     |
| 000041     | 上证公用                       | 2009/1/9     |
| 000042     | 上证央企                       | 2009/3/30    |
| 000043     | 超大盘                         | 2009/4/23    |
| 000044     | 上证中盘                       | 2009/7/3     |
| 000045     | 上证小盘                       | 2009/7/3     |
| 000046     | 上证中小                       | 2009/7/3     |
| 000047     | 上证全指                       | 2009/7/3     |
| 000048     | 责任指数                       | 2009/8/5     |
| 000049     | 上证民企                       | 2009/8/25    |
| 000050     | 50等权                         | 2011/1/4     |
| 000051     | 180等权                        | 2011/5/24    |
| 000052     | 50基本                         | 2012/1/9     |
| 000053     | 180基本                        | 2012/1/9     |
| 000054     | 上证海外                       | 2010/1/4     |
| 000055     | 上证地企                       | 2010/1/4     |
| 000056     | 上证国企                       | 2010/1/4     |
| 000057     | 全指成长                       | 2010/1/4     |
| 000058     | 全指价值                       | 2010/1/4     |
| 000059     | 全R成长                        | 2010/1/4     |
| 000060     | 全R价值                        | 2010/1/4     |
| 000061     | 沪企债30                       | 2010/1/4     |
| 000062     | 上证沪企                       | 2010/1/4     |
| 000063     | 上证周期                       | 2010/2/3     |
| 000064     | 非周期                         | 2010/2/3     |
| 000065     | 上证龙头                       | 2010/2/9     |
| 000066     | 上证商品                       | 2010/4/30    |
| 000067     | 上证新兴                       | 2010/4/30    |
| 000068     | 上证资源                       | 2010/5/28    |
| 000069     | 消费80                         | 2010/5/28    |
| 000070     | 能源等权                       | 2010/8/18    |
| 000071     | 材料等权                       | 2010/8/18    |
| 000072     | 工业等权                       | 2010/8/18    |
| 000073     | 可选等权                       | 2010/8/18    |
| 000074     | 消费等权                       | 2010/8/18    |
| 000075     | 医药等权                       | 2010/8/18    |
| 000076     | 金融等权                       | 2010/8/18    |
| 000077     | 信息等权                       | 2010/8/18    |
| 000078     | 电信等权                       | 2010/8/18    |
| 000079     | 公用等权                       | 2010/8/18    |
| 000090     | 上证流通                       | 2010/12/2    |
| 000091     | 沪财中小                       | 2011/4/6     |
| 000092     | 资源50                         | 2011/5/10    |
| 000093     | 180分层                        | 2011/5/24    |
| 000094     | 上证上游                       | 2011/5/10    |
| 000095     | 上证中游                       | 2011/5/10    |
| 000096     | 上证下游                       | 2011/5/10    |
| 000097     | 高端装备                       | 2011/5/24    |
| 000098     | 上证F200                       | 2011/7/1     |
| 000099     | 上证F300                       | 2011/7/1     |
| 000100     | 上证F500                       | 2011/7/1     |
| 000101     | 5年信用                        | 2013/4/1     |
| 000102     | 沪投资品                       | 2011/6/13    |
| 000103     | 沪消费品                       | 2011/6/13    |
| 000104     | 380能源                        | 2011/6/13    |
| 000105     | 380材料                        | 2011/6/13    |
| 000106     | 380工业                        | 2011/6/13    |
| 000107     | 380可选                        | 2011/6/13    |
| 000108     | 380消费                        | 2011/6/13    |
| 000109     | 380医药                        | 2011/6/13    |
| 000110     | 380金融                        | 2011/6/13    |
| 000111     | 380信息                        | 2011/6/13    |
| 000112     | 380电信                        | 2011/6/13    |
| 000113     | 380公用                        | 2011/6/13    |
| 000114     | 持续产业                       | 2011/8/22    |
| 000115     | 380等权                        | 2011/8/12    |
| 000116     | 信用100                        | 2013/2/26    |
| 000117     | 380成长                        | 2011/10/18   |
| 000118     | 380价值                        | 2011/10/18   |
| 000119     | 380R成长                       | 2011/10/18   |
| 000120     | 380R价值                       | 2011/10/18   |
| 000121     | 医药主题                       | 2011/10/18   |
| 000122     | 农业主题                       | 2011/10/18   |
| 000123     | 180动态                        | 2013/2/8     |
| 000125     | 180稳定                        | 2013/2/8     |
| 000126     | 消费50                         | 2011/12/9    |
| 000128     | 380基本                        | 2012/1/9     |
| 000129     | 180波动                        | 2012/1/9     |
| 000130     | 380波动                        | 2012/1/9     |
| 000131     | 上证高新                       | 2012/2/10    |
| 000132     | 上证100                        | 2012/4/20    |
| 000133     | 上证150                        | 2012/4/20    |
| 000134     | 上证银行                       | 2012/5/29    |
| 000135     | 180高贝                        | 2012/8/6     |
| 000136     | 180低贝                        | 2012/8/6     |
| 000137     | 380高贝                        | 2012/8/6     |
| 000138     | 380低贝                        | 2012/8/6     |
| 000139     | 上证转债                       | 2012/9/12    |
| 000141     | 380动态                        | 2013/2/8     |
| 000142     | 380稳定                        | 2013/2/8     |
| 000145     | 优势资源                       | 2012/5/29    |
| 000146     | 优势制造                       | 2012/5/29    |
| 000147     | 优势消费                       | 2012/5/29    |
| 000148     | 消费领先                       | 2012/5/29    |
| 000149     | 180红利                        | 2012/7/20    |
| 000150     | 380红利                        | 2012/7/20    |
| 000151     | 上国红利                       | 2012/7/20    |
| 000152     | 上央红利                       | 2012/7/20    |
| 000153     | 上民红利                       | 2012/7/20    |
| 000155     | 市值百强                       | 2012/7/20    |
| 000158     | 上证环保                       | 2012/9/25    |
| 000159     | 上证沪股通指数                 | 2014/11/17   |
| 000160     | 上证一带一路主题指数           | 2015/6/24    |
| 000161     | 上证中国制造2025主题指数       | 2015/10/29   |
| 000162     | 上证互联网+主题指数            | 2015/10/29   |
| 000171     | 新兴成指                       | 2017/1/25    |
| 000188     | 中国波指                       | 2016/11/28   |
| 000300     | 沪深300                        | 2005/4/8     |
| 000801     | 资源80                         | 2011/11/8    |
| 000802     | 500沪市                        | 2011/11/8    |
| 000803     | 300波动                        | 2012/1/9     |
| 000804     | 500波动                        | 2012/1/9     |
| 000805     | A股资源                        | 2012/1/6     |
| 000806     | 消费服务                       | 2012/2/10    |
| 000807     | 食品饮料                       | 2012/2/17    |
| 000808     | 医药生物                       | 2012/2/17    |
| 000809     | 细分农业                       | 2012/4/11    |
| 000810     | 细分能源                       | 2012/4/11    |
| 000811     | 细分有色                       | 2012/4/11    |
| 000812     | 细分机械                       | 2012/4/11    |
| 000813     | 细分化工                       | 2012/4/11    |
| 000814     | 细分医药                       | 2012/4/11    |
| 000815     | 细分食品                       | 2012/4/11    |
| 000816     | 细分地产                       | 2012/4/11    |
| 000817     | 兴证海峡                       | 2011/9/27    |
| 000818     | 细分金融                       | 2012/4/11    |
| 000819     | 有色金属                       | 2012/5/9     |
| 000820     | 煤炭指数                       | 2012/5/9     |
| 000821     | 300红利                        | 2012/7/20    |
| 000822     | 500红利                        | 2012/7/20    |
| 000823     | 中证800有色金属指数            | 2012/12/21   |
| 000824     | 国企红利                       | 2012/7/20    |
| 000825     | 央企红利                       | 2012/7/20    |
| 000826     | 民企红利                       | 2012/7/20    |
| 000827     | 中证环保                       | 2012/9/25    |
| 000828     | 300高贝                        | 2012/8/6     |
| 000829     | 300低贝                        | 2012/8/6     |
| 000830     | 500高贝                        | 2012/8/6     |
| 000831     | 500低贝                        | 2012/8/6     |
| 000832     | 中证转债                       | 2012/9/12    |
| 000833     | 中高企债                       | 2012/9/10    |
| 000838     | 创业价值                       | 2012/9/26    |
| 000839     | 浙企综指                       | 2012/11/9    |
| 000840     | 浙江民企                       | 2012/11/9    |
| 000841     | 800医药                        | 2012/12/21   |
| 000842     | 800等权                        | 2012/12/21   |
| 000843     | 300动态                        | 2013/1/7     |
| 000844     | 300稳定                        | 2013/1/7     |
| 000846     | ESG100                         | 2012/10/16   |
| 000847     | 中证腾安价值100指数            | 2013/11/18   |
| 000849     | 沪深300非银行金融指数          | 2012/12/21   |
| 000850     | 沪深300有色金属指数            | 2012/12/21   |
| 000851     | 中证百度百发策略100指数        | 2014/7/30    |
| 000852     | 中证1000指数                   | 2014/10/17   |
| 000853     | 中证申万一带一路主题投资指数   | 2015/4/23    |
| 000854     | 500原料                        | 2013/11/6    |
| 000855     | 央视财经500指数                | 2014/11/3    |
| 000856     | 500工业                        | 2013/11/6    |
| 000857     | 500医药                        | 2013/11/6    |
| 000858     | 500信息                        | 2013/11/6    |
| 000891     | 中国战略新兴产业综合指数       | 2017/1/25    |
| 000901     | 小康指数                       | 2010/4/1     |
| 000902     | 中证流通                       | 2006/2/27    |
| 000903     | 中证100                        | 2006/5/29    |
| 000904     | 中证200                        | 2007/1/15    |
| 000905     | 中证500                        | 2007/1/15    |
| 000906     | 中证800                        | 2007/1/15    |
| 000907     | 中证700                        | 2007/1/15    |
| 000908     | 300能源                        | 2007/7/2     |
| 000909     | 300材料                        | 2007/7/2     |
| 000910     | 300工业                        | 2007/7/2     |
| 000911     | 300可选                        | 2007/7/2     |
| 000912     | 300消费                        | 2007/7/2     |
| 000913     | 300医药                        | 2007/7/2     |
| 000914     | 300金融                        | 2007/7/2     |
| 000915     | 300信息                        | 2007/7/2     |
| 000916     | 300电信                        | 2007/7/2     |
| 000917     | 300公用                        | 2007/7/2     |
| 000918     | 300成长                        | 2008/1/21    |
| 000919     | 300价值                        | 2008/1/21    |
| 000920     | 300R成长                       | 2008/1/21    |
| 000921     | 300R价值                       | 2008/1/21    |
| 000922     | 中证红利                       | 2008/5/26    |
| 000923     | 公司债                         | 2008/11/19   |
| 000925     | 基本面50                       | 2009/2/26    |
| 000926     | 中证央企                       | 2009/3/30    |
| 000927     | 央企100                        | 2009/3/30    |
| 000928     | 中证能源                       | 2009/7/3     |
| 000929     | 中证材料                       | 2009/7/3     |
| 000930     | 中证工业                       | 2009/7/3     |
| 000931     | 中证可选                       | 2009/7/3     |
| 000932     | 中证消费                       | 2009/7/3     |
| 000933     | 中证医药                       | 2009/7/3     |
| 000934     | 中证金融                       | 2009/7/3     |
| 000935     | 中证信息                       | 2009/7/3     |
| 000936     | 中证电信                       | 2009/7/3     |
| 000937     | 中证公用                       | 2009/7/3     |
| 000938     | 中证民企                       | 2009/8/25    |
| 000939     | 民企200                        | 2009/8/25    |
| 000940     | 财富大盘                       | 2009/9/25    |
| 000941     | 新能源                         | 2009/10/28   |
| 000942     | 内地消费                       | 2009/10/28   |
| 000943     | 内地基建                       | 2009/10/28   |
| 000944     | 内地资源                       | 2009/10/28   |
| 000945     | 内地运输                       | 2009/10/28   |
| 000946     | 内地金融                       | 2009/10/28   |
| 000947     | 内地银行                       | 2009/10/28   |
| 000948     | 内地地产                       | 2009/10/28   |
| 000949     | 内地农业                       | 2009/10/28   |
| 000950     | 300基建                        | 2009/10/28   |
| 000951     | 300银行                        | 2009/10/28   |
| 000952     | 300地产                        | 2009/10/28   |
| 000953     | 中证地企                       | 2010/2/9     |
| 000954     | 地企100                        | 2010/2/9     |
| 000955     | 中证国企                       | 2010/2/9     |
| 000956     | 国企200                        | 2010/2/9     |
| 000957     | 300运输                        | 2009/6/16    |
| 000958     | 创业成长                       | 2010/3/24    |
| 000959     | 银河99                         | 2010/2/9     |
| 000960     | 中证龙头                       | 2010/2/9     |
| 000961     | 中证上游                       | 2010/4/16    |
| 000962     | 中证中游                       | 2010/4/16    |
| 000963     | 中证下游                       | 2010/4/16    |
| 000964     | 中证新兴                       | 2010/4/30    |
| 000965     | 基本200                        | 2010/6/2     |
| 000966     | 基本400                        | 2010/6/2     |
| 000967     | 基本600                        | 2010/6/2     |
| 000968     | 300周期                        | 2010/5/28    |
| 000969     | 300非周                        | 2010/5/28    |
| 000970     | ESG40                          | 2010/9/17    |
| 000971     | 等权90                         | 2010/12/2    |
| 000972     | 300沪市                        | 2010/12/2    |
| 000973     | 技术领先                       | 2011/1/4     |
| 000974     | 中证800金融指数                | 2013/5/9     |
| 000975     | 钱江30                         | 2014/1/2     |
| 000976     | 新华金牛                       | 2014/2/18    |
| 000977     | 内地低碳                       | 2011/1/21    |
| 000978     | 医药100                        | 2011/3/18    |
| 000979     | 大宗商品                       | 2011/8/22    |
| 000980     | 中证超大                       | 2011/5/10    |
| 000981     | 300分层                        | 2011/6/13    |
| 000982     | 500等权                        | 2011/6/13    |
| 000983     | 智能资产                       | 2011/6/17    |
| 000984     | 300等权                        | 2011/8/2     |
| 000985     | 中证全指                       | 2011/8/2     |
| 000986     | 全指能源                       | 2011/8/2     |
| 000987     | 全指材料                       | 2011/8/2     |
| 000988     | 全指工业                       | 2011/8/2     |
| 000989     | 全指可选                       | 2011/8/2     |
| 000990     | 全指消费                       | 2011/8/2     |
| 000991     | 全指医药                       | 2011/8/2     |
| 000992     | 全指金融                       | 2011/8/2     |
| 000993     | 全指信息                       | 2011/8/2     |
| 000994     | 全指电信                       | 2011/8/2     |
| 000995     | 全指公用                       | 2011/8/2     |
| 000996     | 领先行业                       | 2011/8/2     |
| 000997     | 大消费                         | 2011/11/11   |
| 000998     | 中证TMT                        | 2011/11/8    |
| 000999     | 中证两岸三地500指数            | 2010/1/18    |
| 399001     | 深证成指                       | 1995/1/23    |
| 399002     | 深成指R                        | 1995/1/23    |
| 399003     | 成份B指                        | 1995/1/23    |
| 399004     | 深证100R                       | 2003/1/2     |
| 399005     | 中小板指                       | 2006/1/24    |
| 399006     | 创业板指                       | 2010/6/1     |
| 399007     | 深证300                        | 2009/11/4    |
| 399008     | 中小300                        | 2010/3/22    |
| 399009     | 深证200                        | 2011/9/1     |
| 399010     | 深证700                        | 2011/9/1     |
| 399011     | 深证1000                       | 2011/9/1     |
| 399012     | 创业300                        | 2013/1/7     |
| 399013     | 深市精选                       | 2014/5/30    |
| 399015     | 深证中小创新指数               | 2015/3/24    |
| 399016     | 深证创新指数                   | 2016/12/1    |
| 399017     | 中小板创新指数                 | 2016/12/1    |
| 399018     | 创业板创新指数                 | 2016/12/1    |
| 399050     | 创新引擎                       | 2018/7/31    |
| 399100     | 新指数                         | 2006/2/16    |
| 399101     | 中小板综                       | 2005/12/1    |
| 399102     | 创业板综合指数                 | 2010/8/20    |
| 399103     | 乐富指数                       | 2011/12/2    |
| 399106     | 深证综指                       | 1991/4/4     |
| 399107     | 深证A指                        | 1992/10/4    |
| 399108     | 深证B指                        | 1992/10/6    |
| 399231     | 农林指数                       | 2013/3/4     |
| 399232     | 采矿指数                       | 2013/3/4     |
| 399233     | 制造指数                       | 2013/3/4     |
| 399234     | 水电指数                       | 2013/3/4     |
| 399235     | 建筑指数                       | 2013/3/4     |
| 399236     | 批零指数                       | 2013/3/4     |
| 399237     | 运输指数                       | 2013/3/4     |
| 399238     | 餐饮指数                       | 2013/3/4     |
| 399239     | IT指数                         | 2013/3/4     |
| 399240     | 金融指数                       | 2013/3/4     |
| 399241     | 地产指数                       | 2013/3/4     |
| 399242     | 商务指数                       | 2013/3/4     |
| 399243     | 科研指数                       | 2013/3/4     |
| 399244     | 公共指数                       | 2013/3/4     |
| 399248     | 文化指数                       | 2013/3/4     |
| 399249     | 综企指数                       | 2013/3/4     |
| 399286     | 区块链50                       | 2019/12/23   |
| 399290     | 深转交债                       | 2019/6/6     |
| 399291     | 创精选88                       | 2019/11/6    |
| 399292     | 民企发展                       | 2019/3/5     |
| 399293     | 创业大盘                       | 2019/4/18    |
| 399294     | 中小创Q                        | 2019/6/6     |
| 399295     | 创业蓝筹                       | 2019/1/23    |
| 399296     | 创成长                         | 2019/1/23    |
| 399298     | 深证中高等级信用债指数         | 2014/9/25    |
| 399299     | 深证中低等级信用债指数         | 2014/9/25    |
| 399300     | 沪深300                        | 2005/4/8     |
| 399301     | 深信用债                       | 2013/1/11    |
| 399302     | 深公司债                       | 2013/1/11    |
| 399303     | 国证2000                       | 2014/3/28    |
| 399305     | 基金指数                       | 2000/7/3     |
| 399306     | 深证ETF                        | 2011/12/2    |
| 399307     | 深证转债                       | 2014/8/27    |
| 399310     | 国证50                         | 2005/9/5     |
| 399311     | 国证1000                       | 2005/2/3     |
| 399312     | 国证300                        | 2005/2/3     |
| 399313     | 巨潮100                        | 2005/2/3     |
| 399314     | 巨潮大盘                       | 2005/2/3     |
| 399315     | 巨潮中盘                       | 2005/2/3     |
| 399316     | 巨潮小盘                       | 2005/2/3     |
| 399317     | 国证A指                        | 2005/2/3     |
| 399318     | 巨潮B股指数                    | 2005/2/3     |
| 399319     | 资源优势                       | 2005/1/4     |
| 399320     | 国证服务                       | 2005/1/4     |
| 399321     | 国证红利                       | 2005/1/4     |
| 399322     | 国证治理                       | 2005/12/12   |
| 399324     | 深证红利                       | 2006/1/24    |
| 399326     | 成长40                         | 2006/1/24    |
| 399328     | 深证治理                       | 2006/1/24    |
| 399330     | 深证100                        | 2006/1/24    |
| 399332     | 深证创新(旧)                   | 2006/2/27    |
| 399333     | 中小板R                        | 2006/12/27   |
| 399335     | 深证央企                       | 2009/8/3     |
| 399337     | 深证民营                       | 2009/8/3     |
| 399339     | 深证科技                       | 2009/8/3     |
| 399341     | 深证责任                       | 2009/8/3     |
| 399344     | 深证300R                       | 2009/11/4    |
| 399346     | 深证成长                       | 2009/11/4    |
| 399348     | 深证价值                       | 2009/11/4    |
| 399350     | 皖江30                         | 2012/12/18   |
| 399351     | 深报指数                       | 2004/9/1     |
| 399352     | 深报综指                       | 2005/2/3     |
| 399353     | 国证物流                       | 2005/3/1     |
| 399354     | 分析师指数                     | 2006/11/25   |
| 399355     | 长三角                         | 2007/7/2     |
| 399356     | 珠三角                         | 2007/7/2     |
| 399357     | 环渤海                         | 2007/7/2     |
| 399358     | 泰达指数                       | 2008/1/2     |
| 399359     | 国证基建                       | 2009/8/3     |
| 399360     | 国证装备                       | 2009/8/3     |
| 399361     | 国证商业                       | 2009/8/3     |
| 399362     | 国证民营                       | 2009/8/3     |
| 399363     | 计算机指                       | 2009/8/3     |
| 399364     | 中金消费                       | 2009/8/3     |
| 399365     | 国证农业                       | 2009/11/4    |
| 399366     | 国证大宗                       | 2009/11/4    |
| 399367     | 巨潮地产                       | 2009/11/4    |
| 399368     | 国证军工                       | 2009/11/4    |
| 399369     | CBN-兴全                       | 2009/11/4    |
| 399370     | 国证成长                       | 2010/1/4     |
| 399371     | 国证价值                       | 2010/1/4     |
| 399372     | 大盘成长                       | 2010/1/4     |
| 399373     | 大盘价值                       | 2010/1/4     |
| 399374     | 中盘成长                       | 2010/1/4     |
| 399375     | 中盘价值                       | 2010/1/4     |
| 399376     | 小盘成长                       | 2010/1/4     |
| 399377     | 小盘价值                       | 2010/1/4     |
| 399378     | 南方低碳                       | 2010/9/20    |
| 399379     | 国证基金                       | 2011/12/2    |
| 399380     | 国证ETF                        | 2011/12/2    |
| 399381     | 1000能源                       | 2011/12/2    |
| 399382     | 1000材料                       | 2011/12/2    |
| 399383     | 1000工业                       | 2011/12/2    |
| 399384     | 1000可选                       | 2011/12/2    |
| 399385     | 1000消费                       | 2011/12/2    |
| 399386     | 1000医药                       | 2011/12/2    |
| 399387     | 1000金融                       | 2011/12/2    |
| 399388     | 1000信息                       | 2011/12/2    |
| 399389     | 国证通信                       | 2011/12/2    |
| 399390     | 1000公用                       | 2011/12/2    |
| 399391     | 投资时钟                       | 2012/3/26    |
| 399392     | 国证新兴                       | 2012/3/28    |
| 399393     | 国证地产                       | 2012/8/20    |
| 399394     | 国证医药                       | 2012/10/29   |
| 399395     | 国证有色                       | 2012/10/29   |
| 399396     | 国证食品                       | 2012/10/29   |
| 399397     | OCT文化                        | 2012/11/9    |
| 399398     | 绩效指数                       | 2012/11/19   |
| 399399     | 中经GDP                        | 2012/11/23   |
| 399400     | 大中盘                         | 2013/3/20    |
| 399401     | 中小盘                         | 2013/3/20    |
| 399402     | 周期100                        | 2013/10/28   |
| 399403     | 防御100                        | 2013/10/28   |
| 399404     | 大盘低波                       | 2013/12/5    |
| 399405     | 大盘高贝                       | 2013/12/5    |
| 399406     | 中盘低波                       | 2013/12/5    |
| 399407     | 中盘高贝                       | 2013/12/5    |
| 399408     | 小盘低波                       | 2013/12/5    |
| 399409     | 小盘高贝                       | 2013/12/5    |
| 399410     | 苏州率先                       | 2013/12/12   |
| 399411     | 红利100                        | 2014/4/10    |
| 399412     | 国证新能                       | 2014/5/16    |
| 399413     | 国证转债                       | 2014/8/27    |
| 399415     | I100                           | 2014/9/12    |
| 399416     | I300                           | 2014/9/12    |
| 399417     | 国证新能源汽车指数             | 2014/9/24    |
| 399418     | 国证国家安全指数               | 2014/11/21   |
| 399419     | 国证高铁指数                   | 2014/12/10   |
| 399420     | 国证保险证券指数               | 2014/12/10   |
| 399423     | 中关村50指数                   | 2015/2/5     |
| 399427     | 国证德高行专利领先指数         | 2015/2/17    |
| 399428     | 国证定向增发指数               | 2015/2/17    |
| 399429     | 新丝路指数                     | 2015/1/8     |
| 399431     | 国证银行行业指数               | 2014/12/30   |
| 399432     | 国证汽车与汽车零配件行业指数   | 2014/12/30   |
| 399433     | 国证交通运输行业指数           | 2014/12/30   |
| 399434     | 国证传媒行业指数               | 2014/12/30   |
| 399435     | 国证农牧渔产品行业指数         | 2014/12/30   |
| 399436     | 国证煤炭行业指数               | 2014/12/30   |
| 399437     | 国证证券行业指数               | 2014/12/30   |
| 399438     | 国证电力公用事业行业指数       | 2014/12/30   |
| 399439     | 国证石油天然气行业指数         | 2014/12/30   |
| 399440     | 国证黑色金属行业指数           | 2014/12/30   |
| 399441     | 国证生物医药指数               | 2015/1/20    |
| 399481     | 企债指数                       | 2003/1/2     |
| 399550     | 央视50                         | 2012/6/6     |
| 399551     | 央视创新                       | 2013/6/6     |
| 399552     | 央视成长                       | 2013/6/6     |
| 399553     | 央视回报                       | 2013/6/6     |
| 399554     | 央视治理                       | 2013/6/6     |
| 399555     | 央视责任                       | 2013/6/6     |
| 399556     | 央视生态                       | 2014/6/6     |
| 399557     | 央视文化                       | 2014/6/6     |
| 399602     | 中小成长                       | 2010/5/24    |
| 399604     | 中小价值                       | 2010/5/24    |
| 399606     | 创业板R                        | 2010/6/1     |
| 399608     | 科技100                        | 2010/10/18   |
| 399610     | TMT50                          | 2010/11/8    |
| 399611     | 中创100R                       | 2011/2/28    |
| 399612     | 中创100                        | 2011/2/28    |
| 399613     | 深证能源                       | 2011/6/15    |
| 399614     | 深证材料                       | 2011/6/15    |
| 399615     | 深证工业                       | 2011/6/15    |
| 399616     | 深证可选                       | 2011/6/15    |
| 399617     | 深证消费                       | 2011/6/15    |
| 399618     | 深证医药                       | 2011/6/15    |
| 399619     | 深证金融                       | 2011/6/15    |
| 399620     | 深证信息                       | 2011/6/15    |
| 399621     | 深证电信                       | 2011/6/15    |
| 399622     | 深证公用                       | 2011/6/15    |
| 399623     | 中小基础                       | 2011/7/25    |
| 399624     | 中创400                        | 2011/8/15    |
| 399625     | 中创500                        | 2011/8/15    |
| 399626     | 中创成长                       | 2011/8/15    |
| 399627     | 中创价值                       | 2011/8/15    |
| 399628     | 700成长                        | 2011/9/1     |
| 399629     | 700价值                        | 2011/9/1     |
| 399630     | 1000成长                       | 2011/9/1     |
| 399631     | 1000价值                       | 2011/9/1     |
| 399632     | 深100EW                        | 2011/10/28   |
| 399633     | 深300EW                        | 2011/10/28   |
| 399634     | 中小板EW                       | 2011/10/28   |
| 399635     | 创业板EW                       | 2011/10/28   |
| 399636     | 深证装备                       | 2011/11/15   |
| 399637     | 深证地产                       | 2011/11/15   |
| 399638     | 深证环保                       | 2011/11/15   |
| 399639     | 深证大宗                       | 2011/11/15   |
| 399640     | 创业基础                       | 2012/1/16    |
| 399641     | 深证新兴                       | 2012/2/1     |
| 399642     | 中小新兴                       | 2012/2/1     |
| 399643     | 创业新兴                       | 2012/2/1     |
| 399644     | 深证时钟                       | 2012/3/26    |
| 399645     | 100低波                        | 2012/6/12    |
| 399646     | 深消费50                       | 2012/8/6     |
| 399647     | 深医药50                       | 2012/8/6     |
| 399648     | 深证GDP                        | 2012/8/8     |
| 399649     | 中小红利                       | 2012/8/20    |
| 399650     | 中小治理                       | 2012/8/20    |
| 399651     | 中小责任                       | 2012/8/20    |
| 399652     | 中创高新                       | 2012/9/17    |
| 399653     | 深证龙头                       | 2012/9/25    |
| 399654     | 深证文化                       | 2012/11/9    |
| 399655     | 深证绩效                       | 2012/11/19   |
| 399656     | 100绩效                        | 2012/11/19   |
| 399657     | 300绩效                        | 2012/11/19   |
| 399658     | 中小绩效                       | 2012/11/19   |
| 399659     | 深成指EW                       | 2012/11/23   |
| 399660     | 中创EW                         | 2012/11/23   |
| 399661     | 深证低波                       | 2012/12/20   |
| 399662     | 深证高贝                       | 2012/12/20   |
| 399663     | 中小低波                       | 2012/12/20   |
| 399664     | 中小高贝                       | 2012/12/20   |
| 399665     | 中创低波                       | 2012/12/20   |
| 399666     | 中创高贝                       | 2012/12/20   |
| 399667     | 创业板G                        | 2013/1/7     |
| 399668     | 创业板V                        | 2013/1/7     |
| 399669     | 深证农业                       | 2013/6/24    |
| 399670     | 深周期50                       | 2013/10/28   |
| 399671     | 深防御50                       | 2013/10/28   |
| 399672     | 深红利50                       | 2014/4/10    |
| 399673     | 创业板50                       | 2014/6/18    |
| 399674     | 深A医药卫生指数                | 2015/6/8     |
| 399675     | 深A软件与互联网指数            | 2015/6/8     |
| 399676     | 深A医药卫生等权指数            | 2015/6/8     |
| 399677     | 深A软件与互联网等权指数        | 2015/6/8     |
| 399678     | 深证次新股指数                 | 2015/6/18    |
| 399679     | 深证200指数                    | 2015/6/18    |
| 399680     | 深成能源行业指数               | 2015/8/31    |
| 399681     | 深成原材料行业指数             | 2015/8/31    |
| 399682     | 深成工业行业指数               | 2015/8/31    |
| 399683     | 深成可选消费行业指数           | 2015/8/31    |
| 399684     | 深成主要消费行业指数           | 2015/8/31    |
| 399685     | 深成医药卫生行业指数           | 2015/8/31    |
| 399686     | 深成金融地产行业指数           | 2015/8/31    |
| 399687     | 深成信息技术行业指数           | 2015/8/31    |
| 399688     | 深成电信业务行业指数           | 2015/8/31    |
| 399689     | 深成公用事业行业指数           | 2015/8/31    |
| 399690     | 深证中小板专利领先指数         | 2016/5/23    |
| 399691     | 深证创业板专利领先指数         | 2016/5/23    |
| 399692     | 创业300低波动率指数            | 2016/12/20   |
| 399693     | 安防产业                       | 2016/6/20    |
| 399694     | 创业高贝                       | 2016/12/20   |
| 399695     | 深证节能环保指数               | 2017/4/28    |
| 399696     | 深证创投                       | 2016/10/21   |
| 399697     | 中关村60                       | 2017/1/10    |
| 399698     | 深证优势成长                   | 2017/6/15    |
| 399699     | 金融科技                       | 2017/6/9     |
| 399701     | 深证F60                        | 2010/5/10    |
| 399702     | 深证F120                       | 2010/5/10    |
| 399703     | 深证F200                       | 2010/5/10    |
| 399704     | 深证上游                       | 2011/10/18   |
| 399705     | 深证中游                       | 2011/10/18   |
| 399706     | 深证下游                       | 2011/10/18   |
| 399707     | 中证申万证券行业指数           | 2015/4/16    |
| 399802     | 500深市                        | 2012/9/5     |
| 399803     | 中证工业4.0指数                | 2015/3/10    |
| 399804     | 中证体育产业指数               | 2015/2/9     |
| 399805     | 中证互联网金融指数             | 2015/2/10    |
| 399806     | 中证环境治理指数               | 2014/7/21    |
| 399807     | 中证高铁产业指数               | 2015/1/20    |
| 399808     | 中证新能源指数                 | 2015/2/10    |
| 399809     | 中证方正富邦保险主题指数       | 2015/2/13    |
| 399810     | 中证申万传媒行业投资指数       | 2015/8/3     |
| 399811     | 中证申万电子行业投资指数       | 2015/8/3     |
| 399812     | 中证养老产业指数               | 2014/6/6     |
| 399813     | 中证国防安全指数               | 2015/1/29    |
| 399814     | 中证大农业指数                 | 2014/7/22    |
| 399817     | 中证阿拉善生态主题100指数      | 2015/10/21   |
| 399901     | 中证南方小康产业指数           | 2010/4/1     |
| 399902     | 中证流通指数                   | 2006/2/27    |
| 399903     | 中证100指数                    | 2006/5/29    |
| 399904     | 中证中盘200指数                | 2007/1/15    |
| 399905     | 中证500                        | 2007/1/15    |
| 399906     | 中证800指数                    | 2007/1/15    |
| 399907     | 中证中小盘700指数              | 2007/1/15    |
| 399908     | 沪深300能源指数                | 2007/7/2     |
| 399909     | 沪深300原材料指数              | 2007/7/2     |
| 399910     | 沪深300工业指数                | 2007/7/2     |
| 399911     | 沪深300可选消费指数            | 2007/7/2     |
| 399912     | 沪深300主要消费指数            | 2007/7/2     |
| 399913     | 沪深300医药卫生指数            | 2007/7/2     |
| 399914     | 沪深300金融地产指数            | 2007/7/2     |
| 399915     | 沪深300信息技术指数            | 2007/7/2     |
| 399916     | 沪深300电信业务指数            | 2007/7/2     |
| 399917     | 沪深300公用事业指数            | 2007/7/2     |
| 399918     | 沪深300成长指数                | 2008/1/21    |
| 399919     | 沪深300价值指数                | 2008/1/21    |
| 399920     | 沪深300相对成长指数            | 2008/1/21    |
| 399922     | 中证红利指数                   | 2008/5/26    |
| 399923     | 公司债                         | 2008/11/19   |
| 399925     | 中证锐联基本面50指数           | 2009/2/26    |
| 399926     | 中证中央企业综合指数           | 2009/3/30    |
| 399927     | 中证中央企业100指数            | 2009/3/30    |
| 399928     | 中证能源指数                   | 2009/7/3     |
| 399929     | 中证原材料指数                 | 2009/7/3     |
| 399930     | 中证工业指数                   | 2009/7/3     |
| 399931     | 中证可选消费指数               | 2009/7/3     |
| 399932     | 中证主要消费指数               | 2009/7/3     |
| 399933     | 中证医药卫生指数               | 2009/7/3     |
| 399934     | 中证金融地产指数               | 2009/7/3     |
| 399935     | 中证信息技术指数               | 2009/7/3     |
| 399936     | 中证电信业务指数               | 2009/7/3     |
| 399937     | 中证公用事业指数               | 2009/7/3     |
| 399938     | 中证民营企业综合指数           | 2009/8/25    |
| 399939     | 中证民营企业200指数            | 2009/8/25    |
| 399940     | 中证财富大盘指数               | 2009/9/25    |
| 399941     | 中证内地新能源主题指数         | 2009/10/28   |
| 399942     | 中证内地消费主题指数           | 2009/10/28   |
| 399943     | 中证内地基建主题指数           | 2009/10/28   |
| 399944     | 中证内地资源主题指数           | 2009/10/28   |
| 399945     | 中证内地运输主题指数           | 2009/10/28   |
| 399946     | 中证内地金融主题指数           | 2009/10/28   |
| 399947     | 中证内地银行主题指数           | 2009/10/28   |
| 399948     | 中证内地地产主题指数           | 2009/10/28   |
| 399949     | 中证内地农业主题指数           | 2009/10/28   |
| 399950     | 沪深300基建主题指数            | 2009/10/28   |
| 399951     | 沪深300银行指数                | 2009/10/28   |
| 399952     | 沪深300地产指数                | 2009/10/28   |
| 399953     | 中证地方国有企业综合指数       | 2010/2/9     |
| 399954     | 中证地方国有企业100指数        | 2010/2/9     |
| 399955     | 中证国有企业综合指数           | 2010/2/9     |
| 399956     | 中证国有企业200指数            | 2010/2/9     |
| 399957     | 沪深300运输指数                | 2009/6/16    |
| 399958     | 中证创业成长指数               | 2010/3/24    |
| 399959     | 军工指数                       | 2011/8/30    |
| 399960     | 中证龙头企业指数               | 2010/2/9     |
| 399961     | 中证上游资源产业指数           | 2010/4/16    |
| 399962     | 中证中游制造产业指数           | 2010/4/16    |
| 399963     | 中证下游消费与服务产业指数     | 2010/4/16    |
| 399964     | 中证新兴产业指数               | 2010/4/30    |
| 399965     | 800地产                        | 2014/4/4     |
| 399966     | 800非银                        | 2014/4/4     |
| 399967     | 中证军工                       | 2013/12/26   |
| 399968     | 沪深300周期行业指数            | 2010/5/28    |
| 399969     | 沪深300非周期行业指数          | 2010/5/28    |
| 399970     | 中证移动互联网指数             | 2014/5/5     |
| 399971     | 中证传媒指数                   | 2014/4/15    |
| 399972     | 300深市                        | 2012/6/21    |
| 399973     | 中证国防指数                   | 2014/4/15    |
| 399974     | 中证国有企业改革指数           | 2014/8/7     |
| 399975     | 中证全指证券公司指数(四级行业) | 2013/7/15    |
| 399976     | 中证新能源汽车指数             | 2014/11/28   |
| 399977     | 中证内地低碳经济主题指数       | 2011/1/21    |
| 399978     | 中证医药100指数                | 2011/3/18    |
| 399979     | 中证大宗商品股票指数           | 2011/8/22    |
| 399980     | 中证超级大盘指数               | 2011/5/10    |
| 399981     | 沪深300行业分层等权重指数      | 2011/6/13    |
| 399982     | 中证500等权重指数              | 2011/6/13    |
| 399983     | 沪深300地产等权重指数          | 2013/11/22   |
| 399984     | 沪深300等权重指数              | 2011/8/2     |
| 399985     | 中证全指指数                   | 2011/8/2     |
| 399986     | 中证银行指数                   | 2013/7/15    |
| 399987     | 中证酒指数                     | 2014/12/10   |
| 399989     | 中证医疗指数                   | 2014/10/31   |
| 399990     | 中证煤炭等权指数               | 2015/1/21    |
| 399991     | 中证一带一路主题指数           | 2015/2/16    |
| 399992     | 中证万得并购重组指数           | 2015/5/8     |
| 399993     | 中证万得生物科技指数           | 2015/5/8     |
| 399994     | 中证信息安全主题指数           | 2015/3/12    |
| 399995     | 中证基建工程指数               | 2015/3/12    |
| 399996     | 中证智能家居指数               | 2014/9/17    |
| 399997     | 中证白酒指数                   | 2015/1/21    |
| 399998     | 中证煤炭指数                   | 2015/2/13    |

输出参数

| 名称     | 类型 | 默认显示 | 描述           |
| :------- | :--- | :------- | :------------- |
| 品种代码 | str  | Y        | 股票代码       |
| 品种名称 | str  | Y        | 股票名称       |
| 纳入日期 | str  | Y        | 成份股纳入日期 |

接口示例

```
import PPshare as PP
index_stock_cons_df = PP.index_stock_cons(index="000300")
print(index_stock_cons_df)
```

数据示例

```
     品种代码  品种名称        纳入日期
0    603501  韦尔股份  2019-12-16
1    600989  宝丰能源  2019-12-16
2    000723  美锦能源  2019-12-16
3    601236  红塔证券  2019-12-16
4    603899  晨光文具  2019-12-16
..      ...   ...         ...
295  000157  中联重科  2005-04-08
296  000069  华侨城A  2005-04-08
297  000063  中兴通讯  2005-04-08
298  000001  深发展A  2005-04-08
299  000002   万科A  2005-04-08
```

### 历史成份

接口: index_stock_hist

目标地址: http://stock.jrj.com.cn/share,sh000300,2015nlscf_2.shtml

描述: 获取指定股票指数的历史成份股票信息

输入参数

| 名称  | 类型 | 必选 | 描述                                   |
| :---- | :--- | :--- | :------------------------------------- |
| index | str  | Y    | index=”sh000300″; 带市场前缀的指数代码 |

```
import PPshare as PP
stock_index_hist_df = PP.index_stock_hist(index="sh000001")
print(stock_index_hist_df)
```

输出参数

| 名称       | 类型 | 默认显示 | 描述     |
| :--------- | :--- | :------- | :------- |
| stock_code | str  | Y        | 股票代码 |
| in_date    | str  | Y        | 进入时间 |
| out_date   | str  | Y        | 退出时间 |

数据示例

```
   stock_code     in_date    out_date
0      000630  2005-04-08  2020-06-15
1      002294  2017-12-11  2020-06-15
2      300070  2014-12-15  2020-06-15
3      002411  2017-06-12  2020-06-15
4      600100  2005-04-08  2020-06-15
..        ...         ...         ...
20     600489  2005-04-08  2005-07-01
21     000562  2005-04-08  2005-07-01
22     600757  2005-04-08  2005-07-01
23     600748  2005-04-08  2005-07-01
24     600271  2005-04-08  2005-07-01
```

## 全球指数数据

接口: index_investing_global

目标地址: https://cn.investing.com/indices/

描述: 获取世界主要国家的各种指数, 由于涉及国家和指数(**1000** + 个指数)具体参见[国家-指数目录](https://cn.investing.com/indices/world-indices?&majorIndices=on&primarySectors=on&additionalIndices=on&otherIndices=on)
具体的调用方式可以参照:

1. 先查询指数所在的国家名称;
2. 复制网页上国家名称(推荐复制), 如 **美国**;
3. 复制所显示的具体指数名称(推荐复制, 如果英文中间有空格, 也需要保留空格), 如 **美元指数**; 也可以调用 **PP.index_investing_global_country_name_url(“美国”)** 获取需要国家的具体指数名称
4. 在安装 [PPShare](https://github.com/jindaxiang/PPshare) 后输入, 如 **PP.index_investing_global(country=”美国”, index_name=”VIX恐慌指数”, period=”每月”, start_date=”2005-01-01”, end_date=”2020-06-05”)**;
5. 稍后就可以获得所需数据.

限量: 单次返回某一个国家的具体某一个指数, 建议用 for 循环获取多个国家的多个指数, 注意不要大量获取, 以免给对方服务器造成压力!

输入参数

| 名称       | 类型 | 必选 | 描述                                                         |
| :--------- | :--- | :--- | :----------------------------------------------------------- |
| country    | str  | Y    | country=”美国”                                               |
| index_name | str  | Y    | index_name=”美元指数”; 可以通过 PP.index_investing_global_country_name_url(“美国”) 获取 |
| period     | str  | Y    | period=”每月”; choice of {“每日”, “每周”, “每月”}            |
| start_date | str  | Y    | start_date=’2000-01-01′                                      |
| end_date   | str  | Y    | end_date=’2019-10-17′                                        |

输出参数

| 名称   | 类型  | 默认显示 | 描述      |
| :----- | :---- | :------- | :-------- |
| 日期   | str   | Y        | 日期-索引 |
| 收盘   | float | Y        | 收盘      |
| 开盘   | float | Y        | 开盘      |
| 高     | float | Y        | 高        |
| 低     | float | Y        | 低        |
| 交易量 | float | Y        | 交易量    |

接口示例

```
import PPshare as PP
index_investing_global_df = PP.index_investing_global(country="美国", index_name="VIX恐慌指数", period="每月", start_date="2005-01-01", end_date="2020-06-05")
print(index_investing_global_df)
```

数据示例

```
               收盘     开盘      高      低  交易量
日期                                         
2020-06-01  24.30  28.90  30.60  23.60  0.0
2020-05-01  27.51  38.17  40.32  25.92  0.0
2020-04-01  34.15  57.38  60.59  30.54  0.0
2020-03-01  53.54  34.86  85.47  24.93  0.0
2020-02-01  40.11  18.64  49.48  13.38  0.0
           ...    ...    ...    ...  ...
2005-05-01  13.29  15.45  17.70  11.65  0.0
2005-04-01  15.31  13.64  18.59  11.20  0.0
2005-03-01  14.02  11.95  14.89  11.66  0.0
2005-02-01  12.08  12.80  13.20  10.90  0.0
2005-01-01  12.82  13.39  14.75  12.29  0.0
```

## 微博指数数据

接口: weibo_index

目标地址: https://data.weibo.com/newindex

描述: 获取指定 **词语** 的微博指数

输入参数

| 名称      | 类型 | 必选 | 描述                                                  |
| :-------- | :--- | :--- | :---------------------------------------------------- |
| word      | str  | Y    | word=”股票”                                           |
| time_type | str  | Y    | time_type=”1hour”; 1hour, 1day, 1month, 3month 选其一 |

输出参数

| 名称  | 类型     | 默认显示 | 描述      |
| :---- | :------- | :------- | :-------- |
| date  | datetime | Y        | 日期-索引 |
| index | float    | Y        | 指数      |

接口示例

```
import PPshare as PP
df_index = PP.weibo_index(word="期货", time_type="3month")
print(df_index)
```

数据示例

```
             期货
index          
20190901  13334
20190902  46214
20190903  49017
20190904  53229
20190905  68506
         ...
20191127  68081
20191128  42348
20191129  62141
20191130  23448
20191201  16169
```

## 百度搜索指数

接口: baidu_search_index

目标地址: http://index.baidu.com/v2/main/index.html

描述: 获取指定 **词语** 的百度搜索指数

输入参数

| 名称       | 类型 | 必选 | 描述                                                        |
| :--------- | :--- | :--- | :---------------------------------------------------------- |
| word       | str  | Y    | word=”股票”                                                 |
| start_date | str  | Y    | start_date=”2010-12-27″                                     |
| end_date   | str  | Y    | end_date=”2019-12-01″                                       |
| cookie     | str  | Y    | cookie=”您在网页端登录百度指数后的 cookie 数据”; 如下图所示 |

如下图中游览器请求头中的蓝色选中部分内容到 cookie 即可

![cookies](http://www.wenjiangs.com/wp-content/uploads/2020/docimg23/mpu4cpsuzy5-48.png)

输出参数

| 名称  | 类型     | 默认显示 | 描述      |
| :---- | :------- | :------- | :-------- |
| date  | datetime | Y        | 日期-索引 |
| index | float    | Y        | 指数      |

接口示例

```
import PPshare as PP
cookie = '此处输入您在网页端登录百度指数后的 cookie 数据'  # 此处请用单引号
baidu_search_index_df = PP.baidu_search_index(word="螺纹钢", start_date='2010-12-27', end_date='2019-12-01', cookie=cookie)
print(baidu_search_index_df)
```

数据示例

```
           index
date            
2010-12-27   294
2011-01-03   494
2011-01-10   527
2011-01-17   462
2011-01-24   411
          ...
2019-10-28   706
2019-11-04   758
2019-11-11   810
2019-11-18   936
2019-11-25   924
```

## 百度资讯指数

接口: baidu_info_index

目标地址: http://index.baidu.com/v2/main/index.html

描述: 获取指定 **词语** 的百度资讯指数

输入参数

| 名称       | 类型              | 必选 | 描述                                                        |
| :--------- | :---------------- | :--- | :---------------------------------------------------------- |
| word       | str               | Y    | word=”股票”                                                 |
| start_date | datetime.datetime | Y    | start_date=”2017-07-03″                                     |
| end_date   | datetime.datetime | Y    | end_date=”2019-12-01″                                       |
| cookie     | str               | Y    | cookie=”您在网页端登录百度指数后的 cookie 数据”; 如下图所示 |

如下图中游览器请求头中的蓝色选中部分内容到 cookie 即可

![cookies](http://www.wenjiangs.com/wp-content/uploads/2020/docimg23/mpu4cpsuzy5-48.png)

输出参数

| 名称  | 类型     | 默认显示 | 描述      |
| :---- | :------- | :------- | :-------- |
| date  | datetime | Y        | 日期-索引 |
| index | float    | Y        | 指数      |

接口示例

```
import PPshare as PP
cookie = '此处输入您在网页端登录百度指数后的 cookie 数据'  # 此处请用单引号
baidu_info_index_df = PP.baidu_info_index(word="螺纹钢", start_date='2017-07-03', end_date='2019-12-01', cookie=cookie)
print(baidu_info_index_df)
```

数据示例

```
            index
date             
2017-07-03  12727
2017-07-10  12670
2017-07-17   8722
2017-07-24   6054
2017-07-31  10763
           ...
2019-10-28  24363
2019-11-04  18594
2019-11-11  38890
2019-11-18  30896
2019-11-25  55445
```

## 百度媒体指数

接口: baidu_media_index

目标地址: http://index.baidu.com/v2/main/index.html

描述: 获取指定 **词语** 的百度媒体指数

输入参数

| 名称       | 类型              | 必选 | 描述                                                        |
| :--------- | :---------------- | :--- | :---------------------------------------------------------- |
| word       | str               | Y    | word=”股票”                                                 |
| start_date | datetime.datetime | Y    | start_date=”2010-12-27″                                     |
| end_date   | datetime.datetime | Y    | end_date=”2019-12-01″                                       |
| cookie     | str               | Y    | cookie=”您在网页端登录百度指数后的 cookie 数据”; 如下图所示 |

如下图中游览器请求头中的蓝色选中部分内容到 cookie 即可

![cookies](http://www.wenjiangs.com/wp-content/uploads/2020/docimg23/mpu4cpsuzy5-48.png)

输出参数

| 名称  | 类型     | 默认显示 | 描述      |
| :---- | :------- | :------- | :-------- |
| date  | datetime | Y        | 日期-索引 |
| index | float    | Y        | 指数      |

接口示例

```
import PPshare as PP
cookie = '此处输入您在网页端登录百度指数后的 cookie 数据'  # 此处请用单引号
baidu_media_index_df = PP.baidu_media_index(word="螺纹钢", start_date='2010-12-27', end_date='2019-12-01', cookie=cookie)
print(baidu_media_index_df)
```

数据示例

```
           index
date            
2010-12-27     0
2011-01-03    13
2011-01-10    30
2011-01-17    33
2011-01-24    27
          ...
2019-10-28     5
2019-11-04     6
2019-11-11     4
2019-11-18     5
2019-11-25     8
```

## 谷歌趋势指数

接口: google_index

目标地址: https://trends.google.com/trends/?geo=US

描述: 获取指定 **词语** 的谷歌趋势指数, **需要通过代理访问**

输入参数

| 名称       | 类型              | 必选 | 描述                                                         |
| :--------- | :---------------- | :--- | :----------------------------------------------------------- |
| word       | str               | Y    | word=”python”                                                |
| start_date | datetime.datetime | Y    | start_date=”2004-01-01″, 如果要获取具体的实时分钟或小时数据, 请输入如 start_date=”2019-12-10T10″ , end_date=”2019-12-10T23″ |
| end_date   | datetime.datetime | Y    | end_date=”2019-12-01″, 如果要获取具体的实时分钟或小时数据, 请输入如 start_date=”2019-12-10T10″ , end_date=”2019-12-10T23″ |
| plot       | Bool              | Y    | plot=True, 则画图                                            |

**start_date=”2019-12-10T10”** 中的 **T10** 表示 10 点, 以 24 小时制计算, 2019年12月10日上午 **10** 点



**end_date=”2019-12-10T23”** 中的 **T10** 表示 23 点, 以 24 小时制计算, 2019年12月10日晚上 **23** 点

**中美时间会有一天左右时差**

输出参数

| 名称  | 类型     | 默认显示 | 描述      |
| :---- | :------- | :------- | :-------- |
| date  | datetime | Y        | 日期-索引 |
| index | float    | Y        | 指数      |

接口示例-长时间

```
import PPshare as PP
google_index_df = PP.google_index(word="python", start_date='2004-01-01', end_date='2019-12-01', plot=True)
print(google_index_df)
```

数据示例-长时间

```
date
2004-01-01     43
2004-02-01     40
2004-03-01     41
2004-04-01     38
2004-05-01     40
             ... 
2019-08-01     87
2019-09-01     98
2019-10-01     99
2019-11-01    100
2019-12-01     60
Name: python, Length: 192, dtype: int32
```

图片示例-长时间

![http://www.wenjiangs.com/wp-content/uploads/2020/docimg23/rh5m4pwuade-49.png](http://www.wenjiangs.com/wp-content/uploads/2020/docimg23/rh5m4pwuade-49.png)

接口示例-短时间

```
import PPshare as PP
index_df = df = PP.google_index(word="AI", start_date="2019-12-10T10", end_date="2019-12-10T23", plot=True)
print(index_df)
```

数据示例-短时间

```
date
2019-12-10 10:00:00    31
2019-12-10 10:08:00    42
2019-12-10 10:16:00    42
2019-12-10 10:24:00    73
2019-12-10 10:32:00    83
                       ..
2019-12-10 22:24:00    12
2019-12-10 22:32:00     0
2019-12-10 22:40:00    12
2019-12-10 22:48:00    12
2019-12-10 22:56:00    62
Name: 人工智能, Length: 98, dtype: int32
```

图片示例-短时间

![http://www.wenjiangs.com/wp-content/uploads/2020/docimg23/qr5q5rcqnsn-50.png](http://www.wenjiangs.com/wp-content/uploads/2020/docimg23/qr5q5rcqnsn-50.png)

## 申万一级行业实时行情

接口: sw_index_spot

目标地址: http://www.swsindex.com/idx0120.aspx?columnid=8832

描述: 获取申万一级行业实时行情数据

输入参数

| 名称 | 类型 | 必选 | 描述 |
| :--- | :--- | :--- | :--- |
| –    | –    | –    | –    |

输出参数

| 名称     | 类型  | 默认显示 | 描述 |
| :------- | :---- | :------- | :--- |
| 指数代码 | str   | Y        |      |
| 指数名称 | str   | Y        |      |
| 昨收盘   | float | Y        |      |
| 今开盘   | float | Y        |      |
| 成交额   | float | Y        |      |
| 最高价   | float | Y        |      |
| 最低价   | float | Y        |      |
| 最新价   | float | Y        |      |
| 成交量   | float | Y        |      |

接口示例

```
import PPshare as PP
sw_index_spot_df = PP.sw_index_spot()
print(sw_index_spot_df)
```

数据示例

```
      指数代码  指数名称       昨收盘       今开盘             成交额       最高价       最低价  \
0   801010  农林牧渔   3272.12   3278.67  10632127513.00   3301.17   3263.88   
1   801020    采掘   2378.17   2378.25   3688421635.00   2378.70   2365.45   
2   801030    化工   2493.00   2492.71  21243935761.00   2505.70   2489.63   
3   801040    钢铁   2027.81   2025.36   2182396591.00   2034.42   2019.31   
4   801050  有色金属   2715.12   2710.45  14929258171.00   2719.40   2708.82   
5   801080    电子   3296.53   3297.50  83835352265.00   3346.92   3293.55   
6   801110  家用电器   7300.79   7310.10   7211608777.00   7371.99   7304.79   
7   801120  食品饮料  14953.12  14989.38  18729948179.00  15286.60  14989.37   
8   801130  纺织服装   1785.56   1783.75   2820139838.00   1799.21   1782.26   
9   801140  轻工制造   2108.66   2109.56   8047875339.00   2127.92   2105.88   
10  801150  医药生物   7722.43   7733.86  25595067955.00   7774.75   7709.18   
11  801160  公用事业   1938.40   1941.14   5974962455.00   1941.26   1930.84   
12  801170  交通运输   2264.88   2269.50   6242927002.00   2283.77   2264.84   
13  801180   房地产   3938.34   3940.38   8647068776.00   3955.22   3934.40   
14  801200  商业贸易   3122.51   3128.76   4137020879.00   3153.07   3128.76   
15  801210  休闲服务   5859.08   5883.74   1647276734.00   5903.78   5853.36   
16  801230    综合   1962.27   1960.96   3119372157.00   1970.41   1954.48   
17  801710  建筑材料   5581.24   5587.85   5438633403.00   5602.77   5564.02   
18  801720  建筑装饰   1985.84   1987.95   5920618857.00   1991.93   1982.52   
19  801730  电气设备   4099.89   4098.35  13939419861.00   4131.52   4090.35   
20  801740  国防军工   1092.14   1092.34   6157230977.00   1097.11   1088.90   
21  801750   计算机   4465.68   4464.80  40529540333.00   4486.20   4429.60   
22  801760    传媒    619.46    618.81  24921253034.00    629.75    617.73   
23  801770    通信   2175.99   2178.60  14877087262.00   2196.10   2168.42   
24  801780    银行   3690.74   3697.36   7989722487.00   3703.54   3677.90   
25  801790  非银金融   1986.05   1988.34  21572483701.00   1991.80   1978.63   
26  801880    汽车   3687.03   3687.86  13890877424.00   3687.86   3660.98   
27  801890  机械设备   1096.74   1096.78  19039342701.00   1103.92   1095.24   
         最新价         成交量  
0    3273.24   762843661  
1    2378.54   675383283  
2    2505.70  2242816595  
3    2033.62   523542522  
4    2717.11  1627640796  
5    3346.92  5865791446  
6    7351.03   537292047  
7   15286.60   579595101  
8    1799.20   418346826  
9    2127.92   970261252  
10   7774.75  1510059102  
11   1941.09  1018563967  
12   2283.77   913935513  
13   3955.22  1205411968  
14   3153.07   628748493  
15   5891.18   140257228  
16   1969.75   269570972  
17   5602.77   548904394  
18   1991.93   819923009  
19   4131.52  1390432678  
20   1097.11   481212023  
21   4486.20  2659642631  
22    629.75  3095214341  
23   2195.80  1092450575  
24   3694.55   971965702  
25   1991.02  1642748437  
26   3676.52  1504640443  
27   1103.92  1881425427  
```

## 申万一级行业成份

接口: sw_index_cons

目标地址: http://www.swsindex.com/idx0210.aspx?swindexcode=801010

描述: 获取申万一级行业成份股数据

输入参数

| 名称       | 类型 | 必选 | 描述                |
| :--------- | :--- | :--- | :------------------ |
| index_code | str  | Y    | index_code=”801010″ |

输出参数

| 名称       | 类型  | 默认显示 | 描述 |
| :--------- | :---- | :------- | :--- |
| stock_code | str   | Y        |      |
| stock_name | str   | Y        |      |
| start_date | float | Y        |      |
| weight     | float | Y        |      |

接口示例

```
import PPshare as PP
sw_index_df = PP.sw_index_cons(index_code="801010")
print(sw_index_df)
```

数据示例

```
   stock_code stock_name          start_date  weight
0      000048        康达尔 2011-10-10 00:00:00  0.4648
1      000505       京粮控股 2018-07-16 00:00:00  0.2636
2      000576       广东甘化 2018-07-16 00:00:00  0.3266
3      000592       平潭发展 2015-11-03 00:00:00  0.7277
4      000702       正虹科技 2008-06-02 00:00:00  0.2174
..        ...        ...                 ...     ...
79     603566        普莱柯 2015-06-24 00:00:00  0.5235
80     603609       禾丰牧业 2014-07-31 00:00:00  0.9313
81     603668       天马科技 2016-12-01 21:19:00  0.2899
82     603718       海利生物 2016-02-05 00:00:00  0.4451
83     603739       蔚蓝生物 2019-01-04 10:00:00  0.1789
```

## 申万一级行业历史行情

接口: sw_index_daily

目标地址: http://www.swsindex.com/idx0200.aspx?columnid=8838&type=Day

描述: 获取申万一级行业历史行情数据

输入参数

| 名称       | 类型 | 必选 | 描述                    |
| :--------- | :--- | :--- | :---------------------- |
| index_code | str  | Y    | index_code=”801010″     |
| start_date | str  | Y    | start_date=”2019-12-01″ |
| end_date   | str  | Y    | end_date=”2019-12-07″   |

输出参数

| 名称       | 类型  | 默认显示 | 描述 |
| :--------- | :---- | :------- | :--- |
| index_code | str   | Y        |      |
| index_name | str   | Y        |      |
| date       | str   | Y        |      |
| open       | float | Y        |      |
| high       | float | Y        |      |
| low        | float | Y        |      |
| close      | float | Y        |      |
| vol        | float | Y        |      |
| amount     | float | Y        |      |
| change_pct | float | Y        |      |

接口示例

```
import PPshare as PP
sw_index_df = PP.sw_index_daily(index_code="801010", start_date="2019-12-01", end_date="2019-12-07")
print(sw_index_df)
```

数据示例

```
  index_code index_name       date     open     high      low    close   vol  \
0     801010       农林牧渔 2019-12-06  3278.67  3301.18  3263.89  3273.24  7.63   
1     801010       农林牧渔 2019-12-05  3278.81  3278.81  3252.86  3272.12  6.93   
2     801010       农林牧渔 2019-12-04  3274.92  3278.03  3227.42  3268.57  7.44   
3     801010       农林牧渔 2019-12-03  3295.98  3315.15  3270.35  3287.12  6.80   
4     801010       农林牧渔 2019-12-02  3280.31  3321.77  3280.31  3297.97  7.33   
   amount change_pct  
0  106.32       0.03  
1   85.40       0.11  
2   93.57      -0.56  
3   91.33      -0.33  
4  105.91       1.37  
```

## 申万一级行业历史行情指标

接口: sw_index_daily_indicator

目标地址: http://www.swsindex.com/idx0200.aspx?columnid=8838&type=Day

描述: 获取申万一级行业历史行情指标数据

输入参数

| 名称       | 类型 | 必选 | 描述                                           |
| :--------- | :--- | :--- | :--------------------------------------------- |
| index_code | str  | Y    | index_code=”801010″                            |
| start_date | str  | Y    | start_date=”2019-12-01″                        |
| end_date   | str  | Y    | end_date=”2019-12-07″                          |
| data_type  | str  | Y    | data_type=”Day”; “Day”: 日报表, “Week”: 周报表 |

输出参数

| 名称                 | 类型  | 默认显示 | 描述 |
| :------------------- | :---- | :------- | :--- |
| index_code           | str   | Y        |      |
| index_name           | str   | Y        |      |
| date                 | str   | Y        |      |
| close                | float | Y        |      |
| volume               | float | Y        |      |
| chg_pct              | float | Y        |      |
| turn_rate            | float | Y        |      |
| pe                   | float | Y        |      |
| pb                   | float | Y        |      |
| vwap                 | float | Y        |      |
| float_mv             | float | Y        |      |
| avg_float_mv         | float | Y        |      |
| dividend_yield_ratio | float | Y        |      |
| turnover_pct         | float | Y        |      |

接口示例-天

```
import PPshare as PP
sw_index_df = PP.sw_index_daily_indicator(index_code="801010", start_date="2019-12-01", end_date="2019-12-07", data_type="Day")
print(sw_index_df)
```

数据示例-天

```
  index_code index_name       date    close volume chg_pct turn_rate     pe  \
0     801010       农林牧渔 2019-12-06  3273.24   7.63    0.03    1.1533  31.62   
1     801010       农林牧渔 2019-12-05  3272.12   6.93    0.11    1.0484  31.62   
2     801010       农林牧渔 2019-12-04  3268.57   7.44   -0.56    1.1242  31.59   
3     801010       农林牧渔 2019-12-03  3287.12   6.80   -0.33    1.0281  31.77   
4     801010       农林牧渔 2019-12-02  3297.97   7.33    1.37    1.1087  31.88   
     pb   vwap  float_mv avg_float_mv dividend_yield_ratio turnover_pct  
0  3.51  12.24  8,360.39        99.53                 1.19         2.64  
1  3.51  12.17  8,357.91        99.50                 1.19         2.05  
2  3.50  12.14  8,354.00        99.45                 1.19         2.68  
3  3.52  12.19  8,373.92        99.69                 1.19         2.68  
4  3.54  12.19  8,389.36        99.87                 1.18         3.16  
```

接口示例-周

```
import PPshare as PP
sw_index_df = PP.sw_index_daily_indicator(index_code="801010", start_date="2019-12-01", end_date="2019-12-07", data_type="Week")
print(sw_index_df)
```

数据示例-周

```
  index_code index_name       date    close volume chg_pct turn_rate     pe  \
0     801010       农林牧渔 2019-12-06  3273.24  36.13    0.61    1.1533  31.62   
1     801010       农林牧渔 2019-11-29  3253.34  36.30   -1.48    1.0256  31.43   
2     801010       农林牧渔 2019-11-22  3302.08  39.75   -1.23    1.1851  31.89   
3     801010       农林牧渔 2019-11-15  3343.26  42.56   -4.95    1.3313  32.27   
4     801010       农林牧渔 2019-11-08  3517.40  58.51   -1.35    1.5961  33.90   
     pb   vwap  float_mv avg_float_mv dividend_yield_ratio turnover_pct  
0  3.51  12.24  8,360.39        99.53                 1.19         2.62  
1  3.49  12.07  8,275.56        98.52                 1.20         2.60  
2  3.54  12.26  8,411.33       100.13                 1.18         2.69  
3  3.58  12.44  8,488.62       101.06                 1.17         3.18  
4  3.76  13.08  8,918.01       106.17                 1.11         4.12  
```

## 商品现货价格指数

接口: spot_goods

目标地址: http://finance.sina.com.cn/futuremarket/spotprice.shtml#titlePos_0

描述: 获取商品现货价格指数

输入参数

| 名称   | 类型 | 必选 | 描述                                                         |
| :----- | :--- | :--- | :----------------------------------------------------------- |
| symbol | str  | Y    | symbol=”波罗的海干散货指数”, 指数目录请参考 **现货指数一览表** |

现货指数一览表

| 名称               | 时间段    |
| :----------------- | :-------- |
| 进口大豆价格指数   | 2000-2016 |
| 波罗的海干散货指数 | 2007-至今 |
| 钢坯价格指数       | 2005-至今 |
| 普氏62%铁矿石指数  | 2011-至今 |

输出参数

| 名称   | 类型  | 默认显示 | 描述 |
| :----- | :---- | :------- | :--- |
| 日期   | str   | Y        |      |
| 指数   | float | Y        |      |
| 涨跌额 | float | Y        |      |
| 涨跌幅 | float | Y        |      |

接口示例-天

```
import PPshare as PP
spot_df = PP.spot_goods(symbol="波罗的海干散货指数")
print(spot_df)
```

数据示例-天

```
              日期       指数     涨跌额      涨跌幅
0     2006-06-23  2808.00   83.00   0.0305
1     2006-06-30  2964.00  156.00   0.0556
2     2006-07-07  2870.00  -94.00  -0.0317
3     2006-07-14  2968.00   98.00   0.0341
4     2006-07-21  3191.00  223.00   0.0751
          ...      ...     ...      ...
2424  2019-12-11  1460.00  -68.00  -4.4500
2425  2019-12-12  1388.00  -72.00  -4.9300
2426  2019-12-13  1355.00  -33.00  -2.3800
2427  2019-12-16  1315.00  -40.00  -2.9500
2428  2019-12-17  1281.00  -34.00  -2.5900
```

## 义乌小商品指数

接口: index_yw

目标地址: http://www.ywindex.com/Home/Product/

描述: 获取义乌小商品指数, 返回所有历史数据

输入参数

| 名称   | 类型 | 必选 | 描述                                                         |
| :----- | :--- | :--- | :----------------------------------------------------------- |
| symbol | str  | Y    | symbol=”周价格指数”, 三选一, “周价格指数”, “月价格指数”, “月景气指数” |

输出参数

| 名称         | 类型  | 默认显示 | 描述 |
| :----------- | :---- | :------- | :--- |
| 期数         | str   | Y        |      |
| 景气指数     | float | Y        |      |
| 规模指数     | float | Y        |      |
| 效益指数     | float | Y        |      |
| 市场信心指数 | float | Y        |      |

接口示例-天

```
import PPshare as PP
index_yw_df = PP.index_yw(symbol="月景气指数")
print(index_yw_df)
```

数据示例

```
      期数     景气指数    规模指数    效益指数    市场信心指数
0   2019-12-01  1166.21  876.42   1714.5   1004.3
1   2019-11-01  1182.63  889.31  1750.16   1006.2
2   2019-10-01  1166.56   904.9  1673.57  1008.44
3   2019-09-01  1146.21  901.67  1608.72  1009.76
4   2019-08-01  1169.04  900.81  1686.27  1009.46
5   2019-07-01  1144.33  888.45  1619.71   1010.1
6   2019-06-01  1146.25  889.61  1620.87  1013.81
7   2019-05-01  1193.03  903.56  1767.35  1004.67
8   2019-04-01  1177.85  885.08  1745.17  1000.88
9   2019-02-01  1145.52  873.83  1649.29  1004.01
10  2019-01-01  1150.15  875.37  1663.42  1003.26
11  2018-12-01  1193.24  870.16  1818.35   998.92
```

## 恐慌指数

接口: index_vix

目标地址: https://datacenter.jin10.com/market

描述: 获取恐慌指数-芝加哥期权交易所 VIX 指数(CBOE Volatility Index)的分钟级别数据

输入参数

| 名称       | 类型 | 必选 | 描述                                                         |
| :--------- | :--- | :--- | :----------------------------------------------------------- |
| start_date | str  | Y    | start_date=”2020-03-20″; 注意开始和结束之间的时间跨度不能太长, 只能获取当前交易日近一个月内的数据 |
| end_date   | str  | Y    | end_date=”2020-03-27″; 只能获取当前交易日近一个月内的数据    |

输出参数

| 名称     | 类型  | 默认显示 | 描述 |
| :------- | :---- | :------- | :--- |
| 日期时间 | str   | Y        |      |
| 开盘价   | float | Y        |      |
| 当前价   | float | Y        |      |
| 涨跌     | float | Y        |      |
| 涨跌幅   | float | Y        |      |

数据解释

VIX全名是芝加哥期权交易所波动率指数（Chicago Board Options Exchange Volatility Index），用以反映S&P 500指数期货的波动程度，测量未来30天市场预期的波动程度，通常用来评估未来风险，因此它被称作“恐慌指数”。VIX指数虽然是反映未来30天的波动程度，却是以年化百分比表示，并且以常态分布的机率出现。 举个例子，假设VIX指数为15，表示未来30天预期的年化波动率为15%，因此可以推断指数期权市场预期未来30天标准普尔500指数向上或向下波动15%/√12 = 4.33% 。也就是，指数期权的定价假设是：标准普尔500指数未来30天的波动率在正负4.33%以内的几率为68%。

数据解读

1. 当VIX指数超过40，表示市场对未来的非理性恐慌，可能于短期内出现反弹。
2. 当VIX指数低于15，表示市场出现非理性繁荣，可能会伴随着卖压杀盘。
3. 即使在1998年的金融风暴时，VIX指数也未曾超过60，VIX指数不一定能准确预测走向，但是多少反映当时市场的气氛。

接口示例

```
import PPshare as PP
index_vix_df = PP.index_vix(start_date="2020-06-11", end_date="2020-06-11")  # 只能获取当前交易日近一个月内的数据
print(index_vix_df)
```

数据示例

```
                    开盘价    当前价    涨跌    涨跌幅
2020-03-20 00:00  76.45  76.68  0.23   0.30
2020-03-20 00:01  76.45  76.79  0.34   0.44
2020-03-20 00:02  76.45  76.95   0.5   0.65
2020-03-20 00:03  76.45  76.89  0.44   0.58
2020-03-20 00:04  76.45  77.24  0.79   1.03
                 ...    ...   ...    ...
2020-03-27 04:10     61  60.99 -0.01  -0.02
2020-03-27 04:11     61  61.11  0.11   0.18
2020-03-27 04:12     61  61.14  0.14   0.23
2020-03-27 04:13     61  61.17  0.17   0.28
2020-03-27 04:14     61     61     0   0.00
```

## 中证指数

接口: stock_zh_index_hist_csindex

目标地址: http://www.csindex.com.cn/zh-CN/indices/index-detail/H30374

描述: 获取中证指数数据, 该接口只返回最近 5 年指数日频率收盘价数据

输入参数

| 名称   | 类型 | 必选 | 描述                      |
| :----- | :--- | :--- | :------------------------ |
| symbol | str  | Y    | symbol=”H30374″; 指数代码 |

输出参数

| 名称   | 类型  | 默认显示 | 描述 |
| :----- | :---- | :------- | :--- |
| 日期   | str   | Y        |      |
| 收盘价 | float | Y        |      |

接口示例

```
import PPshare as PP
stock_zh_index_hist_csindex_df = PP.stock_zh_index_hist_csindex(symbol="H30374")
print(stock_zh_index_hist_csindex_df)
```

数据示例

```
           date    close
0    2015-07-22  3948.79
1    2015-07-23  4031.31
2    2015-07-24  3974.93
3    2015-07-27  3705.04
4    2015-07-28  3645.59
         ...      ...
1290 2020-07-15  4388.49
1291 2020-07-16  4194.77
1292 2020-07-17  4225.59
1293 2020-07-20  4330.10
1294 2020-07-21  4381.20
```