# Generated by Django 3.0.6 on 2020-07-27 20:50

import django.db.models.deletion
import django.utils.timezone
from django.db import migrations, models

import tests.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="Address",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("city", models.TextField()),
                ("street", models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name="InAdmin",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name="InlineAdmin",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.TextField()),
                (
                    "in_admin",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="tests.InAdmin"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="NotInAdmin",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name="Producer",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.TextField()),
                (
                    "address",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="tests.Address",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Product",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.TextField()),
                ("size", models.IntegerField(default=0)),
                ("size_unit", models.TextField()),
                ("onsale", models.BooleanField(null=True)),
                ("image", models.FileField(upload_to="")),
                ("fake", tests.models.FakeField()),
                (
                    "created_time",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                ("only_in_list_view", models.TextField()),
                ("not_in_admin", models.TextField()),
                (
                    "string_choice",
                    models.CharField(choices=[("a", "A"), ("b", "B")], max_length=8),
                ),
                (
                    "number_choice",
                    models.IntegerField(choices=[(1, "A"), (2, "B")], default=1),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Tag",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name="SKU",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.TextField()),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="tests.Product"
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="product",
            name="default_sku",
            field=models.ForeignKey(
                null=True, on_delete=django.db.models.deletion.CASCADE, to="tests.SKU"
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="fk_not_in_admin",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="tests.InAdmin",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="model_not_in_admin",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="tests.NotInAdmin",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="producer",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="tests.Producer"
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="tags",
            field=models.ManyToManyField(to="tests.Tag"),
        ),
        migrations.CreateModel(
            name="Normal",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.TextField()),
                (
                    "in_admin",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="tests.InAdmin"
                    ),
                ),
                (
                    "inline_admin",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="tests.InlineAdmin",
                    ),
                ),
                (
                    "not_in_admin",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="tests.NotInAdmin",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="GenericInlineAdmin",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.TextField()),
                ("object_id", models.PositiveIntegerField()),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.ContentType",
                    ),
                ),
            ],
        ),
    ]
