import csv
import os
from numpy.core.fromnumeric import size
from numpy.core.numeric import outer
import provis

def import_atm_size_info(vw=False):
    """
    Funtion to load dictionaries storing atomic radii, color coding and Van-der-Waals radii by atom name.
    
    Coloring from: https://sciencenotes.org/molecule-atom-colors-cpk-colors/
    
    Parameters:
        vw: bool, optional
            Option to return vanderwaals radius. Default: False.
    
    Returns: 
        dict
            dictionary of atomic radius by atom name
        dict
            dictionary of color by atom name
        dict
            return dictionary of vw rdius by atom name
    """
    

    sizedict = {'H': 0.53, 
                'HE': 0.31, 
                'LI': 1.67, 
                'BE': 1.12, 
                'B': 0.87, 
                'C': 0.67, 
                'N': 0.56, 
                'O': 0.48, 
                'F': 0.42,
                'NE': 0.38,
                'NA': 1.9,
                'MG': 1.45,
                'AL': 1.18,
                'SI': 1.11,
                'P': 0.98,
                'S': 0.88,
                'CL': 0.79,
                'AR': 0.71,
                'K': 2.43,
                'CA': 1.94,
                'SC': 1.84,
                'TI': 1.76,
                'V': 1.71,
                'CR': 1.66,
                'MN': 1.61,
                'FE': 1.56,
                'CO': 1.52,
                'NI': 1.49,
                'CU': 1.45,
                'ZN': 1.42,
                'GA': 1.36,
                'GE': 1.25,
                'AS': 1.14,
                'SE': 1.03,
                'BR': 0.94,
                'KR': 0.88,
                'RB': 2.65,
                'SR': 2.19,
                'Y': 2.12,
                'ZR': 2.06,
                'NB': 1.98,
                'MO': 1.9,
                'TC': 1.83,
                'RU': 1.78,
                'RH': 1.73,
                'PD': 1.69,
                'AG': 1.65,
                'CD': 1.61,
                'IN': 1.56,
                'SN': 1.45,
                'SB': 1.33,
                'TE': 1.23,
                'I': 1.15,
                'XE': 1.08,
                'CS': 2.98,
                'BA': 2.53,
                'LA': 2.26,
                'CE': 2.1,
                'PR': 2.47,
                'ND': 2.06,
                'PM': 2.05,
                'SM': 2.38,
                'EU': 2.31,
                'GD': 2.33,
                'TB': 2.25,
                'DY': 2.28,
                'HO': 2.26,
                'ER': 2.26,
                'TM': 2.22,
                'YB': 2.22,
                'LU': 2.17,
                'HF': 2.08,
                'TA': 2.0,
                'W': 1.93,
                'RE': 1.88,
                'OS': 1.85,
                'IR': 1.8,
                'PT': 1.77,
                'AU': 1.74,
                'HG': 1.71,
                'TL': 1.56,
                'PB': 1.54,
                'BI': 1.43,
                'PO': 1.35,
                'AT': 1.27,
                'RN': 1.2,
                'FR': 0.0,
                'RA': 0.0,
                'AC': 0.0,
                'TH': 0.0,
                'PA': 0.0,
                'U': 0.0,
                'NP': 0.0,
                'PU': 0.0,
                'AM': 0.0,
                'CM': 0.0,
                'BK': 0.0,
                'CF': 0.0,
                'ES': 0.0,
                'FM': 0.0,
                'MD': 0.0,
                'NO': 0.0,
                'LR': 0.0,
                'RF': 0.0,
                'DB': 0.0,
                'SG': 0.0,
                'BH': 0.0,
                'HS': 0.0,
                'MT': 0.0,
                'DS': 0.0,
                'RG': 0.0,
                'CN': 0.0,
                'NH': 0.0,
                'FL': 0.0,
                'MC': 0.0,
                'LV': 0.0,
                'TS': 0.0,
                'OG': 0.0}
    
    
    color = {  'H': '#FFFFFF',
                        'C': '#333333',
                        'O': '#EA2128',
                        'N': '#2233FF',
                        'S': '#FFDC61',
                        'F': '#1FF01F',
                        'CL': '#1FF01F',
                        'BR': '#992200',
                        'I': '#6600BB',
                        'HE': '#00FFFF',
                        'NE': '#00FFFF',
                        'AR': '#00FFFF',
                        'KR': '#00FFFF',
                        'XE': '#00FFFF',
                        'P': '#FF9900',
                        'B': '#FFAA77',
                        'LI': '#7700FF',
                        'NA': '#7700FF',
                        'K': '#7700FF',
                        'RB': '#7700FF',
                        'CS': '#7700FF',
                        'FR': '#7700FF',
                        'BE': '#007700',
                        'MG': '#007700',
                        'CA': '#007700',
                        'SR': '#007700',
                        'BA': '#007700',
                        'RA': '#007700',
                        'BE': '#007700',
                        'TI': '#999999',
                        'FE': '#DD7700'
                    }
    
    if vw:
        vwdict = {'H': 1.2, 
                'HE': 1.4, 
                'LI': 1.82,
                'BE': 1.53, 
                'B': 1.92,
                'C': 1.7,
                'N': 1.55,
                'O': 1.52,
                'F': 1.47,
                'NE': 1.54,
                'NA': 2.27,
                'MG': 1.73,
                'AL': 1.84,
                'SI': 2.1,
                'P': 1.8,
                'S': 1.8,
                'CL': 1.75,
                'AR': 1.88,
                'K': 2.75,
                'CA': 2.31,
                'SC': 2.11,
                'TI': 0.0,
                'V': 0.0,
                'CR': 0.0,
                'MN': 0.0,
                'FE': 0.0,
                'CO': 0.0,
                'NI': 1.63,
                'CU': 1.4,
                'ZN': 1.39,
                'GA': 1.87,
                'GE': 2.11,
                'AS': 1.85,
                'SE': 1.9,
                'BR': 1.85,
                'KR': 2.02,
                'RB': 3.03,
                'SR': 2.49,
                'Y': 0.0,
                'ZR': 0.0,
                'NB': 0.0,
                'MO': 0.0,
                'TC': 0.0,
                'RU': 0.0,
                'RH': 0.0,
                'PD': 1.63,
                'AG': 1.72,
                'CD': 1.58,
                'IN': 1.93,
                'SN': 2.17,
                'SB': 2.06,
                'TE': 2.06,
                'I': 1.98,
                'XE': 2.16,
                'CS': 3.43,
                'BA': 2.68,
                'LA': 0.0,
                'CE': 0.0,
                'PR': 0.0,
                'ND': 0.0,
                'PM': 0.0,
                'SM': 0.0,
                'EU': 0.0,
                'GD': 0.0,
                'TB': 0.0,
                'DY': 0.0,
                'HO': 0.0,
                'ER': 0.0,
                'TM': 0.0,
                'YB': 0.0,
                'LU': 0.0,
                'HF': 0.0,
                'TA': 0.0,
                'W': 0.0,
                'RE': 0.0,
                'OS': 0.0,
                'IR': 0.0,
                'PT': 1.75,
                'AU': 1.66,
                'HG': 1.55,
                'TL': 1.96,
                'PB': 2.02,
                'BI': 2.07,
                'PO': 1.97,
                'AT': 2.02,
                'RN': 2.2,
                'FR': 3.48,
                'RA': 2.83,
                'AC': 0.0,
                'TH': 0.0,
                'PA': 0.0,
                'U': 1.86,
                'NP': 0.0,
                'PU': 0.0,
                'AM': 0.0,
                'CM': 0.0,
                'BK': 0.0,
                'CF': 0.0,
                'ES': 0.0,
                'FM': 0.0,
                'MD': 0.0,
                'NO': 0.0,
                'LR': 0.0,
                'RF': 0.0,
                'DB': 0.0,
                'SG': 0.0,
                'BH': 0.0,
                'HS': 0.0,
                'MT': 0.0,
                'DS': 0.0,
                'RG': 0.0,
                'CN': 0.0,
                'NH': 0.0,
                'FL': 0.0,
                'MC': 0.0,
                'LV': 0.0,
                'TS': 0.0,
                'OG': 0.0}

        return sizedict, color, vwdict
        
    return sizedict, color

  
def import_atm_mass_info():
    """
    Funtion to load dictionary storing atomic mass information by atom type.
    
        dict
            dictionary of atomic mass by atom name
    """
    
    massdict = {'H': 1.00797, 
                'HE': 4.0026,
                'LI': 6.941,
                'BE': 9.01218, 
                'B': 10.81,
                'C': 12.011,
                'N': 14.0067,
                'O': 15.9994,
                'F': 18.998403,
                'NE': 20.179,
                'NA': 22.98977,
                'MG': 24.305,
                'AL': 26.98154,
                'SI': 28.0855,
                'P': 30.97376,
                'S': 32.06,
                'CL': 35.453,
                'K': 39.0983,
                'AR': 39.948,
                'CA': 40.08,
                'SC': 44.9559,
                'TI': 47.9,
                'V': 50.9415,
                'CR': 51.996,
                'MN': 54.938,
                'FE': 55.847,
                'NI': 58.7, 
                'CO': 58.9332, 
                'CU': 63.546,
                'ZN': 65.38,
                'GA': 69.72,
                'GE': 72.59, 
                'AS': 74.9216,
                'SE': 78.96, 
                'BR': 79.904, 
                'KR': 83.8, 
                'RB': 85.4678,
                'SR': 87.62, 
                'Y': 88.9059,
                'ZR': 91.22, 
                'NB': 92.9064, 
                'MO': 95.94, 
                'TC': -98.0, 
                'RU': 101.07,
                'RH': 102.9055,
                'PD': 106.4,
                'AG': 107.868,
                'CD': 112.41,
                'IN': 114.82,
                'SN': 118.69, 
                'SB': 121.75, 
                'I': 126.9045,
                'TE': 127.6,
                'XE': 131.3, 
                'CS': 132.9054,
                'BA': 137.33, 
                'LA': 138.9055,
                'CE': 140.12, 
                'PR': 140.9077,
                'ND': 144.24, 
                'PM': -145.0, 
                'SM': 150.4, 
                'EU': 151.96,
                'GD': 157.25,
                'TB': 158.9254, 
                'DY': 162.5, 
                'HO': 164.9304,
                'ER': 167.26, 
                'TM': 168.9342,
                'YB': 173.04,
                'LU': 174.967,
                'HF': 178.49, 
                'TA': 180.9479,
                'W': 183.85, 
                'RE': 186.207,
                'OS': 190.2, 
                'IR': 192.22, 
                'PT': 195.09, 
                'AU': 196.9665,
                'HG': 200.59,
                'TL': 204.37,
                'PB': 207.2, 
                'BI': 208.9804,
                'PO': -209.0,
                'AT': -210.0, 
                'RN': -222.0, 
                'FR': -223.0, 
                'RA': 226.0254,
                'AC': 227.0278, 
                'PA': 231.0359,
                'TH': 232.0381,
                'NP': 237.0482,
                'U': 238.029,
                'PU': -242.0,
                'AM': -243.0, 
                'BK': -247.0, 
                'CM': -247.0, 
                'NO': -250.0, 
                'CF': -251.0, 
                'ES': -252.0, 
                'HS': -255.0, 
                'MT': -256.0, 
                'FM': -257.0, 
                'MD': -258.0, 
                'LR': -260.0, 
                'RF': -261.0, 
                'BH': -262.0, 
                'DB': -262.0, 
                'SG': -263.0, 
                'UUN': -269.0,
                'UUU': -272.0, 
                'UUB': -277.0, 
                '—': 0.0,
                'UUQ': 0.0}


    return massdict

def import_res_size_info():
    """
    Funtion to load dictionaries storing residue radii and color coding by residue name.
        
    Coloring from: http://acces.ens-lyon.fr/biotic/rastop/help/colour.htm
    
    Parameters:
        dict
            dictionary of radius by residue name
        dict
            dictionary of color by residue name
    """
    # could not find volume information for CYS, HIS, LYS, THR, TYR
    # for above mentioned apporximation by "closest" available

    res_size_dict = { "ALA": 2.80, "ARG": 3.77, "ASN": 3.18, "ASP": 1.51,
            "CYS": 2.87, "GLN": 3.37, "GLU": 1.68, "GLY": 2.51, "HIS": 3.65,
            "ILE": 3.43, "LEU": 3.42, "LYS": 3.77, "MET": 3.44, "PHE": 3.65,
            "PRO": 3.13, "SER": 2.87, "THR": 2.87, "TRP": 3.54, "TYR": 3.65,
            "VAL": 3.24, "HOH":1.375, "HEM": 33.43 } #HEM vol 156536


    res_color_dict = {"ALA": '#13B6E2', "ARG": '#23DEFE', "ASN": '#0EFF57', "ASP": '#822DD2',
            "CYS": '#A22282', "GLN": '#60C7B0', "GLU": '#6913FE', "GLY": '#8E41D0', "HIS": '#7089FC',
            "ILE": '#0CAFF9', "LEU": '#806769', "LYS": '#8B7928', "MET": '#68D139', "PHE": '#8BA695',
            "PRO": '#9FEBA4', "SER": '#BBD7EB', "THR": '#D1A67A', "TRP": '#F93713', "TYR": '#E5613D',
            "VAL": '#128033', "HOH": 'w', "HEM": 'r'}
    
    return res_size_dict, res_color_dict