# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['yara_scanner']
install_requires = \
['plyara>=2.1.1,<3.0.0', 'psutil>=5.6.7,<6.0.0', 'yara-python>=3.11.0,<4.0.0']

entry_points = \
{'console_scripts': ['scan = yara_scanner:main',
                     'ysc = ysc:main',
                     'yss = yss:main']}

setup_kwargs = {
    'name': 'yara-scanner',
    'version': '1.0.17',
    'description': 'A Python wrapper library for libyara and a local server for fully utilizing the CPUs of the system to scan with yara.',
    'long_description': '# Yara Scanner\n\n[![ace-ecosystem](https://circleci.com/gh/ace-ecosystem/yara_scanner.svg?style=svg)](https://circleci.com/gh/ace-ecosystem/yara_scanner)\n\nA wrapper around the [yara-python](https://github.com/VirusTotal/yara-python) project the provides the following capabilities.\n\n- Change tracking of yara files, directories of yara files, or git repositories of yara files.\n- File and data scanning with the ability to filter based on meta data matching.\n- Distributed scanning processes that maximize the use of multi-core systems.\n- Command line interface.\n\n## Python Examples\n\nLoading a single yara file and then scanning data.\n\n```python\nfrom pprint import pprint\nfrom yara_scanner import YaraScanner\n\nscanner = YaraScanner()\n# tells the scanner to start tracking this yara file\nscanner.track_yara_file(\'my_rules.yar\')\nscanner.load_rules()\nif scanner.scan(\'/path/to/scan_target.txt\'):\n   pprint(scanner.scan_results)\n   \n# this returns True if any tracked yara files have changed\nif scanner.check_rules():\n   scanner.load_rules()\n```\n\n## Installation Instructions\n\n```bash\npip install yara-scanner\n```\n\n## Command Line Instructions\n\n   ```\n   usage: scan [-h] [-r] [--from-stdin] [--debug] [-j] [-t] [-y YARA_RULES]\n               [-Y YARA_DIRS] [-G YARA_REPOS] [-c] [-b BLACKLISTED_RULES]\n               [-B BLACKLISTED_RULES_PATH] [-d SIGNATURE_DIR]\n               [PATHS [PATHS ...]]\n\n   Scan the given file with yara using all available rulesets.\n\n   positional arguments:\n     PATHS                 One or more files or directories to scan with yara.\n\n   optional arguments:\n     -h, --help            show this help message and exit\n     -r, --recursive       Recursively scan directories.\n     --from-stdin          Read the list of files to scan from stdin.\n     --debug               Log debug level messages.\n     -j, --dump-json       Dump JSON details of matches. Otherwise just list the\n                           rules that hit.\n     -t, --test            Test each yara file separately against different types\n                           of buffers for performance issues.\n     -y YARA_RULES, --yara-rules YARA_RULES\n                           One yara rule to load. You can specify more than one\n                           of these.\n     -Y YARA_DIRS, --yara-dirs YARA_DIRS\n                           One directory containing yara rules to load. You can\n                           specify more than one of these.\n     -G YARA_REPOS, --yara-repos YARA_REPOS\n                           One directory that is a git repository that contains\n                           yara rules to load. You can specify more than one of\n                           these.\n     -c, --compile-only    Compile the rules and exit.\n     -b BLACKLISTED_RULES, --blacklist BLACKLISTED_RULES\n                           A rule to blacklist (remove from the results.) You can\n                           specify more than one of these options.\n     -B BLACKLISTED_RULES_PATH, --blacklist-path BLACKLISTED_RULES_PATH\n                           Path to a file that contains a list of rules to\n                           blacklist, one per line.\n   ```\n\n## Command Line Examples\n\nscan a single file\n   ```bash\n   scan ms0day.ppsx\n   ```\n\nscan a single file and generate JSON output\n   ```bash\n   scan -j ms0day.ppsx\n   scan -j ms0day.ppsx | json_pp\n   ```  \n\nscan multiple files\n   ```bash\n   scan file1 file2 file3\n   ```\n\nscan all files in a directory and all sub-directories\n   ```bash\n   scan -r dir\n   ```\n\nscan a list of files passed in on standard input\n   ``` bash\n   find dridex -type f | scan --from-stdin\n   ```\n\nscan a single file with a single yara rule\n   ```bash\n   scan -y myrule.yar target_file\n   ```\n\nscan a single file with all rules in a given directory\n  ```bash\n  scan -Y my_rule_dir target_file\n  ```\n\ncheck the syntax of all the rules in a given directory\n   ```bash\n   scan -c -Y my_rule_dir\n   ```\n\n## Blacklisting\n\nThe scan tool also supports "blacklisting" rules. These are specified by using the -b and -B command line options. These allow you to exclude certain rules from the search results rather than making changes to the rules themselves. We use this technique to allow us to use the open source yara repository as-is, rather than trying to maintain a modified branch.\n\n## Rule Output Selection\n\nYou can specify when a rule should (or should not) be displayed. This allows you to prevent some rules from matching against certain kinds of files, or for a rule to be matched against only one specific file.\n\nThe rules are specified as metadata name and value pairs. (example rule syntax)\n\n```yara\nrule html_rule: odd html\n{\nmeta:\n   mime_type = "text/html"\nstrings:\n   ...\ncondition:\n   ...\n}\n```\n\n### Metadata Names and Descriptions\n\n```\nfile_ext   | Matches everything past the first period in the file name.\nfile_name  | Matches the full name of the file (not including the path.)\nfull_path  | Matches against the full path of the file, if one was specified.\nmime_type  | Matches against the output of file -b --mime-type.\n```\n\nThe value of the metadata variable is the string to match. By default the library matches as is, but special modifiers can be used to perform sub string matching and regular expressions. **Special modifiers are added to the beginning of the value (or list of values) and apply to all values in the string.**\n\n### Matching Modifiers\n\n```\n!     | negation    | Negates the match. This can be placed before other modifiers.\nsub:  | sub-search  | Match if this string appears anywhere.\nre:   | regex       | Match if the regular expression is satisfied.\n```\n\nValues can be a comma separated list of values, regardless of the modifiers. Therefor, commas cannot be used in the patterns.\n\n### Rule Selection Examples\n\nOnly match files the end with the .exe extension.\n\n``` \nfile_ext = "exe"\n```\n\nOnly match files that end with .exe, .dll or .ocx extension.\n\n```\nfile_ext = "exe, dll, ocx"\n```\n\nOnly match files that do not end with .exe, .dll or .ocx extension.\n\n```\nfile_ext = "!exe, dll, ocx"\n```\n\nOnly matches files that do not end with .bmp.\n\n```\nfile_ext = "!bmp"\n```\n\nOnly match files identified as PDF despite the file name.\n\n```\nmime_type = "application/pdf"\n```\n\nOnly match files not identified as images.\n\n```\nmime_type = "!sub:image/"\n```\n\nOnly match files that look like an invoice phish.\n\n```\nfile_name = "re:invoice[0-9]+\\\\.doc$"\n```\n\nOnly match files in a subdirectory called /ole.\n\n```\nfull_path = "sub:/ole/"\n```\n\n## Yara Rule Performance Testing\n\nIt\'s often useful to know not only what rules have poor performance, but also what strings inside of those rules are causing the issue. This library has special support for this.\n\n### How Performance Testing Works\n\nEach yara rule is extracted and tested on its own against the following sets of data.\n\n- random data (either a 1MB random sequence of bytes or the contents of a file specified by the `--test-data` option.)\n- repeating byte patterns (1MB of repeating bytes of the same value.)\n\nIn total there are 256 buffers to test against for each test (one random and 255 repeating byte buffers.)\n\nYou can optionally also extract each regular expression from specified rules and test them by themselves against the same buffers. This allows you to determine which string is causing the issue.\n\n## Executing Performance Tests\n\nTesting all rules but not strings.\n\n```bash\nscan -t\n```\n\nTesting all rules and the strings of rules that take longer than 0.1 seconds to scan any buffer.\n\n```bash\nscan -t --test-strings-if --test-strings-threshold 0.1\n```\n\nTest a specific rule and all the strings inside of it.\n\n```bash\nscan -t --test-rule MyYaraRule --test-strings\n```\n\nTest all rules against the file `sample.dat`.\n\n```bash\nscan -t --test-data sample.dat\n```\n\n## CSV Output\n\nThe output of the test can be saved to CSV files using the following options.\n\n`--performance-csv` saves the performance data of entire yara files.\n\n`--failure-csv` saves any rules that fail under performance testing.\n\n`--string-performance-csv` saves the performance data of individual yara strings.\n\n`--string-failure-csv` save any strings that fail under performance testing.\n\nNote that if you do not specify these options the output is sent to standard out.\n\n## Output Format (Performance Data)\n\nPerformance data has the following format.\n\n`buffer_name, file_path, rule_name, total_seconds`\n\n`buffer_name` a description of the buffer that was used by the test, either **random** for random (or file) data, or **chr(*n*)** where *n* is the byte that was used for the buffer.\n\n`file_path` the path to the file that contains the yara rule.\n\n`rule_name` the name of the yara rule.\n\n`total_seconds` the total amount of time it took the yara rule to scan the given buffer.\n\nString performance data is similar but contains two additional fields.\n\n`buffer_name, file_path, rule_name, string_name, result_count, total_seconds`\n\n`string_name` is the name of the string inside the yara rule.\n\n`result_count` is the total number of times the string matched inside the buffer.\n\n## Output Format (Error Data)\n\nError data has a format that is similar to the performance data but inside of **total_seconds** you will see the error message that occurred when the given yara rule or string was used to scan the given buffer.\n\n## Error 30\n\nIf you see "Error 30" is means your rule, or strings inside of a rule, matched too many times.',
    'author': 'John Davison',
    'author_email': 'unixfreak0037@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ace-ecosystem/yara_scanner',
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
