# This file was autogenerated from vk-api json schema

from typing import List, Union, Optional, Literal, overload
from easy_vk.types import objects
from easy_vk.types import responses
from easy_vk.api_category import BaseCategory


class Storage(BaseCategory):
    def __init__(self, session, access_token: str, v: str, last_call_timer, delay: float, auto_retry: bool, max_retries: int, timeout: float):
        super().__init__(session, access_token, v, last_call_timer, delay, auto_retry, max_retries, timeout)

    @overload
    def get(self, key: Optional[str] = None, keys: None = None, user_id: Optional[int] = None) -> responses.StorageGetV5110: ...
    @overload
    def get(self, keys: List[str], key: Optional[str] = None, user_id: Optional[int] = None) -> responses.StorageGetWithKeys: ...
    def get(self, key: Optional[str] = None, keys: Optional[List[str]] = None, user_id: Optional[int] = None):
        """
        Returns a value of variable with the name set by key parameter.
        
        :param key:
        :param keys:
        :param user_id:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'storage.get'
        if not keys:
            response_type = responses.StorageGetV5110
        if keys:
            response_type = responses.StorageGetWithKeys
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_keys(self, user_id: Optional[int] = None, offset: Optional[int] = None, count: Optional[int] = None) -> responses.StorageGetKeys:
        """
        Returns the names of all variables.
        
        :param user_id: user id, whose variables names are returned if they were requested with a server method.
        :param offset:
        :param count: amount of variable names the info needs to be collected from.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'storage.getKeys'
        response_type = responses.StorageGetKeys
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def set_(self, key: str, value: Optional[str] = None, user_id: Optional[int] = None) -> responses.BaseOk:
        """
        Saves a value of variable with the name set by 'key' parameter.
        
        :param key:
        :param value:
        :param user_id:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'storage.set'
        response_type = responses.BaseOk
        return self._call(method_name, method_parameters, param_aliases, response_type)
