# This file was autogenerated from vk-api json schema

from typing import List, Union, Optional, Literal, overload
from easy_vk.types import objects
from easy_vk.types import responses
from easy_vk.api_category import BaseCategory


class Orders(BaseCategory):
    def __init__(self, session, access_token: str, v: str, last_call_timer, delay: float, auto_retry: bool, max_retries: int, timeout: float):
        super().__init__(session, access_token, v, last_call_timer, delay, auto_retry, max_retries, timeout)

    def cancel_subscription(self, user_id: int, subscription_id: int, pending_cancel: Optional[bool] = None) -> responses.OrdersCancelSubscription:
        """
        :param user_id:
        :param subscription_id:
        :param pending_cancel:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'orders.cancelSubscription'
        response_type = responses.OrdersCancelSubscription
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def change_state(self, order_id: int, action: str, app_order_id: Optional[int] = None, test_mode: Optional[bool] = None) -> responses.OrdersChangeState:
        """
        Changes order status.
        
        :param order_id: order ID.
        :param action: action to be done with the order. Available actions: *cancel — to cancel unconfirmed order. *charge — to confirm unconfirmed order. Applies only if processing of [vk.com/dev/payments_status|order_change_state] notification failed. *refund — to cancel confirmed order.
        :param app_order_id: internal ID of the order in the application.
        :param test_mode: if this parameter is set to 1, this method returns a list of test mode orders. By default — 0.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'orders.changeState'
        response_type = responses.OrdersChangeState
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get(self, offset: Optional[int] = None, count: Optional[int] = None, test_mode: Optional[bool] = None) -> responses.OrdersGet:
        """
        Returns a list of orders.
        
        :param offset:
        :param count: number of returned orders.
        :param test_mode: if this parameter is set to 1, this method returns a list of test mode orders. By default — 0.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'orders.get'
        response_type = responses.OrdersGet
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_amount(self, user_id: int, votes: List[str]) -> responses.OrdersGetAmount:
        """
        :param user_id:
        :param votes:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'orders.getAmount'
        response_type = responses.OrdersGetAmount
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_by_id(self, order_id: Optional[int] = None, order_ids: Optional[List[int]] = None, test_mode: Optional[bool] = None) -> responses.OrdersGetById:
        """
        Returns information about orders by their IDs.
        
        :param order_id: order ID.
        :param order_ids: order IDs (when information about several orders is requested).
        :param test_mode: if this parameter is set to 1, this method returns a list of test mode orders. By default — 0.
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'orders.getById'
        response_type = responses.OrdersGetById
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_user_subscription_by_id(self, user_id: int, subscription_id: int) -> responses.OrdersGetUserSubscriptionById:
        """
        :param user_id:
        :param subscription_id:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'orders.getUserSubscriptionById'
        response_type = responses.OrdersGetUserSubscriptionById
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def get_user_subscriptions(self, user_id: int) -> responses.OrdersGetUserSubscriptions:
        """
        :param user_id:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'orders.getUserSubscriptions'
        response_type = responses.OrdersGetUserSubscriptions
        return self._call(method_name, method_parameters, param_aliases, response_type)

    def update_subscription(self, user_id: int, subscription_id: int, price: int) -> responses.OrdersUpdateSubscription:
        """
        :param user_id:
        :param subscription_id:
        :param price:
        """
    
        method_parameters = {k: v for k, v in locals().items() if k not in {'self', 'raw_response'}}
        param_aliases = []
        method_name = 'orders.updateSubscription'
        response_type = responses.OrdersUpdateSubscription
        return self._call(method_name, method_parameters, param_aliases, response_type)
